// Sample DVM<>Remote Process - CLIENT side
//
// This client provides three very simple functions.
//		0 = Convery a string to all lower case
//		2 = Convery a string to all upper case
//		3 = Convery a string, toggeling lower/upper case
// Yes: These could easily be done with local functions, but the purpose
// of this demo is to show how DVM<>Remote Process communication works.
//
//	Compile with LCCWIN32: LC -e5 -nw RPCLIENT.C -s
//
// Dave Dunfield   -   https://dunfield.themindfactory.com
#include <stdio.h>

int  _read(int, void *, unsigned int);
int  _write(int, const void *, unsigned int);
int  _close(int);

int
	Hr,					// Handle to Read
	Hw;					// Handle to Write
unsigned char
	Emsg[128];			// Additional text for Erroe messages

struct MESSAGE {
	unsigned char	Mcode;
	unsigned char	Mtext[128];
}	Message;

// Report an error and terminate
void Error(unsigned char *p)
{
	fputs("RPCLIENT: ", stdout);
	fputs(p, stdout);
	if(*Emsg)
		fputs(Emsg, stdout);
	putc('\n', stdout);
	exit(-1);
}

// Read a message from DVM
unsigned short DVMread(void *buf, unsigned short siz)
{
	unsigned i;
	unsigned short s;
	unsigned char x;

	i = _read(Hr, &s, sizeof(s));
	if(i != sizeof(s)) {
		sprintf(Emsg, " %u", i);
		Error("?DVMread size"); }
	if(s >= siz) 
		exit(0);
	i = _read(Hr, buf, s);
	if(i != s) {
		sprintf(Emsg, " %u %u", i, s);
		Error("?DVMead body"); }
	return s;
}

// Write a message to DVM
void DVMwrite(void *buf, unsigned short siz)
{
	_write(Hw, &siz, sizeof(siz));
	_write(Hw, buf, siz);
}

// Get a Numeric value from a text strinc
unsigned Num(unsigned char *p)
{
	unsigned v, c;
	v = 0;
	for(;;) {
		c = *p++ - '0';
		if(c >= 10)
			break;
		v = (v * 10) + c; }
	return v;
}

// Main client program
main(int argc, char *argv[])
{
	unsigned short i, s;
	unsigned char *p, c, co;

	if(argc != 3)
		Error("No IO handle args\n");
	if(!(Hr = Num(argv[1])))
		Error("Bad Read Handle\n");
	if(!(Hw = Num(argv[2])))
		Error("Bad Write Handle\n");

	for(;;) {
		s = DVMread(&Message, sizeof(Message));
		switch(co = Message.Mcode) {
		default	:
			sprintf(Emsg," %y", co);
			Error("?DVMcode ");
		case 0	:		// lower
		case 1	:		// upper
		case 2	: ; }	// toggle
		p = &Message.Mtext;
		i = 0;
		while(c = *p) {
			if(co & 1) {
				if((c >= 'a') && (c <= 'z'))
					c -= ('a'-'A'); }
			else {
				if((c >= 'A') && (c <= 'Z'))
					c += ('a'-'A'); }
			*p++ = c;
			if(co & 2)
				co ^= 1; }
		DVMwrite(&Message, s); }
}
