// Sample DVM<>Remote Process - DVM side
//
// The client provides three very simple functions.
//		0 = Convery a string to all lower case
//		2 = Convery a string to all upper case
//		3 = Convery a string, toggeling lower/upper case
// Yes: These could easily be done with local functions, but the purpose
// of this demo is to show how DVM<>Remote Process communication works.
//
//	Compile with Micro-C/DVM:	DVM CC RPTEST
//
// Dave Dunfield   -   https://dunfield.themindfactory.com
#include <stdio.h>

struct MESSAGE {	// DVM<>RProc Message structure
	unsigned char	Mcode;
	unsigned char	Mtext[128];
}	Message;

unsigned
	Rpn;	// RPproc Number

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
	exit(-1);
}

// Perform an RProc transaction
void RPtran(unsigned char f, unsigned char *t)
{
	unsigned l;

	Message.Mcode = f;
	strcpy(Message.Mtext, t);
	l = 0; while(t[l++]);						// Get Length
	RPwrite(Rpn, Message, l+1);	
	memset(Message, 0, sizeof(Message));
	l = RPread(Rpn, Message, sizeof(Message));	// Insure we don't see sent msg
	printf("%u'%s'%u\n", Message.Mcode, Message.Mtext, l);
}

main()
{
	Rpn = RPstart("RPCLIENT.EXE", sizeof(Message));
	if(!Rpn)
		error("?RPStart\n");

	RPtran(0, "Zero One Two Three");		// tolower
	RPtran(1, "One  Four Five Six");		// toupper
	RPtran(2, "Two  Seven Eight Nine");		// toggle

	RPend(Rpn);
}
