/*
 * DECTXT
 *
 *	Encode text/source for online posting so it won't be reformatted!
 *	Decoder
 *
 * Dave Dunfield   -   https://dunfield.themindfactory.com
 */
#include <stdio.h>
#if 0	// These includes may be needed by some compilers
	#include <stdlib.h>
	#include <string.h>
#endif

#define	MINC	3

unsigned short
	Gi,				// Global Int (used in various shared places)
	Stop;			// Top of storage segment
FILE
	*fp;
unsigned char
	*Ptr,			// General global pointer
	Ein[256],		// Encode Input table
	Sfile[128],		// Source file
	Dfile[128];		// Destination file

#ifdef _MICROC_
	// MC is 16-bit, storage segment is "external"
	unsigned Seg;
	#define	Get(a)		peek(Seg,a)
	#define	Put(a,c)	poke(Seg,a,c)
#else
	// for 32 bit compilers, just use a 64k array
	unsigned char Seg[65536];
	#define	Get(a)		Seg[a]
	#define	Put(a,c)	Seg[a]=c
#endif

unsigned char DEChelp[] = {
	68,69,67,111,100,101,32,84,101,88,84,10,10,117,115,101,58,132,68,69,67,
	84,88,84,130,102,114,111,109,45,102,105,108,101,32,116,111,45,102,105,
	108,101,10,10,68,101,99,111,100,101,115,32,97,32,102,105,108,101,32,
	102,114,111,109,32,97,110,32,34,101,110,99,111,100,101,100,34,32,65,
	83,67,73,73,32,116,101,120,116,32,98,108,111,99,107,46,10,85,115,101,
	32,116,111,32,101,97,115,105,108,121,32,112,111,115,116,32,102,111,
	114,109,97,116,116,101,100,32,116,101,120,116,32,105,110,32,102,111,
	114,117,109,115,32,119,104,105,99,104,32,99,104,97,110,103,101,32,
	102,111,114,109,97,116,116,105,110,103,10,111,102,32,112,111,115,116,
	101,100,32,116,101,120,116,32,40,101,103,58,32,71,111,111,103,108,
	101,67,114,111,117,112,115,41,46,10,10,65,83,67,73,73,32,98,108,111,
	99,107,32,105,115,32,100,101,99,111,100,101,100,32,116,111,32,97,32,
	102,105,108,101,32,104,97,118,105,110,103,32,116,104,101,32,111,114,
	105,103,105,110,97,108,32,116,101,120,116,32,102,111,114,109,97,116,
	46,10,10,68,97,118,101,32,68,117,110,102,105,101,108,100,131,45,131,
	104,116,116,112,115,58,47,47,100,117,110,102,105,101,108,100,46,116,
	104,101,109,105,110,100,102,97,99,116,111,114,121,46,99,111,109,10,
	0 };

// Minimal general purpose print/error
void Message(unsigned char *p, unsigned a)
{
	unsigned i, j, v, b;
	unsigned char c, d, buf[8];
	if((d = *p) == 0xFF)
		++p;
	while(c = *p++)	switch(c & 0xF0) {
		default	:						// Nothing special
			putc(c, stdout);
			continue;
		case 0x80:	v = a;	goto o10;	// Decimal Passed
		case 0x90:	v = Gi;				// "" Gi
o10:		b = 10;
on:			i = sizeof(buf);
			j = -(c & 7);
			buf[--i] = 0;
			do {
				if((c = v % b) > 9)
					c += ('A'-('0'+10));
				buf[--i] = c + '0';
				++j; }
			while(v /= b);
			while(j++ & 0x80) 	// Set minimal width
				buf[--i] = '0';
			fputs(buf+i, stdout);
			continue;
		case 0xA0:	v = a;	goto o16;		// Hex Passed
		case 0xB0:	v = Gi;					// "" Gi
o16:		b = 16;	goto on;
		case 0xC0:							// String Ptr
			fputs(Ptr, stdout); }
	if(d == 0xFF)
		exit(0);
}

// Set input Encoding table emtries
void SetIn(unsigned short n, unsigned short c)
{
	while(n) {
		Ein[c++] = ++Gi;
		--n; }
}

int main(int argc, char *argv[])
{
	unsigned c;
	unsigned short i, a, s;
	unsigned char c1;

#ifdef _MICROC_
	Seg = alloc_seg(4096);
#endif
	// Process command line
	i = 0;
	while(++i < argc) {
		Ptr = argv[i];
		if(!*Sfile) {
			strcpy(Sfile, Ptr);
			continue; }
		if(*Dfile)
			goto he;
		strcpy(Dfile, Ptr); }
	if(!*Dfile) {		// Output help text
he:		Ptr = DEChelp;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		goto ex; }

	SetIn(1, ':');		// Set
	SetIn(26, 'A');		// the
	SetIn(26, 'a');		// 64-code
	SetIn(10, '0');		// character
	SetIn(1, ';');		// set

	// read and decode input file
	if(!(fp = fopen(Ptr = Sfile, "r")))
		Message("\xFF?FailedOpen: \xC0\n", 0);
	Message("Reading: \xC0", 0);
	s = 0;
	while((c = getc(fp)) != EOF) {
		if(!(c = Ein[c]))
			continue;
		--c;
		switch(s) {	// Decode state?
		case 0	:	// Start of entry
			c1 = c;
			s = ((c & 0x3C) == 0x3C) ? 1 : 2;	// Compressed?
			continue;
		case 1:		// "Regular" character
			c1 &= 3;							// get next 6 bits
			Put(Stop++, (c1 << 6) | c);			// Write 8 bit character
s0:			s = 0;								// Back to "Start" state 
			continue;
		case 2:		// Conpressed
			i = ((c1 << 2) | (c >> 4)) + MINC;	// Size
			a = ((unsigned)c) << 12;			// Inital 4 bits of address
si:			++s;								// Advance state
			continue;
		case 3:		// "" - next 6 bits of address
			a |= (c << 6);
			goto si;
		case 4	:	// "" - finish address & copy string
			a |= c;
			while(i) {
				Put(Stop++, Get(a++));
				--i; }
			goto s0; }
		goto ex; }
	Message(" Size=\x80\n", Stop);
	fclose(fp);

	if(!(fp = fopen(Ptr = Dfile, "w")))
		Message("\xFF?FailedOpen: \xC0\n", 0);
	Message("Writing: \xC0\n", 0);
	i = 0;
	while(i < Stop)
		putc(Get(i++), fp);
	fclose(fp);

ex:	return 0;
}
