/*
 * ENCTXT
 *
 *	Encode text/source for online posting so it won't be reformatted!
 *	Encoder
 *
 * Dave Dunfield   -   https://dunfield.themindfactory.com
 */
#include <stdio.h>
#if 0	// These includes may be needed by some compilers
	#include <stdlib.h>
	#include <string.h>
#endif

#define	MINC	3
#define	MAXC	230

unsigned short
	Gi,			// Global Int (used in various shared places)
	OutP,		// Output position
	Stop,		// Top of storage segment
	Width = 70;	// Output width
FILE
	*fp;
unsigned char
	*Ptr,		// General global pointer
	EOut[64],	// Encode Output table
	Sfile[128],	// Source file
	Dfile[129];	// Destination file

#ifdef _MICROC_
	// MC is 16-bit, storage segment is "external"
	unsigned			Seg;
	#define	Get(a)		peek(Seg,a)
	#define	Put(a,c)	poke(Seg,a,c)
#else
	// for 32 bit compilers, just use a 64k array
	unsigned char		Seg[65536];
	#define	Get(a)		Seg[a]
	#define	Put(a,c)	Seg[a]=c
#endif

unsigned char ENChelp[] = {
	69,78,67,111,100,101,32,84,101,88,84,10,10,117,115,101,58,132,69,78,67,
	84,88,84,130,102,114,111,109,45,102,105,108,101,32,116,111,45,102,105,
	108,101,32,91,111,112,116,105,111,110,115,93,10,10,111,112,116,115,
	58,131,45,87,118,97,108,117,101,137,115,101,116,32,87,105,100,116,
	104,32,111,102,32,111,117,116,112,117,116,153,91,55,48,93,10,10,69,
	110,99,111,100,101,115,32,97,32,102,105,108,101,32,105,110,116,111,
	32,65,83,67,73,73,32,116,101,120,116,32,98,108,111,99,107,46,10,85,
	115,101,32,116,111,32,101,97,115,105,108,121,32,112,111,115,116,32,
	102,111,114,109,97,116,116,101,100,32,116,101,120,116,32,105,110,32,
	102,111,114,117,109,115,32,119,104,105,99,104,32,99,104,97,110,103,
	101,32,102,111,114,109,97,116,116,105,110,103,32,111,102,10,112,111,
	115,116,101,100,32,116,101,120,116,32,40,101,103,58,32,71,111,111,
	103,108,101,67,114,111,117,112,115,41,46,10,10,65,83,67,73,73,32,98,
	108,111,99,107,32,105,115,32,101,110,99,111,100,101,100,32,105,110,
	116,111,32,97,32,116,101,120,116,32,98,108,111,99,107,32,119,105,116,
	104,32,110,111,32,102,111,114,109,97,116,116,105,110,103,46,10,84,
	111,32,107,101,101,112,32,105,116,32,97,108,108,32,112,114,105,110,
	116,97,98,108,101,44,32,50,32,99,104,97,114,97,99,116,101,114,115,
	32,97,114,101,32,111,117,116,112,117,116,32,102,111,114,32,101,97,
	99,104,32,99,104,97,114,97,99,116,101,114,32,105,110,10,116,104,101,
	32,111,114,105,103,105,110,97,108,32,102,105,108,101,32,119,104,105,
	99,104,32,119,111,117,108,100,32,109,97,107,101,32,105,116,32,50,32,
	116,105,109,101,115,32,116,104,101,32,115,105,122,101,44,32,104,111,
	119,101,118,101,114,32,97,32,118,101,114,121,10,115,105,109,112,108,
	101,32,99,111,109,112,114,101,115,115,105,111,110,32,105,115,32,112,
	101,114,102,111,114,109,101,100,32,119,104,105,99,104,32,111,102,116,
	101,110,32,109,97,107,101,115,32,116,104,101,32,111,117,116,112,117,
	116,32,99,108,111,115,101,32,116,111,32,116,104,101,10,111,114,105,
	103,105,110,97,108,32,102,105,108,101,32,115,105,122,101,46,10,10,
	68,97,118,101,32,68,117,110,102,105,101,108,100,131,45,131,104,116,
	116,112,115,58,47,47,100,117,110,102,105,101,108,100,46,116,104,101,
	109,105,110,100,102,97,99,116,111,114,121,46,99,111,109,10,0 };

// Minimal general purpose print/error
void Message(unsigned char *p, unsigned a)
{
	unsigned i, j, v, b;
	unsigned char c, d, buf[8];
	if((d = *p) == 0xFF)	// Leading \xFF means terminate
		++p;
	while(c = *p++)	switch(c & 0xF0) {
		default	:						// Nothing special
			putc(c, stdout);
			continue;
		case 0x80:	v = a;	goto o10;	// Decimal Passed
		case 0x90:	v = Gi;				// "" Gi
o10:		b = 10;
on:			i = sizeof(buf);
			j = -(c & 7);
			buf[--i] = 0;
			do {
				if((c = v % b) > 9)
					c += ('A'-('0'+10));
				buf[--i] = c + '0';
				++j; }
			while(v /= b);
			while(j++ & 0x80)		// Set minimal width
				buf[--i] = '0';
			fputs(buf+i, stdout);
			continue;
		case 0xA0:	v = a;	goto o16;		// Hex Passed
		case 0xB0:	v = Gi;					// "" Gi
o16:		b = 16;	goto on;
		case 0xC0:							// String Ptr
			fputs(Ptr, stdout); }
	if(d == 0xFF)
		exit(0);
}

// Set output Encode table entries
void SetOut(unsigned short n, unsigned char c)
{
	while(n) {
		EOut[Gi++] = c++;
		--n; }
}

// Outout character with max width
void Outc(unsigned short v)
{
	putc(EOut[v], fp);
	if(++OutP >= Width) {
		putc('\n', fp);
		OutP = 0; }
}

// Output Encoded single character
void OutC(unsigned char c)
{
	Outc((c >> 6) | 0x3C);
	Outc(c & 0x3F);
}
// Output Encoded previous section ref.
void OutS(unsigned short s, unsigned short a)
{
	s -= MINC;
	Outc( s >> 2 );
	Outc( ((s & 3) << 4) | (a >> 12) );
	Outc( (a >> 6) & 0x3F );
	Outc( a & 0x3F );
}

// Compare current position with preceeding
unsigned short Compare(unsigned short a1, unsigned short a2)
{
	unsigned short s;
	if(a1 == a2)
		return 0;
	s = 0;
	while(Get(a1++) == Get(a2++)) {
		if(++s >= MAXC)
			break; }
	return s;
}

// Output '-' separator bar
void OutBar(void)
{
	unsigned short i;
	i = Width;
	do {
		putc('-', fp); }
	while(--i);
	putc('\n', fp);
}

int main(int argc, char *argv[])
{
	unsigned short a, a1, a2, i, s;
	unsigned c;

#ifdef _MICROC_
	Seg = alloc_seg(4096);
#endif

	// Process command line
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
			switch(*Ptr++) {
			default	:	goto he;
			case 'w':
			case 'W':	; }
			Width = 0;
			while(c = *Ptr++) {
				if((a = (c - '0')) > 9)
					goto he;
				Width = (Width*10) + a; }
			if(Width < 8)
				goto he;
			continue; }
		if(!*Sfile) {
			strcpy(Sfile, Ptr);
			continue; }
		if(*Dfile)
			goto he;
		strcpy(Dfile, Ptr); }
	if(!*Dfile) {	// Various errors, output help text
he:		Ptr = ENChelp;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		goto ex; }

	SetOut(1, ':');		// Set
	SetOut(26, 'A');	// the
	SetOut(26, 'a');	// 64-code
	SetOut(10, '0');	// character
	SetOut(1, ';');		// set
 
	// resd source file into Seg byffer
	if(!(fp = fopen(Ptr = Sfile, "r")))
		Message("\xFFOpenFail: \xC0\n", 0);
	Message("Reading: \xC0\n", 0);
	while((c = getc(fp)) != EOF) {
		Put(Stop++, c);
		if(!Stop)
			Message("\xFF?TooBig", 0); }
	fclose(fp);

	// Generate the output file (with compression)
	if(!(fp = fopen(Ptr = Dfile, "w")))
		Message("\xFF?eOpenFail: \xC0\n", 0);
	Message("Writing: \xC0\n", 0);
	fputs("This file is ENCTXTed to protect from online reformatting.\n", fp);
	fputs("To Decode get: Daves Old Computers->Personal->Downloads->ENCTXT\n", fp);
	OutBar();
	Gi = Stop;
	a2 = 0;
	while(a2 < Stop) {
		if(!(a2 & 0xFF))	// Progress
			Message("\r\x80 of \x90", a2);
		// Perform "compression", by encoding strings longer than 2 as
		// references to previos data. (Such as reference takes as much
		// space as 2 characters - so not advantage for 2 or less).
		s = 0;
		for(a1 = 0; a1 < a2; ++a1) {
			if((i = Compare(a1, a2)) > s) {
				a = a1;
				if((s = i) >= MAXC)
					break; } }
		if(s < MINC) {			// No preceeding strings long enough
			OutC(Get(a2++));	// Output as "regular" character
			continue; }
		OutS(s, a);				// Output "compressed" reference
		a2 += s; }
	if(OutP)					// Partial output line
		putc('\n', fp);
	OutBar();
	fclose(fp);
	Message("\r\x80\n", a2);	// Final size

ex:	return 0;
}
