// Sample of ESP "Patchable Strings"
#include <stdio.h>

unsigned char
	____1[] = { 0xA7, 65, 65, 65, 0 },
	Str1[65] = "One",
	Str2[65] = "Two",
	Str3[65] = "Three",
	____2 = 0xA7;

// Dump a block of memory
void Dump(unsigned char *a, unsigned char *e)
{
	unsigned i;
	unsigned char c;
	while(a < e) {
		printf("%04x", a);
		for(i=0; i < 16; ++i) {
			if(!(i&3))
				putc(' ', stdout);
			if((a+i) < e)
				printf(" %02x", a[i]);
			else
				fputs("   ", stdout); }
		fputs("   ", stdout);
		for(i=0; i < 16; ++i) {
			if(a >= e)
				break;
			c = *a++;
			if((c < ' ') || (c > 0x7E))
				c = 0xFA;	//A8
			putc(c, stdout); }
		putc('\n', stdout); }
}

main()
{
	Dump(____1, &____2+1);

	printf("1'%s'\n", Str1);
	printf("2'%s'\n", Str2);
	printf("3'%s'\n", Str3);
}
