/*
 * Simple C program to show command line arguments with non-printable
 * character shown in a printable form: {%02x}
 *
 * Let's you easily see what Windows is doing to command line arguments.
 *
 * Compile with : CC args
 * Then run with: ARGS arguments...
 *
 * Dave Dunfield - Oct 2020 - https://dunfield.themindfactory.com
 */
#include <stdio.h>

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c, *p;

	for(i=0; i < argc; ++i) {
		printf("%u: <START>", i);
		p = argv[i];
		while(c = *p++) {
			if((c <' ') || (c > '~'))
				printf("{%02x}", c);
			else
				putc(c, stdout); }
		printf("{END}\n"); }
}
