/*
 * Generate a calendar given a month and year
 *
 * Copyright 1997-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc calendar
 */
#include <stdio.h>

/* Table of number of days in each month */
static char days_in_month[] = { 0,
/*	j	f	m	a	m	j	j	a	s	o	n	d	*/
	31,	28,	31,	30,	31,	30,	31,	31,	30,	31,	30,	31 };

/* Table of month names */
static char *months[] = { "???",
	"January", "February", "March", "April", "May", "June", "July",
	"August", "September", "October", "November", "December" };

/*
 * Calculate the day of the week for a given date
 */
int dow(int y, int m, int d )
{
	return (3*y - (7*(y+(m+9)/12))/4 + (23*m)/9 + d + 2) % 7;
}

main(int argc, char *argv[])
{
	int i, start, days, day, month, year;
	get_date(&day, &month, &year);

	if(argc > 1) {
		month = atoi(argv[1]);
		if((month < 1) || (month > 12))
			abort("\nUse: calendar [month [year]]\n");
		if(argc > 2)
			year = atoi(argv[2]); }

	/* Get # days in month */
	days = days_in_month[month];
	if((month == 2) && !(year % 4))
		++days;

	printf("              Calendar for month of %s, %u\n\n", months[month], year);
	printf("      Sun  |  Mon  |  Tue  |  Wed  |  Thr  |  Fri  |  Sat\n");
	printf("    -------+-------+-------+-------+-------+-------+-------\n    ");

	start = dow(year, month, 1);
	day = 0;
	i = 1;
	for(;;) {
		if(i <= start)
			printf("       ");
		else
			printf(" %5u ", ++day);
		if(day >= days)
			break;
		if(i++ % 7)
			printf("|");
		else {
			printf("\n           |       |       |       |       |       |\n    ");
			printf("-------+-------+-------+-------+-------+-------+-------\n    ");
			} }

	while(i % 7) {
		printf("|");
		if(++i % 7)
			printf("       "); }

	printf("\n           |       |       |       |       |       |\n");
}
