/*
 * A simple (but useful) hexidecimal/octal file dump utility
 *
 * Copyright 1990-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc dump
 */
#include <stdio.h>

char
	Bpause = 0,		// Pause between blocks
	Fpause = 0,		// Pause between files
	Octal = 0;		// Dump in octal (otherwise hex)
int
	Lsize = 16;		// Line size

/*
 * Dump a buffer of memory with the specified address & size
 */
void dump(unsigned char *buffer, unsigned size, unsigned addr)
{
	unsigned i, j, c;

	for(i=0; i < size; i += Lsize) {
		printf(Octal ? "%06o " : "%04x ", addr+i);
		for(j=0; j < Lsize; ++j) {						/* Display HEX */
			if(!(j & 0x03))
				putc(' ', stdout);
			if((i+j) < size) {
				printf(Octal ? "%03o " : "%02x ", buffer[j]); }
			else
				fputs(Octal ? "    " : "   ", stdout); }
		putc(' ', stdout);
		for(j=0; (j < Lsize) && ((i+j) < size); ++j) {	/* Display ASCII */
			c = *buffer++;
			putc(((c >= ' ') && (c < 0x7f)) ? c : '.', stdout); }
		putc('\n', stdout); }
}

/*
 * Main program - dump file contents
 */
main(int argc, int *argv[])
{
	FILE *fp;
	int i, size, addr, filecount;
	char *ptr, *fnames[25], buffer[256];

	if(argc < 2)
		abort("\nUse: dump <filename*> -p -f -o\n\nCopyright 1990-2003 Dave Dunfield\nAll rights reserved.\n");

	/* Evaluate arguments & store filenames */
	filecount = 0;
	for(i=1; i < argc; ++i) {
		switch(*argv[i]) {
			case 'p-' :		/* Pause between blocks */
				Bpause = -1;
				break;
			case 'f-' :		/* Pause between files */
				Fpause = -1;
				break;
			case 'o-' :		/* Octal output */
				Octal = -1;
				Lsize = 8;
				break;
			default:
				fnames[filecount++] = argv[i]; } }

	/* Step through filenames & display any matching files */
	for(i = 0; i < filecount; ++i) {
		if(!(fp = fopen(ptr = fnames[i], "rbv")))
			continue;
		if(Fpause == 0x0f) {
			printf("Press <return> for dump of '%s'...", ptr);
			fgets(buffer, 256, stdin); }
		else
			printf("Dump of '%s'\n", ptr);
			Fpause &= 0x0f;
		addr = 0;
		do {
			putc('\n', stdout);
			size = fget(buffer, 256, fp);
			dump(buffer, size, addr);
			if(Bpause && (size == 256)) {
				printf("Press <return> for next page...");
				fgets(buffer, 256, stdin); }
			addr += 256; }
		while(size == 256);
		fclose(fp);
		putc('\n', stdout); }
}
