#include <stdio.h>

#define	MAXPRIME	1000		/* Search up to here */

unsigned
	primes[MAXPRIME/2],
	squares[MAXPRIME/2],
	count = 0;

/*
 * Very simple program to find prime numbers.
 * Note: 2 is neither tested nor displayed by this program.
 */
void prime1(void)
{
	int num, test;
	char isprime;

	for(num=1; num < MAXPRIME; num += 2) {	/* Test range */
		isprime = 1;						/* Assume prime */
		for(test = 2; (test*test) <= num; ++test) {	/* Test for factors */
			if(!(num%test)) {				/* No remainder: factor */
				isprime = 0;				/* Indicate not prime */
				break; } }					/* Waste no more time */ 
		if(isprime)							/* Prime number, display */
			printf("%d\n", num); }
}

/*
 * Much faster program for finding prime numbers. Each number is tested
 * against previous primes, and the search is terminated when the
 * square of the previous prime exceeds the number being tested.
 *
 * Note: 1 and 2 are neither tested nor displayed by this program.
 */
void prime2(void )
{
	unsigned num, test;
	char flag;

	for(num=3; num < MAXPRIME; num += 2) {	/* Test range */
		flag = 1;
		for(test = 0; test < count; ++test) {
			if(squares[test] > num)			/* Out of range */
				break;
			if(!(num % primes[test])) {		/* No remainder - Not prime */
				flag = 0;
				break; } }
		if(flag) {
			printf("%d\n", num);
			primes[count] = num;
			squares[count++] = num*num; } }
}

main()
{
	prime1();
	prime2();
}
