/*
 * Program to display a file with user specified tab stops using spaces
 * to fill in the tabs.
 *
 * By redirecting the output from this program to a printer, you may
 * properly print my C sources and other files.
 *
 * I am in the habit of using tab intervals of 4 because the standard of
 * 8 makes C code run off the right side of the screen very quickly.
 *
 * If the first argument begins with a digit ('0'-'9') it is assumed to
 * be the desired tab interval, otherwise 4 is assumed.
 *
 * In MICRO-C, the operation "a && b" is defined as returning zero
 * without evaluating "b" if "a" evaluates to zero, otherwise "b"
 * is evaluated and returned.
 *
 * The statement "j = (chr != '\n') && j+1" shows how && (or ||) may
 * be used to create a very efficent conditional expression in MICRO-C.
 * NOTE that this is NOT "standard", and is NOT PORTABLE. The more
 * conventional equivalent is: "j = (chr != '\n') ? j+1 : 0"
 *
 * Copyright 1989-2003 Dave Dunfield
 * All rights reserved.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc tab2spc
 */
#include <stdio.h>

unsigned
	Tab = 4;

main(int argc, char *argv[])
{
	int i, j, chr;
	FILE *fp;

	if(argc < 2) {
he:		abort("\nUse: tab2spc [numeric-tab-interval] <filename...>\n"); }

	i = 0;
	if(isdigit(*argv[1])) {
		if(!(Tab = atoi(argv[++i])))
			goto he; }

	while(++i < argc) {
		if(fp = fopen(argv[i], "rv")) {
			j = 0;
			while((chr = getc(fp)) != EOF) {
				if(chr == '\t') {			/* tab */
					do
						putc(' ', stdout);
					while(++j % Tab); }
				else {						/* not a tab */
					j = (chr != '\n') && j+1;	/* see opening comment */
					putc(chr, stdout); } }
			fclose(fp); } }
	fflush(stdout);
}
