// Checks many of the Micro-C library functions
//	Note: This .C source is auto-generated by a tool I wrote to help
//	test the library, so it may not be as readable as you might like!
// Dave Dunfield - https://dunfield.themindfactory.com
#include <stdio.h>
// Make it very easy to add-remove Debugging printf's
// I use Debug1() to temp enable some without the rest
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
unsigned char
	Pass,	// Test passed flag
	Tnum;	// Tests number
unsigned char
	*Ptr;	// General pointer
void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}
// Begin a test sequence (& end last one)
void Begin(unsigned char *p)
{
	unsigned i;
	unsigned char c;
	switch(Pass) {
	case 1	:	Ps("Ok");
	default	:	Pc('\n');
	case 0	:	; }
	Pass = 1;
	if(p) {
		Tnum = i = 0;
		while(c = *p++) {
			Pc(c);
			++i; }
		while(i < 16) {
			Pc(' ');
			++i; } }
}
// NextTest - Advance test numner
void Nt(void)
{
	++Tnum;
}
// Check results of a function and report error if not expected
void Tst(unsigned v, unsigned r)
{
	Nt();
	if(v != r) {
		printf("(%u %x!%x)", Tnum, v, r);
		Pass = 7; }
}
// Fail current test sequence
void Fail(void)
{
	printf("%u!", Tnum);
	Pass = 7;
}
// Various variables used on some tests
int BStab[] = { 123, 456, 789, 321, 654, 987 };
int BStst(int *a, int *b) { return *a - *b; }
unsigned L[2],L1[2],L2[2],L1234[]={1234,0};
unsigned char Temp[8192];
extern int strcmp();
// Set and Test bits in a large bit array
void setbit(unsigned b)
{
	unsigned i;
	if((i = b >> 3) > 8197)
		error("?Sbit(%u)", b);
	Temp[i] |= (1 << (b & 7));
}
unsigned tstbit(unsigned b)
{
	unsigned i;
	if((i = b >> 3) > 8197)
		error("?Tbit(%u)", b);
	return Temp[i] & (1 << (b & 7));
}
// Assorted functions required to perform various tests.
unsigned Strcmp(unsigned char *s1, unsigned char *s2)
{	// Needed because DVM compiler optimizes strcmp() into an opcode
	// which means Qsort can't take it's address
	return strcmp(s1, s2);
}
unsigned Qsort(void)	// Test qsort() output in sequence
{
	unsigned i, j, k;
	static unsigned char t[5][3] = { "xf","bc","sr","ze","a5" };
	qsort(t, 5, 3, &Strcmp);
	for(i=k=0; i < 5; ++i) {
		j = ((unsigned)t[i][0] << 8) | t[i][1];
		if(j < k)
			return 0;
		k = j; }
	return 1;
}
unsigned Rand(void)	// Check rand() sequence covers all 64K possibilities
{
	unsigned i;
	memset(Temp, i=0, sizeof(Temp));
	do {
		setbit(rand()); }
	while(--i);
	do {
		if(!tstbit(i))
			return 0; }
	while(--i);
	return 1;
}
main()
{
	unsigned i;
	Begin("abs");
	Tst( abs(123) ,123);
	Tst( abs(-123) ,123);
	Begin("atoi");
	Tst( atoi("1234") ,1234);
	Tst( atoi("-1234") ,-1234);
	Begin("atox");
	Tst( atox("1AF2") ,0x1AF2);
	i = 789;
	Begin("bsearch");
	Tst( bsearch(&i,BStab,6,2,&BStst) ,&BStab[2]);
	Begin("concat");
	concat(Temp,"123","456");
	Tst( strcmp(Temp,"123456") ,0);
	Begin("isascii");
	Tst( isascii('a') ,1);
	Tst( isascii(0x80) ,0);
	Begin("isalpha");
	Tst( isalpha('a') ,1);
	Tst( isalpha('z') ,1);
	Tst( isalpha('A') ,1);
	Tst( isalpha('Z') ,1);
	Tst( isalpha(':') ,0);
	Begin("isalnum");
	Tst( isalnum('0') ,1);
	Tst( isalnum('A') ,1);
	Tst( isalnum('z') ,1);
	Tst( isalnum(';') ,0);
	Begin("islower");
	Tst( islower('a') ,1);
	Tst( islower('z') ,1);
	Tst( islower('`') ,0);
	Tst( islower('{') ,0);
	Begin("isupper");
	Tst( isupper('A') ,1);
	Tst( isupper('Z') ,1);
	Tst( isupper('@') ,0);
	Tst( isupper('[') ,0);
	Begin("isgraph");
	Tst( isgraph(' ') ,0);
	Tst( isgraph('!') ,1);
	Tst( isgraph('~') ,1);
	Tst( isgraph(0x7F) ,0);
	Begin("isdigit");
	Tst( isdigit('0') ,1);
	Tst( isdigit('9') ,1);
	Tst( isdigit('a') ,0);
	Tst( isdigit('z') ,0);
	Begin("isxdigit");
	Tst( isxdigit('0') ,1);
	Tst( isxdigit('9') ,1);
	Tst( isxdigit('A') ,1);
	Tst( isxdigit('f') ,1);
	Tst( isxdigit('@') ,0);
	Begin("iscntrl");
	Tst( iscntrl(0) ,1);
	Tst( iscntrl(0x1F) ,1);
	Tst( iscntrl(' ') ,0);
	Begin("ispunct");
	Tst( ispunct('!') ,1);
	Tst( ispunct('a') ,0);
	Tst( ispunct('@') ,1);
	Tst( ispunct('Z') ,0);
	Begin("isprint");
	Tst( isprint(' ') ,1);
	Tst( isprint(0x7E) ,1);
	Tst( isprint(0x09) ,0);
	Tst( isprint(0xFF) ,0);
	Begin("isspace");
	Tst( isspace(' ') ,1);
	Tst( isspace(0x09) ,1);
	Tst( isspace('\n') ,1);
	Tst( isspace('-') ,0);
	Begin("itoa");
	Nt();if(itoa(123,Temp,10)!=3)Fail();
	Tst( strcmp(Temp,"123") ,0);
	Begin("longset");
	Tst( longset(L, 1234) ,1234);
	Tst( longset(L1,1235) ,1235);
	Tst( longset(L2,1233) ,1233);
	Begin("longcmp");
	Tst( longcmp(L, L1234) ,0);
	Tst( longcmp(L1, L1234) ,1);
	Tst( longcmp(L2, L1234) ,-1);
	Begin("longset");
	Tst( longset(L1,1234+1234) ,(1234+1234));
	Begin("longadd");
	Tst( longadd(L,L1234) ,0);
	Begin("longcmp");
	Tst( longcmp(L,L1) ,0);
	longcpy(L2,L);
	Begin("longsub");
	Tst( longsub(L,L1234) ,0);
	Begin("longcmp");
	Tst( longcmp(L, L1234) ,0);
	Tst( longcmp(L1,L2) ,0);
	Begin("longset");
	Tst( longset(L, 1) ,1);
	Begin("!longtst");
	Tst( !longtst(L) ,0);
	Begin("longshr");
	Tst( longshr(L) ,1);
	Begin("longtst");
	Tst( longtst(L) ,0);
	Begin("longshr");
	Tst( longshr(L) ,0);
	L[1]=0x8000;
	Begin("!longtst");
	Tst( !longtst(L) ,0);
	Begin("longshl");
	Tst( longshl(L) ,1);
	Begin("longtst");
	Tst( longtst(L) ,0);
	Begin("longshl");
	Tst( longshl(L) ,0);
	longset(L,1234);
	longmul(L,L1234);
	Nt();if((L[1]!=0x0017)||(*L!=0x3C44))Fail();
	longdiv(L,L1234);
	Begin("longcmp");
	Tst( longcmp(L,L1234) ,0);
	Begin("ltoa");
	ltoa(L1234,Temp,10);
	Tst( strcmp(Temp,"1234") ,0);
	Begin("atol");
	atol("1234 ", L, 10);
	Tst( longcmp(L, L1234) ,0);
	Begin("max");
	Tst( max(99,100) ,100);
	Tst( max(99,-100) ,99);
	Begin("min");
	Tst( min(99,100) ,99);
	Tst( min(99,-100) ,-100);
	Begin("memset");
	Tst( memset(Temp,0x55,128) ,Temp);
	Nt(); for(i=0;i<128;++i) {
		if(Temp[i]!=0x55)Fail();
		Temp[i]=i; }
	Begin("memcpy");
	Tst( memcpy(Temp+128,Temp,128) ,(Temp+128));
	Begin("memcmp");
	Tst( memcmp(Temp+128,Temp,128) ,0);
	Begin("memchr");
	Tst( memchr(Temp,99,128) ,Temp+99);
	Begin("memmove");
	Tst( memmove(Temp+16,Temp,32) ,(Temp+16));
	Begin("memcmp");
	Tst( memcmp(Temp+16,Temp+128,32) ,0);
	Begin("Qsort");
	Tst( Qsort() ,1);
	Begin("Rand");
	Tst( Rand() ,1);
	Begin("sscanf");
	Tst( sscanf("(1234)", "(%u)", &i) ,1);
	Nt();if(i != 1234)Fail();
	Begin("sqrt");
	Tst( sqrt(123*123) ,123);
	Begin("sprintf");
	sprintf(Temp, "Test-%03u-%-03u", 45, 98);
	Tst( strcmp(Temp, "Test-045-980") ,0);
	Begin("strcspn");
	Tst( strcspn("test a,b", " ,") ,4);
	Tst( strcspn("test_a,b", " ,") ,6);
	Begin("stricmp");
	Tst( stricmp("Zero0","zero0") ,0);
	Tst( stricmp("one1", "One0") ,1);
	Tst( stricmp("Two1", "two2") ,-1);
	Begin("strlen");
	Tst( strlen("Testing") ,7);
	Begin("strbeg");
	Tst( strbeg("OneTwo", "One") ,1);
	Tst( strbeg("OneTwo", "Two") ,0);
	Begin("strcmp");
	Tst( strcmp("One1", "One1") ,0);
	Tst( strcmp("One1", "One0") ,1);
	Tst( strcmp("One1", "One2") ,-1);
	Begin("strcpy");
	Tst( strcpy(Temp, "FooBar") ,Temp);
	Tst( strcmp(Temp, "FooBar") ,0);
	Begin("strcat");
	Tst( strcat(Temp, "Flag") ,Temp);
	Tst( strcmp(Temp, "FooBarFlag") ,0);
	Begin("strchr");
	Tst( strchr(Temp,'B') ,Temp+3);
	Tst( strchr(Temp,'A') ,0);
	Begin("strlwr");
	strlwr(Temp);
	Tst( strcmp(Temp,"foobarflag") ,0);
	Begin("strupr");
	strupr(Temp);
	Tst( strcmp(Temp,"FOOBARFLAG") ,0);
	Begin("strrev");
	strrev(Temp);
	Tst( strcmp(Temp,"GALFRABOOF") ,0);
	Begin("strset");
	strset(Temp, '-');
	Tst( strcmp(Temp,"----------") ,0);
	Begin("strncpy");
	Tst( strncpy(Temp,"test", 8) ,Temp);
	Tst( strcmp(Temp,"test") ,0);
	Tst( strncpy(Temp, "OneTwoThree", 4) ,Temp);
	Tst( strcmp(Temp,"OneT") ,0);
	Begin("strdup");
	Ptr=strdup(Temp);
	Tst( strcmp(Ptr,"OneT") ,0);
	strcpy(Temp,"OneOneTwice");
	Begin("strstr");
	Tst( strstr(Temp,"One") ,Temp);
	Tst( strstr(Temp,"OneT") ,Temp+3);
	Tst( strstr(Temp,"Onz") ,0);
	strcpy(Temp,"--");
	Begin("strncat");
	Tst( strncat(Temp,"One", 4) ,Temp);
	Tst( strcmp(Temp,"--One") ,0);
	Tst( strncat(Temp, "TwoThree",3) ,Temp);
	Tst( strcmp(Temp,"--OneTwo") ,0);
	Begin("strncmp");
	Tst( strncmp(Temp,"--OneXXX",5) ,0);
	Begin("strnicmp");
	Tst( strnicmp(Temp,"--ONeXXX",5) ,0);
	Begin("strnset");
	strnset(Temp,'=',3);
	Tst( strcmp(Temp,"===neTwo") ,0);
	Begin("strpbrk");
	Tst( strpbrk(Temp,"To") ,Temp+5);
	Tst( strpbrk(Temp,"Tn") ,Temp+3);
	strcpy(Temp,"=a=a=a=");
	Begin("strrchr");
	Tst( strrchr(Temp,'a') ,Temp+5);
	Tst( strrchr(Temp,'Z') ,0);
	Begin("strspn");
	Tst( strspn("5512fred", "1234567890") ,4);
	strcpy(Temp,"one two,three,four");
	Begin("strtok");
	Ptr = strtok(Temp," ,;");
	Tst( strcmp(Ptr, "one") ,0);
	Ptr = strtok(0," ,;");
	Tst( strcmp(Ptr, "two") ,0);
	Ptr = strtok(0," ,;");
	Tst( strcmp(Ptr, "three") ,0);
	Ptr=strtok(0," ,;");
	Tst( strtok(0," ,;") ,0);
	Begin("toupper");
	Tst( toupper('a') ,'A');
	Begin("tolower");
	Tst( tolower('A') ,'a');
	Begin(0);
}
