// TST
#include <stdio.h>
#include <setjmp.h>
#include <dvmvideo.h>
#include <file.h>
#define	TAB		4			// Tab stops
#define	MARGIN	70			// Screen margin
#define	CLIST	50			// CharList
#define	POOL	16384		// String storage pool size

#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

//#define	Uchar	unsigned char
//#define	Ushort	unsigned

jmp_buf Mret;
unsigned
	Line,					// File I/O line
	Sh, Sl, At, Ti, Da,		// find vars
	Ppos,					// Print (output) position
	Stop, Ptop;				// String top, Pool top
FILE
	*fp;
unsigned char
	*Ptr,					// General pointer
	*Slist[CLIST],			// String list
	Buffer[256],			// General buffer
	Arg[64],				// Parsed argument
	Temp[128],				// Temp buffer
	Pool[POOL];				// String storage pool

#define	_KEYS_	29

unsigned char *Ktxt[] = {
 "UA", "DA", "LA", "RA", "PU", "PD", "HO", "EN", "KP", "KM", "IN", "DL",
 "BS", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "CPU",
 "CPD", "CHO", "CEN", "CLA", "CRA" };

unsigned char Kval1[] = {
 0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B,
 0x8C, 0x8D, 0x8E, 0x8F, 0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
 0x98, 0x99, 0x9A, 0x9B, 0x9C };

unsigned Kval2[] = {
 0x0248, 0x0250, 0x024B, 0x024D, 0x0249, 0x0251, 0x0247, 0x024F, 0x0174,
 0x0184, 0x0252, 0x0253, 0x0008, 0x013B, 0x013C, 0x013D, 0x013E, 0x013F,
 0x0140, 0x0141, 0x0142, 0x0143, 0x0144, 0x0286, 0x0276, 0x0277, 0x0275,
 0x0273, 0x0274 };

unsigned char *Cmds[] = {
 "END", "HELP", "KBGET", "KBTST", "VIDC", "VIDK", "MD", "RD", "CD", "FINDF",
 "FREAD", "FWRITE", "EXEC", "SYS", "DELAY", "RAMD", 0 };
#define	END			1
#define	HELP		2
#define	KBGET		3
#define	KBTST		4
#define	VIDC		5
#define	VIDK		6
#define	MD			7
#define	RD			8
#define	CD			9
#define	FINDF		10
#define	FREAD		11
#define	FWRITE		12
#define	EXEC		13
#define	SYS			14
#define	DELAY		15
#define	RAMD		16

void Reset(void)
{
	if(fp)
		fclose(fp);
	fp = Ptop = Stop = Line = 0;
}

register Pr(unsigned args);
void Pc(unsigned c)
{
	switch(c) {
	case'\t':
		do {
			Pc(' '); }
		while(Ppos % TAB);
		return;
	case'\r':
	case'\n':	Ppos = 0;	break;;
	default	:
		if((c < ' ') || (c> '~')) {
			Pr("{%x}", c);
			return; }
		++Ppos; }
	putc(c, stdout);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}
void Pgo(unsigned x)
{
	do {
		Pc(' '); }
	while(Ppos < x);
}

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	if(Line) printf("%u: ", Line);
	Ps(buf);
	exit(-1);
}

void Quit(void)
{
	unsigned i;
	for(i=0; i < 3; ++i) {
		delay(100);
		if(kbtst() == 0x1B)
			error("?Quit!"); }
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
	Pc('\n');
	longjmp(Mret, 99);
}

//Parse string from input stream
unsigned Parse(unsigned char *p)
{
	unsigned i;
	unsigned char c, e;

	i = 0;
	switch(e = Skip()) {
	default	:
a1:		switch(p[i] = *Ptr) {
		default	:	++Ptr;	++i;	goto a1;
		case ' ':
		case'\t':
		case 0	:	p[i] = 0; }
		goto a3;
	case '`':
	case '"':
	case'\'': ;	}
a2:		if(!(c = *++Ptr))
			Error("?parse");
		if(c != e) {
			p[i++] = c;
			goto a2; }
		p[i] = 0;
		++Ptr;
a3:		return i;
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

void Parg(void)
{
	if(Parse(Arg)) return;
	Error("?Arg");
}
unsigned PargD(unsigned char *p)
{
	if(Parse(Arg)) return 255;
	strcpy(Arg, p);
	return 0;
}

unsigned Value(void)
{
	unsigned v, b, c;
	unsigned char *p;

	b = 10;
	switch(Skip()) {
	case '%':	b = 2;	goto a1;
	case '@':	b = 8;	goto a1;
	case '$':	b = 16;
a1:		++Ptr; }
	v = 0;
	p = Ptr;
a2:	c = *Ptr;
	if((c >= '0') && (c <= '9')) 	{	c -= '0';		goto a3;	}
	if((c >= 'a') && (c <= 'f'))	{ 	c -= ('a'-10);	goto a3;	}
	if((c >= 'A') && (c <= 'F'))	{	c -= ('A'-10);
a3:		v = (v * b) + c;
		++Ptr;
		goto a2; }
	if(Ptr == p)
		Error("?Value");
	return v;
}

unsigned ReadLine(void)
{
	if(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		++Line;
		return 255; }
	return 0;
}

void KBget(unsigned char t)
{
	unsigned i, c, d, e;
a1:	i = 3;
a2:	if(t == 4) {
		while(!(c = kbtst())) {
			delay(500);
			Pc('.'); } }
	else
		c = kbget();
	Pc(e = (c == '\'') ? '"' : '\'');
	Pc(c);
	Pc(e);
	Pc('\n');
	e = d;
	if((d = c) != e) goto a1;
	if(--i) goto a2;
}

void Video(unsigned char f)
{
	unsigned c, i, j, k;
	Vopen(0x17);
	for(i=j=k=0; i < 10; ++i) {
		Vgotoxy(i*4, i);
		Vprintf("%u", i); }
	do {
		c = f ? Vgetk() : Vgetc();
		Vgotoxy(10, 15);
		Vprintf("=%x ",c);
		for(i=0; i < _KEYS_; ++i) {
			if((Kval1[i]==c)||(Kval2[i]==c))
				Vprintf(" %s", Ktxt[i]); }
		Vcleol();
		if(c != j) {
			j = c;
			k = 0; } }
	while(++k < 3);
	Vclscr();
	for(i=0; i < 255; ++i) {
		j = (i >> 4) * 5;
		Vgotoxy(j, (i & 15)+5);
		Vcolor(i);
		Vprintf("%02x", i); }
//	Vcolor(7);
	Vgetc();
	Vclose();
}

void CDtst(void)
{
	unsigned i, j, k;
	if(PargD(Arg)) {
		i = toupper(*Arg)-'A';
		if(Arg[1] == ':') {
			j = set_drive(i);
			k = get_drive(i);
			printf("%u%c", j, ((k==i)?'Y':'N')); }
		printf("%u\n", chdir(Arg) );
		return; }
	printf("%c:", get_drive()+'A' );
	i = getdir(Temp);
	printf("'%s'%u\n", Temp, i);
}

void FindF(void)
{
	unsigned i, j, f;
	struct FF_block ff;

	f = 0x3F;
	PargD("*.*");
	if(Skip())
		f = Value();

	if(find_first(Arg, f, Temp, &Sh, &Sl, &At, &Ti, &Da))
		Error("?FF1");
	do {
		if(Stop >= CLIST)
			Error("?SlistOver");
		sprintf(Buffer, "'%s'%04x%04x %04x %04x%04x -", Temp, Sh, Sl, At, Da, Ti);
		Slist[Stop++] = Pstring(Buffer); }
	while !(i=find_next(Temp, &Sh, &Sl, &At, &Ti, &Da));

	j = 0;
	if(findfirst(Arg, ff, f))
		Error("?FF2");
	do {
		sprintf(Buffer, " %04x%04x %04x %04x%04x'%s'",
			ff.FF_date,
			ff.FF_time,
			ff.FF_attrib,
			ff.FF_size[1],
			ff.FF_size[0],
			ff.FF_name);
			printf("%40s", Slist[j++]);
			printf("%s\n", Buffer); }
	while !(i=findnext(ff));
}

void File(unsigned char op)
{
	unsigned i;
	unsigned char *p1;
	PargD("aBcD");
	p1 = op ? "wv" : "rv";
printf("File'%s'%s'\n", Arg, p1);
	if(!(fp = fopen(Arg, p1)))
		return;
	if(op) {
		for(i=0; i < 10; ++i)
			fprintf(fp, "%s %u\n", Arg, i); }
	else {
		while(ReadLine())
			printf("%u'%s'\n", Line, Buffer); }
	fclose(fp);
}

main(/*int argc, char *argv[]*/)
{
	unsigned i, j;
	unsigned char *p;

	if(i = setjmp(Mret))
		printf("[%u]", i);
a1:	Reset();
	Ps("Tst> ");
	if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, stdin))
		return;
	Debug(("Il'%s'\n", Ptr))
	Pc('\r');
	if(!Parse(Temp)) goto a1;
	strupr(Temp);
	i=j=0;
	while(p=Cmds[i++]) {
		if(strbeg(p, Temp)) {
			if(j) Error("?DupCmd");
			j = i; } }
	if(!j) Error("?Cmd");
	switch(j) {
	case END	:	error("End!");
	case HELP	:	i = j = 0;
		while(p = Cmds[i++]) {
			Pgo(j);
			Ps(p);
			if((j += 8) >= MARGIN) {
				j = 0;
				Pc('\n'); } }
		if(j) Pc('\n');
		goto a1;
	case KBGET	:
	case KBTST	:	KBget(j);	goto a1;
	case VIDC 	:	Video(0);	goto a1;
	case VIDK	:	Video(7);	goto a1;
	case MD		:	Parg(); i=mkdir(Arg);
a2:		Pr("=%u-$%x\n", i, i);
		goto a1;
	case RD		:	Parg(); i=rmdir(Arg);	goto a2;
	case CD		:	CDtst();		goto a1;
	case FINDF	:	FindF();	goto a1;
	case FREAD	:	File(0);	goto a1;
	case FWRITE	:	File(7);	goto a1;
	case EXEC	:
		Parg();
		Parse(Temp);
		Pr("Exec(\"%s\",\"%s\")\n", Arg, Temp);
		i = exec(Arg, Temp);
		goto a2;
	case SYS	:
		Parg();
		Pr("system(\"%s\")\n", Arg);
		i = system(Arg);
		goto a2;
	case DELAY	:
		i = 0;
		do {
			delay(1000);
			printf("%u\n", ++i); }
		while(kbtst() != 0x1B);
		goto a1;
#ifdef _DVM_
	case RAMD	:
		Parg();
		j = Value();
		printf("RDsetup('%c', %u)", *Arg, j);
		i = RDsetup(*Arg, j);
		goto a2;
#endif
	}
	Pr("'%s' is not implemented in this version of TST!\n", Temp);
	Pr("Perhaps it is not available on this system!\n");
	goto a1;
}
