; Model 100 ROM addresses
LCD	EQU	$4B44	; Display character on LCD
KYREAD	EQU	$7242	; scan keyboard
CHGET	EQU	$12CB	; Wait for char
RCVX	EQU	$6D6D	; Check RS-232 queue for chars
RV232C	EQU	$6D7E	; Get char from RS232 queue
SD232C	EQU	$6E32	; Send char
MENU	EQU	$5797	; Go to main menu
;
; This is a very simple MONITOR program for the TRS-80 Model100
;   Build	>	ASM100 M100MON -B
;   Load	>	M100 put R:\M100MON.TXT -B	<-follow prompts
;   Model100	:	Menu->BASIC
;			LOAD"COM:88N1E		<-then press ENTER at PC prompt
;			RUN			<-takes few mins, and shows two
;						  numbers:	{n1}	{n2}
;	launch now->	CALL {n1}
;  make MONITOR.CO->	SAVEM"MONITOR",{n1},{n2},{n1}
; commands available at '>' prompt
;> M ssss,eeee		<- dump Memory
;> E aaaa		<- Edit memory (SPACE to skip, ENTER to quit)
;> F ssss,eeee bb	<- Fill memory
;> G aaaa		<- Go (execute)
;> I pp			<- Input/display IO port
;> K			<- Klear pending RS232
;> L			<- Load Motorola 'S' file (F1-F8 to abort)
;> O pp xx		<- Output xx to port
;> R R aaaa		<- Repeat Read memory	> no
;> R W=xx aaaa		<- Repeat Write memory	> display
;> R I pp		<- Repeat In IO port	> SPACE
;> R O=xx pp		<- Repeat Out IO port	> to stop
;> T			<- TTY to RS232 (F1-F8 to abort)
;> U ssss,eeee		<- Upload memory - Motorola'S'
;> = T			<- switch to Tty (RS232) console
;> = M			<- Switch to M100 (LCD/Keyboard) console
;> X		<=	 eXit
;
; At data prompts, enter 2/4 hex digits or ENTER to cancel
;
; Dave Dunfield   -   https://dunfield.themindfactory.com
;
	ORG	$F000
iom100:	LXI	H,CHGET		Keyboard get char
	LXI	D,LCD		LCD	 put char
	LXI	B,TSKBD		Keybiard test
ioset:	SHLD	GETC+1		Patch input call
	XCHG
	SHLD	PUTC+1		Patch output
	MOV	H,B
	MOV	L,C
	SHLD	TSTC+1		Patch test call
RSTART:	LXI	SP,STACK		Reset stack
go1:	CALL	NL		NewLine
	MVI	A,'>'		Prompt
	CALL	PUTC		Display
	CALL	GETCU		Get commane
	MOV	C,A		Save
	CALL	PUTC		Echo
	CALL	SP		Space over
	LXI	H,CMDTAB	Point to table
go2:	MOV	A,M		Get char from table
	INX	H		next
	ANA	A		End?
	JZ	ncmd		Fail
	MOV	E,M		get low addr
	INX	H		next
	MOV	D,M		get high addr
	INX	H		next
	CMP	C		MAtch
	JNZ	go2
	XCHG
go3:	PCHL
CMDTAB	EQU	*
	DB	'M'
	DW	MEMDMP
	DB	'E'
	DW	EDIT
	DB	'F'
	DW	FILL
	DB	'I'
	DW	INP
	DB	'O'
	DW	OUTP
	DB	'R'
	DW	REP
	DB	'='
	DW	SETIO
	DB	'G'
	DW	GO
	DB	'X'
	DW	MENU
	DB	'U'
	DW	UPLOAD
	DB	'L'
	DW	DNLOAD
	DB	'K'
	DW	DLEND
;	DB	'Z'
;	DW	DOTEST		;?
	DB	'T'
	DW	TTY
	DB	0
; Not a valid command
NCMD	CALL	OUTON		Insure output ON
	MVI	A,'?'		Error indicator
	CALL	PUTC		display
	JMP	go1
; Turn output OFF/ONN
OUTOFF:	LDA	PUTC		1st of function
	CPI	$C9		RET opcore
	RZ			already OFF
	STA	TMPBUF		save
	MVI	A,$C9		RET opcode
	JMP	oo1
OUTON:	LDA	PUTC
	CPI	$C9
	RNZ
	LDA	TMPBUF
oo1:	STA	PUTC		block output
	RET
; dumpMemory
MEMDMP	CALL	GETW		Start address
	XCHG			Save
	CALL	CMA		','
	CALL	GETW		End address
	INX	H		+1 to include ""
	XCHG			HL=start DE=end
mem1	CALL	NL		Newline
	CALL	PUTW		Show address
	CALL	SP		Space
	PUSH	H		Save address
	MVI	B,16		bytes/line
	MOV	C,B		for hex/text
mem2	MOV	A,H		Get high
	CMP	D		at end?
	JNZ	mem2a		no
	MOV	A,L		Get low
	CMP	E		at end?
	JZ	mem2b		yes
mem2a	CALL	SP		space
	MOV	A,M		get value
	INX	H		next
	CALL	PUTH		display
	DCR	B		reduce count
	JNZ	mem2		more
mem2b	MOV	A,B		remaining count
	ANA	A		?
	JZ	mem2d		no
mem2c	CALL	SP		space
	CALL	SP		'x'
	CALL	SP		'x'
	DCR	B		reduce count
	JNZ	mem2c		till done
mem2d	POP	H		restore address
	CALL	SP
	CALL	SP
mem3	MOV	A,H		get high
	CMP	D		at end?
	JNZ	mem3a		no
	MOV	A,L		get low
	CMP	E		at end?
	JZ	go1		yes?
mem3a	MOV	A,M		get value
	INX	H		next
	CPI	' '		<' '(unprint)
	JC	mem4		yes
	CPI	'~'+1		>'~'(unprint)
	JC	mem5		no
mem4	MVI	A,'.'		chg unprint to '.'
mem5	CALL	PUTC		display
	DCR	C		reduce count
	JNZ	mem3		do all
	MOV	A,H		get high
	CMP	D		above end?
	JC	mem1		no
	JNZ	go1		yes
	MOV	A,L		get low
	CMP	E		above end?
	JC	mem1		no
	JMP	go1
; Edit (modify)
EDIT	CALL	GETW		get address
ed1:	CALL	NL		newline
	CALL	PUTW		show address
	MVI	B,8		8 bytes/line
ed2:	CALL	SP		space
	MOV	A,M		get existing value
	CALL	PUTH		display
	CALL	EQ		' '
	CALL	TSTSP		Space? (next)
	JZ	ed3		yes, don't change
	CALL	GETB		get new value
	MOV	M,A		resave
ed3:	INX	H		next
	DCR	B		reduce line count
	JNZ	ed2		continue on this one
	JMP	ed1		new output line
; Fill memory range
FILL	CALL	GETW		Start address
	XCHG			Save
	CALL	CMA		','
	CALL	GETW		End address
	XCHG			HL=sstart FE=end
	CALL	SP		' '
	CALL	GETB		Get value
	MOV	B,A		Save
f1:	MOV	M,B		Write value
	MOV	A,H		Get Haddr
	CMP	D		At end?
	JNZ	f2		No
	MOV	A,L		Get Laddr
	CMP	E		At end?
	JZ	go1		Yes
f2:	INX	H		Next
	JMP	f1
; Input from port
INP:	MVI	B,$DB		IN opcode
	CALL	STMP1		Create RAM subroutine
	CALL	TMPBUF		Call it
	CALL	PUTH		Display
	JMP	go1
; Output to port
OUTP	MVI	B,$D3		OUT opcode
	CALL	STMP1		create RAM subroutine
	CALL	GETB		get byte to output
	CALL	TMPBUF		call ""
	JMP	go1
; Repeated Read Write In I=Out
REP	CALL	GETCU		get type
	CALL	PUTC
	CPI	'R'
	JZ	REPR
	CPI	'W'
	JZ	REPW
	MVI	B,$DB		IN opcode
	CPI	'I'
	JZ	REPIO
	MVI	B,$D3		OUT opcode
	CPI	'O'
	JNZ	NCMD
	CALL	EQ
	CALL	GETB		Byte to write
	MOV	C,A		Save
	CALL	SP
REPIO	MOV	A,B		Get opcode
	CALL	STMP1		Build subroutine
	CALL	NL
repio1	MOV	A,C		get byte (if needed)
	CALL	TMPBUF		call IO sub
	CALL	TSTSPC		Over?
	JNZ	repio1		keep going
	JMP	go1
REPR	CALL	GETW		Get address
	CALL	NL
repr1	MOV	A,M		Read nen
	CALL	TSTSPC		Over?
	JNZ	repr1		Keep going
	jmp	go1
REPW	CALL	EQ
	CALL	GETB		get byte
	MOV	C,A		save
	CALL	SP
	CALL	GETW		get address
	CALL	NL
repw1	MOV	M,C		Write to mem
	CALL	TSTSPC		Over?
	JNZ	repw1		Keep going
	JMP	go1
TSTSPC	CALL	TSTC		Get char
	CPI	' '		Space?
	RET
; Go (execute)
GO	CALL	GETW
	CALL	GHL
	JMP	go1
GHL	PCHL
; TTY
TTY	CALL	NL		New line
tty1:	CALL	KYREAD		Test for char
	JZ	tty2
	JC	go1		Special=END
	CALL	SD232C		send
tty2	CALL	RCVX		in?
	JZ	tty1		no
	CALL	RV232C		get char
	CALL	LCD		display
	JMP	tty1		continue
; Set IO
SETIO	CALL	GETCU		Get char
	CPI	'M'		'M'odel100
	JZ	iom100
	CPI	'T'		'T'ty
	JNZ	NCMD
	LXI	H,RV232C	TTY getchar
	LXI	D,SD232C	TTY putchar
	LXI	B,TS232		TTY test
	JMP	ioset
; Upload memory
UPLOAD	CALL	GETW		Start address
	XCHG			Save
	CALL	CMA		','
	CALL	GETW		End address
	INX	H		+1 to include ""
up1:	MOV	A,H		Get high
	SUB	D		At end?
	JNZ	up2		no
	MOV	A,L		Get low
	SUB	E		compute length
	JZ	up5		at end
	CPI	32		Too large?
	JC	up3		yes, limit
up2:	MVI	A,32		max record length
up3:	MOV	C,A		save
	CALL	NL		new line
	PUSH	H		save HL
	CALL	PUTPC		send record entry
	STRZ	"S1"
	POP	H		restore
	MVI	B,0		initial checksum
	MOV	A,C		length
	ADI	3		adjust for ck+addr
	CALL	ubyte		send
	MOV	A,D		address high
	CALL	ubyte		send
	MOV	A,E		address low
	CALL	ubyte		send
up4:	LDAX	D		get byte
	INX	D		next
	CALL	ubyte		send
	DCR	C		reduce length
	JNZ	up4		more
	MOV	A,B		checksum
	CMA			one's compliment
	CALL	PUTH		send
	JMP	up1
up5:	CALL	PUTPC
	DB	$0A,$0D
	STRZ	"S9030000FC"
	JMP	go1
ubyte	CALL	PUTH		output
	ADD	B		add to checksum
	MOV	B,A		resave
	RET
;
DNLOAD	CALL	dchar		Wait for record start
	CPI	'S'		Start?
	JNZ	dnload
	CALL	dchar
	CPI	'9'		end?
	JZ	dlend		yes
	CPI	'1'		record?
	JNZ	dnload		no
	CALL	EQ		Indicate record
	MVI	B,0		Initial checksum
	CALL	dbyte		Length
	SUI	3		adjust for addr+checksum
	MOV	C,A		set count
	CALL	dbyte		Address High
	MOV	H,A
	CALL	dbyte		Address Low
	MOV	L,A
dnl2:	CALL	dbyte		data
	MOV	M,A		save
	INX	H		next
	DCR	C		reduce count
	JNZ	dnl2		more
	CALL	dbyte1		checksum
	CMA			One's compliment
	CMP	B		Match?
	JZ	dnload
dlerr:	CALL	flush		clear pending
	JMP	NCMD		and report
flush:	MVI	A,'.'
	CALL	putc
fl1:	LXI	B,0		max timeout
fl2:	CALL	RCVX		character?
	JZ	fl3		yes, reset
	CALL	RV232C		clear char
	JMP	fl1
fl3:	DCX	B		Redice count
	MOV	A,B
	ORA	C
	JNZ	fl2		no, wait
	RET
DLEND	CALL	flush		clear pending
	JMP	go1
dchar	CALL	KYREAD		Test abort key
	JZ	dch1		no
	JC	RSTART		abort
dch1	CALL	RCVX		RS232?
	JZ	dchar		no
	JMP	RV232C		Get char
dnib	CALL	dchar		Get character
	CPI	'0'		<'0'?
	JC	dnib1		yes
	CPI	'9'+1		>'9'?
	JNC	dnib1		yes
	SUI	'0'		convert to nibble value 0-9
	RET
dnib1	CPI	'A'		<'A'?
	JC	dnib		yes, ignore
	CPI	'F'+1		>'F'?
	JNC	dnib		yes, ignore
	SUI	'A'-10		convert to nibble value A-F
	RET
dbyte1	CALL	dnib
	RAL			shify
	RAL			info
	RAL			high
	RAL			position
	PUSH	B		reserve B
	MOV	B,A		save
	CALL	dnib		get low nibble
	ORA	B		add high
	POP	B		restore B
	RET
dbyte	CALL	dbyte1
	PUSH	PSW
	ADD	B
	MOV	B,A
	POP	PSW
	RET
;Data Record: 'Stnnaaaadddddddddddddddddddddddddddddddd...cc'
;      Where:  S = 'S', indicates start of data record
;              t = Record type, '1'=data, '9'=end of file.
;              n = Count of number of bytes in record.   (in ASCII/HEX)
;              a = Load address of data record.          (in ASCII/HEX)
;              d = Actual data bytes in record.          (in ASCII/HEX)
;              c = Checksum of count, address, and data. (in ASCII/HEX)
;            Note1: Checksum is computed as one's complement of eight
;                   bit sum of all values from 'nn' to end of data.
;            Note2: Count 'nn' is three greater then the number of data
;                   bytes in the record.
; Build subroutine in RAM with: A=opcode B=byte
STMP1	CALL	GETB		Get I/O port
	STA	TMPBUF+1	save operand
	MOV	A,B		get opcode
	STA	TMPBUF		and save
	MVI	A,$C9		RET opcode
	STA	TMPBUF+2	save in buffer
	JMP	SP		Space & return
;
; Write HL-HEX
PUTW:	MOV	A,H		Get High
	CALL	PUTH		display in hex
	MOV	A,L		Get Low
; Write A-HEX
PUTH:	PUSH	PSW		Save for later
	RAR			shift
	RAR			top nibble
	RAR			into
	RAR			bottom
	CALL	ph1		display high nibble
	POP	PSW		Restore
	PUSH	PSW		save to preserve
	CALL	ph1		display low nibble
	POP	PSW		restore
	RET
ph1:	ANI	15		insure only 1 nibble
	CPI	10		9-9?
	JC	ph2		yes
	ADI	7		'9'+1 -> 'A'
ph2:	ADI	'0'		convert to printable
	JMP	putc		display and return
; Write string[PC]
PUTPC	POP	H		get PC
ppc1:	MOV	A,M		get byte
	INX	H		next
	ANA	A		end ?
	JZ	ppc2		yes
	CALL	PUTC		display
	JMP	ppc1		and continue
ppc2	PCHL			new return address
; Output various canned characters
SP	PUSH	PSW
	MVI	A,' '
	JMP	NL1
EQ	PUSH	PSW
	MVI	A,'='
	JMP	NL1
CMA	PUSH	PSW
	MVI	A,','
	JMP	NL1
NL	PUSH	PSW
	MVI	A,$0A
	CALL	PUTC
	MVI	A,$0D
nl1:	CALL	PUTC
	POP	PSW
	RET
; Get char - convert to upper
GETCU	LDA	PRECH		pending reject
	ANA	A		?
	JZ	getcu1		yes
	PUSH	PSW		save
	XRA	A		zero
	STA	PRECH		pending
	POP	PSW		restore
	RET
getcu1	CALL	GETC		Get from console
	CPI	'a'		lower case?
	RC			no
	CPI	'z'+1		lower case?
	RNC			no
	SUI	'a'-'A'		convert to upper
	RET
; Test for SPACE entry
TSTSP	CALL	GETCU		get char
	CPI	' '		space?
	RZ			Yes
	STA	PRECH		Save as pending
;	ANA	A
	RET	
; Get HEX digit
GETNIB	CALL	GETCU		Get character
	CPI	$0D		return?
	JZ	RSTART		yes, exit
	CPI	'0'		<'0'?
	JC	getn1		yes
	CPI	'9'+1		>'9'?
	JNC	getn1		yes
	CALL	PUTC		echo
	SUI	'0'		convert to nibble value 0-9
	RET
getn1	CPI	'A'		<'A'?
	JC	getnib		yes, ignore
	CPI	'F'+1		>'F'?
	JNC	getnib		yes, ignore
	CALL	PUTC		echo
	SUI	'A'-10		convert to nibble value A-F
	RET
; Get BYTE value 00-FF in A
GETB	CALL	GETNIB		get high nibble
	RAL			shify
	RAL			info
	RAL			high
	RAL			position
	PUSH	B		reserve B
	MOV	B,A		save
	CALL	GETNIB		get low nibble
	ORA	B		add high
	POP	B		restore B
	RET
; Get word value 0000-FFFF in HL
GETW	CALL	GETB		get High
	MOV	H,A		set H
	CALL	GETB		get Low
	MOV	L,A		set L
	RET
; I/O functions
GETC	JMP	CHGET		Get charactger from console
PUTC	JMP	LCD		Put character to console
TSTC	JMP	TSKBD
;
TSKBD	CALL	KYREAD
	JNZ	GETC
	XRA	A
	RET
TS232	CALL	RCVX
	JNZ	RV232C
	XRA	A
	RET
;
PRECH	DB	0
TMPBUF	RMB	3
	RMB	128
STACK	EQU	*
