/*
 * MICRO-C File system definitions for DVM
 *
 * Copyright 2020 Dave Dunfield
 * All rights reserved.
 */

#define	PATH_SIZE	128		/* Max. size of pathname */

// Commented out lines are not available with LCC/Windows

/* File attribute bits in directory entry */
#define	READONLY	0x01	/* File cannot be written */
#define	HIDDEN		0x02	/* File skipped in normal searches */
#define	SYSTEM		0x04	/* File is considered part of system */
#define	VOLUME		0x08	/* Directory entry is volume label */
#define DIRECTORY	0x10	/* File is a directory */
//#define	ARCHIVE		0x20	/* File has been modified */

/* Structure of findfirst/findnext block */
struct FF_block {
	unsigned	FF_date;			/* file Date stamp */
	unsigned	FF_time;			/* file Time stamp */
	unsigned	FF_attrib;			/* file Attributes */
	unsigned	FF_size[2];			/* Size of file */
	char		FF_name[13]; };		/* Name of file */

