/*
 * DDS MICRO-C standard I/O definitions for DVM
 *
 * Copyright 2020-2021 Dave Dunfield
 * All rights reserved.
 */
#define	_MICROC_
#define	_DVM_

#define	FILE	unsigned	/* FILE = 16 bit value */
#define	EOF		-1			/* End of file indicator */
#define	NULL	0			/* General NULL indicator */

extern register printf(), fprintf(), sprintf(),
				scanf(), fscanf(), sscanf(),
				concat();
extern char		*fgets();
extern FILE		*fopen(), *stdin, *stdout, *stderr;

// Micro-C being a 16 bit compiler does not know about "short". I chose
// not to implement it when I wrote Micro-C because it would have done
// "nothing" - the native int size is 16 bits. Later I came to regret not
// doing so because "short" was critical in code for some other compilers
// when I "wanted" 16 bits. I could have modified the compiler to implement
// a non-functional "short" however I decide to simply do this:
//  Define "short" as blank using MCCs limited built-in pre-processor.
//	This way it does'nt use any of MCPs storage space and does'nt show
//	to "#ifdef" etc.
#define	_DeFiNe_	#define
_DeFiNe_ short
#forget _DeFiNe_
