/*
 * Example of a C progam using PTXTP for source configuration
 */
#include <stdio.h>

/*
 * Most source/config text files allow comments of one kind or another.
 * The following line defines what is a "Special Comment"
 *      PtXtP '//:'
 * for the remainder of this text, I will call them "SC"s.
 *
 * SCs contain information used by PTXTP and must be placed at the very
 * beginning of a line.
 *
 *Note1:Since PTXTP has to scan through each line for the SC identifier,
 *      to avoid spending a long time on incorrect files, it "gives up"
 *      (with an error) after 10 lines.  Use -Ln if you must go higher.
 *Note2:I have added a lot of comments describing how this works, but
 *      the actual program and PTXTP SCs required is very small.
 */

/*
 * These SCs define item lists which may be substituted into following lines.
 *
 * Strings are normally parsed by PTXTP based on following spaces, tabs or
 * EndOfLine -- In the event that you need strings containing spaces or tabs,
 * the following delimiter characters can be used: ' " `
 *Note: Delimiter characters are NOT included in the parsed string, if a
 *      string needs to start with one of these, use a different delimiter
 *      character around the whole string.
 *
 * Each such line should contain the same number of Items, and will result
 * in an error if not. This is because PTXTP doesn't know in advance which
 * item line will be chosen and subsequent replacement lines can reference
 * any possible item.
 *
 * You do not HAVE to insert each item. The first item (~0) will be shown when
 * selecting an item list, and you may choose to use it as a list name which
 * is not actually inserted anywhere (although it can be).
 */
//: HiOut       '"Hi World"'    stdout
//: HiErr       '"Hi World"'    stderr
//: HelloOut    '"Hello World"' stdout
//: HelloErr    '"Hello World"' stderr
// Following the item lines, an SC with no items ends the list.
//:

main()
{
/*
 * After the end of the Item list, any lines beginning with SCs will
 * replace the line immediatly following (without the SC lead-in).
 *
 * In these lines, the character '~' has special meaning:
 *  ~0-~9       Insert item from selected Item line
 *  ~;          Premature EndOfLine
 *          Usefull if a single line-comment requires a closing sequence.
 *          eg: If you used "/*:", use "~;*/" to end
 *  ~~          Insert a single '~'
 */
//: fputs(~1, ~2);
    fputs("Hello World", stdout);
}

/*
 * Due to PTXTP rewriting changed files. The file is read into a 64k in-memory
 * buffer. I find this plenty for most text files that I want to so tweak, but
 * be aware that PTXTP may not work for very large files!
 *
 * Also, keep an archive of backup copies in case something "goes wrong" while
 * PTXTP is rewriting the file.
 */
