; 2nd state bootkoader
; This is loaded immediatly above the SNALL and DUMB 1st stage bootloader
; that you have to manually enter and run from the front panel.
;
; It provides Read/Write/Go functoons and all transfers are checksummd!
	ORG	$3100		Must be $100 above BOOT1
ENTRY	LXI	SP,*+255	Set stack at top of our 256 byte block
; Put any UART init needed code here
	MVI	A,'?'		Start prompt
	CALL	UTB		Send
main	CALL	URB		Get command
	MOV	C,A		Start checksum
	CPI	'W'		Write?
	JZ	WRITE
	CPI	'R'		Read?
	JZ	READ
	CPI	'G'
	JNZ	main		Go?
;
; Go to address
;
	CALL	RDADDR		; Get address
	PCHL			; Execute
; Read memory block LENGTH followed by ADDRESS
RDLEN	CALL	URB		; Get length
	MOV	B,A		; Save
	ADD	C		; Add to check
	MOV	C,A		; Resave
; Read HL address
RDADDR	CALL	URB		; Get high
	MOV	H,A		; Save
	ADD	C		; Add to check
	MOV	C,A		; Resave
	CALL	URB		; Get low
	MOV	L,A		; Save
	ADD	C		; Add to check
	MOV	C,A		; Resave
; Confirm checksum
CKC	CALL	URB		; Get value
	SUB	C		; Match?
	JNZ	ENTRY		; No - restart
	MOV	C,A		; New zero CK
	MVI	A,'='
	JMP	UTB
;
; Read a block of memory
;
READ	CALL	RDLEN		; Get length & address
rd1:	MOV	A,M		; Read byte from memory
	CALL	UTB		; Transmit
	ADD	C		; Add to check
	MOV	C,A		; Resave
	INX	H		; Next memory
	DCR	B		; more?
	JNZ	rd1		; Yes
	MOV	A,C		; Get checksum
	CALL	UTB		; Send it
	JMP	main
;
; Write block to memory
;
WRITE	CALL	RDLEN		; Get lenght & address
wr1	CALL	URB		; Get byte
	MOV	M,A		; Save in memory
	ADD	C		; Add to checksum
	MOV	C,A		; Resave
	INX	H		; Next memory
	DCR	B		; More?
	JNZ	wr1		; Yes
	CALL	CKC		; Confirn checksum
	JMP	main
;
; Mits serial I/O
;
USTAT	EQU	$08		; Uart STATUS port
UDATA	EQU	$09		; Uart DATA port
; Uart Read Byte
URB	IN	USTAT		; Read status
	ANI	$01		; Byte ready?
	JZ	URB		; No, wait
	IN	UDATA		; Read data
	RET
; Uart Transmit Byte
UTB:	PUSH	PSW		; Save A
utb1:	IN	USTAT		; Read status
	ANI	$02		; Ready to transmit
	JZ	utb1		; No
	POP	PSW		; Restore A
	OUT	UDATA		; Write data
	RET
