README  TXT  DMF     ASM 	  DISK    ASM %  TYPE    ASM   RENAME  ASM   CMD     ASM 2  CMDUTIL ASM
  BGND    ASM  NSTAR   ASM&                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  Note: This disk contains some of my earliest code - written a long time
      ago when I was much less experienced - please view accordingly.

This is the source to the DMF operating system and utilites.

To determine the address where a utility should be assembled, view the
directory listing of the DMF boot disk. Note that since the editor loads
at 0100, and uses a lot of memory when editing large source files, you
often have to place the assembled code at a different address than where
it will ultimately run.

Example rebuild of DISK command: (Boot DMF and mount DMFSRC1 in drive2)
  .EDIT DISK.ASM,2         <= Load source file
  .AE 100 D000             <= Asm for 100, put at D000
  .Q                       <= Exit editor
  .SAVE DISK.OBJ D000      <= Save new DISK image

Note when rebuilding DMF that it must be origined at EF00, due to the
UPI block occupying the first 256 bytes of the image:
  .EDIT DMF.ASM,2          <= Load source file
  .AE EF00 D000            <= Asm for EF00, put at D000
  .Q                       <= Exit editor
  .SAVE DOS.SYS D000       <= Save new DOS image
to the
UPI block occupying the first 256 bytes of the image:
  .EDIT DMF.ASM,2          <= Load source file
  .AE EF00 D000            <= Asm for EF00, put at D000
  .Q        *
*DMF OPERATING SYSTEM FOR NORTHSTAR MDS CONTROLLER BY D. DUNFIELD
*
Z0 EQU 0
DSKSIZ EQU 350 SIZE OF DISK (TOTAL SECTORS)
TRKSIZ EQU 10 SIZE OF TRACK IN SECTORS
BOOT EQU * ESTABLISH BASE FOR ADDRESS ADJUSTMENT
BOOT1 EQU BOOT+$E000 ADJUSTED BASE
*DSKROM: A=#BLKS B=TRACK C=DRIVE D=SECTOR E=01READ 00WRITE HL=RAMADDR
DSKROM EQU $E91E DISK CONTROLLER ENTRY POINT
*
*BOOT LOADS FIRST BLOCK (SECTOR 4 ON DISK) AT ADDRESS $2000 &
*JUMPS TO $2004
 DW $7F7F FILLER
 DW $7F7F FILLER
 JMP LODALL-BOOT1 EXECUTE BOOT BLOCK
*THIS LOCATION CONTAINS THE LAST DRIVE ON WHICH THE DIRECRORY WAS
*ACCESSED - THIS INDICATES WHAT DRIVE THE RAM COPY OF THE DIRECTORY
*APPLIES TO.
LSTDRV EQU *-BOOT LAST DIRECTORY ACCESSED
 DB 0
*RESTART 1 - RETURN TO DOS
RST1 EQU *-BOOT ADJUSTED ADDRESS (RST1)
 JMP CPENT ENTER DOS
*SET RESTART-1 ADDRESS
SETRST EQU *-BOOT ADJUSTED ADDRESS
 SHLD RST1+1 SET NEW RST-1 ADDRESS
 RET
 DB 0
*RST-2 SVC ENTRY POINT
 JMP SVC ENTER SVC (RST2)
TEMP EQU *-BOOT TEMP LOCATION USED DURING DISK ACCESS
*DB	0,0,0,0,0
 DW 0
 DW 0
 DB 0
*USER I/O ENTRY ENTRY POINTS
INIT EQU *-BOOT USER I/O INITIALZATION (RST3)
 JMP UINIT
*DB	0,0,0,0,0	; FILLER
 DW 0
 DW 0
 DB 0
IN EQU *-BOOT USER INPUT FUNCTION (RST4)
 JMP UIN
*DB	0,0,0,0,0	; FILLER
 DW 0
 DW 0
 DB 0
OUT EQU *-BOOT USER OUTPUT FUNCTION (RST5)
 JMP UOUT
*DB	0,0,0,0,0	; FILLER
 DW 0
 DW 0
 DB 0
CTRLC EQU *-BOOT USER TEST FUNCTION (RST6)
 JMP UCTRLC
OBJ EQU *-BOOT FIXED "OBJ" FOR EXE COMPARISON
 STR 'OBJ'
RWCHK EQU *-BOOT READ/WRITE CHECK FLAG
 DW 0
*RST-7 ENTRY POINT
RST7 JMP $E900 RELOAD DOS
*SVC HANDLER TABLE
SVCTAB EQU *-BOOT
 DW $E900 0  REBOOT
 DW CTRLC 1  TEST FOR CHARACTER/CTRL-C
 DW CONIN 2  CONSOLE INPUT
 DW CONOUT 3  CONSOLE OUTPUT
 DW IN 4  GENERAL INPUT
 DW OUT 5  GENERAL OUTPUT
 DW LFCR 6  OUTPUT LFCR
 DW SPACE 7  OUTPUT SPACE
 DW WRLINE 8  WRITES A MESSAGE
 DW HEXOUT 9  HEX OUTPUT (BYTE)
 DW PRHEX 10 HEX OUTPUT (WORD)
 DW PRDEC 11 DECIMAL OUTPUT
 DW GETLIN 12 GET LINE FROM CONSOLE
 DW NODOT 13 GET LINE WITHOUT PROMPT
 DW SKIP 14 SKIP TO NON BLANK
 DW GETHEX 15 GET HEX VALUE
 DW GETDEC 16 GET DECIMAL VALUE
 DW GETNAM 17 GET FILENAME
 DW VALID 18 TEST FOR VALID FILENAME
 DW GETVAL 19 GET VALID FILENAME
 DW COMNAM 20 COMPARE NAME
 DW DIREAD 21 READ DIRECTORY INTO BUFFER
 DW DIRITE 22 WRITE DIRECTORY FROM BUFFER
 DW LOCRAM 23 LOCATE NAME IN RAM DIRECTORY
 DW LOCDIR 24 READ DIR AND LOCATE NAME
 DW GETFIL 25 GET DISK PARAMETERS FROM DIRECTORY ENT.
 DW LFILE 26 GET DISK PARAMETERS FROM FILENAME
 DW DCOM 27 PERFORM DISK COMMAND (ANY DRIVE)
 DW CMDISK 28 PERFORM DISK COMMAND (FILE DRIVE)
 DW SVCDRV 29 SET DOS DRIVE (FOR 21, 22)
SVC30 EQU *-BOOT RECORD POSITION SO WE CAN PATCH
 DW CPENT 30 REENTER DOS
 DW COMND 31 SHELL TO DOS
 DW CPEX 32 EXECUTE DOS COMMAND
 DW DIR 33 DISPLAY DIRECTORY
 DW SETRST 34 SET RST-1 ADDRESS
 DW SETDEV 35 SET CONSOLE OUTPUT DEVICE
 DW LCMD 36 TABLE LOOKUP
 DW FINADR 37 FIND FREE DISK ADDRESS
 DW FINDET 38 FIND AVAILABLE DIRECRORY ENTRY
 DW SET30 39 SET SVC-30 ADDRESS (TAKE OVER DOS RETURN)
 DW SVCDEF 40 SET DEFAULT DRIVE
 DW GETOBJ 41 GET FILENAME (NO TYPE)
NUMSVC EQU 42 NUMBER OF VALID SVC'S
*
*LOAD REMAINDER OF DOS INTO HIGH MEMORY
*
LODALL LXI SP,STACK INITIAL STACK
*FIRST READ UPI BLOCK INTO MEMORY AT 0000
 MVI A,1 ONE BLOCK
 LXI B,1 TRACK 0, DRIVE 1
 LXI D,$0401 SECTOR 4, READ
 LXI H,0 INTO RAM AT ZERO
 CALL DSKROM READ ZERO BLOCK
 JNZ LODALL-BOOT1 RETRY ON FAILURE
*THEN LOAD REMAINDER OF TRACK 0 INTO DOS AREA
 MVI A,5 5 BLOCKS
 LXI B,1 TRACK 0, DRIVE 1
 LXI D,$0501 SECTOR 5, READ
 LXI H,CP LOAD ADDRESS
 CALL DSKROM READ FIRST PART OF DOS
 JNZ LODALL-BOOT1 RETRY ON FAILURE
*FINALLY, LOAD REMAINDER OF DOS FROM TRACK 1
 MVI A,6 6 BLOCKS
 LXI B,$101 TRACK 1, DRIVE 1
 LXI D,1 SECTOR 0, 1
 LXI H,CP+$500 NEXT BLOCK
 CALL DSKROM READ SECOND PART OF DOS
 JNZ LODALL-BOOT1 RETRY ON FAILURE
 JMP CP ENTER OS
*SUPERVISOR CALL ENTRY POINT
SVC EQU *-BOOT
 SHLD TEMP+1 SAVE HL
 LXI H,0 START WITH ZERO
 DAD SP GET SP
 SHLD CPLOOP+1 SET DOS SP BELOW USER
 POP H GET RETURN ADDRESS
 INX H SKIP OPERAND
 PUSH H STACK IT
 DCX H BACK TO OPERAND
 PUSH PSW SAVE AF
 MOV A,M GET OPERAND
 CPI NUMSVC IN RANGE?
 JNC BADSVC REPORT BAD SVC REQUEST
 ADD A DOUBLE FOR 2BYTE ENTRIES
 LXI H,SVCTAB POINT TO TABLE
 ADD L OFFSET INTO TABLE
 MOV L,A RESET NEW ADDRESS
 MOV A,M GET LOW ADDRESS
 INX H SKIP TO HIGH
 MOV H,M GET HIGH ADDRESS
 MOV L,A SET LOW ADDRESS
 POP PSW RESTORE A
 PUSH H SAVE ADDRESS
 LHLD TEMP+1 RESTORE HL
 RET  CALL HANDLER
*DB	0,0,0,0,0
 DW 0
 DW 0
 DB 0
*BUFFERED FILENAME - INIT TO STARTUP FILENAME
NAME EQU *-BOOT
 STR 'IPLSTART'
TYPE EQU *-BOOT
 STR 'OBJ'
*ACTIVE DRIVE
DRIVE EQU *-BOOT
 DB 1
*USER DATA FIELD ASSOCIATED WITH FILENAME
UDAT EQU *-BOOT
 DW 0
*
*OS DATA AREAS
*
DISK EQU *+$C00 ADDRESS OF DISK BUFFER
STACK EQU DISK OS STACK IS JUST BELOW
BUFFER EQU STACK-256 GENERAL OS BUFFER
*
*BEGINNING OF OS CODE IN HIGH MEMORY
*
CP LXI SP,STACK INITIALIZE STACK
 CALL INIT INITIALIZE I/O DEVICES
 CALL WRIMSG OUTPUT MESSSAGE
*SINCE WE ONLY USE THIS ONCE - BORROW IT FOR TEMP STORAGE
 STR 'DMF-80/ST 1.0' START CODE
CR DB 13 TERMINATE MSG + NULL LINE ADDRESS
 CALL LOCDIR LOCATE IPLSTART.OBJ
 LXI D,CR NULL COMMAND LINE (NO OPERANDS)
 JZ PROF EXECUTE IPLSTART.OBJ IF FOUND
*MAIN COMMAND INTERPRETER
RER LXI SP,STACK RESET STACK IN CASE WE GOT HERE BY ERROR
 CALL COMD1 EXECUTE COMMAND SHELL
 JMP RER IF IT RETURNS - RELAUNCH
*
*BAD SVC REQUEST
BADSVC CALL WRIMSG DISPLAY MESSAGE
 STRZ 'BAD SVC AT '
 DCX H BACKUP TO OFFENDING SERVICE ID
 CALL PRHEX DISPLAY ADDRESS
 CALL LFCR NEW LINE
 ORI $FF INSURE NOT ZERO
PROF CZ EXECPR EXECUTE IPLSTART.OBJ ON FIRST CALL
*DISPLAY RETURN CODE & RE-ENTER DOS
CPENT LXI SP,STACK RESET STACK
 LXI H,RER RETURN HERE
 PUSH H FAKE RETURN ADDRESS
 JMP RETURN DISPLAY CODE & ENTER COMMAND LOOK
*EXECUTE PROGRAM
EXECPR PUSH D SAVE D
 JMP RUNPRF AND RUN THE PRGORAM
*INDICATE ENTERING COMMAND INTERPRETER WITH PROMPT
COMND CALL WRIMSG OUTPUT MESSAGE
 STR 'DMF:' TEXT
 DB $0D NEW LINE & TERMINATE
*GET A COMMAND LINE & EXECUTE
COMD1 CALL GETLIN GET INPUT LINE
 CPI $0D NULL LINE?
 JZ COMND YES, REPROMPT
 PUSH D SAVE POINTER
 CALL CMD LOOKUP COMMAND
 POP D RESTORE POINTER
 ANA A 'RETURN'
 RZ  YES, EXIT SHELL
 CALL CPEX EXECUTE COMMAND
*DISPLAY RETURN INDICATOR
RETURN MOV L,A GET RETURN CODE
 MVI H,0 ZERO HIGH
 MVI A,'R' GET INDICATOR
 CALL CONOUT DISPLAY
 MOV A,L GET RETURN CODE BACK
 ANA A TEST
 JZ SEMI ZERO - NOT NUMERIC DISPLAY
 MVI A,'(' OPENING BRACE
 CALL CONOUT DISPLAY
 CALL PRDEC DISPLAY RETURN CODE VALUE
 MVI A,')' CLOSING BRACE
 CALL CONOUT DISPLAY
SEMI CALL WRIMSG DISPLAY CLOSING MESSAGE
 STR ';' SEMICOLON
 DB $0D NEWLINE & TERMINATE
 JMP COMD1 AND GET NEXT COMMAND
*ISSUE NEWLINE AND GET AN INPUT LINE
NEWIN CALL LFCR NEW LINE
*GET AN INPUT LINE FROM THE CONSOLE WITH '.' PROMPT
GETLIN MVI A,'.' PROMPT
 CALL OUT0 DISPLAY ON CONSOLE
*GET AN INPUT LINE FROM THE CONSOLE
NODOT LXI D,BUFFER POINT TO INPUT BUFFER
GET1 MOV A,E GET OFFSET
 ANA A TEST
 JM NEWIN BACKUP PAST BEGINNING
 CALL CONIN GET INPUT
 CPI $7F DELETE?
 JNZ GET2 NO, NORMAL
 MVI A,8 TRANSLATE TO BACKSPACE
 CALL OUT0 DISPLAY
 MVI A,' ' WIPE OUT CHAR
 CALL OUT0 DISPLAY
 MVI A,8 TRANSLATE TO BACKSPACE
GET2 CALL OUT0 DISPLAY ON CONSOLE
 CPI 3 CONTROL-C?
 JZ NEWIN YES, RESET INPUT
 DCX D BACKUP POINTER (ASSUME BACKSPACE)
 CPI 8 BACKSPACE (RUB-OUT)
 JZ GET1 YES, USE NEW POINTER
 INX D CORRECT BAD ASSUMPTION
 STAX D SAVE CHARACTER
 INX D ADANCE IN BUFFER
 CPI $0D END OF LINE?
 JNZ GET1 NO, GET NEXT CHARACTER
 MVI A,$0A LINE-FREE
 CALL OUT0 SEND TO CONSOLE
 LXI D,BUFFER POINT TO BUFFER
 LDAX D GET FIRST CHAR FROM BUFFER
 RET
*WRITE MESSAGE [PC] TO CONSOLE
WRIMSG XTHL  GET PC - SAVE HL
 CALL WRLINE OUTPUT MESSAGE
 XTHL  RESTORE HL - SET NEW RETURN ADDRESS
 RET
*WRITE A LINE [HL] TO THE CONSOLE
WRLINE MOV A,M GET BYTE FROM LINE
 INX H ADVANCE TO NEXT
 ANA A END OF LINE (NO LFCR)?
 RZ  YES, STOP
 CALL CONOUT DISPLAY
 CPI $0D END OF LINE (LFCR)?
 JNZ WRLINE NO, KEEP DISPLAYING
*DISPLAY LF/CR ON CONSOLE
LFCR MVI A,$0A GET LF
 CALL CONOUT DISPLAY
 MVI A,$0D GET CR
 CALL CONOUT DISPLAY
 CALL CTRLC TEST FOR CONTROL-C
 JZ LFCC YES - HANDLE IT
 CPI $0A LINE-FEED (PAUSE OUTPUT)?
 RNZ  NO, IT'S OK
CTRLS CALL CONIN WAIT FOR CHARACTER
 CPI $0D CARRIAGE RETURN?
 RZ  YES, PROCEED
 CPI 3 CTRL-C?
 JNZ CTRLS NO, WAIT FOR IT
*
*CONTROL-C HAS BEEN ENCOUNTERED
*
LFCC CALL WRIMSG OUTPUT MESSAGE
 STR '^C' TEXT
 DB $0D NEWLINE
 MVI A,7 DOS RETURN CODE (CTRL-C)
 JMP FIXUP TERMINATE / RETURN TO CALLER
*SET SVC 30 ADDRESS
SET30 MOV A,H GET VALUE
 ANA A IS IT ZERO
 JNZ NODEF NO, KEEP THIS VALUE
 LXI H,CPENT 0 = ENTRY POINT
NODEF SHLD SVC30 SAVE NEW ENTRY POINT
 RET
*DISPLAY A SPACE ON THE CONSOLE
SPACE PUSH PSW SAVE A
 MVI A,' ' GET SPACE
 CALL CONOUT DISPLAY
 POP PSW RESTORE A
 RET
*LOOKUP WORD [DE] IN COMMAND TABLE
CMD LXI H,TAB POINT TO COMMAND TABLE
*LOOKUP WORD [DE] IN TABLE [HL]
LCMD MVI B,0 BEGIN WITH ENTRY #0
 CALL SKIP SKIP TO NON-BLANK
TLP0 PUSH D SAVE POSITION
 MOV A,M FLAG BYTE
 ANI $7F REMOVE HIGH BIT MARKER
 JZ OKCMD END OF TABLE
 MOV C,A SAVE LENGTH
CMDL INX H NEXT BYTE IN TABLE
 DCR C REDUCE LENGTH
 LDAX D GET DATA FROM INPUT WORD
 CALL TSPCR END OF WORD?
 JZ GTST YES, SEE IF WE MATCHED ENOUGH
 CMP M DOES IT MATCH TABLE?
 INX D SKIP TO NEXT
 JZ CMDL YES, KEEP LOOKING
*WORD DID NOT MATCH - SKIP TO NEXT TABLE ENTRY
NOVAL POP D RESTORE POSTION
 INR B ADVANCE ENTRY NUMBER
CMD1 MOV A,M GET BYTE FROM TABLE
 ANA A TEST
 INX H ADVANCE TO NEXT
 JP CMD1 GO TILL ENTRY OF ENTRY
 DCX H BACKUP TO FLAG
 JMP TLP0 AND TEST THIS ONE
*WORD ENDED - SEE IF WE HAVE ENOUGH TO DECLARE A MATCH
GTST ORA C ENOUGH?
 JP NOVAL NO, TRY NEXT ONE
OKCMD CALL SKIP SKIP TO NEXT WORK
 MOV A,B GET ENTRY NUMBER
 POP H CLEAN STACK
 RET
*COMMAND LOOKUP TABLE
*EACH ENTRY BEGINS WITH A FLAG BYTE WHICH HAS THE HIGH BIT SET TO
*INDICATE A NEW ENTRY, AND THE REMAINING BITS INDICATE THE MINIMUM
*MATCH LENGTH WHICH IS ACCEPTED. ($80 INDICATES END OF LIST).
TAB DB $82
 STR 'RETURN'
 DB $83
 STR 'DIRECT'
 DB $82
 STR 'CREATE'
 DB $83
 STR 'DELETE'
 DB $82
 STR 'LOAD'
 DB $82
 STR 'SAVE'
 DB $82
 STR 'JUMP'
 DB $82
 STR 'RUN'
 DB $82
 STR 'READ'
 DB $82
 STR 'WRITE'
 DB $83
 STR 'DISPLAY'
 DB $82
 STR 'STORE'
 DB $82
 STR 'SET'
 DB $82
 STR 'OUTPUT'
 DB $82
 STR 'DRIVE'
 DB $80
*DISPLAY A DECIMAL NUMBER[DE], FORMATTED INTO A FIELD
FMTDEC LXI B,99 GREATER THAN 99?
 CALL NCOMP COMPARE
 CNC SPACE NO, OUTPUT SPACE
 MVI C,9 GREATER THAN 9
 CALL NCOMP COMPARE
 CNC SPACE NO, OUTPUT SPACE
 XCHG  HL = NUMBER
*DISPLAY HL IN DECIMAL WITHOUT CORRUPTING REGISTERS
PRDEC PUSH D SAVE DE
 PUSH B SAVE BC
 PUSH H SAVE HL
 CALL DECPRT OUTPUT IN DECIMAL
 POP H RESTORE HL
 POP B RESTORE BC
 POP D RESTORE DE
 RET
*ADVANCE TO NEXT NON-SPACE CHARACTER IN LINE
SKIP LDAX D GET CHARACTER
 CPI $0D CR?
 RZ  YES, STOP
 CPI ' ' SPACE
 RNZ  YES, STOP
 INX D NEXT CHARACTER
 JMP SKIP KEEP LOOKING
*ADVANCE TO NEXT SPACE OR CR
ADVNC CALL TLDAXD GET CHAR/TEST FOR SP/CP
 RZ  FOUND IT
 INX D NEXT CHARACTER
 JMP ADVNC KEEP LOOKING
*LOAD INDIRECT FROM D AND CHECK FOR SPACE OR CR (LINE END)
TLDAXD LDAX D GET CHARACTER
*TEST CHARACTER IN A FOR SPACE OR CR (LINE END)
TSPCR CPI ' ' SPACE?
 RZ  YES, EXIT WITH Z
 CPI $0D CR?
 RET
*GET A DECIMAL NUMBER FROM THE INPUT LINE
GETDEC CALL SKIP SKIP TO NON-BLANK
 JZ BADOPR END OF LINE - FAIL
 CALL ADVNC ADVANCE TO END OF WORD
 PUSH B SAVE BC
 PUSH D SAVE POSITION
 LXI B,1 BEGIN WITH DIGIT=1
 LXI H,0 BEGIN WITH ZERO
ETOP DCX D BACKUP TO PREV. CHARACTER
 LDAX D GET CHARACTER
 CPI ' ' BEGINNING OF OPERAND?
 JZ DECEND YES, WE HAVE IT ALL
 CALL NUM VALID NUMBER?
 JC BADOPR NO, REPORT ERROR
 ANI $0F CONVERT TO 0-9 BINARY
ZLOOP DCR A REDUCE COUNT
 JM ESP1 ALL DONE
 DAD B ADD DIGIT
 JMP ZLOOP DO THEM ALL
*MULTIPLY DIGIT VALUE BY 10
ESP1 PUSH H SAVE HL
 MOV H,B GET DIGIT VALUE
 MOV L,C ""
 DAD B X2
 DAD H X4
 DAD B X5
 DAD H X10
 MOV B,H RESAVE DIGIT VALUE
 MOV C,L ""
 POP H RESTORE HL
 JMP ETOP DO NEXT
DECEND POP D RESTORE POSITION (AT END)
 POP B RESTORE BC
ZERO SUB A RETURN CODE=0
 RET
*TEST FOR A BEIGN A VALID DECIMAL NUMBER '0'-'9'
NUM CPI '0' TEST FOR < 0
 RC  YES, RETURN C=1 (BAD)
 CPI $3A TEST FOR < 10
 CMC  COMPLIMENT C=1 IF BAD
 RET
*GET A HEX VALUE FOR HL
GETHEX CALL SKIP SKIP TO NON-BLANK
 JZ BADOPR REPORT ERROR
 LXI H,0 BEGIN WITH ZERO
TOPHEX CALL TLDAXD GET CHARACTER FROM COMMAND
 JZ ZERO ALL DONE
 INX D SKIP TO NEXT
 CALL NUM VALID NUMBER?
 JNC HEXOK YES - ALSO VALID HEX
 CPI 'A' VALID HEX?
 JC BADOPR NO - FAIL
 CPI 'G' VALID HEX?
 JNC BADOPR NO - FAIL
 SUI 7 CONVERT TO NUMBER OFFSET 11-15
HEXOK SUI $30 CPNVERT TO BINARY 0-15
 DAD H X2
 DAD H X4
 DAD H X8
 DAD H X16
 ORA L INSERT INTO LOW ORDER DIGIT
 MOV L,A AND RESAVE
 JMP TOPHEX DO THEM ALL
*DISPLAY VALUE [HL] IN HEX
PRHEX MOV A,H GET HIGH BYTE
 CALL HEXOUT DISPLAY
 MOV A,L GET LOW BYTE
*DISPLAY VALUE [A] IN HEX
HEXOUT PUSH PSW SAVE VALUE
 RRC  ROTATE
 RRC  HIGH NIBBLE
 RRC  INTO
 RRC  LOW NIBBLE
 CALL HOUT DISPLAY HIGH NIBBLE
 POP PSW RESTORE VALUE
HOUT ANI $F SAVE ONLY LOW NIBBLE
 ADI $30 COVERT TO PRINTABLE
 CPI $3A NUMERIC?
 JC CONOUT OK TO PRINT
 ADI 7 ADJUST 'A'-'F' TO CORRECT
 JMP CONOUT AND DISPLAY
*WRITE DIRECTORY FROM DISK BUFFER
DIRITE SUB A DISK WRITE COMMAND
 JMP DIRECT AND PERFORM COMMAND
*READ DIRECTORY INTO DISK BUFFER
DIREAD MVI A,1 DISK READ COMMAND
DIRECT STA DICMD+1 SAVE COMMAND
 PUSH D SAVE D
 LXI D,DISK POINT TO DISK BUFFER
 LXI H,0 DISK ADDRESS = 0
 MVI A,4 4 SECTORS
DICMD MVI B,1 SET DISK OPERATION
 CALL CMDISK PERFORM DISK OPERATION
 POP D RESTORE D
 LDA DRIVE GET DRIVE ACCESSED
 STA LSTDRV SET LAST DRIVE (DIRECTORY)
 LXI H,DISK POINT TO DISK AREA
 SUB A ZERO RETURN CODE
 RET
*PERFORM A DISK COMMAND
CMDISK PUSH PSW SAVE A
 LDA DRIVE GET DISK DRIVE
 MOV C,A C = DRIVE
 POP PSW RESTORE A
 JMP DCOM PERFORM DISK COMMAND
*GET FILENAME FROM COMMAND LINE
GETNAM MVI A,1 GET DRIVE NUMBER
 STA DRIVE SET DRIVE
 CALL SKIP SKIP TO OPERAND
 LXI H,NAME POINT TO NAME
 MVI B,8 SAVE 8 CHARACTERS
GNAM1 LDAX D GET VALUE
 INX D SKIP TO NEXT
 CPI '.' SEPARATOR?
 JZ FILL YES, MOVE ON TO TYPE
 CPI $0D END OF LINE?
 JZ BADOPR YES, BAD NAME
 MOV M,A SAVE CHARACTER IN NAME
 INX H NEXT LOCATION IN BUFFER
 DCR B REDUCE COUNT OF REMAINING CHARS
 JP GNAM1 DO THEM ALL
 JMP BADOPR MORE THAN 8 CHARS - ERROR
FILL MOV A,B GET COUNT
 CPI 8 ANY DATA ENTERED?
 JZ BADOPR NO, BAD NAME
 CALL PAD PAD WITH BLANKS
 MVI B,3 TYPE IS 3 CHARACTERS
GTYP1 CALL TLDAXD GET DATA FROM BUFFER
 JZ TYPDUN FINISHED WITH TYPE
 INX D SKIP TO NEXT IN SOURCE
 CPI ',' DRIVE SPECIFIED?
 JZ GETDRV YES, HANDLE IT
 MOV M,A SAVE IN BUFFER
 INX H SKIP TO NEXT IN BUFFER
 DCR B REDUCE COUNT
 JP GTYP1 DO THEM ALL
 JMP BADOPR MORE THAN 3 CHARS - ERROR
*DRIVE HAS BEEN SPECIFIED
GETDRV LDAX D GET DRIVE ID
 INX D SKIP TO NEXT
 CALL VALDRV VALIDATE & STORE DRIVE
TYPDUN CALL PAD PADD TYPE WITH BLANKS
 LXI H,NAME POINT TO NAME
 LDA DRIVE GET DRIVE
 MOV C,A C = DRIVE
 SUB A ZERO RETURN
 RET
*PAD BUFFER WITH SPACES FOR LENGTH IN B
PAD DCR B REDUCE COUNT
 RM  ALL DONE
 MVI M,' ' PAD WITH ONE SPACE
 INX H MOVE TO NEXT
 JMP PAD DO THEMN ALL
*COMPARE NAME [HL] WITH BUFFERED FILENAME
COMNAM PUSH H SAVE HL
 PUSH B SAVE BC
 PUSH D SAVE DE
 LXI D,NAME POINT TO NAME
 MVI C,8 TEST 8 CHARACTERS
 CALL COMX COMPARE
 JNZ EXIT NO MATCH - FAIL
 MVI B,0 SKIP TO END
 DAD B IN SOURCE
 LXI D,TYPE POINT TO TYPE
 MVI C,3 TEST 3 CHARACTERS
 CALL COMX COMPARE
EXIT POP D RESTORE DE
 POP B RESTORE BC
 POP H RESTORE HL
 RET
*COMPARE [DE] WITH [HL] FOR LEGNTH
COMX LDAX D GET DATA FROM SOURCE
 INX D SKIP TO NEXT
 CPI '*' WILDCARD MATCHES ANYTHING
 RZ  ALLOW IT
 CMP M MATCH BUFFER?
 RNZ  NO, INDICATE FAIL
 INX H SKIP TO NEXT
 DCR C REDUCE COUNT
 JNZ COMX DO THEM ALL
 RET
*GET A FILENAME AND INSURE IT IS VALID.
GETVAL CALL GETNAM GET FILENAME
*INSURE BUFFERED FILENAME IS VALID
VALID LXI H,NAME POINT TO NAME
 MOV A,M GET DATA FROM NAME
 CPI '@' TEST VALID CHAR
 JC BADOPR BAD CHAR
 CPI $5B TEST VALID CHAR
 JNC BADOPR BAD CHAR
 MVI B,11 TEST 11 CHARACTERS
VLP1 MOV A,M GET DATA
 INX H SKIP TO NEXT
 CPI '*' WILDCARD?
 JZ BADOPR BAD
 CPI ',' DRIVE SEPARATOR?
 JZ BADOPR BAD
 CPI '.' TYPE SEPARATOR?
 JZ BADOPR BAD
 DCR B REDUCE COUNT
 JNZ VLP1 DO THEM ALL
 LXI H,NAME POINT TO NAME
 SUB A ZERO RETURN CODE
 RET
*TEST FOR AN OBJECT FILE EXTENSION
TSTOBJ PUSH D SAVE DE
 PUSH H SAVE HL
 MVI C,3 TEST 3 CHARACTERS
 LXI D,OBJ POINT TO 'OBJ'
 CALL COMX TEST IT
 POP H RESTORE HL
 POP D RESTORE DE
 RET
*LOCATE AN EMPTY DIRECTORY ENTRY
FINDET LXI H,DISK POINT TO BUFFERED DIRECTORY
 LXI B,16 16 BYTES/ENRY
ET1 MOV A,M GET ENTRY
 SBI ' ' IS THIS EMPTY?
 RZ  YES
 DAD B SKIP TO NEXT
 MOV A,H GET HIGH
 CPI =DISK+1024 ARE WE AT END?
 JNZ ET1 NO - KEEP GOING
 MVI A,5 "DIRECTORY FULL"
 ANA A CLEAR Z
 RET
*
*LOCATE FILENAME IN DIRECTORY FROM DISK
*
LOCDIR CALL DIREAD READ DIRECTORY INTO RAM
*
*LOCATE FILENAME IN DIRECTORY IN RAM
*
LOCRAM LXI H,DISK POINT TO DISK AREA
 MVI B,64 MAX. 64 ENTRIES
LOC0 MOV A,M GET CHARACTER FROM DISK
 CPI ' ' USED?
 JZ LOC9 NO, SKIP TO NEXT
 CALL COMNAM COMPARE NAME
 MVI A,0 ASSUME SUCCES
 RZ  AND EXIT IF SO
*NOT THIS ENTRY - ADVANCE TO NEXT
LOC9 MOV A,L GET LOW ADRESS
 ADI 16 OFFSET BY DIR SIZE
 MOV L,A RESAVE
 JNC LOC1 NO CARRY OVER
 INR H ADVANCE HIGH
LOC1 DCR B REDUCE ENTRY COUNT
 JNZ LOC0 MORE TO CHECK
 MVI A,2 INDICATE "FILE NOT FOUND"
 ANA A SET ZF
 RET
*
*LOCATE FREE DISK ADDRESS
*
FINADR LXI H,DISK POINT TO DIRECTORY IN RAM
 LXI B,4 START HIGH-WATER MARK AT FIRST AVAIL.
FLP MOV A,M GET ENTRY
 CPI ' ' USED?
 JZ FLNXT NO, SKIP
 LXI D,11 OFFSET TO DISK ADDRESS
 DAD D ADJUST POINTER
 MOV D,M GET DISK ADDRESS (HIGH)
 INX H NEXT
 MOV E,M GET DISK ADDRESS (LOW)
 INX H NEXT
 PUSH H SAVE HL
 MOV L,M GET SIZE
 MVI H,0 ZERO HIGH
 DAD D CALCULATE NEXT FREE
 XCHG  DE = NEXT FREE
 POP H RESTORE HL
 CALL NCOMP IS IT GREATER?
 INX H SKIP SIZE
 INX H SKIP UDATA-1
 INX H SKIP UDATA-2
 JNC NXTST NOT HIGHER
 MOV B,D SET NEW HIGH WATER
 MOV C,E MARK TO THIS ADDRESS
 JMP NXTST AND TEST THE NEXT
*SKIP TO NEXT DIRECTORY ENTRY
FLNXT LXI D,16 SIZE OF DIRECTORY ENTRY
 DAD D ADVANCE POINTER
NXTST MOV A,H GET HIGH ADDRESS
 CPI =DISK+1024 ARE WE AT END OF DIRECTORY?
 JNZ FLP NO, KEEP LOOKING
 MOV H,B GET FREE ADDRESS
 MOV L,C "" ""
 RET
*COMPARE BC AND DE
NCOMP MOV A,B GET HIGH
 CMP D SAME?
 RNZ  NO - ALL WE NEED
 MOV A,C GET LOW
 CMP E COMPARE
 RET
*
*GET DISK PARAMETERS FROM DIRECTORY ENTRY
*
GETFIL PUSH B SAVE RAM ADDRESS
 JMP LFIL1 AND CONTINUE
*
*GET LOAD/SAVE OPERANDS: FILENAME + MEMORY ADDRESS & OBTAIN DISK PARAMETERS
*
GETOP CALL GETVAL GET FILENAME
 CALL GETHEX GET DISK ADDRESS
*
*GET DISK PARAMETERS FROM BUFFERED FILENAME
*
LFILE PUSH H SAVE RAM ADDRESS
 CALL LOCDIR LOOKUP FILE IN DIRECTORY
 JNZ NOFILE NOT FOUND.
LFIL1 LXI D,11 OFFSET TO DISK ADDRESS
 DAD D ADVANCE POINTER
 MOV D,M GET HIGH ADDRESS
 INX H NEXT
 MOV E,M GET LOW ADDRESS
 INX H NEXT
 LDA DRIVE GET DRIVE
 MOV C,A SET IN C FOR DISK PARM CALL.
 MVI B,1 READ COMMAND
 MOV A,M GET SIZE
 XCHG  HL = DISKADDR
 POP D DE = RAMADDR
 RET
*READ DATA FROM CONSOLE
CONIN SUB A DEVICE 0
 CALL IN CALL INPUT
 CPI $61 LOWER CASE?
 RC  NO - OK
 CPI $7B LOWER CASE?
 RNC  NO - OK
 ANI $DF COVERT TO UPPER CASE
 RET
*WRITE CHARACTER IN A TO CONSOLE
OUT0 PUSH B SAVE B
 MOV B,A B = OUTPUT CHARACTER
 CPI 8 BACKSPACE?
 JZ OUTOK OK TO SEND
 CPI 13 CR?
 JZ OUTOK OK TO SEND
 CPI 10 LF?
 JZ OUTOK OK TO SEND
 CPI ' ' SPACE
 JNC OUTOK OK TO SEND
 MVI A,'^' CONTROL INDICATOR
 CALL OUT0 OUTPUT
 MOV A,B GET CHARACTER
 ADI $40 CONVERT TO PRINTEBLE
 CALL OUT0 DISPLAY IT
 MOV A,B RESTORE CHARACTER
 POP B RESTORE BC
 RET
*OK TO OUTPUT "NORMAL" CHARACTER
OUTOK SUB A GET ZERO
 CPI 1 INSURE Z CLEAR
 JMP OUTF AND OUTPUT
*
*DISPLAY NUMBER HL IN DECIMAL
*
DECPRT LXI B,$FFF6 BEGIN WITH -10
DPL0 MOV D,B -1
 MOV E,B -1
DPL1 DAD B ADD 10
 INX D
 JC DPL1 NOT THERE YET
 MVI A,$3A '0'+10
 ADD L CONVERT TO PRINTABLE DIGIT
 PUSH PSW SAVE FOR LATER
 XCHG  HL = HL/10
 MOV A,H GET VALUE
 ORA L MORE TO GO?
 CNZ DPL0 YES, OUTPUT IN CORRECT ORDER (RECURSE)
 POP PSW RESORE OUTPUT CHARACTER
*DISPLAY CHARACTER IN A ON CONSOLE
CONOUT PUSH B SAVE BC
 MOV B,A B = OUTPUT
ODEV MVI A,0 DEVICE = 0
 CPI $FF SPECIAL CASE - NULL OUTPUT
OUTF CNZ OUT NO - CALL OUTPUT FUNCTION
 MOV A,B RESTORE CHARACTER
 POP B RESTORE BC
 RET
*GET READ/WRITE PARAMETERS FROM COMMAND LINE
REAWRI CALL SKIP SKIP TO NON-BLANK
 CALL VALDRV VALIDATE & STORE DRIVE
 INX D SKIP
 CALL GETDEC GET SECTOR NUMBER
 PUSH H SAVE
 CALL GETDEC GET # BLOCKS
 MOV A,L INTO A
 PUSH PSW SAVE
 CALL GETHEX GET RAM ADDRESS
 XCHG  DE = RAMADDR
 POP PSW RESTORE # BLOCKS
 POP H HL = DISKADDR
 RET
*SET CONSOLE OUTPUT DEVICE FROM COMMAND LINE
SDEV CALL GETDEC GET DEVICE NUMBER
 MOV A,L INTO A
*SET CONSOLE OUTPUT DEVICE TO VALUE IN A
SETDEV STA ODEV+1 SAVE DEVICE NUMBER
 SUB A INDICATE SUCCESS
 RET
*
*EXECUTE A DOS COMMAND
*
CPEX LXI H,0 START WITH ZERO
 DAD SP GET SP
 SHLD CPLOOP+1 SET DOS SP
CPLOOP LXI SP,0 RESET SP IN CASE ERROR
 CALL CMD GET COMMAND & LOOKUP
 ANA A 'RETURN'?
 RZ  YES - EXIT
 DCR A 'DIR'?
 JZ DIR YES - DISPLAY DIRECTORY
 DCR A 'CREATE'?
 JZ CREATE YES - CREATE FILE
 DCR A 'DELETE'?
 JZ DELETE YES - DELETE FILE
 DCR A 'LOAD'?
 JZ LOAD YES - LOAD FILE
 DCR A 'SAVE'?
 JZ SAVE YES - SAVE FILE
 DCR A 'JUMP?
 JZ JUMP YES - JUMP TO PROGRAM
 DCR A 'RUN'
 JZ RUN YES - EXECUTE PRGORAM
 DCR A 'READ'
 JZ HREAD YES - READ DISK
 DCR A 'WRITE'
 JZ HWRITE YES - WRITE DISK
 DCR A 'DISPLAY'
 JZ DISP YES - DISPLAY MEMORY
 DCR A 'STORE'
 JZ STOR YES - STORE INTO MEMORY
 DCR A 'SET'
 JZ SETCMD HANDLE 'SET' FUNCTIONS
 PUSH D SAVE COMMAND LINE POINTER
 CALL GETOBJ GET OBJECT FILENAME
 LDA DRIVE GET DRIVE
 MOV B,A SAVE
 LDA LSTDRV GET LAST DRIVE
 CMP B SAME?
 CNZ DIREAD NO, READ DIRECTORY
 CALL LOCRAM LOCATE FILE IN RAM
 POP D RESTORE COMMAND LINE POINTER
 JZ RUN FILE WAS FOUND - EXECUTE
*DOS COMMAND WAS NOT RECOGNIZED
UNKN CALL WRIMSG OUTPUT MESSAGE
 STR 'UNKNOWN DMF COMMAND'
 DB $0D NEW LINE
 ORI $FF RETURN 255 (ZF CLEAR)
 RET
*DOS COMMAND HAD A BAD OPERAND
BADOPR CALL WRIMSG OUTPUT MESSAGE
 STR 'OPERAND MISSING OR INVALID'
 DB $0D NEW LINE
 MVI A,1 RETURN CODE
*RESTORE SP AND RETURN TO CALLER WITH RETURN CODE IN A
FIXUP LHLD CPLOOP+1 GET SAVED SP
 SPHL  SET SP
 ANA A TEST RETURN CODE
 RET
*
*DISPLAY DIRECTORY OF DISK
*
DIR MVI A,1 ASSUME DRIVE
 STA DRIVE SET DEFAULT DRIVE
 MVI A,'*' ASSUME ALL FILES
 STA NAME SET DEFAULT NAME
 STA TYPE SET DEFAULT TYPE
 CALL SKIP SKIP TO OPTION
 CPI $0D END OF LINE?
 JZ GETIT GO FOR IT
 CALL NUM IS IT A NUMBER?
 JC DIRN NO - TRY NAME
 CALL VALDRV VALIDATE & STORE DRIVE
 JMP GETIT AND DO DIRECTORY
DIRN CALL GETNAM GET FILE SPECIFICATION
*LOCATE BUFFERED FILENAME IN DIRECTORY
GETIT CALL LOCDIR LOCATE IN DIRECTORY
 JNZ NOFILE NO FILE FOUND - ERROR
*DISPLAY CURRENT DIRECTORY ENTRY
D1 PUSH H SAVE POSITION
 MOV A,M CHECK NAME
 CPI ' ' IS THIS ONE USED?
 JZ DIRSKP NO - DO NOT DISPLAY
 CALL COMNAM COMPARE NAME TO REQUESTED
 JNZ DIRSKP NO MATCH - DO NOT DISPLAY
 MVI C,8 NAME IS 8 CHARS WIDE
 CALL PRX DISPLAY FIXED WIDTH
 MVI A,'.' SEPARATOR
 CALL CONOUT DISPLAY
 PUSH H SAVE POSITION OF EXTENSION
 MVI C,3 TYPE IS 3 CHARS WIDE
 CALL PRX DISPLAY FIXED WIDTH
 CALL SPACE SPACE OVER
 CALL SPACE SPACE OVER
 MOV D,M GET HIGH DISK ADDRESS
 INX H NEXT
 MOV E,M GET LOW DISK ADDRESS
 INX H NEXT
 CALL FMTDEC DISPLAY
 XCHG  GET POSITION BACK
 MOV E,M GET SIZE
 INX H NEXT
 MVI D,0 ZERO HIGH
 CALL SPACE SPACE OVER
 CALL SPACE SPACE OVER
 CALL FMTDEC DISPLAY
 POP H RESTORE POSITION TO EXTENSION
 CALL TSTOBJ IS IT AN OBJ FILE?
 JNZ GLF NO - NO MORE OUTPUT
 XCHG  GET POSTION BACK
 MOV D,M GET HIGH RUN ADDRESS
 INX H NEXT
 MOV E,M GET LOW RUN ADDRESS
 XCHG  HL = RUN ADDRESS
 CALL SPACE SPACE OVER
 CALL SPACE SPACE OVER
 CALL SPACE SPACE OVER
 CALL PRHEX DISPLAY RUN ADDRESS
GLF CALL LFCR NEW LINE
*SKIP TO THE NEXT DIRECTORY ENTRY
DIRSKP POP H RESTORE POSITION
 LXI D,16 SIZE OF ENTRY
 DAD D ADJUST POSTIION TO NEXT ENTRY
 MOV A,H GET HIGH ADDRESS
 CPI =DISK+1024 AT END OF DIRECTORY?
 JNZ D1 NO - DISPLAY NEXT
 SUB A INDICATE SUCCES
 RET
*DISPLAY FIXED WIDTH TEXT [HL] (WIDTH IN C)
PRX MOV A,M GET TEXT
 INX H ADVANCE
 CALL CONOUT DISPLAY
 DCR C REDUCE COUNT
 JNZ PRX DO THEM ALL
 RET
*
*CREATE A FILE
*
CREATE CALL GETVAL GET VALID FILENAME
 CALL GETDEC GET SIZE OF FILE
 PUSH H SAVE
 LXI H,TYPE POINT TO TYPE
 CALL TSTOBJ IS IT OBJECT?
 JNZ NOOBJ NO - OK
 CALL GETHEX GET RUN ADDRESS
 SHLD UDAT SET USER DATA
NOOBJ CALL LOCDIR LOOKUP FILE
 JZ EXISTS FILE ALREADY EXISTS
 CALL SKIP SKIP TO OPERAND
 CZ FINADR NO ADDRESS SUPPLIED - FIND FREE
 CNZ GETDEC GET SUPPLIED ADDRESS
 PUSH H SAVE DISK ADDRESS
NL2 CALL FINDET FIND EMPTY DIRECTORY ENTRY
 JNZ DIRFULL NONE AVAILABLE
 MVI B,11 COPY 11 CHARACTERS (NAME.EXT)
 LXI D,NAME POINT TO NAME
NL1 LDAX D GET CHARACTER FROM NAME
 MOV M,A WRITE TO DIRECTORY
 INX H NEXT DEST
 INX D NEXT SOURCE
 DCR B REDUCE COUNT
 JNZ NL1 DO THEM ALL
 POP D RESTORE
 MOV M,D WRITE HIGH DISK ADDRESS
 INX H ADVANCE
 MOV M,E WRITE LOW DISK ADDRESS
 INX H ADVANCE
 POP B RESTORE SIZE
 PUSH B RESAVE
 XCHG  HL = DISK ADDRESS
 DAD B ADJUST TO SIZE
 XCHG  SWAP BACK
 LXI B,DSKSIZ GET DISK SIZE
 CALL NCOMP ARE WE OVER?
 JC TOBIG REPORT ERROR
 POP D RESTORE SIZE
 MOV M,E SAVE SIZE
 INX H NEXT
 XCHG  DE=POSITION
 LHLD UDAT GET USER DATA
 XCHG  HL=POSITION, DE=UDATA
 MOV M,D WRITE HIGH USER ADDRESS
 INX H NEXT
 MOV M,E WRITE LOW USER ADDRESS
 JMP DIRITE AND WRITE DIRECTORY
*REPORT "DIRECTORY FULL" ERROR
DIRFULL CALL WRIMSG WRITE MESSAGE
 STR 'DIRECTORY FULL'
 DB $0D NEW LINE
 MVI A,5 DIRECTORY FULL
 JMP FIXUP AND PROCEED
*REPORT "FILE ALREADY EXISTS" ERROR
EXISTS CALL WRIMSG WRITE MESSAGE
 STR 'FILE ALREADY EXISTS'
 DB $0D NEW LINE
 MVI A,3 RETURN CODE
 JMP FIXUP RETURN TO CALLER
*REPORT "FILE NOT FOUND" ERROR
NOFILE CALL WRIMSG WRITE MESSAGE
 STR 'FILE NOT FOUND'
 DB $0D NEW LINE
 MVI A,2 RETURN CODE
 JMP FIXUP RETURN TO CALLER
*REPORT FILE TOO LARGE FOR DISK
TOBIG CALL WRIMSG WRITE MESSAGE
 STR 'SPACE NOT AVAILABLE'
 DB $0D NEW LINE
 MVI A,4 RETURN CODE
 JMP FIXUP RETURN TO CALLER
*
*DELETE A FILE
*
DELETE CALL GETNAM GET FILENAME
 DCR A GET FF
 STA UDAT SAVE FLAG
 MVI B,11 TEST 11 CHARACTERS
 LXI H,NAME POINT TO BUFFERED NAME
CHLP MOV A,M READ FROM NAME
 CPI '*' WILDCARD?
 JZ DEFGO YES - ASSUME DEFAULT
 INX H ADVANCE POSITION
 DCR B REDUCE COUNT
 JNZ CHLP CHECK THEM ALL
 SUB A RESET FLAG
 STA UDAT AND STORE
DEFGO CALL SKIP SKIP TO PARAMETER
 JZ NOPARM NO PARAMETER
 SUI 'Y' PROMPT OVERRIDE?
 JNZ BADOPR NO - ERROR
 STA UDAT RESET FLAG
NOPARM CALL LOCDIR LOCATE FILE IN DIRECTORY
 JNZ NOFILE NO FILE FOUND
DEL01 LDA UDAT GET FLAG
 ANA A PROMPT OVERRIDE OR SINGLE FILE
 JZ ERASE YES - ERASE THE FILE
 PUSH H SAVE HL
 MVI C,8 DISPLAY 8 CHARS
 CALL PRX DISPLAY FILE NAME
 MVI A,'.' SEPARATOR
 CALL CONOUT DISPLAY
 MVI C,3 DISPLAY 3 CHARS
 CALL PRX DISPLAY FILE EXTENSION
 CALL WRIMSG OUTPUT MESSAGE
 STRZ ' (Y/N/Q)?'
 POP H RESTORE HL
DEL04 CALL CONIN READ CHARACTER
 CPI 3 CONTROL-C?
 JZ ABDEL YES, THROW AWAY CHANGES
 CPI 'Q' QUIT?
 JZ OK YES - PROCEED
 CPI 'Y' YES?
 JZ OK YES - PROCEED
 CPI 'N' NO?
 JNZ DEL04 NO - WAIT FOR VALID CHARACTER
OK PUSH PSW SAVE RESPONSE
 CALL CONOUT OUTPUT
 CALL LFCR NEW LINE
 POP PSW RESTORE RESPONSE
 CPI 'Q' QUIT?
 JZ DIRITE YES - WRITE DIRECTORY & EXIT
 CPI 'Y' YES?
 JNZ DELN NO - DO NOT UPDATE
ERASE MVI M,' ' INVALIDATE FILE ENTRY
*SKIP TO NEXT DIRECTORY ENTRY
DELN LXI B,16 SIZE OF ENTRY
 DAD B ADJUST POSITION
 MOV A,H GET HIGH
 CPI =DISK+1024 ARE WE AT TOP OF DISK
 JZ DIRITE YES - WRITE DIR & EXIT
 MOV A,M GET FILE FLAG
 CPI ' ' ENTRY USED?
 JZ DELN NO, SKIP TO NEXT
 CALL COMNAM DOES IT MATCH?
 JZ DEL01 YES - DO THIS ONE
 JMP DELN NO, SKIP TO NEXT
*ABORT DELETE COMMAND
ABDEL CALL WRIMSG OUTPUT MESSAGE
 STR '^C' INDICATE ^C
 DB $0D NEW LINE
 CALL DIREAD RE-READ DIRECTORY
 MVI A,7 CONTROL-C INDICATOR
 RET
*
*LOAD A FILE INTO MEMORY
*
LOAD CALL GETOP GET FILENAME & ADDRESS
 MVI B,1 INDICATE READ
 JMP CMDISK PERFORM DISK COMMAND
*
*SAVE FILE FROM MEMORY
*
SAVE CALL GETOP GET FILENAME & ADDRESS
 MVI B,0 INDICATE WRITE
 JMP CMDISK PERFORM DISK COMMAND
*
*EXECUTE PROGRAM IN MEMORY
*
JUMP CALL GETHEX GET MEMORY ADDRESS
 CALL SKIP SKIP TO NEXT OPTION
 PCHL  EXECUTE PROGRAM
*
*GET A FILENAME (NO EXTENSION) & SET EXTENSION TO 'OBJ'
*
GETOBJ CALL SKIP SKIP TO NON-BLANK
 JZ BADOPR INDICATE BAD OPERAND
 MVI B,8 READ 8 CHARACTERS
OBJDRV MVI A,1 GET DRIVE
 STA DRIVE SET DRIVE
 LXI H,NAME POINT TO FILENAME
RUL1 CALL TLDAXD READ FROM INPUT
 JZ RUGO END OF NAME
 INX D SKIP TO NEXT
 CPI ',' DRIVE SPECIFIER?
 JZ FINDRV HANDLE IT
 CPI '*' WILDCARD?
 JZ BADOPR NOT ALLOWED
 MOV M,A SAVE IN FILENAME
 INX H NEXT IN FILENAME
 DCR B REDUCE COUNT
 JP RUL1 DO THEM ALL
 JMP BADOPR >8 CHARS - ERROR
*DRIVE WAS SPECIFIED, PROCESS
FINDRV LDAX D GET DRIVE INDICATOR
 INX D SKIP
 CALL VALDRV VALIDATE & STORE
*PAD THE NAME AND ADD OBJ TYPE
RUGO DCR B REDUCE COUNT
 JM COTYP 8 CHARS FINISHED
 MVI M,' ' PAD WITH BLANK
 INX H SKIP TO NEXT
 JMP RUGO AND PROCEED
COTYP MVI M,'O' ADD 'O'
 INX H NEXT
 MVI M,'B' ADD 'B'
 INX H NEXT
 MVI M,'J' ADD 'J'
 DCX H BACK TO 'B'
 DCX H BACK TO 'O'
 SUB A
 RET
*
*RUN A PROGRAM
*
RUN CALL GETOBJ GET FILENAME
 PUSH D SAVE COMMAND LINE
 CALL LOCDIR LOOKUP
 JNZ NOFILE REPORT ERROR
*RUN A PROGRAM FILE
RUNPRF PUSH H SAVE DIRECTORY POSITION
 LXI B,14 OFFSET TO RUN ADDRESS
 DAD B ADJUST POSITION
 MOV B,M GET HIGH RUN ADDRESS
 INX H NEXT
 MOV C,M GET LOW RUN ADDRESS
 POP H RESTORE POSITION
 PUSH B SAVE ADDRESS
 CALL GETFIL GET FILENAME
 MVI B,1 INDICATE READ
 CALL CMDISK READ FILE FROM DISK
 POP H RESTORE RUN ADDRESS
 POP D RESTORE COMMAND POINTER
 CALL SKIP SKIP TO OPERANDS
 PCHL  EXECUTE PRGORAM
*
*READ SECTOR(S) FROM THE DRIVE TO MEMORY
*
HREAD CALL REAWRI GET DRIVE, SECTOR, SIZE, ADDRESS
 MVI B,1 INDICATE READ
 JMP CMDISK READ THE DATA
*
*WRITE SECTORS(S) TO THE DRIVE FROM MEMORY
HWRITE CALL REAWRI GET DRIVE, SECTOR, SIZE, ADDRESS
 MVI B,0 INDICATE WRITE
 JMP CMDISK WRITE THE DATA
*
*SET FUNCTIONS
*
SETCMD CALL CMD LOOP OPERAND KEYWORD
 SUI 13 'OUTPUT'?
 JZ SDEV YES - SET CONSOLE DEVICE
 DCR A 'DRIVE'?
 JZ DEFDSK YES - SET DEFAULT DRIVE
 JMP BADOPR INDICATE ERROR
*
*VALIDATE A DRIVE NUMBER (ASCII) AND STORE
*
VALDRV SUI $30 CONVERT: ASCII->BINARY
SVCDRV DCR A CONVERT: 0-2
 CPI 3 IN RANGE?
 JNC BADOPR NO, REPORT ERROR
 INR A CONVERT: 1-3
 STA DRIVE SET NEW DRIVE
 SUB A INDICATE SUCCESS
 RET
*
*DISPLAY MEMORY
*
DISP CALL GETHEX GET OPERAND
 MOV A,L GET LOW
 ANI $F0 ADJUST TO EVEN BOUNDARY
 MOV L,A RESAVE
 PUSH H SAVE ADDRESS
 CALL SKIP SKIP TO NEXT
 CNZ GETHEX GET HEX VALUE
 MOV B,H SAVE HIGH END
 MOV C,L SAVE LOW END
 POP H RESTORE ADDRESS
DISP1 CALL PRHEX DISPLAY ADDRESS
 PUSH H SAVE ADDRESS
 MVI D,16 OUTPUT 16 BYTES
 CALL SPACE EXTRA SPACE
DISP2 CALL SPACE SPACE OVER
 MOV A,L GET ADDRESS
 ANI 3 AT 4 BYTE BOUNDARY?
 CZ SPACE YES - EXTRA SPACE
 MOV A,M GET DATA
 CALL HEXOUT DISPLAY
 INX H ADVANCE
 DCR D REDUCE COUNT
 JNZ DISP2 DISPLAY THEM ALL
 MVI D,4 # SEPARATING SPACES
SPLP CALL SPACE SPACE OVER
 DCR D REDUCE COUNT
 JNZ SPLP DO THEM ALL
 MVI D,16 DO 16 CHARACTERS
 POP H RESTORE ADDRSS
CHDISP MOV A,M GET DATA
 INX H NEXT
 CPI ' ' PRINTABLE?
 JC DISDOT NO - CHANGE TO '.'
 CPI $7F PRINTABLE?
 JC ITSOK YES - OK TO SHOW
DISDOT MVI A,'.' CHANGE NON-PRINT INTO '.'
ITSOK CALL CONOUT DISPLAY
 DCR D REDUCE COUNT
 JNZ CHDISP AND CONTINUE
 CALL LFCR NEW LINE
 MOV D,H GET HIGH
 MOV E,L GET LOW
 CALL NCOMP COMPARE WITH END
 JNC DISP1 MORE TO GO
 SUB A INDICATE SUCCESS
 RET
*
*STORE VALUE(S) INTO MEMORY
*
STOR CALL GETHEX GET ADDRESS
 MOV B,H COPY
 MOV C,L COPY
STOR1 CALL GETHEX GET DATA VALUE
 MOV A,L INTO A
 STAX B SAVE
 INX B ADVANCE
 CALL SKIP MORE?
 JNZ STOR1 YES, HANDLE THEM
 SUB A INDICATE SUCCESS
 RET
*SET DEFAULT DRIVE FROM COMMAND LINE
DEFDSK LDAX D GET DRIVE FROM COMMAND LINE
*SET THE DEFAULT DRIVE USED BY DOS
SVCDEF CALL VALDRV VALIDATE & STORE DRIVE
 LDA DRIVE GET DRIVE
 STA GETNAM+1 PATCH GETNAM
 STA DIR+1 PATCH DIR
 STA OBJDRV+1 PATCH OBJDRV
 SUB A INDICATE SUCCESS
 RET
*
*PERFORM DISK COMMAND OVER MULTIPLE TRACKS
*A=#BLKS B=COMMAND(00=W/01=R/03=V) C=DRIVE DE=RAMADDR HL=DISKADDR
*
DCOM ANA A ZERO BLOCKS?
 RZ  DO NOTHING
 PUSH PSW SAVE BLOCK COUNT
DTRY1 MVI A,10 10 SECTORS/TRACK
 STA TEMP+1 SAVE FOR LATER
 POP PSW RESTORE BLOCKS
DTRY CALL ACCDSK ACCESS THE DISK
 JNZ DSKERR REPORT DISK ERROR
 ANA A MORE DATA?
 RZ  NO, WE ARE FINISHED
 PUSH PSW SAVE BLOCK COUNT
 PUSH B SAVE COMMAND/DRIVE
 PUSH H SAVE RAM ADDRES
 MOV L,A GET REMAINING BLOCKS
 LDA TEMP+2 GET INITIAL SIZE
 SUB L COMPUTE OFFSET
 MOV H,A SET HIGH ADDRESS
 MOV C,A SET HIGH ADDRESS
 MOV A,L GET LOW ADDRESS
 MVI L,0 ZERO LOW
 MOV B,L ZERO LOW
 DAD D ADJUST RAM ADDRESS
 XCHG  DE = ADJUSTED ADDRESS
 POP H RESTORE DISK ADDRESS
 DAD B ADJUST DISK ADDRESS
 POP B RESTORE COMMAND/DRIVE
 JMP DTRY1 AND CONTINUE COMMAND ON NEW TRACK
*
*PERFORM A DISK ACCESS & DO READ AFTER WRITE CHECK IF ENABLED
*
ACCDSK PUSH H SAVE HL
 PUSH D SAVE DE
 PUSH B SAVE BC
 STA TEMP+2 SAVE # BLOCKS
 CALL UDISK ACCESS THIS TRACK
 LXI H,TEMP POINT TO TEMP LOCATION
 MOV M,B SAVE
 POP B RESTORE BC
 POP D RESTORE DE
 POP H RESTORE HL
 RNZ  IF ERROR, STOP
 PUSH PSW SAVE A
 LDA RWCHK READ/AFTER WRITE ENABLED?
 ORA B TEST WITH WRITE=0
 JZ VERWRI YES, DO VERIFY
 POP PSW RESTORE A
 RET
*VERIFY WRITE OPERATIONS
VERWRI POP PSW SAVE A
 MVI B,2 VERIFY OPERATION
 LDA TEMP+2 GET # BLOCKS
 CALL ACCDSK PERFORM VERIFY
 MVI B,0 ZERO
 RET
*
*A DISK ERROR HAS OCCURED - RETRY, ISSUE CONSOLE MESSAGE IF FATAL
*
DSKERR PUSH PSW SAVE CODE
 LDA TEMP+1 GET RETRY COUNT
 DCR A TIME TO QUIT?
 JZ NOWAY YES - GIVE UP
 STA TEMP+1 RESAVE NEW COUNT
 POP PSW CLEAN STACK
 LDA TEMP+2 GET BLOCK COUNT
 JMP DTRY AND GO AGAIN
*DISK ERROR IS FATAL!
NOWAY CALL WRIMSG OUTPUT MESSAGE
 STRZ 'HDE(' TEXT
 POP PSW RESTORE CODE
 XCHG  SAVE SECTOR
 MOV L,A GET CODE
 MVI H,0 ZERO HIGH
 CALL PRDEC DISPLAY
 CALL WRIMSG OUTPUT MESSAGE
 STRZ ') D' TEXT
 MOV L,C GET DRIVE
 CALL PRDEC DISPLAY
 CALL WRIMSG OUTPUT MESSAGE
 STRZ ' S' TEXT
 LDA TEMP+2 GET # BLKS
 MOV L,A SET
 DAD D ADD TO START
 LDA TEMP GET SECTORS REMAINING
 MOV B,A INTO B
 MOV A,L GET SECTOR
 SUB B ADJUST
 MOV L,A RESAVE
 JNC NODEC NO CARRY BACK
 DCR H ADJUST HIGH
NODEC CALL PRDEC DISPLAY SECTOR
 CALL LFCR NEW LINE
 MVI A,6 "UNRECOVERABLE DISK ERROR"
 JMP FIXUP RETURN TO CALLER
*DISK TRACKING AREA AT ADDRESS 0
*0000: LAST DRIVE ACCESSED
*0001: TRACK POSITION ON DRIVE 1
*0002: TRACK POSITION ON DRIVE 2
*0003: TRACK POSITION ON DRIVE 3
INFO EQU 0 LAST DRIVE ACCESSED
*
*ACCESS THE DISK WITHIN A SINGLE TRACK
*A=#BLKS BC=CMD/SECTOR DE=RAMADDR HL=DISKADDR
*SETS C IF OPERATION SPANS NEXT TRACK & RETURNS REMAINING BLKS IN A
*- YOU MUST SEEK AND RECALL
*
UDISK PUSH PSW SAVE A (SECTOR COUNT)
 PUSH D SAVE DE (RAM ADDRESS)
 PUSH B SAVE BC (CMD/SECTOR)
 PUSH H SAVE HL (DISK ADDRESS)
 MVI D,0 ZERO HIGH
 MOV E,A GET # BLKS
 DAD D HL = LAST SECTOR
DEC0 EQU $FFFF
 LXI D,DEC0-DSKSIZ HL = LAST VALID BLOCK
 DAD D TEST FOR WITHIN DISK
 POP H RESTORE HL (RAM ADDRESS)
 JC SYNT OVERFLOW - REPORT ERROR
 MOV A,C GET DRIVE
 DCR A ADJUST TO 0 OFFSET
 CPI 3 IN RANGE?
 JNC SYNT BAD DRIVE - ERROR
 MOV A,B GET COMMAND
 CPI 3 VALID COMMAND?
 JNC SYNT BAD COMMAND - ERROR
*DETERMINE STARTING TRACK
 LXI D,Z0-TRKSIZ ADJUST BY -TRKSIZE
 MVI B,255 AND -1
D10 INR B ADVANCE COUNT
 DAD D SUBTRACT TRKSIZE
 JC D10 GO TILL WE FIND TRACK
 MOV D,B D = TRACK
 MOV A,L GET SECTOR
 ADI TRKSIZ ADJUST TO POSITIVE
 MOV E,A E = SECTOR
 LDA $EB90 READ DISK STATUS
 ANI $10 MOTORS ON?
 JNZ ALRON ALREADY ON
 MVI B,50 WAIT FOR MOTORS
 CALL WSEC WAIT SECTOR TIMES
 JMP LODHED LOAD HEAD
ALRON LDA INFO GET LAST DRIVE ACCESSED
 CMP C SAME DRIVE?
 JZ NOLOAD YES, NO NEED TO LOAD HEADS
*LOAD HEADS ON DRIVE
LODHED MOV A,C GET DRIVE #
 STA INFO REMEMBER WE ARE USING THIS ONE
 MVI B,$EB ADDRESS DISK CONTROLLER STATUS
 LDAX B SELECT DRIVE (C=DRIVE)
 MVI B,13 WAIT FOR HEAD LOAD
 CALL WSEC WAIT SECTOR TIMES
*STEP TO DESIRED TRACK POSITION
NOLOAD MVI H,=INFO SET HIGH ADDRESS
 MOV L,C ADDRESS SELECTED DRIVE TRACK POSITION
GOSTEP MOV A,M READ TRACK POSITION
 CMP D COMPARE TO DESIRED POSITION
 JZ ATTRK WE ARE AT DESIRED TRACK - PROCEED
 JC STPOUT LESS THAN - STEP OUT
*STEP IN ONE TRACK
STPIN LDA $EB9C STEP IN DIRECTION & READ STATUS
 DCR M RECORD NEW POSITION
 RRC  AT TRACK 0
 JNC CSTEP NO, PROCEED WITH STEP
 MVI M,0 RESET TRACK POSITION
 JMP GOSTEP AND PROCEED
*STEP OUT ONE TRACK
STPOUT LDA $EB9D STEP OUT DIRECTION
 INR M RECORD NEW POSITION
CSTEP LDA $EB09 ASSERT STEP
 XTHL  WAIT A BIT
 XTHL  WAIT A BIT
 LDA $EB08 DEASSERT STEP
 MVI B,2 WAIT FOR STEP
 CALL WSEC WAIT SECTOR TIMES
 JMP GOSTEP AND PROCEED
*WE ARE AT THE CORRECT TRACK
ATTRK CALL WSEC1 WAIT FOR PULSE & GET SECTOR
 CMP E ARE WE AT SECTOR
 JNZ ATTRK NO, KEEP WAITING
 POP B RESTORE BC (CMD/DRIVE)
 POP H RESTORE HL FROM DE (RAM ADDRESS)
 DCR B TEST COMMAND
 JM WRITE WRITE OPERATION
 JNZ VERIFY VERIFY OPERATION
*READ A SECTOR FROM THE DISK
READ CALL GETBDY WAIT FOR BODY MODE
 MOV B,C INITIALIZE CHECK
RBYT LDAX D READ DATA
 MOV M,A SAVE DATA
 INX H SKIP TO NEXT
 XRA B COMPUTE
 RLC  CHECK...
 MOV B,A RESAVE CHECK
 DCR C REDUCE COUNT
 JNZ RBYT DO ALL 256 BYTES/SECTOR
 LDAX D GET CHECK BYTE
 XRA B SAME AS COMPUTED?
 JNZ RERR NO, REPORT ERROR
 POP PSW RESTORE SECTOR COUNT
 DCR A REDUCE COUNT
 ANA A DONE THEM ALL? / CLEAR CARRY
 RZ  YES, STOP
 PUSH PSW RESAVE SECTOR COUNT
 CALL WSEC1 WAIT ONE SECTOR TIME
 JNZ READ READ NEXT IF STILL ON THIS TRACK
 POP PSW CLEAN STACK
 CMP A SET ZF
 STC  INDICATE MORE TO GO
 RET
*READ ERROR HAS OCCURED
RERR POP B CLEAN STACK
 MVI A,2 "READ DATA CRC ERROR"
 ANA A CLEAR ZF
 RET
*VERIFY A SECTOR WITH THE DISK
VERIFY CALL GETBDY WAIT FOR BODY MODE
 MOV B,C BEGIN CHECK = 00
VBYT LDAX D READ BYTE OF DATA
 CMP M SAME AS MEMORY?
 JNZ VERR NO - REPORT ERROR
 INX H NEXT
 XRA B COMPUTE
 RLC  CHECK...
 MOV B,A RESAVE CHECK
 DCR C REDUCE COUNT
 JNZ VBYT DO ALL 256 BYTES
 LDAX D GET CHECK BYTE
 XRA B SAME AS COMPUTED?
 JNZ RERR NO - REPORT ERROR
 POP PSW RESTORE # SECTORS
 DCR A REDUCE COUNT
 ANA A DONE THEM ALL? / CLEAR CARRY
 RZ  YES, STOP
 PUSH PSW RESAVE COUNT
 CALL WSEC1 WAIT ONE SECTOR
 JNZ READ VERIFY NEXT IF STILL ON THIS TRACK
 POP PSW CLEAN STACK
 CMP A SET 'Z'
 STC  INDICATE MORE TO GO
 RET
*DATA ON DISK DID NOT VERIFY
VERR POP B CLEAN STACK
 MVI A,3 "VERIFY DATA ERROR"
 ANA A CLEAR ZF
 RET
*WRITE SECTOR TO THE DISK
WRITE LDA $EB04 READ STATUS
 ANI 2 WRITE PROTECTED?
 JNZ WRIERR YES, REPORT ERROR
TSTWRI LDA $EB10 READ STATUS
 ANI $08 READY FOR DATA?
 JZ TSTWRI NO, WAIT FOR IT
*WRITE PREAMBLE
 LXI B,15 WRITE 15 BYTES OF ZERO
WRIZ MOV E,B GET ZERO
 MVI D,$EA ADDRESS CONTROLLER WRITE REGISTER
 LDAX D WRITE BYTE
 MOV A,M TIMING... ???
 DCR C REDUCE COUNT
 JNZ WRIZ DO THEM ALL
 MVI E,$FB SYNC BYTE
 LDAX D WRITE SYNC BYTE
 MOV A,M TIMING... ???
*WRITE DATA
WLP1 MOV A,M GET DATA
 MOV E,A SET CONTROLLER WRITE DATA
 XRA B COMPUTE
 RLC  CHECK...
 MOV B,A RESAVE CHECK
 LDAX D WRITE THE DATA
 INX H ADVANCE TO NEXT
 DCR C REDUCE COUNT
 JNZ WLP1 WRITE THEM ALL
 MOV E,B GET CHECK BYTE
 INX B C=1
 LDAX D WRITE CHECK BYTE
 POP PSW RESTORE SECTOR COUNT
 DCR A REDUCE COUNT
 ANA A DONE THEM ALL? / CLEAR CARRY
 RZ  YES, STOP
 PUSH PSW RESAVE COUNT
 CALL WSEC1 WAIT FOR NEXT SECTOR
 JNZ WRITE WRITE NEXT SECTOR
 POP PSW CLEAN STACK
 CMP A SET ZF
 STC  INDICATE MORE TO GO
 RET
*WRITE ERROR HAS OCCURED
WRIERR POP B CLEAN STACK
 MVI A,4 "WRITE PROTECT VIOLATION"
 ANA A CLEAR ZF
 RET
*
*WAIT FOR DISK TO INDICATE "BODY" MODE
*ON EXIT, DE=DATA ADDRESS, C=00 (FOR 256 BYTE DATA COUNT)
*
GETBDY LXI D,$EB50 DATA READ ADDRESS
 LXI B,$8C00 TIMEOUT & DATA COUNT
TSTBDY LDA $EB10 GET STATUS
 ANI 4 BODY MODE
 RNZ  READY FOR DATA
 DCR B REDUCE TIMEOUT
 JNZ TSTBDY KEEP LOOKING
 POP PSW CLEAN RETURN ADDRESS
 POP B RESTORE BC
 MVI A,1 "SYNC BYTE NOT FOUND"
 ANA A CLEAR Z
 RET
*WAIT ONE SECTOR TIME
WSEC1 MVI B,1 INDICATE ONE SECTOR TIME
*WAIT B SECTOR TIMES
WSEC LDA $EB14 RESET SECTOR FLAG
WS1P LDA $EBB0 READ STATUS
 ANA A SECTOR PULSE?
 JP WS1P NO, WAIT FOR IT
 DCR B REDUCE COUNT
 JNZ WSEC DO THEM ALL
 ANI $0F RETURN SECTOR NUMBER
 RET
*ERROR IN DISK PARAMETERS
SYNT POP B CLEAN BC
 POP D CLEAN DE
 POP PSW CLEAN A
 ORI 255 SET -1(ERROR) & CLEAR Z
 RET
*
*---------------------------------------------------------------
*USER SUPPLIED I/O FUNCTIONS
*---------------------------------------------------------------
*
*USER I/O INITIALIZATION FUNCTION
*
UINIT MVI A,$03 INSURE COMMAND MODE
 OUT $06 WRITE
 OUT $06 WRITE
 MVI A,$77
 OUT $06
 MVI A,$7A
 OUT $06
 MVI A,$37
 OUT $06
 MVI B,$1A
 JMP TOUT
*
*USER INPUT FUNCTION
*
UIN IN $06 READ STATUS
 ANI $02 CHARACTER READY?
 JZ UIN NO, WAIT FOR IT
 IN $05 READ CHARACTER
 RET
*
*USER OUTPUT FUNCTION
*
UOUT DCR A DEVICE 1
 JZ CONPRT YES, CONSOLE + PRINTER
 DCR A DEVICE 2
 JZ LPRT YES, PRINTER ONLY
TOUT IN $06 READ STATUS
 RRC  UART TX READY?
 JNC TOUT WAIT FOR IT
 MOV A,B GET CHARACTER
 OUT $05 OUTPUT
 CPI $0C CLEAR-SCREEN?
 RNZ  NO, ITS OK
*OUTPUT A PAD AFTER CLEARING THE SCREEN
WAINXT IN $06 READ STATUS
 RRC  UARY TX READY?
 JNC WAINXT WAIT FOR IT
 MVI A,$7F GET PAD
 OUT $05 OUTPUT
 MOV A,B RESTORE CHARACTER
 RET
*
*USER I/O TEST INPUT FUNCTION
*
UCTRLC IN $06 READ STATUS
 ANI $02 CHARACTER READY?
 JZ NOCHR NO.
 IN $05 READ CHARACTER
 CPI $03 IS IT CONTROL-C?
 STC  INDICATE DATA RX
 RET
NOCHR ORI $FF NO CHARACTER - RETURN FF
 RET
*
*OUTPUT DEVICE 1 - WRITE TO CONSOLE AND PRINTER
CONPRT CALL TOUT WRITE TO CONSOLE
*OUTPUT DEVICE 2 - WRITE TO PRINTER
LPRT IN 8 READ STATUS
 ANI $20 CHARACTER READY?
 JZ OKPRT NO, OK TO TX
 IN 9 READ CHARACTER
 CPI $13 CTRL-S?
 JNZ OKPRT NO, OK TO TX
*CTRL-S HAS BEEN RECEIVED - WAIT FOR CTRL-Q
WAICTLS IN 8 READ STATUS
 ANI $20 CHARACTER READY?
 JZ WAICTLS NO, WAIT FOR IT
 IN 9 READ CHARACTER
 CPI $11 CTRL-Q?
 JNZ WAICTLS NO, WAIT FOR IT
OKPRT IN 8 READ STATUS
 ANI 2 TX READY?
 JZ OKPRT NO, WAIT FOR IT
 MOV A,B GET CHARACTER
 OUT 9 WRITE
 RET
Q
WAICTLS IN 8 READ STATUS
 ANI $20 CHARACTER READY?
 JZ WAICTLS NO, WAIT FOR IT
 IN 9 READ CHARACTER
 CPI $11 CTRL-Q?
 JNZ WAICTLS NO, WAIT FOR IT
OKPRT IN 8 READ STATUS
 ANI 2 T*
*DMF "DISK" DISK MANAGEMENT UTILITY BY D. DUNFIELD
*
DATA EQU *+$300 DATA BUFFER GOES HERE
*
 LXI H,CMDTAB POINT TO COMMAND TABLE
 SVC 36 LOOKUP COMMAND
 CPI 4 IN RANGE?
 JNC BADOPR NO, INDICATE BAD OPERAND
 CPI 3 'COPY?'
 JNZ NORM DON'T NEED FROM/TO
 CALL WRIMSG OUTPUT MESSAGE
 STRZ 'FROM '
NORM CALL WRIMSG OUTPUT MESSAGE
 STRZ 'DRIVE#?'
 SVC 13 GET INPUT
 SVC 14 SKIP TO NON-BLANK
 SUI $30 CONVERT TO BINARY
 SVC 29 SET DISK DRIVE
 RNZ  BAD DRIVE
 DCR B 'SORT'?
 JM CSORT DO SORT
 DCR B 'COMPRES'?
 JM CMPRS DO COMPRESS
 DCR B 'INITIALIZE'?
 JM INIT DO INITALIZE
 DCR B 'COPY'?
 JM COPY DO COPY
 ORI $FF -1 BAD PARM (SHOULD NEVER GET HERE)
 RET
*
*SORT THE DISK DIRECTORY BY DISK ADDRESS
*
CSORT CALL SORT PERFORM SORT
 SVC 22 REWRITE DIRECTORY
 RET
*
*SORT THE DISK DIRECTORY
*
SORT SVC 21 READ DIRECTORY
 JNZ ABORT FAILED
 SHLD DIRADR SAVE DIRECTORY ADDRESS
 LXI H,DATA POINT TO DATA AREA
TOP PUSH H SAVE ADDRESS
 LXI H,65535 BIG NUMBER (LOW WATER MARK)
 SHLD FDA SAVE FOR LATER
 POP H RESTORE ADDRESS
 CALL GETSML FIND LOWEST ADDRESS
 JZ EXIT NO MORE FOUND
 MVI B,16 MOVE 16 BYTES
TLP LDAX D READ FROM DIR ENTRY
 MOV M,A WRITE TO NEW DIRECTORY IMAGE
 MVI A,' ' GET UNUSED MARKER
 STAX D MARK OLD ENTRY UNUSED
 INX D NEXT IN SOURCE
 INX H NEXT IN DEST
 DCR B REDUCE COUNT
 JNZ TLP DO ENTIRE ENTRY
 JMP TOP AND TRY NEXT
*
*FIND THE LOWEST ADDRESS IN DIRECTORY
*ON EXIT: DE = SELECTE ENTRY
*
GETSML PUSH H SAVE ADDRESS
 LXI B,64 TEST 64 ENTRIES
 LHLD DIRADR GET DIRECTORY ADDRESS
GLP MOV A,M GET ENTRY
 CPI ' ' USED?
 JZ NXT NO - TRY NEXT
 PUSH H SAVE ADDRESS
 LXI D,11 OFFSET TO DISK ADDRESS
 DAD D ADJUST ADDRESS
 MOV D,M GET HIGH ADDRESS
 INX H NEXT
 MOV E,M GET LOW ADDRESS
 LHLD FDA GET LOW-WATER MARK
 CALL COMP THIS ONE LOWER?
 JNC NOSWAP NO - DO NOT CHANGE
 XCHG  HL = NEW LW MARK
 SHLD FDA SAVE IT
 MVI B,10 INDICATE SUCCESS
 POP H RESTORE ADDRESS
 SHLD SA SAVE THIS ENTRY ADDRESS
 PUSH H RESAVE ADDRESS
NOSWAP POP H RESTORE ADDRESS
*ADVANCE TO NEXT DIRECTORY ADDRESS
NXT LXI D,16 SIZE OF DIRECTORY ENTRY
 DAD D ADJUST ADDRESS
 DCR C REDUCE COUNT
 JNZ GLP CHECK ALL ENTRIES
 LHLD SA GET ENTRY WE SELECTED
 XCHG  DE = ENTRY
 POP H RESTORE ADDRESS
 MOV A,B GET RETURN CODE
 ANA A AND SET FLAGS
 RET
*NOW COPY NEW DIRECTORY BACK TO OLD
EXIT MOV A,H GET DATA FROM NEW
 CPI =DATA+1024 ARE WE AT END?
 JZ EXIT1 YES, EXIT
 MVI M,' ' BLANK IT
 INX H NEXT
 JMP EXIT BLANK REMAINDER
EXIT1 LXI D,DATA NEW DIRECTORY
 LHLD DIRADR OLD DIRECTORY
 LXI B,1024 SIZE OF DIRECTORY
F1 LDAX D READ BYTE FROM NEW
 MOV M,A WRITE TO OLD
 INX D NEXT IN SOURCE
 INX H NEXT IN DEST
 DCX B REDUCE COUNT
 MOV A,B GET HIGH
 ORA C IS IT ZERO?
 JNZ F1 DO ALL
 RET
*
*COMPARE DE WITH HL
*
COMP MOV A,D GET HIGH
 CMP H SAME?
 RNZ  NO NEED TO CONTINUE
 MOV A,E GET LOW
 CMP L COMPARE
 RET
*
*COMPRESS THE DISK
*
CMPRS CALL SORT SORT THE DIRECTORY
 LXI H,4 START OF DATA AREA
 SHLD FDA SAVE MARKER
 CALL GETFIL GET NEXT FILE ENTRY
LOP1 LHLD FS GET FILE SIZE
 DAD D ADD TO FILE ADDRESS
 SHLD NFA SAVE NEW FILE ADDRESS
 LHLD FDA GET NEXT FREE
 XCHG  GET
 LHLD SA GET FILE ADDRESS
 CALL COMP FDA < SA (FREE < FILE)
 JNC FIXFDA NO, ADJUST FDA
*GAP FOUND IN DRIVE - MOVE FILE TO FILL
 CALL WRIMSG OUTPUT MESSAGE
 STRZ 'MOVING "' TEXT
 CALL PRNAM DISPLAY FILENAME
 CALL WRIMSG OUTPUT MESSAGE
 STRZ '" FROM ' TEXT
 SVC 11 DISPLAY FROM SECTOR
 CALL WRIMSG OUTPUT MESSSAGE
 STRZ ' TO ' TEXT
 XCHG  GET TO SECTOR
 SVC 11 DISPLAY TO SECTOR
 SVC 6 NEW LINE
 XCHG  SWAP BACK
 LDA FS GET FILE SIZE
M1 CPI 21 MORE THAN 20 BLOCKS (2 TRACKS)
 JC LST NO - SINGLE TRANSACTION
 PUSH PSW SAVE SIZE
 MVI A,20 MOVE 20 BLOCKS
 CALL XFER COPY THE DATA
 LXI B,20 ADD 20 BLOCKS
 DAD B ADJUST FROM
 XCHG  GET TO
 DAD B ADJUST TO
 XCHG  SWAP BACK
 POP PSW RESTORE LENGTH
 SUI 20 SUBTRACT 20 BLOCKS
 JMP M1 AND DO NEXT
*TRANSFER BLOCKS(A) FROM HL TO DE
XFER PUSH D SAVE DE
 PUSH H SAVE FROM
 PUSH D SAVE TO
 MVI B,1 READ COMMAND
 LXI D,DATA -> DATA BUFFER
 PUSH PSW SAVE LENGTH
 SVC 28 READ DISK
 JNZ HDE DISK ERROR
 POP PSW RESTORE LENGTH
 POP H GET TO
 LXI D,DATA <- DATA BUFFER
 MVI B,0 WRITE COMMAND
 SVC 28 WRITE DISK
 JNZ HDE DISK ERROR
 POP H RESTORE FROM
 POP D RESTORE TO
 RET
*LAST BLOCK TO TRANSFER
LST ANA A MORE BLOCKS?
 CNZ XFER YES, TRANSFER
 LHLD FDA GET FREE DISK ADDRESS
 CALL UPDIR UPDATE DIRECTORY ENTRY
 XCHG  DE=DISK ADDRSS
 LHLD FS GET FLIE SIZE
 MVI H,0 ZERO HIGH
 DAD D ADJUST ADDRSS
 SHLD FDA SET NEW FREE DISK ADDRESS
*READ AND PROCESS NEXT FILE
RDNXT CALL GETFIL GET NEXT FILE ENTRY
 LHLD NFA GET NEXT FILE ADDRESS
 CALL COMP OVERLAID FILE
 JNC LOP1 NO - MOVE NEXT FILE
*NEXT FILE OVERLAYS THIS ONE - ADJUST TO POINT TO CORRECT
*OFFSET WITHIN OVERLAID FILE
 PUSH H SAVE ADDRESS
 LHLD SA GET SAVED ADDRESS
 MOV A,H GET HIGH
 CMA  COMPLIMENT TO NEGATE
 MOV D,A COPY HIGH
 MOV A,L GET LOW
 CMA  COMPLIMENT TO NEGATE
 MOV E,A SAVE LOW
 INX D COMPETE NEGATION: 0-ADDRESS
 POP H RESTORE ADDRESS
 DAD D ADJUST
 MOV A,H GET HIGH
 CMA  COMPLIMENT TO NEGATE
 MOV D,A SAVE HIGH
 MOV A,L GET LOW
 CMA  COMPLIMENT TO NEGATE
 MOV E,A SAVE LOW
 INX D COMPLETE NEGATION: 0-NEW_ADDRESS
 LHLD FDA GET FREE ADDRESS
 DAD D ADJUST
 CALL WRIMSG OUTPUT MESSAGE
 STRZ 'UPDATE "' TEXT
 CALL PRNAM DISPLAY FILENAME
 CALL WRIMSG OUTPUT MESSAGE
 STRZ '" TO POINT TO '
 SVC 11 DISPLAY SECTOR
 SVC 6 NEW LINE
 CALL UPDIR UPDATE DIRECTORY ENTRY
 JMP RDNXT
*UPDATE THE FREE DISK ADDRESS
FIXFDA XCHG  COPY ADDRESS
 LHLD FS GET FILE SOZE
 MVI H,0 ZERO HIGH
 DAD D ADJUST
 LXI D,3 SIZE OF DIRECTORY
 CALL COMP INSURE IN DATA SPACE
 JNC RDNXT NO - DO NOT UPDATE
 SHLD FDA SAVE NEW FREE ADDRESS
 JMP RDNXT AND PROCEED
*UPDATE DIRECTORY ENTRY
UPDIR XCHG  SAVE ADDRESS
 LHLD CENT GET CURRENT ENTRY
 LXI B,11 OFFSET TO DISK ADDRSS
 DAD B ADDJUST DIRECTORY ADDRESS
 MOV M,D SAVE HIGH DISK ADDRESS
 INX H NEXT
 MOV M,E SAVE LOW DISK ADDRESS
 XCHG  SWAP PACK
 RET
*DISPLAY FILENAME
PRNAM PUSH H SAVE HL
 LHLD CENT GET CURRENT ENTRY
 MVI B,8 DISPLAY 8 CHAR NAME
PR1 MOV A,M GET DATA FROM NAME
 INX H NEXT
 SVC 3 SEND TO CONSOLE
 DCR B REDUCE COUNT
 JNZ PR1 DO THEM ALL
 MVI A,'.' SEPARATOR
 SVC 3 DISPLAY
 MVI B,3 DISPLAY 3 CHAR TYPE
PR2 MOV A,M GET DATA FROM TYPE
 INX H NEXT
 SVC 3 SEND TO CONSOLE
 DCR B REDUCE COUNT
 JNZ PR2 DO THEN ALL
 POP H RESTORE HL
 RET
*
*READ FILE ENTRY FROM DIRECTORY
*
GETFIL LHLD DIRADR GET DIRECTORY ADDRESS
GFLP MOV A,M GET FILE MARKER
 CPI ' ' USED?
 JZ DONE YES - FINISHED
 SHLD CENT SAVE CURRENT ENTRY POINTER
 LXI D,11 OFFSET TO DISK ADDRESS
 DAD D ADJUST ADDRESS
 MOV D,M GET HIGH DISK ADDRESS
 INX H NEXT
 MOV E,M GET LOW DISK ADDRESS
 INX H NEXT
 MOV A,M GET SIZE
 STA FS SAVE FILE SIZE
 XCHG  HL = DISK ADDRESS
 SHLD SA SAVE ADDRESS
 XCHG  SWAP BACK
 INX H SKIP USER DATA
 INX H SKIP USER DATA
 INX H SKIP USER DATA
 SHLD DIRADR SAVE NEW DIRECTORY ADDRESS
 RET
*DISPLAY "DONE" MESSAGE, UPDATE DIRECRORY AND EXIT
DONE CALL WRIMSG OUTPUT MESSAGE
 STR 'DONE...'
 DB $0D NEW LINE
*HARD DISK ERROR HAS OCCURED
HDE SVC 22 TRY TO WRITE DIRECTORY
 SVC 30 RE-ENTER DOS
*
*INITIALIZE A DISKETTE
*
INIT LXI H,DATA POINT TO DATA AREA
 MVI A,=DATA+$A00 END ADDRESS
INLP MVI M,' ' WRITE BLANK
 INX H NEXT
 CMP H AT END?
 JNZ INLP DO THEM ALL
 CALL WRIMSG OUTPUT MESSAGE
 STR 'INITIALIZING...'
 DB $0D NEW LINE
 MVI A,35 WRITE 35 TRACKS
 LXI H,0 DISK ADDRESS = 0
INP1 PUSH PSW SAVE TRACK COUNT
 MVI A,10 TRACK = 10 SECTORS
 LXI D,DATA POINT TO DATA AREA
 PUSH H SAVE DISK ADDRESS
 MVI B,0 WRITE COMMAND
 SVC 28 PERFORM DISK OPERATION
 JNZ ABORT FAILED
 POP H RESTORE DISK ADDRESS
 LXI D,10 OFFSET TO NEXT TRACK
 DAD D ADJUST DISK ADDRESS
 POP PSW RESTORE TRACK COUNT
 DCR A REDUCE COUNT
 JNZ INP1 DO THEM ALL
*
*EXIT WITHOUT WRITING DIRECTORY
*
GETOUT CALL WRIMSG OUTPUT MESSAGE
 STR 'DONE...' TEXT
 DB $0D NEW LINE
 SUB A INDICATE SUCCESS
ABORT SVC 30 EXIT TO DOS
*
*COPY A DISKETTE
*
COPY CALL WRIMSG OUTPUT MESSAGE
 STRZ 'TO DRIVE#?' TEXT
 SVC 13 GET INPUT
 SVC 14 SKIP TO PARAMETER
 SUI $31 CONVERT TO BINARY
 CPI 3 0-2 = (1-3)
 JNC BADOPR BAD OPERAND
 INR A FIX TO ACTIAL DISK ID.
 STA FDA SAVE DESTINATION DRIVE
 LXI H,0 BEGIN AT SECTOR 0
 MVI A,5 MOVE 5 BLOCKS (5 * 70 = 350)
CPL1 CALL CFER COPY BLOCK
 LXI D,70 OFFSET TO NEXT BLOCK
 DAD D ADJUST
 DCR A REDUCE COUNT
 JNZ CPL1 CONTINNUE
 JMP GETOUT AND EXIT
*COPY 70 SECTORS FROM SOURCE TO DESTINATION DRIVE
CFER PUSH PSW SAVE BLOCK COUNT
 MVI B,1 READ COMMAND
 LXI D,DATA DATA BUFFER
 PUSH H SAVE DISK ADDRESS
 MVI A,70 MOVE 70 SECTORS
 SVC 28 READ THE DISK
 JNZ ABORT FAILED
 POP H RESTORE ADDRESS
 PUSH H RESAVE ADDRESS
 LDA FDA GET DESTINATION DRIVE
 MOV C,A SET DRIVE FOR SVC
 MVI A,70 MOVE 70 SECTORS
 LXI D,DATA DATA BUFFER
 MVI B,0 WRITE COMMAND
 SVC 27 WRITE DISK
 JNZ ABORT FAILED...
 POP H RESTORE ADDRESS
 POP PSW RESTORE BLOCK COUNT
 RET
*REPORT A BAD OPERAND OR REQUEST
BADOPR CALL WRIMSG OUTPUT MESSAGE
 STR '?PARM' TEXT
 DB $0D NEWLINE
 MVI A,1 "OPERAND MISSING OR INVALID"
 SVC 30 EXIT
*
*WRITE MESSAGE [PC] TO CONSOLE
WRIMSG XTHL  SWAP TO HL
 SVC 8 OUTPUT
 XTHL  SWAP BACK
 RET
*
*COMMAND TABLE
*
CMDTAB DB $82
 STR 'SORT'
 DB $83
 STR 'COMPRES'
 DB $82
 STR 'INITIALIZE'
 DB $83
 STR 'COPY'
 DB $80
*
*DATA AREA
*
DIRADR DW 0 DIRECTORY ADDRESS IN RAM
FDA DW 0 FREE DISK ADDRESS
SA DW 0 SAVED DISK ADDRESS
CENT DW 0 CURRENT DIRECTORY ENTRY
NFA DW 0 NEW FILE ADDRESS
FS DW 0 FILE SIZE (HIGH IS ZERO)
'
 DB $82
 STR 'INITIALIZE'
 DB $83
 STR 'COPY'
 DB $80
*
*DATA AREA
*
DIRADR DW 0 DIRECTORY ADDRESS IN RAM
FDA DW 0 FREE DISK ADDRESS
SA DW 0 SAVED DISK ADDRESS
CENT DW 0 CURRENT DIRECTORY ENTRY
NFA DW 0 NEW FILE ADDRESS
FS DW 0 FILE SIZ*
*DMF "TYPE" FILE DISPLAY UTILITY BY D. DUNFIELD
*
 SVC 19 GET SINGLE FILENAME
 RNZ  FAILURE
 SVC 14 NEXT OPTION
 LXI H,1 ASSUME BEGIN AT LINE 1
 JZ NODAT NO START LINE GIVEN
 SVC 16 GET START LINE NUMBER
NODAT SHLD COUNT SAVE FOR LATER
 SVC 14 NEXT OPTION
 LXI H,$FFFF ASSUME ENTURE FILE
 JZ NOLIN NO LINE COUNT
 SVC 16 READ #LINES
 RNZ  BAD OPTION
NOLIN SHLD NLINES SAVE #LINES
 LXI H,TEXT DATA BUFFER
 SVC 26 CALCULATE DISK OPTINOS
 RNZ  CALCULATION ERROR
 MVI B,1 READ COMMAND
 SVC 28 READ DISK
 RNZ  DISK ERROR
 LXI D,TEXT POINT TO TEXT
 LHLD COUNT GET LINE COUNT
LINE MOV A,H GET HIGH
 ANA A TEST
 JNZ NXT NOT AT LINE 1 - WAIT
 MOV A,L GET LOW
 CPI 1 AT LINE 1
 JZ GOPRT YES, OUTPUT
NXT LDAX D READ DATA
 INX D ADVANCE TO NEXT
 CPI $FF END OF FILE?
 JZ NOLINE YES, EXIT
 CPI $0D END OF LINE?
 JNZ NXT NO, KEEP LOOKING
 DCX H REDUCE LINE COUNT
 JMP LINE AND RESAVE
*DISPLAY A LINE
GOPRT LHLD NLINES GET # LINES
LOOP MOV A,H GET COUNT
 ORA L TEST
 JZ EOF AT END - EXIT
 DCX H REDUCE
NOCR LDAX D GET SOURCE DATA
 INX D NEXT
 ANA A END OF FILE?
 JM EOF YES - EXIT
 SVC 3 DISPLAY
 CPI $0D END OF LINE?
 JNZ NOCR NO, KEEP GOING
 MVI A,10 LINE-FEED
 SVC 3 DISPLAY
 JMP LOOP DO NEXT LINE
*END OF FILE - RETURN SUCCESS
EOF SUB A
 RET
*END OF FILE FOUND BEFORE STARTING LINE
NOLINE LXI H,STLMSG POINT TO MESSAGE
 SVC 8 DISPLAY
 MVI A,99 RETURN CODE
 RET
STLMSG STR 'STARTING LINE NOT FOUND'
 DB $0D
COUNT DW 0 STARTING LINE
NLINES DW 0 # LINES TO OUTPUT
TEXT EQU * DATA BUFFER
F SUB A
 RET
*END OF FILE FOUND BEFORE STARTING LINE
NOLINE L*
*DMF "RENAME" FILE RENAME UTILITY BY D. DUNFIELD
*
 SVC 19 GET FILENAME
 SHLD NAMLOC SAVE LOCATION
 RNZ  INVALID FORMAT
 LXI B,11 OFFSET TO DISK DRIVE
 DAD B ADJUST OFFSET
 MOV A,M GET DRIVE
 STA COMP+1 SET DRIVE TO COMPARE
 SVC 24 LOOK FOR IT
 RNZ  NOT FOUND
 SHLD DIRLOC SAVE LOCATION
 SVC 19 GET FILENAME
 RNZ  NOT FOUND
 LXI B,11 OFFSET TO DRIVE
 DAD B ADJUST
 MOV A,M GET DRIVE
COMP CPI 0 DOES IT MATCH?
 JNZ BADDRV NO - REPORT ERROR
 SVC 23 LOOK FOR IT
 JZ BAD FILE ALREADY EXISTS
 LHLD NAMLOC GET NAME LOCATION
 XCHG  DE = NAME
 LHLD DIRLOC GET DIRECTORY ENTRY LOCATION
 MVI B,11 COPY 11 CHARACTERS
TOP LDAX D READ FROM NAME
 MOV M,A WRITE TO DIRECTORY
 INX D NEXT IN NAME
 INX H NEXT IN DIRECTORY
 DCR B REDUCE COUNT
 JNZ TOP DO THEM ALL
 SVC 22 REWRITE THE DIRECTORY
 RET
*NAME ALREADY EXISTS
BAD LXI H,EXISTS POINT TO MESSAGE
 SVC 8 OUTPUT
 MVI A,3 "ALREADY EXISTS"
 RET
*NEW FILENAME IS NOT ON SAME DRIVE
BADDRV LXI H,BADNAM POINT TO MESSAGE
 SVC 8 OUTPUT
 MVI A,99 GENERAL FAILURE
 RET
EXISTS STR 'FILE ALREADY EXISTS.'
 DB $0D
BADNAM STR 'FILES MUST BE ON SAME DRIVE.'
 DB $0D
DIRLOC DW 0 POINTER TO DIRECTORY BUFFER
NAMLOC DW 0 POINTER TO FILENAME BUFFER
E
BADDRV LXI H,BADNAM POINT TO MESSAGE
 SVC 8 OUTPUT
 MVI A,99 GENERAL FAILURE
 RET
EXISTS STR 'FILE ALREADY*
*DMF "@" COMMAND SCRIPT INTERPRETER BY D. DUNFIELD
*
VARS EQU *+$400
BLINE EQU VARS+$180
STACK EQU VARS+$1FF
TEXT EQU STACK+1
*
*PARSE FILENAME & LOAD FILE
 JMP GO NORMAL ENTRY POINT
 JMP STOR STORE TEXT
 JMP VSTOR STORE VALUE
GO PUSH D SAVE POINTER TO FILENAME
 SVC 41 GET SINGLE FILENAME
 JNZ QUIT BAD OPERAND
 MVI M,'C' APPEND 'C'
 INX H NEXT
 MVI M,'M' APPEND 'M'
 INX H NEXT
 MVI M,'D' APPEND 'D'
 LXI H,TEXT POINT TO DATA BUFFER
 PUSH D SAVE OPTIONS POINTER
 SVC 26 GET DISK PARAMETERS
 JNZ QUIT ERROR OCCURED
 MVI B,1 READ
 SVC 28 LOAD FILE INTO MEMORY
 POP D RESTORE PARM POINTER
 JNZ QUIT FAILED TO LOAD
*CLEAR LOCAL STORAGE
 LXI H,VARS ADDRESS VARIABLES
 LXI B,$180 SIZE OF VARIABLE BLOCK
CLV MVI M,' ' CLEAR
 INX H NEXT
 DCX B DO THEM ALL
 MOV A,B GET HIGH
 ORA C ALL DONE
 JNZ CLV DO THEM ALL
*ASSIGN COMMAND LINE VARIABLES
 MVI B,'A' FIRST VARIABLE
GETPRM SVC 14 GET NEXT OPTION
 JZ NOMORE NO MORE
 PUSH B SAVE VAR NUMBER
 MOV A,B GET VARIABLE
 CALL STOR STORE TEXT INTO VARIABLE
 POP B RESTORE VAR
 INR B NEXT
 JMP GETPRM GET NEXT ONE
*SET '@' TO CONTAIN NUMBER OF OPTIONS
NOMORE MOV A,B GET FINAL OPTION #
 SUI 'A' CONVERT TO BINARY
 MOV L,A SET LOW
 MVI H,0 ZERO HIGH
 MVI A,'@' ADDRESS SPECIAL '@' VARIBLE
 CALL VSTOR STORE VALUE INTO VARIBALE
 POP D RESTORE POINTER TO FILENAME
 MVI A,'N' SPECIAL 'N' VARIABLE
 CALL STOR STORE FILENAME INTO 'N'
 LXI H,REGAIN PROGEAM EXIT - REENTRY VECTOR
 SVC 39 TAKE OVER PROGRAM EXIT VECTOR
 LXI D,TEXT POINT TO DATA AREA
 SUB A GET ZERO
 STA LINE INIT LINE
EXEC LDA LINE LOAD LINE NUMBER
 INR A ADVANCE
 STA LINE RESAVE LINE NUMBER
EXEC1 LXI SP,STACK RESET STACK (IN CASE ERROR)
 PUSH D SAVE FILE POINTER
EXEC2 SVC 14 SKIP TO NEXT
 JZ NXT END OF LINE - GO TO NEXT
 CPI $FF END OF FILE?
 JZ TERM YES, EXIT
 CPI '&' SPECIAL COMMAND?
 JZ COMD YES, HANDLE IT
 CPI '-' LABEL IDENTIFIER?
 JZ LABL YES, HANDLE IT
 CPI '*' COMMENT?
 JZ NXT SKIP REMAINDER OF LINE
 CALL BLDLIN BUILD COMMAND LINE
 SVC 32 EXECUTE DOS COMMAND
*PROGRAM HAS TERMINATED
REGAIN MOV L,A GET RETURN CODE
 MVI H,0 ZERO HIGH
 MVI A,'R' SPECIAL 'R' VARIABLE
 CALL VSTOR STORE RETURN CODE VALUE INTO 'R'
NXT LXI SP,STACK-2 RESET STACK
 POP D RESTORE FILE POIJTER
 CALL NEWLIN SKIP TO NEW LINE
 JMP EXEC AND PROCEED
*ADVANCE DE TO POINT TO NEW LINE
NEWLIN LDAX D GET CHAR FROM LINE
 INX D NEXT
 CPI $0D END OF LINE
 JNZ NEWLIN KEEP LOOKING
 RET
*
*LABEL DEFINITION - SKIP OVER LINE
*
LABL LDAX D GET CHARACTER FROM LABEL
 INX D SKIP TO NEXT
 CPI ' ' LOOK FOR END OF LABEL
 JZ EXEC1 FOUND - PROCEED WITH LINE
 CPI $0D END OF LINE?
 JNZ LABL NO - KEEP LOOKING
 JMP EXEC PROCESS NEXT LINE
*
*END OF FILE HAS BEEN ENCOUNTERED - EXIT
*
TERM SUB A ZERO RETURN CODE
 JMP QUIT AND EXIT
*
*PROCESS AN EXPRESSION
*
EXPR INX D SKIP TO NEXT
 LDAX D GET CHARACTER
 INX D SKIP TO NEXT
 STA VCHR SAVE VARIABLE CHAR
 CALL BLDLIN BUILD LINE
 SVC 14 SKIP TO NON-BLANK
 INX D SKIP CHARACTER
 CPI '=' ASSIGNMENT?
 JNZ SYNT NO ERROR
 SVC 14 SKIP TO NEXT
 CALL GETOP GET OPERATOR
 CPI '+' ADDITION?
 JZ NUM PROCESS NUMERIC
 CPI '-' SUBTRACTION?
 JZ NUM PROCESS NUMERIC
 LDA VCHR GET VARIABLE BACK
 CALL STOR STORE TEXT INTO VARIABLE
 JMP NXT AND PROCESS NEXT LINE
*PROCESS NUMERIC EXPRESSION
NUM SVC 16 READ DECIMAL VALUE (LEFT)
 JNZ SYNT SYNTAX ERROR
 PUSH H SAVE VALUE
 SVC 14 SKIP TO NEXT
 PUSH PSW SAVE OPERATOR
 INX D SKIP OPERATOR
 SVC 16 READ DECIMAL VALUE (RIGHT)
 JNZ SYNT SYNTAX ERROR
 POP PSW RESTORE OPERATOR
 POP B RESTORE LEFT VALUE
 CPI '+' ADDITION?
 JNZ SUBT NO - MUST BE SUBTRACT ??? (ORDERING)
 DAD B ADD RIGHT AND LEFT
TERME CALL VSTV STORE VALUE INTO VARIABLE
 JMP NXT AND PROCESS NEXT LINE
SUBT MOV A,L GET LOW
 CMA  COMPLIMENT
 MOV L,A RESAVE
 MOV A,H GET HIGH
 CMA  COMPLIMENT
 MOV H,A RESAVE
 INX H TURN COMPLIMENT INTO NEGATE
 DAD B ADD (MAKING SUBTRACT)
 JMP TERME STORE VALUE
*
*UNRECOVERABLE SOURCE CODE/SYNTAX ERROR
*
SYNT LXI H,ERRMSG POINT TO MESSAGE
 SVC 8 DISPLAY
 LHLD LINE GET LINE #
 MVI H,0 ZERO HIGH
 SVC 11 DISPLAY
 SVC 6 NEW LINE
 MVI A,99 RETURN CODE=99
*
*TERMINATE COMMAND PROCESSOR
*
QUIT PUSH PSW SAVE RETURN CODE
 MVI H,0 0 = RESTORE VECTOR
 SVC 39 RESTORE PROGRAM TERMINATION VECTOR
 POP PSW RESTORE RETURN CODE
 SVC 30 AND EXIT
*
*GET NEXT OPERATOR AFTER CURRENT WORK
*IE: SKIP CURRENT, THEN PARSE SINGLE CHAR OPERATOR
*
GETOP PUSH D SAVE POSITION
 SVC 14 SKIP TO NON-BLANK
GEZ1 LDAX D GET NEXT CHARACTER
 INX D ADVANCE
 CPI ' ' SPACE?
 JZ ENDE YES, EXIT
 CPI $0D END OF LINE?
 JNZ GEZ1 KEEP LOOKING
ENDE SVC 14 SKIP TO NON-BLANK & GET CHAR
 POP D RESTORE DE
 RET
*
*SPECIAL COMMAND HANDLER
*
COMD LXI H,CTAB POINT TO COMMAND TABLE
 SVC 36 LOOKUP COMMAND
*TYPE COMMAND(S)
 DCR A TEST FOR TYPEN
 DCR A TEST FOR TYPE
 JP INPUT NO, TRY NEXT
NOIND PUSH PSW SAVE INDICATOR
 CALL BLDLIN BUILD THE LINE
 SVC 14 SKIP TO NEXT
TYPE LDAX D READ DATA
 INX D ADVANCE
 CPI $0D END OF LINE?
 JZ ENTYP YES, EXIT
 SVC 3 DISPLAY ON CONSOLE
 JMP TYPE AND GET NEXT
ENTYP POP PSW RESTORE COMMAND
 INR A TYPE?
 JNZ NXT NO, NO LFCR
 SVC 6 LFCR
 JMP NXT NEXT COMMAND
*INPUT COMMAND(S)
INPUT DCR A TEST FOR READN
 DCR A TEST FOR READ
 JP SKIP NO, TRY NEXT
 XCHG  SAVE COMMAND POINTER
 INR A TYPE?
 JZ NO13 YES, USE PROMPT
 SVC 13 GET LINE NO PROMPT
 JMP SWPHL & CONTINUE
NO13 SVC 12 GET LINE WITH PROMPT
SWPHL XCHG  RESTORE COMMAND POINTER
READ SVC 14 SKIP TO NEXT
 JZ NXT NULL LIKE - SKIP
 CPI '&' VARIABLE?
 JNZ SYNT NO, SYNTAX ERROR
 INX D SKIP TO NAME
 LDAX D GET NAME
 INX D ADVANCE
 XCHG  RETURN TO INPUT DATA
 PUSH H SAVE COMMAND COMMAND POINTER
 PUSH PSW SAVE VARIABLE
 SVC 14 SKIP TO NEXT
 POP PSW RESTORE VARIABLE
 CALL STOR STORE INTO VARIABLE
 POP H RESTORE COMMAND POINTER
 XCHG  RETURN TO FILE DATA
 JMP READ HANDLE NEXT VARIABLE
*
*SKIP AHEAD <N> LINES IN COMMAND FILE
*
SKIP JNZ GOTO NOT SKIP
 CALL BLDLIN BUILD THE LINE
 SVC 16 GET # LINES TO SKIP
 JNZ SYNT SYNTAX ERROR
 INR L EXTRA ONE BECAUSE OUT LINE COUNTS
 POP D GET STACKED COMMAND POINTER
 LDA LINE GET LINE NUMBER
 MOV B,A SAVE
SK1 CALL NEWLIN SKIP LINE
 LDA LINE GET LINE NUMBER
 INR A ADVANCE
 STA LINE RESAVE
 DCR L REDUCE COUNT
 JZ EXEC1 WE FOUND IT
 LDAX D GET DATA FROM LINE
 ANA A END OF FILE?
 JP SK1 NO, KEEP LOOKING
 LXI H,SKMSG INDICATE SKIP ERR
 SVC 8 DISPLAY
 MOV A,B GET LINE
 STA LINE RESAVE
 JMP SYNT INDICATE ERROR
*
*ADVANCE TO A SPECIFIC LABEL
GOTO DCR A GOTO?
 JNZ IF NO, TRY NEXT
 CALL BLDLIN BUILD LINE
 SVC 14 SKIP TO NEXT
 CPI '-' LABEL NAME?
 JNZ SYNT NO, ERROR
 LXI H,TEXT POINT TO START OF FILE
 MVI C,1 NEW LINE COUNT
 XCHG  HL = LABEL
 INX H SKIP
 SHLD ADR SAVE ADDRESS
GLP LHLD ADR GET LABEL ADDRESS
GLP1 LDAX D GET CHAR FROM SOURCE
 ANA A END OF FILE?
 JM NOLINE YES, GIVE UP
 PUSH D SAVE POSITION
 CPI '-' IS IT A LABEL?
 JNZ NOTIT NO, DON'T BOTHER
GLP2 INX D SKIP TO NEXT
 LDAX D READ CHARACTER
 CPI ' ' END OF WORD?
 JZ ENDG YES - HANDLE
 CPI $0D END OF LINE?
 JZ ENDG YES - HANDLE
 CMP M MATCH LABEL?
 INX H SKIP TO NEXT
 JZ GLP2 AND KEEP LOOKING
*NOT THIS ONE - TRY NEXT LINE
NOTIT CALL NEWLIN READ NEXT LINE
 INR C ADVANCE LINE NUMBER
 POP H RESTORE POSITION
 JMP GLP AND TRY THIS ONE
ENDG MOV A,M GET DATA
 CPI $0D END OF LINE?
 JZ EOKG YES, THIS IS THE LABEL?
 CPI ' ' END OF WORD?
 JNZ NOTIT NO, THIS IS NOT IT
*WE FOUND THE LABEL
EOKG MOV A,C GET LINE NUMBER
 STA LINE SAVE
 POP D RESTORE POSTIION
 JMP EXEC1 AND EXECUTE
*WE SEARCHED ENTIRE FILE AND DID NOT FIND THE LABEL
NOLINE LXI H,LBLMSG POINT TO MESSAGE
 SVC 8 ISSUE
 JMP SYNT AND EXIT
*
*IF STATEMENT - CONDITIONAL EXECUTION
*
IF DCR A IS THIS IF?
 JNZ EXIT NO, TRY NEXT
 CALL BLDLIN BUILD A LINE
 CALL GETOP GET FOLLOWING OPERATOR
 CPI '=' IS IT EQUALITY?
 JZ EQU HANDLE EQUALITY
 SVC 16 GET LEFT DECIMAL VALUE
 JNZ SYNT ERROR
 PUSH H SAVE LEFT
 SVC 14 SKIP TO BLANK
 PUSH PSW SAVE OPERATOR
 INX D SKIP OPERATOR
 SVC 16 GET RIGHT DECIMAL VALUE
 JNZ SYNT ERROR
 POP PSW RESTORE OPERATOR
 POP B RESTORE LEFT
 CPI '>' GREATER THAN?
 JZ GRTR HANDLE >
 CPI '<' LESS THAN?
 JNZ SYNT NO - ERROR
*PERFORM < TEST
LESS CALL NCOMP COMPARE
 JZ NXT EQUAL - SKIP
 JC NXT > - SKIP
 JMP GOIF DO THE COMMAND
*PERFORM > TEST
GRTR CALL NCOMP COMPARE
 JNC NXT <= - SKIP
 JMP GOIF DO THE COMMAND
*'=' TEST - PERFORM AS TEXT
EQU SVC 14 SKIP TO LEFT
 PUSH D SAVE POINTER
 CALL ADVNC ADVANCE TO END
 INX D SKIP '='
 SVC 14 SKIP TO RIGHT
 POP H RESTORE LEFT
CMPLP LDAX D GET CHAR FROM RIGHT
 CMP M SAME AS LEFT?
 INX D NEXT RIGHT
 INX H NEXT LEFT
 JNZ NXT DIFFERENT - STOP
 CPI ' ' END OF WORK
 JNZ CMPLP KEEP LOOKING
*EXECUTE COMMAND
GOIF POP D RESTORE POINTER
 CALL ADVNC SKIP &IF
 CALL ADVNC SKIP OPERATOR
 INX D SKIP TO OPERATOR
 SVC 14 SKIP TO RIGHT
 CALL ADVNC SKIP RIGHT
 JMP EXEC1 AND EXECUTE
*
*SKIP TO END OF INPUT LINE WORD
*
ADVNC LDAX D GET INPUT
 INX D SKIP TO NEXT
 CPI ' ' SPACE?
 JNZ ADVNC NO, KEEP LOOKING
 SVC 14 SKIP TO NEXT
 RET
*
*EXIT COMMAND - TERMINATE PROCESSING
*
EXIT DCR A EXIT?
 JNZ ANUM NO, TRY NEXT
 CALL BLDLIN BUILD LINE
 SVC 16 GET VALUE
 JNZ SYNT ERROR
 MOV A,L GET RETURN CODE
 JMP QUIT AND EXIT
*
*TEST FOR NUMERIC INPUT
*
ANUM DCR A NUM?
 JNZ EXPR NO, TRY NEXT
 CALL BLDLIN BUILD LINE
 SVC 14 READ NEXT
 JZ NBAD INVALID (NO OPERANDS)
NUM1 SVC 14 SKIP TO NEXT
NUM2 LDAX D READ DATA
 INX D NEXT
 CPI ' ' END OF ARGUMENT?
 JZ NUM1 YES, PROCESS NEXT
 CPI $0D RETURN?
 JZ AOK ALL DONE
 CPI '0' NUMERIC
 JC NBAD NO - INVALID
 CPI $3A < '9'+1?
 JC NUM2 YES, KEEP GOING
*NUMERIC ARGUMENTS FAILED TEST
NBAD MVI L,1 INDICATE NON-NUMERIC
 JMP NGO AND SAVE
*NUMERIC ARGUMENTS PASSED
AOK MVI L,0 INDICATE NUMERIC
NGO MVI H,0 ZERO HIGH
 MVI A,'R' SELECT 'R' RETURN CODE
 CALL VSTOR STORE
 JMP NXT AND PROCESS
*
*STORE A VALUE INTO A VARIABLE
*
VSTOR STA VCHR SAVE VARIABLE
VSTV PUSH D SAVE DE
 SUB A CONVERT TO BINARY
 PUSH PSW SAVE FOR LATER
*STACK DIGITS IN REVERSE ORDER
PTOP LXI B,$FFF6 START WITH -10
 MOV D,B -1
 MOV E,B -1
PLB0 DAD B ADD 10
 INX D INCREMENT RESULT
 JC PLB0 NOT THERE YET
 MOV A,L GET LOW ORDER
 ADI $3A CONVERT TO ASCII
 PUSH PSW STACK FOR REVERSE
 XCHG  HL = HL/10
 MOV A,H GET VALUE
 ORA L MORE TO GO?
 JNZ PTOP DO THEM ALL
*COMPUTE ADDRESS FOR VARIABLE
 LDA VCHR GET VARIABLE CHARACTER
 SUI $40 CONVERT TO BINARY
 CPI 27 IN RANGE?
 JNC SYNT BAD NAME - ERROR
 MOV C,A X1
 ADD A X2
 ADD A X4
 ADD A X8
 SUB C X7
 ADD A X14
 MOV C,A SET LOW ADDRESS
 MVI A,=VARS POINT TO VARS
 ACI 0 INCLUDE CARRY
 MOV B,A SET HIGH ADDRESS
*UNSTACK DIGHTS (IN CORRECT ORDER)
PNOUT POP PSW GET DIGIT
 JNC SKP0 END OF DIGIT STACK
 STAX B SAVE IN OUTPUT
 INX B NEXT
 JMP PNOUT DO MORE
SKP0 MVI A,' ' TERMINATE WITH SPACE
 STAX B SAVE
 POP D RESTORE DE
 RET
*
*BUILD A LINE WITH VARIBLE SUBSTITUTION
*
BLDLIN LXI H,BLINE POINT TO LINE
 MVI M,' ' BEGIN WITH ' ' (FOR BACK SEARCH)
 INX H ADVANCE
BLD1 LDAX D READ FROM SOURCE
 INX D NEXT
 CPI '&' VARIABLE?
 JZ VAR YES, HANDLE IT
 MOV M,A COPY TO OUTPUT
 INX H ADVANCE
 CPI $0D END OF LINE?
 JNZ BLD1 DO ENTRE LINE
 LXI D,BLINE POINT TO BUILT LINE
 RET
*SUBSTITUTE VARIABLE CONTENT
VAR LDAX D GET VARIABLE
 INX D NEXT
 SUI $40 CONVERT TO BINARY
 CPI 27 IN RANGE?
 JNC SYNT NO - ERROR
*COMPUTE VARIABLE ADDRESS
 MOV C,A X1
 ADD A X2
 ADD A X4
 ADD A X8
 SUB C X7
 ADD A X14
 MOV C,A SET LOW ADDRESS
 MVI A,=VARS POINT TO VARS
 ACI 0 ADJUST FOR CARRY
 MOV B,A SET HIGH ADDRESS
*COPY VARIABLE CONTENT INTO OUTPUT
 PUSH D SAVE POINTER
 MVI D,14 MOVE 14 CHARS
GL1 LDAX B READ FROM VARIABLE
 MOV M,A WRITE TO OUTPUT
 INX B NEXT IN VARIABLE
 CPI ' ' END OF VARIABLE?
 JZ GOUT YES, STOP
 INX H NEXT IN OUTPUT
 DCR D REDUCE COUNT
 JNZ GL1 DO THEM ALL
GOUT POP D RESTORE POINTER
 JMP BLD1 AND CONTINUE BUILDING
*
*STORE TEXT INTO A VARIABLE
*
STOR SUI $40 CONVERT TO BINARY
 CPI 27 IN RANGE?
 JNC SYNT NO - ERROR
 MOV C,A X1
 ADD A X2
 ADD A X4
 ADD A X8
 SUB C X7
 ADD A X14
 MOV C,A SET LOW ADDRESS
 MVI A,=VARS POINT TO VARIABLES
 ACI 0 ADJUST FOR CARRY
 MOV B,A SET HIGH ADDRESS
 MVI L,14 COPY UP TO 14 CHARS
ST1 LDAX D READ FROM SOURCE
 INX D NEXT IN SOURCE
 STAX B WRITE TO VARIABLE
 CPI $0D END OFFLINE?
 JZ CR YES, HANDLE IT
 INX B NEXT IN VARIABLE
 CPI ' ' END OF WORD?
 RZ  YES, HANDLE IT
 DCR L REDUCE COUNT
 JNZ ST1 DO THEM ALL
*SKIP TO END OF INPUT WORD (TRUNCATE)
XX LDAX D READ FROM INPUT
 INX D NEXT IN INPUT
 CPI ' ' END OF WORK?
 RZ  YES
 CPI $0D END OF LINE?
 JNZ XX NO, KEEP LOOKING
 DCX D BACKUP TO EOL
 RET
*CARRIAGE RETURN - TERMINATE WORD WITH BLANK
CR MVI A,' ' GET BLANK
 STAX B SAVE IT
 DCX D BACKUP TO CR
 RET
*
*COMPARE HL WITH BX
*
NCOMP MOV A,H GET HIGH
 CMP B SAME?
 RNZ  NO NEED TO GO FURTHER
 MOV A,L GET LOW
 CMP C COMPARE?
 RET
*MESSAGE STRINGS
ERRMSG STRZ 'ERR,L='
SKMSG STRZ 'SKIP '
LBLMSG STRZ 'LABEL '
*COMMAND LOOKUP TABLE
CTAB DB $86
 STR '&TYPEN'
 DB $85
 STR '&TYPE'
 DB $86
 STR '&READN'
 DB $85
 STR '&READ'
 DB $85
 STR '&SKIP'
 DB $85
 STR '&GOTO'
 DB $83
 STR '&IF'
 DB $85
 STR '&EXIT'
 DB $84
 STR '&NUM'
 DB $80
*VARIABLE STORAGE
VCHR DB 0
LINE DB 0
ADR DW 0
ENDIT EQU *
 DB $86
 STR '&TYPEN'
 DB $85
 STR '&TYPE*
*DMF "CMDUTIL" COMMAND SCRIPT HELPER UTILITY BY D. DUNFIELD
*
CMD EQU $E000 BASE ADDRESS OF CMD UTILITY
CSTOR EQU CMD+3 ADDRESS TO STORE TEXT
VSTOR EQU CMD+6 ADDRESS TO STORE VALUE
*
*FIRST CHECK STACK TO VERIFY THAT WE ARE CALLED FROM CMD
 LXI H,0 BEGIN WITH ZERO
 DAD SP GET STACK
 SHLD QUIT+1 SAVE FOR LATER
 MOV A,H GET HIGH ADDRESS
 CPI =CMD+$500 CALLED FROM CMDUTIL?
 JNZ NOCMD NO, REPORT ERROR
*LOOKUP COMMAND IN TABLE
 LXI H,TABLE POINT TO COMMAND TABLE
 SVC 36 LOOK UP COMMAND
 ANA A FILE?
 JZ FILE YES, HANDLE IT
 DCR A DEC?
 JZ DEC YES, HANDLE IT
 DCR A HEX?
 JZ HEX YES, HANDLE IT
 LXI H,BADOPT POINT TO MESSAGE
 SVC 8 DISPLAY
 MVI A,1 RC=1 (BAD OPERAND)
 RET
*FILE COMMAND
FILE SVC 19 GET FILENAME
 RNZ  ERROR
 SVC 24 LOOK IT UP
 RNZ  ERROR
 LXI B,11 OFFSET TO DISK ADDRESS
 DAD B ADJUST POINTER
 MOV B,M GET HIGH ADDRESS
 INX H NEXT
 MOV C,M GET LOW ADDRESS
 CALL STOR STORE INTO VARIABLE & INC
 MOV C,M GET SIZE
 MVI B,0 ZERO HIGH
 CALL STOR STORE INTO VARIABLE & INC
 MOV B,M GET USER DATA
 INX H ADVANCE
 MOV L,M GET LOW BYTE
 MOV H,B COPY
 JMP SAVHEX AND SAVE
*PARSE VARIABLE FROM COMMAND LINE & STORE
STOR PUSH H SAVE H
 SVC 14 SKIP TO NON-BLANK
 PUSH D SAVE POINTER
 JZ ENDIT END OF LINE
 LDAX D GET CHARACTER
 MOV H,B SAVE VALUE
 MOV L,C INTO HL
 CALL ESTOR STORE IT
 POP D RESTORE COMMAND LINE
 POP H RESTORE DIR POINTER
 INX D SKIP VARIABLE NAME
 INX H SKIP TO NEXT IN DIR
 SUB A INDICATE SUCCESS
 RET
*NO MORE OPERANDS - STOP STORING
ENDIT SUB A END OF LINE WAS ENCOUNTERED
*RETURN TO CALLER - RESTORE STACK FRIST
QUIT LXI SP,0 RESTORE STACK
 RET
*PERFORM A STORE
ESTOR MOV B,A SAVE FOR LATER
 SUI $40 CONVERT TO BINARY
 CPI 27 IN RANGE?
 MOV A,B RESTORE
 JC VSTOR OK TO PROCEED
*BAD VARIABLE NAME - ISSUE MESSAGE * EXIT
NOVAR LXI H,BADVAR POINT TO MESSAGE
 SVC 8 DISPLAY
 MVI A,99 RETURN CODE
 JMP QUIT EXIT
*NOT CALLED FROM COMMAND FILE
NOCMD LXI H,CMDONL POINT TO MESSAGE
 SVC 8 DISPLAY
 MVI A,100 RETURN CODE
 RET
*COMMAND LOOKUP TABLE
TABLE DB $83
 STR 'FILE'
 DB $83
 STR 'DEC'
 DB $83
 STR 'HEX'
 DB $80
*CONVERT HEX VALUE INTO DECIMAL
DEC SVC 15 GET HEX VALUE
 RNZ  ERROR
 SVC 14 SKIP TO VARIABLE
 CALL ESTOR STORE IT
 SUB A INDICATE SUCCESS
 RET
*CONVERT DECIMAL VALUE INTO HEX
HEX SVC 16 GET DECIMAL OPERAND
 RNZ
SAVHEX SVC 14 SKIP TO VARIABLE
 PUSH PSW SAVE VARIABLE NAME
 LXI D,SPARE POINT TO BUFFER
 MOV A,H GET HIGH VALUE
 CALL SAVBYT SAVE IT
 MOV A,L GET LOW BYTE
 CALL SAVBYT SAVE IT
 MVI A,' ' BLANK TERMINATE
 STAX D TERMINATE BUFFER
 LXI D,SPARE RESET TO BEGINNING
 POP PSW RESTORE VARIABLE
 MOV B,A MAKE COPY
 SUI $40 CONVERT TO BINARY
 CPI $27 IN RANGE?
 JNC NOVAR NO, REPORT ERROR
 MOV A,B RESTORE
 CALL CSTOR SAVE AS TEXT
 SUB A RETURN A
 RET
*WRITE A SINGLE BYTE TO THE MEMORY BUFFER
SAVBYT PUSH PSW SAVE VALUE
 RRC  SHIFT
 RRC  HIGH
 RRC  INTO
 RRC  LOW
 CALL HSAV SAVE IT
 POP PSW RESTORE VALUE
HSAV ANI $0F SAVE ONLY THIS NIBBLE
 ORI $30 CONVERT TO BINARY
 CPI $3A IN RANGE
 JC OKH YES - IT'S OK
 ADI 7 ADJUST A-F TO ASCII
OKH STAX D SAVE IN BUFFER
 INX D NEXT
 RET
*FIXED MESSAGES
BADOPT STR 'INVALID OPTION'
 DB $0D
BADVAR STR 'INVALID VARIABLE OPERAND'
 DB $0D
CMDONL STR 'CALL FROM CMD FILE.'
 DB $0D
*BUFFER FOR HEX DATA STORATE
SPARE STR '         '
7 ADJUST A-F TO ASCII
OKH STAX D SAVE IN BUFFER
 INX D NEXT
 RET
*FIXED MESSAGES
BADOPT STR 'INVALID OPTION'
 DB $0D
B*
*DMF "BGND" BACKGROUND PROCESS UTILITY BY D. DUNFIELD
*
RUNRAM EQU $E000 RUN LOCATION
*
CIN EQU $0020 CONSOLE INPUT ADDRESS
COUT EQU $0028 CONSOLE OUTPUT ADDRESS
CTEST EQU $0030 CONSOLE TEST FUNCTION
XXX JMP START
*
START SVC 41 GET SINGLE FILENAME
 RNZ
 MVI M,'B' APPEND 'B'
 INX H NEXT
 MVI M,'G' APPEND 'G'
 INX H NEXT
 MVI M,'T' APPEND 'T'
 XCHG  GET COMMAND POINTER
 SHLD DEPOS SAVE FOR LATER
 LXI H,RUNRAM POINT TO RUN LOCATION
 SVC 26 CALCULATE DISK OPERANDS
 RNZ  ERROR
 SVC 28 READ FILE INTO MEMORY
 RNZ  ERROR
 LXI H,STRMSG POINT TO STARTUP MESSAGE
 SVC 8 DISPLAY
 LHLD DEPOS GET COMMAND LINE
 XCHG  DE = COMMAND LINE
 SVC 14 SKIP TO NEXT
 CALL RUNRAM INITIALIZE PROGRAM
*PATCH CONSOLE VECTORS
 LHLD CIN+1 GET CURRENT CONSOLE INPUT
 SHLD OLDIN+1 SAVE IT
 LHLD COUT+1 GET CURRENT CONSOLE OUTPUT
 SHLD OLDOUT+1 SAVE IT
 LHLD CTEST+1 GET CURRENT CONSOLE TEST
 SHLD OLDTST+1 SAVE IT
 SHLD PATCHIN+1 PATCH INPUT
 LXI H,NEWIN NEW INPUT VECTOR
 SHLD CIN+1 WRITE IT
 LXI H,NEWOUT NEW OUTPUT VECTOR
 SHLD COUT+1 WRITE IT
 LXI H,NEWTST NEW TEST VECTOR
 SHLD CTEST+1 WRITE IT
 LXI H,TERM PATCH TO TERMINATION
 SHLD XXX+1 SAVE IT
 SUB A ZERO RETURN
INOK RET
*
*REPLACEMENT CONSOLE INPUT FUNCTION
*- CALL BACKGROUND TASK DURING POLLING LOOP.
*
NEWIN ANA A DEVICE ZERO
OLDIN JNZ $E900 NO - USE OLD HANDLER
PATCHIN CALL $E900 TEST CONSOLE
 JC INOK WE HAVE DATA
 PUSH H SAVE HL
 PUSH D SAVE DE
 PUSH B SAVE BC
 CALL RUNRAM+3 CALL BACKGROUND
 POP B RESTORE BC
 POP D RESTORE DE
 POP H RESTORE HL
 JMP PATCHIN WAIT FOR IT
*
*REPLACEMENT DEVICE OUTPUT FUNCTION
*- CALL BACKGROUND TASK DURING POLLING LOOP
*
NEWOUT PUSH H SAVE HL
 PUSH D SAVE DE
 PUSH B SAVE BC
 PUSH PSW SAVE DEVICE
 CALL RUNRAM+6 CALL BACKGROUND
 POP PSW RESTORE DEVICE
 POP B RESTORE BC
 POP D RESTORE DE
 POP H RESTORE HL
OLDOUT JMP $E900 CALL OUTPUT FUNCTION
*
*REPLACEMENT CONSOLE TEST FUNCTION
*
NEWTST PUSH H SAVE HL
 PUSH D SAVE DE
 PUSH B SAVE BC
 CALL RUNRAM+9 CALL BACKGROUND
 POP B RESTORE BC
 POP D RESTORE DE
 POP H RESTORE HL
OLDTST JMP $E900 CALL TEST FUNCTION
*
*TERMINATE BACKGROUND TASK
*
TERM LHLD OLDIN+1 GET OLD VECTOR
 SHLD CIN+1 RESTORE
 LHLD OLDOUT+1 GET OLD VECTOR
 SHLD COUT+1 RESTORE
 LHLD OLDTST+1 GET OLD VECTOR
 SHLD CTEST+1 RESTORE
 LXI H,ENMSG POINT TO END MESSAGE
XLOP MOV B,M GET DATA
 SUB A OUT TO ZERO
 CALL COUT WRITE IT	???
 INX H NEXT VALUE
 CPI $0D END OF MESSAGE?
 JNZ XLOP DO IT ALL
 SUB A ZERO RC
 RET
ENMSG DB 7 BELL
 STR 'BACKGROUND TASK ENDED'
 DB $0A
 DB $0D
 RET
STRMSG STR 'BACKGROUND TASK STARTED'
 DB $0D
DEPOS DW 0 COMMAND LINE POINTER
FILE EQU *
COUT WRITE IT	???
 INX H NEXT VALUE
 CPI $0D END OF MESSAGE?
 JNZ XLOP DO IT ALL
 SUB A ZERO RC
 RET
ENMSG DB 7 BELL
 STR 'BACKGROUND TASK ENDED'
 DB $0A
 DB $0D
 RET
STRMSG STR 'BACKGROUND TASK STARTED'
 DB $0D
DEPOS DW 0 COMMAND LINE POINTER
FILE EQU *
*
*DMF "NSTAR" NORTHSTAR DOS EMULATOR BY D. DUNFIELD
*
HDE EQU 6
*
 LXI H,HDERR POINT TO HD ERROR HANDLER
 SHLD HDERR+1 SAVE IT
 SVC 41 GET FILENAME
 RNZ  ERROR - QUIT
 JMP START AND CONTINUE WITH STARTUP
 NOP  FILLER
*
*-- NORTHSTAR DOS ENTRY POINTS
*
*CONSOLE OUTPUT FUNCTION
COUT SVC 5 DMF COUT FUNCTION
 RET
*CONSOLE INPUT FUNCTION
CIN JMP CONIN PERFORM CONSOLE IN WITH LC->UC
*TERMINAL INITIALIZATION FUNCTION
TINIT RET  IGNORE
 RET  FILLER
 RET  FILLER
*CONTROL-C TEST
CTRLC SVC 1 DMF CTRL-C CHECK
 RET
HDERR JMP XHDERR ENTRY POINT
DLOOK JMP XDLOOK ENTRY POINT FOR DIRECTORY LOOKUP
DWRIT JMP XDWRIT ENTRY POINT FOR DIRECTORY WRITEBACK
DCOM JMP XDCOM ENTRY POINT FOR DISK COMMAND
LIST JMP XLIST ENTRY POINT FOR DIRECTORY LIST
DOS JMP XDOS ENTRY POINT FOR DOS REENTRY
RWCHK DB $00 READ AFTER WRITE CHECK FLAG (NO USED)
DOSERR JMP DOSERR DOS ERROR HAS OCCURED
 DB 0 INDICATES SINGLE-DENSITY
*HARD DISK ERROR - RESTORE STACK & EXIT
HERROR LHLD SAVSP GET SP
 SPHL  RESTORE STACK
 JMP HDERR PERFORM ERROR
XHDERR SVC 30 REENTER DOS
*RETURN TO OS
XDOS SUB A GET ZERO
 SVC 35 RESET CONSOLE OUTPUT
 SVC 30 RETURN TO DOS
*CONSOLE INPUT - TRANSLATE TO UPPERCASE
CONIN SVC 4 DOS CIN FUNCTION
 CPI $61 LOWER CASE?
 RC  NO - IT'S OK
 ANI $DF TRANSLATE TO UPPER
 RET
*DISK COMMAND:
*A=#BLKS B=W/R/V:0/1/2 C=DRIVE DE=RAMADDR HL=DISKADDR
XDCOM CALL GETSP SAVE SP IN CASE ERROR
 PUSH PSW SAVE # BLKS
 PUSH D SAVE RAMADDR
 PUSH H SAVE DISKADDR
 SVC 27 DMF DISK OPERATION
 POP H RESTORE DISKADDR
 POP D RESTORE RAMADDR
 CPI HDE HARD DRIVE ERROR? ???
 JZ HERROR HANDLE IT
 POP PSW RESTORE # BLOCKS
 ANA A CLEAR CARRY (OK)
 RET
*DIRECTORY LIST FUNCTION
*A=DRIVE L=OUTPUT DEVICE
XLIST CALL GETSP SAVE SP IN CASE ERROR
 ADI $30 CONVERT TO ASCII
 STA NSNAME+5 SET DRIVE FOR LIST
 MOV A,L GET PASSED DEVICE
 SVC 35 SET CONSOLE OUTPUT DEVICE
 LXI D,NSNAME POINT TO '*.#*'
 SVC 33 LIST DIRECTORY
 PUSH PSW SAVE RETURN CODE
 MVI A,$FF NO OUTPUT ???
 SVC 35 SET CONSOLE OUTPUT DEVICE
 POP PSW RESTORE RETURN CODE
 CPI HDE DRIVE ERROR?
 JZ HERROR HANDLE IT
 RET
NSNAME STR "*.#*,1" DIRECTORY MATCHING PATTERN
 DB $0D END OF LINE
*DIRECTORY LOOKUP ROUTINE
*A=DRIVE HL=FILENAME
XDLOOK CALL GETSP SAVE SP IN CASE ERROR
 STA DRIVE SAVE FOR LATER
 ADI $30 CONVERT TO ASCII
 MOV C,A SAVE DRIVE
 MOV A,M GET CHAR FROM FILENAME
 CPI $20 SPACE?
 JZ FNDNEW END OF NAME
 LXI D,FNBUF POINT TO FILENAME BUFFER
 CALL BLFILE ZERO THE FILENAME
XDL1 MOV A,M GET CHAR FROM NAME
 CPI $2C COMMA?
 JZ XDL2 YES - END OF NAME
 CPI $20 SPACE?
 JZ XDL3 YES - END OF NAME
 CPI $0D RETURN?
 JZ XDL3 YES - END OF NAME
 STAX D COPY INTO NAME
 INX H NEXT SOURCE
 INX D NEXT DEST
 JMP XDL1 COPY ENTIRE NAME
XDL2 INX H SKIP ','
 MOV C,M GET DRIVE
XDL3 MVI A,$2E GET '.'
 STAX D APPEND
 INX D NEXT
 MVI A,$23 GET '#'
 STAX D APPEND
 INX D NEXT
 MVI A,$30 GET '0'
 STAX D APPEND
 INX D NEXT
 MVI A,$2A GET '*'
 STAX D APPEND
 INX D NEXT
 MVI A,$2C GET ',' FOR DRIVE
 STAX D APPEND
 INX D NEXT
 MOV A,C GET DRIVE
 STAX D APPEND TO FILENAME
 SUI $30 CONVERT TO BINARY
 STA DRIVE SET OUR DRIVE
 SVC 29 SET DOS DISK DRIVE
 JNZ FERROR ERROR
 INX D SKIP DRIVE
 MVI A,$0D TERMINATE WITH CR
 STAX D STORE IT
 LXI D,FNBUF POINT TO FILENAME BUFFER
 SVC 17 PARSE FILENAME
 JNZ FERROR ERROR
 SVC 24 LOOKUP IN DIRECTORY
 CALL TSTHDE TEST FOR HDE
 JNZ FNDFRE NOT FOUND
 SHLD DMFDIR SAVE DMF DIRCTORY POINTER
*TRANSLATE INTO NORTH-STAR FORMAT
 LXI D,NSDIR POINT TO OUTPUT ENTRY
 MVI B,$08 MOVE 8 CHARS
XDL4 MOV A,M READ FROM DMF
 STAX D WRITE TO NS
 INX H NEXT DMF
 INX D NEXT NS
 DCR B FINISHED?
 JNZ XDL4 COPY THEM ALL
 INX H SKIP DMF TYPE1
 INX H SKIP DMF TYPE2
 MOV A,M GET DMF TYPE3
 SUI $30 CONVERT TO BINARY
 STA NSDIR+12 SAVE NS FILE TYPE
 INX H SKIP TYPE
 MOV A,M GET DMF DISK ADDRESS H
 STAX D SAVE IN NS H
 INX H NEXT DMF
 INX D NEXT NS
 MOV A,M GET DMF DISK ADDRESS L
 STAX D SAVE IN NS L
 INX H NEXT DMF
 MOV A,M GET DMF SIZE
 STA NSDIR+10 SAVE FOR LATER
 INX H NEXT DMF
 MOV A,M GET DMF UA
 STA NSDIR+13 SAVE NS UA
 CALL SWPADDR SWAP DISKADDR ENDIAN
 LXI H,NSDIR+8 POINT TO DIRECTORY ENTRY
 LDA DRIVE GET DRIVE
 ANA A CLEAR C
 RET
*NOT FOUND - RETURN FREE DISK AREA
FNDFRE SVC 37 LOCATE FREE AREA
 LDA DRIVE GET DRIVE
 STC  INDICATE NOT FOUND
 RET
*GENERAL ERROR
FERROR SUB A GET ZERO
 STC  INDICATE FAIL
 RET
*BLANK FILENAME - REQUEST FOR EMPTY DIR
FNDNEW MOV A,C GET DRIVE
 SUI $30 CONVERT TO BINARY
 SVC 29 SET DISK DRIVE
 JNZ FERROR ERROR
 SVC 21 READ DIRECTORY
 CALL TSTHDE TEST FOR HDE
 SVC 38 FIND FREE DIR ENTRY
 SHLD DMFDIR SAVE FOR LATER
 LXI H,NSDIR+8 POINT TO DIRECTORY ENTRY
 LDA DRIVE GET DRIVE
 ANA A CLEAR C
 RET
*TEST FOR HARD DISK ERROR & HANDLE
TSTHDE RZ  NO ERROR - DO NOTHING
 CPI HDE WAS IT HDE?
 JZ HERROR YES - HANDLE
 RET
*WRITE DIRECTRY ENTRY BACK TO DISK
XDWRIT CALL SAVSP SAVE SP IN CASE ERROR
 LXI D,NSDIR POINT TO NS ENTRY
 CALL SWPADDR ADJUST DISK ADDRESS TO DMF
 LHLD DMFDIR POINT TO DMF ENTRY
 MVI B,$08 COPY 8 BYTES
XDW1 LDAX D GET FROM NS
 MOV M,A WRITE TO DMF
 INX D NEXT NS
 INX H NEXT DMF
 DCR B DONE?
 JNZ XDW1 DO ALL 8
 MVI M,$23 SET DMF TYPE1 TO '#'
 INX H NEXT
 MVI M,$30 SET DMF TYPE2 TO '0'
 INX H NEXT
 LDA NSDIR+12 GET NS TYPE
 ADI $30 CONVERT TO ASCII
 MOV M,A SET DMF TYPE3
 INX H NEXT
 LDAX D GET NS DISK ADDRESS H
 MOV M,A SET DMF DISK ADDRESS H
 INX D NEXT NS
 INX H NEXT DMF
 LDAX D GET NS DISK ADDRESS L
 MOV M,A SET DMF DISK ADDRESS L
 INX H NET
 LDA NSDIR+10 GET NS FILE SIZE
 MOV M,A WRITE DMF FILE SIZE
 LDA NSDIR+13 GET NS USER DATA
 INX H NEXT
 MOV M,A WRITE DMF USER DATA
 SVC 22 WRITE DIRECTORY BACK TO DRIVE
 JMP TSTHDE TEST FOR HDE & RETURN
*RESET FILENAME TO BLANKS
BLFILE PUSH H SAVE HL
 PUSH B SAVE BC
 MVI B,$08 COPY 8 CHARS
 LXI H,NSDIR POINT TO FILENAME
BFIL1 MVI M,$20 SET TO SPACE
 INX H NEXT
 DCR B REDUCE COUNT
 JNZ BFIL1 SET THEM ALL
 POP B RESTORE B
 POP H RESTORE H
 RET
*SWAP ENDIAN OF NORTHSTAR ENTRY TO MATCH DMF
SWPADDR PUSH H SAVE HL
 LHLD NSDIR+8 GET NS DISK ADDRESS
 MOV A,L COPY LOW TO TEMP
 MOV L,H COPY HIGH TO LOW
 MOV H,A COPY TEMP TO HIGH
 SHLD NSDIR+8 RESAVE
 POP H RESTORE HL
 RET
*SAVE STACK POINTER
GETSP PUSH H SAVE HL
 LXI H,0-4 (ADJUST FOR RET + HL)
 DAD SP GET SP
 SHLD SAVSP SAVE SP
 POP H RESTORE H
 RET
*
*STARTUP - LOAD FILE INTO MEMORY
*
START MVI M,'#' APPEND '#'
 INX H NEXT
 MVI M,'0' APPEND '0'
 INX H NEXT
 MVI M,'1' APPEND '1'
 XCHG  GET COMMAND POSITION
 SHLD SCMDP SAVE FOR LATER
 SVC 24 LOCATE NAME IN DIRECTORY
 RNZ  FAILED - STOP
 PUSH H SAVE DIR POSITION
 LXI D,$000E OFFSET TO UDATA
 DAD D ADJUST POINTER
 MOV B,M GET RUN ADDR HI
 INX H NEXT
 MOV C,M GET RUN ADDR LO
 POP H RESTORE DIR POINTER
 SVC 25 COMPUTE DISK OPERANDS
 RNZ  FAILED - STOP
 PUSH D SAVE RUN ADDRESS
 SVC 28 READ FILE FROM DISK
 POP D RESTORE RUN ADDRESS
 RNZ  FAILED - STOP
 PUSH D RESAVE RUN ADDRESS
 LHLD SCMDP GET COMMAND POINTER
 RET  EXECUTE NS PROGRAM
*
SCMDP DW 0 SAVED COMMAND POINTER
SAVSP DW 0 SAVED STACK POINTER
NSDIR STR '        ' FILENAME
 DW 0 DISK ADDRESS
 DW 0 FILE SIZE
 DB 2 FILE TYPE
 DW 0 USER DATA
 DB 0 USER DATA
FNBUF STR 'ABCDEFGH.#0*,1  '
DRIVE DB $01 DRIVE INDICATOR
DMFDIR DW $0000 DMF DIRECTORY POINTER
OMMAND POINTER
SAVSP DW 0 SAVED STACK POINTER
NSDIR STR '        ' FILENAME
 DW 0 DISK ADDRESS
 DW 0 FILE SIZE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                