FORTH1  MAC d  FORTH2  MAC hd  OLDFORTHASM }                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ;****************************************
;* FIG-FORTH RELEASE 1.1 FOR THE 8080 *
;****************************************
; RELEASE & VERSION NUMBERS
FIGREL EQU 1 ; FIG RELEASE
FIGREV EQU 1 ; FIG REVISION
USRVER EQU 0 ; USER VERSION
; ;
; ; ASCII CHARACTERS USED
; ;
ADOT EQU 02EH ; PERIOD
BELL EQU 07H ; (G)
BSIN EQU 7FH ; INPUT BACKSPACE CHR = RUBOUT
BSOUT EQU 08H ; OUTPUT BACKSPACE (/H)
; ;
; ; MEMORY ALLOCATION
; ;
EM EQU 04000H ; TOP OF MEMORY + 1 = LIMIT
US EQU 40H ; USER VARIABLES SPACE
RTS EQU 0A0H ; RETURN STACK & TERM BUFF SPACE
; ;
INITR0 EQU 6000H-US ; (R0)
INITS0 EQU INITR0-RTS ; (S0)
;
;---------------------------- --------------
;
 ORG 500H
ORIG: NOP
 JMP CLD
 NOP
 JMP WRM
 DB FIGREL
 DB FIGREV
 DB USRVER
 DB 0EH
 DW TASK-7
 DW BSIN
 DW INITR0
;
; FOLLOWING USED BY COLD
; MUST BE IN SAME ORDER AS USER VARIABLES
 
 DW INITS0
 DW INITR0
 DW INITS0
 DW 1FH
 DW 0
 DW INITDP
 DW INITDP
 DW FORTH+6
;
; END DATA USED BY COLD
;
 DW 5H,0B320H
UP: DW INITR0
RPP: DW INITR0
BIP: DW 0
;
TNEXT: LXI H,BIP
 MOV A,M
 CMP C
 JNZ TNEX1
 INX H
 MOV A,M
 CMP B
 JNZ TNEX1
BREAK: NOP
 NOP
 NOP
TNEX1: LDAX B
 INX B
 MOV L,A
 JMP NEXT+3
;
DPUSH: PUSH D
HPUSH: PUSH H
NEXT: LDAX B
 INX B
 MOV L,A
 LDAX B
 INX B
 MOV H,A
NEXT1: MOV E,M
 INX H
 MOV D,M
 XCHG
 PCHL
;
DP0: DB 83H
 DB 'LI'
 DB 'T'+80H
 DW 0 ;(LFA)=0 MARKS END OF DICTIONARY
LIT: DW $+2
 LDAX B
 INX B
 MOV L,A
 LDAX B
 INX B
 MOV H,A
 JMP HPUSH
;
; EXECUTE
;
 DB 87H
 DB 'EXECUT'
 DB 'E'+80H
 DW LIT-6
EXEC: DW $+2
 POP H
 JMP NEXT1
;
; BRANCH
;
 DB 86H
 DB 'BRANC'
 DB 'H'+80H
 DW EXEC-0AH
BRAN: DW $+2
BRAN1: MOV H,B
 MOV L,C
 MOV E,M
 INX H
 MOV D,M
DCX H
 DAD D
 MOV C,L
 MOV B,H
 JMP NEXT
;
; 0BRANCH
;
 DB 87H
 DB '0BRANC'
 DB 'H'+80H
 DW BRAN-9
ZBRAN: DW $+2
 POP H
 MOV A,L
 ORA H
 JZ BRAN1
 INX B
 INX B
 JMP NEXT
;
; (LOOP)
;
 DB 86H
 DB '(LOOP'
 DB ')'+80H
 DW ZBRAN-0AH
XLOOP: DW $+2
 LXI D,1
XLOO1: LHLD RPP
 MOV A,M
 ADD E
 MOV M,A
 MOV E,A
 INX H
 MOV A,M
 ADC D
 MOV M,A
 INX H
 INR D
 DCR D
 MOV D,A
 JM XLOO2
 MOV A,E
 SUB M
 MOV A,D
 INX H
 SBB M
 JMP XLOO3
XLOO2: MOV A,M
 SUB E
 INX H
 MOV A,M
 SBB D
;
XLOO3: JM BRAN1
 INX H
 SHLD RPP
 INX B
 INX B
 JMP NEXT
;
; (+LOOP)
;
 DB 87H
 DB '(+LOOP'
 DB ')'+80H
 DW XLOOP-9
XPLOO: DW $+2
 POP D
 JMP XLOO1
;
; (DO)
;
 DB 84H
 DB '(D'
 DB 'O'
 DB ')'+80H
 DW XPLOO-0AH
XDO: DW $+2
 LHLD RPP ;(RP) <- (RP) - 4
 DCX H
 DCX H
 DCX H
 DCX H
 SHLD RPP
 POP D ;8R19 ,- 8S19 - INIT INDEX
 MOV M,E
 INX H
 MOV M,D
 POP D ;(R2) <- (S2) = LIMIT
 INX H
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; I
;
 DB 81H
 DB 'I'+80H
 DW XDO-7
IDO: DW $+2
 LHLD RPP
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
;
; DIGIT
;
 DB 85H
 DB 'DIGI'
 DB 'T'+80H
 DW IDO-4
DIGIT: DW $+2
 POP H
 POP D
 MOV A,E
 SUI 30H
 JM DIGI2
 CPI 0AH
 JM DIGI1
 SUI 7
 CPI 0AH
 JM DIGI2
DIGI1: CMP L
 JP DIGI2
 MOV E,A
 LXI H,1 ;(S1) <- TRUE
 JMP DPUSH
DIGI2: MOV L,H
 JMP HPUSH
;
; (FIND) (2-1)FAILURE (2-;)SUCCESS
;
 DB 86H
 DB '(FIND'
 DB ')'+80H
 DW DIGIT-8
PFIND: DW $+2
 POP D
PFIN1: POP H ;STRING ADDRESS
 PUSH H
 LDAX D
 XRA M
 ANI 3FH
 JNZ PFIN4
PFIN2: INX H
 INX D
 LDAX D
 XRA M
 ADD A
 JNZ PFIN3
 JNC PFIN2
 LXI H,5
 DAD D
 XTHL
PFIN6: DCX D
 LDAX D
 ORA A
 JP PFIN6
 MOV E,A
 MVI D,0
 LXI H,1
 JMP DPUSH ;SUCCESS EXIT
PFIN3: JC PFIN5
PFIN4: INX D
 LDAX D
 ORA A
 JP PFIN4
PFIN5: INX D
 XCHG
 MOV E,M
 INX H
 MOV D,M
 MOV A,D
 ORA E
 JNZ PFIN1
 POP H
 LXI H,0
 JMP HPUSH ;FAILURE EXIT
;
; ENCLOSE
;
 DB 87H
 DB 'ENCLOS'
 DB 'E'+80H
 DW PFIND-9
ENCL: DW $+2
 POP D ;(DE) <- (S1) = DELIMITER CHAR
 POP H ;(HL) <- (S2) = ADDR TEXT TO SCAN
 PUSH H ;(S4) <- ADDR
 MOV A,E
 MOV D,A ;(D) <- DELIM CHR
 MVI E,-1 ;INITIALIZE CHR OFFSET COUNTER
 DCX H ;(HL) <- ADDR - 1
; ;SKIP OVER LEADING DELIMITER CHRS
ENCL1: INX H
 INR E
 CMP M ;IF TEXT CHR = DELIM CHR
 JZ ENCL1 ;THEN LOOP AGAIN
; ;ELSE NON-DELIM CHR FOUND
 MVI D,0 ;(S3) <- (E) = OFFSET TO 1ST NON-DELIM
 PUSH D
 MOV D,A ;(D) <- DELIM CHR
 MOV A,M ;IF 1ST NON-DELIM = NULL
 ANA A
 JNZ ENCL2
 MVI D,0 ;THEN (S2) <- OFFSET TO BYTE
 INR E ; FOLLOWING NULL
 PUSH D
 DCR E ;(S1) <- OFFSET TO NULL
 PUSH D
 JMP NEXT
; ;ELSE TEXT CONTAINS NON-DELIM &
; ; NON-NULL CHR
ENCL2: MOV A,D ;(A) <- DELIM CHR
 INX H ;(HL) <- ADDR NEXT CHR
 INR E ;(E) <- OFFSET TO NEXT CHR
 CMP M ;IF NEXT CHR <> NULL
 JZ ENCL4
 MOV A,M ;AND IF NEXT CHR <> NULL
 ANA A
 JNZ ENCL2 ;THEN CONTINUE SCAN
; ;ELSE CHR = NULL
 MVI D,0 ;(S2) <- OFFSET TO NULL
 PUSH D
 PUSH D ;(S1) <- OFFSET TO NULL
 JMP NEXT
; ;ELSE CHR = DELIM CHR
ENCL4: MVI D,0 ;(S2) <- OFFSET TO BYTE
; ; FOLLOWING TEXT
 PUSH D
 INR E ;(S1) <- OFFSET TO 2 BYTES AFTER
; END OF WORD
 PUSH D
 JMP NEXT
;
; EMIT
;
 DB 84H
 DB 'EMI'
 DB 'T'+80H
 DW ENCL-0AH
EMIT: DW DOCOL ; :
 DW PEMIT ;DO USER SUPPLIED ROUTINE TO OUTPUT A CH
 DW ONE,OUTT ;INCR1 OUT
 DW PSTOR,SEMIS ; +! ;S
;
; KEY
;
 DB 83H
 DB 'KE'
 DB 'Y'+80H
 DW EMIT-7
KEY: DW $+2
 JMP PKEY ;DO USER SUPPLIED ROUTINE TO READ A CHAR
;
; ?TERMINAL
;
 DB 89H
 DB '?TERMINA'
 DB 'L'+80H
 DW KEY-6
QTERM: DW $+2
 LXI H,0
 JMP PQTER ;DO USER SUPPLIED ROUTINE TO SENSE A BRE
;
; CR
;
 DB 82H
 DB 'C'
 DB 'R'+80H
 DW QTERM-0CH
CR: DW $+2
 JMP PCR ;DO USER SUPPLIED ROUTINE TO OUTPUT A CR
;
; CMOVE
;
 DB 85H
 DB 'CMOV'
 DB 'E'+80H
 DW CR-5
CMOVE: DW $+2
 MOV L,C ;(HL) <- (IP)
 MOV H,B
 POP B ;(BC) <- (S1) = #CHRS
 POP D ;(DE) <- (S2) = DEST ADDR
 XTHL ;(HL) <- (S3) = SOURCE ADDR
; ;(S1) <- (IP)
 JMP CMOV2 ;RETURN IF #CHRS = 0
CMOV1: MOV A,M ;((DE)) <- ((HL))
 INX H ;INCR SOURCE ADDR
 STAX D
 INX D ;INCR DEST ADDR
 DCX B ;DECR #CHRS
CMOV2: MOV A,B
 ORA C
 JNZ CMOV1 ;REPEAT IF #CHRS <> 0
 POP B ;RESTORE (IP) FROM (S1)
 JMP NEXT
;
; U* ;16X16 UNSIGNED MULTIPLY
; ;AVG EXECUTION TIME = 994 CYCLES
 DB 82H
 DB 'U'
 DB '*'+80H
 DW CMOVE-8
USTAR: DW $+2
 POP D ;(DE) <- MPLIER
 POP H ;(HL) <- MPCAND
 PUSH B ;SAVE IP
 MOV B,H
 MOV A,L ;(BA) <- MPCAND
 CALL MPYX ;*AHL)1 <- MPCAND.LB * MPLIER
; ; 1ST PARTIAL PRODUCT
 PUSH H ;SAVE (HL)1
 MOV H,A
 MOV A,B
 MOV B,H ;SAVE (A)1
 CALL MPYX ;(AHL)2 <- MPCAND.HB * MPLIER
; ; 2ND PARTIAL PRODUCT
 POP D ;(DE) <- (HL)1
 MOV C,D ;(BC) <- (AH)1
; ;FORM SUM OF PARTIALS:
; ; (AHL) 1
; ; + (AHL) 2
; ; ____________
; ; (AHLE)
 DAD B ;(HL) <- (HL)2 + (AH)1
 ACI 0 ;(AHLE) <- (BA) * (DE)
 MOV D,L
 MOV L,H
 MOV H,A ;(HLDE) <- MPLIER * MPCAND
 POP B ;RESTORE IP
 PUSH D ;(S2) <- PRODUCT.LW
 JMP HPUSH ;(S1) <- PRODUCT.HW
;
; ;MULTIPLY PRIMITIVE
;
; ; (AHL) <- (A) * (DE)
; ;#BITS = 24 8 16
;
MPYX: LXI H,0 ;(HL) <- 0 = PARTIAL PRODUCT.LW
 MVI C,8 ;LOOP COUNTER
MPYX1: DAD H ;LEFT SHIFT (AHL) 24 BITS
 RAL
 JNC MPYX2 ;IF NEXT MPLIER BIT = 1
 DAD D ;THEN ADD MPCAND
 ACI 0
MPYX2: DCR C ;IF NOT LAST MPLIER BIT
 JNZ MPYX1 ;THEN LOOP AGAIN
 RET ;ELSE DONE
;
; U/
;
 DB 82H
 DB 'U'
 DB '/'+80H
 DW USTAR-5
USLAS: DW $+2
 LXI H,4
 DAD SP ;((HL)) <- NUMERATOR.LW
 MOV E,M ;(DE) <- NUMER.LW
 MOV M,C ;SAVE IP ON STACK
 INX H
 MOV D,M
 MOV M,B
 POP B ;(BC) <- DENOMINATOR
 POP H ;(HL) <- NUMER.HW
 MOV A,L
 SUB C ;IF NUMER >= DENOM
 MOV A,H
 SBB B
 JC USLA1
 LXI H,0FFFFH ;THEN OVERFLOW
 LXI D,0FFFFH ;SET REM & QUOT TO MAX
 JMP USLA7
USLA1: MVI A,16 ;LOOP COUNTER
USLA2: DAD H ;LEFT SHIFT (HLDA) THRU CARRY
 RAL
 XCHG
 DAD H
 JNC USLA3
 INX D
 ANA A
USLA3: XCHG ;SHIFT DONE
 RAR ;RESTORE 1ST CARRY
 PUSH PSW ;SAVE COUNTER
 JNC USLA4 ;IF CARRY = 1
 MOV A,L ;THEN (HL) <- (HL) - (BC)
 SUB C
 MOV L,A
 MOV A,H
 SBB B
 MOV H,A
 JMP USLA5
USLA4: MOV A,L ;ELSE TRY (HL) <- (HL) - (BC)
 SUB C
 MOV L,A
 MOV A,H
 SBB B ;(HL) <- PARTIAL REMAINDER
 MOV H,A
 JNC USLA5
 DAD B ;UNDERFLOW, RESTORE
 DCX D
USLA5: INX D ;INC QUOT
 POP PSW ;RESTORE COUNTER
 DCR A ;IF COUNTER > 0
 JNZ USLA2 ;THEN LOOP AGAIN
USLA7: POP B ;ELSE DONE, RESTORE IP
 PUSH H ;(S2) <- REMAINDER
 PUSH D ;(S1) <- QUOTIENT
 JMP NEXT
;
; ; AND LOGICAL OPERATOR
;
 DB 83H
 DB 'AN'
 DB 'D'+80H
 DW USLAS-5
ANDD: DW $+2 ;(S1) <- (S1) AND (S2)
 POP D
 POP H
 MOV A,E
 ANA L
 MOV L,A
 MOV A,D
 ANA H
 MOV H,A
 JMP HPUSH
;
; ORR
;
 DB 82H
 DB 'O'
 DB 'R'+80H
 DW ANDD -6 ; AND
ORR: DW $+2
 POP D
 POP H
 MOV A,E
 ORA L
 MOV L,A
 MOV A,D
 ORA H
 MOV H,A
 JMP HPUSH
;
; XOR LOGICAL OPERATOR
;
 DB 83H
 DB 'XO'
 DB 'R'+80H
 DW ORR-5
XORR: DW $+2
 POP D
 POP H
 MOV A,E
 XRA L
 MOV L,A
 MOV A,D
 XRA H
 MOV H,A
 JMP HPUSH
;
; SP@
;
 DB 83H
 DB 'SP'
 DB '@'+80H
 DW XORR-6
SPAT: DW $+2
 LXI H,0
 DAD SP
 JMP HPUSH
;
; SP!
;
 DB 83H
 DB 'SP'
 DB '!'+80H
 DW SPAT-6
SPSTO: DW $+2
 LHLD UP
 LXI D,6
 DAD D
 MOV E,M
 INX H
 MOV D,M
 XCHG
 SPHL
 JMP NEXT
;
; RP@
;
 DB 83H
 DB 'RP'
 DB '@'+80H
 DW SPSTO-6
RPAT: DW $+2 ;(S1) <- (RP)
 LHLD RPP
 JMP HPUSH
;
; RP! ;RETURN STACK POINTER STORE
;
 DB 83H
 DB 'RP'
 DB '!'+80H
 DW RPAT-6
RPSTO: DW $+2 ;(RP) <- (R0) (USER VARIABLE)
 LHLD UP ;(HL) <- USER VARIABLE BASE ADDR
 LXI D,8
 DAD D ;(HL) <- R0
 MOV E,M ;(DE) <- (R0)
 INX H
 MOV D,M
 XCHG
 SHLD RPP ;(RP) <- (R0)
 JMP NEXT
;
; ;S
;
 DB 82H
 DB ';'
 DB 'S'+80H
 DW RPSTO-6
SEMIS: DW $+2 ;(IP) <- (R1)
 LHLD RPP
 MOV C,M ;(BC) <- (R1)
 INX H
 MOV B,M
 INX H
 SHLD RPP ;(RP) <- (RP) + 2
 JMP NEXT
;
; LEAVE
;
 DB 85H
 DB 'LEAV'
 DB 'E'+80H
 DW SEMIS-5
LEAVE: DW $+2 ;LIMIT <- INDEX
 LHLD RPP
 MOV E,M ;(DE) <- (R1) = INDEX
 INX H
 MOV D,M
 INX H
 MOV M,E ;(R2) <- (DE) = LIMIT
 INX H
 MOV M,D
 JMP NEXT
;
; >R
;
 DB 82H
 DB '>'
 DB 'R'+80H
 DW LEAVE-8
TOR: DW $+2
 POP D
 LHLD RPP
 DCX H ;(RP) <- (RP) - 2
 DCX H
 SHLD RPP
 MOV M,E ;((HL)) <- (DE)
 INX H
 MOV M,D
 JMP NEXT
;
; R> ;
;
 DB 82H
 DB 'R'
 DB '>'+80H
 DW TOR-5
FROMR: DW $+2 ;(S1) <- (R1)
 LHLD RPP
 MOV E,M ;(DE) <- (R1)
 INX H
 MOV D,M
 INX H
 SHLD RPP ;(RP) <- (RP) + 2
 PUSH D ;(S1) <- (DE)
 JMP NEXT
;
; R
;
 DB 81H
 DB 'R'+80H
 DW FROMR-5
RR: DW IDO+2
;
; 0=
;
 DB 82H
 DB '0'
 DB '='+80H
 DW RR-4
ZEQU: DW $+2
 POP H
 MOV A,L
 ORA H
 LXI H,0
 JNZ ZEQU1
 INX H
ZEQU1: JMP HPUSH
;
; 0<
;
 DB 82H
 DB '0'
 DB '<'+80H
 DW ZEQU-5
ZLESS: DW $+2
 POP H
 DAD H
 LXI H,0
 JNC ZLES1
 INX H
ZLES1: JMP HPUSH
;
; +
;
 DB 81H
 DB '+'+80H
 DW ZLESS-5
PLUS: DW $+2
 POP D
 POP H
 DAD D
 JMP HPUSH
;
; D+ XLW XHW YLW YHW --- SLW SHW
; S4 S3 S2 S1 S2 S1
 DB 82H
 DB 'D'
 DB '+'+80H
 DW PLUS-4
DPLUS: DW $+2
 LXI H,6
 DAD SP ;((HL)) <- XLW
 MOV E,M ;(DE) = XLW
 MOV M,C ;SAVE IP ON STACK
 INX H
 MOV D,M
 MOV M,B
 POP B ;(BC) <- YHW
 POP H ;(HL) <- YLW
 DAD D
 XCHG ;(DE) <- YLW + XLW = SUM.LW
 POP H ;(HL) <- XHW
 MOV A,L
 ADC C
 MOV L,A ;(HL) <- YHW + XHW + CARRY
 MOV A,H
 ADC B
 MOV H,A
 POP B ;RESTORE IP
 PUSH D ;(S2) <- SUM.LW
 JMP HPUSH ;(S1) <- SUM.HW
;
; MINUS
;
 DB 85H
 DB 'MINU'
 DB 'S'+80H
 DW DPLUS-5
MINUS: DW $+2 ;(S1) <- -(S1) ( 2'S COMPLEMENT )
 POP H
 MOV A,L
 CMA
 MOV L,A
 MOV A,H
 CMA
 MOV H,A
 INX H
 JMP HPUSH
;
; DMINUS
;
 DB 86H
 DB 'DMINU'
 DB 'S'+80H
 DW MINUS-8
DMINU: DW $+2
 POP H ;(HL) <- HW
 POP D ;(DE) <- LW
 SUB A
 SUB E ;(DE) <- 0 - (DE)
 MOV E,A
 MVI A,0
 SBB D
 MOV D,A
 MVI A,0
 SBB L ;(HL) <- 0 - (HL)
 MOV L,A
 MVI A,0
 SBB H
 MOV H,A
 PUSH D ;(S2) <- LW
 JMP HPUSH ;(S1) <- HW
;
; OVER
;
 DB 84H
 DB 'OVE'
 DB 'R'+80H
 DW DMINU-9
OVER: DW $+2
 POP D
 POP H
 PUSH H
 JMP DPUSH
;
; DROP
;
 DB 84H
 DB 'DRO'
 DB 'P'+80H
 DW OVER-7
DROP: DW $+2
 POP H
 JMP NEXT
 
; SWAP
;
 DB 84H
 DB 'SWA'
 DB 'P'+80H
 DW DROP-7
SWAP: DW $+2
 POP H
 XTHL
 JMP HPUSH
;
; DUP
;
 DB 83H
 DB 'DU'
 DB 'P'+80H
 DW SWAP-7
DUP: DW $+2
 POP H
 PUSH H
 JMP HPUSH
;
; 2DUP
;
 DB 84H
 DB '2DU'
 DB 'P'+80H
 DW DUP-6
TDUP: DW $+2
 POP H
 POP D
 PUSH D
 PUSH H
 JMP DPUSH
;
; +!
;
 DB 82H
 DB '+'
 DB '!'+80H
 DW TDUP-7
PSTOR: DW $+2
 POP H
 POP D
 MOV A,M
 ADD E
 MOV M,A
 INX H
 MOV A,M
 ADC D
 MOV M,A
 JMP NEXT
;
; TOGGLE
;
 DB 86H
 DB 'TOGGL'
 DB 'E'+80H
 DW PSTOR-5
TOGGL: DW $+2
 POP D
 POP H
 MOV A,M
 XRA E
 MOV M,A
 JMP NEXT
;
; @
;
 DB 81H
 DB '@'+80H
 DW TOGGL-9
AT: DW $+2
 POP H
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
 
; C@
;
 DB 82H
 DB 'C'
 DB '@'+80H
 DW AT-4
CAT: DW $+2
 POP H
 MOV L,M
 MVI H,0
 JMP HPUSH
;
; 2@
;
 DB 82H
 DB '2'
 DB '@'+80H
 DW CAT-5
TAT: DW $+2
 POP H ;(HL) <- ADDR HW
 LXI D,2
 DAD D ;(HL) <- ADDR LW
 MOV E,M ;(DE) <- LW
 INX H
 MOV D,M
 PUSH D ;(S2) <- LW
 LXI D,-3 ;(HL) <- ADDR HW
 DAD D
 MOV E,M ;(DE) <- (HW
 INX H
 MOV D,M
 PUSH D ;(S1) <- HW
 JMP NEXT
;
; !
;
 DB 81H
 DB '!'+80H
 DW TAT-5
STORE: DW $+2
 POP H
 POP D
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; C!
;
 DB 82H
 DB 'C'
 DB '!'+80H
 DW STORE-4
CSTOR: DW $+2
 POP H
 POP D
 MOV M,E
 JMP NEXT
;
; 2!
;
 DB 82H
 DB '2'
 DB '!'+80H
 DW CSTOR-5
TSTOR: DW $+2
 POP H ;(HL) <- ADDR
 POP D ;(DE) <- HW
 MOV M,E ;(ADDR) <- HW
 INX H
 MOV M,D
 INX H ;(HL) <- ADDR LW
 POP D ;(DE) <- LW
 MOV M,E ;(ADDR+2) <- LW
 INX H
 MOV M,D
 JMP NEXT
;
; :
;
 DB 0C1H
 DB ':'+80H
 DW TSTOR-5
COLON: DW DOCOL ; :
 DW QEXEC ; ?EXEC
 DW SCSP ; !CSP
 DW CURR ; CURRENT
 DW AT ; @
 DW CONT ; CONTEXT
 DW STORE ; !
 DW CREAT ; CREATE
 DW RBRAC ; 
 DW PSCOD ; (;CODE)
DOCOL: LHLD RPP
 DCX H ;(R1) <- (IP)
 MOV M,B
 DCX H ;(RP) <- (RP) - 2
 MOV M,C
 SHLD RPP
 INX D ;(DE) <- CFA+2 = (W)
 MOV C,E ;(IP) <- (DE) = (W)
 MOV B,D
 JMP NEXT
;
; ;
;
 DB 0C1H
 DB ';'+80H
 DW COLON-4
SEMI: DW DOCOL ; :
 DW QCSP ; ?CSP
 DW COMP ; COMPILE
 DW SEMIS ; ;S
 DW SMUDG ; SMUDGE
 DW LBRAC ; 
 DW SEMIS ; ;S
;
; NOOP
;
 DB 84H
 DB 'NOO'
 DB 'P'+80H
 DW SEMI-4
NOOP: DW DOCOL ; :
 DW SEMIS ; ;S
;
; CONSTANT
;
 DB 88H
 DB 'CONSTAN'
 DB 'T'+80H
 DW NOOP-7
CON: DW DOCOL ; :
 DW CREAT ; CREATE
 DW SMUDG ; SMUDGE
 DW COMMA ; ,
 DW PSCOD ; (;CODE)
DOCON: INX D
 XCHG
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
;
; VARIABLE
;
 DB 88H
 DB 'VARIABL'
 DB 'E'+80H
 DW CON-0BH
VAR: DW DOCOL ; :
 DW CON ; CONSTANT
 DW PSCOD ; (;CODE)
 INX D
 PUSH D
 JMP NEXT
;
; USER
;
 DB 84H
 DB 'USE'
 DB 'R'+80H
 DW VAR-0BH
USER: DW DOCOL ; :
 DW CON ; CONSTANT
 DW PSCOD ; (;CODE)
DOUSE: INX D
 XCHG
 MOV E,M
 MVI D,0
 LHLD UP
 DAD D
 JMP HPUSH
;
; 0
;
 DB 81H
 DB '0'+80H
 DW USER-7
ZERO: DW DOCON
 DW 0
;
; 1
;
 DB 81H
 DB '1'+80H
 DW ZERO-4
ONE: DW DOCON
 DW 1
;
; 2
;
 DB 81H
 DB '2'+80H
 DW ONE-4
TWO: DW DOCON
 DW 2
;
; 3
;
 DB 81H
 DB '3'+80H
 DW TWO-4
THREE: DW DOCON
 DW 3
;
; BL
;
 DB 82H
 DB 'B'
 DB 'L'+80H
 DW THREE-4
BL: DW DOCON
 DW 20H
;
; C/L ( CHARACTERS PER LINE )
;
 DB 83H
 DB 'C/'
 DB 'L'+80H
 DW BL-5
CSLL: DW DOCON
 DW 64
;
; LIMIT
;
 DB 85H
 DB 'LIMI'
 DB 'T'+80H
 DW CSLL-6
LIMIT: DW DOCON
 DW EM
;
; +ORIGIN
;
 DB 87H
 DB '+ORIGI'
 DB 'N'+80H
 DW LIMIT-8
PORIG: DW DOCOL ; :
 DW LIT ; LIT
 DW ORIG
 DW PLUS ; +
 DW SEMIS ; ;S
;
; S0
;
 DB 82H
 DB 'S'
 DB '0'+80H
 DW PORIG-0AH
SZERO: DW DOUSE
 DW 6
;
; R0
;
 DB 82H
 DB 'R'
 DB '0'+80H
 DW SZERO-5
RZERO: DW DOUSE
 DW 8
;
; TIB
;
 DB 83H
 DB 'TI'
 DB 'B'+80H
 DW RZERO-5
TIB: DW DOUSE
 DB 0AH
;
; WIDTH
;
 DB 85H
 DB 'WIDT'
 DB 'H'+80H
 DW TIB-6
WIDTH: DW DOUSE
 DB 0CH
;
; WARNING
;
 DB 87H
 DB 'WARNIN'
 DB 'G'+80H
 DW WIDTH-8
WARN: DW DOUSE
 DB 0EH
;
; FENCE
;
 DB 85H
 DB 'FENC'
 DB 'E'+80H
 DW WARN-0AH
FENCE: DW DOUSE
 DB 10H
;
; DP
;
 DB 82H
 DB 'D'
 DB 'P'+80H
 DW FENCE-8
DP: DW DOUSE
 DB 12H
;
; VOC-LINK
;
 DB 88H
 DB 'VOC-LIN'
 DB 'K'+80H
 DW DP-5
VOCL: DW DOUSE
 DW 14H
;
;BLK
;
 DB 83H
 DB 'BL'
 DB 'K'+80H
 DW VOCL-0BH
BLK: DW DOUSE
 DB 16H
;
; INN
;
 DB 82H
 DB 'I'
 DB 'N'+80H
 DW BLK-6
INN : DW DOUSE
 DB 18H
;
; OUTT
;
 DB 83H
 DB 'OU'
 DB 'T'+80H
 DW INN-5
OUTT: DW DOUSE
 DB 1AH
;
; SCR
;
 DB 83H
 DB 'SC'
 DB 'R'+80H
 DW OUTT-6
SCR: DW DOUSE
 DB 1CH
;
; OFFSET
;
 DB 86H
 DB 'OFFSE'
 DB 'T'+80H
 DW SCR-6
OFSET: DW DOUSE
 DB 1EH
;
; CONTEXT
;
 DB 87H
 DB 'CONTEX'
 DB 'T'+80H
 DW OFSET-9
CONT: DW DOUSE
 DB 20H
;
; CURRENT
;
 DB 87H
 DB 'CURREN'
 DB 'T'+80H
 DW CONT-0AH
CURR: DW DOUSE
 DB 22H
;
; STATE
;
 DB 85H
 DB 'STAT'
 DB 'E'+80H
 DW CURR-0AH
STATE: DW DOUSE
 DB 24H
;
; BASE
;
 DB 84H
 DB 'BAS'
 DB 'E'+80H
 DW STATE-8
BASE: DW DOUSE
 DB 26H
;
; DPL
;
 DB 83H
 DB 'DP'
 DB 'L'+80H
 DW BASE-7
DPL: DW DOUSE
 DB 28H
;
; FLD
;
 DB 83H
 DB 'FL'
 DB 'D'+80H
 DW DPL-6
FLD: DW DOUSE
 DB 2AH
;
; CSP
;
 DB 83H
 DB 'CS'
 DB 'P'+80H
 DW FLD-6
CSP: DW DOUSE
 DB 2CH
;
; R#
;
 DB 82H
 DB 'R'
 DB '#'+80H
 DW CSP-6
RNUM: DW DOUSE
 DB 2EH
;
; HLD
;
 DB 83H
 DB 'HL'
 DB 'D'+80H
 DW RNUM-5
HLD: DW DOUSE
 DW 30H
;
; 1+
;
 DB 82H
 DB '1'
 DB '+'+80H
 DW HLD-6
ONEP: DW DOCOL ; :
 DW ONE ; 1
 DW PLUS ; +
 DW SEMIS ; ;S
;
; 2+
;
 DB 82H
 DB '2'
 DB '+'+80H
 DW ONEP-5
TWOP: DW DOCOL ; :
 DW TWO ; 2
 DW PLUS ; +
 DW SEMIS ; ;S
;
; HERE
;
 DB 84H
 DB 'HER'
 DB 'E'+80H
 DW TWOP-5
HERE: DW DOCOL ; :
 DW DP ; DP
 DW AT ; @
 DW SEMIS ; ;S
;
; ALLOT
;
 DB 85H
 DB 'ALLO'
 DB 'T'+80H
 DW HERE-7
ALLOT: DW DOCOL ; :
 DW DP ; DP
 DW PSTOR ; +!
 DW SEMIS ; ;S
;
; ,
;
 DB 81H
 DB ','+80H
 DW ALLOT-8
COMMA: DW DOCOL ; :
 DW HERE ; HERE
 DW STORE ; !
 DW TWO ; 2
 DW ALLOT ; ALLOT
 DW SEMIS ; ;S
;
; C,
;
 DB 82H
 DB 'C'
 DB ','+80H
 DW COMMA-4
CCOMM: DW DOCOL ; :
 DW HERE ; HERE
 DW CSTOR ; C!
 DW ONE ; 1
 DW ALLOT ; ALLOT
 DW SEMIS ; ;S
;
; SUBROUTINE USED BY - AND <
; (HL) <- (HL) - (DE)
SSUB: MOV A,L ;LB
 SUB E
 MOV L,A
 MOV A,H ;HB
 SBB D
 MOV H,A
 RET
;
; -
;
 DB 81H
 DB '-'+80H
 DW CCOMM-5
SUBB: DW $+2
 POP D ;(DE) <- (S1) = Y
 POP H ;(HL) <- (S2) = X
 CALL SSUB
 JMP HPUSH ;(S1) <- X - Y
;
; =
;
 DB 81H
 DB '='+80H
 DW SUBB-4
EQUAL: DW DOCOL ; :
 DW SUBB ; -
 DW ZEQU ; 0=
 DW SEMIS ; ;S
;
; < X < Y
; S2 S1
 DB 81H
 DB '<'+80H
 DW EQUAL-4
LESS: DW $+2
 POP D ;(DE) <- (S1) = Y
 POP H ;(HL) <- (S2) = X
 MOV A,D ;IF X & Y HAVE SAME SIGNS
 XRA H
 JM LES1
 CALL SSUB ;(HL) <- X - Y
LES1: INR H ;IF (HL) >= 0
 DCR H
 JM LES2
 LXI H,0 ;THEN X >= Y
 JMP HPUSH ;(S1) <- FALSE
LES2: LXI H,1 ;ELSE X < Y
 JMP HPUSH ;(S1) <- TRUE
;
; U< ( UNSIGNED < )
;
 DB 82H
 DB 'U'
 DB '<'+80H
 DW LESS-4
ULESS: DW DOCOL,TDUP ; : 2DUP
 DW XORR,ZLESS ; XOR 0<
 DW ZBRAN ; 0BRANCH
 DW ULES1-$
 DW DROP,ZLESS ; DROP 0<
 DW ZEQU ; 0=
 DW BRAN ; BRANCH
 DW ULES2-$
ULES1: DW SUBB,ZLESS ; - 0<
ULES2: DW SEMIS ; ;S
;
; >
;
 DB 81H
 DB '>'+80H
 DW ULESS-5
GREAT: DW DOCOL ; :
 DW SWAP ; SWAP
 DW LESS ; <
 DW SEMIS ; ;S
;
; ROT
;
 DB 83H
 DB 'RO'
 DB 'T'+80H
 DW GREAT-4
ROT: DW $+2
 POP D
 POP H
 XTHL
 JMP DPUSH
;
; SPACE
;
 DB 85H
 DB 'SPAC'
 DB 'E'+80H
 DW ROT-6
SPACE: DW DOCOL ; :
 DW BL ; BL
 DW EMIT ; EMIT
 DW SEMIS ; ;S
;
; -DUP
;
 DB 84H
 DB '-DU'
 DB 'P'+80H
 DW SPACE-8
DDUP: DW DOCOL ; :
 DW DUP ; DUP
 DW ZBRAN ; 0BRANCH
 DW DDUP1-$
 DW DUP ; DUP
DDUP1: DW SEMIS ; ;S
;
; TRAVERSE
;
 DB 88H
 DB 'TRAVERS'
 DB 'E'+80H
 DW DDUP-7
TRAV: DW DOCOL ; :
 DW SWAP ; SWAP
TRAV1: DW OVER ; OVER
 DW PLUS ; +
 DW LIT ; LIT
 DW 7FH
 DW OVER ; OVER
 DW CAT ; C@
 DW LESS ; <
 DW ZBRAN ; 0BRANCH
 DW TRAV1-$
 DW SWAP ; SWAP
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; LATEST
;
 DB 86H
 DB 'LATES'
 DB 'T'+80H
 DW TRAV-0BH
LATES: DW DOCOL ; :
 DW CURR ; CURRENT
 DW AT ; @
 DW AT ; @
 DW SEMIS ; ;S
;
; LFA-LINK FIELD ADDR
;
 DB 83H
 DB 'LF'
 DB 'A'+80H
 DW LATES-9
LFA: DW DOCOL ; :
 DW LIT ; LIT
 DW 4
 DW SUBB ; -
 DW SEMIS ; ;S
;
; CFA-CODE FIELD ADDR
;
 DB 83H
 DB 'CF'
 DB 'A'+80H
 DW LFA-6
CFA: DW DOCOL ; :
 DW TWO ; 2
 DW SUBB ; -
 DW SEMIS ; ;S
;
; NFA-NAME FIELD ADDR
;
 DB 83H
 DB 'NF'
 DB 'A'+80H
 DW CFA-6
NFA: DW DOCOL ; :
 DW LIT ; LIT
 DW 5
 DW SUBB ; -
 DW LIT ; LIT
 DW -1
 DW TRAV ; TRAVERSE
 DW SEMIS ; ;S
;
; PFA-PARAMETER FLD ADDR
;
 DB 83H
 DB 'PF'
 DB 'A'+80H
 DW NFA-6
PFA: DW DOCOL ; :
 DW ONE ; 1
 DW TRAV ; TRAVERSE
 DW LIT ; LIT
 DW 5
 DW PLUS ; +
 DW SEMIS ; ;S
;
; !CSP
;
 DB 84H
 DB '!CS'
 DB 'P'+80H
 DW PFA-6
SCSP: DW DOCOL ; :
 DW SPAT ; SP@
 DW CSP ; CSP
 DW STORE ; !
 DW SEMIS ; ;S
;
; ?ERROR
;
 DB 86H
 DB '?ERRO'
 DB 'R'+80H
 DW SCSP-7
QERR: DW DOCOL ; :
 DW SWAP ; SWAP
 DW ZBRAN ; 0BRANCH
 DW QERR1-$
 DW ERROR ; ERROR
 DW BRAN ; BRANCH
 DW QERR2-$
QERR1: DW DROP ; DROP
QERR2: DW SEMIS ; ;S
;
; ?COMP
;
 DB 85H
 DB '?COM'
 DB 'P'+80H
 DW QERR-9
QCOMP: DW DOCOL ; :
 DW STATE ; STATE
 DW AT ; @
 DW ZEQU ; 0=
 DW LIT ; LIT
 DW 11H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?EXEC
;
 DB 85H
 DB '?EXE'
 DB 'C'+80H
 DW QCOMP-8
QEXEC: DW DOCOL ; :
 DW STATE ; STATE
 DW AT ; @
 DW LIT ; LIT
 DW 12H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?PAIRS
;
 DB 86H
 DB '?PAIR'
 DB 'S'+80H
 DW QEXEC-8
QPAIR: DW DOCOL ; :
 DW SUBB ; -
 DW LIT ; LIT
 DW 13H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?CSP
;
 DB 84H
 DB '?CS'
 DB 'P'+80H
 DW QPAIR-9
QCSP: DW DOCOL ; :
 DW SPAT ; SP@
 DW CSP ; CSP
 DW AT ; @
 DW SUBB ; -
 DW LIT ; LIT
 DW 14H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?LOADING
;
 DB 88H
 DB '?LOADIN'
 DB 'G'+80H
 DW QCSP-7
QLOAD: DW DOCOL ; :
 DW BLK ; BLK
 DW AT ; @
 DW ZEQU ; 0=
 DW LIT ; LIT
 DW 16H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; COMPILE
;
 DB 87H
 DB 'COMPIL'
 DB 'E'+80H
 DW QLOAD-0BH
COMP: DW DOCOL ; :
 DW QCOMP ; ?COMP
 DW FROMR ; R>
 DW DUP ; DUP
 DW TWOP ; 2+
 DW TOR ; >R
 DW AT ; @
 DW COMMA ; ,
 DW SEMIS ; ;S
;
; 'LEFT SQR BRACKET'
;
 DB 0C1H
 DB 0DBH ;LEFT SQUARE BRACKET + 80H
 DW COMP-0AH
LBRAC: DW DOCOL ; :
 DW ZERO ; 0
 DW STATE ; STATE
 DW STORE ; !
 DW SEMIS ; ;S
;
; 'RIGHT SQR BRACKET'
;
 DB 81H
 DB 0DDH ;RIGHT SQUARE BRACKET + 80H
 DW LBRAC-4
RBRAC: DW DOCOL ; :
 DW LIT ; LIT
 DW 0C0H
 DW STATE ; STATE
 DW STORE ; !
 DW SEMIS ; ;S
;
; SMUDGE
;
 DB 86H
 DB 'SMUDG'
 DB 'E'+80H
 DW RBRAC-4
SMUDG: DW DOCOL ; :
 DW LATES ; LATEST
 DW LIT ; LIT
 DW 20H
 DW TOGGL ; TOGGLE
 DW SEMIS ; ;S
;
; HEX
;
 DB 83H
 DB 'HE'
 DB 'X'+80H
 DW SMUDG-9
HEX: DW DOCOL ; :
 DW LIT ; LIT
 DW 10H
 DW BASE ; BASE
 DW STORE ; !
 DW SEMIS ; ;S
;
; DECIMAL
;
 DB 87H
 DB 'DECIMA'
 DB 'L'+80H
 DW HEX-6
DEC: DW DOCOL ; :
 DW LIT ; LIT
 DW 0AH
 DW BASE ; BASE
 DW STORE ; !
 DW SEMIS ; ;S
;
; ( CODE)
;
 DB 87H
 DB '( CODE'
 DB ')'+80H
 DW DEC-0AH
PSCOD: DW DOCOL ; :
 DW FROMR ; R>
 DW LATES ; LATEST
 DW PFA ; PFA
 DW CFA ; CFA
 DW STORE ; !
 DW SEMIS ; ;S
;
; CODE
;
 DB 0C5H
 DB ' COD'
 DB 'E'+80H
 DW PSCOD-0AH
SEMIC: DW DOCOL ; :
 DW QCSP ; ?CSP
 DW COMP ; COMPILE
 DW PSCOD ; (;CODE)
 DW LBRAC ; 
 DW NOOP ; NOOP
 DW SEMIS ; ;S
;
; <BUILDS
;
 DB 87H
 DB '<BUILD'
 DB 'S'+80H
 DW SEMIC-8
BUILD: DW DOCOL ; :
 DW ZERO ; 0
 DW CON ; CONSTANT
 DW SEMIS ; ;S
;
; DOES>
;
 DB 85H
 DB 'DOES'
 DB '>'+80H
 DW BUILD-0AH
DOES: DW DOCOL ; :
 DW FROMR ; R>
 DW LATES ; LATEST
 DW PFA ; PFA
 DW STORE ; !
 DW PSCOD ; (;CODE)
DODOE: LHLD RPP ;(HL) <- (RP)
 DCX H
 MOV M,B ;(R1) <- (IP) = PFA = (SUBSTITUTE CFA)
 DCX H
 MOV M,C
 SHLD RPP ;(RP) <- (RP) - 2
 INX D ;(DE) <- PFA = (SUBSTITUTE PFA)
 XCHG
 MOV C,M ;(IP) <- (SUBSTITUTE PFA)
 INX H
 MOV B,M
 INX H
 JMP HPUSH ;(S1) <- PFA+2 = SUBSTITUTE PFA
;
; COUNT
;
 DB 85H
 DB 'COUN'
 DB 'T'+80H
 DW DOES-8
COUNT: DW DOCOL ; :
 DW DUP ; DUP
 DW ONEP ; 1+
 DW SWAP ; SWAP
 DW CAT ; C@
 DW SEMIS ; ;S
;
; TYPE
;
 DB 84H
 DB 'TYP'
 DB 'E'+80H
 DW COUNT-8
TYPE: DW DOCOL ; :
 DW DDUP ; -DUP
 DW ZBRAN ; 0BRANCH
 DW TYPE1-$
 DW OVER ; OVER
 DW PLUS ; +
 DW SWAP ; SWAP
 DW XDO ; (DO)
TYPE2: DW IDO ; I
 DW CAT ; C@
 DW EMIT ; EMIT
 DW XLOOP ; (LOOP)
 DW TYPE2-$
 DW BRAN ; BRANCH
 DW TYPE3-$
TYPE1: DW DROP ; DROP
TYPE3: DW SEMIS ; ;S
;
; -TRAILING
;
 DB 89H
 DB '-TRAILIN'
 DB 'G'+80H
 DW TYPE-7
DTRAI: DW DOCOL ; :
 DW DUP ; DUP
 DW ZERO ; 0
 DW XDO ; (DO)
DTRA1: DW OVER ; OVER
 DW OVER ; OVER
 DW PLUS ; +
 DW ONE ; 1
 DW SUBB ; -
 DW CAT ; C@
 DW BL ; BL
 DW SUBB ; -
 DW ZBRAN ; 0BRANCH
 DW DTRA2-$
 DW LEAVE ; LEAVE
 DW BRAN ; BRANCH
 DW DTRA3-$
DTRA2: DW ONE ; 1
 DW SUBB ; -
DTRA3: DW XLOOP ; (LOOP)
 DW DTRA1-$
 DW SEMIS ; ;S
;
; (.")
;
 DB 84H
 DB '(."'
 DB ')'+80H
 DW DTRAI-0CH
PDOTQ: DW DOCOL ; :
 DW RR ; R
 DW COUNT ; COUNT
 DW DUP ; DUP
 DW ONEP ; 1+
 DW FROMR ; R>
 DW PLUS ; +
 DW TOR ; >R
 DW TYPE ; TYPE
 DW SEMIS ; ;S
;
; ."
;
 DB 0C2H
 DB '.'
 DB '"'+80H
 DW PDOTQ-7
DOTQ: DW DOCOL ; :
 DW LIT ; LIT
 DW 22H
 DW STATE ; STATE
 DW AT ; @
 DW ZBRAN ; 0BRANCH
 DW DOTQ1-$
 DW COMP ; COMPILE
 DW PDOTQ ; (.")
 DW WORD ; WORD
 DW HERE ; HERE
 DW CAT ; C@
 DW ONEP ; 1+
 DW ALLOT ; ALLOT
 DW BRAN ; BRANCH
 DW DOTQ2-$
DOTQ1: DW WORD ; WORD
 DW HERE ; HERE
 DW COUNT ; COUNT
 DW TYPE ; TYPE
DOTQ2: DW SEMIS ; ;S

; T=0.45/3.05 07:01:35


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


                     @   ;
; EXPECT
;
 DB 86H
 DB 'EXPEC'
 DB 'T'+80H
 DW DOTQ-5
EXPEC: DW DOCOL ; :
 DW OVER ; OVER
 DW PLUS ; +
 DW OVER ; OVER
 DW XDO ; (DO)
EXPE1: DW KEY ; KEY
 DW DUP ; DUP
 DW LIT ; LIT
 DW 0EH
 DW PORIG ; +ORIGIN
 DW AT ; @
 DW EQUAL ; =
 DW ZBRAN ; 0BRANCH
 DW EXPE2-$
 DW DROP ; DROP
 DW DUP ; DUP
 DW IDO ; I
 DW EQUAL ; =
 DW DUP ; DUP
 DW FROMR ; R>
 DW TWO ; 2
 DW SUBB ; -
 DW PLUS ; +
 DW TOR ; >R
 DW ZBRAN ; 0BRANCH
 DW EXPE6-$
 DW LIT ; LIT
 DW BELL
 DW BRAN ; BRANCH
 DW EXPE7-$
EXPE6: DW LIT ; LIT
 DW BSOUT
EXPE7: DW BRAN
 DW EXPE3-$
EXPE2: DW DUP ; DUP
 DW LIT ; LIT
 DW 0DH
 DW EQUAL ; =
 DW ZBRAN ; 0BRANCH
 DW EXPE4-$
 DW LEAVE ; LEAVE
 DW DROP ; DROP
 DW BL ; BL
 DW ZERO ; 0
 DW BRAN ; BRANCH
 DW EXPE5-$
EXPE4: DW DUP ; DUP
EXPE5: DW IDO ; I
 DW CSTOR ; C!
 DW ZERO ; 0
 DW IDO ; I
 DW ONEP ; 1+
 DW STORE ; !
EXPE3: DW EMIT ; EMIT
 DW XLOOP ; (LOOP)
 DW EXPE1-$
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; QUERY
;
 DB 85H
 DB 'QUER'
 DB 'Y'+80H
 DW EXPEC-9
QUERY: DW DOCOL ; :
 DW TIB ; TIB
 DW AT ; @
 DW LIT ; LIT
 DW 50H
 DW EXPEC ; EXPECT
 DW ZERO ; 0
 DW INN ; IN
 DW STORE ; !
 DW SEMIS ; ;S
;
; 0 (NULL)
;
 DB 0C1H
 DB 80H
 DW QUERY-8
NULL: DW DOCOL
 DW FROMR
 DW DROP
 DW SEMIS
;
; FILL
;
 DB 84H
 DB 'FIL'
 DB 'L'+80H
 DW NULL-4
FILL: DW $+2
 MOV L,C
 MOV H,B
 POP D
 POP B
 XTHL
 XCHG
FILL1: MOV A,B
 ORA C
 JZ FILL2
 MOV A,L
 STAX D
 INX D
 DCX B
 JMP FILL1
FILL2: POP B
 JMP NEXT
;
; ERASE
;
 DB 85H
 DB 'ERAS'
 DB 'E'+80H
 DW FILL-7
ERASEE: DW DOCOL
 DW ZERO ; 0
 DW FILL ; FILL
 DW SEMIS ; ;S
;
; BLANKS
;
 DB 86H
 DB 'BLANK'
 DB 'S'+80H
 DW ERASEE-8 ; ERASE
BLANK: DW DOCOL ; :
 DW BL ; BL
 DW FILL ; FILL
 DW SEMIS ; ;S
;
; HOLD
;
 DB 84H
 DB 'HOL'
 DB 'D'+80H
 DW BLANK-9
HOLD: DW DOCOL ; :
 DW LIT ; LIT
 DW -1
 DW HLD ; HLD
 DW PSTOR ; +!
 DW HLD ; HLD
 DW AT ; @
 DW CSTOR ; C!
 DW SEMIS ; ;S
;
; PAD
;
 DB 83H
 DB 'PA'
 DB 'D'+80H
 DW HOLD-7
PAD: DW DOCOL ; :
 DW HERE ; HERE
 DW LIT ; LIT
 DW 44H
 DW PLUS ; +
 DW SEMIS ; ;S
;
; WORD
;
 DB 84H
 DB 'WOR'
 DB 'D'+80H
 DW PAD-6
WORD: DW DOCOL ; :
 DW TIB ; TIB
 DW AT ; @
 DW INN ; IN
 DW AT ; @
 DW PLUS ; +
 DW SWAP ; SWAP
 DW ENCL ; ENCLOSE
 DW HERE ; HERE
 DW LIT ; LIT
 DW 22H
 DW BLANK ; BLANKS
 DW INN ; IN
 DW PSTOR ; +!
 DW OVER ; OVER
 DW SUBB ; -
 DW TOR ; >R
 DW RR ; R
 DW HERE ; HERE
 DW CSTOR ; C!
 DW PLUS ; +
 DW HERE ; HERE
 DW ONEP ; 1+
 DW FROMR ; R>
 DW CMOVE ; CMOVE
 DW SEMIS ; ;S
;
; (NUMBER)
;
 DB 88H
 DB '(NUMBER'
 DB ')'+80H
 DW WORD-7
PNUMB: DW DOCOL ; :
PNUM1: DW ONEP ; 1+
 DW DUP ; DUP
 DW TOR ; >R
 DW CAT ; C@
 DW BASE ; BASE
 DW AT ; @
 DW DIGIT ; DIGIT
 DW ZBRAN ; 0BRANCH
 DW PNUM2-$
 DW SWAP ; SWAP
 DW BASE ; BASE
 DW AT ; @
 DW USTAR ; U*
 DW DROP ; DROP
 DW ROT ; ROT
 DW BASE ; BASE
 DW AT ; @
 DW USTAR ; U*
 DW DPLUS ; D+
 DW DPL ; DPL
 DW AT ; @
 DW ONEP ; 1+
 DW ZBRAN ; 0BRANCH
 DW PNUM3-$
 DW ONE ; 1
 DW DPL ; DPL
 DW PSTOR ; +!
PNUM3: DW FROMR ; R>
 DW BRAN ; BRANCH
 DW PNUM1-$
PNUM2: DW FROMR ; R>
 DW SEMIS ; ;S
;
; NUMBER
;
 DB 86H
 DB 'NUMBE'
 DB 'R'+80H
 DW PNUMB-0BH
NUMB: DW DOCOL ; :
 DW ZERO ; 0
 DW ZERO ; 0
 DW ROT ; ROT
 DW DUP ; DUP
 DW ONEP ; 1+
 DW CAT ; C@
 DW LIT ; LIT
 DW 2DH
 DW EQUAL ; =
 DW DUP ; DUP
 DW TOR ; >R
 DW PLUS ; +
 DW LIT ; LIT
 DW -1
NUMB1: DW DPL ; DPL
 DW STORE ; !
 DW PNUMB ; (NUMBER)
 DW DUP ; DUP
 DW CAT ; C@
 DW BL ; BL
 DW SUBB ; -
 DW ZBRAN ; 0BRANCH
 DW NUMB2-$
 DW DUP ; DUP
 DW CAT ; C@
 DW LIT ; LIT
 DW 2EH
 DW SUBB ; -
 DW ZERO ; 0
 DW QERR ; ?ERROR
 DW ZERO ; 0
 DW BRAN ; BRANCH
 DW NUMB1-$
NUMB2: DW DROP ; DROP
 DW FROMR ; R>
 DW ZBRAN ; 0BRANCH
 DW NUMB3-$
 DW DMINU ; DMINUS
NUMB3: DW SEMIS ; ;S
;
; -FIND (0-3) SUCCESS (0 ) FAILURE
;
 DB 85H
 DB '-FIN'
 DB 'D'+80H
 DW NUMB-9
DFIND: DW DOCOL ; :
 DW BL ; BL
 DW WORD ; WORD
 DW HERE ; HERE
 DW CONT ; CONTEXT
 DW AT ; @
 DW AT ; @
 DW PFIND ; (FIND)
 DW DUP ; DUP
 DW ZEQU ; 0=
 DW ZBRAN ; 0BRANCH
 DW DFIN1-$
 DW DROP ; DROP
 DW HERE ; HERE
 DW LATES ; LATEST
 DW PFIND ; (FIND)
DFIN1: DW SEMIS ; ;S
;
; (ABORT)
;
 DB 87H
 DB '(ABORT'
 DB ')'+80H
 DW DFIND-8
PABOR: DW DOCOL ; :
 DW ABORT ; ABORT
 DW SEMIS ; ;S
;
; ERROR
;
 DB 85H
 DB 'ERRO'
 DB 'R'+80H
 DW PABOR-0AH
ERROR: DW DOCOL ; :
 DW WARN ; WARNING
 DW AT ; @
 DW ZLESS ; 0<
 DW ZBRAN ; 0BRANCH
 DW ERRO1-$
 DW PABOR ; (ABORT)
ERRO1: DW HERE ; HERE
 DW COUNT ; COUNT
 DW TYPE ; TYPE
 DW PDOTQ ; (.")
 DB 2
 DB '? '
 DW MESS ; MESSAGE
 DW SPSTO ; SP!
;
; CHANGE FROM FIG MODEL
; DW IN,AT,BLK,AT
;
 DW BLK,AT ; BLK @
 DW DDUP ; -DUP
 DW ZBRAN ; 0BRANCH
 DW ERRO2-$
 DW INN,AT ; IN @
 DW SWAP ; SWAP
ERRO2: DW QUIT ; QUIT
;
; ID.
;
 DB 83H
 DB 'ID'
 DB '.'+80H
 DW ERROR-8
IDDOT: DW DOCOL ; :
 DW PAD ; PAD
 DW LIT ; LIT
 DW 20H
 DW LIT ; LIT
 DW 5FH
 DW FILL ; FILL
 DW DUP ; DUP
 DW PFA ; PFA
 DW LFA ; LFA
 DW OVER ; OVER
 DW SUBB ; -
 DW PAD ; PAD
 DW SWAP ; SWAP
 DW CMOVE ; CMOVE
 DW PAD ; PAD
 DW COUNT ; COUNT
 DW LIT ; LIT
 DW 1FH
 DW ANDD ; AND
 DW TYPE ; TYPE
 DW SPACE ; SPACE
 DW SEMIS ; ;S
;
; CREATE
;
 DB 86H
 DB 'CREAT'
 DB 'E'+80H
 DW IDDOT-6
CREAT: DW DOCOL ; :
 DW DFIND ; -FIND
 DW ZBRAN ; 0BRANCH
 DW CREA1-$
 DW DROP ; DROP
 DW NFA ; NFA
 DW IDDOT ; ID.
 DW LIT ; LIT
 DW 4
 DW MESS ; MESSAGE
 DW SPACE ; SPACE
CREA1: DW HERE ; HERE
 DW DUP ; DUP
 DW CAT ; C@
 DW WIDTH ; WIDTH
 DW AT ; @
 DW MIN ; MIN
 DW ONEP ; 1+
 DW ALLOT ; ALLOT
 DW DUP ; DUP
 DW LIT ; LIT
 DW 0A0H
 DW TOGGL ; TOGGLE
 DW HERE ; HERE
 DW ONE ; 1
 DW SUBB ; -
 DW LIT ; LIT
 DW 80H
 DW TOGGL ; TOGGLE
 DW LATES ; LATEST
 DW COMMA ; ,
 DW CURR ; CURRENT
 DW AT ; @
 DW STORE ; !
 DW HERE ; HERE
 DW TWOP ; 2+
 DW COMMA ; ,
 DW SEMIS ; ;S
;
; LSB[COMPILE]RSB
;
 DB 0C9H
 DB 5BH ; FORCE HEX FOR LEFT SQUARE BRACKET
 DB 'COMPILE'
 DB 0DDH ; HEX FOR RIGHT SQUARE BRACKET + 80H
 DW CREAT-9
BCOMP: DW DOCOL ; :
 DW DFIND ; -FIND
 DW ZEQU ; 0=
 DW ZERO ; 0
 DW QERR ; ?ERROR
 DW DROP ; DROP
 DW CFA ; CFA
 DW COMMA ; ,
 DW SEMIS ; ;S
;
; LITERAL
;
 DB 0C7H
 DB 'LITERA'
 DB 'L'+80H
 DW BCOMP-0CH
LITER: DW DOCOL ; :
 DW STATE ; STATE
 DW AT ; @
 DW ZBRAN ; 0BRANCH
 DW LITE1-$
 DW COMP ; COMPILE
 DW LIT ; LIT
 DW COMMA ; ,
LITE1: DW SEMIS ; ;S
;
; DLITERAL
;
 DB 0C8H
 DB 'DLITERA'
 DB 'L'+80H
 DW LITER-0AH
DLITE: DW DOCOL ; :
 DW STATE ; STATE
 DW AT ; @
 DW ZBRAN ; 0BRANCH
 DW DLIT1-$
 DW SWAP ; SWAP
 DW LITER ; LITERAL
 DW LITER ; LITERAL
DLIT1: DW SEMIS ; ;S
;
; ?STACK
;
 DB 86H
 DB '?STAC'
 DB 'K'+80H
 DW DLITE-0BH
QSTAC: DW DOCOL ; :
 DW SPAT ; SP@
 DW SZERO ; S0
 DW AT ; @
 DW SWAP ; SWAP
 DW ULESS ; U<
 DW ONE ; 1
 DW QERR ; ?ERROR
 DW SPAT ; SP@
 DW HERE ; HERE
 DW LIT ; LIT
 DW 80H
 DW PLUS ; +
 DW ULESS ; U<
 DW LIT ; LIT
 DW 7
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; INTERPRET
;
 DB 89H
 DB 'INTERPRE'
 DB 'T'+80H
 DW QSTAC-9
INTER: DW DOCOL ; :
INTE1: DW DFIND ; -FIND
 DW ZBRAN ; 0BRANCH
 DW INTE2-$
 DW STATE ; STATE
 DW AT ; @
 DW LESS ; <
 DW ZBRAN ; 0BRANCH
 DW INTE3-$
 DW CFA ; CFA
 DW COMMA ; ,
 DW BRAN ; BRANCH
 DW INTE4-$
INTE3: DW CFA ; CFA
 DW EXEC ; EXECUTE
INTE4: DW QSTAC ; ?STACK
 DW BRAN ; BRANCH
 DW INTE5-$
INTE2: DW HERE ; HERE
 DW NUMB
 DW DPL ; DPL
 DW AT ; @
 DW ONEP ; 1+
 DW ZBRAN ; 0BRANCH
 DW INTE6-$
 DW DLITE ; DLITERAL
 DW BRAN ; BRANCH
 DW INTE7-$
INTE6: DW DROP ; DROP
 DW LITER ; LITERAL
INTE7: DW QSTAC ; ?STACK
INTE5: DW BRAN ; BRANCH
 DW INTE1-$
;
; IMMEDIATE
;
 DB 89H
 DB 'IMMEDIAT'
 DB 'E'+80H
 DW INTER-0CH
IMMED: DW DOCOL ; :
 DW LATES ; LATEST
 DW LIT ; LIT
 DW 40H
 DW TOGGL ; TOGGLE
 DW SEMIS ; ;S
;
; VOCABULARY
;
 DB 8AH
 DB 'VOCABULAR'
 DB 'Y'+80H
 DW IMMED-0CH
VOCAB: DW DOCOL ; :
 DW BUILD ; <BUILDS
 DW LIT ; LIT
 DW 0A081H
 DW COMMA ; ,
 DW CURR ; CURRENT
 DW AT ; @
 DW CFA ; CFA
 DW COMMA ; ,
 DW HERE ; HERE
 DW VOCL ; VOC-LINK
 DW AT ; @
 DW COMMA ; ,
 DW VOCL ; VOC-LINK
 DW STORE ; !
 DW DOES ; DOES>
DOVOC: DW TWOP ; 2+
 DW CONT ; CONTEXT
 DW STORE ; !
 DW SEMIS ; ;S
;
; FORTH
;
 DB 0C5H
 DB 'FORT'
 DB 'H'+80H
 DW VOCAB-0DH
FORTH: DW DODOE
 DW DOVOC
 DW 0A081H
 DW TASK-7
 DW 0 ;END OF VOCABULARY LIST
;
; DEFINITIONS
;
 DB 8BH
 DB 'DEFINITION'
 DB 'S'+80H
 DW FORTH-8
DEFIN: DW DOCOL ; :
 DW CONT ; CONTEXT
 DW AT ; @
 DW CURR ; CURRENT
 DW STORE ; !
 DW SEMIS ; ;S
;
; (
;
 DB 0C1H
 DB '('+80H
 DW DEFIN-0EH
PAREN: DW DOCOL ; :
 DW LIT ; LIT
 DW 29H
 DW WORD ; WORD
 DW SEMIS ; ;S
;
; QUIT
;
 DB 84H
 DB 'QUI'
 DB 'T'+80H
 DW PAREN-4
QUIT: DW DOCOL ; :
 DW ZERO ; 0
 DW BLK ; BLK
 DW STORE ; !
 DW LBRAC ; 
QUIT1: DW RPSTO ; RP!
 DW CR ; CR
 DW QUERY ; QUERY
 DW INTER ; INTERPRET
 DW STATE ; STATE
 DW AT ; @
 DW ZEQU ; 0=
 DW ZBRAN ; 0BRANCH
 DW QUIT2-$
 DW PDOTQ ; (.")
 DB 2
 DB 'OK'
QUIT2: DW BRAN ; BRANCH
 DW QUIT1-$
;
; ABORT
;
 DB 85H
 DB 'ABOR'
 DB 'T'+80H
 DW QUIT-7
ABORT: DW DOCOL ; :
 DW SPSTO ; SP!
 DW DEC ; DECIMAL
 DW QSTAC ; ?STACK
 DW CR ; CR
 DW PDOTQ ; (.")
 DB 0EH
;
 DB 'DMF FORTH '
 DB FIGREL+30H
 DB ADOT
 DB FIGREV+30H
 DB USRVER+30H
;
 DW FORTH ; FORTH
 DW DEFIN ; DEFINITIONS
 DW QUIT ; QUIT
 
WRM: LXI B,WRM1
 JMP NEXT
WRM1: DW WARM ; WARM
;
; WARM
;
 DB 84H
 DB 'WAR'
 DB 'M'+80H
 DW ABORT-8
WARM: DW DOCOL ; :
 DW ABORT ; ABORT
;
CLD: LXI B,CLD1
 LHLD ORIG+12H
 SPHL
 JMP NEXT
CLD1: DW COLD ; COLD
;
; COLD
;
 DB 84H
 DB 'COL'
 DB 'D'+80H
 DW WARM-7
COLD: DW DOCOL ; :
 DW LIT ; LIT
 DW ORIG+12H
 DW LIT ; LIT
 DW UP
 DW AT ; @
 DW LIT ; LIT
 DW 6
 DW PLUS ; +
 DW LIT ; LIT
 DW 10H
 DW CMOVE ; CMOVE
 DW LIT ; LIT
 DW ORIG+0CH
 DW AT ; @
 DW LIT ; LIT
 DW FORTH+6
 DW STORE ; !
 DW ABORT ; ABORT
;
; S->D
;
 DB 84H
 DB 'S->'
 DB 'D'+80H
 DW COLD-7
STOD: DW $+2
 POP D
 LXI H,0
 MOV A,D
 ANI 80H
 JZ STOD1
 DCX H
STOD1: JMP DPUSH
;
; +-
;
 DB 82H
 DB '+'
 DB '-'+80H
 DW STOD-7
PM: DW DOCOL ; :
 DW ZLESS ; 0<
 DW ZBRAN ; 0BRANCH
 DW PM1-$
 DW MINUS ; MINUS
PM1: DW SEMIS ; ;S
;
; D+-
;
 DB 83H
 DB 'D+'
 DB '-'+80H
 DW PM-5
DPM: DW DOCOLV
 DW ZLESS ; 0<
 DW ZBRAN ; 0BRANCH
 DW DPM1-$
 DW DMINU ; DMINUS
DPM1: DW SEMIS ; ;S
;
; ABS
;
 DB 83H
 DB 'AB'
 DB 'S'+80H
 DW DPM-6
ABS: DW DOCOL ; :
 DW DUP ; DUP
 DW PM ; +-
 DW SEMIS ; ;S
;
; DABS
;
 DB 84H
 DB 'DAB'
 DB 'S'+80H
 DW ABS-6
DABS: DW DOCOL ; :
 DW DUP ; DUP
 DW DPM ; D+-
 DW SEMIS ; ;S
;
; MIN
;
 DB 83H
 DB 'MI'
 DB 'N'+80H
 DW DABS-7
MIN: DW DOCOL,TDUP ; : 2DUP
 DW GREAT ; >
 DW ZBRAN ; 0BRANCH
 DW MIN1-$
 DW SWAP ; SWAP
MIN1: DW DROP ; DROP
 DW SEMIS ; ;S
;
; MAX
;
 DB 83H
 DB 'MA'
 DB 'X'+80H
 DW MIN-6
MAX: DW DOCOL,TDUP ; : 2DUP
 DW LESS ; <
 DW ZBRAN ; 0BRANCH
 DW MAX1-$
 DW SWAP ; SWAP
MAX1: DW DROP ; DROP
 DW SEMIS ; ;S
;
; M*
;
 DB 82H
 DB 'M'
 DB '*'+80H
 DW MAX-6
MSTAR: DW DOCOL,TDUP ; : 2DUP
 DW XORR ; XOR
 DW TOR ; >R
 DW ABS ; ABS
 DW SWAP ; SWAP
 DW ABS ; ABS
 DW USTAR ; U*
 DW FROMR ; R>
 DW DPM ; D+-
 DW SEMIS ; ;S
;
; M/
;
 DB 82H
 DB 'M'
 DB '/'+80H
 DW MSTAR-5
MSLAS: DW DOCOL ; :
 DW OVER ; OVER
 DW TOR ; >R
 DW TOR ; >R
 DW DABS ; DABS
 DW RR ; R
 DW ABS ; ABS
 DW USLAS ; U/
 DW FROMR ; R>
 DW RR ; R
 DW XORR ; XOR
 DW PM ; +-
 DW SWAP ; SWAP
 DW FROMR ; R>
 DW PM ; +-
 DW SWAP ; SWAP
 DW SEMIS ; ;S
;
; *
;
 DB 81H
 DB '*'+80H
 DW MSLAS-5
STAR: DW DOCOL ; :
 DW MSTAR ; M*
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; /MOD
;
 DB 84H
 DB '/MO'
 DB 'D'+80H
 DW STAR-4
SLMOD: DW DOCOL ; :
 DW TOR ; >R
 DW STOD ; S->D
 DW FROMR ; R>
 DW MSLAS ; M/
 DW SEMIS ; ;S
;
; /
;
 DB 81H
 DB '/'+80H
 DW SLMOD-7
SLASH: DW DOCOL ; :
 DW SLMOD ; /MOD
 DW SWAP ; SWAP
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; MOD FUNCTION
;
 DB 83H
 DB 'MO'
 DB 'D'+80H
 DW SLASH-4
MODFN: DW DOCOL ; :
 DW SLMOD ; /MOD
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; */MOD
;
 DB 85H
 DB '*/MO'
 DB 'D'+80H
 DW MODFN-6
SSMOD: DW DOCOL ; :
 DW TOR ; >R
 DW MSTAR ; M*
 DW FROMR ; R>
 DW MSLAS ; M/
 DW SEMIS ; ;S
;
; */
;
 DB 82H
 DB '*'
 DB '/'+80H
 DW SSMOD-8
SSLA: DW DOCOL ; :
 DW SSMOD ; */MOD
 DW SWAP ; SWAP
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; M/MOD
;
 DB 85H
 DB 'M/MO'
 DB 'D'+80H
 DW SSLA-5
MSMOD: DW DOCOL ; :
 DW TOR ; >R
 DW ZERO ; 0
 DW RR ; R
 DW USLAS ; U/
 DW FROMR ; R>
 DW SWAP ; SWAP
 DW TOR ; >R
 DW USLAS ; U/
 DW FROMR ; R>
 DW SEMIS ; ;S
;
; MESSAGE
;
 DB 87H
 DB 'MESSAG'
 DB 'E'+80H
 DW MSMOD-8
MESS: DW $+2
 JMP PMSG ; CALL EXTERNAL ROUTINE
;
; 8080 PORT FETCH AND STORE
; ( SELF MODIFYING CODE, NOT REENTRANT )
;
; P@
;
 DB 82H
 DB 'P'
 DB '@'+80H
 DW MESS-0AH
PTAT: DW $+2
 POP D ;E <- PORT#
 LXI H,$+5
 MOV M,E
 IN 0 ;( PORT# MODIFIED )
 MOV L,A ;L <- (PERT#)
 MVI H,0
 JMP HPUSH
;
; P!
;
 DB 82H
 DB 'P'
 DB '!'+80H
 DW PTAT-5
PTSTO: DW $+2
 POP D ;E <- PORT#
 LXI H,$+7
 MOV M,E
 POP H ;H <- CDATA
 MOV A,L
 OUT 0 ;( PORT# MODIFIED )
 JMP NEXT
;
; '
;
 DB 0C1H
 DB 0A7H
 DW PTSTO-5
TICK: DW DOCOL ; :
 DW DFIND ; -FIND
 DW ZEQU ; 0=
 DW ZERO ; 0
 DW QERR ; ?ERROR
 DW DROP ; DROP
 DW LITER ; LITERAL
 DW SEMIS ; ;S
;
; FORGET
;
 DB 86H
 DB 'FORGE'
 DB 'T'+80H
 DW TICK-4
FORG: DW DOCOL ; :
 DW CURR ; CURRENT
 DW AT ; @
 DW CONT ; CONTEXT
 DW AT ; @
 DW SUBB ; -
 DW LIT ; LIT
 DW 18H
 DW QERR ; ?ERROR
 DW TICK ; '
 DW DUP ; DUP
 DW FENCE ; FENCE
 DW AT ; @
 DW LESS ; <
 DW LIT ; LIT
 DW 15H
 DW QERR ; ?ERROR
 DW DUP ; DUP
 DW NFA ; NFA
 DW DP ; DP
 DW STORE ; !
 DW LFA ; LFA
 DW AT ; @
 DW CONT ; CONTEXT
 DW AT ; @
 DW STORE ; !
 DW SEMIS ; ;S
;
; BACK
;
 DB 84H
 DB 'BAC'
 DB 'K'+80H
 DW FORG-9
BACK: DW DOCOL ; :
 DW HERE ; HERE
 DW SUBB ; -
 DW COMMA ; ,
 DW SEMIS ; ;S
;
; BEGIN
;
 DB 0C5H
 DB 'BEGI'
 DB 'N'+80H
 DW BACK-7
BEGIN: DW DOCOL ; :
 DW QCOMP ; ?COMP
 DW HERE ; HERE
 DW ONE ; 1
 DW SEMIS ; ;S
;
; ENDIF
;
 DB 0C5H
 DB 'ENDI'
 DB 'F'+80H
 DW BEGIN-8
ENDIFF: DW DOCOL
 DW QCOMP ; ?COMP
 DW TWO ; 2
 DW QPAIR ; ?PAIRS
 DW HERE ; HERE
 DW OVER ; OVER
 DW SUBB ; -
 DW SWAP ; SWAP
 DW STORE ; !
 DW SEMIS ; ;S
;
; THEN
;
 DB 0C4H
 DB 'THE'
 DB 'N'+80H
 DW ENDIFF-8 ; ENDIF
THEN: DW DOCOL ; :
 DW ENDIFF ; ENDIF
 DW SEMIS ; ;S
;
; DO
;
 DB 0C2H
 DB 'D'
 DB 'O'+80H
 DW THEN-7
DO: DW DOCOL ; :
 DW COMP ; COMPILE
 DW XDO ; (DO)
 DW HERE ; HERE
 DW THREE ; 3
 DW SEMIS ; ;S
;
; LOOP
;
 DB 0C4H
 DB 'LOO'
 DB 'P'+80H
 DW DO-5
LOOP: DW DOCOL ; :
 DW THREE ; 3
 DW QPAIR ; ?PAIRS
 DW COMP ; COMPILE
 DW XLOOP ; (LOOP)
 DW BACK ; BACK
 DW SEMIS ; ;S
;
; +LOOP
;
 DB 0C5H
 DB '+LOO'
 DB 'P'+80H
 DW LOOP-7
PLOOP: DW DOCOL ; :
 DW THREE ; 3
 DW QPAIR ; ?PAIRS
 DW COMP ; COMPILE
 DW XPLOO ; (+LOOP)
 DW BACK ; BACK
 DW SEMIS ; ;S
;
; UNTIL
;
 DB 0C5H
 DB 'UNTI'
 DB 'L'+80H
 DW PLOOP-8
UNTIL: DW DOCOL ; :
 DW ONE ; 1
 DW QPAIR ; ?PAIRS
 DW COMP ; COMPILE
 DW ZBRAN ; 0BRANCH
 DW BACK ; BACK
 DW SEMIS ; ;S
;
; END
;
 DB 0C3H
 DB 'EN'
 DB 'D'+80H
 DW UNTIL-8
ENDD: DW DOCOL ; :
 DW UNTIL ; UNTIL
 DW SEMIS ; ;S
;
; AGAIN
;
 DB 0C5H
 DB 'AGAI'
 DB 'N'+80H
 DW ENDD-6
AGAIN: DW DOCOL ; :
 DW ONE ; 1
 DW QPAIR ; ?PAIRS
 DW COMP ; COMPILE
 DW BRAN ; BRANCH
 DW BACK ; BACK
 DW SEMIS ; ;S
;
; REPEAT
;
 DB 0C6H
 DB 'REPEA'
 DB 'T'+80H
 DW AGAIN-8
REPEA: DW DOCOL ; :
 DW TOR ; >R
 DW TOR ; >R
 DW AGAIN ; AGAIN
 DW FROMR ; R>
 DW FROMR ; R>
 DW TWO ; 2
 DW SUBB ; -
 DW ENDIFF ; ENDIF
 DW SEMIS ; ;S
;
; IF
;
 DB 0C2H
 DB 'I'
 DB 'F'+80H
 DW REPEA-9
IFF: DW DOCOL ; :
 DW COMP ; COMPILE
 DW ZBRAN ; 0BRANCH
 DW HERE ; HERE
 DW ZERO ; 0
 DW COMMA ; ,
 DW TWO ; 2
 DW SEMIS ; ;S
;
; ELSE
;
 DB 0C4H
 DB 'ELS'
 DB 'E'+80H
 DW IFF-5
ELSEE: DW DOCOL ; :
 DW TWO ; 2
 DW QPAIR ; ?PAIRS
 DW COMP ; COMPILE
 DW BRAN ; BRANCH
 DW HERE ; HERE
 DW ZERO ; 0
 DW COMMA ; ,
 DW SWAP ; SWAP
 DW TWO ; 2
 DW ENDIFF ; ENDIF
 DW TWO ; 2
 DW SEMIS ; ;S
;
; WHILE
;
 DB 0C5H
 DB 'WHIL'
 DB 'E'+80H
 DW ELSEE-7
WHILE: DW DOCOL ; :
 DW IFF ; IF
 DW TWOP ; 2+
 DW SEMIS ; ;S
;
; SPACES
;
 DB 86H
 DB 'SPACE'
 DB 'S'+80H
 DW WHILE-8
SPACS: DW DOCOL ; :
 DW ZERO ; 0
 DW MAX ; MAX
 DW DDUP ; -DUP
 DW ZBRAN ; 0BRANCH
 DW SPAX1-$
 DW ZERO ; 0
 DW XDO ; (DO)
SPAX2: DW SPACE ; SPACE
 DW XLOOP ; (LOOP)
 DW SPAX2-$
SPAX1: DW SEMIS ; ;S
;
; <#
;
 DB 82H
 DB '<'
 DB '#'+80H
 DW SPACS-9
BDIGS: DW DOCOL ; :
 DW PAD ; PAD
 DW HLD ; HLD
 DW STORE ; !
 DW SEMIS ; ;S
;
; #>
;
 DB 82H
 DB '#'
 DB '>'+80H
 DW BDIGS-5
EDIGS: DW DOCOL ; :
 DW DROP ; DROP
 DW DROP ; DROP
 DW HLD ; HLD
 DW AT ; @
 DW PAD ; PAD
 DW OVER ; OVER
 DW SUBB ; -
 DW SEMIS ; ;S
;
; SIGN
;
 DB 84H
 DB 'SIG'
 DB 'N'+80H
 DW EDIGS-5
SIGN: DW DOCOL ; :
 DW ROT ; ROT
 DW ZLESS ; 0<
 DW ZBRAN ; 0BRANCH
 DW SIGN1-$
 DW LIT ; LIT
 DW 2DH
 DW HOLD ; HOLD
SIGN1: DW SEMIS ; ;S
;
; #
;
 DB 81H
 DB '#'+80H
 DW SIGN-7
DIG: DW DOCOL ; :
 DW BASE ; BASE
 DW AT ; @
 DW MSMOD ; M/MOD
 DW ROT ; ROT
 DW LIT ; LIT
 DW 9
 DW OVER ; OVER
 DW LESS ; <
 DW ZBRAN ; 0BRANCH
 DW DIG1-$
 DW LIT ; LIT
 DW 7
 DW PLUS ; +
DIG1: DW LIT ; LIT
 DW 30H
 DW PLUS ; +
 DW HOLD ; HOLD
 DW SEMIS ; ;S
;
; #S
;
 DB 82H
 DB '#'
 DB 'S'+80H
 DW DIG-4
DIGS: DW DOCOL ; :
DIGS1: DW DIG ; #
 DW OVER ; OVER
 DW OVER ; OVER
 DW ORR ; OR
 DW ZEQU ; 0=
 DW ZBRAN ; 0BRANCH
 DW DIGS1-$
 DW SEMIS ; ;S
;
; D.R
;
 DB 83H
 DB 'D.'
 DB 'R'+80H
 DW DIGS-5
DDOTR: DW DOCOL ; :
 DW TOR ; >R
 DW SWAP ; SWAP
 DW OVER ; OVER
 DW DABS ; DABS
 DW BDIGS ; <#
 DW DIGS ; #S
 DW SIGN ; SIGN
 DW EDIGS ; #>
 DW FROMR ; R>
 DW OVER ; OVER
 DW SUBB ; -
 DW SPACS ; SPACES
 DW TYPE ; TYPE
 DW SEMIS ; ;S
;
; .R
;
 DB 82H
 DB '.'
 DB 'R'+80H
 DW DDOTR-6
DOTR: DW DOCOL ; :
 DW TOR ; >R
 DW STOD ; S->D
 DW FROMR ; R>
 DW DDOTR ; D.R
 DW SEMIS ; ;S
;
; D.
;
 DB 82H
 DB 'D'
 DB '.'+80H
 DW DOTR-5
DDOT: DW DOCOL ; :
 DW ZERO ; 0
 DW DDOTR ; D.R
 DW SPACE ; SPACE
 DW SEMIS ; ;S
;
; .
;
 DB 81H
 DB '.'+80H
 DW DDOT-5
DOT: DW DOCOL ; :
 DW STOD ; S->D
 DW DDOT ; D.
 DW SEMIS ; ;S
;
; ?
;
 DB 81H
 DB '?'+80H
 DW DOT-4
QUES: DW DOCOL ; :
 DW AT ; @
 DW DOT ; .
 DW SEMIS ; ;S
;
; U.
;
 DB 82H
 DB 'U'
 DB '.'+80H
 DW QUES-4
UDOT: DW DOCOL ; :
 DW ZERO ; 0
 DW DDOT ; D.
 DW SEMIS ; ;S
;
; VLIST
;
 DB 85H
 DB 'VLIS'
 DB 'T'+80H
 DW UDOT-5
VLIST: DW DOCOL ; :
 DW LIT ; LIT
 DW 80H
 DW OUTT ; OUT
 DW STORE ; !
 DW CONT ; CONTEXT
 DW AT ; @
 DW AT ; @
VLIS1: DW OUTT ; OUT
 DW AT ; @
 DW CSLL ; C/L
 DW GREAT ; >
 DW ZBRAN ; 0BRANCH
 DW VLIS2-$
 DW CR ; CR
 DW ZERO ; 0
 DW OUTT ; OUT
 DW STORE ; !
VLIS2: DW DUP ; DUP
 DW IDDOT ; ID.
 DW SPACE ; SPACE
 DW SPACE ; SPACE
 DW PFA ; PFA
 DW LFA ; LFA
 DW AT ; @
 DW DUP ; DUP
 DW ZEQU ; 0=
 DW QTERM ; ?TERMINAL
 DW ORR ; OR
 DW ZBRAN ; 0BRANCH
 DW VLIS1-$
 DW DROP ; DROP
 DW SEMIS ; ;S
;
; BYE
;
 DB 83H ;EXIT CP/M
 DB 'BY'
 DB 'E'+80H
 DW VLIST-8
BYE: DW $+2
 JMP PEXIT ;REENTER DOS
;
; TASK
;
 DB 84H
 DB 'TAS'
 DB 'K'+80H
 DW BYE-6
TASK: DW DOCOL
 DW SEMIS
;
; TERMINAL ROUTINES
;
XRTN EQU 100H
PQTER: CALL XRTN+3
 JMP HPUSH
;
PEMIT: DW $+2
 CALL XRTN+6
 JMP NEXT
;
PKEY: CALL XRTN+9
 JMP HPUSH
;
PCR: CALL XRTN+12
 JMP NEXT
;
PMSG: CALL XRTN+15
 JMP NEXT
;
PEXIT: JMP XRTN+18
;
INITDP EQU $
 END

=0.33/2.28 07:28:24
 



T ; @
 DW SEMIS ; ;S
;
; LFA-LINK FIELD ADDR
;
 DB 83H
 DB 'LF'
 DB 'A'+80H
 DW LATES-9
LFA: DW DOCOL ; :
 DW LIT ; LIT
 DW 4
 DW SUBB ; -
 DW SEMIS ; ;S
;
; CFA-CODE FIELD ADDR
;
 DB 83H
 DB 'CF'
 DB 'A'+80H
 DW LFA-6
CFA: DW DOCOL ; :
 DW TWO ; 2
 DW SUBB ; -
 DW SEMIS ; ;S
;
; NFA-NAME FIELD ADDR
;
 DB 83H
 DB 'NF'
 DB 'A'+80H
 DW CFA-6
NFA: DW DOCOL ; :
 DW LIT ; LIT
 DW 5
 DW SUBB ; -
 DW LIT ; LIT
 DW -1
 DW TRAV ; TRAVERSE
 DW SEMIS ; ;S
;
; PFA-PARAMETER FLD ADDR
;
 DB 83H
 DB 'PF'
 DB 'A'+80H
 DW NFA-6
PFA: DW DOCOL ; :
 DW ONE ; 1
 DW TRAV ; TRAVERSE
 DW LIT ; LIT
 DW 5
 DW PLUS ; +
 DW SEMIS ; ;S
;
; !CSP
;
 DB 84H
 DB '!CS'
 DB 'P'+80H
 DW PFA-6
SCSP: DW DOCOL ; :
 DW SPAT ; SP@
 DW CSP ; CSP
 DW STORE ; !
 DW SEMIS ; ;S
;
; ?ERROR
;
 DB 86H
 DB '?ERRO'
 DB 'R'+80H
 DW SCSP-7
QERR: DW DOCOL ; :
 DW SWAP ; SWAP
 DW ZBRAN ; 0BRANCH
 DW QERR1-$
 DW ERROR ; ERROR
 DW BRAN ; BRANCH
 DW QERR2-$
QERR1: DW DROP ; DROP
QERR2: DW SEMIS ; ;S
;
; ?COMP
;
 DB 85H
 DB '?COM'
 DB 'P'+80H
 DW QERR-9
QCOMP: DW DOCOL ; :
 DW STATE ; STATE
 DW AT ; @
 DW ZEQU ; 0=
 DW LIT ; LIT
 DW 11H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?EXEC
;
 DB 85H
 DB '?EXE'
 DB 'C'+80H
 DW QCOMP-8
QEXEC: DW DOCOL ; :
 DW STATE ; STATE
 DW AT ; @
 DW LIT ; LIT
 DW 12H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?PAIRS
;
 DB 86H
 DB '?PAIR'
 DB 'S'+80H
 DW QEXEC-8
QPAIR: DW DOCOL ; :
 DW SUBB ; -
 DW LIT ; LIT
 DW 13H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?CSP
;
 DB 84H
 DB '?CS'
 DB 'P'+80H
 DW QPAIR-9
QCSP: DW DOCOL ; :
 DW SPAT ; SP@
 DW CSP ; CSP
 DW AT ; @
 DW SUBB ; -
 DW LIT ; LIT
 DW 14H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; ?LOADING
;
 DB 88H
 DB '?LOADIN'
 DB 'G'+80H
 DW QCSP-7
QLOAD: DW DOCOL ; :
 DW BLK ; BLK
 DW AT ; @
 DW ZEQU ; 0=
 DW LIT ; LIT
 DW 16H
 DW QERR ; ?ERROR
 DW SEMIS ; ;S
;
; COMPILE
;
 DB 87H
 DB 'COMPIL'
 DB 'E'+80H
 DW QLOAD-0BH
COMP: DW DOCOL ; :
 DW QCOMP ; ?COMP
 DW FROMR ; R>
 DW DUP ; DUP
 DW TWOP ; 2+
 DW TOR ; >R
 DW AT ; @
 DW COMMA ; ,
 DW SEMIS ; ;S
;
; 'LEFT SQR BRACKET'
;
 DB 0C1H
 DB 0DBH ;LEFT SQUARE BRACKET + 80H
 DW COMP-0AH
LBRAC: DW DOCOL ; :
 DW ZERO ; 0
 DW STATE ; STATE
 DW STORE ; !
 DW SEMIS ; ;S
;
; 'RIGHT SQR BRACKET'
;
 DB 81H
 DB 0DDH ;RIGHT SQUARE BRACKET + 80H
 DW LBRAC-4
RBRAC: DW DOCOL ; :
 DW LIT ; LIT
 DW 0C0H
 DW STATE ; STATE
 DW STORE ; !
 DW SEMIS ; ;S
;
; SMUDGE
;
 DB 86H
 DB 'SMUDG'
 DB 'E'+80H
 DW RBRAC-4
SMUDG: DW DOCOL ; :
 DW LATES ; LATEST
 DW LIT ; LIT
 DW 20H
 DW TOGGL ; TOGGLE
 DW SEMIS ; ;S
;
; HEX
;
 DB 83H
 DB 'HE'
 DB 'X'+80H
 DW SMUDG-9
HEX: DW DOCOL ; :
 DW LIT ; LIT
 DW 10H
 DW BASE ; BASE
 DW STORE ; !
 DW SEMIS ; ;S
;
; DECIMAL
;
 DB 87H
 DB 'DECIMA'
 DB 'L'+80H
 DW HEX-6
DEC: DW DOCOL ; :
 DW LIT ; LIT
 DW 0AH
 DW BASE ; BASE
 DW STORE ; !
 DW SEMIS ; ;S
;
; ( CODE)
;
 DB 87H
 DB '( CODE'
 DB ')'+80H
 DW DEC-0AH
PSCOD: DW DOCOL ; :
 DW FROMR ; R>
 DW LATES ; LATEST
 DW PFA ; PFA
 DW CFA ; CFA
 DW STORE ; !
 DW SEMIS ; ;S
;
; CODE
;
 DB 0C5H
 DB ' COD'
 DB 'E'+80H
 DW PSCOD-0AH
SEMIC: DW DOCOL ; :
 DW QCSP ; ?CSP
 DW COMP ; COMPILE
 DW PSCOD ; (;CODE)
 DW LBRAC ; 
 DW NOOP ; NOOP
 DW SEMIS ; ;S
;
; <BUILDS
;
 DB 87H
 DB '<BUILD'
 DB 'S'+80H
 DW SEMIC-8
BUILD: DW DOCOL ; :
 DW ZERO ; 0
 DW CON ; CONSTANT
 DW SEMIS ; ;S
;
; DOES>
;
 DB 85H
 DB 'DOES'
 DB '>'+80H
 DW BUILD-0AH
DOES: DW DOCOL ; :
 DW FROMR ; R>
 DW LATES ; LATEST
 DW PFA ; PFA
 DW STORE ; !
 DW PSCOD ; (;CODE)
DODOE: LHLD RPP ;(HL) <- (RP)
 DCX H
 MOV M,B ;(R1) <- (IP) = PFA = (SUBSTITUTE CFA)
 DCX H
 MOV M,C
 SHLD RPP ;(RP) <- (RP) - 2
 INX D ;(DE) <- PFA = (SUBSTITUTE PFA)
 XCHG
 MOV C,M ;(IP) <- (SUBSTITUTE PFA)
 INX H
 MOV B,M
 INX H
 JMP HPUSH ;(S1) <- PFA+2 = SUBSTITUTE PFA
;
; COUNT
;
 DB 85H
 DB 'COUN'
 DB 'T'+80H
 DW DOES-8
COUNT: DW DOCOL ; :
 DW DUP ; DUP
 DW ONEP ; 1+
 DW SWAP ; SWAP
 DW CAT ; C@
 DW SEMIS ; ;S
;
; TYPE
;
 DB 84H
 DB 'TYP'
 DB 'E'+80H
 DW COUNT-8
TYPE: DW DOCOL ; :
 DW DDUP ; -DUP
 DW ZBRAN ; 0BRANCH
 DW TYPE1-$
 DW OVER ; OVER
 DW PLUS ; +
 DW SWAP ; SWAP
 DW XDO ; (DO)
TYPE2: DW IDO ; I
 DW CAT ; C@
 DW EMIT ; EMIT
 DW XLOOP ; (LOOP)
 DW TYPE2-$
 DW BRAN ; BRANCH
 DW TYPE3-$
TYPE1: DW DROP ; DROP
TYPE3: DW SEMIS ; ;S
;
; -TRAILING
;
 DB 89H
 DB '-TRAILIN'
 DB 'G'+80H
 DW TYPE-7
DTRAI: DW DOCOL ; :
 DW DUP ; DUP
 DW ZERO ; 0
 DW XDO ; (DO)
DTRA1: DW OVER ; OVER
 DW OVER ; OVER
 DW PLUS ; +
 DW ONE ; 1
 DW SUBB ; -
 DW CAT ; C@
 DW BL ; BL
 DW SUBB ; -
 DW ZBRAN ; 0BRANCH
 DW DTRA2-$
 DW LEAVE ; LEAVE
 DW BRAN ; BRANCH
 DW DTRA3-$
DTRA2: DW ONE ; 1
 DW SUBB ; -
DTRA3: DW XLOOP ; (LOOP)
 DW DTRA1-$
 DW SEMIS ; ;S
;
; (.")
;
 DB 84H
 DB '(."'
 DB ')'+80H
 DW DTRAI-0CH
PDOTQ: DW DOCOL ; :
 DW RR ; R
 DW COUNT ; COUNT
 DW DUP ; DUP
 DW ONEP ; 1+
 DW FROMR ; R>
 DW PLUS ; +
 DW TOR ; >R
 DW TYPE ; TYPE
 DW SEMIS ; ;S
;
; ."
;
 DB 0C2H
 DB '.'
 DB '"'+80H
 DW PDOTQ-7
DOTQ: DW DOCOL ; :
 DW LIT ; LIT
 DW 22H
 DW STATE ; STATE
 DW AT ; @
 DW ZBRAN ; 0BRANCH
 DW DOTQ1-$
 DW COMP ; COMPILE
 DW PDOTQ ; (.")
 DW WORD ; WORD
 DW HERE ; HERE
 DW CAT ; C@
 DW ONEP ; 1+
 DW ALLOT ; ALLOT
 DW BRAN ; BRANCH
 DW DOTQ2-$
DOTQ1: DW WORD ; WORD
 DW HERE ; HERE
 DW COUNT ; COUNT
 DW TYPE ; TYPE
DOTQ2: DW SEMIS ; ;S

; T=0.45/3.05 07:01:35


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


 DW SEMIS ; ;S
 
R; T=0.45/3.05 07:01:35
 



01:35
 


                     @   ;****************************
;* FIG-FORTH RELEASE 1.1 FOR
;****************************
; RELEASE & VERSION NUMB
FIGREL EQU 1
FIGREV EQU 1
USRVER EQU 0
;
;
;
ADOT EQU 02EH
BELL EQU 07H
BSIN EQU 7FH
BSOUT EQU 08H
;
;
;
XRTN EQU 0D000H
EM EQU 04000H
US EQU 40H
RTS EQU 0A0H
;
INITR0 EQU 6000H-US
INITS0 EQU INITR0-RTS
;
;----------------------------
;
 ORG 100H
ORIG: NOP
 JMP CLD
 NOP
 JMP WRM
 DB FIGREL
 DB FIGREV
 DB USRVER
 DB 0EH
 DW TASK-7
 DW BSIN
 DW INITR0
;
; FOLLOWING USED BY COLD
; MUST BE IN SAME ORDER AS US
 
 DW INITS0
 DW INITR0
 DW INITS0
 DW 1FH
 DW 0
 DW INITDP
 DW INITDP
 DW FORTH+6
;
; END DATA USED BY COLD
;
 DW 5H,0B320H
UP: DW INITR0
RPP: DW INITR0
BIP: DW 0
;
TNEXT: LXI H,BIP
 MOV A,M
 CMP C
 JNZ TNEX1
 INX H
 MOV A,M
 CMP B
 JNZ TNEX1
BREAK: NOP
 NOP
 NOP
TNEX1: LDAX B
 INX B
 MOV L,A
 JMP NEXT+3
;
DPUSH: PUSH D
HPUSH: PUSH H
NEXT: LDAX B
 INX B
 MOV L,A
 LDAX B
 INX B
 MOV H,A
NEXT1: MOV E,M
 INX H
 MOV D,M
 XCHG
 PCHL
;
DP0: DB 83H
 DB 'LI'
 DB 'T'+80H
 DW 0
LIT: DW $+2
 LDAX B
 INX B
 MOV L,A
 LDAX B
 INX B
 MOV H,A
 JMP HPUSH
;
; EXECUTE
;
 DB 87H
 DB 'EXECUT'
 DB 'E'+80H
 DW LIT-6
EXEC: DW $+2
 POP H
 JMP NEXT1
;
; BRANCH
;
 DB 86H
 DB 'BRANC'
 DB 'H'+80H
 DW EXEC-0AH
BRAN: DW $+2
BRAN1: MOV H,B
 MOV L,C
 MOV E,M
 INX H
 MOV D,M
DCX H
 DAD D
 MOV C,L
 MOV B,H
 JMP NEXT
;
; 0BRANCH
;
 DB 87H
 DB '0BRANC'
 DB 'H'+80H
 DW BRAN-9
ZBRAN: DW $+2
 POP H
 MOV A,L
 ORA H
 JZ BRAN1
 INX B
 INX B
 JMP NEXT
;
; (LOOP)
;
 DB 86H
 DB '(LOOP'
 DB ')'+80H
 DW ZBRAN-0AH
XLOOP: DW $+2
 LXI D,1
XLOO1: LHLD RPP
 MOV A,M
 ADD E
 MOV M,A
 MOV E,A
 INX H
 MOV A,M
 ADC D
 MOV M,A
 INX H
 INR D
 DCR D
 MOV D,A
 JM XLOO2
 MOV A,E
 SUB M
 MOV A,D
 INX H
 SBB M
 JMP XLOO3
XLOO2: MOV A,M
 SUB E
 INX H
 MOV A,M
 SBB D
;
XLOO3: JM BRAN1
 INX H
 SHLD RPP
 INX B
 INX B
 JMP NEXT
;
; (+LOOP)
;
 DB 87H
 DB '(+LOOP'
 DB ')'+80H
 DW XLOOP-9
XPLOO: DW $+2
 POP D
 JMP XLOO1
;
; (DO)
;
 DB 84H
 DB '(D'
 DB 'O'
 DB ')'+80H
 DW XPLOO-0AH
XDO: DW $+2
 LHLD RPP
 DCX H
 DCX H
 DCX H
 DCX H
 SHLD RPP
 POP D
 MOV M,E
 INX H
 MOV M,D
 POP D
 INX H
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; I
;
 DB 81H
 DB 'I'+80H
 DW XDO-7
IDO: DW $+2
 LHLD RPP
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
;
; DIGIT
;
 DB 85H
 DB 'DIGI'
 DB 'T'+80H
 DW IDO-4
DIGIT: DW $+2
 POP H
 POP D
 MOV A,E
 SUI 30H
 JM DIGI2
 CPI 0AH
 JM DIGI1
 SUI 7
 CPI 0AH
 JM DIGI2
DIGI1: CMP L
 JP DIGI2
 MOV E,A
 LXI H,1
 JMP DPUSH
DIGI2: MOV L,H
 JMP HPUSH
;
; (FIND) (2-1)FAILURE (2
;
 DB 86H
 DB '(FIND'
 DB ')'+80H
 DW DIGIT-8
PFIND: DW $+2
 POP D
PFIN1: POP H
 PUSH H
 LDAX D
 XRA M
 ANI 3FH
 JNZ PFIN4
PFIN2: INX H
 INX D
 LDAX D
 XRA M
 ADD A
 JNZ PFIN3
 JNC PFIN2
 LXI H,5
 DAD D
 XTHL
PFIN6: DCX D
 LDAX D
 ORA A
 JP PFIN6
 MOV E,A
 MVI D,0
 LXI H,1
 JMP DPUSH
PFIN3: JC PFIN5
PFIN4: INX D
 LDAX D
 ORA A
 JP PFIN4
PFIN5: INX D
 XCHG
 MOV E,M
 INX H
 MOV D,M
 MOV A,D
 ORA E
 JNZ PFIN1
 POP H
 LXI H,0
 JMP HPUSH
;
; ENCLOSE
;
 DB 87H
 DB 'ENCLOS'
 DB 'E'+80H
 DW PFIND-9
ENCL: DW $+2
 POP D
 POP H
 PUSH H
 MOV A,E
 MOV D,A
 MVI E,-1
 DCX H
;
ENCL1: INX H
 INR E
 CMPM
 JZ ENCL1
;
 MVI D,0
 PUSH D
 MOV D,A
 MOV A,M
 ANA A
 JNZ ENCL2
 MVI D,0
 INR E
 PUSH D
 DCR E
 PUSH D
 JMP NEXT
;
;
ENCL2: MOV A,D
 INX H
 INR E
 CMP M
 JZ ENCL4
 MOV A,M
 ANA A
 JNZ ENCL2
;
 MVI D,0
 PUSH D
 PUSH D
 JMP NEXT
;
ENCL4: MVI D,0
;
 PUSH D
 INR E
;
 PUSH D
 JMP NEXT
;
; EMIT
;
 DB 84H
 DB 'EMI'
 DB 'T'+80H
 DW ENCL-0AH
EMIT: DW DOCOL
 DW PEMIT
 DW ONE,OUTT
 DW PSTOR,SEMIS
;
; KEY
;
 DB 83H
 DB 'KE'
 DB 'Y'+80H
 DW EMIT-7
KEY: DW $+2
 JMP PKEY
;
; ?TERMINAL
;
 DB 89H
 DB '?TERMINA'
 DB 'L'+80H
 DW KEY-6
QTERM: DW $+2
 LXI H,0
 JMP PQTER
;
; CR
;
 DB 82H
 DB 'C'
 DB 'R'+80H
 DW QTERM-0CH
CR: DW $+2
 JMP PCR
;
; CMOVE
;
 DB 85H
 DB 'CMOV'
 DB 'E'+80H
 DW CR-5
CMOVE: DW $+2
 MOV L,C
 MOV H,B
 POP B
 POP D
 XTHL
;
 JMP CMOV2
CMOV1: MOV A,M
 INX H
 STAX D
 INX D
 DCX B
CMOV2: MOV A,B
 ORA C
 JNZ CMOV1
 POP B
 JMP NEXT
;
; U*
;
 DB 82H
 DB 'U'
 DB '*'+80H
 DW CMOVE-8
USTAR: DW $+2
 POP D
 POP H
 PUSH B
 MOV B,H
 MOV A,L
 CALL MPYX
;
 PUSH H
 MOV H,A
 MOV A,B
 MOV B,H
 CALL MPYX
;
 POP D
 MOV C,D
;
;
;
;
;
 DAD B
 ACI 0
 MOV D,L
 MOV L,H
 MOV H,A
 POP B
 PUSH D
 JMP HPUSH
;
;
;
;
;
;
MPYX: LXI H,0
 MVI C,8
MPYX1: DAD H
 RAL
 JNC MPYX2
 DAD D
 ACI 0
MPYX2: DCR C
 JNZ MPYX1
 RET
;
; U/
;
 DB 82H
 DB 'U'
 DB '/'+80H
 DW USTAR-5
USLAS: DW $+2
 LXI H,4
 DAD SP
 MOV E,M
 MOV M,C
 INX H
 MOV D,M
 MOV M,B
 POP B
 POP H
 MOV A,L
 SUB C
 MOV A,H
 SBB B
 JC USLA1
 LXI H,0FFFFH
 LXI D,0FFFFH
 JMP USLA7
USLA1: MVI A,16
USLA2: DAD H
 RAL
 XCHG
 DAD H
 JNC USLA3
 INX D
 ANA A
USLA3: XCHG
 RAR
 PUSH PSW
 JNC USLA4
 MOV A,L
 SUB C
 MOV L,A
 MOV A,H
 SBB B
 MOV H,A
 JMP USLA5
USLA4: MOV A,L
 SUB C
 MOV L,A
 MOV A,H
 SBB B
 MOV H,A
 JNC USLA5
 DAD B
 DCX D
USLA5: INX D
 POP PSW
 DCR A
 JNZ USLA2
USLA7: POP B
 PUSH H
 PUSH D
 JMP NEXT
;
;
;
 DB 83H
 DB 'AN'
 DB 'D'+80H
 DW USLAS-5
ANDD: DW $+2
 POP D
 POP H
 MOV A,E
 ANA L
 MOV L,A
 MOV A,D
 ANA H
 MOV H,A
 JMP HPUSH
;
; ORR
;
 DB 82H
 DB 'O'
 DB 'R'+80H
 DW ANDD -6
ORR: DW $+2
 POP D
 POP H
 MOV A,E
 ORA L
 MOV L,A
 MOV A,D
 ORA H
 MOV H,A
 JMP HPUSH
;
; XOR LOGICAL OPERATOR
;
 DB 83H
 DB 'XO'
 DB 'R'+80H
 DW ORR-5
XORR: DW $+2
 POP D
 POP H
 MOV A,E
 XRA L
 MOV L,A
 MOV A,D
 XRA H
 MOV H,A
 JMP HPUSH
;
; SP@
;
 DB 83H
 DB 'SP'
 DB '@'+80H
 DW XORR-6
SPAT: DW $+2
 LXI H,0
 DAD SP
 JMP HPUSH
;
; SP!
;
 DB 83H
 DB 'SP'
 DB '!'+80H
 DW SPAT-6
SPSTO: DW $+2
 LHLD UP
 LXI D,6
 DAD D
 MOV E,M
 INX H
 MOV D,M
 XCHG
 SPHL
 JMP NEXT
;
; RP@
;
 DB 83H
 DB 'RP'
 DB '@'+80H
 DW SPSTO-6
RPAT: DW $+2
 LHLD RPP
 JMP HPUSH
;
; RP!
;
 DB 83H
 DB 'RP'
 DB '!'+80H
 DW RPAT-6
RPSTO: DW $+2
 LHLD UP
 LXI D,8
 DAD D
 MOV E,M
 INX H
 MOV D,M
 XCHG
 SHLD RPP
 JMP NEXT
;
; ;S
;
 DB 82H
 DB ';'
 DB 'S'+80H
 DW RPSTO-6
SEMIS: DW $+2
 LHLD RPP
 MOV C,M
 INX H
 MOV B,M
 INX H
 SHLD RPP
 JMP NEXT
;
; LEAVE
;
 DB 85H
 DB 'LEAV'
 DB 'E'+80H
 DW SEMIS-5
LEAVE: DW $+2
 LHLD RPP
 MOV E,M
 INX H
 MOV D,M
 INX H
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; >R
;
 DB 82H
 DB '>'
 DB 'R'+80H
 DW LEAVE-8
TOR: DW $+2
 POP D
 LHLD RPP
 DCX H
 DCX H
 SHLD RPP
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; R> ;
;
 DB 82H
 DB 'R'
 DB '>'+80H
 DW TOR-5
FROMR: DW $+2
 LHLD RPP
 MOV E,M
 INX H
 MOV D,M
 INX H
 SHLD RPP
 PUSH D
 JMP NEXT
;
; R
;
 DB 81H
 DB 'R'+80H
 DW FROMR-5
RR: DW IDO+2
;
; 0=
;
 DB 82H
 DB '0'
 DB '='+80H
 DW RR-4
ZEQU: DW $+2
 POP H
 MOV A,L
 ORA H
 LXI H,0
 JNZ ZEQU1
 INX H
ZEQU1: JMP HPUSH
;
; 0<
;
 DB 82H
 DB '0'
 DB '<'+80H
 DW ZEQU-5
ZLESS: DW $+2
 POP H
 DAD H
 LXI H,0
 JNC ZLES1
 INX H
ZLES1: JMP HPUSH
;
; +
;
 DB 81H
 DB '+'+80H
 DW ZLESS-5
PLUS: DW $+2
 POP D
 POP H
 DAD D
 JMP HPUSH
;
; D+
;
 DB 82H
 DB 'D'
 DB '+'+80H
 DW PLUS-4
DPLUS: DW $+2
 LXI H,6
 DAD SP
 MOV E,M
 MOV M,C
 INX H
 MOV D,M
 MOV M,B
 POP B
 POP H
 DAD D
 XCHG
 POP H
 MOV A,L
 ADC C
 MOV L,A
 MOV A,H
 ADC B
 MOV H,A
 POP B
 PUSH D
 JMP HPUSH
;
; MINUS
;
 DB 85H
 DB 'MINU'
 DB 'S'+80H
 DW DPLUS-5
MINUS: DW $+2
 POP H
 MOV A,L
 CMA
 MOV L,A
 MOV A,H
 CMA
 MOV H,A
 INX H
 JMP HPUSH
;
; DMINUS
;
 DB 86H
 DB 'DMINU'
 DB 'S'+80H
 DW MINUS-8
DMINU: DW $+2
 POP H
 POP D
 SUB A
 SUB E
 MOV E,A
 MVI A,0
 SBB D
 MOV D,A
 MVI A,0
 SBB L
 MOV L,A
 MVI A,0
 SBB H
 MOV H,A
 PUSH D
 JMP HPUSH
;
; OVER
;
 DB 84H
 DB 'OVE'
 DB 'R'+80H
 DW DMINU-9
OVER: DW $+2
 POP D
 POP H
 PUSH H
 JMP DPUSH
;
; DROP
;
 DB 84H
 DB 'DRO'
 DB 'P'+80H
 DW OVER-7
DROP: DW $+2
 POP H
 JMP NEXT
 
; SWAP
;
 DB 84H
 DB 'SWA'
 DB 'P'+80H
 DW DROP-7
SWAP: DW $+2
 POP H
 XTHL
 JMP HPUSH
;
; DUP
;
 DB 83H
 DB 'DU'
 DB 'P'+80H
 DW SWAP-7
DUP: DW $+2
 POP H
 PUSH H
 JMP HPUSH
;
; 2DUP
;
 DB 84H
 DB '2DU'
 DB 'P'+80H
 DW DUP-6
TDUP: DW $+2
 POP H
 POP D
 PUSH D
 PUSH H
 JMP DPUSH
;
; +!
;
 DB 82H
 DB '+'
 DB '!'+80H
 DW TDUP-7
PSTOR: DW $+2
 POP H
 POP D
 MOV A,M
 ADD E
 MOV M,A
 INX H
 MOV A,M
 ADC D
 MOV M,A
 JMP NEXT
;
; TOGGLE
;
 DB 86H
 DB 'TOGGL'
 DB 'E'+80H
 DW PSTOR-5
TOGGL: DW $+2
 POP D
 POP H
 MOV A,M
 XRA E
 MOV M,A
 JMP NEXT
;
; @
;
 DB 81H
 DB '@'+80H
 DW TOGGL-9
AT: DW $+2
 POP H
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
 
; C@
;
 DB 82H
 DB 'C'
 DB '@'+80H
 DW AT-4
CAT: DW $+2
 POP H
 MOV L,M
 MVI H,0
 JMP HPUSH
;
; 2@
;
 DB 82H
 DB '2'
 DB '@'+80H
 DW CAT-5
TAT: DW $+2
 POP H
 LXI D,2
 DAD D
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 LXI D,-3
 DAD D
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
;
; !
;
 DB 81H
 DB '!'+80H
 DW TAT-5
STORE: DW $+2
 POP H
 POP D
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; C!
;
 DB 82H
 DB 'C'
 DB '!'+80H
 DW STORE-4
CSTOR: DW $+2
 POP H
 POP D
 MOV M,E
 JMP NEXT
;
; 2!
;
 DB 82H
 DB '2'
 DB '!'+80H
 DW CSTOR-5
TSTOR: DW $+2
 POP H
 POP D
 MOV M,E
 INX H
 MOV M,D
 INX H
 POP D
 MOV M,E
 INX H
 MOV M,D
 JMP NEXT
;
; :
;
 DB 0C1H
 DB ':'+80H
 DW TSTOR-5
COLON: DW DOCOL
 DW QEXEC
 DW SCSP
 DW CURR
 DW AT
 DW CONT
 DW STORE
 DW CREAT
 DW RBRAC
 DW PSCOD
DOCOL: LHLD RPP
 DCX H
 MOV M,B
 DCX H
 MOV M,C
 SHLD RPP
 INX D
 MOV C,E
 MOV B,D
 JMP NEXT
;
; ;
;
 DB 0C1H
 DB ';'+80H
 DW COLON-4
SEMI: DW DOCOL
 DW QCSP
 DW COMP
 DW SEMIS
 DW SMUDG
 DW LBRAC
 DW SEMIS
;
; NOOP
;
 DB 84H
 DB 'NOO'
 DB 'P'+80H
 DW SEMI-4
NOOP: DW DOCOL
 DW SEMIS
;
; CONSTANT
;
 DB 88H
 DB 'CONSTAN'
 DB 'T'+80H
 DW NOOP-7
CON: DW DOCOL
 DW CREAT
 DW SMUDG
 DW COMMA
 DW PSCOD
DOCON: INX D
 XCHG
 MOV E,M
 INX H
 MOV D,M
 PUSH D
 JMP NEXT
;
; VARIABLE
;
 DB 88H
 DB 'VARIABL'
 DB 'E'+80H
 DW CON-0BH
VAR: DW DOCOL
 DW CON
 DW PSCOD
 INX D
 PUSH D
 JMP NEXT
;
; USER
;
 DB 84H
 DB 'USE'
 DB 'R'+80H
 DW VAR-0BH
USER: DW DOCOL
 DW CON
 DW PSCOD
DOUSE: INX D
 XCHG
 MOV E,M
 MVI D,0
 LHLD UP
 DAD D
 JMP HPUSH
;
; 0
;
 DB 81H
 DB '0'+80H
 DW USER-7
ZERO: DW DOCON
 DW 0
;
; 1
;
 DB 81H
 DB '1'+80H
 DW ZERO-4
ONE: DW DOCON
 DW 1
;
; 2
;
 DB 81H
 DB '2'+80H
 DW ONE-4
TWO: DW DOCON
 DW 2
;
; 3
;
 DB 81H
 DB '3'+80H
 DW TWO-4
THREE: DW DOCON
 DW 3
;
; BL
;
 DB 82H
 DB 'B'
 DB 'L'+80H
 DW THREE-4
BL: DW DOCON
 DW 20H
;
; C/L
;
 DB 83H
 DB 'C/'
 DB 'L'+80H
 DW BL-5
CSLL: DW DOCON
 DW 64
;
; LIMIT
;
 DB 85H
 DB 'LIMI'
 DB 'T'+80H
 DW CSLL-6
LIMIT: DW DOCON
 DW EM
;
; +ORIGIN
;
 DB 87H
 DB '+ORIGI'
 DB 'N'+80H
 DW LIMIT-8
PORIG: DW DOCOL
 DW LIT
 DW ORIG
 DW PLUS
 DW SEMIS
;
; S0
;
 DB 82H
 DB 'S'
 DB '0'+80H
 DW PORIG-0AH
SZERO: DW DOUSE
 DW 6
;
; R0
;
 DB 82H
 DB 'R'
 DB '0'+80H
 DW SZERO-5
RZERO: DW DOUSE
 DW 8
;
; TIB
;
 DB 83H
 DB 'TI'
 DB 'B'+80H
 DW RZERO-5
TIB: DW DOUSE
 DB 0AH
;
; WIDTH
;
 DB 85H
 DB 'WIDT'
 DB 'H'+80H
 DW TIB-6
WIDTH: DW DOUSE
 DB 0CH
;
; WARNING
;
 DB 87H
 DB 'WARNIN'
 DB 'G'+80H
 DW WIDTH-8
WARN: DW DOUSE
 DB 0EH
;
; FENCE
;
 DB 85H
 DB 'FENC'
 DB 'E'+80H
 DW WARN-0AH
FENCE: DW DOUSE
 DB 10H
;
; DP
;
 DB 82H
 DB 'D'
 DB 'P'+80H
 DW FENCE-8
DP: DW DOUSE
 DB 12H
;
; VOC-LINK
;
 DB 88H
 DB 'VOC-LIN'
 DB 'K'+80H
 DW DP-5
VOCL: DW DOUSE
 DW 14H
;
;BLK
;
 DB 83H
 DB 'BL'
 DB 'K'+80H
 DW VOCL-0BH
BLK: DW DOUSE
 DB 16H
;
; INN
;
 DB 82H
 DB 'I'
 DB 'N'+80H
 DW BLK-6
INN : DW DOUSE
 DB 18H
;
; OUTT
;
 DB 83H
 DB 'OU'
 DB 'T'+80H
 DW INN-5
OUTT: DW DOUSE
 DB 1AH
;
; SCR
;
 DB 83H
 DB 'SC'
 DB 'R'+80H
 DW OUTT-6
SCR: DW DOUSE
 DB 1CH
;
; OFFSET
;
 DB 86H
 DB 'OFFSE'
 DB 'T'+80H
 DW SCR-6
OFSET: DW DOUSE
 DB 1EH
;
; CONTEXT
;
 DB 87H
 DB 'CONTEX'
 DB 'T'+80H
 DW OFSET-9
CONT: DW DOUSE
 DB 20H
;
; CURRENT
;
 DB 87H
 DB 'CURREN'
 DB 'T'+80H
 DW CONT-0AH
CURR: DW DOUSE
 DB 22H
;
; STATE
;
 DB 85H
 DB 'STAT'
 DB 'E'+80H
 DW CURR-0AH
STATE: DW DOUSE
 DB 24H
;
; BASE
;
 DB 84H
 DB 'BAS'
 DB 'E'+80H
 DW STATE-8
BASE: DW DOUSE
 DB 26H
;
; DPL
;
 DB 83H
 DB 'DP'
 DB 'L'+80H
 DW BASE-7
DPL: DW DOUSE
 DB 28H
;
; FLD
;
 DB 83H
 DB 'FL'
 DB 'D'+80H
 DW DPL-6
FLD: DW DOUSE
 DB 2AH
;
; CSP
;
 DB 83H
 DB 'CS'
 DB 'P'+80H
 DW FLD-6
CSP: DW DOUSE
 DB 2CH
;
; R#
;
 DB 82H
 DB 'R'
 DB '#'+80H
 DW CSP-6
RNUM: DW DOUSE
 DB 2EH
;
; HLD
;
 DB 83H
 DB 'HL'
 DB 'D'+80H
 DW RNUM-5
HLD: DW DOUSE
 DW 30H
;
; 1+
;
 DB 82H
 DB '1'
 DB '+'+80H
 DW HLD-6
ONEP: DW DOCOL
 DW ONE
 DW PLUS
 DW SEMIS
;
; 2+
;
 DB 82H
 DB '2'
 DB '+'+80H
 DW ONEP-5
TWOP: DW DOCOL
 DW TWO
 DW PLUS
 DW SEMIS
;
; HERE
;
 DB 84H
 DB 'HER'
 DB 'E'+80H
 DW TWOP-5
HERE: DW DOCOL
 DW DP
 DW AT
 DW SEMIS
;
; ALLOT
;
 DB 85H
 DB 'ALLO'
 DB 'T'+80H
 DW HERE-7
ALLOT: DW DOCOL
 DW DP
 DW PSTOR
 DW SEMIS
;
; ,
;
 DB 81H
 DB ','+80H
 DW ALLOT-8
COMMA: DW DOCOL
 DW HERE
 DW STORE
 DW TWO
 DW ALLOT
 DW SEMIS
;
; C,
;
 DB 82H
 DB 'C'
 DB ','+80H
 DW COMMA-4
CCOMM: DW DOCOL
 DW HERE
 DW CSTOR
 DW ONE
 DW ALLOT
 DW SEMIS
;
;
;
SSUB: MOV A,L
 SUB E
 MOV L,A
 MOV A,H
 SBB D
 MOV H,A
 RET
;
; -
;
 DB 81H
 DB '-'+80H
 DW CCOMM-5
SUBB: DW $+2
 POP D
 POP H
 CALL SSUB
 JMP HPUSH
;
; =
;
 DB 81H
 DB '='+80H
 DW SUBB-4
EQUAL: DW DOCOL
 DW SUBB
 DW ZEQU
 DW SEMIS
;
; <
;
 DB 81H
 DB '<'+80H
 DW EQUAL-4
LESS: DW $+2
 POP D
 POP H
 MOV A,D
 XRA H
 JM LES1
 CALL SSUB
LES1: INR H
 DCR H
 JM LES2
 LXI H,0
 JMP HPUSH
LES2: LXI H,1
 JMP HPUSH
;
; U<
;
 DB 82H
 DB 'U'
 DB '<'+80H
 DW LESS-4
ULESS: DW DOCOL,TDUP
 DW XORR,ZLESS
 DW ZBRAN
 DW ULES1-$
 DW DROP,ZLESS
 DW ZEQU
 DW BRAN
 DW ULES2-$
ULES1: DW SUBB,ZLESS
ULES2: DW SEMIS
;
; >
;
 DB 81H
 DB '>'+80H
 DW ULESS-5
GREAT: DW DOCOL
 DW SWAP
 DW LESS
 DW SEMIS
;
; ROT
;
 DB 83H
 DB 'RO'
 DB 'T'+80H
 DW GREAT-4
ROT: DW $+2
 POP D
 POP H
 XTHL
 JMP DPUSH
;
; SPACE
;
 DB 85H
 DB 'SPAC'
 DB 'E'+80H
 DW ROT-6
SPACE: DW DOCOL
 DW BL
 DW EMIT
 DW SEMIS
;
; -DUP
;
 DB 84H
 DB '-DU'
 DB 'P'+80H
 DW SPACE-8
DDUP: DW DOCOL
 DW DUP
 DW ZBRAN
 DW DDUP1-$
 DW DUP
DDUP1: DW SEMIS
;
; TRAVERSE
;
 DB 88H
 DB 'TRAVERS'
 DB 'E'+80H
 DW DDUP-7
TRAV: DW DOCOL
 DW SWAP
TRAV1: DW OVER
 DW PLUS
 DW LIT
 DW 7FH
 DW OVER
 DW CAT
 DW LESS
 DW ZBRAN
 DW TRAV1-$
 DW SWAP
 DW DROP
 DW SEMIS
;
; LATEST
;
 DB 86H
 DB 'LATES'
 DB 'T'+80H
 DW TRAV-0BH
LATES: DW DOCOL
 DW CURR
 DW AT
 DW AT
 DW SEMIS
;
; LFA-LINK FIELD ADDR
;
 DB 83H
 DB 'LF'
 DB 'A'+80H
 DW LATES-9
LFA: DW DOCOL
 DW LIT
 DW 4
 DW SUBB
 DW SEMIS
;
; CFA-CODE FIELD ADDR
;
 DB 83H
 DB 'CF'
 DB 'A'+80H
 DW LFA-6
CFA: DW DOCOL
 DW TWO
 DW SUBB
 DW SEMIS
;
; NFA-NAME FIELD ADDR
;
 DB 83H
 DB 'NF'
 DB 'A'+80H
 DW CFA-6
NFA: DW DOCOL
 DW LIT
 DW 5
 DW SUBB
 DW LIT
 DW -1
 DW TRAV
 DW SEMIS
;
; PFA-PARAMETER FLD ADDR
;
 DB 83H
 DB 'PF'
 DB 'A'+80H
 DW NFA-6
PFA: DW DOCOL
 DW ONE
 DW TRAV
 DW LIT
 DW 5
 DW PLUS
 DW SEMIS
;
; !CSP
;
 DB 84H
 DB '!CS'
 DB 'P'+80H
 DW PFA-6
SCSP: DW DOCOL
 DW SPAT
 DW CSP
 DW STORE
 DW SEMIS
;
; ?ERROR
;
 DB 86H
 DB '?ERRO'
 DB 'R'+80H
 DW SCSP-7
QERR: DW DOCOL
 DW SWAP
 DW ZBRAN
 DW QERR1-$
 DW ERROR
 DW BRAN
 DW QERR2-$
QERR1: DW DROP
QERR2: DW SEMIS
;
; ?COMP
;
 DB 85H
 DB '?COM'
 DB 'P'+80H
 DW QERR-9
QCOMP: DW DOCOL
 DW STATE
 DW AT
 DW ZEQU
 DW LIT
 DW 11H
 DW QERR
 DW SEMIS
;
; ?EXEC
;
 DB 85H
 DB '?EXE'
 DB 'C'+80H
 DW QCOMP-8
QEXEC: DW DOCOL
 DW STATE
 DW AT
 DW LIT
 DW 12H
 DW QERR
 DW SEMIS
;
; ?PAIRS
;
 DB 86H
 DB '?PAIR'
 DB 'S'+80H
 DW QEXEC-8
QPAIR: DW DOCOL
 DW SUBB
 DW LIT
 DW 13H
 DW QERR
 DW SEMIS
;
; ?CSP
;
 DB 84H
 DB '?CS'
 DB 'P'+80H
 DW QPAIR-9
QCSP: DW DOCOL
 DW SPAT
 DW CSP
 DW AT
 DW SUBB
 DW LIT
 DW 14H
 DW QERR
 DW SEMIS
;
; ?LOADING
;
 DB 88H
 DB '?LOADIN'
 DB 'G'+80H
 DW QCSP-7
QLOAD: DW DOCOL
 DW BLK
 DW AT
 DW ZEQU
 DW LIT
 DW 16H
 DW QERR
 DW SEMIS
;
; COMPILE
;
 DB 87H
 DB 'COMPIL'
 DB 'E'+80H
 DW QLOAD-0BH
COMP: DW DOCOL
 DW QCOMP
 DW FROMR
 DW DUP
 DW TWOP
 DW TOR
 DW AT
 DW COMMA
 DW SEMIS
;
; 'LEFT SQR BRACKET'
;
 DB 0C1H
 DB 0DBH
 DW COMP-0AH
LBRAC: DW DOCOL
 DW ZERO
 DW STATE
 DW STORE
 DW SEMIS
;
; 'RIGHT SQR BRACKET'
;
 DB 81H
 DB 0DDH
 DW LBRAC-4
RBRAC: DW DOCOL
 DW LIT
 DW 0C0H
 DW STATE
 DW STORE
 DW SEMIS
;
; SMUDGE
;
 DB 86H
 DB 'SMUDG'
 DB 'E'+80H
 DW RBRAC-4
SMUDG: DW DOCOL
 DW LATES
 DW LIT
 DW 20H
 DW TOGGL
 DW SEMIS
;
; HEX
;
 DB 83H
 DB 'HE'
 DB 'X'+80H
 DW SMUDG-9
HEX: DW DOCOL
 DW LIT
 DW 10H
 DW BASE
 DW STORE
 DW SEMIS
;
; DECIMAL
;
 DB 87H
 DB 'DECIMA'
 DB 'L'+80H
 DW HEX-6
DEC: DW DOCOL
 DW LIT
 DW 0AH
 DW BASE
 DW STORE
 DW SEMIS
;
; ( CODE)
;
 DB 87H
 DB '( CODE'
 DB ')'+80H
 DW DEC-0AH
PSCOD: DW DOCOL
 DW FROMR
 DW LATES
 DW PFA
 DW CFA
 DW STORE
 DW SEMIS
;
; CODE
;
 DB 0C5H
 DB ' COD'
 DB 'E'+80H
 DW PSCOD-0AH
SEMIC: DW DOCOL
 DW QCSP
 DW COMP
 DW PSCOD
 DW LBRAC
 DW NOOP
 DW SEMIS
;
; <BUILDS
;
 DB 87H
 DB '<BUILD'
 DB 'S'+80H
 DW SEMIC-8
BUILD: DW DOCOL
 DW ZERO
 DW CON
 DW SEMIS
;
; DOES>
;
 DB 85H
 DB 'DOES'
 DB '>'+80H
 DW BUILD-0AH
DOES: DW DOCOL
 DW FROMR
 DW LATES
 DW PFA
 DW STORE
 DW PSCOD
DODOE: LHLD RPP
 DCX H
 MOV M,B
 DCX H
 MOV M,C
 SHLD RPP
 INX D
 XCHG
 MOV C,M
 INX H
 MOV B,M
 INX H
 JMP HPUSH
;
; COUNT
;
 DB 85H
 DB 'COUN'
 DB 'T'+80H
 DW DOES-8
COUNT: DW DOCOL
 DW DUP
 DW ONEP
 DW SWAP
 DW CAT
 DW SEMIS
;
; TYPE
;
 DB 84H
 DB 'TYP'
 DB 'E'+80H
 DW COUNT-8
TYPE: DW DOCOL
 DW DDUP
 DW ZBRAN
 DW TYPE1-$
 DW OVER
 DW PLUS
 DW SWAP
 DW XDO
TYPE2: DW IDO
 DW CAT
 DW EMIT
 DW XLOOP
 DW TYPE2-$
 DW BRAN
 DW TYPE3-$
TYPE1: DW DROP
TYPE3: DW SEMIS
;
; -TRAILING
;
 DB 89H
 DB '-TRAILIN'
 DB 'G'+80H
 DW TYPE-7
DTRAI: DW DOCOL
 DW DUP
 DW ZERO
 DW XDO
DTRA1: DW OVER
 DW OVER
 DW PLUS
 DW ONE
 DW SUBB
 DW CAT
 DW BL
 DW SUBB
 DW ZBRAN
 DW DTRA2-$
 DW LEAVE
 DW BRAN
 DW DTRA3-$
DTRA2: DW ONE
 DW SUBB
DTRA3: DW XLOOP
 DW DTRA1-$
 DW SEMIS
;
; (.")
;
 DB 84H
 DB '(."'
 DB ')'+80H
 DW DTRAI-0CH
PDOTQ: DW DOCOL
 DW RR
 DW COUNT
 DW DUP
 DW ONEP
 DW FROMR
 DW PLUS
 DW TOR
 DW TYPE
 DW SEMIS
;
; ."
;
 DB 0C2H
 DB '.'
 DB '"'+80H
 DW PDOTQ-7
DOTQ: DW DOCOL
 DW LIT
 DW 22H
 DW STATE
 DW AT
 DW ZBRAN
 DW DOTQ1-$
 DW COMP
 DW PDOTQ
 DW WORD
 DW HERE
 DW CAT
 DW ONEP
 DW ALLOT
 DW BRAN
 DW DOTQ2-$
DOTQ1: DW WORD
 DW HERE
 DW COUNT
 DW TYPE
DOTQ2: DW SEMIS
;
; EXPECT
;
 DB 86H
 DB 'EXPEC'
 DB 'T'+80H
 DW DOTQ-5
EXPEC: DW DOCOL
 DW OVER
 DW PLUS
 DW OVER
 DW XDO
EXPE1: DW KEY
 DW DUP
 DW LIT
 DW 0EH
 DW PORIG
 DW AT
 DW EQUAL
 DW ZBRAN
 DW EXPE2-$
 DW DROP
 DW DUP
 DW IDO
 DW EQUAL
 DW DUP
 DW FROMR
 DW TWO
 DW SUBB
 DW PLUS
 DW TOR
 DW ZBRAN
 DW EXPE6-$
 DW LIT
 DW BELL
 DW BRAN
 DW EXPE7-$
EXPE6: DW LIT
 DW BSOUT
EXPE7: DW BRAN
 DW EXPE3-$
EXPE2: DW DUP
 DW LIT
 DW 0DH
 DW EQUAL
 DW ZBRAN
 DW EXPE4-$
 DW LEAVE
 DW DROP
 DW BL
 DW ZERO
 DW BRAN
 DW EXPE5-$
EXPE4: DW DUP
EXPE5: DW IDO
 DW CSTOR
 DW ZERO
 DW IDO
 DW ONEP
 DW STORE
EXPE3: DW EMIT
 DW XLOOP
 DW EXPE1-$
 DW DROP
 DW SEMIS
;
; QUERY
;
 DB 85H
 DB 'QUER'
 DB 'Y'+80H
 DW EXPEC-9
QUERY: DW DOCOL
 DW TIB
 DW AT
 DW LIT
 DW 50H
 DW EXPEC
 DW ZERO
 DW INN
 DW STORE
 DW SEMIS
;
; 0 (NULL)
;
 DB 0C1H
 DB 80H
 DW QUERY-8
NULL: DW DOCOL
 DW FROMR
 DW DROP
 DW SEMIS
;
; FILL
;
 DB 84H
 DB 'FIL'
 DB 'L'+80H
 DW NULL-4
FILL: DW $+2
 MOV L,C
 MOV H,B
 POP D
 POP B
 XTHL
 XCHG
FILL1: MOV A,B
 ORA C
 JZ FILL2
 MOV A,L
 STAX D
 INX D
 DCX B
 JMP FILL1
FILL2: POP B
 JMP NEXT
;
; ERASE
;
 DB 85H
 DB 'ERAS'
 DB 'E'+80H
 DW FILL-7
ERASEE: DW DOCOL
 DW ZERO
 DW FILL
 DW SEMIS
;
; BLANKS
;
 DB 86H
 DB 'BLANK'
 DB 'S'+80H
 DW ERASEE-8
BLANK: DW DOCOL
 DW BL
 DW FILL
 DW SEMIS
;
; HOLD
;
 DB 84H
 DB 'HOL'
 DB 'D'+80H
 DW BLANK-9
HOLD: DW DOCOL
 DW LIT
 DW -1
 DW HLD
 DW PSTOR
 DW HLD
 DW AT
 DW CSTOR
 DW SEMIS
;
; PAD
;
 DB 83H
 DB 'PA'
 DB 'D'+80H
 DW HOLD-7
PAD: DW DOCOL
 DW HERE
 DW LIT
 DW 44H
 DW PLUS
 DW SEMIS
;
; WORD
;
 DB 84H
 DB 'WOR'
 DB 'D'+80H
 DW PAD-6
WORD: DW DOCOL
 DW TIB
 DW AT
 DW INN
 DW AT
 DW PLUS
 DW SWAP
 DW ENCL
 DW HERE
 DW LIT
 DW 22H
 DW BLANK
 DW INN
 DW PSTOR
 DW OVER
 DW SUBB
 DW TOR
 DW RR
 DW HERE
 DW CSTOR
 DW PLUS
 DW HERE
 DW ONEP
 DW FROMR
 DW CMOVE
 DW SEMIS
;
; (NUMBER)
;
 DB 88H
 DB '(NUMBER'
 DB ')'+80H
 DW WORD-7
PNUMB: DW DOCOL
PNUM1: DW ONEP
 DW DUP
 DW TOR
 DW CAT
 DW BASE
 DW AT
 DW DIGIT
 DW ZBRAN
 DW PNUM2-$
 DW SWAP
 DW BASE
 DW AT
 DW USTAR
 DW DROP
 DW ROT
 DW BASE
 DW AT
 DW USTAR
 DW DPLUS DW DPL
 DW AT
 DW ONEP
 DW ZBRAN
 DW PNUM3-$
 DW ONE
 DW DPL
 DW PSTOR
PNUM3: DW FROMR
 DW BRAN
 DW PNUM1-$
PNUM2: DW FROMR
 DW SEMIS
;
; NUMBER
;
 DB 86H
 DB 'NUMBE'
 DB 'R'+80H
 DW PNUMB-0BH
NUMB: DW DOCOL
 DW ZERO
 DW ZERO
 DW ROT
 DW DUP
 DW ONEP
 DW CAT
 DW LIT
 DW 2DH
 DW EQUAL
 DW DUP
 DW TOR
 DW PLUS
 DW LIT
 DW -1
NUMB1: DW DPL
 DW STORE
 DW PNUMB
 DW DUP
 DW CAT
 DW BL
 DW SUBB
 DW ZBRAN
 DW NUMB2-$
 DW DUP
 DW CAT
 DW LIT
 DW 2EH
 DW SUBB
 DW ZERO
 DW QERR
 DW ZERO
 DW BRAN
 DW NUMB1-$
NUMB2: DW DROP
 DW FROMR
 DW ZBRAN
 DW NUMB3-$
 DW DMINU
NUMB3: DW SEMIS
;
; -FIND (0-3) SUCCESS (0
;
 DB 85H
 DB '-FIN'
 DB 'D'+80H
 DW NUMB-9
DFIND: DW DOCOL
 DW BL
 DW WORD
 DW HERE
 DW CONT
 DW AT
 DW AT
 DW PFIND
 DW DUP
 DW ZEQU
 DW ZBRAN
 DW DFIN1-$
 DW DROP
 DW HERE
 DW LATES
 DW PFIND
DFIN1: DW SEMIS
;
; (ABORT)
;
 DB 87H
 DB '(ABORT'
 DB ')'+80H
 DW DFIND-8
PABOR: DW DOCOL
 DW ABORT
 DW SEMIS
;
; ERROR
;
 DB 85H
 DB 'ERRO'
 DB 'R'+80H
 DW PABOR-0AH
ERROR: DW DOCOL
 DW WARN
 DW AT
 DW ZLESS
 DW ZBRAN
 DW ERRO1-$
 DW PABOR
ERRO1: DW HERE
 DW COUNT
 DW TYPE
 DW PDOTQ
 DB 2
 DB '? '
 DW MESS
 DW SPSTO
;
; CHANGE FROM FIG MODEL
; DW IN,AT,BLK,AT
;
 DW BLK,AT
 DW DDUP
 DW ZBRAN
 DW ERRO2-$
 DW INN,AT
 DW SWAP
ERRO2: DW QUIT
;
; ID.
;
 DB 83H
 DB 'ID'
 DB '.'+80H
 DW ERROR-8
IDDOT: DW DOCOL
 DW PAD
 DW LIT
 DW 20H
 DW LIT
 DW 5FH
 DW FILL
 DW DUP
 DW PFA
 DW LFA
 DW OVER
 DW SUBB
 DW PAD
 DW SWAP
 DW CMOVE
 DW PAD
 DW COUNT
 DW LIT
 DW 1FH
 DW ANDD
 DW TYPE
 DW SPACE
 DW SEMIS
;
; CREATE
;
 DB 86H
 DB 'CREAT'
 DB 'E'+80H
 DW IDDOT-6
CREAT: DW DOCOL
 DW DFIND
 DW ZBRAN
 DW CREA1-$
 DW DROP
 DW NFA
 DW IDDOT
 DW LIT
 DW 4
 DW MESS
 DW SPACE
CREA1: DW HERE
 DW DUP
 DW CAT
 DW WIDTH
 DW AT
 DW MIN
 DW ONEP
 DW ALLOT
 DW DUP
 DW LIT
 DW 0A0H
 DW TOGGL
 DW HERE
 DW ONE
 DW SUBB
 DW LIT
 DW 80H
 DW TOGGL
 DW LATES
 DW COMMA
 DW CURR
 DW AT
 DW STORE
 DW HERE
 DW TWOP
 DW COMMA
 DW SEMIS
;
; LSB[COMPILE]RSB
;
 DB 0C9H
 DB 5BH
 DB 'COMPILE'
 DB 0DDH
 DW CREAT-9
BCOMP: DW DOCOL
 DW DFIND
 DW ZEQU
 DW ZERO
 DW QERR
 DW DROP
 DW CFA
 DW COMMA
 DW SEMIS
;
; LITERAL
;
 DB 0C7H
 DB 'LITERA'
 DB 'L'+80H
 DW BCOMP-0CH
LITER: DW DOCOL
 DW STATE
 DW AT
 DW ZBRAN
 DW LITE1-$
 DW COMP
 DW LIT
 DW COMMA
LITE1: DW SEMIS
;
; DLITERAL
;
 DB 0C8H
 DB 'DLITERA'
 DB 'L'+80H
 DW LITER-0AH
DLITE: DW DOCOL
 DW STATE
 DW AT
 DW ZBRAN
 DW DLIT1-$
 DW SWAP
 DW LITER
 DW LItER
DLIT1: DW SEMIS
;
; ?STACK
;
 DB 86H
 DB '?STAC'
 DB 'K'+80H
 DW DLITE-0BH
QSTAC: DW DOCOL
 DW SPAT
 DW SZERO
 DW AT
 DW SWAP
 DW ULESS
 DW ONE
 DW QERR
 DW SPAT
 DW HERE
 DW LIT
 DW 80H
 DW PLUS
 DW ULESS
 DW LIT
 DW 7
 DW QERR
 DW SEMIS
;
; INTERPRET
;
 DB 89H
 DB 'INTERPRE'
 DB 'T'+80H
 DW QSTAC-9
INTER: DW DOCOL
INTE1: DW DFIND
 DW ZBRAN
 DW INTE2-$
 DW STATE
 DW AT
 DW LESS
 DW ZBRAN
 DW INTE3-$
 DW CFA
 DW COMMA
 DW BRAN
 DW INTE4-$
INTE3: DW CFA
 DW EXEC
INTE4: DW QSTAC
 DW BRAN
 DW INTE5-$
INTE2: DW HERE
 DW NUMB
 DW DPL
 DW AT
 DW ONEP
 DW ZBRAN
 DW INTE6-$
 DW DLITE
 DW BRAN
 DW INTE7-$
INTE6: DW DROP
 DW LITER
INTE7: DW QSTAC
INTE5: DW BRAN
 DW INTE1-$
;
; IMMEDIATE
;
 DB 89H
 DB 'IMMEDIAT'
 DB 'E'+80H
 DW INTER-0CH
IMMED: DW DOCOL
 DW LATES
 DW LIT
 DW 40H
 DW TOGGL
 DW SEMIS
;
; VOCABULARY
;
 DB 8AH
 DB 'VOCABULAR'
 DB 'Y'+80H
 DW IMMED-0CH
VOCAB: DW DOCOL
 DW BUILD
 DW LIT
 DW 0A081H
 DW COMMA
 DW CURR
 DW AT
 DW CFA
 DW COMMA
 DW HERE
 DW VOCL
 DW AT
 DW COMMA
 DW VOCL
 DW STORE
 DW DOES
DOVOC: DW TWOP
 DW CONT
 DW STORE
 DW SEMIS
;
; FORTH
;
 DB 0C5H
 DB 'FORT'
 DB 'H'+80H
 DW VOCAB-0DH
FORTH: DW DODOE
 DW DOVOC
 DW 0A081H
 DW TASK-7
 DW 0
;
; DEFINITIONS
;
 DB 8BH
 DB 'DEFINITION'
 DB 'S'+80H
 DW FORTH-8
DEFIN: DW DOCOL
 DW CONT
 DW AT
 DW CURR
 DW STORE
 DW SEMIS
;
; (
;
 DB 0C1H
 DB '('+80H
 DW DEFIN-0EH
PAREN: DW DOCOL
 DW LIT
 DW 29H
 DW WORD
 DW SEMIS
;
; QUIT
;
 DB 84H
 DB 'QUI'
 DB 'T'+80H
 DW PAREN-4
QUIT: DW DOCOL
 DW ZERO
 DW BLK
 DW STORE
 DW LBRAC
QUIT1: DW RPSTO
 DW CR
 DW QUERY
 DW INTER
 DW STATE
 DW AT
 DW ZEQU
 DW ZBRAN
 DW QUIT2-$
 DW PDOTQ
 DB 2
 DB 'OK'
QUIT2: DW BRAN
 DW QUIT1-$
;
; ABORT
;
 DB 85H
 DB 'ABOR'
 DB 'T'+80H
 DW QUIT-7
ABORT: DW DOCOL
 DW SPSTO
 DW DEC
 DW QSTAC
 DW CR
 DW PDOTQ
 DB 0EH
;
 DB 'DMF FORTH '
 DB FIGREL+30H
 DB ADOT
 DB FIGREV+30H
 DB USRVER+30H
;
 DW FORTH
 DW DEFIN
 DW QUIT
 
WRM: LXI B,WRM1
 JMP NEXT
WRM1: DW WARM
;
; WARM
;
 DB 84H
 DB 'WAR'
 DB 'M'+80H
 DW ABORT-8
WARM: DW DOCOL
 DW ABORT
;
CLD: LXI B,CLD1
 LHLD ORIG+12H
 SPHL
 JMP NEXT
CLD1: DW COLD
;
; COLD
;
 DB 84H
 DB 'COL'
 DB 'D'+80H
 DW WARM-7
COLD: DW DOCOL
 DW LIT
 DW ORIG+12H
 DW LIT
 DW UP
 DW AT
 DW LIT
 DW 6
 DW PLUS
 DW LIT
 DW 10H
 DW CMOVE
 DW LIT
 DW ORIG+0CH
 DW AT
 DW LIT
 DW FORTH+6
 DW STORE
 DW ABORT
;
; S->D
;
 DB 84H
 DB 'S->'
 DB 'D'+80H
 DW COLD-7
STOD: DW $+2
 POP D
 LXI H,0
 MOV A,D
 ANI 80H
 JZ STOD1
 DCX H
STOD1: JMP DPUSH
;
; +-
;
 DB 82H
 DB '+'
 DB '-'+80H
 DW STOD-7
PM: DW DOCOL
 DW ZLESS
 DW ZBRAN
 DW PM1-$
 DW MINUS
PM1: DW SEMIS
;
; D+-
;
 DB 83H
 DB 'D+'
 DB '-'+80H
 DW PM-5
DPM: DW DOCOLV
 DW ZLESS
 DW ZBRAN
 DW DPM1-$
 DW DMINU
DPM1: DW SEMIS
;
; ABS
;
 DB 83H
 DB 'AB'
 DB 'S'+80H
 DW DPM-6
ABS: DW DOCOL
 DW DUP
 DW PM
 DW SEMIS
;
; DABS
;
 DB 84H
 DB 'DAB'
 DB 'S'+80H
 DW ABS-6
DABS: DW DOCOL
 DW DUP
 DW DPM
 DW SEMIS
;
; MIN
;
 DB 83H
 DB 'MI'
 DB 'N'+80H
 DW DABS-7
MIN: DW DOCOL,TDUP
 DW GREAT
 DW ZBRAN
 DW MIN1-$
 DW SWAP
MIN1: DW DROP
 DW SEMIS
;
; MAX
;
 DB 83H
 DB 'MA'
 DB 'X'+80H
 DW MIN-6
MAX: DW DOCOL,TDUP
 DW LESS
 DW ZBRAN
 DW MAX1-$
 DW SWAP
MAX1: DW DROP
 DW SEMIS
;
; M*
;
 DB 82H
 DB 'M'
 DB '*'+80H
 DW MAX-6
MSTAR: DW DOCOL,TDUP
 DW XORR
 DW TOR
 DW ABS
 DW SWAP
 DW ABS
 DW USTAR
 DW FROMR
 DW DPM
 DW SEMIS
;
; M/
;
 DB 82H
 DB 'M'
 DB '/'+80H
 DW MSTAR-5
MSLAS: DW DOCOL
 DW OVER
 DW TOR
 DW TOR
 DW DABS
 DW RR
 DW ABS
 DW USLAS
 DW FROMR
 DW RR
 DW XORR
 DW PM
 DW SWAP
 DW FROMR
 DW PM
 DW SWAP
 DW SEMIS
;
; *
;
 DB 81H
 DB '*'+80H
 DW MSLAS-5
STAR: DW DOCOL
 DW MSTAR
 DW DROP
 DW SEMIS
;
; /MOD
;
 DB 84H
 DB '/MO'
 DB 'D'+80H
 DW STAR-4
SLMOD: DW DOCOL
 DW TOR
 DW STOD
 DW FROMR
 DW MSLAS
 DW SEMIS
;
; /
;
 DB 81H
 DB '/'+80H
 DW SLMOD-7
SLASH: DW DOCOL
 DW SLMOD
 DW SWAP
 DW DROP
 DW SEMIS
;
; MOD FUNCTION
;
 DB 83H
 DB 'MO'
 DB 'D'+80H
 DW SLASH-4
MODFN: DW DOCOL
 DW SLMOD
 DW DROP
 DW SEMIS
;
; */MOD
;
 DB 85H
 DB '*/MO'
 DB 'D'+80H
 DW MODFN-6
SSMOD: DW DOCOL
 DW TOR
 DW MSTAR
 DW FROMR
 DW MSLAS
 DW SEMIS
;
; */
;
 DB 82H
 DB '*'
 DB '/'+80H
 DW SSMOD-8
SSLA: DW DOCOL
 DW SSMOD
 DW SWAP
 DW DROP
 DW SEMIS
;
; M/MOD
;
 DB 85H
 DB 'M/MO'
 DB 'D'+80H
 DW SSLA-5
MSMOD: DW DOCOL
 DW TOR
 DW ZERO
 DW RR
 DW USLAS
 DW FROMR
 DW SWAP
 DW TOR
 DW USLAS
 DW FROMR
 DW SEMIS
;
; MESSAGE
;
 DB 87H
 DB 'MESSAG'
 DB 'E'+80H
 DW MSMOD-8
MESS: DW $+2
 JMP PMSG
;
; 8080 PORT FETCH AND STORE
; ( SELF MODIFYING CODE, NOT
;
; P@
;
 DB 82H
 DB 'P'
 DB '@'+80H
 DW MESS-0AH
PTAT: DW $+2
 POP D
 LXI H,$+5
 MOV M,E
 IN 0
 MOV L,A
 MVI H,0
 JMP HPUSH
;
; P!
;
 DB 82H
 DB 'P'
 DB '!'+80H
 DW PTAT-5
PTSTO: DW $+2
 POP D
 LXI H,$+7
 MOV M,E
 POP H
 MOV A,L
 OUT 0
 JMP NEXT
;
; '
;
 DB 0C1H
 DB 0A7H
 DW PTSTO-5
TICK: DW DOCOL
 DW DFIND
 DW ZEQU
 DW ZERO
 DW QERR
 DW DROP
 DW LITER
 DW SEMIS
;
; FORGET
;
 DB 86H
 DB 'FORGE'
 DB 'T'+80H
 DW TICK-4
FORG: DW DOCOL
 DW CURR
 DW AT
 DW CONT
 DW AT
 DW SUBB
 DW LIT
 DW 18H
 DW QERR
 DW TICK
 DW DUP
 DW FENCE
 DW AT
 DW LESS
 DW LIT
 DW 15H
 DW QERR
 DW DUP
 DW NFA
 DW DP
 DW STORE
 DW LFA
 DW AT
 DW CONT
 DW AT
 DW STORE
 DW SEMIS
;
; BACK
;
 DB 84H
 DB 'BAC'
 DB 'K'+80H
 DW FORG-9
BACK: DW DOCOL
 DW HERE
 DW SUBB
 DW COMMA
 DW SEMIS
;
; BEGIN
;
 DB 0C5H
 DB 'BEGI'
 DB 'N'+80H
 DW BACK-7
BEGIN: DW DOCOL
 DW QCOMP
 DW HERE
 DW ONE
 DW SEMIS
;
; ENDIF
;
 DB 0C5H
 DB 'ENDI'
 DB 'F'+80H
 DW BEGIN-8
ENDIFF: DW DOCOL
 DW QCOMP
 DW TWO
 DW QPAIR
 DW HERE
 DW OVER
 DW SUBB
 DW SWAP
 DW STORE
 DW SEMIS
;
; THEN
;
 DB 0C4H
 DB 'THE'
 DB 'N'+80H
 DW ENDIFF-8
THEN: DW DOCOL
 DW ENDIFF
 DW SEMIS
;
; DO
;
 DB 0C2H
 DB 'D'
 DB 'O'+80H
 DW THEN-7
DO: DW DOCOL
 DW COMP
 DW XDO
 DW HERE
 DW THREE
 DW SEMIS
;
; LOOP
;
 DB 0C4H
 DB 'LOO'
 DB 'P'+80H
 DW DO-5
LOOP: DW DOCOL
 DW THREE
 DW QPAIR
 DW COMP
 DW XLOOP
 DW BACK
 DW SEMIS
;
; +LOOP
;
 DB 0C5H
 DB '+LOO'
 DB 'P'+80H
 DW LOOP-7
PLOOP: DW DOCOL
 DW THREE
 DW QPAIR
 DW COMP
 DW XPLOO
 DW BACK
 DW SEMIS
;
; UNTIL
;
 DB 0C5H
 DB 'UNTI'
 DB 'L'+80H
 DW PLOOP-8
UNTIL: DW DOCOL
 DW ONE
 DW QPAIR
 DW COMP
 DW ZBRAN
 DW BACK
 DW SEMIS
;
; END
;
 DB 0C3H
 DB 'EN'
 DB 'D'+80H
 DW UNTIL-8
ENDD: DW DOCOL
 DW UNTIL
 DW SEMIS
;
; AGAIN
;
 DB 0C5H
 DB 'AGAI'
 DB 'N'+80H
 DW ENDD-6
AGAIN: DW DOCOL
 DW ONE
 DW QPAIR
 DW COMP
 DW BRAN
 DW BACK
 DW SEMIS
;
; REPEAT
;
 DB 0C6H
 DB 'REPEA'
 DB 'T'+80H
 DW AGAIN-8
REPEA: DW DOCOL
 DW TOR
 DW TOR
 DW AGAIN
 DW FROMR
 DW FROMR
 DW TWO
 DW SUBB
 DW ENDIFF
 DW SEMIS
;
; IF
;
 DB 0C2H
 DB 'I'
 DB 'F'+80H
 DW REPEA-9
IFF: DW DOCOL
 DW COMP
 DW ZBRAN
 DW HERE
 DW ZERO
 DW COMMA
 DW TWO
 DW SEMIS
;
; ELSE
;
 DB 0C4H
 DB 'ELS'
 DB 'E'+80H
 DW IFF-5
ELSEE: DW DOCOL
 DW TWO
 DW QPAIR
 DW COMP
 DW BRAN
 DW HERE
 DW ZERO
 DW COMMA
 DW SWAP
 DW TWO
 DW ENDIFF
 DW TWO
 DW SEMIS
;
; WHILE
;
 DB 0C5H
 DB 'WHIL'
 DB 'E'+80H
 DW ELSEE-7
WHILE: DW DOCOL
 DW IFF
 DW TWOP
 DW SEMIS
;
; SPACES
;
 DB 86H
 DB 'SPACE'
 DB 'S'+80H
 DW WHILE-8
SPACS: DW DOCOL
 DW ZERO
 DW MAX
 DW DDUP
 DW ZBRAN
 DW SPAX1-$
 DW ZERO
 DW XDO
SPAX2: DW SPACE
 DW XLOOP
 DW SPAX2-$
SPAX1: DW SEMIS
;
; <#
;
 DB 82H
 DB '<'
 DB '#'+80H
 DW SPACS-9
BDIGS: DW DOCOL
 DW PAD
 DW HLD
 DW STORE
 DW SEMIS
;
; #>
;
 DB 82H
 DB '#'
 DB '>'+80H
 DW BDIGS-5
EDIGS: DW DOCOL
 DW DROP
 DW DROP
 DW HLD
 DW AT
 DW PAD
 DW OVER
 DW SUBB
 DW SEMIS
;
; SIGN
;
 DB 84H
 DB 'SIG'
 DB 'N'+80H
 DW EDIGS-5
SIGN: DW DOCOL
 DW ROT
 DW ZLESS
 DW ZBRAN
 DW SIGN1-$
 DW LIT
 DW 2DH
 DW HOLD
SIGN1: DW SEMIS
;
; #
;
 DB 81H
 DB '#'+80H
 DW SIGN-7
DIG: DW DOCOL
 DW BASE
 DW AT
 DW MSMOD
 DW ROT
 DW LIT
 DW 9
 DW OVER
 DW LESS
 DW ZBRAN
 DW DIG1-$
 DW LIT
 DW 7
 DW PLUS
DIG1: DW LIT
 DW 30H
 DW PLUS
 DW HOLD
 DW SEMIS
;
; #S
;
 DB 82H
 DB '#'
 DB 'S'+80H
 DW DIG-4
DIGS: DW DOCOL
DIGS1: DW DIG
 DW OVER
 DW OVER
 DW ORR
 DW ZEQU
 DW ZBRAN
 DW DIGS1-$
 DW SEMIS
;
; D.R
;
 DB 83H
 DB 'D.'
 DB 'R'+80H
 DW DIGS-5
DDOTR: DW DOCOL
 DW TOR
 DW SWAP
 DW OVER
 DW DABS
 DW BDIGS
 DW DIGS
 DW SIGN
 DW EDIGS
 DW FROMR
 DW OVER
 DW SUBB
 DW SPACS
 DW TYPE
 DW SEMIS
;
; .R
;
 DB 82H
 DB '.'
 DB 'R'+80H
 DW DDOTR-6
DOTR: DW DOCOL
 DW TOR
 DW STOD
 DW FROMR
 DW DDOTR
 DW SEMIS
;
; D.
;
 DB 82H
 DB 'D'
 DB '.'+80H
 DW DOTR-5
DDOT: DW DOCOL
 DW ZERO
 DW DDOTR
 DW SPACE
 DW SEMIS
;
; .
;
 DB 81H
 DB '.'+80H
 DW DDOT-5
DOT: DW DOCOL
 DW STOD
 DW DDOT
 DW SEMIS
;
; ?
;
 DB 81H
 DB '?'+80H
 DW DOT-4
QUES: DW DOCOL
 DW AT
 DW DOT
 DW SEMIS
;
; U.
;
 DB 82H
 DB 'U'
 DB '.'+80H
 DW QUES-4
UDOT: DW DOCOL
 DW ZERO
 DW DDOT
 DW SEMIS
;
; VLIST
;
 DB 85H
 DB 'VLIS'
 DB 'T'+80H
 DW UDOT-5
VLIST: DW DOCOL
 DW LIT
 DW 80H
 DW OUTT
 DW STORE
 DW CONT
 DW AT
 DW AT
VLIS1: DW OUTT
 DW AT
 DW CSLL
 DW GREAT
 DW ZBRAN
 DW VLIS2-$
 DW CR
 DW ZERO
 DW OUTT
 DW STORE
VLIS2: DW DUP
 DW IDDOT
 DW SPACE
 DW SPACE
 DW PFA
 DW LFA
 DW AT
 DW DUP
 DW ZEQU
 DW QTERM
 DW ORR
 DW ZBRAN
 DW VLIS1-$
 DW DROP
 DW SEMIS
;
; BYE
;
 DB 83H
 DB 'BY'
 DB 'E'+80H
 DW VLIST-8
BYE: DW $+2
 JMP PEXIT
;
; TASK
;
 DB 84H
 DB 'TAS'
 DB 'K'+80H
 DW BYE-6
TASK: DW DOCOL
 DW SEMIS
;
; TERMINAL ROUTINES
;
PQTER: CALL XRTN
 JMP HPUSH
;
PEMIT: DW $+2
 CALL XRTN+3
 JMP NEXT
;
PKEY: CALL XRTN+6
 JMP HPUSH
;
PCR: CALL XRTN+9
 JMP NEXT
;
PMSG: CALL XRTN+12
 JMP NEXT
;
PMSG: JMP XRTN+15
;
INITDP EQU $
 END

NSOLE STATUS
#2220  RLC ;ROTATE BUSY STATUS BIT
"2230  JC ECON ;IF BUSY THEN LOOP
'2240  MOV A,B ;LOAD BYTE FOR PRINTING
%2250  OUT 01H ;ECHO BYTE ON CONSOLE
2260  RET ;RETURN
2270 *
*2280 *  RECEIVE BYTE AND TEST FOR CNTL-C
2290 *
%2300 RXCC IN STAT ;GET MODEM STATUS
 2310  ANI 01H ;ISOLATE RRF BIT
$2320  JZ NIL ;JUMP IF NO CHARACTER
$2330  IN DATA ;GET BYTE FROM MODEM
2340  ANI 7FH ;KILL PARITY
 2350  CPI 03H ;TEST FOR CNTL-C
2360  RET ;RETURN
!2370 NIL MVI A,01H ;SET NZ FLAG
2380  RET ;RETURN
2390 *
!2400 *  CONSOLE & USER MESSAGES
2410 *
2420 SMESS DW 1A1EH
2430  DW 0A07H
'2440  ASC 'FREDERICTON CBBS ON-LINE:'
2450  DW 0A0DH
2460  DW 0A0DH
2470  DB 0FFH
'2480 CTMES ASC '  NUMBER OF CALLS = '
2490 CNTL DB 30H
2500 CNTH DB 30H
2510  DW 0A0DH
2520  DW 0A0DH
2530  DB 0FFH
!2540 RDMES ASC 'RING DETECTED.'
2550  DW 0A0DH
2560  DB 0FFH
+2570 NAMES ASC 'NO ANSWER TO TX CARRIER.'
2580  DW 0A0DH
2590  DB 0FFH
92600 AMES ASC 'REMOTE MICROCOMPUTER SYSTEM ON-LINE ...'
2610  DW 0A0DH
2620  DW 0A0DH
2630  DB 0FFH
 2640 LCMES ASC 'LOST CARRIER.'
2650  DW 0A0DH
2660  DB 0FFH
$2670 CRMES ASC 'CARRIER RECEIVED.'
2680  DW 0A0DH
2690  DB 0FFH
 2700 DCMES ASC 'DISCONNECTED.'
2710  DW 0A0DH
2720  DW 0A0DH
2730  DB 0FFH
-2740 TMESS ASC 'TIMEOUT DURING ANSWERBACK.'
2750  DW 0A0DH
2760  DW 0A0DH
2770  DB 0FFH
)2780 RMESS ASC '  WAITING FOR CALL ...'
2790  DW 0A0DH
2800  DW 0A0DH
2810  DB 0FFH
2820 *
2830 *  DYNAMIC STORAGE AREA
2840 *
2850 DOUT DW 0000H
2860 DIN DW 0000H
2870 DCC DW 0000H
2880 STATS DB 00H
2890  END ;END OF SOURCE
E
OF SOURCE
BBS ON-LINE:'
2890  DW 0A0DH
2900  DW 0A0DH
2910  DB 0FFH
'2920 CTMES ASC '  NUMBER OF CALLS = '
2930 CNTL DB 30H
2940 CNTH DB 30H
2950  DW 0A0DH
2960  DW 0A0DH
2970  DB 0FFH
!2980 RDMES ASC 'RING DETECTED.'
2990  DW 0A0DH
3000  DB 0FFH
.3010 NAMES ASC 'NO ANSWER TO TX CARRIER ...'
3020  DW 0A0DH
3030  DB 0FFH
93040 AMES ASC 'REMOTE MICROCOMPUTER SYSTEM ON-LINE ...'
3050  DW 0A0DH
3060  DW 0A0DH
3070  DB 0FFH
 3080 LCMES ASC 'LOST CARRIER.'
3090  DW 0A0DH
3100  DB 0FFH
$3110 CRMES ASC 'CARRIER RECEIVED.'
3120  DW 0A0DH
3130  DB 0FFH
 3140 DCMES ASC 'DISCONNECTED.'
3150  DW 0A0DH
3160  DW 0A0DH
3170  DB 0FFH
-3180 TMESS ASC 'TIMEOUT DURING ANSWERBACK.'
3190  DW 0A0DH
3200  DW 0A0DH
3210  DB 0FFH
)3220 RMESS ASC '  WAITING FOR CALL ...'
3230  DW 0A0DH
3240  DW 0A0DH
3250  DB 0FFH
3260 *
3270 *  DYNAMIC STORAGE AREA
3280 *
3290 DOUT DW 0000H
3300 DIN DW 0000H
3310 DCC DW 0000H
3320 STATS DB 00H
 CALL OFHK ;GO OFF HOOK
$0630  LDA STATS ;LOAD MODEM STATUS
0640  ORI 02H ;SET TXE BIT ON
%0650  STA STATS ;UPDATE STATUS BYTE
!0660  OUT MODE ;TURN ON CARRIER
0670 *
#0680 *  CHECK IF CARRIER RECEIVED
0690 *
/0700  LXI D,0100H ;LOAD D,E WITH DELAY FACTOR
(0710 CHKC: IN STAT ;CHECK MODEM STATUS
0720  ANI 40H ;ISOLATE CD BIT
20730  JNZ CONN ;IF CARRIER RECEIVED THEN CONNECT
0740  CALL DELAY ;CALL DELAY
&0750  DCX D ;DECREMENT REGISTER PAIR
 0760  MOV A,D ;MOVE REG D TO A
"0770  ORA E ;LOGICAL OR A WITH E
&0780  JNZ CHKC ;IF NOT END THEN LOOP
0790 *
0800 *  DISCONNECT
0810 *
:0820 DISC: LXI H,NAMES ;LOAD H,L WITH ADDRESS OF MESSAGE
?0830  CALL PMESS ;PRINT "NO ANSWER TO TX CARRIER ..." MESSAGE
&0840 LC LDA STATS ;LOAD MODEM STATUS
"0850  ANI 0FDH ;TURN OFF TXE BIT
0860  ANI 7FH ;GO ON-HOOK
&0870  STA STATS ;UPDATE MODEM STATUS
0880  OUT MODE ;SET MODEM
50890  LXI H,DCMES ;LOAD H,L WITH ADDRESS OF MESSAGE
10900  CALL PMESS ;PRINT "DISCONNECTED." MESSAGE
!0910  JMP 0E800H ;REBOOT SYSTEM
0920 *
0930 *  CONNECT
0940 *
;0950 CONN: LXI H,CRMESS ;LOAD H,L WITH ADDRESS OF MESSAGE
-0960  CALL PMESS ;PRINT "CARRIER RECEIVED."
*0970 ENT LXI B,0000H ;INITIALIZE COUNTER
&0980 MOD IN STAT ;INPUT MODEM STATUS
 0990  ANI 01H ;ISOLATE RRF BIT
-1000  JNZ TST ;IF CHARACTER THERE THEN TEST
#1010  IN STAT ;INPUT MODEM STATUS
1020  ANI 40H ;ISOLATE CD BIT
)1030  JNZ CNT ;SKIP IF CARRIER STILL ON
51040  LXI H,LCMES ;LOAD H,L WITH ADDRESS OF MESSAGE
11050  CALL PMESS ;PRINT "LOST CARRIER." MESSAGE
1060  JMP LC ;DISCONNECT
#1070 CNT INX B ;INCR                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                