;
; 68HC16 DMS kernel preconfigured for the Motorola EVB16
;
; 68HC16 chip selects:
;	CSBOOT	00000-0FFFF	Pseudo-ROM (Actually RAM on EVB)
;	CS0	10000-1FFFF	LOWER BYTE write enable
;	CS1	10000-1FFFF	UPPER BYTE write enable
;	CS2	10000-1FFFF	RAM CHIP SELECT
;
;**** SIM MODULE REGISTERS *****
SYNCR	EQU	$FA04		;Clock synthesizer control register
SYPCR	EQU	$FA21		;System protection control register
;**** SRAM MODULE REGISTERS *****
RAMMCR	EQU	$FB00		;RAM module configuration register
RAMBAH	EQU	$FB04		;RAM base address HIGH register
RAMBAL	EQU	$FB06		;RAM base address LOW register
;**** CHIP-SELECT REGISTERS *****
CSBARBT	EQU	$FA48		;CSBOOT base address
CSBAR0	EQU	$FA4C		;CS0 base address
CSBAR1	EQU	$FA50		;CS1 base address
CSBAR2	EQU	$FA54		;CS2 base address
CSOR0	EQU	$FA4E		;CS0 option
CSOR1	EQU	$FA52		;CS1 option
CSOR2	EQU	$FA56		;CS2 option
CSPAR0	EQU	$FA44		;CS pin assignment
;**** QSM ADDRESS MAP *****
SCCR0	EQU	$FC08		;SCI control register 0
SCCR1	EQU	$FC0A		;SCI control register 1
SCSR	EQU	$FC0C		;SCI status register
SCDR	EQU	$FC0E		;SCI data register
;***************************************************************************
RAMseg	EQU	$0001		;External RAM segment
RAMbeg	EQU	$FC00		;Beginning of RAM
RAMend	EQU	$FFFF		;End of RAM
STACK	EQU	RAMend-1	;Stack goes here
; Command codes from host to target monitor
CQUERY	EQU	$A0		; Query command
CBREAK	EQU	$A1		; Break command
CEXEC	EQU	$A2		; Execute command
CSTEP	EQU	$A3		; Single-step command
CREADP	EQU	$B0		; Read Program memory
CREADD	EQU	$B1		; Read Data memory
CREADX	EQU	$B2		; Read X memory
CREADY	EQU	$B3		; Read Y memory
CREADZ	EQU	$B4		; Read Z memory
CREADS	EQU	$B5		; Read STACK memory
CWRITEP	EQU	$B8		; Write program memory
CWRITED	EQU	$B9		; Write data memory
CWRITEX	EQU	$BA		; Write X memory
CWRITEY	EQU	$BB		; Write Y memory
CWRITEZ	EQU	$BC		; Write Z memory
CWRITES	EQU	$BD		; Write STACK memory
; Response codes from target monitor to host
RESP1	EQU	$AA		; Query response 1
RESP2	EQU	$55		; Query response 2
BRKF1	EQU	$90		; Break leadin-1
BRKF2	EQU	$A5		; Break leadin-2
BRKF3	EQU	$B9		; Break leadin-3
KID	EQU	$6816		; Kernel ID
;
	ORG	RAMbeg		; Point to RAM
PEXT	RMB	2		; Program memory extension
DEXT	RMB	2		; Data memory extension
XEXT	RMB	2		; X memory extension
YEXT	RMB	2		; Y memory extension
ZEXT	RMB	2		; Z memory extension
SEXT	RMB	2		; Stack memory extension
;
	ORG	$0000		;Code page starts at 0
; Reset vector information
	FDB	$0000		;0   zk=0, sk=0, pk=0
	FDB	start		;1   initial program counter
	FDB	STACK		;2   initial stack pointer
	FDB	$0000		;3   direct page pointer
; Interrupt vectors
	FDB	exit		;4   Breakpoint (BKPT)
	FDB	exit		;5   Bus Error (BERR)
	FDB	exit		;6   Software Interrupt (SWI)
	FDB	exit		;7   Illegal Instruction
	FDB	exit		;8   Divide by Zero
	FDB	exit		;9   (Unassigned Reserved)
	FDB	exit		;10  (Unassigned Reserved)
	FDB	exit		;11  (Unassigned Reserved)
	FDB	exit		;12  (Unassigned Reserved)
	FDB	exit		;13  (Unassigned Reserved)
	FDB	exit		;14  (Unassigned Reserved)
	FDB	exit		;15  Uninitialized Interrupt
	FDB	exit		;16  (Unassigned Reserved)
	FDB	exit		;17  Level 1 Interrupt Autovector
	FDB	exit		;18  Level 2 Interrupt Autovector
	FDB	exit		;19  Level 3 Interrupt Autovector
	FDB	exit		;20  Level 4 Interrupt Autovector
	FDB	exit		;21  Level 5 Interrupt Autovector
	FDB	exit		;22  Level 6 Interrupt Autovector
	FDB	exit		;23  Level 7 Interrupt Autovector
	FDB	exit		;24  Spurious Interrupt
	FDB	exit		;25  (Unassigned Reserved)
	FDB	exit		;26  (Unassigned Reserved)
	FDB	exit		;27  (Unassigned Reserved)
	FDB	exit		;28  (Unassigned Reserved)
	FDB	exit		;29  (Unassigned Reserved)
	FDB	exit		;30  (Unassigned Reserved)
	FDB	exit		;31  (Unassigned Reserved)
	FDB	exit		;32  (Unassigned Reserved)
	FDB	exit		;33  (Unassigned Reserved)
	FDB	exit		;34  (Unassigned Reserved)
	FDB	exit		;35  (Unassigned Reserved)
	FDB	exit		;36  (Unassigned Reserved)
	FDB	exit		;37  (Unassigned Reserved)
	FDB	exit		;38  (Unassigned Reserved)
	FDB	exit		;39  (Unassigned Reserved)
	FDB	exit		;40  (Unassigned Reserved)
	FDB	exit		;41  (Unassigned Reserved)
	FDB	exit		;42  (Unassigned Reserved)
	FDB	exit		;43  (Unassigned Reserved)
	FDB	exit		;44  (Unassigned Reserved)
	FDB	exit		;45  (Unassigned Reserved)
	FDB	exit		;46  (Unassigned Reserved)
	FDB	exit		;47  (Unassigned Reserved)
	FDB	exit		;48  (Unassigned Reserved)
	FDB	exit		;49  (Unassigned Reserved)
	FDB	exit		;50  (Unassigned Reserved)
	FDB	exit		;51  (Unassigned Reserved)
	FDB	exit		;52  (Unassigned Reserved)
	FDB	exit		;53  (Unassigned Reserved)
	FDB	exit		;54  (Unassigned Reserved)
	FDB	exit		;55  (Unassigned Reserved)
	FDB	exit		;56  User Defined Interrupt Vector 1
	FDB	exit		;57  User Defined Interrupt Vector 2
	FDB	exit		;58  User Defined Interrupt Vector 3
	FDB	exit		;59  User Defined Interrupt Vector 4
	FDB	exit		;60  User Defined Interrupt Vector 5
	FDB	exit		;61  User Defined Interrupt Vector 6
	FDB	exit		;62  User Defined Interrupt Vector 7
	FDB	exit		;63  User Defined Interrupt Vector 8
	FDB	exit		;64  User Defined Interrupt Vector 9
	FDB	exit		;65  User Defined Interrupt Vector 10
	FDB	exit		;66  User Defined Interrupt Vector 11
	FDB	exit		;67  User Defined Interrupt Vector 12
	FDB	exit		;68  User Defined Interrupt Vector 13
	FDB	exit		;69  User Defined Interrupt Vector 14
	FDB	exit		;70  User Defined Interrupt Vector 15
	FDB	exit		;71  User Defined Interrupt Vector 16
	FDB	exit		;72  User Defined Interrupt Vector 17
	FDB	exit		;73  User Defined Interrupt Vector 18
	FDB	exit		;74  User Defined Interrupt Vector 19
	FDB	exit		;75  User Defined Interrupt Vector 20
	FDB	exit		;76  User Defined Interrupt Vector 21
	FDB	exit		;77  User Defined Interrupt Vector 22
	FDB	exit		;78  User Defined Interrupt Vector 23
	FDB	exit		;79  User Defined Interrupt Vector 24
	FDB	exit		;80  User Defined Interrupt Vector 25
	FDB	exit		;81  User Defined Interrupt Vector 26
	FDB	exit		;82  User Defined Interrupt Vector 27
	FDB	exit		;83  User Defined Interrupt Vector 28
	FDB	exit		;84  User Defined Interrupt Vector 29
	FDB	exit		;85  User Defined Interrupt Vector 30
	FDB	exit		;86  User Defined Interrupt Vector 31
	FDB	exit		;87  User Defined Interrupt Vector 32
	FDB	exit		;88  User Defined Interrupt Vector 33
	FDB	exit		;89  User Defined Interrupt Vector 34
	FDB	exit		;90  User Defined Interrupt Vector 35
	FDB	exit		;91  User Defined Interrupt Vector 36
	FDB	exit		;92  User Defined Interrupt Vector 37
	FDB	exit		;93  User Defined Interrupt Vector 38
	FDB	exit		;94  User Defined Interrupt Vector 39
	FDB	exit		;95  User Defined Interrupt Vector 40
	FDB	exit		;96  User Defined Interrupt Vector 41
	FDB	exit		;97  User Defined Interrupt Vector 42
	FDB	exit		;98  User Defined Interrupt Vector 43
	FDB	exit		;99  User Defined Interrupt Vector 44
	FDB	exit		;100 User Defined Interrupt Vector 45
	FDB	exit		;101 User Defined Interrupt Vector 46
	FDB	exit		;102 User Defined Interrupt Vector 47
	FDB	exit		;103 User Defined Interrupt Vector 48
	FDB	exit		;104 User Defined Interrupt Vector 49
	FDB	exit		;105 User Defined Interrupt Vector 50
	FDB	exit		;106 User Defined Interrupt Vector 51
	FDB	exit		;107 User Defined Interrupt Vector 52
	FDB	exit		;108 User Defined Interrupt Vector 53
	FDB	exit		;109 User Defined Interrupt Vector 54
	FDB	exit		;100 User Defined Interrupt Vector 55
	FDB	exit		;111 User Defined Interrupt Vector 56
	FDB	exit		;112 User Defined Interrupt Vector 57
	FDB	exit		;113 User Defined Interrupt Vector 58
	FDB	exit		;114 User Defined Interrupt Vector 59
	FDB	exit		;115 User Defined Interrupt Vector 60
	FDB	exit		;116 User Defined Interrupt Vector 61
	FDB	exit		;117 User Defined Interrupt Vector 62
	FDB	exit		;118 User Defined Interrupt Vector 63
	FDB	exit		;119 User Defined Interrupt Vector 64
	FDB	exit		;120 User Defined Interrupt Vector 65
	FDB	exit		;121 User Defined Interrupt Vector 66
	FDB	exit		;122 User Defined Interrupt Vector 67
	FDB	exit		;123 User Defined Interrupt Vector 68
	FDB	exit		;124 User Defined Interrupt Vector 69
	FDB	exit		;125 User Defined Interrupt Vector 70
	FDB	exit		;126 User Defined Interrupt Vector 71
	FDB	exit		;127 User Defined Interrupt Vector 72
	FDB	exit		;128 User Defined Interrupt Vector 73
	FDB	exit		;129 User Defined Interrupt Vector 74
	FDB	exit		;130 User Defined Interrupt Vector 75
	FDB	exit		;131 User Defined Interrupt Vector 76
	FDB	exit		;132 User Defined Interrupt Vector 77
	FDB	exit		;133 User Defined Interrupt Vector 78
	FDB	exit		;134 User Defined Interrupt Vector 79
	FDB	exit		;135 User Defined Interrupt Vector 80
	FDB	exit		;136 User Defined Interrupt Vector 81
	FDB	exit		;137 User Defined Interrupt Vector 82
	FDB	exit		;138 User Defined Interrupt Vector 83
	FDB	exit		;139 User Defined Interrupt Vector 84
	FDB	exit		;140 User Defined Interrupt Vector 85
	FDB	exit		;141 User Defined Interrupt Vector 86
	FDB	exit		;142 User Defined Interrupt Vector 87
	FDB	exit		;143 User Defined Interrupt Vector 88
	FDB	exit		;144 User Defined Interrupt Vector 89
	FDB	exit		;145 User Defined Interrupt Vector 90
	FDB	exit		;146 User Defined Interrupt Vector 91
	FDB	exit		;147 User Defined Interrupt Vector 92
	FDB	exit		;148 User Defined Interrupt Vector 93
	FDB	exit		;149 User Defined Interrupt Vector 94
	FDB	exit		;150 User Defined Interrupt Vector 95
	FDB	exit		;151 User Defined Interrupt Vector 96
	FDB	exit		;152 User Defined Interrupt Vector 97
	FDB	exit		;153 User Defined Interrupt Vector 98
	FDB	exit		;154 User Defined Interrupt Vector 99
	FDB	exit		;155 User Defined Interrupt Vector 100
	FDB	exit		;156 User Defined Interrupt Vector 101
	FDB	exit		;157 User Defined Interrupt Vector 102
	FDB	exit		;158 User Defined Interrupt Vector 103
	FDB	exit		;159 User Defined Interrupt Vector 104
	FDB	exit		;160 User Defined Interrupt Vector 105
	FDB	exit		;161 User Defined Interrupt Vector 106
	FDB	exit		;162 User Defined Interrupt Vector 107
	FDB	exit		;163 User Defined Interrupt Vector 108
	FDB	exit		;164 User Defined Interrupt Vector 109
	FDB	exit		;165 User Defined Interrupt Vector 110
	FDB	exit		;166 User Defined Interrupt Vector 111
	FDB	exit		;167 User Defined Interrupt Vector 112
	FDB	exit		;168 User Defined Interrupt Vector 113
	FDB	exit		;169 User Defined Interrupt Vector 114
	FDB	exit		;170 User Defined Interrupt Vector 115
	FDB	exit		;171 User Defined Interrupt Vector 116
	FDB	exit		;172 User Defined Interrupt Vector 117
	FDB	exit		;173 User Defined Interrupt Vector 118
	FDB	exit		;174 User Defined Interrupt Vector 119
	FDB	exit		;175 User Defined Interrupt Vector 120
	FDB	exit		;176 User Defined Interrupt Vector 121
	FDB	exit		;177 User Defined Interrupt Vector 122
	FDB	exit		;178 User Defined Interrupt Vector 123
	FDB	exit		;179 User Defined Interrupt Vector 124
	FDB	exit		;180 User Defined Interrupt Vector 125
	FDB	exit		;181 User Defined Interrupt Vector 126
	FDB	exit		;182 User Defined Interrupt Vector 127
	FDB	exit		;183 User Defined Interrupt Vector 128
	FDB	exit		;184 User Defined Interrupt Vector 129
	FDB	exit		;185 User Defined Interrupt Vector 130
	FDB	exit		;186 User Defined Interrupt Vector 131
	FDB	exit		;187 User Defined Interrupt Vector 132
	FDB	exit		;188 User Defined Interrupt Vector 133
	FDB	exit		;189 User Defined Interrupt Vector 134
	FDB	exit		;190 User Defined Interrupt Vector 135
	FDB	exit		;191 User Defined Interrupt Vector 136
	FDB	exit		;192 User Defined Interrupt Vector 137
	FDB	exit		;193 User Defined Interrupt Vector 138
	FDB	exit		;194 User Defined Interrupt Vector 139
	FDB	exit		;195 User Defined Interrupt Vector 140
	FDB	exit		;196 User Defined Interrupt Vector 141
	FDB	exit		;197 User Defined Interrupt Vector 142
	FDB	exit		;198 User Defined Interrupt Vector 143
	FDB	exit		;199 User Defined Interrupt Vector 144
	FDB	exit		;200 User Defined Interrupt Vector 145
	FDB	exit		;201 User Defined Interrupt Vector 146
	FDB	exit		;202 User Defined Interrupt Vector 147
	FDB	exit		;203 User Defined Interrupt Vector 148
	FDB	exit		;204 User Defined Interrupt Vector 149
	FDB	exit		;205 User Defined Interrupt Vector 150
	FDB	exit		;206 User Defined Interrupt Vector 151
	FDB	exit		;207 User Defined Interrupt Vector 152
	FDB	exit		;208 User Defined Interrupt Vector 153
	FDB	exit		;209 User Defined Interrupt Vector 154
	FDB	exit		;210 User Defined Interrupt Vector 155
	FDB	exit		;211 User Defined Interrupt Vector 156
	FDB	exit		;212 User Defined Interrupt Vector 157
	FDB	exit		;213 User Defined Interrupt Vector 158
	FDB	exit		;214 User Defined Interrupt Vector 159
	FDB	exit		;215 User Defined Interrupt Vector 160
	FDB	exit		;216 User Defined Interrupt Vector 161
	FDB	exit		;217 User Defined Interrupt Vector 162
	FDB	exit		;218 User Defined Interrupt Vector 163
	FDB	exit		;219 User Defined Interrupt Vector 164
	FDB	exit		;220 User Defined Interrupt Vector 165
	FDB	exit		;221 User Defined Interrupt Vector 166
	FDB	exit		;222 User Defined Interrupt Vector 167
	FDB	exit		;223 User Defined Interrupt Vector 168
	FDB	exit		;224 User Defined Interrupt Vector 169
	FDB	exit		;225 User Defined Interrupt Vector 170
	FDB	exit		;226 User Defined Interrupt Vector 171
	FDB	exit		;227 User Defined Interrupt Vector 172
	FDB	exit		;228 User Defined Interrupt Vector 173
	FDB	exit		;229 User Defined Interrupt Vector 174
	FDB	exit		;230 User Defined Interrupt Vector 175
	FDB	exit		;231 User Defined Interrupt Vector 176
	FDB	exit		;232 User Defined Interrupt Vector 177
	FDB	exit		;233 User Defined Interrupt Vector 178
	FDB	exit		;234 User Defined Interrupt Vector 179
	FDB	exit		;235 User Defined Interrupt Vector 180
	FDB	exit		;236 User Defined Interrupt Vector 181
	FDB	exit		;237 User Defined Interrupt Vector 182
	FDB	exit		;238 User Defined Interrupt Vector 183
	FDB	exit		;239 User Defined Interrupt Vector 184
	FDB	exit		;240 User Defined Interrupt Vector 185
	FDB	exit		;241 User Defined Interrupt Vector 186
	FDB	exit		;242 User Defined Interrupt Vector 187
	FDB	exit		;243 User Defined Interrupt Vector 188
	FDB	exit		;244 User Defined Interrupt Vector 189
	FDB	exit		;245 User Defined Interrupt Vector 190
	FDB	exit		;246 User Defined Interrupt Vector 191
	FDB	exit		;247 User Defined Interrupt Vector 192
	FDB	exit		;248 User Defined Interrupt Vector 193
	FDB	exit		;249 User Defined Interrupt Vector 194
	FDB	exit		;250 User Defined Interrupt Vector 195
	FDB	exit		;251 User Defined Interrupt Vector 196
	FDB	exit		;252 User Defined Interrupt Vector 197
	FDB	exit		;253 User Defined Interrupt Vector 198
	FDB	exit		;254 User Defined Interrupt Vector 199
	FDB	exit		;255 User Defined Interrupt Vector 200
exit	EQU	*
;**** Startup Code *****
; Initialize & configure system including the Watchdog and System Clock
start	LDAB	#$0F		;BankF = register access
	TBEK			;point EK to bank F for register access
	LDD	#$0003		;at reset, the CSBOOT block size is 512k
	STD	CSBARBT		;this line sets the block size to 64k
	LDAA	#$7F		;w=0, x=1, y=111111
	STAA	SYNCR		;set system clock to 16.78 Mhz
	CLR	SYPCR		;turn COP (software watchdog) off,
; Initialize the HC16's 1K internal SRAM (at ?RAMbeg, bank 0)
	CLRD			;Page zero
	STD	RAMBAH		;Set upper RAM array
	LDD	#RAMbeg		;Offset to top RAM
	STD	RAMBAL		;Set lower RAM array
	CLR	RAMMCR		;Enable RAM
; For MOTOROLA EVB16 with additional RAM populated (U1, U3)
; Set up bank 1 to be 64K 8/16 bit read/write RAM
; This is done only for the segalloc() and segfree() functions
	LDD	#(RAMseg<8)+3	;address=$10000 Blksize=64K
	STD	CSBAR0		;set U1 RAM chip select
	STD	CSBAR1		;set U3 RAM chip select
	STD	CSBAR2		;set U1/U3 RAM chip select
	LDD	#$5030		;Async, Ubyte, Wonly, Addr, 0Wait, Super/User
	STD	CSOR0		;Set chip-select 0 (U1 WE)
	LDD	#$3030		;Async, Lbyte, Wonly, Addr, 0Wait, Super/User
	STD	CSOR1		;Set chip-select 1 (U3 WE)
	LDD	#$7830		;Async, Word, R/W, Addr, 0Wait, Super/User
	STD	CSOR2		;Set chip-select 2 (U1,U3 CS)
	LDD	#$00FF		;CS2,CS1,CS0,CSBOOT = 16 bit port
	STD	CSPAR0		;Set chip-selects
; Initialize the SCI to transmit and receive at 9600 baud
	LDD	#$0037
	STD	SCCR0		;set the SCI baud rate to 9600 baud
	LDD	#$000C
	STD	SCCR1		;enable the SCI receiver and transmitter
; Zero all memory bank selectors
	CLRB			;Switch to page zero
	TBEK			;EK=0 for global access
	TBXK			;XK=0 for indexed access
	TBYK			;YK=0 for misc. access
	TBZK			;ZK=0 for stack access
	TBSK			;SK=0 for system stack
; Loop, reading data till it times out
flush:	BSR	getchr		; Read data
	BRA	flush		; Till it times out

; Write a character to the SCI port (no translation)
putchr	TSX			;Address stack
	LDD	4,X		;Get character
?putchr	PSHM	D,E,K		;Save data & extension register
	CLRA			;Zero high
	TDE			;E = data
	LDAB	#$0F		;Bank F for register access
	TBEK			;Set up K
	BRCLR	SCSR,#$01,*	;Wait until xmitter is ready
	STE	SCDR		;transmit one ASCII character to the screen
	PULM	D,E,K		;Restore data & extension
?putret	RTS
;
; Write character in B to the serial port
;
wrchr:	PSHM	D,E,K		;Save data & extension register
	CLRA			;Zero high
	TDE			;E = data
	LDAB	#$0F		;Bank F for register access
	TBEK			;Set up K
	BRCLR	SCSR,#$01,*	;Wait until xmitter is ready
	STE	SCDR		;transmit one ASCII character to the screen
	PULM	D,E,K		;Restore data & extension
	RTS
;
; Get an address into the X register
;
getaddr	BSR	getchr		;Get high address
	TBA			;Set high
	BSR	getchr		;Get low address
	XGDX			;Set address
	RTS
;
; Get character from the serial port with timeout
; re-enter monitor if timeout
;
getchr:	PSHM	X,K		;Save extension
	LDAB	#$0F		;Bank F for register access
	TBEK			;Set up K
	LDX	#0		;Zero counter
getch1:	BRCLR	SCSR+1,#$40,getch2 ;No data available
	LDAB	SCDR+1		;Get the data
	PULM	X,K		;Restore extension
	RTS
getch2:	AIX	#-1		; Reduce X by 1
	BNE	getch1		; No timeout yet
;
; Main monitor command loop
;
main:	LDS	#STACK		;Zero stack
main1:	CLRB			;Get zero
	TBEK			;EK=0 for global access
	TBXK			;XK=0 for indexed access
	TBYK			;YK=0 for misc. access
	TBZK			;ZK=0 for stack access
	TBSK			;SK=0 for system stack
main2:	BSR	getchr		;Get character
;
; Query command
;
	CMPB	#CQUERY		;Query?
	BNE	mreadp		;No, try next
	LDX	#qresp		;Point to response
qloop:	LDAB	,X		;Read data
	BEQ	main2		;End - exit
	BSR	wrchr		;Send to host
	AIX	#1		;Advance to next
	BRA	qloop		;Do them all
qresp:	FCB	RESP1,RESP2,=KID,KID,1,0
; Read memory location
mread:	TAB			; B = extension
	TBXK			; X extension = B
	BSR	getaddr		; Get the address
	BSR	getchr		; Get size
	TBA			; A = size
mread1:	LDAB	,X		; Get data
	BSR	wrchr		; Send to host
	AIX	#1		; Skip to next
	DECA			; Reduce count
	BNE	mread1		; Do them all
	BRA	main1		; And exit
;
; Read program memory
;
mreadp:	LDAA	pext		; Get program extension
	CMPB	#CREADP		; Read program?
	BEQ	mread		; Yes, do the read
	CMPB	#CWRITEP	; Write program?
	BEQ	mwrite		; Yes, do the write
	LDAA	dext		; Get data extension
	CMPB	#CREADD		; Read data?
	BEQ	mread		; Yes, do the read
	CMPB	#CWRITED	; Write data?
	BEQ	mwrite		; Yes, do the write
	LDAA	xext		; Get X extension
	CMPB	#CREADX		; Read X?
	BEQ	mread		; Yes, do the read
	CMPB	#CWRITEX	; Write X?
	BEQ	mwrite		; Yes, do the write
	LDAA	yext		; Get Y extension
	CMPB	#CREADY		; Read Y?
	BEQ	mread		; Yes, do the read
	CMPB	#CWRITEY	; Write Y?
	BEQ	mwrite		; Yes, do the write
	LDAA	zext		; Get Z extension
	CMPB	#CREADZ		; Read Z?
	BEQ	mread		; Yes, do the read
	CMPB	#CWRITEZ	; Write Z?
	BEQ	mwrite		; Yes, do the write
	LDAA	sext		; Get S extension
	CMPB	#CREADS		; Read S?
	BEQ	mread		; Yes, do the read
	CMPB	#CWRITES	; Write S?
	BNE	break		; No, try next
; Write memory location
mwrite:	TAB			; B = extension
	TBXK			; X extension = B
	JSR	getaddr		; Get the address
	JSR	getchr		; Get size
	TBA			; A = size
mwrit1:	JSR	getchr		; Read a character
	STAB	,X		; Write to memory
	AIX	#1		; Skip to next
	DECA			; Reduce count
	BNE	mwrit1		; Do them all
	JMP	main1		; And exit
;
; Set a breakpoint
;
break:
