/*
 * PocketShell
 */
#include <stdio.h>
#include <window.h>
#include <file.h>

#define	EXTENSIONS	50			// Number of extensions supported
#define	COMMANDS	50			// Number of commands supported
#define	EXTCMDS		25			// Commands per extension
#define	MAXFILES	500			// Number of files supported

// Command function codes
#define	CMD_NAME	0x80		// Filename
#define	CMD_NAMEO	0x81		// Name only
#define	CMD_PATH	0x82		// Pathname only
#define	CMD_SOURCE	0x83		// Source filename
#define	CMD_DEST	0x84		// Destination filename
#define	CMD_ARGS	0x85		// Argument
#define	CMD_CONFIRM	0x86		// Always confirm
#define	CMD_PAUSE	0x87		// Always pause
#define	CMD_QUOTE	0x88		// String
#define	CMD_DEFI	0x89		// Default Input

// File display options
#define	FD_size		0x01		// Display size
#define	FD_time		0x02		// Display time
#define	FD_date		0x04		// Display date
#define	FD_attr		0x08		// Display attributes
#define	FD_sort		0x10		// Sort display
#define	FD_NUM		5

unsigned char *FD_menu[] = {
	" Show Size",
	" Show Time",
	" Show Date",
	" Show Attrs",
	" Sort names",
	" File match",
	0 };
unsigned char *FD_keywords[] = {
	"SIZE", "TIME", "DATE", "ATTR", "SORT" };

unsigned
	CEflags,						// Critical error flags
	CEcode,							// Critical error code
	CEseg,							// INT 24 segment
	CEoff,							// INT 24 offset
	Width = 80,						// Screen width
	Height = 25,					// Screen Height
	ext_top,						// Highest extension name used
	cmd_top,						// Highest command name used
	file_top,						// Highest file used
	pool_top;						// Highest address used in pool

unsigned char
	path[70],						// Current path
	Dpath[70],						// Destination path
	Spath[70],						// Source path
	Args[51],						// Arguments
	Fname[51],						// Filename
	temp[100],						// General storage
	*extensions[EXTENSIONS],		// Known file extensions
	*cnames[COMMANDS],				// Known command names
	*ctext[COMMANDS],				// Known command descriptions
	extcmd[EXTENSIONS][EXTCMDS],	// Extension -> Command mapping
	*ptr,							// General pointer
	pool[20000];					// memory pool

struct FF_block
	*files[MAXFILES];

unsigned char
	Confirm = 255,
	Fdisplay,
	Pause,
	Pause1,
	Confirm1;

unsigned
	Ten[2] = { 10, 0 };

extern unsigned
	Longreg[];

unsigned char *DEwords[] = {
"access", "adapter", "block", "can't", "code", "command", "data",
"deleted", "denied", "device", "disk", "drive", "duplicate", "error",
"exceeded", "failure", "fault", "file", "files", "found", "function",
"incorrect", "insufficient", "invalid", "limit", "many", "memory",
"missing", "name", "net", "netbios", "network", "not", "password",
"print", "redirection", "remote", "request", "required", "space", "type",
"unexpected", "unit", "unknown", "violation", "write"};	// 46

unsigned char *DEtext[] = {
	"\x97 \x94 number",					// 1
	"\x91 \xA0 \x93",					// 2
	"path \xA0 \x93",					// 3
	"too \x99 open \x92",				// 4
	"\x80 \x88",						// 5
	"\x97 handle",						// 6
	"cntrl \x82 destroyed",				// 7
	"\x96 \x9A",						// 8
	"\x97 \x9A \x82",					// 9
	"\x97 environment",					// 10
	"\x97 format",						// 11
	"\x97 \x80 \x84",					// 12
	"\x97 \x86",						// 13
	"\xAB \xAA",						// 14
	"\x97 \x8A \x8B",					// 15
	"\x83 remove current dir",			// 16
	"\xA0 same \x89",					// 17
	"no more \x92",						// 18
	"\x8A \xAD protected",				// 19
	"\xAB \xAA",						// 20
	"\x8B \xA0 ready",					// 21
	"\xAB \x85",						// 22
	"\x86 \x8D - bad crc",				// 23
	"bad \xA5-struct",					// 24
	"seek \x8D",						// 25
	"\xAB media \xA8",					// 26
	"sector \xA0 \x93",					// 27
	"\xA2er",							// 28
	"\xAD \x90",						// 29
	"read \x90",						// 30
	"general \x8F",						// 31
	"sharing \xAC",						// 32
	"\x91-lock",						// 33
	"\x8A change \x97",					// 34
	"fcb unavailable",					// 35
	"share buffer overflow",			// 36
	"\x84 page mismatch",				// 37
	"\x83 finish \x91 operation",		// 38
	"\x96 \x8A \xA7",					// 39
	0,									// 40
	0,									// 41
	0,									// 42
	0,									// 43
	0,									// 44
	0,									// 45
	0,									// 46
	0,									// 47
	0,									// 48
	0,									// 49
	"unsupported \x9F \xA5",			// 50
	"\xA4 \xA0 listening",				// 51
	"\x8C \x9C on \x9F",				// 52
	"\x9F \x9C \xA0 \x93",				// 53
	"\x9F busy",						// 54
	"\x9Dword",							// 55
	"\x9E \x85 \x98",					// 56
	"\x9F \x81 \x8D",					// 57
	"\x95 response from \x9D",			// 58
	"\xA9 \x9F \x8D",					// 59
	"\xA4 \x81 incompatible",			// 60
	"\xA2 queue full",					// 61
	"no \xA7 to \xA2 \x91",				// 62
	"\xA2 \x91 was \x87",				// 63
	"\x9F \x9C \x87",					// 64
	"\x9F \x80 \x88",					// 65
	"\x95 \x9D \x89 \xA8",				// 66
	"\x9F \x9C \xA0 \x93",				// 67
	"\x9F \x9C \x98 \x8E",				// 68
	"\x9E session \x98",				// 69
	"temporary pause",					// 70
	"\x9F \xA5 \xA0 accepted",			// 71
	"\xA3 paused",						// 72
	"\x9F software \x9B",				// 73
	"\xA9 \x81 close",					// 74
	"\xA1 \xA6",						// 75
	"\x97 login attempt",				// 76
	"\x9F \x8A \x98 \x8E",				// 77
	"\xA0 logged in",					// 78
	0,									// 79
	"\x91 already exists",				// 80
	0,									// 81
	"cannot create directory",			// 82
	"critical \x8D \x8F",				// 83
	"too \x99 \xA3s",					// 84
	"\x8C \xA3",						// 85
	"\x97 \xA1",						// 86
	"\x97 parameter",					// 87
	"\x9F \xAD \x90",					// 88
	"\x94 \xA0 avail. on \x9D",			// 89
	"\xA6 component \x9B"};				// 90

#include "pen.h"

/*
 * Add a string to the pool
 */
unsigned char *add_pool(unsigned char *text)
{
	unsigned char *p;
	p = pool + pool_top;
	do {
		if(pool_top >= sizeof(pool))
			abort("Out of memory");
		pool[pool_top++] = *text; }
	while(*text++);
	return p;
}

/*
 * Skip ahead to next non-blank
 */
unsigned char skip_blanks()
{
	while(isspace(*ptr))
		++ptr;
	return *ptr;
}

/*
 * Parse work from input
 */
int parse(unsigned char *dest)
{
	unsigned char *p;
	skip_blanks();
	p = dest;
	while(*ptr && !isspace(*ptr))
		*p++ = toupper(*ptr++);
	*p = 0;
	return *dest;
}

unsigned lookup(unsigned char *word, unsigned char *list[], unsigned index)
{
	unsigned i;
//	unsigned char *p;
	for(i=0; i < index; ++i) {
//		if(!(p = list[i]))
//			break;
		if(!strcmp(list[i], word))
			return i; }
	return -1;
}

asm {
INT24:	PUSH	DS					; Save DS
		PUSH	CS					; Copy CS
		POP		DS					; Set DS
		MOV		DGRP:_CEflags,AX	; Set flags
		MOV		DGRP:_CEcode,DI		; Set code
		POP		DS					; Restore DS
		MOV		AL,3				; Cause source failure
		IRET
}
void CE_on() asm
{
		MOV		DX,offset INT24		; Address of handler
		MOV		AX,2524h			; Set vector 24h
		INT		21h					; Call DOS
}
void CE_off() asm
{
		PUSH	DS					; Save DS
		MOV		DX,DGRP:_CEoff		; Get old INT24 offset
		MOV		DS,DGRP:_CEseg		; Get old INT24 segment
		MOV		AX,2524h			; Set vector 24h
		INT		21h					; Call DOS
		POP		DS					; Restore DS
}
void CE_check()
{
	if(CEflags|CEcode) {
		message("Disk error on drive %c:", (CEflags & 0x1F) + 'A');
		CEflags = CEcode = 0; }
}

read_config(unsigned char *path)
{
	unsigned i, j, l;
	unsigned char buffer[200], c, *op;
	FILE *fp;
	static unsigned char *keywords[] = {
		"WIDTH", "HEIGHT", "PEN", "CONFIRM", "PAUSE", "LEFT", "DISPLAY" };

	i = j = 0;
	while(buffer[i] = l = path[i]) {
		++i;
		if(l == '.')
			j = i; }
	strcpy(buffer+j, "INI");
	fp = fopen(buffer, "rvq");

	l = 0;
	while(fgets(ptr = buffer, sizeof(buffer)-1, fp)) {
		++l;
		switch(j = skip_blanks()) {
		case ';' :					// Comemnt
		case 0   : continue;		// Null line
		case '#' :					// CONFIG item
			++ptr;
			parse(temp);
			if((i = lookup(temp, keywords, sizeof(keywords)/2)) == -1) {
				printf("%u: Unknown # keyword: '%s'\n", l, temp);
				exit(-1); }
			parse(temp);
			switch(i) {
			case 0 :	Width	= atoi(temp);	continue;
			case 1 :	Height	= atoi(temp);	continue;
			case 2 :	C_Hold	= atoi(temp);	continue;
			case 3 :	op = &Confirm;			break;
			case 4 :	op = &Pause;			break;
			case 5 :	op = &C_left;			break;
			case 6 :
				do {
					if((i = lookup(temp, FD_keywords, sizeof(FD_keywords)/2)) == -1) {
						printf("%u: Unknown display option '%s'\n", l, temp);
						exit(-1); }
					Fdisplay |= (1 << i); }
				while(parse(temp));
				continue; }
			if(!strcmp(temp, "NO"))			{ *op = 0; continue; }
			else if(!strcmp(temp, "YES"))	{ *op = 255; continue; }
			printf("%u: Bad YES/NO option '%s'\n", l, temp);
			exit(-1);
		case '$' :					// Shell command
		case '%' :					// Direct EXE command
			++ptr;
			if(!parse(temp)) {
				printf("%u: No command name\n", l);
				exit(-1); }
			if((i = lookup(temp, cnames, cmd_top)) != -1) {
				printf("%u: Duplicate command name '%s'\n", l, temp);
				exit(-1); }
			if(cmd_top >= COMMANDS) {
				printf("%u: Command table exhausted\n", l);
				exit(-1); }
			cnames[cmd_top] = add_pool(temp);
			if(!skip_blanks()) {
				printf("%u: No description for '%s'\n", l, temp);
				exit(-1); }
			ctext[cmd_top++] = pool + pool_top;
			pool[pool_top++] = j;
			do  {
				if(pool_top >= sizeof(pool))
					abort("Out of memory");
				if((c = *ptr++) == '%') { newesc: switch(c = *ptr++) {
					case '\'':
						pool[pool_top++] = CMD_QUOTE;
						while(c = *ptr++) {
							if(c == '\'') goto newesc;
							pool[pool_top++] = c; }
					default:
						printf("%u: Bad escape sequence\n", l);
						exit(-1);
					case 'N' : c = CMD_NAME;	break;
					case 'O' : c = CMD_NAMEO;	break;
					case 'F' : c = CMD_PATH;	break;
					case 'S' : c = CMD_SOURCE;	break;
					case 'D' : c = CMD_DEST;	break;
					case 'A' : c = CMD_ARGS;	break;
					case 'C' : c = CMD_CONFIRM;	break;
					case 'P' : c = CMD_PAUSE;	break;
					case 'I' : c = CMD_DEFI;
					case '%' : } }
				pool[pool_top++] = c; }
			while(c);
			continue; }

		if((!parse(temp)) || (strlen(temp) > 3)) {
			printf("%u: Bad extension '%s'\n", l, temp);
			exit(-1); }

		j = 0;
		if(lookup(temp, extensions, ext_top) != -1) {
			printf("%u: Duplicate extension '%s'\n", l, temp);
			exit(-1); }
		extensions[ext_top] = add_pool(temp);

		if(!skip_blanks()) {
			printf("%u: No command definitions for '%s'\n", l, temp);
			exit(-1); }

		while(parse(temp)) {
			if((i = lookup(temp, cnames, cmd_top)) == -1) {
				printf("%u: Command name '%s' not found\n", l, temp);
				exit(-1); }
			extcmd[ext_top][j++] = i+1; }

		++ext_top; }
			
	fclose(fp);
	if(Width < 40) abort("Bad #WIDTH - must be >= 40");
	if(Height < 16) abort("Bad HEIGHT - must be >= 16");
}

/* int directory_compare(struct FF_block *f1, struct FF_block *f2)
{
	if((f1->FF_attrib ^ f2->FF_attrib) & DIRECTORY)
		return f2->FF_attrib & DIRECTORY;
	return strcmp(f1->FF_name, f2->FF_name) == 1;
} */
directory_compare(f1, f2) asm
{
		XOR		AH,AH			; Zero high
		MOV		SI,6[BP]		; Get F1
		MOV		DI,4[BP]		; Get F2
		MOV		AL,21[SI]		; Get attributes
		XOR		AL,21[DI]		; Test for differences
		AND		AL,10h			; Differences?
		JZ		dc1				; No, do normal compare
		MOV		AL,21[DI]		; Get f2 attributes
		AND		AL,10h			; > if directory
		POP		BP				; Restore BP
		RET
dc1:	ADD		SI,30			; Offset to source name
		ADD		DI,30			; Offset to dest name
dc2:	MOV		AL,[SI]			; Get source
		CMP		AL,[DI]			; Compare with dest
		JNZ		dc4				; Report difference
		INC		SI				; Advance source
		INC		DI				; Advance dest
		AND		AL,AL			; End of string?
		JZ		dc2				; Continue
dc3:	XOR		AL,AL			; No compare
		POP		BP				; Restore PB
		RET
dc4:	JB		dc3				; <
		MOV		AL,-1			; Report >
}
		
		
/*
 * Input:
 *	x		= base x coordinate
 *	y		= base y coordinate
 *	w		= Width of window
 *	h		= Maximum height of window
 *	color	= Window colors
 *	menu 	= List of menu items to present on title bar
 *	func	= function index call
 *	items	= List of items to present
 * Returns:
 *	FFFF	= 'X' selected by tap
 *	FEFF	= 'X' selected by tap and hold
 *  FFnn	= Menu item 'n' selected by tap
 *  FEnn	= Menu item 'n' selected by tap and hold
 *  xxnn	= Item 'n' selected at offset 'x' by tap
 *	8xnn	= Item 'n' selected at offset 'x' by tab-and-hold
 */
show_file(unsigned index)
{
	struct FF_block *f;
	unsigned i, j, k, x, l[2];
	unsigned char *p, temp[10];
	static char attrs[] = { "RHSVDA??" };

	// Display the filename
	p = (f = files[index]) -> FF_name;
	x = 0;
	while(*p) {
		wputc(*p++);
		++x; }
	if(f->FF_attrib & DIRECTORY) {
		wputc('\\');
		++x; }
	while(x < 13) {
		wputc(' ');
		++x; }

	// Display size
	if(Fdisplay & FD_size) {
		longcpy(l, f->FF_size);
		i = 0;
		do {
			longdiv(l, Ten);
			temp[i++] = *Longreg + '0'; }
		while(longtst(l));
		x += i;
		while(x < 22) {
			wputc(' ');
			++x; }
		do {
			wputc(temp[--i]); }
		while(i); }

	j = (k = ((i = f->FF_time) >> 11) & 0x1f) % 12;
	if(Fdisplay & FD_time)
		wprintf(" %2u:%02u%c", (j)?j:12, (i>>5)&0x3F, (k>11)?'p':'a');
	if(Fdisplay & FD_date) {
		i = f->FF_date;
		wprintf(" %2u-%02u-%02u", (i>>5)&0x0F, i&0x1F, ((i>>9)+80)%100); }

	// Display attributes
	if(Fdisplay & FD_attr) {
		wputc(' ');
		for(i=0; i < 6; ++i) {
			if((1 << i) & f->FF_attrib) {
				wputc(attrs[i]);
				++x; } } }
}

unsigned char *about[] = {
	"",
	"PocketShell 1.0",
	"",
	"Copyright 2003-2006",
	"Dave Dunfield.",
	"All rights reserved.",
	"",
	"www.dunfield.com",
	0 };

main(int argc, char *argv[])
{
	unsigned i, b;

	read_config(argv[0]);
	if(!Fdisplay) {
		Fdisplay = (Width >= 45) ?
			(FD_size|FD_time|FD_date|FD_attr|FD_sort)
		:	(FD_size|FD_time|FD_date|FD_sort); }
	if(!init_mouse())
		abort("Mouse required");
	*path = get_drive() + 'A';
	path[1] = ':';	
	path[2] = '\\';
	getdir(path+3);
	wopen(0, 0, Width, Height, WSAVE|0x17);

	asm {
		MOV		AX,3524h			; Get INT024
		INT		21h					; Call DOS
		MOV		DGRP:_CEseg,ES		; Save segment
		MOV		DGRP:_CEoff,BX		; Save offset
	}
	b = pool_top;

	CE_on();
redraw:
	*W_OPEN = 0x17; wclwin();
	pool_top = b;
	sprintf(temp, " \x04Confirm:%c \x04Pause:%c \x04About",
		Confirm ? 'Y' : 'N',
		Pause ? 'Y' : 'N');
	i = get_file(0, 0x17, path, temp);
	set_drive(*path - 'A');
	chdir(path);
	CE_check();
	switch(i) {
	case 0xFFFF : wclose(); CE_off(); return;
	case 0xFF02 : Confirm = Confirm ? 0 : 255; goto redraw;
	case 0xFF03 : Pause = Pause ? 0 : 255; goto redraw;
	case 0xFF04 : xmessage(about); goto redraw; }

	process_file(files[i & 0x7FFF], i >> 15); goto redraw;
}

process_file(struct FF_block *f, char hold)
{
	unsigned i, j, k, e;
	unsigned char *p, **flist, c; // temp[EXTCMDS*2];
	Confirm1 = Confirm;
	Pause1 = Pause;
	p = f->FF_name;
	while(*p) {
		if(*p++ == '.')
			break; }

	if((e = lookup(p, extensions, ext_top)) == -1) {
		e = 0;
		Confirm1 = hold = 255; }

	if(!hold) {		// Single tap - run first command
		do_command(f->FF_name, extcmd[e][0]);
		return; }

	// Build list
	flist = pool+pool_top;
	for(i=j=0; c = extcmd[e][i]; ++i) {
		temp[j] = c;
		flist[j++] = cnames[c-1]; }
	if(e) {
		for(i=0; c = extcmd[0][i]; ++i) {
			for(k=0; k < j; ++k)
				if(temp[k] == c)
					goto noadd;
			temp[j] = c;
			flist[j++] = cnames[c-1];
			noadd: } }
	flist[j++] = 0;
	if(j > 7) j = 7;
	if((Y+j) >= Height) Y = Height-j;
	if((X+25) >= Width) X = Width - 25;
	switch(i = pen_menu(X, Y, 25, 6, WSAVE|0x67, "|Command", -1, flist)) {
	case 0xFFFF :
	case 0xFEFF : return; }
	do_command(f->FF_name, temp[i & 255]);
}

append(unsigned char *p, unsigned char t)
{
	while(*p) {
		if(*p == t)
			break;
		*ptr++ = *p++; }
}

unsigned char *arg(unsigned char *dest, unsigned char *source,
	unsigned char *def, unsigned char *prefix, unsigned char *suffix)
{
	unsigned char *d;
	d = dest;
	if(!source)
		source = def;
	if(prefix) {
		while(*d = *prefix++)
			++d; }
	while(*source && !(*source & 0x80))
		*d++ = *source++;
	if(suffix) {
		while(*d = *suffix++)
			++d; }
	*d = 0;
	return dest;
}

do_command(unsigned char *file, unsigned cmd)
{
	unsigned r, cd, cs, ca;
	unsigned char *p, *p1, c, *t, title[80], // xfile[13];
	static char cmdbuf[150];
//	strcpy(xfile, file);
	p = ctext[--cmd];
	ptr = cmdbuf;
	*Args = cd = cs = ca = 0;
	wgotoxy(0, 0); wprintf("%s %s", cnames[cmd], /*x*/file); wcleol();
	while(c = *p++) { t = 0; xcmd: switch(c) {
		case CMD_PATH :
			append(path, 0);
			if(*(ptr-1) != '\\')
				append("\\", 0);
			continue;
		case CMD_NAME:		append(file, 0);			continue;
		case CMD_NAMEO:		append(file, '.');			continue;
		case CMD_CONFIRM:	Confirm1 = 255;				continue;
		case CMD_PAUSE:		Pause1 = 255;				continue;
		case CMD_DEST:
			if(!*Dpath)
				strcpy(Dpath, path);
		xxagain:
			switch(r = get_file(1, 0x67, Dpath, arg(title, t, "Destination file", " \x04New|  ", ":"))) {
			case 0xFFFF :
			case 0xFEFF :
				return;
			case 0xFF02 :
				if(!input("New filename:", p1 = Fname, 12))
					goto xxagain;
				break;
			default: p1 = files[r & 0x7FFF]->FF_name; }
			append(Dpath, 0);
			if(*(ptr-1) != '\\') *ptr++ = '\\';
			append(p1, 0);
			continue;
		case CMD_SOURCE:
			if(!*Spath)
				strcpy(Spath, path);
			switch(r = get_file(1, 0x67, Spath, arg(title, t, "Source file", "| ", ":"))) {
			case 0xFFFF :
			case 0xFEFF : return; }
			append(Spath, 0);
			if(*(ptr-1) != '\\') *ptr++ = '\\';
			append(files[r & 0x7FFF]->FF_name, 0);
			continue;
		case CMD_ARGS:
			if(!input(arg(title, t, "Arguments", 0, ":"), Args, 50))
				return;
			append(Args, 0);
			*Args=0;
			continue;
		case CMD_QUOTE :
			t = p;
			while(!((c = *p++) & 0x80));
			goto xcmd;
		case CMD_DEFI: arg(Args, t, "", 0, 0);
			continue;
		case '\t' : c = ' ';
		default: *ptr++ = c; } }
	*ptr = 0;
	*W_OPEN = 0x07;	wclwin(); wgotoxy(0,0);
	fputs(cmdbuf+1, stdout);
	putc('\n', stdout);
	if(Confirm1) {
		if(!yesno("%s %s?", cnames[cmd], file))
			return; }
	CE_off();
	if(*cmdbuf == '$')
		r = system(cmdbuf+1);
	else {
		p = cmdbuf;
		while(*p) {
			if(*p == ' ') {
				*p++ = 0;
				break; }
			++p; }
		r = exec(cmdbuf+1, p); }
	CE_on();
	if(r) {
		strcpy(temp, "Exit %u(");
		ptr = temp+8; p = 0;
		if(r < ((sizeof(DEtext)/2)+1))
			p = DEtext[r-1];
		if(!p) p = "unknown exit code";
		while(c = *p++) {
			if(c & 0x80) { append(DEwords[c & 0x7f], 0); continue; }
			*ptr++ = c; }
		strcpy(ptr, ")");
//		if(message("Exit Code: %d", r) == 0xFF02)
		if(message(temp, r) == 0xFF02)
			mouse_status();
		return; }
	if(Pause1) mouse_status();
}

get_file(unsigned y, unsigned a, unsigned char *path, unsigned char *prompt)
{
	unsigned i, j, k, pool_base;
	struct FF_block f, *pf;
	unsigned char temp[80], mask[13];

	pool_base = pool_top;
gocd:
	*mask = 0;
gocd1:
	if(!path[2])
		strcpy(path+2, "\\");
//reload:
	for(i=0; temp[i] = path[i]; ++i);
	if(temp[i-1] != '\\') temp[i++] = '\\';
	strcpy(temp+i, *mask ? mask : "*.*");

	*W_OPEN = 0x17; wgotoxy(0, 1); wcleow();
	*W_OPEN = REVERSE; wgotoxy(0, Height-1); wputs(temp); wcleol();

	pool_top = pool_base;
	file_top = 0;
	if(!findfirst(temp, f, 0x3F)) do {
		if(f.FF_attrib & VOLUME) continue;
		if(*f.FF_name == '.') continue;
		if(file_top >= MAXFILES) {
			message("Too many files to display");
			break; }
		memcpy(pool + pool_top, f+21, (sizeof(f)-21));
		files[file_top++] = (pool + pool_top) - 21;
		pool_top += (sizeof(f)-21); }
	while !findnext(f);
	CE_check();

	// Sort list
	if(Fdisplay & FD_sort) {
		for(i=0; i < file_top; ++i) {
			for(j=i+1; j < file_top; ++j) {
				if(directory_compare(files[i], files[j])) {
					k = files[i];
					files[i] = files[j];
					files[j] = k; } } } }

redraw:
	sprintf(temp, "\x04Up \x04Drive%s", prompt);
	i=pen_menu(0, y, Width, (Height-y)-2, WCOPEN|a, temp, file_top, &show_file);
	switch(i) {
	case 0xFFFF : return i;					// Exit
	case 0xFEFF :
		for(i=0; i < FD_NUM; ++i)
			*FD_menu[i] = ((1 << i) & Fdisplay) ? 0xFB : ' ';
		switch(i = pen_menu(C_left ? 0 : Width-11, Y+1, 11, 25, WSAVE|WCOPEN|0x34, "", -1, FD_menu)) {
		case 0xFFFF :
		case 0xFEFF :	goto redraw; }
		if((i &= 255) == FD_NUM) {
			if(!input("File match:", mask, sizeof(mask)-1)) goto redraw;
			goto gocd1; }
		Fdisplay ^= (1 << i);
		if(i == 4) goto gocd1;
		goto redraw;
	case 0xFF00 :							// UP
	case 0xFE00 :
		i = j = 0;
		while(k = path[i]) {
			++i;
			if((k == '\\') && path[i])
				j = i; }
		if(!j) { message("Already to top level"); goto redraw; }
		path[j-1] = 0;
		goto gocd;
	case 0xFF01 :
	case 0xFE01 :							// Drive
		if(select_drive(path))
			goto gocd;
		goto redraw; }

	if(i >= 0xFE00)							// Menu item
		return i;

	pf = files[i & 0x7FFF];
	if(pf->FF_attrib & DIRECTORY) {
		for(i=0; path[i]; ++i);
		if(path[i-1] != '\\')
			strcat(path, "\\");
		strcat(path, pf->FF_name);
		goto gocd; }
	return i;
}

check_drive(d) asm
{
	MOV	AX,4409h
	MOV	BL,4[BP]
	INT	21h
	MOV	AX,-1
	JNC	ok
	XOR	AX,AX
ok:
}

select_drive(unsigned char *path)
{
	unsigned char *list[26];
	unsigned i, j;
	for(i=j=0; i < 26; ++i) {
		if(check_drive(i+1)) {
			list[j++] = pool + pool_top;
			pool[pool_top++] = i + 'A';
			add_pool(":"); } }
	list[j] = 0;
again:
	i=pen_menu(X, Y+1, 10, 5, WSAVE|0x34, "", -1, list);
	switch(i) {
	case 0xFFFF :
	case 0xFEFF : return 0; }
	if(i & 0x8000) goto again;
	strcpy(path, list[i & 255]);
	return -1;
}

xmessage(unsigned char **list)
{
	unsigned x, y, l, ll[25];
	unsigned char *p;
	for(y=x=0; p = list[y]; ++y) {
		if((l = ll[y] = strlen(p)) > x)
			x = l; }
	wopen((Width-x)/2-1, (Height-y)/2-1, x+2, y+2, WSAVE|WBOX1|WCOPEN|0x47);
	wcursor_off();
	for(l=0; l < y; ++l) {
		wgotoxy((x-ll[l])/2, l);
		wputs(list[l]); }
	mouse_status();
	wclose();
}
