/* The EN registers - the DS8390 chip registers */
/* There are two (really 3) pages of registers in the chip. You select */
/* which page you want, then address them at offsets 00-0F from base. */
/* The chip command register (EN_CCMD) appears in all pages. */

#define EN_CCMD			0x00	/* Chip's command register */

/* Page 0 */
#define EN0_CLDALO		0x01	/* Low byte of current local dma addr  RD */
#define EN0_STARTPG		0x01	/* Starting page of ring bfr WR */
#define EN0_CLDAHI		0x02	/* High byte of current local dma addr RD */
#define EN0_STOPPG		0x02	/* Ending page +1 of ring bfr WR */
#define EN0_BOUNDARY	0x03	/* Boundary page of ring bfr RD WR */
#define EN0_TSR			0x04	/* Transmit status reg RD */
#define EN0_TPSR		0x04	/* Transmit starting page WR */
#define EN0_NCR			0x05	/* Number of collision reg RD */
#define EN0_TCNTLO		0x05	/* Low byte of tx byte count WR */
#define EN0_FIFO		0x06	/* FIFO RD */
#define EN0_TCNTHI		0x06	/* High byte of tx byte count WR */
#define EN0_ISR			0x07	/* Interrupt status reg RD WR */
#define EN0_CRDALO		0x08	/* low byte of current remote dma address RD */
#define EN0_RSARLO		0x08	/* Remote start address reg 0 */
#define EN0_CRDAHI		0x09	/* high byte of current remote dma address RD */
#define EN0_RSARHI		0x09	/* Remote start address reg 1 */
#define EN0_RCNTLO		0x0A	/* Remote byte count reg WR */
#define EN0_RCNTHI		0x0B	/* Remote byte count reg WR */
#define EN0_RSR			0x0C	/* rx status reg RD */
#define EN0_RXCR		0x0C	/* RX control reg WR */
#define EN0_TXCR		0x0D	/* TX control reg WR */
#define EN0_COUNTER0	0x0D	/* Rcv alignment error counter RD */
#define EN0_DCFG		0x0E	/* Data configuration reg WR */
#define EN0_COUNTER1	0x0E	/* Rcv CRC error counter RD */
#define EN0_IMR			0x0F	/* Interrupt mask reg WR */
#define EN0_COUNTER2	0x0F	/* Rcv missed frame error counter RD */

/* Page 1 */
#define EN1_PHYS		0x01	/* This board's physical enet addr RD WR */
#define EN1_CURPAG		0x07	/* Current memory page RD WR */
#define EN1_MULT		0x08	/* Multicast filter mask array (8 bytes) RD WR */

/* Page 3 */
#define	EN3_CR			0x00
#define	EN3_9346CR		0x01
#define	EN3_BPAGE		0x02
#define EN3_CFG0		0x03	/* This board's physical enet addr RD WR */
#define	EN3_CFG1		0x04
#define	EN3_CFG2		0x05
#define	EN3_CFG3		0x06
#define	EN3_CFG4		0x0D

/* Bits in EN3_CFG - Configuration Register 0 */
#define ENCFG0_BNC		0x04	/* inhibit CRC, do not append crc */

/* Chip commands in EN_CCMD */
#define ENC_STOP		0x01	/* Stop the chip */
#define ENC_START		0x02	/* Start the chip */
#define ENC_TRANS		0x04	/* Transmit a frame */
#define ENC_RREAD		0x08	/* remote read */
#define ENC_RWRITE		0x10	/* remote write */
#define ENC_NODMA		0x20	/* No remote DMA used on this card */
#define ENC_PAGE0		0x00	/* Select page 0 of chip registers */
#define ENC_PAGE1		0x40	/* Select page 1 of chip registers */
#define ENC_PAGE3		0xC0	/* Select page 3 of chip registers */

/* Commands for EN0_RXCR - RX control reg */
#define ENRXCR_CRC		0x01	/* Save error pkts */
#define ENRXCR_RUNT		0x02	/* Accept runt pkt */
#define ENRXCR_BCST		0x04	/* Accept broadcasts */
#define ENRXCR_MULTI	0x08	/* Multicast (if pass filter) */
#define ENRXCR_PROMP	0x10	/* Promiscuous physical addresses */
#define ENRXCR_MON		0x20	/* Monitor mode (no packets rcvd) */

/* Bits in EN0_TXCR - transmit control reg */
#define ENTXCR_CRC		0x01	/* inhibit CRC, do not append crc */
#define ENTXCR_LOOP		0x02	/* Set loopback mode */
#define ENTXCR_LB01		0x06	/* encoded loopback control */
#define ENTXCR_ATD		0x08	/* auto tx disable */
#define ENTXCR_OFST		0x10	/* collision offset enable */

/* Bits in EN0_DCFG - Data config register */
#define ENDCFG_WTS		0x01	/* word transfer mode selection */
#define ENDCFG_BOS		0x02	/* byte order selection */
#define ENDCFG_LAS		0x04	/* long addr selection */
#define ENDCFG_BMS		0x08	/* burst mode selection */
#define ENDCFG_ARM		0x10	/* autoinitialize remote */
#define ENDCFG_FT00		0x00	/* burst length selection */
#define ENDCFG_FT01		0x20	/* burst length selection */
#define ENDCFG_FT10		0x40	/* burst length selection */
#define ENDCFG_FT11		0x60	/* burst length selection */

/* Bits in EN0_ISR - Interrupt status register */
#define ENISR_RX		0x01	/* Receiver, no error */
#define ENISR_TX		0x02	/* Transmitter, no error */
#define ENISR_RX_ERR	0x04	/* Receiver, with error */
#define ENISR_TX_ERR	0x08	/* Transmitter, with error */
#define ENISR_OVER		0x10	/* Receiver overwrote the ring */
#define ENISR_COUNTERS	0x20	/* Counters need emptying */
#define ENISR_RDC		0x40	/* remote dma complete */
#define ENISR_RESET		0x80	/* Reset completed */

#define ENISR_ALL		0x3F	/* Interrupts we will enable */

/* Bits in received packet status byte and EN0_RSR */
#define ENRSR_RXOK		0x01	/* Received a good packet */
#define ENRSR_CRC		0x02	/* CRC error */
#define ENRSR_FAE		0x04	/* frame alignment error */
#define ENRSR_FO		0x08	/* FIFO overrun */
#define ENRSR_MPA		0x10	/* missed pkt */
#define ENRSR_PHY		0x20	/* physical/multicase address */
#define ENRSR_DIS		0x40	/* receiver disable. set in monitor mode */
#define ENRSR_DEF		0x80	/* deferring */

/* Bits in EN0_TSR -  TX status reg */
#define ENTSR_PTX		0x01	/* Packet transmitted without error */
#define ENTSR_DFR		0x02	/* non deferred tx */
#define ENTSR_COLL		0x04	/* Collided at least once */
#define ENTSR_COLL16	0x08	/* Collided 16 times and was dropped */
#define ENTSR_CRS		0x10	/* carrier sense lost */
#define ENTSR_FU		0x20	/* TX FIFO Underrun */
#define ENTSR_CDH		0x40	/* collision detect heartbeat */
#define ENTSR_OWC		0x80	/* out of window collision */

/* Description of header of each packet in receive area of memory */
#define EN_RBUF_STAT	0		/* Received frame status */
#define EN_RBUF_NXT_PG	1		/* Page after this frame */
#define EN_RBUF_SIZE_LO	2		/* Length of this frame */
#define EN_RBUF_SIZE_HI	3		/* Length of this frame */
#define EN_RBUF_NHDR	4		/* Length of above header area */
