;
; Bare system startup code for interrupt demo.
; Set up System/Interrupt/User mode stacks and launch application
; in user mode.
; - Dave Dunfield - Oct 20, 2003
;
		KEEP
	IF		TS_DEBUG
;; Comment-Out the following definitions if you are building DEBUG
;; without the indicated debug features.
;; Don't forget to update OO_* definitions in OS.H
OO_TIME	EQU		255					; Real-Time monitor
	ENDIF

DRAMBEG	EQU		&00804000			; Data RAM beginning
DRAMEND	EQU		&02000000			; Data RAM end
HW_BASE	EQU		&80000000			; Hardware base address
S_STK_T	EQU		&6000C000			; Supervisor stack (top)
S_STK_L	EQU		&6000B100			; Supervisor stack (limit)
I_STK_T	EQU		&6000B000			; IRQ stack (top)
I_STK_L	EQU		&6000A100			; IRQ stack (limit)
O_STK_T	EQU		&6000A000			; OS stack (top)
O_STK_L	EQU		&60009100			; OS stack (limit)
INTSR1	EQU		&0240				; Offset to irq status
INTMR1	EQU		&0280				; Offset to irq mask
IRQSTS	EQU		&40000				; Offset to eirq mask
;
		IMPORT  __OSmain			; Startup address
		IMPORT	__OSpanic			; Panic debugger
		IMPORT	__OSentry			; Os entry point
		IMPORT	__OSdispatch_next	; Dispatches next task
		IMPORT	dividebyzero		; divide by zero exception
		IMPORT	OS_active_tcb		; Current task
		IMPORT	OS_eirq_mask		; External IRQ mask
		IMPORT	OS_irq_active		; Interrupt active flag
		IMPORT	IRQ_timer1			; Timer1 interrupt handler
		IMPORT	IRQ_timer2			; Timer2 interrupt handler
		IMPORT	IRQ_uart_tx			; Uart transmit interrupt
		IMPORT	IRQ_uart_rx			; Uart receive  interrupt
		IMPORT	IRQ_ethernet		; Ethernet interrupt
	IF		:DEF:OO_TIME
		IMPORT	OS_read_real_time	; Read timer
		IMPORT	OST_ibase			; Interrupt timer base
	ENDIF
		IMPORT	_etext				; Initialized data table
		IMPORT	_edata				; Zero data offset
;
		EXPORT	__rt_udiv, __rt_sdiv, __rt_udiv10, __rt_sdiv10
		EXPORT	__OSboot, __OSinitram, __OSenable, __OSdisable
		EXPORT	OS_swap, OS_call, __OSexit, __OSsystem, __OSinvtlb
		EXPORT	OS_panic, __OSreturn
	IF		TS_DEBUG
		IMPORT	__OSstackoverflow
		EXPORT	__rt_stkovf_split_small
		EXPORT	__rt_stkovf_split_big
	ENDIF

		AREA |$first|, CODE, READONLY

		ENTRY
; Interrupt vectors for EP7311
; ARM executes here for the indicated exceptions
__OSboot
		B		IRQrst				; 0000 reset
		B		IRQinst				; 0004 Undefined instruction
	IF	TS_DEBUG
		B		IRQswi				; 0008 Software interrupt
	ELSE
		B		__OSentry			; 0008 Software interrupt
	ENDIF
		B		IRQpre				; 000C Prefetch abort
		B		IRQdata				; 0010 Data abort
		B		IRQrst				; 0014 Reserved
		B		IRQirq				; 0018 IRQ
		B		IRQfiq				; 001C FIQ
; For all of these vectors - restart the system
; Note that since all of these events are "privleged" we can set the
; system mode in CPSR - if we wished to restart from user mode, we
; would have to implement an SWI call to the operating system
IRQpre	MVN		r13,#0				; Get FFFFFFFF
		MCR		p15,0,r13,c3,c0		; All domains = Manager
		LDR		sp,=&00800000		; Set abort stack
		STMDB	sp!,{r0-r12,r14}	; Save registers
		MOV		a1,#&0C
		B		doabort				; And proceed
IRQfiq	MVN		r13,#0				; Get FFFFFFFF
		MCR		p15,0,r13,c3,c0		; All domains = Manager
		LDR		sp,=&00800000		; Set abort stack
		STMDB	sp!,{r0-r12,r14}	; Save registers
		MOV		r0,#&1C
		B		doabort
IRQdata	MVN		r13,#0				; Get FFFFFFFF
		MCR		p15,0,r13,c3,c0		; All domains = Manager
		LDR		sp,=&00800000		; Set abort stack
		STMDB	sp!,{r0-r12,r14}	; Save registers
		MOV		r0,#&10				; Indicate data abort
		MRC		p15,0,r2,c6,c0,0	; Get violation address
; Process abort request - save machine state and launch panic debugger
; Entry: r0 = vector type, r2 = exception address
doabort	MRS		r5,SPSR				; Get SPSR
		MRS		r7,CPSR				; Get CPSR
		MOV		r1,sp				; Copy stack pointer
; Switch to FIQ mode and record SPSR,R8-R12,SP,LR
		BIC		r7,r7,#&1F			; Clear mode bits
		ORR		r7,r7,#&D1			; Disable IRQ,FIQ - enter FIQ
		MSR		CPSR,R7				; Move to FIQ mode
		MRS		r6,SPSR				; Get FIQ SPSR
		STMDB	r1!,{r6,r8-r14}		; Save FIQ SPSR,R8-R12,SP,LR
; Switch to IRQ mode and record SPSR,SP,LR
		BIC		r7,r7,#&1F			; Clear mode bits
		ORR		r7,r7,#&D2			; Disable IRQ, FIQ - enter IRQ
		MSR		CPSR,r7				; Move to IRQ mode
		MRS		r6,SPSR				; Get SPSR
		STMDB	r1!,{r6,r13,r14}	; Save IRQ SPSR,SP,LR
; Switch to SVC mode and record SPSR, SP, LR
		ORR		r7,r7,#&D3			; Disable IRQ, FIQ - enter SVC
		MSR		CPSR,r7				; Move to SVC mode
		MRS		r6,SPSR				; Get SVC SPSR
		STMDB	r1!,{r6,r13,r14}	; Save SVC SPSR,SP,LR
; Switch to SYSTEM mode and record USER SPSR,SP,LR
		ORR		r7,r7,#&DF			; Disable IRQ, FIQ - enter SYSTEM
		MSR		CPSR,r7				; Move to SYSTEM mode (USER access)
		MRS		r6,SPSR				; Get SPSR
		STMDB	r1!,{r5,r6,r13,r14}	; Save ABORT SPSR, USER SPSR,SP,LR
; r0=vector r1=stack r2=exception address (if applicable)
		MOV		sp,r1				; Reset stack
	IF		TS_DEBUG
		MOV		R10,#0
	ENDIF
		B		__OSpanic			; Launch panic debugger

;
; User PANIC entry
;
OS_panic
		STMDB	sp,{a1-a4}			; Save printf parameters (No SP update)
		DCD		&E7F000F0			; Illegal opcode to trigger exception
panop								; Address of panic abort

;
; Re-launch application program - Restore ARM state from stacked registers.
;
__OSreturn
		MRS		r7,CPSR				; Get CPSR
		ORR		r7,r7,#&DF			; Disable IRQ, FIQ - enter SYSTEM
		MSR		CPSR,r7				; Set mode
		LDMIA	r0!,{r5,r6,r13,r14}	; Get ABORT SPSR, USER SPSR,SP,LR
		MSR		SPSR,r6				; Set user SPSR
		BIC		r7,r7,#&0C			; Move to SVC
		MSR		CPSR,r7				; Set mode
		LDMIA	r0!,{r6,r13,r14}	; Get SVC SPSR,SP,LR
		MSR		SPSR,r6				; Set IRQ SPSR
		BIC		r7,r7,#&01			; Move to IRQ
		MSR		CPSR,r7				; Set mode
		LDMIA	r0!,{r6,r13,r14}	; Get IRQ SPSR,SP,LR
		MSR		SPSR,r6				; set IRQ SPSR
		BIC		r7,r7,#&0F			; Clear mode
		ORR		r7,r7,#&D1			; Move to FIQ
		MSR		CPSR,r7				; Set mode
		LDMIA	r0!,{r6,r8-r14}		; Get FIQ SPSR,r8-r12,sp,lr
		MSR		SPSR,r6				; Set FIQ SPSR
		ORR		r7,r7,#&17			; Set ABORT mode
		MSR		CPSR,r7				; Set mode
		MSR		SPSR,r5				; Restore SPSR
		MOV		sp,r0				; Set SP
		MOV		R0,#&00000001		; All domains = Client
		MCR		p15,0,r0,c3,c0		; Set C3 - Domain access bits
		LDMIA	sp!,{r0-r12,r14}	; Restore general registers
		SUBS	pc,lr,#0			; Restore & return

;
; Illegal instruction exception
;
IRQinst	MVN		r13,#0				; Get FFFFFFFF
		MCR		p15,0,r13,c3,c0		; Set C3 - Domain access bits
		LDR		r13,=panop			; Get panic address
		CMP		r13,r14				; Is this a panic abort?
		LDR		sp,=&00800000		; Set abort stack
		STMDB	sp!,{r0-r12,r14}	; Save registers
		MOVNE	a1,#&04				; No  - indicate illegal op
		MOVEQ	a1,#0				; Yes - indicate panic
		B		doabort				; and process abort

;
;
; Hardware reset
;
IRQrst	LDR		SP,=S_STK_T			; Establish supervisor stack
		MRS		r0,CPSR				; Get control register
		BIC		r0,r0,#&1F			; Clear mode bits
		ORR		r0,r0,#&D2			; Disable IRQ, FIQ - enter IRQ mode
		MSR		CPSR,R0				; Move to IRQ mode
		LDR		SP,=I_STK_T			; Establish IRQ stack
		BIC		r0,r0,#&8F			; Set to user mode, enable IRQ
		MSR		CPSR,R0				; Move to USER mode
		LDR		SP,=O_STK_T			; Establish USER stack
	IF	TS_DEBUG
		LDR		R10,=O_STK_L		; Establish USER limit
	ENDIF
		B		__OSmain			; Launch main program

;
; IRQ interrupt handler
; - Save ARM registers
; - Call C handler
; - Restore registers
; - return to adjusted PC
; ***NOTE1, interrupted CPSR is saved by ARM hardware
; ***NOTE2, You CANNOT allow nested interrupts, unless you save the
;           the interrupt registers - R13/R14 will be overwritten on
;           the second interrupt.
;           Interrupt from within SWI is OK, because SWI operates in
;           SUPERVISOR mode, which has it's own stack and link registers.
;
IRQirq
	IF		TS_DEBUG
		STMDB	sp!,{a1-a4,v1,r10,fp,ip,lr}
		LDR		R10,=I_STK_L			; Establish IRQ stack limit
	ELSE
		STMDB	sp!,{a1-a4,v1,ip,lr}
	ENDIF
		IF		:DEF:OO_TIME
;; Establish interrupt time
		BL		OS_read_real_time		; Read interrupt time
		LDR		a2,[pc, #__OStiba-.-8]	; Address OST_ibase
		STR		a1,[a2,#0]				; OST_ibase = OS_read_real_time
		ENDIF
;;Hardware Performance Testing
;;		LDR		v1,[pc,#OSmirror-.-8] ; Address mirror
;;		LDR		a1,=&10204000
;;		ORR		v1,v1,#&01			; Set bit
;;		STR		v1,[pc,#OSmirror-.-8] ; Address mirror
;;		STRB	v1,[a1,#0]			; Write I/O port
;
		MOV		a1,#HW_BASE			; Set hardware base
		LDR		a2,[a1,#INTSR1]		; Read interrupt status
		LDR		a3,[a1,#INTMR1]		; Get mask register
		LDR		a4,[pc,#__OSirqa-.-8] ; Address IRQ active flag
		MOV		a1,#255				; Get set value
		STRB	a1,[a4,#0]			; Set flag
		AND		v1,a2,a3			; Allow only unmasked interrupts
		TST		v1,#&0100			; Timer-1?
		BLNE	IRQ_timer1
		IF		:DEF:OO_TIME
		TST		v1,#&0200			; Timer-2
		BLNE	IRQ_timer2
		ENDIF
		TST		v1,#&2000			; Uart receive?
		BLNE	IRQ_uart_rx
		TST		v1,#&1000			; Uart transmit?
		BLNE	IRQ_uart_tx
		TST		v1,#&0020			; External?
		BEQ		noext
; External interrupt
		LDR		a2,[pc,#__OSirqs-.-8]	; Address EIRQ status
		LDR		a3,[pc,#__OSeirq-.-8]	; Address EIRQ mask
		LDR		a2,[a2,#0]			; Read EIRQ status
		LDR		a3,[a3,#0]			; Read EIRQ mask
		AND		v1,a2,a3			; Allow only unmasked interrupts
		MOVNE	a1,v1				; Copy for argument
		TST		v1,#&00100000		; 20: Ethernet
		BLNE	IRQ_ethernet
;
noext	LDR		a4,[pc,#__OSirqa-.-8] ; Address IRQ active flag
		MOV		a1,#0				; Get set value
		STRB	a1,[a4,#0]			; Set flag
;; Hardware Performance Testing
;;		LDR		v1,[pc,#OSmirror-.-8] ; Address mirror
;;		LDR		a1,=&10204000
;;		BIC		v1,v1,#&01			; Set bit
;;		STR		v1,[pc,#OSmirror-.-8] ; Address mirror
;;		STRB	v1,[a1,#0]			; Write I/O port
;
	IF		TS_DEBUG
		LDMIA	sp!,{a1-a4,v1,r10,fp,ip,lr}
	ELSE
		LDMIA	sp!,{a1-a4,v1,ip,lr}
	ENDIF
		SUBS	pc,lr,#4			; Return to caller

	IF	TS_DEBUG
;
; SWI handler - set stack limit and launch OS
;
IRQswi	LDR		R10,=S_STK_L		; Set OS stack limit
		B		__OSentry			; And launch
;
; Stack limit check failed
;
__rt_stkovf_split_small
__rt_stkovf_split_big
        ADD      a1,pc,#StkMsg-.-8
        B        OS_panic
StkMsg	DCB		"Stack Overflow"
		DCB		0,0
	ENDIF

;
; Initialize system RAM
; Copy constant data - then zero-init remainder
;
__OSinitram
		LDR		a1,=DRAMBEG		; Start of RAM
		LDR		a2,[pc,#__Text-.-8] ; Address of init data
		LDR		a3,[pc,#__Data-.-8] ; End of init data
iram1	LDR		a4,[a2],#4		; Get word from init
		STR		a4,[a1],#4		; Write to data
		CMP		a1,a3			; At end?
		BCC		iram1			; No, keep going
		LDR		a2,[pc,#__Wdog-.-8] ; Address watchdog		
		MOV		a3,#DRAMEND		; End of RAM
iram2	MOV		a4,#0			; Reset to zero
iram3	STR		a4,[a1],#4		; Write to RAM
		TST		a1,#&3FC		; At 1k boundary
		BNE		iram3			; No - keep going
		STR		a4,[a2,#0]		; Wack the dog
		CMP		a1,a3			; At end?
		BCS		iram4			; End - exit
		STR		a2,[a1,#0]		; Pattern-1
		STR		a3,[a1,#4]		; Pattern-2
		LDR		a4,[a1,#0]		; Get pattern-1
		CMP		a4,a2			; Match?
		BNE		iram4			; No exit
		LDR		a4,[a1,#4]		; Get pattern-2
		CMP		a4,a3			; Match
		BEQ		iram2			; Yes, continue
iram4	MOV		pc,lr

;
; Disable ARM interrupts globally
;
__OSdisable
		STMDB	R13!,{R0,R14}
		MRS		r0,SPSR			; Get control register
		ORR		r0,r0,#&80		; Set disable bit
		MSR		SPSR,r0			; Resave
		LDMIA	R13!,{R0,PC}	; Restore & return

;
; Enable ARM interrupts globally
;
__OSenable
		STMDB	R13!,{R0,R14}	; Save R0, lr
		MRS		r0,SPSR			; Get control register
		BIC		r0,r0,#&80		; Clear disable bit
		MSR		SPSR,r0			; Resave
		LDMIA	R13!,{R0,PC}	; Restore & return

;
; Invalidate MMU Translation Lookaside Buffer
; This is necessary when memory map or protection is changed.
; Must be executed in privileged state
;
__OSinvtlb
		MRC		p15,0,r0,c1,c0	; Get C1
		BIC		r0,r0,#&0100	; Clear 'S' error from BB
		ORR		r0,r0,#&1200	; Icache=1, RS=10
		ORR		r0,r0,#&00D		; Enable MMU, Dcache & Write buffer
		MCR		p15,0,r0,c1,c0	; rewrite C1
		MOV		R0,#&00000001	; All domains = Client
		MCR		p15,0,r0,c3,c0	; Set C3 - Domain access bits
		MCR		p15,0,r0,c8,c7,0 ; Invalidate TLBs
		MOV		pc,lr
;
;__OSgetsp
;		MOV		R0,R13
;		MOV		pc,lr
;__OSgetcpsr
;		MRS		R0,CPSR
;		MOV		pc,lr
;__OSgetspsr
;		MRS		R0,SPSR
;		MOV		pc,lr
;
; -- Operating system access stubs --
;
;
; Timeslice/Task swap
; !!! Important !!! - Make sure 'dispatch_next' does not corrupt R11
;
OS_swap	STMDB	sp!,{r0-r12,lr}			; Save user registers
		LDR		r11,[pc,#__OSatcb-.-8]	; Address current task pointer
		LDR		r0,[r11,#0]				; Get current task pointer
		STR		sp,[r0,#0]				; Save current task stack
		BL		__OSdispatch_next		; Dispatch next task
; Return to user task
;		LDR		r11,[pc,#__OSatcb-.-8]	; Address current task pointer
		LDR		r0,[r11,#0]				; Get current task pointer
		LDR		sp,[r0,#0]				; Restore task stack
		LDMIA	sp!,{r0-r12,pc}			; Restore registers & continue
;
; Launch user program
;
__OSexit
		LDR		sp,=&6000C000			; Restore SP
		MRS		R0,SPSR					; Get saved
		MSR		CPSR,R0					; Return to user
; Launch in supervisor mode (stop system)
__OSsystem
		LDR		a1,[pc,#__OSatcb-.-8]	; Address current task pointer
		LDR		a1,[a1,#0]				; Get current task pointer
		LDR		r13,[a1,#0]				; Restore task stack
		LDMIA	sp!,{r0-R12,pc}			; Restore registers & continue
;
; OS service call
;
OS_call	STMDB	sp!,{r0-r12,lr}			; Save user registers
		LDR		a1,[pc,#__OSatcb-.-8]	; Address current task pointer
		LDR		a1,[a1,#0]				; Get current task pointer
		STR		sp,[a1,#0]				; Save current task stack
		SWI		0						; Launch OS

;
; --- Below this line are compiler runtime support functions ---
;

; Unsigned divide of a2 by a1: returns quotient in a1, remainder in a2
; Destroys a4, ip and r5
__rt_udiv
		MOVS	a4, a1
		BEQ		dividebyzero
		STMFD	sp!,{ip,lr}
		MOV		ip, #0
		MOV		a3, #&80000000
		CMP		a2, a3
		MOVLO	a3, a2
udiv1	CMP		a3, a4
		MOVHI	a4,a4,ASL #1
		BHI		udiv1
udiv2	CMP		a2, a4
		ADC		ip, ip, ip
		SUBHS	a2, a2, a4
		CMP		a1, a4
		MOVLO	a4, a4, LSR #1
		BLO		udiv2
		MOV		a1, ip
	IF {CONFIG} = 26
		LDMFD	sp!,{ip,pc}^
	ELSE
		LDMFD	sp!,{ip,pc}
	ENDIF

; Calculate x / 10 as (x * 2**32/10) / 2**32.
; That is, we calculate the most significant word of the double-length
; product. In fact, we calculate an approximation which may be 1 off
; because we've ignored a carry from the least significant word we didn't
; calculate. We correct for this by insisting that the remainder < 10
; and by incrementing the quotient if it isn't.
__rt_udiv10
        MOV     a2, a1
__rt_udiv10a
        MOV     a1, a1, LSR #1
        ADD     a1, a1, a1, LSR #1
        ADD     a1, a1, a1, LSR #4
        ADD     a1, a1, a1, LSR #8
        ADD     a1, a1, a1, LSR #16
        MOV     a1, a1, LSR #3
        ADD     a3, a1, a1, ASL #2
        SUB     a2, a2, a3, ASL #1
        CMP     a2, #10
        ADDGE   a1, a1, #1
        SUBGE   a2, a2, #10
    IF      {CONFIG} = 26
        MOV.S    pc, lr
    ELSE
        MOV      pc, lr
    ENDIF

; Signed divide of a2 by a1: returns quotient in a1, remainder in a2
; Quotient is truncated (rounded towards zero).
; Sign of remainder = sign of dividend.
; Destroys a3, a4 and ip
; Negates dividend and divisor, then does an unsigned divide; signs
; get sorted out again at the end.
__rt_sdiv
        MOVS    a3, a1
        BEQ     dividebyzero            ; ip now unwanted
        STMFD   sp!,{ip,lr}
        RSBMI   a1, a1, #0              ; absolute value of divisor
        EOR     a3, a3, a2
        ANDS    ip, a2, #&80000000
        ORR     a3, ip, a3, LSR #1
        STMFD   sp!,{a3}
        ; saved a3:
        ;  bit 31  sign of dividend (= sign of remainder)
        ;  bit 30  sign of dividend EOR sign of divisor (= sign of quotient)
        RSBNE   a2, a2, #0              ; absolute value of dividend
        MOV     a3, a2
        MOV     a4, a1
        MOV     ip, #0
sdiv1	CMP     a3, a4
        MOVHI   a4, a4, ASL #1
        BHI     sdiv1
sdiv2   CMP     a2, a4
        ADC     ip, ip, ip
        SUBHS   a2, a2, a4
        CMP     a1, a4
        MOVLO   a4, a4, LSR #1
        BLO     sdiv2
        MOV     a1, ip
        LDMFD   sp!,{a3}
        MOVS    a3, a3, ASL #1
        RSBMI   a1, a1, #0
        RSBCS   a2, a2, #0
    IF {CONFIG} = 26
        LDMFD   sp!,{ip,pc}^
    ELSE
        LDMFD   sp!,{ip,pc}
    ENDIF

; Fast signed divide by 10: dividend in a1, divisor in a2.
; Returns quotient in a1, remainder in a2.
; Also destroys a3 and a4.
; Quotient is truncated (rounded towards zero).
; Make use of __rt_udiv10
__rt_sdiv10
		MOVS	a2,a1			; Test sign
		BPL		__rt_udiv10a	; Positive - normal udiv10
		MOV		a4,lr			; Save return address
		RSB		a1,a1,#0		; Negate operand
		BL		__rt_udiv10		; Normal divide
		RSB		a1,a1,#0		; Negate result
		RSB		a2,a2,#0		; Negate remainder
		MOV		pc,a4			; Return to caller

;
; --- Constant data area ---
;
__Text   DCD		_etext				; Initialized data table
__Data   DCD		_edata				; Beginning of zero-init data
__OSatcb DCD		OS_active_tcb		; Active Task Control Block
__OSeirq DCD		OS_eirq_mask		; External IRQ mask
__OSirqa DCD		OS_irq_active		; IRQ active flag
__Wdog   DCD		&100E0000			; Watchdog register
		IF		:DEF:OO_TIME
__OStiba DCD		OST_ibase			; Interrupt base time marker
		ENDIF
__OSirqs DCD		&30040000			; External interrupt status
;; Hardware Performance Testing
;;OSmirror DCD		0
		END
