/*
 * ArmOS external interrupts
 *
 * NOTES:
 *	1 - All interrupt sources on the top board require IRQ_TOPB to be ENABLED
 *		in order for the processor interrupt to occur.
 *
 *	2 - Status bit only, does NOT cause a processor interrupt.
 *
 * Dave Dunfield - 03/11/06
 */

#ifndef __IRQ_H_
	#define __IRQ_H_

	// Misc interrupts
	#define	IRQ_ETHERNET	0x00100000		// Ethernet interrupt -NOTE1

	// Index values used by the OS_irq_exit() function, which should
	// be called immediately before exiting any interrupt when the OO_TIME
	// (real-time-logging) macro is #defined
	#ifdef OO_TIME
		#define	XIRQ_timer1		0
		#define	XIRQ_timer2		1
		#define	XIRQ_uart_rx	3
		#define	XIRQ_uart_tx	4
		#define	XIRQ_network	5
	#endif
#endif
