/*
 * ArmOS - Library definitions
 *
 * Dave Dunfield - 98/10/04
 *	99/05/22 + memcmp, strncpy, strncat, strncmp, strbeg, strstr, abs, size_t
 *	03/11/03 - changed testc, getc, gets, printf to raw* diagnostic functions.
 *			 + Added new printf, Dprintf for official console output
 *  03/12/08 - Added strupr
 *			 + Improved parse() functionality
 *			 + Fixed rawgets() to enforce length
 *	04/01/22 - Modified _format_ to be bounded
 *			 + Added snprintf()
 *			 + Added "safe" OS functions.
 */

#ifndef __LIBRARY_H_
	#define	__LIBRARY_H_

	// I/O functions
	void rawputc(unsigned char c);
	void rawputs(void *string);
	unsigned rawtestc(void);
	unsigned rawgetc(void);
	unsigned rawgets(unsigned char *dest, unsigned length);
	void rawprintf(const char *format, ...);
	void printf(const char *format, ...);
	void Dprintf(unsigned mask, const char *format, ...);
	void Eprintf(unsigned char attr, const char *format, ...);
	unsigned testc(void);
	
	// Memory manipulation
	void byteset(void *dest, unsigned char value, unsigned size);
	void wordset(void *dest, unsigned value, unsigned size);
	void memset(void *dest, unsigned char value, unsigned size);
	void bytecpy(void *dest, const void *source, unsigned size);
	void wordcpy(void *dest, const void *source, unsigned size);
	void memcpy(void *dest, const void *source, unsigned size);
	int memcmp(const void *block1, const void *block2, unsigned size);
	
	// String manipulation
	unsigned strlen(const void *string);
	unsigned char *strcpy(void *dest, const void *source);
	unsigned char *strcat(void *dest, const void *source);
	int strcmp(const void *string1, const void *string2);
	unsigned char *strncpy(void *dest, const void *source, unsigned length);
	unsigned char *strncat(void *dest, const void *source, unsigned length);
	int strncmp(const void *string1, const void *string2, unsigned length);
	int strbeg(const void *string1, const void *string2);
	unsigned char *strstr(const void *string1, const void *string2);
	unsigned sprintf(void *output, const char *format, ...);
	unsigned snprintf(void *output, unsigned len, const char *format, ...);
	unsigned _format_(char *output, unsigned len, const char *format, unsigned *optr);
    int strncmptok(const void *string1, const void *string2, unsigned length, const char token);
	
	// Math
	int abs(int value);
	
	// User interface/parsing
	unsigned atoi(const void *source);
	unsigned atox(const void *source);
	unsigned char skip_blanks(unsigned char **source);
	unsigned parse(unsigned char **source, void *dest, unsigned size);
	int parse_number(unsigned char **source, unsigned *dest, unsigned char hex);
	void strupr(void *string);
	
	typedef unsigned int size_t;
	typedef void (*PFV)(unsigned x);		// ((PFV)LOADADR)();
	
	// "Safe" OS functions
	struct MESSAGE *SOS_msg_small(void);
	struct MESSAGE *SOS_msg_medium(void);
	struct MESSAGE *SOS_msg_large(void);
	void SOS_msg_release(struct MESSAGE *m);
	unsigned SOS_msg_send(unsigned Tid, struct MESSAGE *m, unsigned char pid);
	void SOS_proc_signal(unsigned signal, unsigned value);
	void SOS_irq_set(unsigned mask);
	void SOS_irq_clear(unsigned mask);
	void SOS_console_tx(struct MESSAGE *m);
	void SOS_ethernet_tx(unsigned char *p, unsigned size);
	void SOS_bls(unsigned mask);
	void SOS_blc(unsigned mask);
	void SOS_tls(unsigned mask);
	void SOS_tlc(unsigned mask);

//
	void Iprintf(unsigned mask, const char *format, ...);
#endif	
