/*
 * --- Hardware Interface: Code Flash
 */
#include "hardware.h"
#include "os.h"

//	MEMCFG1	%1010,1100,0000,1101,0000,1111,0000,1101
//#define	FM32	MEMCFG1 = 0xAC0D0F0D	// Flash in 32 bit mode
//#define	FM16	MEMCFG1	= 0xAC0D0F0C	// Flash in 16 bit mode
#define	FM32	MEMCFG1 = 0x1819970D	// Flash in 32 bit mode
#define	FM16	MEMCFG1	= 0x1819970C	// Flash in 16 bit mode
#define	FLASH	0xC0000000				// Flash base address

// Read word from flash memory
static unsigned READ(unsigned a)
{
	if(a & 2)
		return (*(unsigned*)a >> 16);
	return *(unsigned*)a & 0xFFFF;
}

// Write word to flash memory
static void WRITE(unsigned a, unsigned d)
{
	d &= 0xFFFF;
	*(unsigned*)a = (d << 16) | d;
}

// Write command to flash memory block
static void CWRITE(unsigned a, unsigned c)
{
	WRITE(FLASH+(0x555*2), 0xAA);
	WRITE(FLASH+(0x2AA*2), 0x55);
	WRITE(a, c);
}

// Reset flash device
static void flash_reset(void)
{
	FM32;
	CWRITE(FLASH, 0xF0);
}

// Wait for flash device
static int flash_wait(unsigned a, unsigned w)
{
	unsigned i;
unsigned x;
	i = 0;
	do {
		if(!(i & 0xFF))
			OS_swap();
		if((x = READ(a)) == w)
			return 0; }
	while(++i < 0x100000);
//printf("[%08x]", x);
	return -1;
}

// Erase flash block
int flash_erase_block(unsigned a)
{
	unsigned r;
	r = 5;
top:
	flash_reset();
	CWRITE(FLASH+(0x555*2), 0x80);
	CWRITE(a, 0x30);
	if(flash_wait(a, 0xFFFF)) {
		if(--r) goto top;
		FM16;
		return -1; }
	FM16;
	return 0;
}

// Program a block of flash memory
int flash_program_block(unsigned a, unsigned b, unsigned l)
{
	unsigned r, w, *bp;
	bp = (unsigned*)b;
	flash_reset();
	if(l /= 4) do {
		r = 5;
	retry1:
		CWRITE(FLASH+(0x555*2), 0xA0);
		WRITE(a, w = *bp & 0xFFFF);
		if(flash_wait(a, w)) {
			if(--r) goto retry1;
			FM16;
			return -1; }
		a += 2;
		r = 5;
	retry2:
		CWRITE(FLASH+(0x555*2), 0xA0);
		WRITE(a, w = *bp >> 16);
		if(flash_wait(a, w)) {
			if(--r) goto retry2;
			FM16;
			return -1; }
		a += 2;
		++bp; }
	while(--l);
	FM16;
	return 0;
}
