// BLD
#include <stdio.h>

#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	POOL		8192
#define	O_DOS		0x01
#define	O_DVM		0x02
#define	O_COMPAK	0x04
#define	O_UPDT		0x08
#define	O_GO		0x10
#define	O_TEMP		0x40
#define	O_SETENV	0x80

#define	T_CHTI		0x01		// Internal
#define	T_CHTM		0x02		// .COM
#define	T_CHTB		0x03		// Both ""
#define	T_HELP		0x04
#define	T_BUILD		0x08

unsigned
	Sh, Sl, At, Ti, Da, Ti1, Da1,
	Fn, Fe,
	A7,
	Line,
	Ptop;
FILE
	*fp,
	*fpo;
unsigned char
	*Ptr,
	*CCdos = "cc %s -pof m=T",
	*CCdvm = "ccf %s -poft",
	Opt,
	GoFlag,
	Type,
	Buffer[256],
	Name[128],
	Pool[POOL+1];

/* unsignd char
	___1[] = { 0xA7, 64, 64, 0 },
	DosDir[64] = { "Y:\\CMDS" },
	DvmDir[64] = { "V:\\DVMGO" },
	___2  = 0xA7; */

//ChtTxt R:\Help.H
#include "R:\\Help.H"

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}

void Close(void)
{
	if(fpo) {
		fclose(fpo);
		fpo = 0; }
}

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	if(Line) printf("%u: ", Line);
	Ps(buf);
	Close();
	exit(-1);
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

register Padd(unsigned args)
{
	unsigned t, *ptr;
	unsigned char buf[128];
	t = *(ptr = (nargs() - 1) * 2 + &args);
	_format_(ptr, buf);
	Debug(("Pa%02x'%s'\n", t, buf))
	Pool[Ptop++] = t;
	Pstring(buf);
}
unsigned Tst(unsigned char *p, unsigned char b)
{
	switch(Ptr[1]) {
	default	:	goto rz;
	case '/':
	case '*':	; }
	if(strbeg(Ptr+2, p)) {
		Ptr += (strlen(p) + 2);
		Type |= b;
		return 255; }
rz:	return 0;
}

register System(unsigned args)
{
	unsigned char *p, buf[128];
	_format_(nargs()*2+&args, buf);
	if(*(p = buf) == '!')
		++p;
	else {
		Ps(">'");
		Ps(p);
		Ps("'\n"); }
	if(!fpo) error("?fpo");
	fputs(p, fpo);
	putc('\n', fpo);
}

unsigned TstGo(unsigned char t)
{
	unsigned char c, o;
	o = 0;
a1:	switch(c = *Ptr++) {
	case 'A':	c = O_DOS|O_DVM;	goto a2;
	case 'D':	c = O_DOS;			goto a2;
	case 'U':	c = O_UPDT;			goto a2;
	case 'V':	c = O_DVM;			goto a2;
	case 'C':	c = O_COMPAK;
a2:		o |= c;
		goto a1;
	default	:
a3:		if((c < ' ') || (c > '~'))
			c = '?';
		error("//Build'%c'", c);
	case ' ':
	case'\t':	; }
	if(!o)
		goto a3;
	Skip(); Trim();
	return o & t;
}

unsigned File(void)
{
	unsigned i;
	Fn = i = 0;
a1:	Fe = 0;
a2:	switch(Name[i++]) {
	case ':':
	case'\\':	Fn = i;	goto a1;
	case '.':	Fe = i;
	default	:			goto a2;
	case 0	:	; }
	return i;
}

void Build(void)
{
	unsigned i;
	unsigned char c, Opt1;
	Opt1 = (Opt | O_GO);
	Ptop = A7 = Type = 0;
	i = File();
	if(!Fe)	Fe  = i;
	strcpy(Name+Fe-1, ".C");
	Debug(("Bld'%s'\n", Name))

	fp = fopen(Name, "rvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		++Line;
		while(*Ptr) {
			if(strbeg(Ptr++, "0xA7"))
				++A7; }
		if(*Buffer == '/') {
			Ptr = Buffer;
			if(Tst("ChtTxt",	T_CHTI))	continue;
			if(Tst("ChtCom",	T_CHTM))	continue;
			if(Tst("HelpTxt",	T_HELP))	continue;
			if(Tst("Build",		T_BUILD))	{
				c = TstGo(0xFF);
				Debug(("Pb%02x'%s'\n", c, Ptr))
				Pool[Ptop++] = c;
				Pstring(Ptr); } } }
	fclose(fp); Line = 0;
	Debug(("Type=%04x A7=%u\n", Type, A7))

	if(Type & (T_CHTI|T_CHTM)) {
		if(Type & T_HELP)
			error("Conflicting 'ChtTxt' and 'HelpTxt'");
		if(!(Opt & O_DOS))
			Type &= ~T_CHTM;
		if(Opt & O_DVM)
			Type |= T_CHTI; }

	if(A7) {
		Debug(("!A7"))
		Opt1 ^= O_COMPAK; }

	Debug(("[%u %x]", Ptop, Opt))
	if(!Ptop) {
		Name[Fe-1] = 0;
		Ptr = Name+Fn;
		if(Type & T_CHTI)
			Padd(O_DOS, "cht %s -C", Ptr);
		if(Type & T_HELP)	Padd(O_GO, "cht %s -C -Shelp", Ptr);
		if(Opt & O_SETENV)
			Padd(O_DOS, "set MCDIR=C:\\MC");
		Padd(O_DOS, CCdos, Ptr);
		if(Type & T_CHTB)
			Padd(O_DVM, "cht %s -C -M", Ptr);
		if(Opt & O_SETENV)
			Padd(O_DVM, "set MCDIR=V:\\DVMGO");
		Padd(O_DVM, CCdvm, Ptr);
		if(Opt & O_SETENV)
			Padd(O_DOS, "set MCDIR=C:\\MC");
		if(Type & T_CHTM)
			Padd(O_DOS, "cht %s -C -M%s", Ptr, Ptr);
/*ChtTxt Bhelp
Build can be controlled by "special" source comments: //Build<flgs> command
	<flgs> are 'D'U'V'C' options: -Dos -Update -dVm -Compak
	Command will be performed if correspoding option was specified:
if no //Build comments, assumes:

if//ChtTxt		CHT name -C [-Shelp (if //HelpTxt)]
 	-DE			SET MCDIR=C:\MC
	-D			CC name -POF M=T
if//ChtCom -D	CHT name -C -Mname
if//ChtCom -V	CHT name -C -M
	-VE			SET MCDIR=V:\\DVMGO
	-V			CCF name -POFT
	-VE			SET MCDIR=C:\MC
	-DC			COMPAK name
	-DT			CP name.COM R:\name.COM
	-DU			CP name.com Y:\\Cmds\\name.COM
	-VU			CP R:\name.dvm v:\\DVMGO\name.DVM
	-DU			DEL name.COM
	-VU			DEL R:\name.dvm
*/
		Padd(O_DOS|O_COMPAK,"compak %s", Ptr);
		Padd(O_DOS|O_TEMP,	"cp %s.COM R:\\%s.COM", Ptr, Ptr);
		Padd(O_DOS|O_UPDT,	"cp %s.COM Y:\\CMDS\\%s.COM", Ptr, Ptr);
		Padd(O_DVM|O_UPDT,	"cp R:\\%s.DVM V:\\DVMGO\\%s.DVM", Ptr, Ptr);
		Padd(O_DOS|O_TEMP,	"del %s.COM", Ptr);
		Padd(O_DOS|O_UPDT,	"del %s.COM", Ptr);
		Padd(O_DVM|O_UPDT,	"del R:\\%s.DVM", Ptr);
	}

	Debug(("Ptop=%u Opt=%02x%02x\n", Ptop, Opt, Opt1))
	i = 0;
	while(i < Ptop) {	//?
		c = Pool[i++];
		Ptr = Pool+i;
		while(Pool[i++]);
		Debug(("%02x&%02x %02x'%s'\n", Opt1, c, Opt1&c, Ptr))
		if((Opt1 & c) == c) {
			Debug(("%02x%02x%02x", Opt1, Opt1 & c, c))
			System(Ptr); } }
}

void SetEnv(void)
{
	if(!getenv("PATH", Ptr = Buffer)) error("?PATH");
	strupr(Buffer);
	while(*Ptr) {
		if(strbeg(Ptr++, "V:\\DVM"))
			goto a1; }
//				 Y:\\Cmds;Y:\\TCMDS;Z:\\;C:\\;C:\\mc;Y:\\
//PATH Y:\Cmds;R:\;V:\DVM;V:\Cmds;Z:\;C:\;C:\MC;W:\DOSTC
	System("!PATH Y:\\Cmds;R:\\;V:\\DVM;V:\\Cmds;Z:\\;C:\\;C:\\MC;W:\\TC;U:\\Cmds");
a1:	if(!getenv("MCCF", Buffer))
		System("!set MCCF=V:\\DVM");
}

void Remove1(void)
{
	strcpy(Buffer+Sl, Name+Fn);
	if(fp = fopen(Buffer, "rv")) {
		fclose(fp);
		printf("Rm'%s'? ", Buffer);
a1:		switch(kbget()) {
		default	:	goto a1;
		case 0x1B:	error("Abort");
		case 'n':
		case 'N':	Ps("N\n");	return;
		case 'y':
		case 'Y':	Ps("Y\n");
			if(delete(Buffer))
				Ps("Failed!\n"); } }
}
void Remove2(unsigned char *p)
{
	unsigned char c;
	Sl = c = 0;
	while(*p)
		Buffer[Sl++] = c= *p++;
	switch(c) {
	default	:	Buffer[Sl++] = '\\';
	case ':':
	case'\\':	;	}
}
void Remove(void)
{
	unsigned i;
	strcpy(Name, Ptr);
	i = File()-1;
	if(Opt & O_DOS) {
		Remove2("Y:\\CMDS");
		if(!Fe) {
			strcpy(Name+i, ".COM");
			Remove1();
			strcpy(Name+i, ".EXE"); }
		Remove1(); }
	if(Opt & O_DVM) {
		Remove2("V:\\DVMGO");
		if(!Fe)
			strcpy(Name+i, ".DVM");
		Remove1(); }
	return;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	for(i=1; i < argc; ++i) {
		switch(*(Ptr = argv[i])) {
		case '?': ++Ptr;
he0:		switch(toupper(*Ptr)) {
			case 'B':	Ptr = Bhelp; goto he1;
			}
he:			Ptr = Mhelp;
he1:		while(c = *Ptr++) {
				if(c & 0x80) {
					while(c-- & 0x7F)
						Pc(' ');
					continue; }
				Pc(c); }
			return;
		case '-':
		case'//':	++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
			case '?':	goto he0;
/*ChtTxt Mhelp
BuiLD for Dos&dVm with possible Help

use:	BLD program... [options]

opts:	-C		force Compak .COM
		-D		build Dos
		-E		set MCDIR env
		-G		Go (do it)
		-R		Remove program from Y:\CMDS and V:\DVMGO
		-U		Update Y:\CMDS & V:\DVMGO
		-V		build dVm
		-S		Small model
		-T		make Temp on R:\

	for Build control details: BLD -?B

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'S':
				CCdos = "cc %s -pof m=S";
				CCdvm = "ccf %s -pof";
				break;
			case 'R':	GoFlag = 0x5F;	break;
			case 'C':	c = O_COMPAK;	goto o2;
			case 'D':	c = O_DOS;		goto o2;
			case 'E':	c = O_SETENV;	goto o2;
			case 'G':	c = O_GO;		goto o2;
			case 'V':	c = O_DVM;		goto o2;
			case 'T':	c = O_TEMP;		goto o2;
			case 'U':	c = O_UPDT;
o2:				Opt |= c; }
			if(*Ptr) goto o1;
			continue; }
		GoFlag |= 15; }
	if(!(Opt & (O_DOS|O_DVM)))
		Opt |= (O_DOS|O_DVM);
	Opt ^= O_COMPAK;
	Debug(("Opt=%02x Gf=%u\n", Opt, GoFlag))

	if(GoFlag == 0x5F) {
		for(i=1; i < argc; ++i) {
			if(*(Ptr = argv[i]) != '-')
				Remove(); }
		return; }

	if(!GoFlag) {	// No files supplied
		if(find_first("*.C", 0, Buffer, &Sh, &Sl, &At, &Ti, &Da)) {
			Ps("No .C files!\n\n");
			goto he; }
		do {
			if(Da > Da1)	goto a1;
			if(Da < Da1)	continue;
			if(Ti >= Ti1)	{
a1:				Da1 = Da; Ti1 = Ti;
				strcpy(Name, Buffer); } }
		while !find_next(Buffer, &Sh, &Sl, &At, &Ti, &Da);
		Debug(("Lc'%s'\n", Name)) }

	fpo = fopen("R:\\$BLD$.BAT", "wvq");
	System("!@echo OFF");
	SetEnv();
	if(GoFlag) {
		for(i=1; i < argc; ++i) {
			switch(*(Ptr = argv[i])) {
			default	:
				strcpy(Name, Ptr);
				Build();
			case '-':
			case'\\':	; } } }
	else
		Build();
	Close();
	if(Opt & O_GO) {
		system("R:\\$BLD$");
		return; }
	printf("Use -G or execute R:\\$BLD$.BAT\nfor help: BLD ?\n");
}
///BuildA Cht bld
///BuildD Cc bld -pof
///BuildV Ccf bld -pof
///BuildD Compak bld
///BuildDU Cp bld.com Y:\Cmds
///BuildVU Cp R:\bld.dvm  V:\DVMGO
