// Compile and auto-edit errors
#include <stdio.h>
#include <window.h>

#define	CMDS	10			// Maximum number of commands
#define	EMATCH	10			// Maximum number of error matchs
#define	CFILE	10			// Maximum number of config files
#define	ERR		25			// Maximum # errors
#define	BDSTK	32			// Brace depth stack

#define	MSIZE	23			// Lines
#define	MWIDTH	(79-7)		// Columns
#define	MNOR	0x17		// Normal
#define	MAT1	0x16		// Attention1
#define	MHIL	0x71		// Hilite
#define	MSEL	0x1C		// Selected
#define	ENOR	0x67		// Error

unsigned
	D,					// Date of file
	T,					// Time of file
	S,					// SizeLow of file
	L,					// Length of filename
	Line,				// Line position on file
	Mline,				// Maximum line in file
	Tab = 4,			// Tab width
	Bdepth,				// {} depth
	FileB,				// Bdepth at line
	Outp,				// Output position
	Start,				// Start position of line
	FileH,				// File position high
	FileL,				// File position low
	Etop,				// Error line top
	Esel,				// Error line selected
	CDtop,				// Config data top
	CMtop,				// Top of commands
	CFtop,				// Top of file list
	EMtop,				// Top of error match
	BDsp,				// Brace depty stack pointer
	BDstk[BDSTK],		// Brace depth stack
	Eline[ERR];			// Error lines
FILE
	*fp;
unsigned char
	*Ptr,				// General pointer
	*Fname,				// Filename
	*Fext,				// File extension
	*FNext = ".C",		// Extension assumed
	*CMlist[CMDS],		// Command list
	*CFlist[CFILE],		// Config file list
	*EMlist[EMATCH],	// Error match list
	*Sname,				// Section name
	*Ofile,				// Error output file
	RbF,				// Rebuild Flag
	F,					// Global Flag
	Of,					// Output flag
	Mode,				// File scan mode
	NoDepth = 255,		// Disable {} depth display
	DoEdit = 255,		// Disable initial edit
	FileM,				// Stored Mode at top of screen
	Name[64],			// Filename to edit
	Edit[128],			// Edit command
	Recomp[128],		// Recompile comment
	Buffer[256],		// General Buffer
	Temp[128],			// Temp buffer
	Etext[ERR][81],		// Error text
	CDbuffer[4096];		// Config Data Buffer
struct WINDOW
	*Mwin,
	*Ewin;
//ChtArg -E`
#include "R:\\Help.h"

// Report error and terminate
register error(unsigned args)
{
	unsigned char buf[256];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
	putc('\n', stdout);
	exit(-1);
}

// Skip to non-blank
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

// Process path name to find directory and extension
unsigned char *Ext(unsigned char *fn)
{
	unsigned char *p;

	skip();
	Fname = p = fn;
	Fext = 0;
a1:	switch(*p++) {
	case ':' :
	case '\\': Fname = p;	Fext = 0;
	default	:				goto a1;
	case '.' : Fext = p;	goto a1;
	case 0 : ; }
	if(!Fext) Fext = p-1;
	return Fext;
}

// Store data in config buffer
unsigned char *CData(unsigned char *p)
{
	unsigned char *p1;
	p1 = CDbuffer+CDtop;
	do {
		if(CDtop >= sizeof(CDbuffer))
			error("?Config data full"); }
	while(CDbuffer[CDtop++] = toupper(*p++));
	return p1;
}
	
extern char *ARGV[];
// Open command config file with same name as command and specified extension:
//	Tries:	.\<command>.ext
//			%DDCDATA%\<command>.ext
//			<command executable part>\<command>.ext
// If ext has leading '!' then error occurs on last attempt, otherwise
// returns 0 if file could not be opened.
FILE *CmdOpen(unsigned char *ext)
{
	FILE *fp;
	unsigned char c, d, *p;
	if(!(d = *ext-'!')) ++ext;
	strcpy(Ext(ARGV[0]), ext);
	if(fp = fopen(Fname, "r")) goto ex;
	if(getenv("DDCDATA", Ptr = Buffer)) {
		skip(); p = Ptr;
		while(*p) c = *p++;
		switch(c) {
		default: *p++ = '\\';
		case '\\':
		case ':' : ; }
		strcpy(p, Fname);
		if(fp = fopen(Ptr, "r")) goto ex; }
	fp = fopen(ARGV[0], d ? "r" : "rvq");
ex:	return fp;
}

// Get line from screen
unsigned getline(unsigned char *dest, unsigned l)
{
	unsigned i;

	l *= 160;
	i = 0;
	do {
		dest[i++] = peek(W_BASE, l);
		l += 2; }
	while(i < 80);
	while(i && isspace(dest[i-1]))
		--i;
	dest[i] = 0;
	return i;
}

// Print character with tabs & screen width
void pc(unsigned char c)
{
	if(c < ' ') {
		if(c == '\t') {
			do { pc(' '); } while(Outp % Tab);
			return; }
		c = 0xA8; }
	if(Outp++ > (Start+MWIDTH))	return;
	if(Outp <= Start)			return;
	wputc(c);
	return 0;
}

// printf() using pc()
register pprintf(unsigned args)
{
	unsigned char *p, buf[128];
	_format_(nargs()*2+&args, p=buf);
	while(*p) pc(*p++);
}

// Show a C line
void show(void)
{
	unsigned c, d;
	unsigned char *p, a;
	if(skip() == '#') {
		++Ptr;
		if(strbeg(Ptr, "if")) {
			if(BDsp >= BDSTK)
				error("?BDstkOver");
			BDstk[BDsp++] = Bdepth;
			goto ex; }
		if(strbeg(Ptr, "el")) {
			if(BDsp)
				Bdepth = BDstk[BDsp-1];
			goto ex; }
		if(strbeg(Ptr, "endif")) {
			if(BDsp)
				--BDsp; } }
ex:	p = Buffer;
	while(c = *p++) {
		d = *p;
		if(c != '\\') switch(Mode) {
			case 1 :	if(c == '\'')				m0: Mode = 0;break;	// '
			case 2 :	if(c == '"' )					goto m0; break;	// "
			case 3 :	if(!d)							goto m0; break;	// //
			case 4 :	if((c == '*') && (d == '/'))	goto m0; break;	// /*
			default:	switch(c) {		// Normal
				case '{' :
				case '}' :
					if(NoDepth) break;	// Depth display disabled
					a = *Mwin; *Mwin = MAT1;
					if(Bdepth & 0x8000) Bdepth = 0;
					if(c == '{')
						pprintf("{%u", ++Bdepth);
					else
						pprintf("%u}", Bdepth--);
					*Mwin = a;
					continue;
				case '\'': Mode = 1;							break;
				case '"' : Mode = 2;							break;
				case '/' : switch(d) {
					case '/' : Mode = 3;						break;
					case '*' : Mode = 4; } } }
		pc(c); }
	if(Mode == 3) Mode = 0;
}

// Go to line in file
void filego(void)
{
	unsigned l;
	rewind(fp); l = 0;
	Mode = Bdepth = BDsp = 0;
	Outp = 50000;
	while(l < Line) {
		if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
			Mline = Line = l;
			break; }
		show();
		++l; }
	ftell(fp, &FileH, &FileL);
	FileM = Mode;
	FileB = Bdepth;
	ftell(fp, &FileH, &FileL);
	FileM = Mode;
	FileB = Bdepth;
}

// Redraw view screen
redraw()
{
	unsigned y;

	fseek(fp, FileH, FileL, 0);
	Mode = FileM;
	Bdepth = FileB;
	y = 0;
	while(y < MSIZE) {
		wgotoxy(0, y);
		if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
			wcleow();
			*Mwin = MHIL;
			wputs("[EOF]");
			*Mwin = MNOR;
			break; }
		*Mwin = ((Line+y) == Eline[Esel]) ? MSEL : MNOR;
		wprintf("%5u: ", ++y + Line);
		wcleol();
		Outp = 0; show();
		*Mwin = MNOR; }
	w_gotoxy(0, 0, Ewin);
	if(Esel < Etop) {
		w_printf(Ewin, "%u ", Eline[Esel]);
		w_puts(Etext[Esel], Ewin); }
	w_cleow(Ewin);
}

// Display help command
void help(unsigned char *p, unsigned char f)
{
	unsigned char c;
    while(c = *p++) {
        if(c & 0x80) {
            while(c-- & 0x7F) {
				if(f)
					wputc(' ');
				else
	                putc(' ', stdout); }
            continue; }
		if(f)
			wputc(c);
		else {
			if((c >= 0x1A) && (c <= 0x1B))
				c -= 0x0A;
	        putc(c, stdout); } }
	if(!f) exit(-1);
}

/*ChtTxt R:\Help
edit/Compile newest C Code.

use:	ccc [file] [options]

opts:	/name		Select INI settings to use				[first]
		.=ext		set assumed extension						[C]
		.E			skip initial Edit
		.T			skip initial Time check
		?I			help with INI file
		?S			help with INI text substitution
		?V			help with interactive Viewer

?COPY.TXT 2020 Dave Dunfield.
*/
void CmdArg(void)
{
	unsigned i;
	unsigned char c;
	i = toupper(*Ptr++) << 8;
	switch(toupper(*Ptr++) | i) {
	case '-?' :
	case '/?' :	goto h1;
	case '?I' : Ptr = INIhelp;	goto h2;
	case '?S' : Ptr = SUBhelp;	goto h2;
	case '?V' : Ptr = VIEhelp;	goto h2;
	case '.=' : FNext = CData(Ptr-1); *FNext = '.';	return;
	case '.E' : c = 0xF0;		goto eo;
	case '.T' : c = 0x0F;		eo:
		DoEdit &= c;
		return;
	} switch(i >> 8) {
	case '?' : h1: Ptr = Help; h2: help(Ptr, 0);
	case '-' :
	case '/' :
		Sname = CData(Ptr-1);						return;
	} if(*Name) goto h1;
	strcpy(Name, Ptr-2);
}

// Outout character with control
void Oc(unsigned char c)
{
	if(!(Of & 0x80)) *Ptr++ = c;
}
// Of: 0=Normal 1=SetMatch 2=Cmd
unsigned char *CmdSub(unsigned char *p)
{
	unsigned char c, l, d, *p1, buf[8];
	l = 0;
	Ptr = Buffer;
a1:	d = 0;
/*ChtTxt SUBhelp
INI text substitution:

The following special characters can be used in CCC.INI text:

	~F	Full filename
	~N	file Name only (no extenson)
	~E	file Extension only
	~L	insert Lower case (normally Upper)
	~U	resume Upper case
	~#	M: scan for line number	E: insert line number of selected error
	~R	M: Indicates error might be transient and compile should be retried
		   after the R: command - only does this once per compile attempt.
	~[	E: begin conditional (only if an error line)
	~]	E: end conditional section
	~;	M: stop looking, match if up to here
	~~	insert single '~'
*/
	switch(c = *p++) {
	case '~' : switch(toupper(c = *p++)) {
		default: a3: error("?bad ~%c", c);
		case 'F' : p1 = Name;	goto a2;	// Full fine name
		case 'N' : p1 = Name;	d = '.';	// Name only
a2:			while((c = *p1++) != d) {
				if(!c) break;
				c = l ? tolower(c) : toupper(c);
				Oc(c); }
			goto a1;
		case 'E' : p1 = Fext;	goto a2;	// Extension only
		case 'L' : l = 15;		goto a1;	// Lower case
		case 'U' : l = 0;		goto a1;	// Upper case
		case '#' :							// Number
			switch(Of & 0x7F) {
			default: goto a3;
			case 1 : c = 0x80;	goto a4;	// #scan
			case 2 : d = 0; }				// #output
			sprintf(p1=buf, "%u", Eline[Esel]);
			goto a2;
		case '[' : if((Of & 0x7f) != 2) goto a3;	// Only if on error
			if(Esel >= Etop) Of |= 0x80;
			goto a1;
		case ']' : if((Of &= 0x7F) != 2) goto a3;	// Resume error
			goto a1;
		case 'R' :	if((Of & 0x7F) != 1) goto a3;
			c = 0x82;	goto a4;
		case ';' :	if((Of & 0x7F) != 1) goto a3;	// Premature end
			Oc(0x81);
			goto a5; 
		case '~' : ; }
	default:
		if(l) c = tolower(c);
a4:		Oc(c); goto a1;
	case 0 : a5: *Ptr = 0; }
	p1 = Ptr;
	Ptr = Buffer;
	Of = 0;
	return p1;
}

// Write the ~F file
void wcfile(void)
{
	unsigned i;
	FILE *fp;
	if(CFtop) {
		fp = fopen(CFlist[i=0], "wvq");
		while(++i < CFtop) {
			CmdSub(CFlist[i]);
			fputs(Ptr, fp);
			putc('\n', fp); }
		fclose(fp); }
}

// Execute a command
int DoCmd(void)
{
	unsigned char *p, *p1;
	if(skip() != '!')
		return system(Ptr);
	p = ++Ptr;
a1:	switch(*Ptr) {
	default: ++Ptr;	goto a1;
	case ' ' :
	case '\t':
	case 0 : p1 = Ptr; }
	skip();
	*p1 = 0;
	return exec(p, Ptr);
}

#if 0
FILE	*Dfp;
#define	Dopen()		Dfp = fopen("R:\\Z", "wvq")
#define	Dclose()	fclose(Dfp)
void Dputs(unsigned char *p)
{
	unsigned char c;
a1:	switch(c = *p++) {
	default:
		if((c < ' ') || (c > 0x7E)) {
			fprintf(Dfp, "[%u]", c);
			goto a1; }
	case '\n' :
		putc(c, Dfp);
		goto a1;
	case 0 : ; }
}
#else
	#define	Dopen()
	#define	Dclose()
	#define	Dputs(s)
#endif

// Perform compile commands and check for errors
int Compile()
{
	unsigned i, j,  k, ml, n;
	unsigned char c, rf, *p, *p1, *p2, *p3;
	rf = 0;
a0:	system("CLS");
	for(Etop=i=0; i < CMtop; ++i) {
		CmdSub(CMlist[i]);
		DoCmd(); }
	ml = 25;
	if(Ofile)
		fp = fopen(Ofile, "rvq");
	Dopen();
	while(i++ < ml) {
		if(Ofile) {
			if(!fgets(Temp, sizeof(Temp)-1, fp))
				break; }
		else
			getline(Temp, i-1);
//??	strupr(Ptr = Temp);
		Ptr = Temp;
		skip(); p3 = Ptr;
		for(j=0; j < EMtop; ++j) {
			Of = 1; CmdSub(EMlist[j]);
			p1 = p3;
a3:			Dputs("=\n\'");
			Dputs(Buffer);
			Dputs("'\n '");
			Dputs(Temp);
			Dputs("'\n '");
			Dputs(p1);
			Dputs("'");
			if(!*(p = p1++))
				continue;
			n = 0;
			Ptr = Buffer;
a1:			switch(c = toupper(*Ptr++)) {	//?
			case ' ' :
			case '\t':
				skip();
				if(isspace(*p)) {
					do ++p; while(isspace(*p));
					goto a1; }
				Dputs("1\n");
				goto a3;
			default:
				if(toupper(*p++) == c) goto a1;
				Dputs("2\n");
				goto a3;
			case 0x80:		// Number
				p2 = p;
a2:				if((k = *p - '0') < 10) {
					n = (n * 10) + k;
					++p;
					goto a2; }
				if(p2 != p) goto a1;
				Dputs("4\n");
				goto a3;
			case 0x82:	rf |= 15;	goto a1;	// Restart error
			case 0 : 							// End
				while(isspace(*p)) ++p;
				if(*p) {
					Dputs("5\n");
					goto a3; }
			case 0x81: ; }					// Premature end
			Dputs("0\n");
			if(Etop < ERR) {
				strcpy(Etext[Etop], p1-1);
				Eline[Etop++] = n; } } }
	Dclose();
	if(Ofile)
		fclose(fp);
	if(rf == 15) {
		if(*(Ptr = Recomp)) {
			DoCmd();
			rf = 255;
			goto a0; } }
	return 0;
}

// Main program
main(int argc, char *argv[])
{
	unsigned i, j, sl, at, ti, da;
	unsigned c, char name[16];

	if(getenv("CCC", Temp))
		Sname = CData(Temp);

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		CmdArg(); }

	fp = CmdOpen("!INI");
	while(fgets(Ptr = Temp, sizeof(Temp)-1, fp)) {
		switch(skip()) {
		case ';' :
		case 0 : continue; }
		while(Ptr[i]) ++i;
		while(i && isspace(Ptr[i-1])) --i;
		Ptr[i] = 0;
		strupr(Ptr);
		if(strbeg(Ptr, "SEC:")) {
			if(F) break;
			Ptr += 4; skip();
			if(Sname) {
				if(strcmp(Sname, Ptr)) continue; }
			F = 255;
			continue; }
		if(!F) continue;
		j = *Ptr++;
		if(*Ptr++ != ':') goto e1;
		skip();
/*ChtTxt INIhelp
CCC.INI is read to establish edit/compile settings. It it searched for in:
	Current directory
	Directory set in environment variable: %DDCDATA%
	Directory containing the CCC.COM executable
; Blank lines and lines beginning with ';' are ignored
SEC: name
	A: text		- command Argument (useful for .=)
	E: text		- specify Editor command
	O: file		- Compile output expected in file, otherwise read from screen
	F: file		- Create a file (useful for .BAT files) first F: is file name
	F: text		- Subsequest F:s are lines to write
	C: text		- Command to compile
	M: text		- Text to match for compiler errors
	R: text		- Command to run on ~R before retry compile

Text substitutions can be performed with '~', see:  ccc ?S

Multiple sections can be entered, first one is used if no '/name' command
  line option.  Section can also be selected by environment variable: %CCC%

E:, C: and R: may begin with '!', means use 'exec()' instead of 'system()'.
  Full command path must be given, options are limited (no redirection etc.)
  and name is parsed based on ' ' (command path may not contain spaces).
  Has less overhead and may give better return values.
*/
		switch(j) {
		default: e1: error("?expected A/C/E/F/O:");
		case 'A' :
			CmdArg();
			continue;
		case 'E' :
			strcpy(Edit, Ptr);
			continue;
		case 'R' :
			strcpy(Recomp, Ptr);
			continue;
		case 'O' :
			Ofile = CData(Ptr);
			continue;
		case 'F' :
			if(CFtop >= CFILE) error("?too many F:");
			CFlist[CFtop++] =  CData(Ptr);
			continue;
		case 'C' :
			if(CMtop >= CMDS) error("?too many C:");
			CMlist[CMtop++] = CData(Ptr);
			break;
		case 'M' :
			if(EMtop >= EMATCH) error("?too many E:");
			EMlist[EMtop++] = CData(Ptr); } }
	if(!F) {
		sprintf(Ptr = Buffer, "Section '%s' not found!", Sname);
he:		printf("?%s\n", Ptr);
		help(Help, 0); }
	fclose(fp);

	if(!*Name) strcpy(Name, "*");
	if(!*Ext(Name))				goto ae2;
	if(!strcmp(Fext, "COM"))	goto ae1;
	if(!strcmp(Fext, "EXE")) {
ae1:		--Fext;
ae2:		strcpy(Fext, FNext); }
	if(Fname != Name) { Ptr = "Can't have path!"; goto he; }
	if(!*Edit)			error("?no E=");

	if(find_first(Name, 0, name, &j, &sl, &at, &ti, &da))
		error("?? %s", Name);
	do {
		if(da < D) continue;
		if(da > D) goto cp;
		if(ti <= T) continue;
	cp:	D = da; T = ti; S=sl;
		strcpy(Name, name);  }
	while(!find_next(name, &j, &sl, &at, &ti, &da));
	L = strlen(Name);
	Ext(Name);
#if 0
for(i=0; i < CMtop;++i) {
	printf("'%s'\n", CMlist[i]);
	Of = 2; CmdSub(CMlist[i]);
	printf("C:'%s'\n", Ptr); }
for(i=0; i < EMtop;++i) {
	printf("'%s'\n", EMlist[i]);
	Of = 1; CmdSub(EMlist[i]);
	printf("E:'%s'\n", Buffer); }
	wcfile();
//	return;
#endif

	wopen(0, 0, 80, 25, NORMAL);
	wclose();
//	S = -1;
edit:
	c = DoEdit;
	DoEdit = 255;
	Of = 2; CmdSub(Edit);
	if(c & 0x0F) {
		if(DoCmd()) {
			if(RbF)
				goto view; } }
	RbF = 255;
	if(find_first(Name, 0, name, &j, &sl, &at, &ti, &da))
		error("?? %s", Name);
	if((ti == T) && (da == D) && (sl == S) && (c & 0xF0)) {
ex:		RbF = 0;
		printf("\n'%s' Timestamp has NOT changed.\n", Name);
		printf("C)ompile V)iew E)dit ESC=exit?");
a0:		switch(toupper(kbget())) {
		default: goto a0;
		case 0x1B: exit(0);
		case 'V' : goto view;
		case 'E' : goto edit;
		case 'C' : ; } }
	D = da; T=ti; S=sl;

	Esel = 0;
	F = 0x50;
	wcfile();
	while(Compile());
	if(!Etop)
		return;

// View file in window
view:
	DoEdit = 255;
	Line = Start = Mline = 0;
	fp = fopen(Name, "rvq");
	Ewin = wopen(0, MSIZE, 80, 25-MSIZE, WSAVE|WCOPEN|WWRAP|ENOR);
	Mwin = wopen(0, 0, 80, MSIZE, WSAVE|WCOPEN|MNOR);
a1:	filego();
	redraw();
/*ChtTxt VIEhelp
CCC interactive viewer commands:

		`^/`v			move 1 line
	 PgUp/PgDn		move 23 lines
	^PgUp/^PgDn		move to 1st/last line
		`</`>			move one column
	   Home			move to First column
	   space		move to current error
	} ] > or .		move to next error
	{ [ < or ,		move to previous error
		Tab			toggle Tabs: 1, 2, 4, 8
		F1			toggle {} depth display on/off
	   Enter		edit file
		ESC			exit
		 ?			this help display
*/
	for(;;) switch(wgetc()) {
	case 0x1B:
		wclose();
		wclose();
		fclose(fp);
		goto ex;
	case '?' : wclwin(); help(VIEhelp, 255);	continue;
	case _KUA: if(!Line) continue;
		--Line;
rl:		filego();
		goto a1;
	case _KDA:	++Line;												goto rl;
	case _KPU:	Line = (Line >= (MSIZE-1)) ? Line - (MSIZE-1) : 0;	goto rl;
	case _KPD:	Line += (MSIZE-1);									goto rl;
	case _CPU:	Line = 1;											goto rl;
	case _CPD:	Line = -1;											goto rl;
	case _KRA:	++Start;											goto a1;
	case _KLA:	if(Start) --Start;									goto a1;
	case _KHO:	Start = 0;											goto a1;
	case '\t': if((Tab <<= 1) > 8) Tab=1;							goto a1;
	case _K1: NoDepth = !NoDepth;	goto a1;
	case '}' :
	case ']' :
	case '.' :
	case '>' : if(++Esel >= Etop) --Esel;
	case ' ' :
re:		Line = Eline[Esel];
		Line = (Line > 12) ? Line-12 : 0;
		goto rl;
	case '{' :
	case '[' :
	case ',' :
	case '<' : if(Esel) --Esel;			goto re;
	case '\n' :
		fclose(fp);
		wclose();
		wclose();
		goto edit; }
}
//ChtCmd cc ccc -pof
