// CHT C Help Text
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	EDBG	0	// 1=Show 2=DSYM 8=Halt
#define	MemTst(a)

#define	POOL		16384
#define	SYMS		25
#define	CMDS		25
#define	BSIZE		32

#define	O_PRE		0x01	// Preview
#define	O_OUT		0x02	// Write to stdout
#define	O_QUIET		0x04	// Less output
#define	O_CMD		0x08	// Do NOT perform commands
#define	O_TXT		0x10	// Text output
#define	O_ASM		0x20	// Assembly format output
#define	O_COM		0x40	// .COM patch

#define	R_SYM		0x01
#define	R_TAB		0x02
#define	R_SPC		0x04

unsigned
	CMseg, CMtop,
	CMend, CMhlp,
	Line,			// Currently read line
	Yr, Mo, Da, Hr, Mi, Se; 
	Tab,			// Tab width
	Width,			// Output width
	Oval,
	Owidth,			// Running output width
	Sindex,			// Lookup symbol index
	Stop,			// Top of symbol list
	Ctop,			// Top of command list
	Ptop;			// Top of string pool
FILE
	*fpi,
	*fpo;
unsigned char
	*Ptr,			// General
	*Scmt,			// Special command [Cht]
	*Syms[SYMS],	// Symbol list names
	*Sdefs[SYMS],	// "" definition text
	*Cmds[CMDS],
	Opt,			// Command options
	Opt1 = 255,		// ""Inverted
	Esc = '~',		// Esc character
	Tim2,			// 2 char Time mode
	Nnl,			// No-NewLine
	Cread,			// Comment reading flag
	Smode,			// Special comment mode
	Progress,		// Progress flag
	Buffer[256],	// General buffer
	Rbuffer[256],	// Resolved buffer
#ifndef _DVM_
	CMname[128],
#endif
	Symbol[128],	// Parsed symbol
	Temp[128],		// General buffer
	Pool[POOL];		// String pool

#ifdef _DVM_
	unsigned char H;
	#include "R:\\Help.h"
#else
	#include "R:\\CHT.H"
#endif

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}

// Check on progress before exit
void CKprogress(void)
{
	if(!Progress)
		Ps("For help use: CHT -?\n");
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	CKprogress();
	if(Line) printf("%u: ", Line);
	Ps(buf);
	exit(-1);
}
register Msg(unsigned args)
{
	unsigned i;
	unsigned char buf[200];
	i = nargs();
	if(Opt1 & O_QUIET) {
		_format_(i*2+&args, buf);
		Ps(buf); }
}

#ifdef _DVM_
void help(unsigned char *p, unsigned char c)
{
	if((H == c) || (H == '?')) {
		if(Esc) Pc('\n');
		while(c = *p++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
			Esc = 7; }
}
#endif
void PokeCM(unsigned char c)
{
	if(CMseg)
		poke(CMseg, CMtop++, c);
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}
void Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i]) ++i;
	while(i && isspace(Ptr[i-1])) --i;
	Ptr[i] = 0;
}

void pq(unsigned char *buf, unsigned char tc)
{
	unsigned i;
	unsigned char c;
	i = 0;
	while((c = *Ptr++) != tc) {
		if((i >= BSIZE) || !c)
			Error("?%ctext%c", tc, tc);
		buf[i++] = c; }
	buf[i] = 0;
}
		
unsigned Expression(unsigned char tc);
unsigned Value(void)
{
	unsigned v, c, b;
	unsigned char d, o, b1[BSIZE+1], b2[BSIZE+1];
	v = c = d = 0;
	switch(o = Skip()) {
	case '(' :
		++Ptr;
		v = Expression(')');
		return v;
	case '\'':
	case '`' :
	case '"' :
		++Ptr;
		pq(b1, o);
		pq(b2, o);
		Debug(("?'%s'%s'\n", b1, b2))
		return !strcmp(b1, b2);
	case '.' :
		++Ptr;
		return Oval;
	case '!' :
	case '~' :
	case '-' :
		++Ptr;
		Skip(); }
#if 0
	if(issym(*Ptr) & 0xF0) {	// Symbol index
		Sparse(b1);
		v = lookup(b1); }
	else
#endif
	{						// Numeric quantity
		b = 10;
		switch(*Ptr) {
		case '%' :	b = 2;	goto a1;
		case '@' :	b = 8;	goto a1;
		case '$' :	b = 16;	a1:
			++Ptr; }
		for(;;) {
			c = *Ptr;
			if((c >= '0') && (c <= '9'))	{	c -= '0';		goto a2; }
			if((c >= 'A') && (c <= 'F'))	{	c -= ('A'-10);	goto a2; }
			if((c >= 'a') && (c <= 'f'))	{	c -= ('a'-10);	goto a2; }
			break;
a2:			if(c >= b)
				break;
			v = (v * b) + c;
			d = 255;
			++Ptr; }
		if(!d) Error("Bad value"); }
	switch(o) {
	case '!' :	return !v;
	case '~' :	return ~v;
	case '-' :	return -v; }
	return v;
}

unsigned Expression(unsigned char tc)
{
	unsigned v, o;
	v = Value();
a1:	Skip();
	if((o = *Ptr++) == tc)
		return v;
//	if(*Ptr == '=')
	switch(*Ptr) {
		case '=':
		case '|':
		case '&': o = (o << 8) | *Ptr++; }
	switch(o) {
	case '+' :	v = v + Value();	goto a1;
	case '-' :	v = v - Value();	goto a1;
	case '*' :	v = v * Value();	goto a1;
	case '/' :	v = v / Value();	goto a1;
	case '%' :	v = v % Value();	goto a1;
	case '&' :	v = v & Value();	goto a1;
	case '|' :	v = v | Value();	goto a1;
	case '^' :	v = v ^ Value();	goto a1;
	case '<' :	v = v < Value();	goto a1;
	case '>' :	v = v > Value();	goto a1;
	case '=' :
	case '==':	v = v == Value();	goto a1;
	case '!=':	v = v != Value();	goto a1;
	case '<=':	v = v <= Value();	goto a1;
	case '>=':	v = v >= Value();	goto a1;
	case '&&':	v = Value() && v;	goto a1;
	case '||':	v = Value() || v;	goto a1; }
	if(!(v = o >> 8)) v = ' ';
	Error("?Operator: %c%c", v, o & 255);
}

#if EDBG&8
void Halt(void)
{
	if(kbtst() == 0x1B)
		Error("Halt");
}
#endif

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("StringPoolOverflow"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}
unsigned char *LookUp(unsigned char *p)
{
	for(Sindex = 0; Sindex < Stop; ++Sindex) {
		if(!strcmp(Syms[Sindex], p)) {
			Debug(("F'%s'='%s'\n", Syms[Sindex], Sdefs[Sindex]))
			return Sdefs[Sindex]; } }
	return 0;
}

#if EDBG&1
void Show(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			printf("{%u}", c & 0x7F);
			continue; }
		Pc(c); }
	if(Nnl != 123) printf("{nl}");
	Pc('\n');
	Nnl = 0;
}
#endif

#define	VSYM	('Z'+12)
unsigned ISsym(unsigned char c)
{
	if((c >= '0') && (c <= '9'))	return c - '0';
	if((c >= 'a') && (c <= 'z'))	return c - ('a'-10);
	if((c >= 'A') && (c <= 'Z'))	return c - ('A'-10);
	return (c == '_') ? VSYM-1 : 255;
}
unsigned ISvar(unsigned char c)
{
	if((c = ISsym(c)) < VSYM) {
		if(c > 9)
			return 255; }
	return 0;
}

void Asym(unsigned char *p)
{
	unsigned char d, *p1;
	d = 255;
	switch(*(p1 = Symbol)) {
	case '1':	d = 0;	goto a1;
	case '0':	d = 7;
a1:		++p1; }
	if(ISsym(*p1) < 10)
		Error("BadSymbol");
	if(LookUp(p1)) {
		if(d) {
			if(d & 0xF0)
				Error("DuplicateSymbol'%s'", p1);
			return; } }
	else {
		if(Stop++ >= SYMS)
			Error("TooManySymbols");
		Syms[Sindex] = Pstring(p1); }
	Sdefs[Sindex] = Pstring(p);
}

// Parse a symbol name
unsigned Psym(void)
{
	unsigned i;
	i = 0;
	while(ISsym(*Ptr) < VSYM)
		Symbol[i++] = *Ptr++;
	Symbol[i] = 0;
	Debug(("Ps'%s'%u\n", Symbol, i))
	return i;
}

void Resolve(unsigned char o)
{
	unsigned i, j, k, l;
	unsigned char c, d, s, t, *p;

	i = j = s = d = 0;
a1:	c = *Ptr;
//	printf("[%02x]", c);
	switch(c) {
	case 0 :
		Rbuffer[j] = 0;
		Ptr = Rbuffer;
		Debug(("R'%s'\n", Rbuffer))
		return;
	case '\t':
		if(o & R_TAB) {
			s = 7;
			do {
				++i; }
			while(i % Tab);
//printf("T%u-%u\n", s, i);
			++Ptr;
			goto a1; }
		c = ' '; }
	if(s) {
		Rbuffer[j++] = i | 0x80;
		s = 0; }

	if(c == Esc) {
		if(!(o & R_SPC)) goto a2;
		++Ptr;
		switch(c = *Ptr) {
		default	:
			if((k = c - '0') < 10) {
				i -= k;
				if(i & 0x8000) i = 0;
				goto a3; }
			goto a2;
		case '^':	c = 0x18;	goto a2;
		case 'v':	c = 0x19;	goto a2;
		case '>':	c = 0x1A;	goto a2;
		case '<':	c = 0x1B;	goto a2;
		case 'n':	c = '\n';	goto a2;
//		case '.':
//		case ',':				goto a3;
		case 0	:	Nnl = 123;	goto a1;
		case '$':
			k = ISsym(Ptr[1]);
			l = ISsym(Ptr[2]);
			if((k | l) & 0xFFF0) Error("BadHex");
			c = (k << 4) | l;
			Ptr += 2;
Rbuffer[j++] = 0x80;
			goto a2;
		case '#':
		case '?':
			d = c;
			t = j;
			goto a3;
		case 'T':	Tim2 = 0;	goto a3;
		case 't':	Tim2 = 123;	goto a3;
		case 'Y':	k = Yr;		goto a4;
		case 'M':	k = Mo;		goto a4;
		case 'D':	k = Da;		goto a4;
		case 'h':	k = Hr;		goto a4;
		case 'm':	k = Mi;		goto a4;
		case 's':	k = Se;
a4:			if(Tim2 == 123)
				sprintf(p = Temp, "%02u", k % 100);
			else
				sprintf(p = Temp, "%u", k);
			i += strlen(p); }
		++Ptr;
		goto a9; }
	if((c == ';') && d) {
		Rbuffer[j] = 0;
//		Debug((":%c'%s'%s'\n", c, Rbuffer+t, Ptr))
		j = t; c = d; d = 0;
		p = Ptr+1;
		Ptr = Rbuffer+t;
		i += 3;
		switch(c) {
		default	:	Error("?%c%c...;", Esc, c);
		case '?':
			k = Expression(':');
			Debug(("[?%u'%s]", k, Ptr))
			l = Ptr;
			Ptr = p;
			if(!k) goto a1;
			p = l;
			goto a9;
		case '#':
			k = Expression(0);
			Ptr = p;
			sprintf(p = Temp, "%u", k);
			goto a9; } }
	if(!(k = Psym())) {
a2:		Rbuffer[j++] = c;
		++i;
a3:		++Ptr;
		goto a1; }
	i += k;
	if(!(p = LookUp(Symbol)))
		p = Symbol;
#if 0
	else {
		Debug1(("Sym'%s'='%s'\n", Symbol, p)) }
#endif
a9:	while(c = *p++)
		Rbuffer[j++] = c;
	goto a1;
}

unsigned Begins(unsigned char *p1, unsigned char *p2)
{
	unsigned i;
	unsigned char c;
	i = 0;
	while(c = p2[i]) {
		if(p1[i++] != c)
			return 0; }
	Ptr = p1 + i;
	return 255;
}

unsigned ReadLine(void)
{
	unsigned i;
a1:	if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fpi))
		return 0;
	++Line;
	i = *(unsigned*)Buffer;
//printf("%04x[%s]\n", i, Buffer);
	if(Cread & 0x80) {
		if(i == '/*') {					// End comment
			Cread = Smode = 0;
			goto a1; }
		if(Smode == 0xA0)	goto a1;
		return 3; }
	if(Begins(Buffer+2, Scmt)) switch(i) {
		case '*/':							// StartComment
			i = 0;
			while(Buffer[i]) ++i;
			if(i > 4) {
				if(strcmp(Buffer+i-2, "*/")) {
					Cread = 0x80;
					return 2; }
				Buffer[i-2] = 0; }
		case '//':	return 1; }				// LineComment
	goto a1;
}

void Arg(unsigned char ce)
{
	unsigned char c, *p;

	Debug(("Arg'%s'\n", Ptr))
	switch(*Ptr) {
#ifdef _DVM_
	case '?': ++Ptr; goto q;
#endif
	case '-':
	case '/': ++Ptr;
o1:		switch(c = toupper(*Ptr++)) {
		default	:
			p = --Ptr;
			Oval = 0;
			while((c = *Ptr - '0') < 10) {
				Oval = (Oval*10)+c;
				++Ptr; }
			if(Ptr == p)
				goto he;
			break;
#ifdef _DVM_
		case '?':
q:			H = toupper(*Ptr);
			goto he1;
#else
		case 'M':
			strcpy(CMname, Ptr);
			Opt |= O_COM;
			return;
#endif
		case 'T':	Tab = Expression(0);	return;
		case 'W':	Width = Expression(0);	return;
		case 'E':	Esc = *Ptr;				return;
		case 'S':	Scmt = Pstring(Ptr);	return;
		case 'P':	printf("%s\n", Ptr);	return;
		case 'A':	c = O_ASM;				goto o2;
		case 'C':	c = O_CMD;				goto o2;
		case 'O':	c = O_OUT;				goto o2;
		case 'Q':	c = O_QUIET;			goto o2;
		case 'X':	c = O_TXT;				goto o2;
		case 'V':	c = O_PRE;
o2:			Opt |= c;
			Opt1 = ~Opt; }
		if(*Ptr) goto o1;
		return; }
	p = Ptr;
	if(Psym()) {
		if(*Ptr++ == '=') {
			Skip(); Trim();
			Asym(Ptr);
			return; } }
	if(ce || *Rbuffer) {
he:
#ifdef _DVM_
		H = 0;
		he1:
#endif
		Progress = Esc = 0;
#ifdef _DVM_
		help(Help, 0);
		help(OptHlp, 'O');
		help(CmtHlp, 'C');
		help(SymHlp, 'S');
		help(EscHlp, 'E');
		help(ValHlp, 'V');
		help(RopHlp, 'R');
		help(HowHlp, 'H');
		if(!Esc) help(Help, H);
#else
		CKprogress();
#endif
		exit(0); }
	strcpy(Rbuffer, p);
}

void Args(void)
{
	unsigned i;
	unsigned char c, e;
	for(;;) {
		i = e = 0;
		switch(Skip()) {
		case 0	: return;
		case'\'':
		case '"':
		case '`': e = *Ptr++; }
//Debug(("[%02x'%s]\n", e, Ptr))
a1:		switch(c = *Ptr) {
		case ' ':
		case'\t':	if(!e) c = 0; }
//Debug(("[c%02x]", c))
		if(c != e) {
			if(!c) Error("Parse'\"`Error");
			Temp[i++] = *Ptr++;
			goto a1; }
		Temp[i] = 0;
		i = e ? (Ptr+1) : Ptr;
		Ptr = Temp;
		Arg(7);
		Ptr = i; }
}
void Acmd(void)
{
	if(Skip()) {
		Trim();
		Debug(("C'%s'\n", Ptr))
		if(Ctop >= CMDS)
			Error("TooManyCmds");
		Cmds[Ctop++] = Pstring(Ptr); }
}

unsigned char Oflag;
void PCfpo(unsigned char c)
{
	if(!fpo)
		Error("?fpo");
	if(fpo != stdin)
		putc(c, fpo);
}
void PSfpo(unsigned char *p)	{	while(*p) PCfpo(*p++);	}
void PVfpo(unsigned v)
{
	unsigned i;
	unsigned char buf[16];
	if(Smode == 0xA4) {
		PokeCM(v);
		return; }
	if(Opt & O_TXT) {
		if(v < ' ')		goto a1;
		if(v > '~')		goto a1;
		if(v == '\'')	goto a1;
		i = sprintf(buf, "'%c',", v); }
	else {
a1:		i = sprintf(buf, "%u,", v); }
	if((Owidth  += i) >= Width) {
		Owidth = i;
		if(Opt & O_ASM) {
			buf[--i] = 0;
			PSfpo(buf);
			PSfpo("\n\tDB\t");
			return; }
		PSfpo(buf);
		PSfpo("\n\t");
		return; }
	PSfpo(buf);
}
void Oclose(void)
{
	if((fpo != stdin) && fpo)
		fclose(fpo);
}
void Close(void)
{
	if((Opt1 & O_PRE) && (Smode != 0xA4) && Oflag) {
		Debug(("Close!\n"))
		PSfpo((Opt & O_ASM) ? "0\n" : "0 };\n"); }
	Owidth = Oflag = 0;
}
void Open(unsigned char *p, unsigned o)
{
	unsigned i, j, k;
	Debug(("Open'%s'%u\n", p, o))
	Close();
	i = k = 0;
a1:	j = 0;
a2:	switch(p[i++]) {
	case ':':
	case'\\':	k = i;	goto a1;
	case '.':	j = i;
	default	:			goto a2;
	case 0	:	; }
	if(j | k) {		// Path/Ext speced
		if(Opt1 & O_OUT) {
			Debug(("Fclose!\n"))
			Oclose();
			fpo = 0; } }
	if(j)
		--j;
	else {
		j = i-1;
		strcpy(p+j, (Opt & O_ASM) ? ".ASM" : ".H"); }
	if(!fpo) {
#ifndef _DVM_
		if(*CMname) {
			Msg("Write: %s\n", CMname);
			fpo = stdin; }
		else
#endif
		{
			Msg("Write: %s\n", p);
			fpo = fopen(p, "wvq"); } }
	p[j] = 0;
	if(o == 1) return;
	Oflag = 7;
	Msg("***Section: "+3);
	Msg("%s\n", p += k);
	if(Smode == 0xA4) {
		if(CMtop != CMhlp)
			PokeCM(*p);
		return; }
	if(Opt & O_PRE) {
		PSfpo("***Section: ");
		PSfpo(p);
		PSfpo(" ***\n");
		return; }
	if(Opt & O_ASM) {
		PSfpo(p);
		PSfpo(":\n\tDB\t");
		return; }
	PSfpo("unsigned char ");
	PSfpo(p);
	PSfpo("[] = {\n\t");
}

void FindLatest(void)
{
	unsigned i, At, Ti, Da, Lt, Ld;
	if(find_first("*.c", Ld = Lt = 0, Buffer, &i, &i, &At, &Ti, &Da))
		Error("*.c not found!");
	do {
		if(Da < Ld) continue;
		if(Da > Ld)	goto a1;
		if(Ti < Lt) continue;
a1:		Ld = Da; Lt = Ti;
		strcpy(Rbuffer, Buffer); }
	while !find_next(Buffer, &i, &i, &At, &Ti, &Da);
}

void ShoFpo(unsigned char *p)
{
	unsigned i, j, s;
	unsigned char c;
	i = s = 0;
	while(c = *p++) {
		if(c & 0x80) {
			if(c == 0x80) {
				if(!(c = *p++))
					Error("Unexpected EOL");
				goto a1; }
			s = c & 0x7F;
			continue; }
		if(c == ' ') {
			++s;
			continue; }
a1:		if(s > i) {
			j = s - i;
			PVfpo( (j == 1) ? ' ' : j | 0x80);
			i += j; }
		PVfpo(c);
		++i;
		++s; }
	if(Nnl != 123)
		PVfpo('\n');
	Nnl = 0;	//?
}
void ShoPre(unsigned char *p)
{
	unsigned i, s;
	unsigned char c;
	i = s = 0;
	while(c = *p++) {
		if(c & 0x80) {
			s = c & 0x7F;
			continue; }
		if(c == ' ') {
			++s;
			continue; }
		if(s > i) {
			while(i < s) {
				PCfpo(' ');
				++i; } }
		PCfpo(c);
		++i;
		++s; }
	if(Nnl != 123)
		PCfpo('\n');
	Nnl = 0;
}

void Fext(unsigned char *fn, unsigned *ext)
{
	unsigned  i, j;
	i = 0;
a1:	j = 0;
a2:	switch(fn[i++]) {
	case ':':
	case'\\':	goto a1;
	case '.':	j = i;
	default	:	goto a2;
	case 0	:	; }
	if(!j)
		strcpy(fn+i-1, ext);
}

#ifndef _DVM_
unsigned TstSegHlp(void)
{
	unsigned i, j;
	if(peek(CMseg, 0) != 0xE9) {
rz:		return 0; }
	j = peekw(CMseg, 1) + 3;
	Debug(("=%04x\n", j))
	for(i = 3; i < 0x20; ++i) {
		Debug(("%02x%02x;", peek(CMseg, i+j), CCcode[i] ))
		if(peek(CMseg, i+j) != CCcode[i])
			goto rz; }
	Debug(("=%04x", j))
	Debug(("[%04x %04x]", peekw(CMseg, j+Xpat1), peekw(CMseg, j+Xpat2) ))
	pokew(CMseg, 0, peekw(CMseg, j+Xpat1));
	pokew(CMseg, 2, peekw(CMseg, j+Xpat2));
	Ps("Existing CHT -M");
	Ps(CMname);
	Ps(" - ");
	return CMtop = j;
}
#endif

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char o;

	MemTst(7);

	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		Arg(0); }

	if(*Rbuffer)
		Fext(Rbuffer, ".C");
	else
		FindLatest();

#ifndef _DVM_
/*	if(Opt & O_COM) {
		if(!*CMname) {
			strcpy(CMname, Rbuffer);
			Ptr = i = 0;
c1:			switch(CMname[i]) {
			case '.':	Ptr = CMname+i;
			default	:	++i; goto c1;
			case 0	:	; }
			if(!Ptr) Error("?COM");
			*Ptr = 0; } */
	if((Opt & O_COM) && *CMname) {
		Fext(CMname, ".COM");
		fpi = fopen(CMname, "rbvq");
		CMseg = alloc_seg(4096);
		while( (i = getc(fpi)) != EOF)
			PokeCM(i);
		fclose(fpi);
		if(TstSegHlp()) {
			if(Opt & O_TXT) {
				Ps("Removed\n");
				goto zz; }
			Ps("Replaced\n"); }
		Debug(("Cl'%s'%u", CMname, CMtop))
		CMend = CMtop;
		i = 0;
		while(i < sizeof(CCcode))
			PokeCM(CCcode[i++]);
		CMhlp = CMtop;
		Debug((" %u\n", CMtop))
		fpo = stdin; }
#endif
#if EDBG&2
	for(i=0; i < Stop; ++i) {
		printf("%u'%s'", i, Syms[i]);
		printf("='%s'\n", Sdefs[i]); }
#endif
	if(!Tab) 	Tab		= 4;
	if(!Width)	Width	= 70;
	if(!Esc)	Esc		= '~';
	if(!Scmt)	Scmt	= "Cht";
	if(Opt & O_OUT)	fpo = stdout;

	get_date(&Da, &Mo, &Yr);
t1:	i = Da;
	get_time(&Hr, &Mi, &Se);
	get_date(&Da, &Mo, &Yr);
	if(Da != i) goto t1;
	Debug(("%04u/%02u/%u %u:%02u:%02u\n", Yr, Mo, Da, Hr, Mi, Se))

	if(!(fpi = fopen(Rbuffer, "rv"))) {
		CKprogress();
		return; }
	Msg("Read: %s\n", Rbuffer);
	Progress = 99;
a1:	switch(i = ReadLine()) {
	case 3 :	//End
		Resolve(R_TAB|R_SYM|R_SPC);
		switch(Smode) {
		default	:	Error("?Smode");
		case 0xA2:
			Acmd();
			goto a1;
		case 0xA3:
			Args();
		case 0xA0:
			goto a1;
		case 0xA1:
		case 0xA4:	; }
Debug(("T'%s'\n", Rbuffer)) 
#if EDBG&1
		Show(Rbuffer);
#endif
		Progress = 123;
		if(Opt & O_PRE) {
			ShoPre(Rbuffer);
			goto a1; }
		ShoFpo(Rbuffer);
		goto a1;
	case 1	:	//
	case 2	:	/**/
		if(CMtop > CMhlp)
			PokeCM(0);
		Debug(("$%u'%s'\n", Ptr))
		Resolve(R_SYM);
		if(Skip() == '(') {
			++Ptr;
			if(!Expression(')')) {
				Smode = 0xA0;
				goto a1; }
			Skip(); }
		if(Begins(Ptr, "Txt")) {
a2:			Smode = 0xA1;
a3:			if(Skip())
				Open(Ptr, i);
			goto a1; }
		if(Begins(Ptr, "Com")) {
			if(Opt & O_COM) {
#ifndef _DVM_
				if(*CMname) {
					Smode = 0xA4;
					goto a3; }
#endif
				goto a2; }
			break; }
		if(Begins(Ptr, "Cmd")) {
			Smode = 0xA2;
			Acmd();
			goto a1; }
		if(Begins(Ptr, "Arg")) {
			Smode = 0xA3;
			o = Opt;
			Args();
			if((Opt ^ o) & O_OUT) {
				Oclose();
				fpo = stdout; }
			goto a1; }
		if(!Begins(Ptr, "End"))
			Error("Unknown '%s'", Scmt); }
	Debug(("Close\n"))
	PokeCM(0);
	Close();
#ifdef _DVM_
	if(Opt & O_COM)
#else
	if((Opt & O_COM) && !*CMname)
#endif
		PSfpo("#define	_ChtCom_\n");
	Oclose();
	fclose(fpi);
	if(Progress != 123)
		Error("NoHelpTxt");
#ifndef _DVM_
/*
unsigned char CCcode[] = {
	0x40,0xCD,0x21,0x58,0x5B,0xC3 } // 149
#define	Xpat0	0x01	//HelpTxt
#define	Xpat1	0x20	//Code0100
#define	Xpat2	0x26	//Code0102
#define	Xpat3	0x2C	//JMP0100
*/
	if(*CMname) {
		poke(CMseg, CMtop++, 0);
		pokew(CMseg, CMend+Xpat0, CMhlp+256);
		pokew(CMseg, CMend+Xpat1, peekw(CMseg, 0));
		pokew(CMseg, CMend+Xpat2, peekw(CMseg, 2));
		i = CMend+Xpat3;
		pokew(CMseg, i, 0xFFFE - i);
		poke(CMseg, 0, 0xE9);
		pokew(CMseg, 1, CMend - 0x003);
zz:		fpo = fopen(CMname, "wbvq");
		i = 0;
		while(i < CMtop)
			putc(peek(CMseg, i++), fpo);
		fclose(fpo); }
#endif

	if(Opt1 & O_CMD) {
		for(i=0; i < Ctop; ++i) {
			Ptr = Cmds[i];
			Msg(">%s\n", Ptr);
			system(Ptr);
			} }

	MemTst(0);
}
//ChtArg -e`
/*ChtCom R:\Help.h
C Help Text Generator

use: CHT [c-file[.C]] [options**]

Generate .H (or .ASM) file for help text embedded in "special" comments
within C source code (referred to hereafter as SCs):
** Some of my older sources may need option: -SHelp

For additional help:
	CHT -?C		special Comments
	CHT -?E		SC Escape codes
	CHT -?H		How text is encoded
`?!DVM:`6	CHT -?M		adding to .coM`n;`
	CHT -?O		command line Options
	CHT -?R		opeRators in SC value expressions
	CHT -?S		SC Symbols
	CHT -?V		SC Values

To get full help as .TXT, use: CHT -?? >CHTHELP.TXT

Dave Dunfield	-	https://dunfield.themindfactory.com
 Download and see my product CATALOG!		Another way to find me:
 Search "Dave's Old Computers" and see my "personal" link at bottom.`
*/
/*ChtCom OptHlp

Command options:
	-Tvalue			set Tab width								[4]
	-Wvalue			set max output Width						[70]
	-Echar			set Escape Character						[~]
`?!DVM:`6	-M[file[.COM]]	add ChtCom help [to existing .coM]`n;`
`?!DVM:`6		if no [file], treats as ChtTxt and also #define's _ChtCom_`n;`
	-Stext			set Special identifier						[Cht]
	-Ptext			display message on console
		useful with //ChtArg
	-A				Assembly format output						[C format]
	-C				do not execute ChtCmd(s)
	-O				Output to console							[file(s)]
	-Q				Quiet										[more messages]
`?DVM:`5	-X				teXt output (where possible)				[hex numbers]`n;`
`?!DVM:`6	-X				teXt output (where possible) / remove -M	[hex numbers]`n;`
	-V				generate preView							[code]
	-n				set '.' value (n=0-65535)
	name=text		set symbol Name to text
*/
/*ChtCom CmtHlp
Special comments are C comments beginning in column 1 which begin with:
	//ChtXXX function			single line comment
	/*ChtXXX function*/			also ""
	/*ChtXXX function			multi line comment
		Additional Lines in Comment are referred to as ALC below.
'Cht' identifies this comment as a "special" one handled by CHT.
	You can change this string with the -S command option.
'XXX' is the type of special comment:
	Txt		function	is the name of a help section (C variable).
				if it contains ':', '\' or '.', it defines an output file,
					and only the file name is used as the section name.
				It may be blank to continue the preceeding Txt section.
			ALC=contain the help text.
	Com		if no -M	:	ignored
			if -M		:	treated like ChtTxt
			if -Mfile	:	help is added to file.COM
	Cmd		function	is a system command to be performed after the
			entire file is processed (I use it to recompile the program)
			ALC=additional commands.
	Arg		function	defines options to be processed as if they had been
			entered as command line arguments.	ALC=additional arguments.

You can use "Cht(value)XXX" to make an SC conditional on: value!=0
*/
/*ChtCom SymHlp
Like C, symbol names are case sensitive, must begin with 'A-Z', 'a-z', or '_',
and may also include '0-9' in later characters. With symbol=text, symbol may
be preceeded by '0' or '1' which gives a couple abilities:
	0 = don't cause an error if synbol already exists, leave unchanged if so.
	1 = "", assign symbol the new text value.
		note: the old text is NOT released from the CHT string pool,
		doing this excessively can cause the pool to overflow!
	The leading digit causes it to NOT be replaced in Help lines.  This
	allows ChtArg to:  default:	 0name=	 :or reassign:	1name=	:symbols.
*/
/*ChtCom EscHlp
Escape codes:	(default -E'~' assumed)

  ~T ~t				make times display as T:full or t:2-digit values
  ~Y ~M ~D			current		Year	Month	Day
  ~h ~m ~s						Hour	Minite	Second
  ~$cc				character with hex value: c=0-F
  ~^ ~v ~< ~>		PC video arrow characters
  ~n				New line
  ~#value;			output value of expression
  ~?value:text;		output text only if expression != 0
  ~0				ignored - use to break up symbol parsing
  ~1..~9			reduce desired output Position
	CHT tracks the horizonal position in input lines, and adjusts the number of
	spaces in the outut to align things at the same positions.	If a "special
	sequence" in the input is longer than the corresponding output, this can
	move the "desired" output position to the wrong place.	Tabs often handle
	small differences, but ~1..~9 can compensate more.
  ~end-of-line		don't output newline

If '~' preceeds any character not listed above, that character is output "as
is" - This can be used to prevent symbols from being substituted, as well as
to include strings not normally allowed on comments (like "*/").
*/
/*ChtCom ValHlp
CHT expects "values" to be provided for:
	-T and -W				command line options
	~# and ~?				escape sequences
	//Cht(value)XXX			Special comment control
	/*Cht(value)XXX[*/]		""
In their basic form, values are:
	0..9					Decimal number
	%0..1					Binary number
	@0..7					Octal number
	#0..F					Hexidecimal value
	'text1'text2'			1 if text1 matches text2, 0 otherwise
	"text1"text2"			""
	``text1``text2``			""
	.						Value passed as -n option
They may also be a full expression containg values as well as operators:
	Monadic (preceeds a value)
	Dyadic	(between two values)		use -?R for help with opeRators
*/
/*ChtCom RopHlp
Monadic operators (preceeds a value):
	-	 Negate
	!	 Not (0=1, !0=0)
	~	 Bitwise compliment
Dyadic operators (between two values):
	+	 Add					=	 Test Equal				\
	-	 Subtract				==	 ""						 > All tests are:
	&	 Bitwise AND			!=	 Test NOT Equal			 >
	|	 Bitwise OR				<	 Test Less				 >	0	if FALSE
	^	 Bitwise XOR			>	 Test Greater			 >		and
	*	 Multiply				<=	 Test Less or Equal		 >	!0	if TRUE
	/	 Divide					>=	 Test Greater or Equal	/
	%	 Modulus (remainder after division)
	&&	 Logical AND			0 if either 0,	!0 otherwise
	||	 Logical OR				0 if  both	0,	!0 otherwise
Expressions are evaluated left to right with NO operator precedence.
Precedence can be forced with brackets: 5*(2+3)
*/
/*ChtCom HowHlp
Help text is encoded in character arrays, consisting of the ASCII character
values (0x01-0x7F) with sequences of multiple spaces represented by a single
byte containing the number of spaces with the high bit set.	 This allows you
to space and align output with very little overhead. 0x00 indicates the end.

Here is simple C code to correctly display help text:

	while(c = *ptr++) {
		// "special" (0x80, 0x81 & 0x09) values can be handled here!
		if(c & 0x80) {
			while(c-- & 0x7F)
				putc(' ', stdout);
			continue; }
		putc(c, stdout); }

Note that the bytes 0x80, 0x81 and 0x09 (tab) will never occur naturally in
the encoded text, allowing you to use these values for "special purposes".
*/
/*Cht(!DVM)Com MocHlp
-Mfile	adds command line help to file.COM without using memory when it runs!
		Command line help is activated with first arg: -? /? or ?[c]
		(You might wamt to mention this in docs, or when it runs)
			[c] is the first character of the section name to show, or
			'?' to show all sections: -??
	-X	can be used with -M to remove any such added help.

.COMs are the simplest DOS programs			 (just an image of program memory)
	  and small				(64k or less - lots for most of my simple tools *)
	*	but.. 64k can be limiting if the tool uses much of it, and you
		want it to have a lot of "command line help" text.

.COMs are laid out in a 64k memory block:
  0000	256 bytes reserved by DOS
  0100+	Program code & Initialized data		>	Contained in .COM file
  ----	Unitialized data					\
  `v`v`v`v	malloc heap grows upward			 >	Not contained in .COM
  `^`^`^`^	Stack grows downward				/	(random content at start)
  FFFF

-M puts JMP UnitData at 0100 / adds code there to do help / fix 0100 / JMP back
*/
//BuildD CHTH -xF0
//BuildV cht CHT -M DVM=7
//BuildD cc CHT -pof
//BuildV ccf CHT -poft
//BuildD cht CHT -MCHT DVM=0
