// CHTH - Generate -coM header with patch addresses
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	FNAM	"R:\\MCCHP"
#define	XMAX	4

unsigned
	Btop,
	Ctop,
	Xcount1,
	Xcount2;
FILE
	*fp,
	*fpo;
unsigned char
	*Ptr,
	Xbyte,
	Xagn[XMAX],
	Buffer[256],
	Bytes[258],
	Code[128],		// Line
	Block[1024];	// File
#include "R:\\Help.H"
extern unsigned char *Xdesc[];

void Pc(unsigned char c)	{	putc(c, fpo);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fpo = stdout;
	Ps(buf);
	exit(-1);
}


unsigned Hex(unsigned c)
{
	if((c >= '0') && (c <= '9'))	return c - '0';
	if((c >= 'A') && (c <= 'F'))	return c - ('A'-10);
	if((c >= 'a') && (c <= 'f'))	return c - ('a'-10);
	return -1;
}
unsigned Byte(void)
{
	unsigned x;
	if((x = Hex(*Ptr)) != -1)
		x = (x << 4) | Hex(Ptr[1]);
	return x;
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

main(int argc, char *argv[])
{
	unsigned i, j, v;
	unsigned char c;

	fpo = stdout;
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt R:\Help.h
CHT .H creator

use:	CHTX	-Xxx

		-Xxx	special Patch byte value (hex)

Creates the CHT.H header file required to build CHT.C
	requires my ASM86.EXE 8086 cross assembler

'xx' value (hex) must be one that does not occur in the generated MCCHT.LST
	(usable values are displayed if you chose an unsuitable one)

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'X':
				Xbyte = Byte();
				continue; }
		}
he:		Ptr = Help;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return; }
	if(!Xbyte) goto he;

	strcpy(Buffer, argv[0]);
	i = j = 0;
x1:	switch(Buffer[i++]) {
	case '.':	j = i;
	default	:	goto x1;
	case 0	:	Buffer[j+1] = 0; }	// Truncate .COM to .C
	Debug1(("'%s'\n", Buffer))

	// Read CHTH.C and extract .ASM
	fp = fopen(Buffer, "rvq");
	fpo = fopen(FNAM#".ASM", "wvq");
	Pr("XADDR	EQU	$%02x00\n", Xbyte);
	i = j = 0;
	while(fgets(Buffer, sizeof(Buffer)-1, fp)) {
		if(strbeg(Buffer, "#if/**/0")) {
			i = j = 7;
			continue; }
		if(strbeg(Buffer, "#endif")) {
			i = 0;
			continue; }
		if(i) {
			fputs(Buffer, fpo);
			Nl(); } }
	fclose(fpo);	fpo = stdout;
	fclose(fp);
	if(!j) {
		Ps("No .ASM src found\n");
		return; }

	system("asm86 "#FNAM#" -f");

	fp = fopen("R:\\MCCHP.LST", "rvq");
/*
DUNFIELD 8086 ASSEMBLER: p                                            PAGE: 1

0100                         1  	ORG	$100
-12345678901234567890123456789
0100  BE 5E 01               2  	MOV	SI,#help
014D                        46  ;	RET
014D  53                    47  putc:	PUSH	BX
015E                        57  ;
015E                        58  Help:
*/
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		if(Skip() < ' ')
			continue;
		if(strbeg(Ptr, "DUNFIELD"))	continue;
		Ptr += 6;
		Ctop = 0;
		while((v = Byte()) != -1) {
			Code[Ctop++] = v;
			Bytes[v] = 7;
			Ptr += 3;
			if(*Ptr == '+')
				goto a1; }
		if(!Ctop) {
a1:			continue; }
		Debug(("%s=", Buffer))
		for(i=0; i < Ctop; ++i) {
			Block[Btop++] = c = Code[i];
			Debug((" %02x", c))
			if(c == Xbyte)		// Count #times XBYTE occurs is code
				++Xcount2; }
		Debug(("\n"))
		Ptr = Buffer;
		while(*Ptr) {			// Count number of times "XADDR" occurs
			if(strbeg(Ptr++, "XADDR"))
				++Xcount1; } }
	fclose(fp);

	printf("Size=%u Xbyte=%02x Xcount=%u-%u\n", Btop, Xbyte, Xcount1, Xcount2);

	if(Xcount1 != Xcount2) {	// Mismatch
		Ps("Invalid XBYTE value (these are available):\n");
		Bytes[256] = 255;
		i = v = 0;
		while(i < 256) {
			if(++v > 12) {
				Nl();
				v = 0; }
			if(!Bytes[i++]) {
				j = i;
				while(!Bytes[j]) ++j;
				Pc(' ');
				if(j != i)
					Pr("%02x-", i-1);
				else {
					j = i-1;
					Ps("   "); }
				Pr("%02x", j);
				if(j < 0xFC)
					c = j; } }
		Error("\nRecomend highest that's not normally common (eg: %02x)!\n", c); }

	fpo = fopen("R:\\CHT.H", "wvq");
//	Pr("#define\tXBYTE\t0x%02x\n", Xbyte);
	Pr("// XBYTE=0x%02x\n", Xbyte);
	Ps("unsigned char CCcode[] = {");
	for(i=j=0; i < Btop; ++i) {
		if(i)
			Pc(',');
		if(!j)
			Ps("\n\t");
		Pr("0x%02x", Block[i]);
		if(++j > 12)
			j = 0; }
	Pr(" } // %u\n", Btop);

	for(i=0; i < Btop; ++i) {
		if(Block[i] == Xbyte) {
			if( (j = Block[i-1]) >= XMAX)
				Error("?XADDR+%u > %u", j, XMAX-1);
			Pr("#define\tXpat%u", j);
			if(v = Xagn[j]) Pc(v+'@');
			Pr("\t0x%02x\t//%s\n", i-1, Xdesc[j]);
			++Xagn[j]; } }

	fclose(fpo);
//	fpo = stdout;
}
unsigned char *Xdesc[] = {
	"HelpTxt",
	"Code0100",
	"Code0102",
	"JMP0100",
	0 };
// This is written to MCCHT.ASM (and then assembled)
// It is the CHT code stub that will activate when the program runs.
#if/**/0
	ORG	$00
	MOV	SI,#XADDR		; Addres of HELP
	MOV	BX,#$80			; "" command operands
	MOV	CX,SI
o1:	INC	BX				; Skip to next
	MOV	AL,[BX]			; Get char
	CMP	AL,#' '			; Ignore spaces
	JZ	o1
	CMP	AL,#9			; Ignore tabs
	JZ	o1
	CMP	AL,#'-'			; Ignore '-'
	JZ	o1
	CMP	AL,#'/'			; Ignore '/'
	JZ	o1
	CMP	AL,#'?'			; Help request
	JZ	b1
; Return to main program
ex:	MOV	AX,#XADDR+1		; Restore start code
	MOV	$0100,AX
	MOV	AX,#XADDR+2		; ""
	MOV	$0102,AX
	DB	$E9				; JMP $0100
	DW	XADDR+3
; Request not found - show original
o9:	MOV	SI,CX
	JMP	<b9
; Lookup index
b1:	MOV	AH,1[BX]	; Get section (command)
	CMP	AH,#'a'		; Lower
	JB	<b2
	CMP	AH,#'z'
	JA	<b2
	SUB	AH,#'a'-'A'	; Convert
b2:	MOV	AL,[SI]		; Get from section
	INC	SI		; Next
	AND	AL,AL		; End?
	JNZ	b2		; No, keep looking
	MOV	AL,[SI]		; Get Section
	AND	AL,AL		; Last?
	JZ	o9		; Yes, default
	INC	SI		; Skip section
	CMP	AL,AH		; This one?
	JNZ	b2		; No, keep looking
; Section was found
b9:	MOV	AL,[SI]		; Get char
	INC	SI		; next
	TEST	AL,#$80		; Spaces?
	JNZ	a3		; Yes
	AND	AL,AL		; End?
	JZ	a9
	CMP	AL,#10		; NewLine
	JNZ	a2
b0:	MOV	AL,#13		; Get Return
a2:	CALL	putc
	CMP	AL,#13
	JNZ	<b9
	MOV	AL,#10		; Include LF
	JMP	<a2
; Output spaces
a3:	AND	AL,#$7F
	MOV	BL,AL
a4:	MOV	AL,#' '
	CALL	putc
	DEC	BL
	JNZ	a4
	JMP	<b9
; End of section
a9:	CMP	AH,#'?'		; All?
	JNZ	<a0
	MOV	AL,[SI]
	INC	SI
	AND	AL,AL		; End
	JNZ	<b0
; Exit
a0:	MOV	AX,#$4C00
	INT	$21
putc:	PUSH	BX
	PUSH	AX
	MOV	DX,SP		; Data address
	MOV	CX,#1		; Write one character
	MOV	BX,#1		; stdout
	MOV	AH,#$40		; DOS WRITE Function
	INT	$21			; Write to file
	POP	AX
	POP	BX
	RET
;
Help:
	DB	'-','-','-','-','*','-','-','-','-','0','-','-','-','-','*','-','-','-'
	DB	'-','1','-','-','-','-','*','-','-','-','-','2',10,132,'A',10,137
	DB	'B',10,136,'C',138,'D',10,0
#endif
