// CL
#include <stdio.h>
#include <dvmvideo.h
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	POOL		30000
#define	CLIPS		300
#define	LINES		22
#define	WIDTH		79

#define	O_SORT		0x01

// ClipList item flags
#define	F_NSHOW		0x80	// Never Show
#define	F_NSDEP		0x40	// "" unless dependent
#define	F_TOU		0x20	// Touched
#define	F_DEP		0x04	// Is dependent
#define	F_SEL		0x03	// Select flags

unsigned
	Line,			// Read Line#
	Seg, Stop,		// Dependency segment
	CLsel,			// Selected list entry
	CLStop,			// ListScreen Top
	LKpos,			// LookupPosition
	MaxLen,			// Maximum select item length
	CLtop,			// Top of ClipList
	SLtop,			// "" sported
	Ptop,			// "" string pool
	CLdep[CLIPS],	// ClipList dependencies
	CLsort[CLIPS];	// ClipList sorted indexes
FILE
	*fpi,
	*fpo;
unsigned char
	*Ptr,
	*CLname[CLIPS],	// ClipList names
	Opt = O_SORT,	// Command line options
	_VColor_,		// Current VideoColor
	CLflg[CLIPS],	// ClipList flags
	Buffer[256],	// General buffer
	CLfile[128],	// ClipList file
	Title[128],		// "" title
	Temp[128],		// Temp buffer
	Pool[POOL];		// StringStorage

#define	VNOR	0x17
//Video attributes	Nsel  Dep	Sel	  SelDep
unsigned Vnor[] = { VNOR, 0x15, 0x12, 0x13 };
unsigned Vhil[] = { 0x71, 0x75, 0x72, 0x73 };

//ChtTxt R:\Help.h
#include "R:\\Help.H"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

//Close video display
unsigned VClose(void)
{
	if(_VColor_) {
		Vclose();
		_VColor_ = 0; }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	VClose();
	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	MemTst(0);
	exit(-1);
}

// Print char/string/newline
void Pc(unsigned char c)
{
	if(_VColor_) {
		Vputc(c);
		return; }
	putc(c, fpo);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Parse string from input stream
unsigned Parse(unsigned char *p)
{
	unsigned i;

	Skip(); i = 0;
a1:	switch(p[i] = *Ptr) {
	default: ++Ptr; ++i;	goto a1;
	case ' ' :
	case '\t':
	case 0 : p[i] = 0; }
	return i;
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?PoolOver"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

// Write segment Word
void WsegW(unsigned v)
{
	pokew(Seg, Stop, v);
	Debug(("Seg%04x=%u\n", Stop, v))
	if(!(Stop += 2))
		Error("?SegOver");
}

unsigned char *CLnameX(unsigned i)
{
	unsigned char *p;
	if(*(p = CLname[i]) & 0x80)
		return p+1;
	return p;
}

// Lookup name
unsigned LookUp(unsigned char *n)
{
	unsigned i;
	for(i=0; i < CLtop; ++i) {
		if(!strcmp(CLnameX(i), n)) {
			LKpos = i;
			return 7; } }
	return 0;
}

// Set Video Color if different
void VColor(unsigned char c)
{
	if(c != _VColor_)
		Vcolor(_VColor_ = c);
}

// Display message at bottom of screen
register Message(unsigned args)
{
	unsigned i;
	unsigned char buf[128];
	i = _format_(nargs()*2+&args, buf);
	Vgotoxy(0, 24);
	Vcleol();
	i = (80-i)/2;
	while(i--) Pc(' ');
	Vputs(buf);
}

// Issue help message
void Help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

// Resolve symbols to display/dependencies
void Resolve(void)
{
	unsigned i, j, k;
	unsigned char c;
	for(i=0; i < CLtop; ++i) {	// Clear dependencies
		CLflg[i] &= ~1; }
	while(i--) {				// Mark/select dependencies
		Debug(("%-4u%02x'%s'%u", i, CLflg[i], CLnameX(i), CLdep[i]))
		if(CLflg[i] & F_SEL) {
			if(j = CLdep[i]) {
				--j;
				while(k = peekw(Seg, j)) {
					j += 2;
					c = F_DEP|1;
					if(CLflg[k-1] & F_TOU)	// name touched
						c = F_DEP;			// don't auto select
					Debug((" %u", k-1))
					CLflg[k-1] |= c; } } }
		Debug(("\n"))
	}

	for(SLtop = i = 0; i < CLtop; ++i) {	// Build list to display
		if((c = CLflg[i]) & F_NSHOW)		// never display
			continue;
		if((c & (F_NSDEP|F_TOU|F_SEL)) != F_NSDEP)	// Not NSDEP
			CLsort[SLtop++] = i; }
	if(Opt & O_SORT) {						// Sort names to display
		for(i=0; i < SLtop; ++i) {
			j = i;
			while(++j < SLtop) {
				if(strcmp(CLname[CLsort[j]], CLname[CLsort[i]]) & 0x8000) {
					k = CLsort[i];
					CLsort[i] = CLsort[j];
					CLsort[j] = k; } } } }
}

// Present interactive list and allow names to be selected
void ListSel(void)
{
	unsigned i, q, s, x, y, yy;
	unsigned char c;

a0:	Vgotoxy((80-strlen(Title))/2, 0);
	Vputs(Title);

	yy = WIDTH/MaxLen;
a1:	Resolve();
a2:	if(CLsel & 0x8000)	{ CLsel = 0;		}
	if(CLsel >= SLtop)	{ CLsel = SLtop-1;	}
	if(CLsel < CLStop)	CLStop = CLsel;
	i = yy*LINES;
	while((CLStop+i) <= CLsel)
		++CLStop;
	Vgotoxy(y = x = 0, 0);
	for(q = CLStop; q < SLtop; ++q) {
		c = CLflg[s = CLsort[q]];
		if((x+MaxLen) > WIDTH) {
			x = 0;
			if(++y >= LINES)
				break;
			Vcleol(); }
		Vgotoxy(x, y+2);
		Vcolor((q == CLsel) ? Vhil[c & F_SEL] : Vnor[c & F_SEL]);
		Vputs(Ptr = CLnameX(s));
		VColor(VNOR);
		for(i = strlen(Ptr); i < MaxLen; ++i)
			Vputc(' ');
		x += MaxLen; }
	Vcolor(VNOR);
	Vcleos();
	Message("Help: '?'");
	s = CLsort[CLsel];
//	Message("[%u:%u %u %u]", CLtop, SLtop, CLsel, s);
b1:	switch(i = Vgetk()) {
	case _KLA:	i = 1;	goto b2;	// Advance item
	case _KUA:	i = yy;	goto b2;	// "" line
	case _KPU:	i = yy * (LINES-1);	// "" screen
b2:		CLsel -= i;
		goto a2;
	case _KRA:	i = 1;	goto b3;	// Backup item
	case _KDA:	i = yy;	goto b3;	// "" line
	case _KPD:	i = yy * (LINES-1);	// "" screen
b3:		CLsel += i;
		goto a2;
	case _CPU:					// Move to first
	case _KHO:	CLsel = 0;		goto a2;
	case _CPD:					// Move to last
	case _KEN:	CLsel = SLtop;	goto a2;
	case 0x1B:	// Emergency escape
		Error("?Abort");
	case '\n':	// Accept selections
	case _K10:
		return;
	case '?':	// Display help
		Vclscr();
		Help(Ihelp);
		Message("Press ANY key!");
		Vgetk();
		Vclscr();
		goto a0;
	case _K1:	// Recalc dependencies
		for(i=0; i < CLtop; ++i)
			CLflg[i] &= ~(F_TOU|F_DEP);
		goto a1;
/*ChtTxt Ihelp
CLip select - Interactive commands:~n~n
	  ~</~>		Move one item
	  ~^/~v		"" Line
   PgUp/PgDn	"" screen
   Home/End		"" to first/last
	 Space		toggle
	 Enter		accept
	  F1		re-evaluate dependencies
	 Esc		quit
*/
	}
	c = CLflg[s];
	if(CLsel < SLtop) switch(i) {
		case ' ':	// Toggle select
			if(c & 3)	// Selected - clear all
				c &= ~3;
			else		// otherwise select
				c |= 2;
			CLflg[s] = c | F_TOU;
			goto a1;
	} goto b1;
}

#if 0
void DumpCL(void)
{
	unsigned i, j, k;
	for(i=0; i < CLtop; ++i) {
		printf("%-4u%02x'%s'", i, CLflg[i], CLnameX(i));
		if(j = CLdep[i]) {
			--j;
			while(k = peekw(Seg, j)) {
				printf(" '%s'", CLnameX(k-1));
				j += 2; } }
		putc('\n', stdout); }
}
#else
	#define	DumpCL(a)
#endif

// Put "Sort" prefix on name string
unsigned char *STRsort(unsigned char *p)
{
	unsigned c, v;
	if(*p == '{') {
		v = 0;
		while((c = *++p - '0') < 10) {
			v = (v * 10)+c; }
		Debug(("[%u]", v))
		if((*p != '}') || v & 0xFF80)
			Error("?[sort]");
		*p = v | 0x80; }
	return p;
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	fpo = stdout;
	MemTst(7);

	i = 0;
	while(++i < argc) {			// Command line arguments
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:
he:				Error("for help: CL -?");
/*ChtCom Chelp
CLip select

use:	CL	[lib] [options]

lib:	CLip library to use (%DDCDATA%\lib.CL)							[CL]

opts:	-S	do not Sort

Select text from library .CL file and place in:	%DDTMP%\CL
												 %TEMP%\CL
														CL
for details on .CL file format: CL -?F 

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'S':	c = O_SORT;
				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(*Buffer) goto he;
		strcpy(Buffer, Ptr); }

	// Find .CL data file
	if(!getenv("DDCDATA", CLfile))
		Error("?DDCDATA");
	LKpos = c = 0;
	while(CLfile[LKpos])
		c = CLfile[LKpos++];
	if(c != '\\')
		CLfile[LKpos++] = '\\';
	strcpy(CLfile+LKpos, "CL.CL");
	if(*Buffer) {	// Specified
		strupr(Buffer);
		strcpy(CLfile+LKpos, "*.CL");
		Stop = strlen(Buffer);
		if(find_first(CLfile, 0, Temp, &i, &i, &i, &i, &i))
			Error("?%s", CLfile);
		do {	// Find matches
			Debug(("'%s'\n", Temp))
			Pstring(Temp);
			if(strbeg(Temp, Buffer)) {
				strcpy(CLfile+LKpos, Temp);
				if(Temp[Stop] == '.')
					goto a1;	// Exact
				++Seg; }
		} while !find_next(Temp, &i, &i, &i, &i, &i);
		if(Seg != 1) {
			Ps("Available:\n");
			i = 0;
			while(i < Ptop) {
				printf(" %s\n", Pool+i);
				while(Pool[i++]); }
			goto he; } }

	// Read .CL data file and build select database
a1:	Seg = alloc_seg(4096);
	Stop = Ptop = 0;
	fpi = fopen(CLfile, "rvq");
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fpi)) {
		++Line;
		if(*Ptr == '=') {
			c = 0;
			switch(*++Ptr) {
			case '=':	strcpy(Title, Ptr+1);		// Set Title
			case ';':	continue;					// Comment
			case '-':	c = F_NSHOW;	goto b1;	// Never show
			case '+':	c = F_NSDEP;				// Show when selected
b1:				++Ptr; }
			if(!Parse(Temp))
				Error("?Name");
			if(LookUp(Temp))
				Error("?Dup'%s'", Temp);
			if(CLtop >= CLIPS)
				Error("?TooManyClips");
			if((i = strlen(Temp)) > MaxLen)
				MaxLen = i;
			CLname[CLtop] = Pstring(STRsort(Temp));
			if(Skip()) {
				Debug(("'%s'", Temp))
				CLdep[CLtop] = Stop+1;
				while(Parse(Temp)) {
					if(!LookUp(Temp))
						Error("?dep'%s'\n", Temp);
					WsegW(LKpos+1); }
				WsegW(0); }
			CLflg[CLtop++] = c; } }
	fclose(fpi); Line = 0;
/*ChtCom Fhelp
.CL file format:

'=' in column1 indicates a SpecialAction:

=; ignored (comment)
==title to show

={n}name [depeandency name]...
	{n} (optional) sort level {0-127} - close to first
	If dependency names, those are auto selected with "name"
=-""	as above, "name" never appears available to select (dependency only)
=+""	as above, "name" only appears if it has been selected

	all following lines (till next =SpecialAction) are included only if the
	preceeing =[-+] has been selected
*/

	if(!CLtop)
		Error("?NoItems");
	++MaxLen;	// Allow space between

	// Perform interactive selection
	Vopen(_VColor_ = VNOR);
	ListSel();
	VClose();

	// Get output file location
	LKpos = c = 0;
	if(getenv("DDTMP", Temp)) goto c1;
	if(getenv("TEMP" , Temp)) {
c1:		while(Temp[LKpos])
			c = Temp[LKpos++];
		if(c != '\\')
			Temp[LKpos++] = '\\'; }
	strcpy(Temp+LKpos, "CL");
	Debug(("O'%s'\n", Temp))

	// Write clipped sections
	fpi = fopen(CLfile, "rvq");
	fpo = fopen(Temp, "wvq");
	i = c = 0;
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fpi)) {
		++Line;
		if(*Ptr == '=') {
			if(Ptr[1] != '=') {
				if(i >= CLtop)
					Error("?sel%u", i);
				c = CLflg[i++]; }
			continue; }
		if(c & F_SEL) {
			Ps(Buffer);
			Pc('\n'); } }
	fclose(fpo); fpo = stdout;
	fclose(fpi);

	MemTst(0);

}
