#include <stdio.h>

#define	SIG		0x03		// Signature offset
#define	NAME	0x0C		// Name offset
#define	ADDR	0x30
#define	IRQ		0x32
#define	DMA		0x39
#define	VERSION	0x33

#include "D:SB15.h"
#include "D:SB20.H"
#include "D:SBPRO.h"
#include "D:SB16.H"

unsigned
	index,
	crl,
	crh,
	nop,
	size;
unsigned char
	*image,
	*pp;

static unsigned char *names[] =
	{ "1.5", "2.0", "PRO", "16" };
static unsigned xsize[] =
	{ sizeof(sb15), sizeof(sb20), sizeof(sbpro), sizeof(sb16) };
static unsigned xcrl[] =
	{ 0x273, 0x273, 0x53F, 0x3A8 };
static unsigned xcrh[] =
	{ 0x278, 0x278, 0x544, 0x3AD };
static unsigned char *ximage[] =
	{ &sb15, &sb20, &sbpro, &sb16 };

int strcp(unsigned char *s1, unsigned char *s2)
{
	do {
		if(toupper(*s1) != *s2++)
			return 0; }
	while(*s1++);
	return -1;
}

select_drv(unsigned i)
{
	image = ximage[index = i];
	size = xsize[i];
	crl = xcrl[i];
	crh = xcrh[i];
}

display_drv()
{
	printf("Settings for Sound Blaster %s driver:\n", names[index]);
	printf("  Version    : %u.%02u, size: %u\n", image[VERSION+1], image[VERSION], size);
	printf("  Address    : %04x\n", *(unsigned*)(image+ADDR));
	printf("  Interrupt  : %u\n", image[IRQ]);
	printf("  DMA        : %u\n", image[DMA]);
	printf("  DSP version: %u.%02x - %u.%02x\n",
		image[crl+1], image[crl], image[crh+1], image[crh]);
}

unsigned get(unsigned base, unsigned char t)
{
	unsigned c, v;
	v = 0;
	while(c = *pp++) {
		if(c == t)
			return v;
		if(c == '.')
			continue;
		if(isdigit(c))
			c -= '0';
		else if((c >= 'a') && (c <= 'f'))
			c -= ('a'-10);
		else if((c >= 'A') && (c <= 'F'))
			c -= ('A'-10);
		else
			c = 100;
		if(c >= base) {
			printf("Bad digit: %c\n", *(pp-1));
			exit(-1); }
		v = (v * base) + c; }
	if(t)
		abort("Expected '-value'\n");
	return v;
}

char help[] = { "\n\
Build CT-VOICE driver for most ISA Sound-Blaster cards\n\n\
Use: SBDRV <card> [options]\n\n\
card:	1.5	= Sound Blaster-1.x\n\
	2.0	= Sound Blaster-2.x\n\
	Pro	= Sound Blaster-Pro\n\
	16	= Sound Blaster-16\n\n\
Opts:	Ax	= Set default address (hex)\n\
	In	= Set default IRQ (0-15)\n\
	Dn	= Set default DMA channel (0-7)\n\
	Vx-x	= Set accepted card versions\n\n\
example: SBDRV 16 A220 I7 D1 V4.00-4.99\n\n\
    Builds CT-VOICE.DRV for Sound Blaster-16 with:\n\
	default-address       = 220\n\
	default-irq           = 7\n\
	default-dma channel   = 1\n\
	Accepted DSP versions = 4.00 through 4.99\n\n\
Voice drivers: Copyright 1989-2005 Creative Technology Ltd.\n" };


main(int argc, char *argv[])
{
	unsigned i;
	FILE *fp;

	if(argc < 2)
		goto dohelp;

	for(i=0; i < 4; ++i) {
		if(strcp(argv[1], names[i]))
			goto found; }
dohelp:
	abort(help);
found:
	select_drv(i);
	for(i=2; i < argc; ++i) {
		pp = argv[i];
		switch(toupper(*pp++)) {
		case 'A' : *(unsigned*)(image+ADDR) = get(16, 0);	continue;
		case 'I' : image[IRQ] = get(10, 0);				continue;
		case 'D' : image[DMA] = get(10, 0);				continue;
		case 'V' :
			*(unsigned*)(image+crl) = get(16, '-');
			*(unsigned*)(image+crh) = get(16, 0);		continue; }
		printf("Unknown option: %s\n", argv[i]);
		return; }
	display_drv();

	fp = fopen("CT-VOICE.DRV", "wvqb");
	fput(image, size, fp);
	fclose(fp);
}
