#include c:\mc\stdio.h
#include c:\mc\window.h

#define	VIDEO_SIZE 2000

#define	UP		0x4800
#define	DOWN	0x5000
#define	LEFT	0x4B00
#define	RIGHT	0x4D00
#define	INS		0x5200
#define	DEL		0x5300
#define	HOME	0x4700
#define	END		0x4F00
#define	PGUP	0x4900
#define	PGDN	0x5100
#define	F1		0x3B00
#define	F2		0x3C00
#define	F3		0x3D00
#define	F4		0x3E00
#define	F5		0x3F00
#define	F6		0x4000
#define	F7		0x4100
#define	F8		0x4200
#define	F9		0x4300
#define	F10		0x4400
#define	AF1		0x6800

int attr = 0x07, xchr = ' ';

char welcome_text[] = "
SCREEN - Text screen editor for CAM\n\n
   ?COPY.TXT 1995-2005 Dave Dunfield.\n
        -- see COPY.TXT --.\n\n
Press ALT-F1 for key function list.";

char help_text[] = "
SCREEN - ?COPY.TXT 1995-2005 Dave Dunfield.\n\n
F1   - Select/enter character        F5   - Select/enter attribute\n
F2   - Repeat character horizontal   F6   - Repeat attribute horizontal\n
F3   - Repeat character vertical     F7   - Repeat attribute vertical\n
F4   - Pickup character at cursor    F8   - Pickup attribute at cursor\n\n
F9   - Clear screen char/attr        F10  - Exit SCREEN\n\n
Home - Go to start of line           End  - Go to End of line\n
Ins  - Insert character horizontal   Del  - Delete character horizontal\n
PgUp - Insert character vertical     PgDn - Delete character vertical\n\n
Press any key to proceed.";

char *exit_menu[] = {
	"Return to editor",
	"Exit and save screen",
	"Quit without saving",
	0 };

/*
 * Position the cursor
 */
gotoxy(x, y) asm
{
	MOV	AH,02h
	XOR BH,BH
	MOV	DH,4[BP]
	MOV	DL,6[BP]
	INT	10h
}

/*
 * Clear screen to specified attribute and character
 */
clear_screen(int a, int c)
{
	c += (a << 8);
	for(a=0; a < VIDEO_SIZE; ++a)
		pokew(W_BASE, a+a, c);
}

/*
 * Main program
 */
main(int argc, char *argv[])
{
	int i, x, y, k, l;
	unsigned j;
	FILE *fp;
	static char wflag = 0;

	if(argc < 2)
		abort("\nUse: screen [filename]\n\n?COPY.TXT 1995-2005 Dave Dunfield\n -- see COPY.TXT --.\n");

	fp = fopen(argv[1], "rvb");

	wopen(0, 0, 80, 25, WCOPEN|NORMAL);
	wclose();

	clear_screen(0x07, ' ');
	gotoxy(j = x = y = 0, 0);

	if(fp) {
		while((i = getc(fp)) >= 0) {
			poke(W_BASE, j, i);
			if(++j > (VIDEO_SIZE*2))
				break; }
		fclose(fp); }

	wopen(21, 8, 37, 8, WSAVE|WCOPEN|WBOX2|REVERSE);
	wputs(welcome_text);

top:
	if(x < 0) x = 79, --y;
	if(x > 79) x = 0, ++y;
	if(y < 0) y = 24;
	if(y > 24) y = 0;
	gotoxy(x, y);
	j = ((y * 80)+x) * 2;
	i = kbget();
	if(!wflag) {
		wclose();
		wflag = -1; }
	switch(i) {
		case UP :	--y;	goto top;
		case DOWN:	++y;	goto top;
		case RIGHT:	++x;	goto top;
		case LEFT:	--x;	goto top;
		case HOME:	x = 0;	goto top;
		case END:	x = 79;	goto top;

		case F1 :	/* Select special character */
			if(get_box()) goto writexchar;
			if(get_char()) goto writexchar;
			goto top;
		case F2 :	/* Re-write last character in block & advance X */
			++x;
			goto writexchar;
		case F3 :	/* Re-write last character in block & advance Y */
			++y;
		writexchar:
			pokew(W_BASE, j, (attr << 8)+xchr);
			goto top;
		case F4 :	/* Get special character */
			xchr = peek(W_BASE, j);
			goto top;

		case F5 :	/* Select video attribute */
			if(get_attr()) goto setattr;
			goto top;
		case F6 :	/* Set attribute & advance X */
			++x;
			goto setattr;
		case F7 :	/* Set attribute & advance Y */
			++y;
		setattr:
			poke(W_BASE, j+1, attr);
			goto top;
		case F8 :	/* Pickup video attribute */
			attr = peek(W_BASE, j+1);
			goto top;

		case F9 :	/* Clear screen to char/attr */
			if(get_char() && get_attr())
				clear_screen(attr, xchr);
			goto top;

		case INS :	/* Insert char horizontal */
			k = peekw(W_BASE, j);
			for(i=x; i <80; ++i) {
				l = peekw(W_BASE, j += 2);
				pokew(W_BASE, j, k);
				k = l; }
			goto top;
		case DEL :	/* Delete char horizontal */
			for(i=x; i < 79; ++i) {
				pokew(W_BASE, j, peekw(W_BASE, j+2));
				j += 2; }
			poke(W_BASE, j, ' ');
			goto top;
		case PGUP :	/* Insert char horizontal */
			k = peekw(W_BASE, j);
			for(i=y; i < 25; ++i) {
				l = peekw(W_BASE, j+= 160);
				pokew(W_BASE, j, k);
				k = l; }
			goto top;
		case PGDN :	/* Delete char vertical */
			for(i=y; i < 24; ++i) {
				pokew(W_BASE, j, peekw(W_BASE, j+160));
				j += 160; }
			poke(W_BASE, j, ' ');
			goto top;

		case AF1:
			wopen(2, 4, 74, 16, WSAVE|WBOX1|WCOPEN|REVERSE);
			wcursor_off();
			wputs(help_text);
			wgetc();
			wclose();
			goto top;

		default:
			if(!(i & 0xFF00)) {
				pokew(W_BASE, j, (attr << 8) + i);
				++x; }
			goto top;
		case F10 : }

	i = 0;
	if(wmenu(30, 10, WSAVE|WCOPEN|WBOX1|REVERSE, exit_menu, &i) || !i)
		goto top;

	if(i == 1) {
		fp = fopen(argv[1], "wvqb");

		for(j=0; j < (VIDEO_SIZE*2); ++j)
			putc(peek(W_BASE, j), fp);
		fclose(fp); }

	clear_screen(0x07, ' ');
	gotoxy(0, 0);
}

/*
 * Choose character
 */
get_char()
{
	unsigned char i;
	static unsigned char ch = 0xC4 - 10;

	wopen(35, 1, 9, 23, WSAVE|WCOPEN|WBOX3|NORMAL);
	wcursor_off();

	for(;;) {
		for(i=0; i < 21; ++i) {
			wgotoxy(0, i);
			*W_OPEN = (i == 10) ? REVERSE : NORMAL;
			wprintf(" %02x -", i + ch);
			*W_OPEN = NORMAL;
			wputc(' ');
			wputc((unsigned)(i+ch) | 0x0100); }
		switch(i = wgetc()) {
			case _KUA :	--ch;		break;
			case _KDA : ++ch;		break;
			case _KPU :	ch -= 20;	break;
			case _KPD :	ch += 20;	break;
			case _KHO :	ch = -10;	break;
			case _KEN :	ch = 0x76;	break;
			case '\n' :
				xchr = ch + 10;
				wclose();
				return -1;
			case 0x1B :
				wclose();
				return 0;
			default:
				if(!(i & 0x80))
					ch = i - 10; } }
}

/*
 * Get a box character
 */
get_box()
{
	int i;
	static int n = 0;
	static unsigned char boxchars[] = {
		0xB3, 0xBA, 0xC4, 0xCD, 0xC5, 0xD8, 0xD7, 0xCE,
		0xDA, 0xBF, 0xC0, 0xD9, 0xC3, 0xB4, 0xC2, 0xC1,
		0xD5, 0xB8, 0xD4, 0xBE, 0xC6, 0xB5, 0xD1, 0xCF,
		0xD6, 0xB7, 0xD3, 0xBD, 0xC7, 0xB6, 0xD2, 0xD0,
		0xC9, 0xBB, 0xC8, 0xBC, 0xCC, 0xB9, 0xCB, 0xCA };

	wopen(30, 7, 20, 13, WSAVE|WCOPEN|WBOX1|REVERSE);

	/* Draw the characters */
	for(i=0; i < sizeof(boxchars); ++i) {
		wgotoxy(((i&7)*2+1), ((i/8)*2)+1);
		wputc(boxchars[i]); }

	for(;;) {
		wgotoxy(((n&7)*2)+1, ((n/8)*2)+1);
		switch(i = wgetc()) {
			case _KRA :
				n = (n & 0xF8) | ((n+1) & 0x07);
				break;
			case _KLA :
				n = (n & 0xF8) | ((n-1) & 0x07);
				break;
			case _KDA :
				if((n += 8) >= sizeof(boxchars))
					n -= sizeof(boxchars);
				break;
			case _KUA :
				if((n -= 8) < 0)
					n += sizeof(boxchars);
				break;
			case '\n' :
				xchr = boxchars[n];
				wclose();
				return -1;
			case 0x1B :
				wclose();
				return 0; } }
}

/*
 * Get forground\background color
 */
get_attr()
{
	int c, f, b;
	b = attr >> 4;
	f = attr & 0x0F;

	for(;;) {
		wopen(30, 10, 20, 5, WSAVE|WCOPEN|WBOX2|NORMAL);
		wprintf("Forground: %u\nBackground: %u\n", f, b);
		*W_OPEN = (b << 4) | f;
		wputs(" * TEST * ");
		c = wgetc();
		wclose();
		switch(c) {
			case _KUA :
				f = (f < 15) ? f+1 : 0;
				break;
			case _KDA :
				f = f ? f-1 : 15;
				break;
			case _KRA :
				b = (b < 15) ? b+1 : 0;
				break;
			case _KLA :
				b = b ? b-1 : 15;
				break;
			case '\n' :
				attr = (b << 4) | f;
				return -1;
			case 0x1B :
				return 0; } }
}
