// DBBD
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	MemTst(a)

#define	CPM	0xAAAA
#define	CPX	0x5555

#define	TFILE		"$DBBD$.TMP"
#define	VCOL		64
#define	POOL		8192
#define	CWIDTH		64
#define	PGMNAME		"DBBD.COM"
#define	TSTB		""//"boot\\"
//#define	OFILE	"R:\\PBZ.TXT"

#define	O_A			0x01
#define	O_B			0x02
#define	O_C			0x04
#define	O_PACK		0x08	// Pack files to DSKIMG
#define	O_NEW		0x10	// "" new DSKIMG
#define	O_PATCH		0x20	// NewLocation
#define	O_KEEP		0x40
#define	O_DBX		0x80
//#define	O_AUTO		0x80

#define	M_RECURSE	0x80
#define	M_DIR		0x40
#define	M_FILE		0x20
#define	M_SHOW		0x00
#define	M_DELETE	0x01

unsigned
	V,
	Wx,	Wy = 768,
	Nic,
	Rsize = 4096,
	Csize,
	Sh, Sl, At, Ti, Da,
	Rseed,
	Ttop,
	Dtop,
	Ptop;
FILE
	*fp;
unsigned char
	*Ptr,
	**DELL,
	*ZipImg,
	Rletter = 'C',
	Opt = O_KEEP|O_DBX,
	DBGf = 255,
	Boot,
	Mode,
	Home[128],
	Path[128],
	Dir[128],
	HostID[128] = "127.0.0.1",
	Ofile[128],			// Output
	Cfile[128],			// Cdrive
	TmpFile[128],
	Temp1[128],
	Temp[16384],
	Pool[POOL];
//#define	TMPO	7936
unsigned char *DEList1[] = {
	"DOSBOX.*",
	"MSVC*.DLL",
	"SDL*.DLL",
	0 };
unsigned char *DEList2[] = {
	"*.SYS",
//	"EMM386.EXE",
//	"FDISK.EXE",
//	"FORMAT.COM",
	"AUTOEXEC.BAT",
	0 };
unsigned char *DBfiles[] = {
	"MSVCP71.DLL",
	"MSVCR71.DLL",
	"SDL.DLL",
	"SDL_NET.DLL",
	0 }
unsigned char *PKZno[] = {
	"PKZIP (R",
	"Copr.",
	"PKZIP Reg",
	"\xFE ",
	0 };
unsigned char	*DSKIno[] = {
	"Injecting",
	0 };

#include "R:\\Help.h"

#define	Cmd		Dir
#define	Dcmd	HostID
#define	Zip		Sh
#define	Ctop	Sl

void Pc(unsigned char c)	{	putc(c, fp);		}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}
void Nl(void)				{	putc('\n', fp);	}
void NlS(void)				{	putc('\n', stdout);	}

void GoHome(void)
{
	if(*Home) {
		set_drive(*Home - 'A');
		cd(Home);
		*Home = 0; }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	GoHome();
	exit(-1);
}

register Dprintf(unsigned args)
{
	unsigned i;
	unsigned char buf[128];
	i - nargs();

	if(!DBGf) {
		_format_(i*2+&args, buf);
		fputs(buf, stdout); }
}

FILE *Fopen(unsigned char *dn, unsigned char *fn, unsigned char *o)
{
	unsigned i, dt, ft, pt;
	unsigned char c;
	dt = ft = pt = i = 0;

a1:	switch(fn[i++]) {
	case ':':
	case'\\':	ft = i;
	default	:	goto a1;
	case 0	:	; }
	Debug(("Fn'%s'%s'%u'\n", fn, fn+ft, ft))

	if(ft) {
		if(fp = fopen(fn, o)) {
			strcpy(dn+1, fn);
			*dn = ft+1;
			goto a4; } }

a2:	dt = 0;
a3:	switch(c = Path[pt++]) {
	default	:	dn[++dt] = c;
	case ' ':
	case'\t':	goto a3;
	case ';':
	case 0	:	;	}
	Debug(("[%c]", dn[dt]))
	if(dn[dt] != '\\')
		dn[++dt] = '\\';
	strcpy(dn+dt+1, fn+ft);
	if(fp = fopen(dn+1, o)) {
		*dn = dt+1;
		goto a4; }
	Debug(("!'%s'\n", dn+1, *dn))
	if(c)	goto a2;
	Error("Cannot find: %s\n", dn+ft);
a4:	Debug(("='%s'%u\n", dn+1, *dn))
	return fp;
}
void Fclose(void)
{
	if(fp && (fp != stdout))
		fclose(fp);
	fp = stdout;
}

void TFname(void)
{
	unsigned char c;
	switch(Opt & 7) {
	default	:	Error("?to -A or -B only!");
	case O_A:	c = 'A';	break;
	case O_B:	c = 'B';	}
	TmpFile[Ttop] = c;
	TmpFile[Ttop+1] = 0;
}
void TFtemp(void)				{	strcpy(TmpFile+Ttop, TFILE);			}
void TFzip(void)				{	sprintf(TmpFile+Ttop, "Z%u.ZIP", Zip);	}
unsigned char *Tfile(void)		{	return TmpFile+2;						}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?PoolOverFlow"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

unsigned Scmd(unsigned char *cs)
{
	unsigned char *p;
	putc('>', stdout);
	p = cs;
a1:	switch(*p) {
	default	:
		putc(*p++, stdout);
		goto a1;
	case '>':
	case 0	:	; }
//	fputs(cs, stdout);
	NlS();
	if(!DBGf)
		return 255;
	system(cs);
	return 0;
}

void Xcd(unsigned char *p)
{
	unsigned i;
	unsigned char c;
	if(p)
		strcpy(Temp1, p);
	else {
		strcpy(Temp1, TmpFile+2);
//		i = Ttop - (Ttop > 5);
//		tmp[i] = 0;
//		p = Temp+(TMPO+2); }
		Temp1[Ttop-2] = 0; }
	i = strlen(Temp1)-1;
	if((i > 2) && (Temp1[i] == '\\'))
		Temp1[i] = 0;
	Debug(("Cd'%s'\n", Temp1))
	if(Temp1[1] == ':') {
		set_drive(c = toupper(*Temp1) - 'A');
		if(get_drive() != c) {
e1:			Error("?cd'%s'", Temp1); } }
	
	if(cd(Temp1))	goto e1;
#if 0
	Debug(("Cd'%s'", Temp1))
	system("cd");
#endif
}

int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 15;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}

void GoFile(void)
{
	unsigned i;
	unsigned char *p;
	Debug(("Gf'%s'\n", Dir))
	switch(Mode & 15) {
	default			:	Error("?mode%u", Mode);
	case M_SHOW		:	printf("Sf'%s'\n", Dir);	return;
	case M_DELETE	:
		i = 0;
		while(p = DELL[i++]) {
			if(Fmatch(Temp, p)) {
				Debug(("Del'%s'\n", Dir))
				delete(Dir);
			} }
		return;
	}
}
void GoDir(void)
{
	Debug(("Gd'%s'\n", Dir))
	switch(Mode & 15) {
	default			:	Error("?mode%u", Mode);
	case M_SHOW		:	printf("Sd'%s'\n", Dir);	return;
	case M_DELETE	:	//rmdir(Dir);
	}
}

//void RecOn(void)	{	Opt |= O_RECURSE;	}
//void RecOff(void)	{	Opt &= ~O_RECURSE;	}

void DoDir(void)
{
	unsigned i, dt, pt;
	pt = Ptop;
	dt = Dtop;
	while(Dir[Dtop]) ++Dtop;
	if(Dir[Dtop-1] != '\\')
		Dir[Dtop++] = '\\';
	strcpy(Dir+Dtop, "*.*");
	Debug(("D1'%s'%u\n", Dir, Dtop))
	if(find_first(Dir, 0x3F, Temp, &Sh, &Sl, &At, &Ti, &Da)) {
		Debug(("Nf'%s'\n", Dir))
		goto ex; }
	do {
		if(At &= (DIRECTORY|SYSTEM|HIDDEN|VOLUME)) {
			if((At == DIRECTORY) && (*Temp != '.'))
				Pstring(Temp);
			continue; }
		if(Mode & M_FILE) {
			strcpy(Dir+Dtop, Temp);
			GoFile(); } }
	while !find_next(Temp, &Sh, &Sl, &At, &Ti, &Da);
	i = pt;
	while(i < Ptop) {
		if(Mode & M_RECURSE) {
			strcpy(Dir+Dtop,  Pool+i);
			DoDir(); }
		if(Mode & M_DIR) {
			strcpy(Dir+Dtop,  Pool+i);
			GoDir(); }
		while(Pool[i++]); }
ex:	Dir[Dtop = dt] = 0;
	Ptop = pt;
}

register System(unsigned args)
{
	unsigned *up, i;
	unsigned char *s, *e, c, buf[128];
	FILE *fp;

	s = *(up = (nargs()-1)*2 + &args);
	e = *--up;

	i = _format_(up, buf);
	TFtemp();
	strcpy(buf+i, TmpFile);
	Dprintf("<%s'%s'", s||"", e||"");
	if(Scmd(buf))
		return;

	fp = fopen(Tfile(), "rvq");
	c = s ? 0 : 0x55;
	while(fgets(buf, sizeof(buf)-1, fp)) {
		if(s && strbeg(buf, s)) {
			c = 0x55;
			continue; }
		if(e && strbeg(buf, e)) {
			c = 0;
			continue; }
		if(c == 0x55) {
			fputs(buf, stdout);
			NlS(); } }
	fclose(fp);
	delete(Tfile());
}

#define	CPYTMP	Dir
unsigned Copy(void)
{
	unsigned i, j;
	FILE *fpo;
	printf("Add %s\n", CPYTMP+1);
	fpo = fopen(CPYTMP+*CPYTMP, "wbvq");
	j = 0;
	while(i = fget(Temp, sizeof(Temp), fp)) {
		fput(Temp, i, fpo);
		++j;
		if(i < sizeof(Temp))
			break; }
	fclose(fpo);
	Fclose();
	return j;
}

// ------------------------------------------------------- 

unsigned Exist(unsigned char *fn)
{
	FILE *fp;
	if(fp = fopen(fn, "rb")) {
		fclose(fp);
		return 255; }
	return 0;
}

void CmdE(void)
{
	while(Cmd[Ctop]) ++Ctop;
}

register Ncmd(unsigned args)
{
	_format_(nargs()*2+&args, Dcmd);
	Ctop = 0;
//	delete(OFILE);
}

void CPout(void)
{
	unsigned i;
	unsigned char *p;
	FILE	*fpi, *fpo;
#if 0
	i = 0;
	while(p = DELL[i++])
		printf("N'%s'\n", p);
#endif
	TFtemp();
	if(!DBGf)
		return;
	fpi = fopen(Tfile(), "rvq");
//	fpo = fopen(OFILE, "wavq");
	fpo = stdout;
	i = 0;
	while(fgets(Temp, sizeof(Temp)-1, fpi)) {
		if(*Temp) {
			i = 0;
			while(p = DELL[i++]) {
				if(strbeg(Temp, p))
					goto a1; }
			fputs(Temp, fpo);
			putc('\n', fpo); }
a1:		; }
//	fclose(fpo);
	fclose(fpi);
}
	
void Cflush(void)
{
	if(Ctop) {
		CmdE();
		TFtemp();
		strcpy(Cmd+Ctop, TmpFile);
		if(!Scmd(Cmd))
			CPout();
		Ctop = 0; }
}

register Acmd(unsigned args)
{
	unsigned l;
	unsigned char buf[128];
	l = _format_(nargs()*2+&args, buf);
	if(!Ctop) {
a1:		strcpy(Cmd, Dcmd); }
	CmdE();
	if((Ctop+l) >= CWIDTH) {
		Cflush();
		goto a1; }
	strcpy(Cmd+Ctop, buf);
}

unsigned Ext(unsigned char *fn, unsigned char *e)
{
	unsigned i, j;
	i = 0;
a1:	j = 0;
a2:	switch(fn[i++]) {
	case'\\':	goto a1;
	case '.':	j = i;
	default	:	goto a2;
	case 0	:	; }
	if(*e == '.') {
		if(!j) {
			strcpy(fn+i-1, e);
			goto r1; }
		++e; }

	if(j && !strcmp(fn+j, e)) {
r1:		return 255; }
	return 0;
}

void Xrs(void)
{
	unsigned char d;
	d = get_drive();
	set_drive(*TmpFile - 'A');
	system("rescan >NUL:");
	set_drive(d);
}

unsigned Rbyte(void)
{
	return (Rseed = (Rseed * 13709) + 13849) & 255;
}

unsigned Onum(unsigned f)
{
	unsigned v, c;
	v = 0;
	while((c = *Ptr - '0') < 10) {
		v = (v * 10) + c;
		f = ++Ptr; }
	if(!f)
		Error("?BadNumber");
	return v;
}

void GetNic(void)
{
	unsigned x, y, s;
	unsigned char buf[81];
	Ps("Ethernet NIC: ");
	system("realnic");
	s = 0xB000;
//a1:	for(y=0; y < (25*160); y += 160) {
a1:	y = 25*160;
	do {
		y -= 160;
		for(x=0; x < 25; ++x)
			buf[x] = peek(s, y+x+x);
		while(x && (buf[x-1] == ' '))	--x;
		buf[x] = 0;	//	012345678901234
		if(strbeg(buf, "Ethernet NIC: ")) {
			Ptr = buf+14;
			Nic = Onum(0);
			Debug(("[%u]", Nic))
			return; } }
	while(y);
	if((s += 0x800) == 0xB800)
		goto a1;
	Error("?can't find NIC!");
}

void WCfile(unsigned char *e, unsigned char *dst)
{
	unsigned i;
	FILE *fpo;
	unsigned char c, buf[128];
#define	sfn	Temp
	concat(sfn, Pool, e);
	Debug(("WCf'%s'\n", buf))
	if(fp = fopen(sfn, "rv")) {
		fpo = fopen(dst, "wvq");
		while(fgets(buf, sizeof(buf)-1, fp)) {
			i = 0;
a1:			switch(c = buf[i++]) {
			case '?':	switch(buf[i]) {
				case 'R':	putc(Rletter, fpo);			goto a2;
				case 'S':	fprintf(fpo, "%u", Rsize);	goto a2;
				case 'N':
					if(!Nic)
						continue;
a2:					++i;
					goto a1; }
			default	:
				putc(c, fpo);
				goto a1;
			case 0	:	putc('\n', fpo); } }
		fclose(fpo);
		Fclose();
		System(0, 0, "fdi %c -w %s", Boot, dst);
		if(Opt & O_KEEP) {
			Debug(("Del'%s'\n", sfn))
			delete(sfn); } }
#undef sfn
	Fclose();
}

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

unsigned Value(void)
{
	unsigned c;
	unsigned char *p;
	V = 0;
	p = Ptr;
	while((c = *Ptr - '0') < 10) {
		V = (V * 10) + c;
		++Ptr; }
	return (Ptr == p) ? 255 : *Ptr;
}

void Gocf(void)
{
	unsigned i;
	unsigned char *p;
	p = i = 0;
	Debug(("Gcf'%s'%u\n", Temp, x))
a1:	switch(Temp[i]) {
	case ';':	p = Temp+i;
	default	:	++i;	goto a1;
	case 0	:	; }
	if(p) {
		*p++ = 0;
		if(!*Cfile) {
			strcpy(Cfile, p);
			Debug(("Cf'%s'\n", Cfile)) } }
	if(*Temp) {
		if(!*Ofile) {
			strcpy(Ofile, Temp);
			Debug(("Of'%s'\n", Ofile)) } }
}

extern char *ARGV[];
/*void LdOCF(void)
{
	unsigned c, v, m;
	unsigned char *p;
	FILE *fp;
	if(fp = fopen(ARGV[0], "rbv")) {
		m = CPM ^ CPX;
		m ^= CPX;
		p = v = 0;
		while((c = getc(fp)) != EOF) {
			if((v = (v << 8) | c) == m) {
				Debug(("[F]"))
				p = Temp;
				continue; }
			if(p)
				*p++ = c; }
		fclose(fp);
		if(p) {
			Debug(("Ld'%s'\n", Temp))
			*p = 0;
			Gocf(); } }
}*/

void ENdebug(void)
{
	unsigned char *p;
	p = &Dprintf;
	Debug(("%04x %x", p, p[7]))
	p[7] = 0xBB;	// MOV BX
	Debug((" %x\n", p[7]))
}

unsigned Patch(unsigned char *p)
{
	unsigned i, t;
	FILE *fp;
	unsigned char c;
	fp = fopen(ARGV[0], "rbvq");
	t = i = fget(Temp, sizeof(Temp), fp);
	fclose(fp);
	Debug(("R%04x %u", i, t))
	Ptr = Temp;
	while(c = Temp[--i]) {
		Debug(("%5u %x\n", i, c))
		if((c < ' ') || (c > '~'))
			goto a1;
		if(!p)
			*Ptr++ = c; }
	if(!p)
		return *Ptr = 0;
	t = i;
a1:	if(p) {
		Debug(("-%04x %u\n", t, i))
		Temp[t++] = 0;
		i = strlen(p);
		Debug(("'%s'%u\n", p, i))
		while(i)
			Temp[t++] = p[--i];
		fp = fopen(ARGV[0], "wbvq");
//		fp = fopen("R:\\TST.COM", "wbvq");
		fput(Temp, t, fp);
		fclose(fp); }
	return 255;
}

void CheckA(void)	// unzip from right location
{
	unsigned char *p, zip[128];
	if((Boot == 'A') && strcmp(Pool, "*")) {
		Debug1(("Pool'%s'\n", Pool))
		if(ZipImg)
			strcpy(p = zip, ZipImg);
		else {
			strcpy(CPYTMP+*CPYTMP, TSTB#"DBBDBOOT");
			p = CPYTMP+1; }
//		Ext(p, ".ZIP");
		delete(Pool);
		concat(Temp, Pool, ".A"); delete(Temp);
		concat(Temp, Pool, ".C"); delete(Temp);
		System("\xFE", 0, "pkunzip %s %s.*", p, Pool);
		*Temp = Boot;
		Temp[1] = 0;
		delete(Temp);
		rename(Pool, Temp); }
}

void CheckC(void)	// imgmake C if needed
{
	unsigned i;
	unsigned char buf[200];
	FILE *fp;
	Debug(("Cc'%s'\n", Cfile))
	if(*Cfile) {
a1:		fp = fopen(Cfile, "rbvq");
a2:		fclose(fp);
		Rletter = 'R';
		return; }
	strcpy(Cfile, Ofile);
	if(i = strlen(Cfile)) {
		if(Cfile[i-1] != '\\')
			Cfile[i++] = '\\'; }
	strcpy(Cfile+i, "C");
	if(fp = fopen(Cfile, "rvb"))
		goto a2;
//	concat(buf, "imgmake ", Cfile, " -t hd_st225");
	sprintf(buf, "imgmake %s -t hd -size %u", Cfile, Csize || 10);
	system(buf);
	goto a1;
}

void Phc(unsigned char c)
{
	Pc(c);
	V = (c == '\n') ? 0 : V+1;
}
void Xhelp(unsigned char *p)
{
	unsigned char c;
	fp = stdout;
	V = 0;
	while(c = *p++) {
		if(c & 0x80) {
			switch(c) {
			case 0x80 :
				Ptr = Ofile/*TmpFile+2*/;
				while(c = *Ptr++)
					Phc(c);
				continue;
			case 0x81:
				do {
					Phc(' '); }
				while V < VCOL;
				continue; }
			while(c-- & 0x7F)
				Phc(' ');
			continue; }
		Phc(c); }
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c, d;

	fp = stdout;
	MemTst(7);
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(d = toupper(*Ptr++)) {
			default:
				Debug(("H1"))
he:				Xhelp(Help);
				goto ex;
			case 'H':
				strcpy(HostID, Ptr);
				continue;
			case 'T':
				strcpy(Temp, Ptr);
				Gocf();
				continue;
			case 'E':
				Nic = Onum(255) || -1;
				break;
			case 'R':
				if(!(Rsize = Onum(0)))	{
					Debug(("H2"))
					goto he; }
				break;
			case 'Z':
				Zip = Onum(0);
				break;
			case 'S':
				ZipImg = Ptr;
				continue;
			case 'W':
				Wx = 1024; Wy = 768;
				if(*Ptr) {
					c = Value();
					Wy = ((Wx = V) * 3) / 4;
					switch(c) {
					default	:
						Debug(("H3"))
						goto he;
					case ',':	++Ptr;
						if(Value()) {
							Debug(("H4"))
							goto he; }
						Wy = V;
					case 0	: ; } }
				Debug(("W=%ux%u", Wx, Wy))
				continue;
			case '$':	DBGf = 0;		break;
			case 'K':	c = O_KEEP;		goto o3;
			case 'L':	c = O_PATCH;	goto o2;
			case 'N':	c = O_NEW;		goto o3;
			case 'P':	c = O_PACK;		goto o3;
			case 'X':	c = O_DBX;		goto o3;
/*ChtTxt R:\Help.h
DosBox BootfloppyDisk

use:	DBBD	[name] options...

opts:	-[ABC[size]]		drives to use
			If first drive specified is A or C, dosbox will autoboot to it
			- to prevent this, specify drive twice!
				A will be auto-created with minimal system
			If C not exist, will be auto-created {size}
		-E[n]		create nE2000 realnic=n				[same realnic as host]
		-Htext		set HostID for serial3
		-L			patch DBBD.COM with -T Location;c_drive_file
		-R[k]		size of Ramdisk to create							[4096]
		-Sname		set Source name								[DBBDBOOT.ZIP]
		-Tdirectory	set Target location				[env:DBBD] then [env:TEMP]
		-P			Pack: FDI ~$80B -w [files]~0~$81\neither: build
		-N			"" new image				~$81/DosBox to boot
		-W[x[,y]]	Set Window size								[1024x768]
			DDRAW [Y=X*3/4], otherwise SURFACE 640x480
		-X			toggle dosbox-X detection
		-Z[n]		pack to Zip:	Zn.ZIP								   [0]

Dave Dunfield   -   https://dunfield.themindfactory.com~
*/
			case 'A':	c = O_A;		goto o2;
			case 'B':	c = O_B;		goto o3;
			case 'C':	c = O_C;
				if(Value() != 255)
					Csize = V;
o2:				if(Boot == d) {
					Boot = 0;
					break; }
				if(!(Opt & 7))
					Boot = d;
o3:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		strupr(Ptr);
		Pstring(Ptr); }

	if(Opt & O_PATCH) {
		if(Ptop) {
			Patch(Pool);
			return; }
		if(!Patch(0)) {
			Ps(Temp);
			Nl(); }
		return; }

	strcpy(Home, "::\\");
	*Home = get_drive() + 'A';
	getdir(Home+3);
	Debug(("H'%s'%s\n", Home, HostID))

	if(getenv("DBBD", Temp))
		Gocf();
	if(getenv("TEMP", Temp))
		Gocf();
	if(!(*Ofile && *Cfile)) {
		if(!Patch(0))
			Gocf(); }

	if(!(Opt & (O_A|O_B|O_C))) {
		Debug(("H5"))
		goto he; }

	if(!getenv("PATH", Path))
		Error("Environment variable 'PATH' not found!");

	if(!*Ofile) {
		Ptr = "No output";
		Fclose();
		Ps(Ptr);
		Error(", use: -t... DBBD=... or -L ..."); }
	Xcd(Ofile);
	strcpy(TmpFile, " >::\\");
	TmpFile[2] = get_drive() + 'A';
	getdir(TmpFile+5);
	Ttop = strlen(TmpFile);
	if(TmpFile[Ttop-1] != '\\')
		TmpFile[Ttop++] = '\\';
	printf("Target: %s\n", TmpFile+2);

	if(!DBGf) {
		printf("'%s'%u\n", TmpFile, Ttop);
		TFtemp();
		printf("Tf1'%s'\n", Tfile());
		printf("Tf1'%s'\n", TmpFile);
		TFname();
		printf("Tf1'%s'\n", Tfile()); }
	if(Opt & (O_PACK|O_NEW)) {
		TFname();
		Xrs();
		if(Opt & O_NEW)
			delete(Tfile());
		if(!Exist(Tfile())) {
			concat(Temp, "imgmake ", Tfile(), " -t fd_1440");
			Scmd(Temp);
			Xrs(); }
		TFzip();
		delete(Tfile());
		Ncmd("pkzip -ex %s", Tfile());
		DELL = PKZno;
		Xcd(Home);
		i = 0;
		while(i < Ptop) {
			if(!Ext(Pool+i, "ZIP"))
				Acmd(" %s", Pool+i);
			while(Pool[i++]); }
		Cflush();
		TFname();
//		Ncmd("dskimg -i %s", Tfile());
		Ncmd("fdi %s -w", Tfile());
		DELL = DSKIno;
		i = 0;
		while(i < Ptop) {
			if(Ext(Pool+i, "ZIP"))
				Acmd(" %s", Pool+i);
			while(Pool[i++]); }
		Cflush();
		TFtemp();
		delete(Tfile());
		TFzip(Zip);	strcpy(HostID, TmpFile+2);	//?
		TFname();
//		sprintf(Temp, "dskimg -i %s %s", Tfile(), HostID);	//?
		sprintf(Temp, "fdi %s -w %s", Tfile(), HostID);	//?
		Scmd(Temp);
		goto ex1; }

// Build
	switch(Boot) {
	case 'C':
		if(Ptop) {
			Debug(("H6"))
			goto he; }
		break;
	case 'A':
		if(!Ptop)
			Pstring("PCDOS");
		i = 0; while(Pool[i++]);
		if(i < Ptop) {	// Check only one entry
			Debug(("H7"))
			goto he; } }

	strcpy(Dir, Tfile());
	Mode = M_FILE|M_DELETE;
	DELL = DEList1;
	DoDir();
	DELL = DEList2;
	DoDir();
	Mode = 0;

#ifdef DBX
	#message DosBox-X
	Fopen(CPYTMP, "Y:\\DBX.EXE", "rbv");
#else
	Fopen(CPYTMP, "Y:\\DOSBOX.EXE", "rbv");
#endif
	if(Copy() > 1024)
		Opt ^= O_DBX;
	if(Opt & O_DBX) {
		i = 0;
		while(Ptr = DBfiles[i++]) {
			strcpy(CPYTMP+*CPYTMP, Ptr);
			fp = fopen(CPYTMP+1, "rbvq");
			Copy(); } }

	CheckA();

	if(Nic == -1)
		GetNic();

	fp = fopen("DOSBOX.INI", "wvq");
	if(Wx && Wy) {
		Ps("[sdl]\noutput=ddraw\n");
		Pr("windowresolution=%ux%u\n", Wx, Wy); }
	Ps("[cpu]\ncycles=fixed 50000\n");
	Ps("[serial]\n");
	Ps("serial1=directserial realport:COM1\n");
	Ps("serial2=directserial realport:COM2\n");
	if(*HostID) {
		Ps("serial3=nullmodem server:");
		Ps(HostID);
		Ps(" transparent:1 txdelay:1\n"); }
	if(Nic) {
		Rseed = peekw(0x40, 0x6C);
		Ps("[ne2000]\nne2000=true\nnicbase=300\nnicirq=9\n");
		Pr("macaddr=AC:DE:48:%02x:%02x:%02x\n", Rbyte(), Rbyte(), Rbyte());
		Pr("realnic=%u\n", Nic); }
	Ps("[autoexec]\n");
#if 0
	if(Opt & O_A) {
		strcpy(TmpFile+Ttop, "A");
		Ps("imgmount A ");
		Ps(Tfile());
		Nl(); }
	if(Opt & O_B) {
		strcpy(TmpFile+Ttop, "B");
		Ps("imgmount B ");
		Ps(Tfile());
		Nl(); }
#endif
	if(Opt & O_C) {
		CheckC();
		fclose(fopen(Cfile, "rbvq"));
		Debug(("Cf'%s'\n", Cfile))
		Ps("imgmount C ");
		Ps(Cfile);
		Nl(); }
	if(Boot) {
		Ps("boot");
		if(Opt & O_A)	Ps(" A");
		if(Opt & O_B)	Ps(" B");
		if(Boot == 'C')	Ps(" -l C");
		Nl(); }
	Fclose();

#if 0	// Old non-.C .A
	fp = fopen("AUTOEXEC.BAT", "wvq");
	Ps("@echo OFF\n");
	Pr("xmsdsk /Y /C1 C %u\n", Rsize);
	if(Nic)
		Ps("ne2000 0x60 9 0x300\n");
	Ps("path A:\\\nC:\n");
	Fclose();
#else
	switch(Boot) {
	case 'A':
	case 'B':
		WCfile(".A", "AUTOEXEC.BAT");
		WCfile(".C", "CONFIG.SYS"); }
#endif

	Xcd(0);
	Debug(("'%s' Dt=%u Pt=%u\n", Temp1, Dtop, Ptop))
	Mode = M_FILE|M_DELETE;
	DELL = DEList2;
	*Dir = Dtop = 0;
	DoDir();

ex:	GoHome();
ex1:MemTst(0);
}
///BuildD cc dbbd -pof
///BuildD compak dbbd
///BuildD dbbd -l r:\;C:\BOOT\C
