// BAX
#include <stdio.h>
#define	MemTst(a)
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	POOL	8192
#define	CMDS	50
#define	SYMBOLS	25
#define	LSTACK	5

unsigned
	Line,
	Elvl,				// ErrorLevel
	Twait,
	Lsp,
	Ctop,
	Stop,
	Ptop,
	Lstack[LSTACK];
FILE
	*fp,
	*fp1,
	*fpo;
unsigned char
	*Ptr,
	*Cmds[CMDS],
	Copt,
	Xopt,
	IFnot,
	Estop,
	Buffer[128],
	Temp[128],
	Temp1[128],
	*Cargs[10][128],
	Symbols[SYMBOLS][128],
	Pool[POOL];
#define	Temp2	Temp

#define	CO_PAUSE1	0x01
#define	CO_PAUSE2	0x02
#define	CO_PAUSE	0x03
#define	CO_ECHO1	0x04
#define	CO_ECHO2	0x08
#define	CO_ECHO3	0x10
#define	CO_ECHO		0x1C
#define	CO_TEST		0x80

unsigned char *CMwords[] = {
#define	_REM	1
	"REM",
#define	_SET	2
	"SET",
#define	_CD		3
	"CD",
#define	_MKDIR	4
	"MKDIR",
#define	_SYSTEM	5
	"SYSTEM",
#define	_GOTO	6
	"GOTO",
#define	_CALL	7
	"CALL",
#define	_RETURN	8
	"RETURN",
#define	_ECHO	9
	"ECHO",
#define	_IF		10
	"IF",
#define	_PAUSE	11
	"PAUSE",
#define	_EXIT	12
	"EXIT",
#define	_PEXIT	13
	"PEXIT",
#define	_TYPE	14
	"TYPE",
#define	_DEL	15
	"DEL",
#define	_RMDIR	16
	"RMDIR",
#define	_SEL	17	//?
	"SEL" };		//?
#define	CMtop	(sizeof(CMwords)/2)

unsigned char *ONwords[] = {
	"OFF",
	"ON" };
#define	ONtop	(sizeof(ONwords)/2)

unsigned char *IFwords[] = {
#define	_NOT	1
	"NOT",
#define	_EXIST	2
	"EXIST",
#define	_ELVL	3
	"ERRORLEVEL" };
#define	IFtop	(sizeof(IFwords)/2)

#include "R:\Help.H"

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u S%u C%u P%u\n", p, i, Stop, Ctop, Ptop);
	}
#endif


void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	if(Line) printf("%u: ", Line);
	Ps(buf);
	exit(-1);
}

// Optional message
void Omsg(unsigned char *p)
{
	IFnot = 0;
	if(skip())
		p = Ptr;
	if(p) {
		Ps(p);
		IFnot = 255; }
}
void Onl(void)
{
	if(IFnot) Nl();
}

void Cecho(void)
{
	if((Copt & Xopt) & CO_ECHO) {
		Pc('>');
		Ps(Buffer);
		Nl(); }
}

// Skip to non-blank
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}
void trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i]) ++i;
	while(i && isspace(Ptr[i-1])) --i;
	Ptr[i] = 0;
}

//Parse string from input stream
unsigned Uparse(unsigned char *p)
{
	unsigned i;

	skip(); i = 0;
a1:	switch(p[i] = toupper(*Ptr)) {
	default: ++Ptr; ++i;	goto a1;
	case ' ' :
	case '\t':
	case 0 : p[i] = 0; }
	return i;
}


// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

unsigned lookup(unsigned *p, unsigned **wr, unsigned t)
{
	unsigned i;
	i = 0; skip();
	while(i < t) {
		if(!strcmp(wr[i++], p))
			return i; }
	return 0;
}

unsigned char issym(unsigned char c)
{
	if((c >= 'a') && (c <= 'z'))	goto a1;
	if((c >= 'A') && (c <= 'Z'))	goto a1;
	if((c >= '0') && (c <= '9'))	return 15;
	if(c != '_')					return 0;
a1:	return 255;
}

unsigned Psym(unsigned char *d)
{
	unsigned i;
	skip();
	i = 0;
	if(issym(*Ptr) & 0xF0) {
		do {
			d[i++] = toupper(*Ptr++);
		} while(issym(*Ptr));
		d[i] = 0; }
	return i;
}
unsigned Esym(unsigned char *d)
{
	unsigned i
	if(!(i = Psym(d)))
		error("?symbol expected");
	return i;
}

int readline(void)
{
	if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fp))
		return 0;
	++Line;
	return 255;
}

// Prepare command for EXEC
void precmd(void)
{
	unsigned i, j, k;
	unsigned char c, *p, *p1;
	for(i=j=0; i < Ctop; ++i) {
		p1 = Cmds[i];
		if(p1[1] == ':') {
			j = i;
			continue; }
		k = 0;
a1:		switch(c = Temp1[k]) {
		case'\\':
		case ':':
		case '.':
			strcpy(Temp2, Temp1);
			return;
		default	:
			if(p1[k] == c) {
				 ++k;
				goto a1; }
			continue;
		case 0	:
			if(p1[k] == '.') {
				strcpy(p = Temp2, Cmds[j]);		// Get directrory
				while(*p) ++p;					// Add
				*p++ = '\\';
				strcpy(p, p1);
				return; } } }
	error("?cmd'%s'", Temp1);
}

void repline(void)
{
	unsigned i;
	unsigned char c, *p, *p1, *p2, t[64], t1[64], t2[64];
	p2 = p = Ptr;
	strcpy(Ptr = t, p2);
a1:	switch(c = *Ptr++) {
	case '%' :
		if(isdigit(*Ptr)) {
			p1 = Cargs[(unsigned)*Ptr++ - '0'];
			c = 0;
a2:			while(*p1)
				*p++ = *p1++;
			if(c) *p++ = c;
			goto a1; }
		if(Psym(p1 = t1)) {
			if(*Ptr != '%') {
a3:				*p++ = '%';
				goto a2; }
			++Ptr;
			c = 0;
			if(!strcmp(t1, "ERRORLEVEL")) {
				sprintf(p1 = t1, "%u", Elvl);
				goto a2; }
			if(!strcmp(t1, "DIRECTORY")) {
				*(p1 = t1) = get_drive()+'A';
				t1[1] = ':'; t1[2] = '\\';
				getdir(t1+3);
				goto a2; }
			for(i=0; i < Stop; ++i) {
//printf("?'%s'%s'\n", Symbols[i], t1);
				if(!strcmp(p1 = Symbols[i], t1)) {
					while(*p1++);
//printf("='%s'%s'\n", p1, Ptr);
					goto a2; } }
			if(getenv(p1 = t1, t2)) {
				p1 = t2;
				goto a2; }
			c = '%';
			goto a3; }
	default:
		*p++ = c;
		goto a1;
	case 0 : *p = 0; }
	Ptr = p2;
}
unsigned char rst(void)
{
	unsigned char c;
	repline();
	c = skip();
	trim();
	Cecho();
	return c;
}
void pause(void)
{
	if((Copt & Xopt) & CO_PAUSE) {
		Pc('!');
a1:		switch(kbget()) {
		default	: goto a1;
		case 0x1B:	exit(-1);
		case ' ':
		case'\r':
		case'\n': Ps("\b \b"); } }
}

void tstexit(void)
{
	unsigned i, j, k;
	if(i = k = Twait) {
a1:		while((j = peek(0x40, 0x6C)) == i);
		i = j; }
	switch(kbtst()) {
	case 0x1B: ex: exit(-1);
	case ' ' :
		Pc('[');
a2:		switch(kbget()) {
		default	 : goto a2;
		case 0x1B: goto ex;
		case ' ' :
		case'\r' : Pc(']'); } }
	if(k) {
		--k;
		goto a1; }
}

register CmdErr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	if(Estop) {
		Ps(buf);
		Ps(" A)bort I)gnore?");
a1:		switch(kbget()) {
		default:	goto a1;
		case 'a':
		case 'A':
		case 0x1B: exit(-1);
		case 'i':
		case 'I': Nl(); } }
}

unsigned value(unsigned char *p)
{
	unsigned v, c, b;
	unsigned char *p1;
	b = 10;
	switch(*p) {
	case '$' :	b = 16;	goto a1;
	case '@' :	b = 8;	goto a1;
	case '%' :	b = 2;	a1:
		++p; }
	p1 = p;
	v = 0;
	while(c = *p) {
		if((c >= '0') && (c <= '9')) {	c -= '0';		goto a2; }
		if((c >= 'a') && (c <= 'f')) {	c -= ('a'-10);	goto a2; }
		if((c < 'A') || (c > 'F'))		goto bv;
		c -= ('A'-10);
a2:		if(c >= b) goto bv;
		v = (v * b) + c;
		++p; }
	if(p == p1) {
bv:		error("?value"); }
	return v;
}
void CmdOpt1(void)
{
	Xopt = CO_PAUSE1|CO_ECHO1|CO_ECHO3;
	Estop = 255;
	if(skip() == '!') {
a1:		switch(toupper(*++Ptr)) {
		case'P':	Xopt &= ~CO_PAUSE;	goto a1;
		case'E':	Xopt &= ~CO_ECHO;	goto a1;
		case'F':	Estop = 0;			goto a1; }
		++Ptr;	}
}
void CmdOpt2(void)
{
	if(skip() == '!') {
a1:		switch(toupper(*Ptr++)) {
		case'P':
		case'E':
		case'F':	goto a1; }
		++Ptr;	}
}

#if 0
FILE *Fopen(unsigned char *x1, unsigned char *x2)
{
	printf("Fo'%s'%s'\n", x1, x2);
a1:	switch(*x2++) {
	case 'q':
	case 'Q': exit(-1);
	case 0	: return 0; }
	goto a1;
}
#define	fopen	Fopen
#endif

// Test to see if a file pattern exists
unsigned char exist(unsigned char *name)
{
	unsigned i, j;
	unsigned char tmp[64];
	if(!find_first(name, 0, tmp, &i, &i, &j, &i, &i))
		return 255;
	return 0;
}

// Swap tabs to spaces in outgoing command
void swaptab(unsigned char *p)
{
a1:	switch(*p) {
	case'\t': *p=' ';
	default : ++p;	goto a1;
	case 0	: ; }
}

main(int argc, char *argv[])
{
	unsigned i, j, k;
	unsigned char c, *p;

	MemTst(7);
	k = 0;
	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		j = toupper(*Ptr) << 8;
/*ChtTxt R:\Help
BAtch eXtended - make batch files useful in DOSBOX.

use: BAX file[.BAX] arguments.. [options]

opts:	-?[?]	- additional help				-?? to skip "Press..."
		-EI		- auto Echo Internal commands
		-EE		- auto Echo External commands
		-PI		- auto Pause after Internal Commands
		-PE		- auto Pause after External commands
		-T		- Test mode (run thgough motions)
		W=t		- Wait between commands (55ms ticks)
			during this time, you can press SPACE to pause,
			or ESC to abort the .BAX file.

BAX is NOT embedded in the command interpreter, which means it has some
limitations (as well as extensions):

Some DOSBOX commands are not implemented, if you need them, use: SYSTEM cmd
 note that this prevents %ERRORLEVEL% from being set correctly!
BAX does not search PATH, recognized external programs are defined in: BAX.INI
Redirection is NOT implemented, again use SYSTEM if you need it.

Dave Dunfield - ~Y/~t~M/~D - https://dunfield.themindfactory.com
*/
		switch(toupper(Ptr[1]) | j) {
		case '-P':
		case '/P':	c = CO_PAUSE;	goto so1;
		case '-E':
		case '/E':	c = (CO_ECHO1|CO_ECHO2);
so1:		switch(toupper(Ptr[2])) {
			default	: goto a1;
			case 'E': c &= ~(CO_ECHO1|CO_PAUSE1);	break;
			case 'I': c &= ~(CO_ECHO2|CO_PAUSE2);
			case 0	: ; }
so2:		Copt |= c;
			continue;
		case '-T':
		case '/T':	c = CO_TEST;	goto so2;
		case 'W=':	Twait = value(Ptr+2);	continue;
		case '-?':
		case '/?':
			j = Ptr[2] == '?';
			p = Help1;
			goto he;	}
a1:		if(k >= 10) error("?#args");
		strcpy(Cargs[k++], Ptr); }			
	if(!k) {
		p = Help;
he:		while(c = *p++) {
			if(c & 0x80) {
				if(c & 0x7F) {
					while(c-- & 0x7F)
						Pc(' ');
					continue; }
				if(j) {
					Nl();
					continue; }
				Ps("Press any key to proceed.");
				if(kbget() == 0x1B)
					goto ex;
				Pc('\r');
				continue; }
			Pc(c); }
		goto ex; }

	Copt ^= CO_TEST;

	if(fp = fopen("BAX.INI", "r")) goto j2;
	if(getenv("DDCDATA", Buffer)) {
		i = 0; while(Buffer[i]) ++i;
		if(i) switch(Buffer[i-1]) {
			default	: Buffer[i++] = '\\';
			case ':':
			case'\\': ; }
		strcpy(Buffer+i, "BAX.INI");
		if(fp = fopen(Buffer, "r"))	goto j2; }
	strcpy(Buffer, argv[0]);
	i = j = 0;
j1:	switch(Buffer[i++]) {
	case ':':
	case'\\':	j = i;
	default :	goto j1;
	case 0	:	strcpy(Buffer+j, "BAX.INI"); }
	fp = fopen(Buffer, "rvq");
j2:	while(readline()) {
		switch(skip()) {
		case ';':
		case 0	: continue; }
		if(Ctop >= CMDS)
			error("?#cmd");
		trim();
		strupr(Ptr);
		Cmds[Ctop++] = Pstring(Ptr); }
	fclose(fp); Line = 0;
//for(i=0; i < Ctop; ++i) printf("%u'%s'\n", i, Cmds[i]); return;

	Ptr = Cargs[i = 0];
i1:	j = 0;
i2:	switch(Ptr[i++]) {
	case ':':
	case'\\':	goto i1;
	case '.':	j = i;
	default	:	goto i2;
	case 0	:	; }
	if(!j)
		strcpy(Ptr+i-1, ".BAX");

	fp = fopen(Ptr, "rvq");
	while(readline()) {
		tstexit();
a0:		switch(skip()) {
		case 0	: continue;
		case ':':	++Ptr;
			Esym(Temp1);
			strcpy(Buffer, Ptr);
			Ptr = Buffer;
			goto a0; }
/*a1:*/	if(issym(c=*Ptr) & 0xF0) {
			if(Ptr[1] == ':') switch(Ptr[2]) {
				case ' ':
				case'\t':
				case 0	:
					c = toupper(c) - 'A';
					if(c > 26) error("?drive");
					set_drive(c);
					if(get_drive() != c)
						CmdErr("?Drive %c: = %c", c+'A', get_drive()+'A');
					continue; } }
		Ptr = Buffer;
		CmdOpt1();
		if(Psym(Temp1)) {
//			strupr(Temp1);
			if(!(i = lookup(Temp1, CMwords, CMtop)))
				goto a999;
			switch(i) {
			default	 :	error("?kw'%s'", Temp1);
			case _REM:	continue;
			case _SET:
				if(issym(c = skip()) == 15) {
					p = Ptr++;
					switch(skip()) {
					case'=': ++Ptr;
					case ' ':
					case'\t':
						p = Cargs[(unsigned)c-'0'];
						Debug(("SET %c", c))
						goto a3; }
					Ptr = p; }
				Esym(Temp1);
				if(skip() == '=')
					++Ptr;
				for(i=0; i < Stop; ++i) {
					if(!strcmp(Symbols[i], Temp1))
						goto a2; }
				if(Stop >= SYMBOLS)
					error("?#sym");
				++Stop;
a2:				strcpy(p = Symbols[i], Temp1);
				while(*p++);
				Debug(("SET '%s'", Temp1))
a3:				rst();
				Debug(("='%s'%u\n", Ptr, i))
				strcpy(p, Ptr);
xi:				pause();
				continue;
			case _CD:
				c = rst();
				Debug(("CD'"))
				if(issym(c) & 0xF0) {
					if(Ptr[1] == ':') {
						c = toupper(c)-'A';
						if(c > 26) error("?drive");
						if(Copt & CO_TEST) {
							set_drive(c);
							if(get_drive() != c)
								CmdErr("?Dr'%c'%c'", c+'A', get_drive()+'A'); }
						Debug(("[%c:]", c+'A'))
						Ptr += 2; } }
				if(*Ptr) {
					trim();
					Debug(("%s'\n", Ptr))
					if(chdir(Ptr))
						CmdErr("?cd'%s'", Ptr); }
				goto xi;
			case _MKDIR:
				rst();
				if(Copt & CO_TEST) {
					if(i=mkdir(Ptr))
						CmdErr("mkdir(%s)=%u", Ptr, i); }
				Debug(("MKDIR'%s'\n", Ptr))
				goto xi;
			case _SYSTEM:
				rst();
				if(Copt & CO_TEST) {
					if(i=system(Ptr))
						CmdErr("?systen(%s)=%u", Ptr, i); }
				goto xi;
			case _GOTO:
gt1:				repline();
				Cecho();
				Uparse(Temp1);
				i = Line;
				rewind(fp); Line = 0;
				while(readline()) {
					if(skip() == ':') {
						++Ptr;
						repline();
						Uparse(Temp);
						if(!strcmp(Temp, Temp1)) {
							Ptr = Buffer;
							goto a0; } } }
				Line = i;
				error("?nf'%s'", Temp1);
			case _CALL:
				if(Lsp >= LSTACK)
					error("?#call");
				Lstack[Lsp++] = Line;
				goto gt1;
			case _RETURN:
				if(!Lsp)	goto ex;
				i = Lstack[--Lsp];
				rewind(fp);	Line = 0;
				while(readline()) {
					if(Line == i)
						goto xi; }
				error("?ret%i", i);
			case _ECHO:
				p = Ptr;
				if(Uparse(Temp1)) switch(lookup(Temp1, ONwords, ONtop)) {
					case 1 : Copt &= ~CO_ECHO3;	continue;
					case 2 : Copt |= CO_ECHO3;	continue; }
				Ptr = p; rst();
				Ps(Ptr);
				Nl();
				goto xi;
			case _IF:
				repline();
				Cecho();
				IFnot = 255;
//b1:				p = Ptr;
b1:				if(Uparse(Temp1)) switch(lookup(Temp1, IFwords, IFtop)) {
					case _NOT:	IFnot = 0;	goto b1;
					case _EXIST:
						if(Uparse(Temp1)) {
							if(exist(Temp1))	goto ift;
//?							if(fp1 = fopen(Temp1, "rb"))
//?								fclose(fp1);
//?							if(fp1)		goto ift;
iff:						if(!IFnot)	goto ift1;
iff1:						Ptr = "";
							goto a0; }
						goto xi;
					case _ELVL:
						Uparse(Temp1);
						if(value(Temp1) > Elvl)	goto iff;
ift:					if(!IFnot)				goto iff1;
ift1:					strcpy(Buffer, Ptr);
						Ptr = Buffer;
						goto a0; }
				Uparse(Temp);
				j = (*Temp << 8) | Temp[1];
				Uparse(Temp);
				switch(j) {
				case '==': if(!strcmp(Temp1, Temp)) goto ift;	goto iff;
				case '!=': if(strcmp(Temp1, Temp))	goto ift;	goto iff; }
				i = value(Temp1); k=value(Temp);
				switch(j) {
				case 'EQ' : if(i == k)	goto ift;	goto iff;
				case 'NE' : if(i != k)	goto ift;	goto iff;
				case'<'<<8:	if(i < k)	goto ift;	goto iff;
				case '<=' :	if(i <= k)	goto ift;	goto iff;
				case'>'<<8:	if(i > k)	goto ift;	goto iff;
				case '>=' :	if(i >= k)	goto ift;	goto iff; }
				error("?if");
			case _PAUSE:
				rst();
				Omsg("Press SPACE/ENTER to continue.");
p1:				switch(c = kbget()) {
				case 0x1B:	goto ex;
				default:
					if((c < '1') || (c > '9')) goto p1;
					Elvl = c - '0';
					break;
				case '0':	Elvl = 10;	break;
				case'\n':
				case'\r':
				case ' ':	Elvl = 0;	}
				Onl();
				continue;
			case _PEXIT:
				rst();
				Omsg(0);
p2:				switch(kbget()) {
				default:	goto p2;
				case 0x1B:
				case'\n':
				case'\r':
				case ' ':	goto e1; }
			case _EXIT:
				rst();
				Omsg(0);
e1:				Onl();
				goto ex;
			case _TYPE:
				rst();
				k = 4;
				fpo = stdout;
t1:				if(Uparse(Temp2)) {
					switch(*Temp2) {
					case '#':	k = value(Temp2+1);	goto t1;
					case '>':
						if(fpo != stdout)	fclose(fpo);
						fpo = fopen(Temp2+1, "wvq");
						goto t1; }
					fp1 = fopen(Temp2, "rvq");
					j = 0;
					while((c = getc(fp1)) != EOF) {
						if(c == '\t') {
							do
								putc(' ', fpo);
							while(++j % k); }
						else {						/* not a tab */
							j = (c != '\n') && j+1;	/* see opening comment */
							putc(c, fpo); } }
					fclose(fp1);
					goto t1; }
				if(fpo != stdout)	fclose(fpo);
				continue;
			case _DEL:
				rst();
				if(Copt & CO_TEST) {
					if(i=delete(Ptr))
						CmdErr("del(%s)=%u", Ptr, i); }
				Debug(("DEL'%s'\n", Ptr))
				goto xi;
			case _RMDIR:
				rst();
				if(Copt & CO_TEST) {
					if(i = rmdir(Ptr))
						CmdErr("rmdir(%s)=%u", Ptr, i); }
				Debug(("RMD'%s'\n", Ptr))
				goto xi;
			case _SEL:
				repline();
				Cecho();
				Elvl = value(Ptr);
				goto xi;
			}
		}
a999:	Ptr = Buffer;
		CmdOpt2();
		if(!Uparse(Temp1))
			error("???");
		Xopt = CO_PAUSE2|CO_ECHO2|CO_ECHO3;
		rst();
		precmd();
		*--Ptr = ' ';
		Debug(("Cmd'%s'%s'\n", Temp2, Ptr))
		if(Copt & CO_TEST) {
			swaptab(Ptr);
			if(i=exec(Temp2, Ptr))
				CmdErr("exec(%s,%s)=%u", Temp2, Ptr, i); }
		pause(); }

ex:	fclose(fp);
	MemTst(0);
}
/*ChtTxt Help1
BAX.INI - Looked for in current dir, then in one specified by %DDCDATA%

; Blank lines and those beginning with ';' are ignored.
;
; Lines beginning with 'd:' are assumed to be the full path to a set of
; commands. Otherwise is assumed to be the command program filename.
Y:\CMDS
	XDEL.COM
	MAR.COM
	TYPESET.COM
	XDIR.COM
C:\MC
	MCP.EXE

You can use the following special substitutions in any .BAX file line:

		 %0			- Argument 0 (.BAX file nane)
	   %1-%9		- Arguments 1-9
	%ERRORLEVEL%	- Error code returned by last operation
	%DIRECTORY%		- Current DRIVE:DIRECTORTY path
	 %envvar%		- Any local or environment variable
~$80
Internal commands recoginzed by BAX:

REM	text ...			- CommentLine ignored
SET symbol=text		 	- Set a symbol
	Symbols can be accessed with %symbol%, can also access environment
	variables.  SET does NOT set environment variables, only a local symbol.
	You can SET %0-%9 like any other local: SET 1=text
CD [drive:][directory]	- Change drive and/or directory
	Unlike DOS, will actually change current drive
MKDIR path				- Make a directory
RMDIR path				- Remove a directory
DEL file				- Delete a file
SYSTEM command			- Execute command via system command interpreter
TYPE [#n >file] file..	- Display a file
	Does tab-to-space conversion using tabstops at intervals specified by
    '#n'. (default is: #4 which I tend to use a lot!).
	Can send output to file using '>' (fake redirection).
	'#' and '>' are processed as arguments/files are read, meaning they
	should occur BEFORE any files where you want them to have effect!
GOTO label				- Transfer to label
~$80
CALL label				 - Stack location & Transfer to label
	Unlike DOS, does not start another BAX file.
	Allows you to have subroutines within one file.
	Up to 5 call levels can be stacked.
    Use "SYSTEM BAX ..." to invoke another .BAX file.
RETURN					- Return to prev location
	Returns to line following last CALL.
	If no outstanding CALLs, EXITs
ECHO text				- Display text
 ""	 ON|OFF				- Enable/Disable command echo
IF condition command	- Perform command on condition
	NOT contition		- Invert true/false of condition
	ERRORLEVEL n		- true if %ErrorLevel% >= n
	EXIST file			- true if file exists
	string1 == string2	- true if text1 matches text2
	string1 != string2	- true if text1 does not match
	value1 EQ value2		Remaining comparisons are value
	value1 NE value2		comparison, operands MUST be:
	value1 >  value2			0-9..	= Decimal number
	value1 <  value2			%0-1..	= Binary number
	value1 >= value2			@0-7..	= Octal number
	value1 <= value2			$0-F..	= Hexidecimal number
~$80
PAUSE [text]			 - Display text, if none given uses:
								"Press SPACE/ENTER to continue."
		Waits for 			'1'-'9'		%ERRORLEVEL% = 1-9
		  one of			  '0'		%ERRORLEVEL% = 10
	   these keys:		  ' ' or '\n'	%ERRORLEVEL% = 0
							  ESC		Terminate BAX
EXIT [text]				- Display text and exit
PEXIT [text]			- "", Wait for SPACE/ENTER

.BAX file will auto pause when commands indicate failure by returning
a non-zero %ERRORLEVEL%.

You can override auto actions on any line by prefixing with: !efp
	where 'efp' is a combination of:
		E - disable auto Echo
		F - disable auto Failure detection on %ERRORLEVEL%
		P - disable auto Pause
*/
