// COMP
#include <stdio.h>
#include <file.h>

#define	MemTst(a)
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	POOL		32768
#define	TSIZ		4096

#define	O_SUB		0x01
#define	O_QUIET		0x02
#define	O_MATCH		0x04
#define	O_FIL2		0x08
#define	O_EXTRA		0x10
#define	O_MTO1		0x20
#define	O_VERB		0x40
#define	O_DRY		0x80

unsigned
	Sh, Sl, At, Ti, Da,
	Fcount,
	Dcount,
	Dfail,
	Ffail,
	Dtop,
	Ptop;
FILE
	*fp1,
	*fp2;
unsigned char
	*Ptr,
	*Base1,
	*Base2,
	*Pattern,
	*CmpFile,
	Opt,
	Dir1[256],
	Dir2[256],
	Temp1[TSIZ],
	Temp2[TSIZ],
	Pool[1024],
	Ptmp[POOL-1024];

#include "R:\\Help.h"

#define	OCB		{
#define	CCB		}

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
	exit(-1);
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	Debug(printf("Match '%s'", name));
//	Debug(printf(" '%s'\n", pattern));

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
		if(toupper(*name++) != c)
//		if(*name++ != c)
			return 0; }
}

#define	C_SIZE	0x08
#define	C_DIFF	0x04
#define	C_FAIL	0x0C
unsigned comp(void)
{
	unsigned i, j;
	unsigned char c, e1, e2;
	if(Opt & O_DRY) {
		Pc('\'');
		Ps(Dir1);
		Ps("'?'");
		Ps(Dir2);
		Ps("'\n");
		return 0; }
	if(!(fp1 = fopen(Dir1, "rb"))) {
		Ps("Not: ");
		Ps(Dir1);
		Nl(); }
	if(!(fp2 = fopen(Dir2, "rb"))) {
		Ps("Not: ");
		Ps(Dir2);
		Nl(); }
	c = 0;
	if(fp1 && fp2) {
		e1 = e2 = 255;
		do {
			if(e1)
				i = fget(Temp1, TSIZ, fp1);
			if(e2)
				j = fget(Temp2, TSIZ, fp2);
			if(i != j) {
				c |= C_SIZE;
				goto a1; }
			if(e1 & e2) {
				if(memcmp(Temp1, Temp2, i)) {
					c |= C_DIFF; } }
a1:			if(i < TSIZ) e1 = 0;
			if(j < TSIZ) e2 = 0; }
		while(e1 | e2); }
	else
		++Ffail;
	if(fp2) fclose(fp2);
	if(fp1) fclose(fp1);
	return c;
}
		
void dodir(void)
{
	unsigned i, dt, pt;
	dt = Dtop; pt = Ptop;
	if(Opt & O_VERB) {
		fputs("Dir: ", stderr);
		fputs(Dir1, stderr);
		putc('\n', stderr); }
	while(Base1[Dtop]) ++Dtop;
	strcpy(Base1+Dtop, "\\*.*");
	strcpy(Base2+Dtop, "\\*.*");
	++Dtop;
	++Dcount;
//printf("D1'%s'\n", Dir1);
//printf("D2'%s'\n", Dir2);
	i = 0;
	if(find_first(Dir2, 0x3F, Temp2, &Sh, &Sl, &At, &Ti, &Da))
		i = 0x02;
	else
		find_close();
	if(find_first(Dir1, 0x3F, Temp1, &Sh, &Sl, &At, &Ti, &Da))
		i |= 0x01;
	if(i) {
		++Dfail;
		if(i & 0x01) {
			Ps("Not: ");
			Ps(Dir1);
			Nl(); }
		if(i & 0x02) {
			Ps("Not: ");
			Ps(Dir2);
			Nl(); }
		goto ex; }
	do {
#ifdef _DVM_
		if(At & DIRECTORY) {
			{
#else
		if(At & (DIRECTORY|HIDDEN|SYSTEM|VOLUME)) OCB
			if(!(At & (HIDDEN|SYSTEM|VOLUME))) OCB
#endif
				if(*Temp1 != '.')
					Pstring(Temp1); }
			continue; }
//printf("[%s]\n", Temp1);
		if(Fmatch(Temp1, Pattern)) {
			strcpy(Base1+Dtop, Temp1);
			strcpy(Base2+Dtop, CmpFile || Temp1);
			++Fcount;
			if((i = comp()) & C_FAIL) {
				++Ffail;
				if(!(Opt & O_MATCH)) {
					Ps((i & C_SIZE) ? "Siz: " : "Dif: ");
					goto a1; }
				continue; }
			if(Opt & O_MATCH) {
a1:				if(Opt & O_FIL2) {
					Ps(Dir1);
					Ps(" ? ");
					Ps(Dir2); }
				else
					Ps(Base1+1);
				Nl(); } } }
	while !find_next(Temp1, &Sh, &Sl, &At, &Ti, &Da);

	if(Opt & O_EXTRA) {
		strcpy(Base2+Dtop, "*.*");
		if(!find_first(Dir2, 0x3F, Temp1, &Sh, &Sl, &At, &Ti, &Da)) {
			do {
#ifdef _DVM_
				if(At & DIRECTORY) {
					{
#else
				if(At & (DIRECTORY|HIDDEN|SYSTEM|VOLUME)) OCB
					if(!(At & (HIDDEN|SYSTEM|VOLUME))) OCB
#endif
					if(*Temp1 == '.') continue;
					i = pt;
					while(i < Ptop) {
						if(!strcmp(Pool+i, Temp1))
							goto a2;
						while(Pool[i++]); }
					strcpy(Base2+Dtop, Temp1);
					Ps("Ext: ");
					Ps(Dir2);
					Nl();
a2:					; } } }
			while !find_next(Temp1, &Sh, &Sl, &At, &Ti, &Da); } }

	if(Opt & O_SUB) {
		i = pt;
		while(i < Ptop) {
			strcpy(Base1+Dtop, Pool+i);
			strcpy(Base2+Dtop, Pool+i);
			dodir();
			while(Pool[i++]); } }
ex:	Dtop = dt; Ptop = pt;
}

unsigned iswild(unsigned char *p)
{
a1:	switch(*p++) {
	case '?':
	case '*':	return 255;
	default	:	goto a1;
	case 0	:	; }
	return 0;
}
void Gcd(unsigned char *p)
{
	strcpy(p, "_:\\");
	*p = get_drive()+'A';
	getdir(p+3);
}
void GetFile(unsigned char *dst)
{
	unsigned i, j;
	unsigned char *p, d;
	strupr(Ptr);
	if((d = toupper(*(p = Ptr))) && (Ptr[1] == ':')) {
		set_drive(d -= 'A');
		if(get_drive() != d) {
			p = "?Bdrive:  ";
			goto e1; }
		p += 2; }

	i = j = 0;
a1:	switch(p[i++]) {
	case ':':
	case'\\':	j = i;
	default	:	goto a1;
	case 0	:	; }
	if(!cd(p)) {
		strcpy(Temp2, "*");
		goto a2; }
	strcpy(Temp2, p+j);
	switch(j) {
		default	:
			p[j-1] = 0;
			if(cd(p)) {
				p = "?Bdir: ";
				goto e1; }
			break;
		case 1	:
			if(cd("\\")) {
				p = "?Broot";
				goto e1; }
		case 0	:	; }
a2:	Gcd(dst);
	i = 0; while(dst[i]) ++i;
	if(i == 3) dst[i-1] = 0;
	p = 0;
e1:	set_drive(*Ptmp-'A');
	cd(Ptmp);
	if(p) {
		Ps(p);
		Ps(Ptr);
		error("\n"); }
}

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

void ShowCpy(void)
{
	Ps("Compare: ");
	Ps(Dir1); Pc('\\'); Ps(Pattern);
	Ps("\n   with: ");
	Ps(Dir2); Pc('\\'); Ps(Temp2);
	Nl();
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	MemTst(7);
	Gcd(Ptmp);

	for(i=1; i < argc; ++i) {
		switch(*(Ptr = argv[i])) {
		case '-':
		case '/':	++Ptr;
/*ChtTxt R:\Help.H
COMPare file(s)

use:	COMP filespec1 filespec2 [options]

opts:	-D		Dry run (show what will be tested without taking time to test)
		-E		show Extra subdirectories along filespec2
		-M		show Matching files				(otherwise different)
		-S		recurse into Subdirectories
		-Q		Quiet (less output)
		-V		Verbose (show directories as they are scanned)
			- progress messages are not redirected with: >file
		-1		allow many-to-1 compare
		-2		show 2nd filename in results

filespec1 can be a directory or file (which may contain wildcards: *?)
  wildcards:  . not special:  * =all file,  *.* =must have at least one .
filespec2 can be a directory (or file if !-S)

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
a1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
			case 'D':	c = O_DRY;		goto a2;
			case 'E':	c = O_EXTRA;	goto a2;
			case 'S':	c = O_SUB;		goto a2;
			case 'M':	c = O_MATCH;	goto a2;
			case 'Q':	c = O_QUIET;	goto a2;
			case 'V':	c = O_VERB;		goto a2;
			case '1':	c = O_MTO1;		goto a2;
			case '2':	c = O_FIL2;
a2:				Opt  |= c; }
			if(*Ptr) goto a1;
			continue; }
		if(!*Dir1) {
			GetFile(Dir1);
			Pattern = Pstring(Temp2);
			continue; }
		if(*Dir2)
			goto he;
		GetFile(Dir2); }

	if(!*Dir2) {
he:		Ptr = Help;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return; }

	Debug(("1'%s'%s'\n", Dir1, Pattern))
	Debug(("2'%s'%s'\n", Dir2, Temp2))

	if(strcmp(Temp2, "*")) {
		if(iswild(Temp2) || (Opt & O_SUB)) {
			ShowCpy();
			error(" with must be simple %sdirectory.", (Opt & O_SUB) ? "" : "file/"); }
		CmpFile = Pstring(Temp2); }

	Base1 = Dir1; while(*Base1) ++Base1;
	Base2 = Dir2; while(*Base2) ++Base2;

	Debug(("3'%s'%s'\n", Dir2, CmpFile || "*"))

	if(iswild(Pattern) && !iswild(Temp2)) {
		if(!(Opt * O_MTO1)) {
			ShowCpy();
			error(" is many-to-1 (use -1 if you really want to do this)"); } }

	if(!(Opt & O_QUIET))
		ShowCpy();

	dodir();

	if(!(Opt & O_QUIET)) {
		if(Dcount > 1) {
			printf("%u Dir(s)", Dcount);
			if(Dfail)
				printf(" %u failed", Dfail);
			Ps(", "); }
		printf("%u File(s)", Fcount);
		if(Ffail)
			printf(" %u difference(s)", Ffail);
		Ps(".\n"); }

	MemTst(0);
}
//ChtCmd cc comp -pof
