// DBKEYS
#include <stdio.h>
#include <dvmvideo.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;
#define	Vdebug(a)	//Vprintf a;
#define	MemTst(a)

#define	MFILE	"Y:\\DOSBOX"

#define	VNOR	0x17
#define	VHIL	0x71
#define	LINES	24

#define	LLEN	3
#define	POOL	4096

#define	O_SHOWF	0x01
#define	O_SHOWK	0x02
#define	O_EDIT	0x04
#define	O_DAVES	0x08
#define	O_INIT	0x10
#define	O_YES	0x20

#define	O_SHOW	0x03	// SHOWK|SHOWF
#define	O_HELP	0x0F	// SHOW|EDIT|DAVES

#include "map.h"

unsigned
	Tab = 4,
	Width = 74,
	Lines = 20,
	H,
	Line,
	Offset,
	Klen,
	Mlen,
	MapTop,
	Opos,
	Ptop, Ppos,
	Code[sizeof(Map)/(LLEN*2)],
	Nmap[sizeof(Map)/(LLEN*2)];
FILE
	*fp,
	*fpo;
unsigned char
	*Ptr,
	Opt = O_INIT | O_YES,
	Vmode,
	Mfile[128],
	Wfile[128],
	Buffer[128],
	Temp[128],
	Pool[POOL];

#include "keys.h"

//ChtTxt R:\Help.h
#include "R:\\Help.h"

#define	K_H		'H'
#define	K_1		'C'
#define	K_2		'A'
#define	K_3		'S'

void Close(void)
{
	if(fpo != stdout) {
		fclose(fpo);
		fpo = stdout; }
	if(Vmode) {
		Vclose();
		Vmode = 0; }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	Close();
	fputs(buf, stdout);
	exit(-1);
}

void Pc(unsigned char c)
{
	switch(c) {
	case '\t':
		do {
			++Opos; }
		while(Opos % Tab);
		goto a1;
	case '\r':
	case '\n':
		Opos = 0;
		goto a1; }
	++Opos;
a1:	if(Vmode) {
		Vputc(c);
		return; }
	putc(c, fpo);
}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);		}
void Nl(void)				{	Pc('\n');				}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}
void Pcc(unsigned char c)
{
	switch(c) {
	case '"':
	case'\\': Pc('\\'); }
	Pc(c);
}
void GoX(unsigned to)
{
	do {
		Pc(' ');
	} while(Opos < to);
}

unsigned char Help(void)
{
	unsigned char c;
	while(c = *Ptr++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

unsigned Prompt(unsigned char *p)
{
	unsigned i;
	unsigned char *p1, *p2, c, d;
	p1 = p;
	while(*p++);
	p2 = p;
	while(*p) Pc(*p++);
	for(;;) {
		if((c = toupper(kbget())) == 0x1B)
			Error("Abort");
		i = 0;
		while(d = p1[i++]) {
			if(c == d)
				goto a1; } }
a1:	if(*p2 == '\r') {
		Pc('\r');
		do {
			Pc(' '); }
		while(--p > p2);
		Pc('\r'); }
	return i-1;
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

void Ext(unsigned char *fn, unsigned *e)
{
	unsigned i, j;
	i = 0;
a1:	j = 0;
a2:	switch(fn[i++]) {
	case ':':
	case'\\':	goto a1;
	case '.':	j = i;
	default	:	goto a2;
	case 0	:	; }
	if(!j)
		strcpy(fn+i-1, e);
}

unsigned EndMat(unsigned char *lst[], unsigned char *np)
{
	unsigned i, j, k, s, ls, ns, ct;
	unsigned char *lp, e;
	e = 0;
a1:	ns = strlen(np);
	ct = i = k = 0;
	while(lp = lst[i]) {
//		i += LLEN;
		ls = s = strlen(lp);
		j = ns;
		do {
			if(toupper(lp[--s]) != np[--j])
				goto a2; }
		while j;
		Debug(("EndMat'%s'%s'\n", np, lp))
		if(e)
			printf("%s\n", lp);
		k = i;
		if(ls == ns)
			goto re;
		++ct;
a2:		i += LLEN; }
	switch(ct) {
	default	:
		if(!e) {
			e = 7;
			goto a1; }
		Error("NotUnique: %s\n", np);
	case 0	:	Error("NotFnd: %s\n", np);
	case 1	:	; }
re:	Debug(("EndMat'%s'=%u\n", np, k))
	return k;
}

unsigned LenLIST(unsigned char *list[])
{
	unsigned i, j, l;
	unsigned char *p;
	for(i=l=0; p = list[i]; i += LLEN) {
		if((j = strlen(p)) > l)
			l = j; }
	Debug(("List=%u %u\n", i, i/LLEN))
	return l+1;
}

void PrKey(unsigned i)
{
	unsigned j, v;
	unsigned char *p;
	j = (v = Code[i/LLEN]) & 0xFFF;
//	j = (v = i) & 0xFFF;
	for(i=0; p = Keys[i]; i += LLEN) {
		if(Keys[i+Offset] == j) {
			if(v & _H)		Pc(K_H);
			if(v & _1)		Pc(K_1);
			if(v & _2)		Pc(K_2);
			if(v & _3)		Pc(K_3);
			if(v & 0xF000)	Pc(':');
			Ps(p);
			return; } }
	Ps("???");
}

void ShowLIST(void)
{
	unsigned i, n, l, ll;
	unsigned char **list, *p;
	if(Opt & O_SHOWF) {
		list = Map;
		ll = Mlen;
		p = "FunctionCode"; }
	else {
		list = Keys;
		ll = Klen;
		p = "Key"; }
	Pr("**%s names:\n", p);
	for(i=n=l=0; p = list[i]; i += LLEN) {
		if( (Opos + strlen(p)) >= Width) {
			Nl();
			if(++l >= Lines) {
				Prompt(" \0\rPress SPACE");
				l = 0; }
			n = 0; }
		if(n)
			GoX(n*ll);
		Ps(p);
		++n; }
	Nl();
}
ShowMAP(void)
{
	unsigned i, k;
	unsigned char *p;
	for(i=0; p = Map[i]; i += LLEN) {
		k = Map[i+Offset];
		if(Opt & O_YES) {
			if(Code[i/LLEN] != k)
				goto a1;
			continue; }
		if(k & 0xFFF) {
a1:			Ps(p);
			GoX(Mlen);
			PrKey(i);
			Nl(); } }
}


void PrMk(unsigned v)
{
	Pr(" \x22key %u", v & 0xFFF);
	if(v & _H) Ps(" host");
	if(v & _1) Ps(" mod1");
	if(v & _2) Ps(" mod2");
	if(v & _3) Ps(" mod3");
	Pc(0x22);
}

unsigned PrMap(unsigned i)
{
	unsigned v;
	if(v = Code[i/LLEN]) {
		Ps(Map[i]);
		if(v != _H)
			PrMk(v);
		return 7; }
	return 0;
}

void PdbVer(void)
{
	Ps((Offset & 1) ? "DoxBox-X" : "MegaBuild6");
}

#ifndef MemTst
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Parse string from input stream
unsigned Parse(unsigned char *p)
{
	unsigned i;

	Skip(); i = 0;
a1:	switch(p[i] = *Ptr) {
	default: ++Ptr; ++i;	goto a1;
	case '"' : ++Ptr;
	case ' ' :
	case '\t':
	case 0 : p[i] = 0; }
	return i;
}

void LoadCode(void)
{
	unsigned i, k, v, e;
	unsigned char *p;
	Debug(("Lc'%s'\n", MAPFILE))
	fp = fopen(Mfile, "rvq");
	e = 10;
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		++Line;
		switch(Skip()) {
//		case '[':
		case 0	:	continue; }
		Parse(Temp);
		for(i=0; p = Map[i]; i += LLEN) {
			if(!strcmp(Temp, p))
				goto a1; }
		Debug(("?nf'%s'\n", Temp))
		continue;
a1:		Debug(("'%s'\n", Buffer))
		if(Skip() != '"') {
			Debug(("!\x22"))
			continue; }
		++Ptr;
		v = 0;
		while(Parse(Temp)) {
			if(!strcmp(Temp, "key"))
				continue;
			if(isdigit(*Temp)) {
				k = v = atoi(Temp);
				continue; }
			if(!v)	Error("?value");
			if(!strcmp(Temp, "host")) v |= _H;
			if(!strcmp(Temp, "mod1")) v |= _1;
			if(!strcmp(Temp, "mod2")) v |= _2;
			if(!strcmp(Temp, "mod3")) v |= _3;
			Debug(("[%s]%04x\n", Temp, v))
			if(!(v & 0xF000)) Error("?mod?");
		}
		Code[i/LLEN] = v;
#if 0
		for(j=0; Map[j]; j += LLEN) {
			if(Map[j+Offset] == k) {
				Code[i/LLEN] = v;
				goto a2; } }
//		Pr("?nc%04x %u\n", v, v);
		PdbVer();
		Ps(" code unknown: ");
		Ps(Buffer);
		Nl();
		if(!--e)
			Error("Too many");
a2:
//		Nl();
#endif
	}
	fclose(fp);
}

void GetMod(void)
{
	unsigned i, j;
	i = H = 0;
a1:	switch(Ptr[i++]) {
	case K_H:	j = _H;	goto a2;
	case K_1:	j = _1;	goto a2;
	case K_2:	j = _2;	goto a2;
	case K_3:	j = _3;
a2:		H |= j;
		goto a1;
	default	:	H = i = 0;
	case ':':	Ptr += i; }
}

void Squish(void)
{
	unsigned i, j;
	for(i=j=0; Map[i]; i += LLEN) {
		if(Map[i+Offset]) {
			Map[j] = Map[i];
			Map[j+1] = Map[i+1];
			Map[j+2] = Map[i+2];
			Nmap[i/LLEN] = j/LLEN;
			j += LLEN; } }
	Map[j] = 0;
	MapTop = (j/LLEN)-1;
}

void Edit(void);
void PatDaves(void);
main(int argc, char *argv[])
{
	unsigned i, j;
	unsigned char c;

	MemTst(7);
	fpo = stdout;

	Klen = LenLIST(Keys);
	Mlen = LenLIST(Map);
	Debug(("Klen=%u Mlen=%u\n", Klen, Mlen))

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt Mhelp
DosBox KEYS mapper

use:	DBKEYS functioncode~~1=[mods:~~2]key~~1... [optiopns]

opts:	-C				show functionCodes names
		-K				show Keys names
		-S				Show full map
		-Q				Query map changed from default
		-A				install Alternate function codes					~~3
		-E				interactively Edit keymap
		-D				reset to Default key mappings (ignore DOSBOX.MAP)
		-Y				auto Yes to "save?"
		-Ffile[.MAP]	set mapFile							   [Y:\\DOSBOX.MAP]
		-Wfile[.MAP]	set Write file						   [     " "	  ]
		-X				force DosBox-X					> otherwise detect the
		-M				force MegaBuild6 (SVN)			> edition of DosBox!
		-?				additional Help

Modify DosBox key map easier than with SDL's map editor, and also make simple
map changes from the command line.								  ~~n  see -?

Dave Dunfield - https://dunfield.themindfactory.com - ~T~Y/~t~M/~D
*/
			case 'F':	strcpy(Mfile, Ptr);	continue;
			case 'W':	strcpy(Wfile, Ptr);	continue;
			case 'X':	Offset = 1;			break;
			case 'M':	Offset = 2;			break;
			case '?':	Ptr = Help1;		goto he1;
			case 'K':	c = O_SHOWK;		goto o2;
			case 'C':	c = O_SHOWF;		goto o2;
			case 'Q':	c = O_SHOW;			goto o2;
			case 'S':	c = O_SHOW|O_YES;	goto o2;
			case 'D':	c = O_INIT;			goto o2;
			case 'E':	c = O_EDIT;			goto o2;
			case 'A':	c = O_DAVES;		goto o2;
			case 'Y':	c = O_YES;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
/*ChtTxt Help1
~~1	When assigning keymap via commane line, you only need enter enough of the
	LAST of a name to be unique!
~~2	mod keys are:	'H'ost   'C'ontrol   'A'lt   'S'hift
	eg: keymap tdown=CAS:end		<=	hand_shutdown = Ctrl+Alt+Shift+End
~~3	These are keys which conflict with "standard" DOS keys much less that the
	MegaBuild6 defaullt ones. To see: DBKEYS -DAQ
*/
		strcpy(Temp, Ptr);
		strupr(Temp);
		Pstring(Temp); }


	if(!( (Opt & O_HELP) || Ptop )) {
he:		Ptr = Mhelp;
he1:	Help();
		return; }

	if(!*Mfile) {
		strcpy(Mfile, MFILE);
#ifndef MemTst
		switch(Offset) {
		case 1	:	strcpy(Mfile, "DBX.MAP");	break;
		case 2	:	strcpy(Mfile, "MB6.MAP");	}
#endif
	}
	Ext(Mfile, ".MAP");
	if(!*Wfile) strcpy(Wfile, Mfile);
	Ext(Wfile, ".MAP");
#if 0
	Debug1(("M'%s'\n", Mfile))
	Debug1(("W'%s'\n", Wfile))
	return;
#endif
	if(!Offset) {
		if(fp = fopen("Z:\\SYSTEM\\IMGMOUNT.COM", "rb")) {
			Offset = 1;
			fclose(fp); }
		else if(fp = fopen("Z:\\IMGMOUNT.COM", "rb")) {
			Offset = 2;
			fclose(fp); }
		else
			Error("Cannot detect type of DosBox!"); }
	Debug(("Offset=%u\n", Offset))

	Squish();
	switch(Opt & O_SHOW) {
	case O_SHOWK:
	case O_SHOWF:
		ShowLIST();
		goto ex; }

	for(i=0; Map[i]; i += LLEN)
		Code[i/LLEN] = Map[i+Offset];
	if(Opt & O_INIT)
		LoadCode();

	if(Opt & O_DAVES)
		PatDaves();

	while(Ppos < Ptop) {
		strcpy(Ptr = Temp, Pool+Ppos);
		while(Pool[Ppos++]);
		Debug(("'%s'",Temp))
a1:		switch(*Ptr++) {
		default	:	goto a1;
		case 0	:	Error("?No='%s'\n", Temp);
		case '=':	*(Ptr-1) = 0; }
		Debug(("%s'\n", Ptr))
		i = EndMat(Map, Temp);
		if(j = Skip()) {
			GetMod();
			j = EndMat(Keys, Ptr); }
		Debug(("%s(%u}=%s(%u) %u\n", Temp, i/LLEN, Ptr, j, Keys[j+Offset]))
		Code[i/LLEN] = (unsigned)Keys[j+Offset] | H;
	}

#if 0
	for(i=0; Map[i]; i += LLEN) {
		Pr("M%u ", i/LLEN);
		PrMap(i);
		Ps(" -- ");
		PrKey(i);
		Nl(); }
	ShowLIST(0);
#endif

	if(Opt & O_SHOW) {
		ShowMAP();
		goto ex; }

	if(Opt & O_EDIT)
		Edit();

	concat(Temp, "NY:Save'", Wfile, "'YN? ");
	Temp[2] = 0;
	if(Opt & O_YES) switch(Prompt(Temp)) {
		default	: Ps("No\n");	goto ex;
		case 1	: Ps("Yes\n"); }

	fpo = fopen(Wfile, "wvq");
	if(Offset = 1) Ps("[SDL2]\n");
	for(i=0; Map[i]; i += LLEN) {
		if(PrMap(i))
			Nl(); }
	Ps("mod_1 "); PrMk(Code[MODlctrl]); 	PrMk(Code[MODrctrl]);	Nl();
	Ps("mod_2 "); PrMk(Code[MODlalt]);		PrMk(Code[MODralt]);	Nl();
	Ps("mod_3 "); PrMk(Code[MODlshift]);	PrMk(Code[MODrshift]);	Nl();

ex:	Close();

	MemTst(0);
}


unsigned
	Cpos,
	Kpos,
	Kold;

void Color(unsigned char c)
{
	if(Vmode != c)
		Vcolor(Vmode = c);
}

void DrawKeys(unsigned y, unsigned h)
{
	unsigned i, j;
	unsigned char *p;
	i = 0;
	while(p = Kmap[i]) {
		j = Kmap[i+1];
		Vgotoxy((j & 255)+1, (j >> 8)+y);
		if(!h--)
			Color(VHIL);
		Vputs(p);
		Color(VNOR);
		i += KLEN; }
}

unsigned FindNxt(unsigned i)
{
	unsigned j, x, y;
	x = (j = (unsigned)Kmap[(i *= KLEN)+1]) & 255;
	y = (j >> 8)+1;
	while(Kmap[i += KLEN]) {
		j = Kmap[i+1];
		if((j >> 8) < y)	continue;
		if((j & 255) >= x)	break; }
	return i/KLEN;
}
unsigned FindPrv(unsigned i)
{
	unsigned j, x, y;
	x = (j = (unsigned)Kmap[(i *= KLEN)+1]) & 255;
	y = (j >> 8)-1;
	while(i -= KLEN) {
		j = Kmap[i+1];
		if((j >> 8) > y)	continue;
		if((j &255) <= x)	break; }
	return i/KLEN;
}

unsigned StrSam(unsigned char *p1, unsigned char *p2)
{
	unsigned i;
	i = 0;
	do {
		if(p1[i] != p2[i])
			goto ex; }
	while(p1[i++]);
ex:	return i;
}

unsigned LookKey(void)
{
	unsigned i, j, k, l;
	unsigned char *p;
	for(i=l=0; p = Kmap[i]; i += KLEN) {
		if((j = StrSam(p, Ptr)) > l) {
			l = j;
			k = i; } }
	return l ? k/KLEN : -1;
}

void PrMod(unsigned char *p, unsigned m)
{
	Vputs(" '");
	if(H & m) Color(VHIL);
	Vputc(*p);
	Color(VNOR);
	Vputc('\'');
	Vputs(p+1);
}

void AdjCp(unsigned adj)
{
	unsigned i, j, k, l;
	unsigned char *p1, *p2;
	if(Kpos != Kold) {
		p1 = Kmap[Kpos*KLEN];
		Vdebug(("\nKey'%s'", p1))
		k = -1;
		for(i=l=0; p2 = Keys[i]; i += LLEN) {
			if((j = StrSam(p1, p2)) > l) {
				l = j;
				k = i; } }
		Vdebug(("%u %u [%u]", k, k/LLEN, Cpos))
		if(k != -1)
			Code[Cpos] = Keys[k+Offset] | (H & 0xF000);
	}
	Cpos = adj;
}

void Edit(void)
{
	unsigned i, j, k, kt;

	kt = (sizeof(Kmap)/(KLEN*2))-1;

	Vopen(Vmode = VNOR);
	Kpos = Cpos = 0;
a0:	Vgotoxy(68, LINES);
	Ps("'?' = help");
a1:	if(Cpos & 0x8000)	Cpos = 0;
	if(Cpos > MapTop)	Cpos = MapTop;
	Ptr = Map[j = Cpos*LLEN];
	k = (H = Code[Cpos]) & 0xFFF;
	Vgotoxy(30, 1);
	Vputs("DosBox function: ");
	Vputs(Ptr);
	if(!Map[j+Offset]) {
		Vputs(" !");
		PdbVer(); }
	Vdebug((" [%u %04x]", k, H))
	Vcleol();
	Kpos = -1;
	for(i=0; Ptr = Keys[i]; i += LLEN) {
		if(Keys[i+Offset] == k) {
			Kpos = LookKey();
			break; } }
	Vdebug((" {%u}", Kpos))
	Kold = Kpos;

	Vgotoxy(0, LINES-1);
	Ptr = Help2;	Help();
/*ChtTxt Help2
Select "DosBox function" BEFORE picking a key. 
Movement of Key affects current function only!
*/
a2:	Vgotoxy(28, 10);
	PrMod("Host",	_H);
	PrMod("Ctrl",	_1);
	PrMod("Alt'",	_2);
	PrMod("Shift",	_3);

a3:	DrawKeys(3, Kpos);

b1:	switch(toupper(Vgetk())) {
	default	:	goto b1;
	case _KPU: i = 1;
b2:		AdjCp(Cpos - i);
		goto a1;
	case _KPD:	i = 1;
b4:		AdjCp(Cpos + i);
		goto a1;
	case _CPU:	i = 10;			goto b2;
	case _CPD:	i = 10;			goto b4;
	case _CHO:	AdjCp(0);		goto a1;
	case _CEN:	AdjCp(MapTop);	goto a1;
	case _KRA:	++Kpos;			goto b5;
	case _KLA:	--Kpos;
b5:		if(Kpos & 0x8000)		Kpos = 0;
		if(Kpos > kt)			Kpos = kt;
		goto a3;
	case _KUA:	Kpos = FindPrv(Kpos);	goto b5;
	case _KDA:	Kpos = FindNxt(Kpos);	goto b5;
	case _KHO:	Kpos = 0;				goto a3;
	case _KEN:	Kpos = kt;				goto a3;
/*ChtTxt Ihelp
KeyMap interactive keys:

	   ~</~>			selecxt Key
	   ~^/~v			"" by line
	Home/End		first/last ""
	  Space			reset Key

	PgUp/PgDn		select Functiion (by 1)
   ^PgUp/^PgDn		"" by 10
   ^Home/^End		first/last function

	   'H'			toggle	Host
	   'C'			  ""	Control
	   'A'			  ""	Alt
	   'S'			  ""	Shift

	  Enter			save/exit
	   Esc			abort/cancel
*/
	case 'H':	H ^= _H;				goto a2;
	case 'C':	H ^= _1;				goto a2;
	case 'A':	H ^= _2;				goto a2;
	case 'S':	H ^= _3;				goto a2;
	case ' ':	Kpos = Kold;			goto a3;
	case '?':
		Vclscr();
		Ptr = Ihelp;
		Help();
		Vgotoxy(0, LINES);
		Prompt(" \0Press SPACE");
		Vclscr();
		goto a0;
	case 0x1B:	Error("?Abort");
	case'\r':
	case'\n':	; }
	AdjCp(Cpos);
	Close();
}

unsigned Daves[] = {
	4,          155,    // hand_shutdown        End
	5,          83,     // hand_capmouse        F10
	10,         84,     // hand_ejectpage       F11
	15,         74,     // hand_mapper          F1
	25,         85,     // hand_speedlock       F12
	36,         76,     // hand_decfskip        F3
	37,         75,     // hand_incfskip        F2
	40,         79,     // hand_recwave         F6
	42,         81,     // hand_caprawmidi      F8
	43,         80,     // hand_caprawopl       F7
	44,         82,     // hand_video           F9
	45,         78,     // hand_scrshot         F5
	52,         159,    // hand_cycledown       Down
	53,         157,    // hand_cycleup         Up
	58,         77,     // hand_swapimg         F4
	218,        152,    // hand_restart         Home
	0 };
void PatDaves(void)
{
	unsigned i, m;
	for(i=0; m = Daves[i]; i += 2) {
		Code[Nmap[m]] = (unsigned)Map[(Nmap[Daves[i+1]]*LLEN)+Offset] | 0x7000;
	}
}
