// DBPATCH
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	POOL	8192
#define	SYMS	128
#define	QLEN	7
#define	MSYM	8

#define	BLK		8

#define	S_ZEND	0x01	// Zero END
#define	S_LLEN	0x02	// Leading Length
#define	S_SEND	0x04	// Space END

#define	O_QUIET	0x01
#define	O_GO	0x02
#define	O_REST	0x04
#define	O_SHOW	0x08
#define	O_BUILD	0x80

unsigned
	H, L,
	H1, L1,
	Seg, Stop,
	Len,
	GoFlag,
	Fext,
	SYtop,
	Ptop;
FILE
	*fp,
	*fpo;
HANDLE
	fh;
unsigned char
	*Ptr,
	*Syms[SYMS],
	Opt = O_QUIET,
	Type,
	SYfnd[SYMS],
	Fname[128],
	Temp[128],
	Pool[POOL];
unsigned char
//	SYlen[SYMS],
	SYtyp[SYMS],
//	Rfile[128],
	Wfile[128];
#define	Rfile	Fname
#define	SYlen	SYfnd

//ChtTxt R:\Help.h
#include "R:\Help.h"

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

void Pc(unsigned char c)	{	putc(c, fpo);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

void Help(unsigned char *p)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

unsigned StrCmp(unsigned idx)
{
	unsigned i;
	unsigned char c;
	Ptr = Syms[idx];
	Debug(("'%s'%s'\n", Temp, Ptr))
	i = 0;
	do {
		c = toupper(Temp[i]);
		if(toupper(Ptr[i++]) != c)
			return 0; }
	while(c);
	Len = 0;
	while(*Ptr++)
		++Len;
	Debug(("Fs'%s'%s'%u\n", Temp, Ptr, Len))
	return 7;
}

unsigned Gb(void)
{
	unsigned c;
	if((c = getc(fp)) == EOF)
		Error("?eof");
	return c;
}
unsigned Gw(void)
{
	unsigned w;
	w = Gb();
	return (Gb() << 8) | w;
}


//#define	S_ZEND	0x01	// Zero END
//#define	S_LLEN	0x02	// Leading Length
//#define	S_SEND	0x04	// Space END
void DoPatch(void)
{
	unsigned i, o, s, h, l;
	unsigned char c, d, tmp[128];

	if(Type & S_LLEN) {
		o = 1;
		s = Len + 2; }
	else {
		o = 0;
		s = Len+1; }

	h = H;
	if((l = L - o) > L)
		--h;

	if(i = lseek(fh, h, l, 0))
		Error("?Seek%04x%04x", h, l);
	if(!(Type & (S_SEND|S_ZEND))) {
		d = '?';
		goto a1; }
	if(GoFlag) {
		c = (Type & S_SEND) ? ' ' : 0;
		i = strlen(Ptr);
		if(Type & S_LLEN)
			*tmp = i;
		memcpy(tmp+o, Ptr, i);
		while(i < Len)
			tmp[i++ + o] = c;
		d = '=';
		--s;
		if(Opt & O_GO)
			write(tmp, s, fh);
	} else {
		d = '-';
a1:		read(tmp, s, fh);
		i = 0;
		if(Type & S_LLEN) {
			if(tmp[i++] > MSYM)
				goto e1; }
		while(i < s) {
			if(c = Temp[i++]) {
				if((c < ' ') || (c > '~')) {
e1:					Ps(Fname);
					Error(" does not match DBP database!%02x", c); } } } }

	if(Opt & O_QUIET) {
		printf("%c%02x %04x%04x", d, Type, H, L);
		for(i=0; i < s; ++i)
			Pr(" %02x", tmp[i]);
		while(i < 16) {
			Ps("   ");
			++i; }
		Pc(' ');
		for(i=0; i < s; ++i) {
			c = tmp[i];
			if((c < ' ') || (c > '~'))
				c = '.';
			Pc(c); }
		Nl(); }
}
unsigned Open(unsigned om)
{
	if(!(fh = open(Fname, om)))
		Error("?open'%s'\n", Fname);
}

unsigned Rsym(void)
{
	unsigned i, j, k;
	if((i = getc(fp)) != EOF) {
		if(i > MSYM) {
e1:			Error("DBP database corrupt!%u", i); }
		j = 0;
		while(j < i) {
			Temp[j++] = k = Gb();
			if((k < ' ') || (k > '~'))
				goto e1; }
		return Temp[j] = 0; }
	return EOF;
}

void Ext(unsigned char *fn, unsigned char *e)
{
	unsigned i;
	Debug(("'%s'%s'\n", fn, e))
	i = 0;
a1:	Fext = 0;
a2:	switch(fn[i++]) {
	case ':':
	case'\\':	goto a1;
	case '.':	Fext = i;
	default	:	goto a2;
	case 0	:	; }
	if(!Fext) {
		fn[i-1] = '.';
		strcpy((Fext=i)+fn, e); }
	Debug(("Ext'%s'%u\n", fn, j))
}

main(int argc, char *argv[])
{
	unsigned i, j;
	unsigned char c;
//	unsigned char t;

	fpo = stdout;
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:				goto he;
/*ChtTxt Mhelp1
DosBox PATCH

use:	DBPATCH file[.DBP.EXE] name=new [options]
		DBPATCH -B file[.BFB] [outfile[.DBP]] [options]

opts:	-B			Build .DBP database (more help: -B with no options)
		-G			Go (otherwise show what would be changed)
		-R			Restore original strings
		-Q			Quiet: don't show changes
		-S			Show available names
	
Patches DOSBOX.EXE, allowing certain internal "strings" (config file extension,
commands etc.) to be changed.

Note: Reads name.DBP (DosBox Patch) database to determine strings and type of
patches to be applied.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'B': c = O_BUILD;	goto o2;
			case 'G': c = O_GO;		goto o2;
			case 'R': c = O_REST;	goto o2;
			case 'Q': c = O_QUIET;	goto o2;
			case 'S': c = O_SHOW;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!*Fname) {
			strcpy(Fname, Ptr);
			continue; }
		if(SYtop >= SYMS)
			Error("?#Syms");
		j = 0;
o3:		switch(Ptr[j]) {
		default	:	++j;	goto o3;
		case 0	:	Error("?='%s'", Ptr);
		case '=':	; }
		Ptr[j] = 0;
		Syms[SYtop++] = Pstring(Ptr);
		Pstring(Ptr+j+1);  }
	if(!*Fname) {
he:		Help((Opt & O_BUILD) ? Mhelp2 : Mhelp1);
		return; }

	if(Opt & O_BUILD) {
		switch(SYtop) {
		default:	goto he;
		case 1 :
			strcpy(Wfile, Syms[0]);
			Ptop = SYtop = 0;
		case 0	:	; }
		if(Opt & O_REST)
			goto he;
		Xmain();
		return; }

	Ext(Fname, "DBP");
	Debug(("Fn'%s'%u\n", Fname, Fext))

#if 0
	for(i=0; i < SYtop; ++i) {
		Pr("%u'%s", i, Ptr = Syms[i]);
		while(*Ptr++);
		Pr("'%s'\n", Ptr); }
#endif

//	LenName
//	TypeAddr...
//	0
	fp = fopen(Fname, "rbvq");
	if(Opt & O_SHOW) {
		Ps(Fname);
		Ps(" contains the following symbols:\n");
		Len = 1;
		while(!Rsym()) {
			if(!--Len) {
				Nl();
				Len = QLEN; }
			Pr("%10s=", Temp);
			while(Gb()) {
				Gw();
				Gw(); } }
		Nl();
		return; }
	strcpy(Fname+Fext, "EXE");

	if(Opt & O_REST) {
		if(!(Opt & O_GO))
			Error("-R must have -G");
		Open(F_READ|F_WRITE);
		GoFlag = 7;
		while(!Rsym()) {
			Len = strlen(Ptr = Temp);
			while(Type = Gb()) {
				L = Gw();
				H = Gw();
				DoPatch(); } }
		goto ex; }

	if(!SYtop) goto he;
	Open(F_READ);
a3:	while(!Rsym()) {
		for(Len = i=0; i < SYtop; ++i) {
			if(StrCmp(i)) {
				SYfnd[i] = 7;
//				if(Opt & O_REST)
//					Ptr = Syms[i];
				break; } }
		while(Type = Gb()) {
			L = Gw();
			H = Gw();
			if(Len)
				DoPatch(); } }

	if(Opt & O_GO)
		close(fh);
	if(!GoFlag) {
		GoFlag = 7;
		for(i=j=0; i < SYtop; ++i) {
			if(!SYfnd[i]) {
				printf("?Nf'%s'\n", Syms[i]);
				j = 7; } }
		if(j) goto ex;
		rewind(fp);
		if(Opt & O_GO)
			Open(F_READ|F_WRITE);
		goto a3;
	}
ex:	fclose(fp);
}
/*ChtTxt Mhelp2
Builds the .DBP database for a specific DOSBOX.EXE

Uses the .BFB from Binary File Search (BFS from my site) to identify the
addresses of various symbol text and the type of patchs needed:
	eg:	BFS DOSBOX.EXE :DB -BDOSBOX
		DBPATCH -B DOSBOX
.DBP content:
	<1length of symbol name>				For each symbol occuring
	<1symbol name characters>				in the BFS generated .BFB
	<1type>	0000000SLZ	PadWith'S'pace  (otherwise 0)	> Repeats for each
	<4address>			^'L'engthLeads 'Z'eroFollows^	> associated address
	<1zero>									Marks end of symbol
	^repeats for each symbol^

Dave Dunfield   -   https://dunfield.themindfactory.com
*/

//? DBPDB
void Abort(void)
{
	if(kbtst() == 0x1B)
		Error("?Abort");
}

void Psb(unsigned char b)
{
	if(fpo) {
		putc(b, fpo);
		return; }
	poke(Seg, Stop++, b);
	if(!Stop)
		Error("?SegOver");
}
void Psw(unsigned v)
{
	Psb(v);
	Psb(v >> 8);
}

void Aadj(unsigned i)
{
	L1 = L + i;
	H1 = H;
	if(i & 0x8000) {
		if(L1 > L)
			--H1; }
	else {
		if(L1 < L)
			++H1; }
}

void Dump(unsigned l)
{
	unsigned i, j;
	unsigned c;
	j = l / 2;
	for(i=0; i < l; ++i) {
		Pc((i==j) ? '-':' ');
		Pr("%02x", Temp[i]); }
	Pc(' ');
	for(i=0; i < l; ++i) {
		c = Temp[i];
		if((c < ' ') || (c > '~'))
			c = 0xFA;
		Pc(c); }
}

Xmain()
{
	unsigned i, j, l;
	unsigned char c, d, t;

	Seg = alloc_seg(4096);

	Debug(("Rb'%s'\n", Rfile))

	if(Opt & (O_SHOW|O_GO)) {
		Ext(Rfile, "DBP");
		fp = fopen(Rfile, "rbvq");
		if(Opt & O_GO) {
			fpo = fopen("DOSBOX.BFS", "wvq");
			Ps("-C\n"); }
		for(;;) {
			switch(l = getc(fp)) {
			case 0x00:
			case EOF :
				if(Opt & O_GO)
					fclose(fpo);
				fclose(fp);
				return; }
			for(i=0; i < l; ++i)
				Temp[i] = Gb();
			Temp[i] = 0;
			Ps(Temp); Nl();
			while(t = Gb()) {
				L = Gw();
				H = Gw();
				if(Opt & O_SHOW)
					Pr("%02x %04x%04x\n", t, H, L); } } }

	fpo = 0;	
	Ext(Rfile, "BFB");
	Debug1(("Bfb'%s'\n", Rfile))
	fp = fopen(Rfile, "rbvq");
	if(!*Wfile) {
		strcpy(Wfile, Rfile);
		Wfile[Fext] = 0; }
	strcpy(Rfile+Fext, "EXE");
	Ext(Wfile, "DBP");

	while(l = Gb()) {
		for(i=0; i < l; ++i)
			Temp[i] = Gb();
		Temp[i] = 0;
		Debug1(("%u'%s'\n", l, Temp))
		if(SYtop >= SYMS)
			Error("?#syms");
		Syms[SYtop] = Pstring(Temp);
		SYlen[SYtop++] = l; }

	if(!(fh = open(Rfile, F_READ)))
		Error("?open'%s'", Rfile);
	Debug1(("Rf'%s'\n", Rfile))
	while((i = getc(fp)) != EOF) {
		L = Gw();
		H = Gw();
		l = SYlen[i];
		Debug1(("%04x%04x", H, L))
		Debug1((" %-5u%u'%s'\n", i, l, Syms[i]))
		Aadj(-BLK);
		if(j = lseek(fh, H1, L1, 0))
			Error("?Read(%04x%04x)%u", H, L, j);
		read(Temp, BLK+BLK, fh);
		c = Temp[BLK-1];
		d = Temp[SYlen[i]+BLK];
//	if(i)
		Debug1(("{%x}", d))
		switch(d) {
		default	:
			continue;
		case 0x00:
			t = S_ZEND;
	if(i)
			if(c) {
				if(c != l)
					continue;
				t = S_LLEN|S_ZEND; }
			break;
		case '.':
		case '.':
		case ')':
			if(i)
				continue;
		case ' ':
			t = S_SEND;
			if(i) switch(c) {
				default	:	continue;
				case ' ':
				case'\t':
				case 0x00: ; } }
		SYtyp[i] |= t;
		if(Opt & O_QUIET) {
			printf("%04x %02x %02x%02x", L, t, c, d);
			Dump(Temp, BLK+BLK);
			Nl(); }
		Psb(i);
		Psb(t);
		Psw(L);
		Psw(H); }
	Debug1(("!!"))
	close(fh);
	fclose(fp);

#if 0	//7
	fpo = fopen(Wfile, "wbvq");
	Debug1(("Wf'%s'\n", Wfile))
	for(i=0; i < SYtop; ++i) {
		if(SYtyp[i]) {
			Debug(("S%u'%s'\n", i, Syms[i]))
			Psb(l=SYlen[i]);
			Ptr = Syms[i];
			for(j=0; j < l; ++j)
				Psb(Ptr[j]);
			for(j=0; j < Stop; j += 6) {
				if(peek(Seg, j) == i) {		// Match symbol
					t =  peek(Seg, j+1);
					L = peekw(Seg, j+2);
					H = peekw(Seg, j+4);
					Debug(("%02x %04x%04x\n", t, H, L))
					Psb(t);
					Psw(L);
					Psw(H);
			} }
			Psb(0); } }
	fclose(fpo);
#endif
}
