// DBSETUP
#include <stdio.h>
#include <window.h>
#define	Debug(a)	//Printf a;
#define	Debug1(a)	Printf a;
//#define	TEST

#ifdef TEST
	#define	DBIN	"DOSBOX.INI"
	#define	DBOUT	"DOSBOX.NIN"
	#define	HOME	"$HOME$"
#else
	#define	DBIN	"Y:\\DOSBOX.INI"
	#define	DBOUT	"Y:\\DOSBOX.INI"
	#define	HOME	"Y:\\$HOME$"
#endif
#define	POOL	8192
#define	ITEMS	16
#define	VOFFSET	2

#define	NSEG	2
#define	VNOR	0x17
#define	VREV	0x71

#define	O_YES	0x01
#define	O_RESET	0x02

unsigned
	Line,
	MntLine,				// Where "mounts" go
	Msel,					// Menu select
	Apos = -1,				// AutoExec[pos]
	Itop,					// Top of item list
	Ptop,					// Top of string pool
	Seg, SegS, SegE,		// Extern segments Start/End
	SegT, Stop, Spos;		// Topseg, Top, position
FILE
	*fpi,
	*fpo;
unsigned char
	*Ptr,
	*Ptr1,
	Opt = O_YES,
	Iaef = 0x80,			// Initial AutoExecFlag
	WinA = 7,				// Window active
	*Item[ITEMS],			// Item list
	Buffer[256],
	Temp[128],
	Pool[POOL];
extern unsigned RAND_SEED;

unsigned char *Sections[] = {
	"WindowResolution=",	//0
	"Output=",				//1
	"Scaler=",				//2
	"Core=",				//3
	"Cycles=",				//4
	"Serial1=",				//5
	"Serial2=",				//6
	"Serial3=",				//7
	"Serial4=",				//8
	"RealNic=",				//9
	"MacAddr=",				//10
	"Path ",				//11
#define	SClast		12
	"mount",				//12
	0 };
unsigned char *SecDef[] = {
	"640x480",
	"surface",
	"normal2x",
	"dynamic",
	"max",
	"directserial realport:COM1",
	"directserial realport:COM1",
	"nullmodem transparent:1 txdelay:1",
	"disabled",
	0 };
unsigned		SecLine[SClast];
unsigned char	SecTxt[SClast][65];
unsigned char	Mounts[25][65];

// 80(special)40=Newline 3F=space)
unsigned char SRhlp[] = {"\
Video resolution in pixels expressed as: nx,ny\
\xC8eg: `640x480\x88\
\xCC`800x600\x88\\\
\xCC`900x675\x89> to get these, select\
\xCC`1024x768\x88>\x84\"output type\"\
\xCC`1160x870\x88> other than \"surface\"\
\xCC`1280x1024\x86/"};n\

unsigned char VOhlp[] = {"\
\x88eg: `surface\x88>always 640x480\
\xCC`overlay\xCC`opengl\xCC`openglnb\xCC`ddraw"};

unsigned char VShlp[] = {"\
\x88eg: `none\xCC`normal2x\xCC`normal3x"};

unsigned char CRhlp[] = {"\
Type of CPU core:\n\
\xC8eg: `auto\x8B>not always reliable, may be slower\
\xCC`dynamic\x88>fastest: fails on some systems\
\xCC`normal\
\xCC`simple"};

unsinged char CYhlp[] = {"\
Approx. instructions/millisecond\n\
\xC8`auto\xC8`fixed {value}\xC8`max"};

unsigned char CMhlp[] = {"\
\x88eg:\x84`disabled\
\xD2`dummy\
\xCB`directserial realport:COM1\x81[rxdelay:1]\
\xD2`modem [listenport:n]\
\xCE`nullmodem [server] [transparent:1] [txdelay:1]\
\xD8[rxdelay] [usedtr] [port] [telnet] [inhsocket]"};

unsigned char ENhlp[] = {"\
The number of the network interface to use, to see the available interfaces:\n\
\xC6DosBox-SVN: command 'realnic list'\x88(view in DosBox status)\
\xC8Press '?' to perform\x84^^\x84now!" };

//\xC6DosBox-X: Help->List network interfaces\
unsigned char ENhlp1[] = {"\
\x84Look in the DosBox status window to see available network interfaces\n\
\xC8Note: This may have rendered the NIC inoperative util you\
\xDCrestart DosBox!" };

unsigned char EMhlp[] = {"\
6 hex bytes:\n\
\xCC`AC:DE:48:xx:xx:xx\
\xCC^^ ^^ ^^ -------- Reserved for private use\
\xD5must be DIFFERENT for every DosBox on network!" };

unsigned char CPhlp[] = {"\
Where commands can be found, format:\n\
\xC8`directory[;directory...]"};

unsigned char MNhlp[] = {"\
See/Edit drive Mounts\n\
\xC8Should be full paths, ie: <drive>:\\..."};
unsigned char

unsigned char EXhlp[] = {"\
Exit and save changes\n\
\xC8To quit with no save, use <ESC>\n\
\xCCIf you want to change settings DBSETUP does not accomodate,\
\xD6you can always edit DOSBOX.INI directly"};

unsigned char *SecHlp[] = {
	"Screen Resolution",		&SRhlp,
	"Video output type",		&VOhlp,
	"Video Scaleing",			&VShlp,
	"CPU core",					&CRhlp,
	"CPU cycles",				&CYhlp,
	"Serial COM1",				&CMhlp,
	"Serial COM2",				&CMhlp,
	"Serial COM3",				&CMhlp,
	"Serial COM4",				&CMhlp,
	"Ethernet NIC",				&ENhlp,
	"Ethernet MAC",				&EMhlp,
	"Command path",				&CPhlp,
	"Mounted Drives",			&MNhlp,
	"Exit",						&EXhlp,
	0 };

#define	MC	0x01
unsigned char *Aexec[] = {
	"@echo OFF",
	"cls",
	"mount C",
	"mount R",
	"mount Y",
	"\x80path C:\\;Y:\\Cmds;Y:\\;Z:\\",
	"\x81path C:\\;Y:\\Cmds;C:\\MC;Y:\\;Z:\\",
	"\x81set MCDIR=C:\\MC",
	"\x81set MCTMP=R:\\$",
	"set TEMP=R:\\",
	"C:",
//	"clrtmp R:\\",
	0 };

#include "R:\\Help.h"

void Pc(unsigned char c)	{	putc(c, fpo);		}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}
void Nl(void)				{	Pc('\n');			}
register Pr(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	Ps(buf);
}

void Wclose(void)
{
	if(!WinA) {
		wclose();
		WinA = 7; }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
	Wclose();
	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

register Printf(unsigned args)
{
	unsigned char buf[256];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
}

// Skip to non-blank
int Skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

unsigned Begins(unsigned char *p)
{
	unsigned i;
	unsigned char c;
//	Skip();
	i = 0;
	while(c = toupper(*p++)) {
		if(toupper(Ptr[i++]) != c)
			return 0; }
	return i;
}

void SegPs(unsigned char *p)
{
	do {
		poke(Seg, Stop, *p);
		if(!++Stop) {
			if((Seg += 4096) > SegE)
				Error("?SegOver\n"); } }
	while(*p++);
}
unsigned SegGs(unsigned char *dst)
{
	unsigned char *p, c;
	p = dst;
	Debug(("{%04x %u %04x %u}", SegE, Stop, Seg, Spos))
a1:	if(Seg >= SegT) {
		Debug(("!"))
		if((Seg != SegT) || (Spos >= Stop))
			return 0; }
	c = peek(Seg, Spos);
	if(!++Spos)
		Seg += 4096;
	if(*p = c) {
		++p;
		goto a1; }
	return 7;
}

void INIread(void)
{
	unsigned i, j;
	fpi  = fopen(DBIN, "rvq");
//	while(ReadLine()) {
	for(;;) {
		if(Apos & 0xF000) {
			if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fpi))
				break;
			if(Begins("##INIT##")) {
				Opt |= O_RESET;
				continue; }
			if(Begins("[AUTOEXEC]") && (Opt & O_RESET)) {
				Apos = 0; } }
		else {
a1:			Debug(("[%u %04x]", Apos, Aexec[Apos]))
			if(!(Ptr = Aexec[Apos++]))
				break;
			if(*Ptr & 0x80) {
				if(*Ptr++ != Iaef)
					goto a1; } }
		++Line;
		Debug(("I%u'%s'\n", Line, Ptr))
		i = 0;
		while(Ptr1 = Sections[i++]) {
			if(j = Begins(Ptr1))
				goto a2; }
		SegPs(Ptr);
		continue;
a2:		Debug(("%u'%s'%u %u-%u\n", Line, Ptr, i, j))
		Ptr += j; Skip(); Trim();
		if(--i < SClast) {
			Debug(("S%u'%s'%s\n", Line, Ptr, Sections[i])) 
			SecLine[i] = Line;
			strcpy(SecTxt[i], Ptr);
			continue; }
		if((j = toupper(*Ptr) - 'A') > ('Y'-'A')) {
			Ps("?ini: ");
			Ps(Buffer);
			Error("\n"); }
		if(!MntLine)
			MntLine = Line;
		++Ptr; Skip();
		Debug(("M%u'%s'%u\n", Line, Ptr, j))
		strcpy(Mounts[j], Ptr);
	}
	fclose(fpi);
	Debug(("MntLine %u\n", MntLine))
}

void INIwrite(Void)
{
	unsigned i;//, j;
	Line = 0;

	for(i=0; i < SClast; ++i) {
		if(!SecLine[i])
			printf("{%u}", i); }

	fpo = fopen(DBOUT, "wvq");
	while(SegGs(Ptr = Buffer)) {
a2:		if(++Line == MntLine) {
			for(i=0; i < ('Z'-'A'); ++i) {
				if(*(Ptr1 = Mounts[i])) {
					Debug(("M%u'%s'%u\n", Line, Ptr1, i))
					Ps("mount ");
					Pc(i+'A');
					Pc(' ');
					Ps(Ptr1);
					++Line;
					Nl(); } } }
		for(i=0; i < SClast; ++i) {
			if(SecLine[i] == Line) {
				Debug(("%u'%s'%u\n", i, SecTxt[i], Line))
				Ps(Sections[i]);
				Ps(SecTxt[i]);
				Nl();
				SecLine[i] = 0;
				goto a2; } }
		Ps(Ptr);
		Nl(); }
#if 0
	for(i=0; i < SClast; ++i) {
		if(j = SecLine[i]) 
			printf("%u'%s'%u\n", i, SecTxt[i], j); }
#endif
}

// Add a string to the pool
unsigned char *Pstring(unsigned char *p)
{
	unsigned t;
	t = Ptop;
	do {
		if(Ptop >= POOL)
			Error("?Pover"); }
	while(Pool[Ptop++] = *p++);
	return Pool+t;
}

void Randomize(void)
{
	unsigned d, mo, y, h, mi, s;
	get_date(&d, &mo, &y);
	get_time(&h, &mi, &s);
	RAND_SEED = (y<<11)^(mo<<8)^(d<<5)
			^	(h<< 9)^(mi<<6)^s;
}

void MntDrv(void)
{
	unsigned i, j, s;
	s = 0;
a1:	for(i = 0; i < ('Z'-'A'); ++i) {
		wgotoxy(0, j=i);
		if(i == s) *W_OPEN = VREV;
		wputc(i+'A');
		wputs(": ");
		wputs(Mounts[i]);
		*W_OPEN = VNOR;
		wcleol(); }
a2:	switch(wgetc()) {
	default	:	goto a2;
	case _KUA:
		if(s) --s;
		goto a1;
	case _KDA:
		if(s < j) ++s;
		goto a1;
	case '\n':
		strcpy(Temp, Ptr = Mounts[s]);
a3:		switch(wgets(3, s, Temp, 64)) {
		case '\n':
			if(*Temp) {
				if(!strbeg(Temp+1, ":\\"))
					goto a3; }
			strcpy(Ptr, Temp);
		} goto a1;
	case 0x1B	:	; }
}

void DBedit(void)
{
	unsigned i, j;
	unsigned char c;

	wopen(WinA = 0, 0, 80, 25, WSAVE|WCOPEN|VNOR);

a0:	wgotoxy(28, 0);
	wputs("-- DosBox Configuration --");
	wgotoxy(70, 0);
	switch(Iaef) {
	case 0x81:	wputs("*MC*");
	}
#ifdef TEST
	wputs("\r*TEST*");
#endif
a1:	if(Msel & 0xF000)		Msel = 0;
	if(Msel > (SClast+1))	Msel = (SClast+1);
	for(i=0; Ptr = SecHlp[i+i]; ++i) {
		wgotoxy(0, i+VOFFSET);
		wcleol();
		if(i == Msel) {
			*W_OPEN = VREV;
			Ptr1 = SecHlp[Msel+Msel+1]; }
		wputs(SecHlp[i+i]);
		if(i < SClast) {
			wgotoxy(30, i+VOFFSET);
			wputs(SecTxt[i]); }
		*W_OPEN = VNOR; }
a9:	wgotoxy(0, i+VOFFSET);
	wcleow();
	wputc('\n');
	Ptop = Itop = 0;
a2:	j = 0;
	while(c = *Ptr1++) {
		if(c & 0x80) {
			if(c & 0x40)		wputc('\n');
			while(c-- &0x3F)	wputc(' ');
			if(j) Pool[Ptop++] = 0;
			goto a2; }
		if(c == '`') {
			Item[Itop++] = Pool+Ptop;
			j = 7;
			continue; }
		if(j)
			Pool[Ptop++] = c;
		wputc(c); }
	Pool[Ptop] = 0;
#if 0
	if(Itop) {
		Wclose();
		for(i=0; i < Itop; ++i)
			printf("`%s`\n", Item[i]);
		exit(0); }
#endif
//wgotoxy(0, 24); wprintf("[%u]", Msel);
	switch(Msel) {
	case 9 :
	case 10:
		wgotoxy(20, 24);
		wputs("*** WINPCAP must be installed on host ***"); }

b1:	switch(wgetc()) {
	case '?':
		if(Msel == 9) {
			system("realnic list");
			Ptr1 = ENhlp1;
			goto a9; }
	default	:	goto b1;
	case _KUA:	--Msel;			goto a1;
	case _KDA:	++Msel;			goto a1;
	case _KHO:
	case _CPU:	Msel = 0;		goto a1;
	case _KEN:
	case _CPD:	Msel = SClast;	goto a1;
	case 0x1B:	;
		Error("?abort\n");
	case '\n':
		wgotoxy(0, 24);
		wcleow(); }

	switch(i-Msel) {
	default	:
		wgotoxy(80-23, 23);//0		  1			2		  3			4
		wputs(				"Enter=accept ESC=Cancel");
		wgotoxy(80-47, 24);//12345678901234567890123456789012345678901234567890
		wputs(				"Left/Right/Home/End/PgUp/PgDn/Ins/Del/Bspc=Edit");
		if(Itop) {
			wgotoxy(80-47-14, 24);
			wputs("Up/Dn=Presets"); }
		Ptr = Ptr1 = SecTxt[Msel];
		j = 255;
b5:		strcpy(Temp, Ptr);
		switch(wgets(30, Msel+VOFFSET, Temp, 64)) {
		case _KUA:	--j;	goto b6;
		case _KDA:	++j;
b6:			if(Itop) {
				if(j & 0x8000)	j = Itop-1;
				if(j >= Itop)	j = 0;
				Ptr = Item[j]; }
			goto b5;
		case '\n':	strcpy(Ptr1, Temp); }
		goto a1;
	case 2	:
		MntDrv();
		wclwin();
		goto a0;
	case 1	:
	case 0	: ; }
	Wclose();
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	fpo = stdout;

	if(fpi = fopen("Y:\\C\\MC\\CC.COM", "rb")) {
		Iaef = 0x81;
		fclose(fpi); }

	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
/*ChtTxt R:\Help.H
DosBoxSETUP

use:	DBSETUP	[options]

opts:	-M		include Micro-C setup
		-I		reset to Initial AutoExec
		-Y		auto Yes (resave)

Allows you to (re)configure the basic setings in DOSBOX.INI

(Run _DBSETUP.BAT to launch a reconfigurable DOSBOX)

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'M':	Iaef ^= 0x01;	break;
			case 'I':	c = O_RESET;	goto o2;
//			case 'R':	c = O_RESET;	goto o2;
			case 'Y':	c = O_YES;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
he:		Ptr = Help;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					Pc(' ');
				continue; }
			Pc(c); }
		return; }

	SegE = (SegS = Seg = alloc_seg(NSEG*4096)) + ((NSEG-1)*4096);
	Debug(("Seg %04x-%04x\n", SegS, SegE))

	INIread();

	if(Opt & O_RESET) {
		if(!(fpi = fopen(HOME, "rv")))
			Error("Please run _DBSETUP.BAT");
		fgets(Buffer, sizeof(Buffer)-1, fpi);
		fclose(fpi);
		Debug(("H'%s", Buffer))
		concat(Mounts['Y'-'A'], Buffer);
		if(i = strlen(Buffer)) {
			if(Buffer[i-1] != '\\') {
				Buffer[i++] = '\\';
				Buffer[i] = 0; } }
		Debug(("'%s'\n", Buffer))
		concat(Mounts['C'-'A'], Buffer, "C");
		concat(Mounts['R'-'A'], Buffer, "Temp");
		for(i=0; Ptr = SecDef[i]; ++i)
			strcpy(SecTxt[i], Ptr);
		Randomize();
		sprintf(SecTxt[10], "AC:DE:48:%02x:%02x:%02x",
			random(255), random(255), random(255)); }

	DBedit();

	if(Opt & O_YES) {
		printf("Resave %s? ", DBOUT);
a1:		switch(toupper(kbget())) {
		default	:	goto a1;
		case 0x1B:
		case 'n':
		case 'N':
			Error("No\n");
		case 'y':
		case 'Y':
			Ps("Yes\n"); } }

	SegT = Seg;
	Seg=SegS; Spos = 0;

	INIwrite();
	fclose(fpo); fpo = stdout;

	concat(Temp, "fct ", DBIN, " ", DBOUT);
	system(Temp);
}
