/*
 * Windows side of Windows Command Interface
 *
 * Compile with LCCwin32
 *
 * Dave Dunfield   -   https://dunfield.themindfactory.com
 */
#include <stdio.h>

#define	SFILE	"$WCMD$.FLG"
#define	CFILE	"$WCMD$.CMD"
#define	EFILE	"$WCMD$.ERR"
#define	RFILE	"$WCMD$."

FILE
	*fp,
	*efp;
unsigned char
	*Ptr,
	*Fptr,
	Home[128],
	Buffer[256];

void Close(void)
{
	if(efp)	{ fclose(efp);	efp = 0; }
	if(fp)	{ fclose(fp);	fp	= 0; }
}

// Report error and terminate
void error(unsigned char *m)
{
	unsigned char c;
	Close();
a1:	switch(c = *m++) {
	default	:	putc(c, stdout);		goto a1;
	case 0x80:	fputs(Home, stdout);	goto a1;
	case 0 :
		fputs("\n\nPress ENTER\n", stdout);
		fgets(Buffer, sizeof(Buffer)-2, stdin);
	case 0xF0:
		exit(-1); }
}

// Remove temporary files
void clean(void)
{
	strcpy(Fptr, CFILE);	remove(Home);
	strcpy(Fptr, SFILE);	remove(Home);
}
// Allow keyboard exit/pause commands
void kbcmd(unsigned char x)
{
	unsigned char m;
	m = 0;
	if(x) goto pr;
	do {
		switch(getch()) {
		case 0x1B:	error("Abort!");
		case ' ' :	m = m ? 0 : 255;
		default: pr:
			printf("DBWCMD: Press ESC to exit, SPACE to %s.\n",
				m ? "continue" : "pause");
	} } while(m);
}

// Skip blanks
int skip(void)
{
	unsigned c;
a1:	switch(*Ptr) {
	case ' ' :
	case '\t': ++Ptr; goto a1;
	case '\n':
	case '\r': *Ptr = 0; }
	return *Ptr;
}

// Compare for beginning string
int xcmp(unsigned char *p, unsigned char *b)
{
	unsigned char c, d;
	while(d = *b++) {
		c = *p++;
		if((c >= 'a') && (c <= 'z'))
			c &= 0x5F;
		if(c != d)
			return 0; }
	return 255;
}

main(int argc, char *argv[])
{
	unsigned e, r;
	unsigned char *p, c, o;

	// Locate R path in DOSBOX.INI
	if(argc > 1)
		strcpy(Fptr = Home, argv[1]);
	else
		strcpy(Fptr = Home, "C:\\DOSBOX");
	while(*Fptr) ++Fptr;
	if(*(Fptr-1) != '\\')
		*Fptr++ = '\\';
	*Fptr = 0;
	printf("DosBox: %s\n", Home);
	strcpy(Fptr, "DOSBOX.INI");
	if(!(fp = fopen(Home, "r")))
		error("Cannot open: \x80");
	o = 255;
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		skip();
		if(xcmp(Ptr, "MOUNT R ")) {
			Ptr += 8;
			skip();
			Fptr = Home;
			o = 0;
			break; } }
	Close(); //fclose(fp);
	if(o)
		error("mount R - not found in \x80");
a1:	switch(c = *Ptr++) {
	default: *Fptr++ = o = c; goto a1;
	case '\t':
	case '\r':
	case '\n':
	case 0 : ; }
	switch(o) {
	default: *Fptr++ = '\\';
	case '\\':
	case ':' : ; }
	*Fptr = 0;

	clean();
	kbcmd(255);
	for(;;) {
		sleep(500);
		if(kbhit())
			kbcmd(0);
		strcpy(Fptr, SFILE);
		if(!(fp = fopen(Home, "r"))) continue;
		Close(); //fclose(fp);
		strcpy(Fptr, CFILE);
		if(!(fp = fopen(Home, "r"))) {
			printf("No CMD file.\n");
			clean();
			continue; }
		strcpy(Fptr, EFILE);
		if(!(efp = fopen(Home, "w")))
			printf("Cannot open EFILE\n");
		r = 0;
		while(fgets(Ptr = p = Buffer, sizeof(Buffer)-1, fp)) {
		ag:	switch(*p) {
			default: ++p; goto ag;
			case '\r' :
			case '\n' :
			case 0 : *p = 0; }
//			o = 0;
			switch(o = *Ptr) {
			default: o = ' ';	break;
			case '+' :
				strcpy(Fptr, RFILE);
				sprintf(p, " >%s%u", Home, r);
			case '-' : ++Ptr; }
			++r;
			printf("'%s'\n", Ptr);
			if(!strcmp(Ptr, "$EXIT$"))
				error("$EXIT$\xF0");
			e = system(Ptr);
			if(efp) fprintf(efp, "%c%u\n", o, e & 0xFFFF);
		}
		//if(efp) fclose(efp);
		//fclose(fp);
		Close();
		clean(); }
}
