// ICHB
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	INIFILE	"Y:\\DOSBOX.INI"
#define	DATFILE	"R:\\INICMT.DAT"
#define	HFILE	"R:\\INICMT.H"

#define	O_ID	0x01
#define	O_PD	0x02
#define	O_DH	0x04

unsigned
	Hsc,
	Enab,
	Inl =7,
	Opos, Tab = 4;
FILE
	*fpi,
	*fpo;
unsigned char
	Opt,
	*Ptr,
	*Ptr1,
	*Optr,
	Ibuf[256],
	Obuf[256],
	Temp[128];

unsigned char *Itxt[] = {
	"This describes the options available in DOSBOX.INI (configuration file)",
	" Config file lines beginning with '#' are ignored (comments)",
	" Lines starting with [name] identify a configuration section!",
	0 };

#include "R:\\Help.h"

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}


void Pc(unsigned char c)
{
	putc(c, fpo);
}
void Ps(unsigned char *p)
{
	while(*p)
		Pc(*p++);
}
void Nl(void)
{
	Pc('\n');
}
void Pss(unsigned char *p)
{
	unsigned sc;
	unsigned char c, e;
	sc = 0;
	e = 0x40;
	while(c = *p++) {
#if 7
		if(c == ' ') {
			++sc;
			continue; }
#endif
		if(sc > Hsc)
			Hsc = sc;
		switch(sc) {
		default	:	Pc(sc|e|0x80);	goto a1;
		case 1	:	Pc(e ? 0xC1 : ' ');
a1:			sc = e = 0;
			break;
		case 0	:
			if(e) {
				if(!Inl)
					Nl(); }
			Inl = e = 0; }
		Pc(c); }
}

//Trim spaces from string
unsigned Trim(void)
{
	unsigned i;
	i = 0;
	while(Ptr[i])					++i;
	while(i && isspace(Ptr[i-1]))	--i;
	Ptr[i] = 0;
	return i;
}

void Xpc(unsigned char c)
{
	switch(c) {
	case '\t':
		do {
			Xpc(' '); }
		while(Opos % Tab);
		return;
	case '\r':
	case '\n':
		Opos = 0;
		break;
	default	:
		++Opos; }
	*Optr++ = c;
}

void Sfile(unsigned char *dst, unsigned char *n, unsigned char *e)
{
	unsigned i, j;
	Debug(("'%s[%x]%s'", Ibuf, *dst, Obuf))
	if(!*dst)
		strcpy(dst, n);

	i = 0;
a1:	j = 0;
a2:	switch(dst[i++]) {
	case ':':
	case'\\':	goto a1;
	case '.':	j = i;
	default	:	goto a2;
	case 0	:	; }
	Debug(("=%x'%s'%u'%s'\n", j, dst, i, e))
	if(!j)
		strcpy(dst+i-1, e);
	Debug(("F%04x'%s'\n", dst, dst))
}

void Oclose(void)
{
	if(fpo != stdout) {
		fclose(fpo);
		fpo = stdout; }
}

void ini2dat(void)
{
	unsigned i;
	unsigned char c;

	Sfile(Ibuf, INIFILE, ".INI");
	Sfile(Obuf, DATFILE, ".DAT");
	Ps("ini2dat ");
	Ps(Ibuf);
	Pc(' ');
	Ps(Obuf);
	Nl();

	fpi = fopen(Ibuf, "rvq");
	fpo = fopen(Obuf, "wbvq");
	i = 0;
	while(Ptr = Itxt[i++])
		Pss(Ptr);
	while(fgets(Ptr = Ibuf, sizeof(Ibuf)-1, fpi)) {
		if(!Enab) {
			if(*Ptr != '[')
				continue;
			Enab = 0x55; }
		if(*Ptr == '[') {
			Ptr1 = Obuf;
			goto a1; }
		if(*Ptr != '#')  {
			if(Enab == 0xAA)
				break;
			continue; }
		switch(Ptr[1]) {
		case '?':
		case '!':	continue; }
		Ptr1 = Obuf+1;
a1:		Trim();
		Optr = Obuf;
		Opos = 0;
		while(c = *Ptr++)
			Xpc(c);
		*Optr = 0;
		Pss(Ptr1);
		if(*Obuf == '[') {
			strupr(Obuf);
			if(strbeg(Obuf, "[AUTOEXEC]"))
				Enab = 0xAA; } }
	Nl();
	Oclose();
	fclose(fpi);
	printf("Hsc=%u\n", Hsc);
}

void printdat(void)
{
	unsigned char c, d;

	Sfile(Ibuf, DATFILE, ".DAT");
	if(*Obuf) {
		Sfile(Temp, Obuf, ".TXT");
		Ps("printdat ");
		Ps(Ibuf);
		Pc(' ');
		Ps(Temp);
		Nl(); }
	fpi = fopen(Ibuf, "rbvq");
	if(*Obuf)
		fpo = fopen(Temp, "wvq");
	d = 0;
	while( (c = getc(fpi)) != EOF) {
		if(c & 0x80) {
			if(c & 0x40)
				Nl();
			while(c-- & 0x3F)
				Pc(' ');
			continue; }
		if((c == '[') && (d == '\n'))
			Nl();
		Pc(d = c); }
	Oclose();
	fclose(fpi);
}

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;

	fpo = stdout;
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:
/*ChtTxt R:\Help.h
IniCmt.H Builder

use:	ICHB	[outfile] [options]

opts:	-D		build r:\inicmt.Dat	from y:\dosbox.ini
		-P		Print r:\inicmt.dat
		-H		build r:\inicmt.H	from r:\inicmt.dat
		-Ifile	set Input file

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'I':
				if(!*Ptr) goto he;
				strcpy(Ibuf, Ptr);
				continue;
			case 'D':	c = O_ID;	goto o2;
			case 'H':	c = O_DH;	goto o2;
			case 'P':	c = O_PD;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(*Obuf)
			goto he;
		strcpy(Obuf, Ptr); }

	switch(Opt & (O_ID|O_PD|O_DH)) {
	case O_ID:
		ini2dat();
//		concat(Ibuf, "hexed ", DATFILE);
//		system(Ibuf);
		return;
	case O_PD:
		printdat();
		return;
	case O_DH:
		Sfile(Ibuf, DATFILE, ".DAT");
		Sfile(Obuf, HFILE, ".H");
		concat(Temp, "bin2c ", Ibuf, " ", Obuf, " N=INItxt");
		Ps(Temp); Nl();
		system(Temp);
		return; }

he:	Ptr = Help;
	while(c = *Ptr++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				Pc(' ');
			continue; }
		Pc(c); }
}
