// SORT
#include <stdio.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	//printf a;
#define	Debug2(a)	printf a;

#define	BSIZE	2048	// Buffer size
#define	DLINE	20480	// Duplicate lines
#define	BITS	8192	// 64k bits(*8)

#define	O_DUP	0x01
#define	O_UPR	0x02
#define	O_VER	0x04

unsigned
	Eseg = 16384,
	Seg, Aseg,
	Spos,
	Low = -1,
	Line,
	Lline,
	Lprog,
	Lmax,
	Dtop,
	Dline[DLINE];
FILE
	*fpi,
	*fpo;
unsigned char
	*Ptr,
	Opt = O_DUP,
	Buffer[BSIZE],
	CmpTXT[BSIZE],
	Bits[BITS];

//ChtTxt R:\Help.h
#include "R:\\Help.h"

#define	Temp	CmpTXT

void SetBit(unsigned b)
{
	Debug1(("{%u}", b))
	Bits[b >> 3] |= 1 << (b & 7);
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	fputs(buf, stdout);
	exit(-1);
}

register Printf(unsigned args)
{
	unsigned i;
	unsigned char buf[256];
	i = nargs();
	if(Opt & O_VER) {
		_format_(i*2+&args, buf);
		fputs(buf, stderr); }
}

void Abort(void)
{
	if(kbtst() == 0x1B)
		Error("?Abort");
}

int Strcmp(unsigned char *str1, unsigned char *str2)
{
	do {
		if(*str1 > *str2)		/* String1 > String2 */
			return 1;
		if(*str1 < *str2++)		/* String1 < String2 */
			return -1; }
	while(*str1++);
	return 0;					/* String 1 == String 2 */
}

unsigned ReadLine1(void)
{
	unsigned H, L;
	if(Aseg >= Eseg)
		Error("?SegOverflow");
	ftell(fpi, &H, &L);
	pokew(Aseg, Spos, L);
	pokew(Aseg, Spos+2, H);
	if(!(Spos += 4))
		Aseg += 4096;
	if(fgets(Buffer, BSIZE-1, fpi)) {
		++Line;
		if(Opt & O_UPR)
			strupr(Buffer);
		return 255; }
	return 0;
}

unsigned ReadLine2(void)
{
	unsigned s, o;
	Debug1(("L%u", Line))
	s = 0;
a1:	if(Line >= Lmax) {
		Debug1(("E1\n"))
		goto a2; }
	if(Bits[Line >> 3] & (1 << (Line & 7))) {
		Debug1(("S"))
		s = ++Line;
		goto a1; }
	if(s) {
		s = ((Line >> 2) & 0xF000) + Seg;
		o = Line << 2;
		fseek(fpi, peekw(s, o+2), peekw(s, o), 0); }
	if(fgets(Buffer, BSIZE-1, fpi)) {
		Debug1(("'%s'\n", Buffer))
		++Line;
		if(Opt & O_UPR)
			strupr(Buffer);
		return 255; }
	Debug1(("E2\n"))
a2:	return 0;
}

#ifdef TEST
	extern unsigned RAND_SEED;
	void GenTest(unsigned n)
	{
		unsigned i, j, k;
		if(!n) n = TEST;
		printf("%u", n);
		i = n >> 1;
		RAND_SEED = peek(0x40, 0x6C);
		fpo = fopen("R:\\TST.TXT", "wvq");
		do {
			fprintf(fpo, "%u\n", j = rand());
			if(n == i)
				fprintf(fpo, "%u\n", k = j); }
		while --n;
		fclose(fpo);
		printf(" %u", k);
	}
	void MemTst(unsigned char x)
	{
		unsigned i, j;
		unsigned char *p, *p1;
		static unsigned char *mp;

		if(x) {
			p1 = &i - 16;
			free(mp = p = malloc(8));
			while(p < p1)
				*p++ = 0xA5;
			return; }

		i = 0;
		p1 = &x;
		printf("Mem: %04x-", mp);
	a1:	j = 0;
		while(mp < p1) {
			if(*mp++ != 0xA5) {
				if(j > i) {
					i = j;
					p = mp; }
				goto a1; }
			++j; }
		printf("%04x %u\n", p, i);
	}
#endif

main(int argc, char *argv[])
{
	unsigned i;
	unsigned char c;
#ifdef TEST
	MemTst(7);
#endif
	i = 0;
	while(++i < argc) {
		if(*(Ptr = argv[i]) == '-') {
			++Ptr;
o1:			switch(toupper(*Ptr++)) {
			default	:	goto he;
#ifdef TEST
			case 'T':
				GenTest(atoi(Ptr));
				return;
#endif
/*ChtTxt Mhelp
SORT file

use:	SORT	infile [outfile] [options]

opts:	-D		remove Duplicate lines
		-M(1-4)	set Memory segments(16k lines per 64k segment)		[4]
		-P		show Progress
		-R		Reverse sort (higher first)
		-U		convert to Upper case
		-V		Verbose - show progress

Sorts a text file, output has the alphabetically lower lines first!

 * I've not spent time optimizing SORT, so it can be slow on large files.
 * it does support up to 64k lines without needing a LOT of RAM.

Dave Dunfield   -   https://dunfield.themindfactory.com
*/
			case 'R':	Low = 1;	break;
			case 'M':	Eseg = atoi(Ptr);
				if((Eseg - 1) > 3)
					goto he;
				Eseg *= 4096;
				continue;
			case 'D':	c = O_DUP;	goto o2;
			case 'U':	c = O_UPR;	goto o2;
			case 'V':	c = O_VER;
o2:				Opt ^= c; }
			if(*Ptr) goto o1;
			continue; }
		if(!*Buffer) {
			strcpy(Buffer, Ptr);
			continue; }
		if(*Temp)
			goto he;
		strcpy(Temp, Ptr); }
	if(!*Buffer) {
he:		Ptr = Mhelp;
		while(c = *Ptr++) {
			if(c & 0x80) {
				while(c-- & 0x7F)
					putc(' ', stdout);
				continue; }
			putc(c, stdout); }
		return; }

	Debug1(("Opt %x\n", Opt))

	Eseg += (Seg = Aseg = alloc_seg(Eseg));

	fpo = stdout;
	fpi = fopen(Buffer, "rvq");
	if(*Temp)
		fpo = fopen(Temp, "wvq");
	while(ReadLine1());
	Printf("0     of %u", Lmax = Line);
	Debug1(("Lmax%u\n", Lmax))
	Aseg = Seg;
a1:	rewind(fpi);
	Lline = Line = 0;
//	memset(CmpTXT, (Low == -1) ? 255 : 0, BSIZE);
	*CmpTXT = (Low == -1) ? 255 : 0;
	Abort();
	while(ReadLine2()) {
		if((i = Strcmp(Buffer, CmpTXT)) == Low) {
			Lline = Line;
			strcpy(CmpTXT, Buffer);
			Dtop = 0; }
		if(!i) {
			if(Dtop >= DLINE)
				Error("?TooManyDupLines");
			Dline[Dtop++] = Line-1; } }
	if(Lline) {
		SetBit(Lline-1);
		Printf("\r%u", ++Lprog);
		fputs(CmpTXT, fpo);
		putc('\n', fpo);
		while(Dtop) {
			if(Opt & O_DUP) {
				fputs(CmpTXT, fpo);
				putc('\n', fpo); }
			SetBit(Dline[--Dtop]); }
		goto a1; }
	if(fpo != stdout)
		fclose(fpo);
	fclose(fpi);
	Printf("\n");
#ifdef TEST
	MemTst(0);
#endif
}
//ChtCmd cc sort -pof TEST=16
