/*
 * TREE command for MS-DOS
 *
 * This command is virtually identical to the original MS-DOS TREE command,
 * except that it expands the current directory path instead of showing '.'
 * in the display.
 *
 * ?COPY.TXT 1995-2003 Dave Dunfield
 * Freely distributable.
 *
 * Compile command: cc tree -fop
 */
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//printf a;
#define	Debug1(a)	printf a;

#define	DIRS		500		// Depth of directory stacking
#define	DEPTH		50		// Depth of scanner recursion

#define	O_FILES		0x01	// Option: show files
#define	O_SIZE		0x02	// "": show sizes
#define	O_TIME		0x04	// "": show timestamps
#define	O_TOTAL		0x08	// "": show totals
#define	O_RECURSE	0x10	// Recurse into subdirs
unsigned
	Sh, Sl, Ti, Da,			// Find* Size/Time
	Lsh, Lsl, Lti, Lda,		// Littlest "" in directory
	Bsh, Bsl, Bti, Bda,		// Biggest  "" in directory
	BSh, BSl, BTi, BDa,		// Biggest  "" in all
	Tsh, Tsl,				// Total size
	Fcount,					// File count
	Dirptr,					// Directory stacking level
	Level;					// Function recursion level
unsigned char
	Opt = O_RECURSE,					// Command options
	Home[128],				// Home directory
	Path[128],				// Final path specification
	Match[128],
	Dirstack[DIRS][13],		// Stack of directory names
	*Actstack[DEPTH];		// Stack of active levels

extern unsigned
	Longreg[2];

unsigned
	LSh = -1,				// Littlest Size in all
	LSl = -1, 				// ""
	LTi = -1,				// Lowest Timestamp in all
	LDa = -1,				// ""
	L10[]	= { 10, 0 };
unsigned char
	*Vline	= "\xB3\x20\x20",	/* Vertical line */
	*Vtee	= "\xC3\xC4\xC4",	/* Vertical/Horizonal tee */
	*Corn	= "\xC0\xC4\xC4",	/* Vertical/Horizontal corner */
	*Hline	= "\xC4\xC4\xC4";	/* Horisontal line */

#include "R:\\Help.h"

void Pc(unsigned char c)	{	putc(c, stdout);	}
void Ps(unsigned char *p)	{	while(*p) Pc(*p++);	}

// Retuwn to Home directory
void GoHome(void)
{
	if(*Home) {
		set_drive(*Home - 'A');
		cd(Home);
		*Home = 0; }
}

//Print error message and terminate
register Error(unsigned args)
{
	unsigned char buf[200];
	_format_(nargs()*2+&args, buf);
//	if(Line) printf("%u: ", Line);
	Ps(buf);
	exit(-1);
}

// Show Long Number
#define LJ	"%-12s"	// Left  Justified
#define	RJ	"%12s"	// Right Justified
void ShowLN(unsigned h, unsigned l, unsigned char *fmt)
{
	unsigned i, lv[2];
	unsigned char buf[13];
	buf[i = sizeof(buf)-1] = 0;
	lv[1] = h;
	*lv = l;
	do {
		longdiv(lv, L10);
		buf[--i] = *Longreg + '0'; }
	while longtst(lv);
	printf(fmt, buf+i);
}

// Show Date and Time
void ShowDT(unsigned da, unsigned ti)
{
	printf("%04u-%02u-%02u",	(da>>9)+1980,	(da>>5)&15,		da&31);
	printf("%3u:%02u:%02u",		ti>>11, 		(ti>>5)&63,		(ti&31)*2);
}

// Print "<>" separater
void Plb(void)
{
	Ps("<>");
}

/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

//	Debug(printf("Match '%s'", name));
//	Debug(printf(" '%s'\n", pattern));

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;	// ?!*name
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}


/*
 * Handle a single directory, recurse to do others
 */
void tree_path(void)
{
	unsigned plen, dirbase, i, j, attrs;
	unsigned char name[13], *p;

	/* Get all sibdirectory names in this dir */
	dirbase = Dirptr;

	plen = strlen(Path);
	strcpy(Path+plen, "*.*");
	if(Opt & O_RECURSE) {
		if(!find_first(Path, -1, name, &Sh, &Sl, &attrs, &Ti, &Da)) do {
			if((attrs & DIRECTORY) && (*name != '.')) {
				strcpy(Dirstack[Dirptr++], name);
				continue; } }
		while(!find_next(name, &Sh, &Sl, &attrs, &Ti, &Da)); }

	/* Display files in this dir if required */
	Actstack[Level++] = (dirbase == Dirptr) ? "   " : Vline;
	if(Opt & (O_FILES|O_SIZE|O_TIME|O_TOTAL)) {
		Bsh = Bsl = Bti = Bda = i = 0;
		Lsh = Lsl = Lti = Lda = 	-1;
		if(!find_first(Path, -1, name, &Sh, &Sl, &attrs, &Ti, &Da))  do {
			if(attrs & (DIRECTORY|VOLUME))
				continue;
			if(!Fmatch(name, Match))
				continue;
			if(Opt & O_FILES) {
				for(j=0; j < Level; ++j)
					Ps(Actstack[j]);
				printf("%s\n", name); }
			Tsh += Sh;
			j = Tsl;
			if((Tsl += Sl) < j)
				++Tsh;
			if(Sh >= Bsh) {
				if((Sh != Bsh) || (Sl > Bsl)) {
					Bsh = Sh;
					Bsl = Sl; } }
			if(Sh <= Lsh) {
				if((Sh != Lsh) || (Sl < Lsl)) {
					Lsh = Sh;
					Lsl = Sl; } }
			if(Da >= Bda) {
				if((Da != Bda) || (Ti > Bti)) {
					Bda = Da;
					Bti = Ti; } }
			if(Da <= Lda) {
				if((Da != Lda) || (Ti < Lti)) {
					Lda = Da;
					Lti = Ti; } }
			++Fcount;
			i = -1; }
		while(!find_next(name, &Sh, &Sl, &attrs, &Ti, &Da));
		if(i) {
			for(j=0; j < Level; ++j)
				Ps(Actstack[j]);
			if(Opt & O_SIZE) {
				ShowLN(Lsh, Lsl, RJ);
				Plb();
				ShowLN(Bsh, Bsl, LJ); }
			if(Opt & O_TIME) {
				ShowDT(Lda, Lti);
				Plb();
				ShowDT(Bda, Bti); }
			if(Bsh >= BSh) {
				if((Bsh != BSh) || (Bsl > BSl)) {
					BSh = Bsh;
					BSl = Bsl; } }
			if(Lsh <= LSh) {
				if((Lsh != LSh) || (Lsl < LSl)) {
					LSh = Lsh;
					LSl = Lsl; } }
			if(Bda >= BDa) {
				if((Bda != BDa) || (Bti > BTi)) {
					BDa = Bda;
					BTi = Bti; } }
			if(Lda <= LDa) {
				if((Lda != LDa) || (Lti < LTi)) {
					LDa = Lda;
					LTi = Lti; } }
			Pc('\n'); } }

	/* Report of no subdirectories exist */
	if((dirbase == Dirptr) && (Level == 1) && (Opt & O_RECURSE))
		printf("No sub-directories exist\n");

	/* Recurse into subdirectories */
	for(i=dirbase; i < Dirptr; ++i) {
		Actstack[Level-1] = ((i+1) != Dirptr) ? Vtee : Corn;
		for(j=0; j < Level; ++j)
			Ps(Actstack[j]);
		Actstack[Level-1] = ((i+1) != Dirptr) ? Vline : "   ";
		printf("%s\n", p = Dirstack[i]);
		strcpy(Path+plen, p);
		strcat(Path, "\\");
		tree_path(); }

	/* Restore entry conditions and exit */
	Path[plen] = 0;
	Dirptr = dirbase;
	--Level;
}

/*
 * Main program - parse arguments & start recursive procedure
 */
main(int argc, char *argv[])
{
	unsigned i;
	unsigned char *p, c;

	i = 0;
	while(++i < argc) {
		switch(*(p = argv[i])) {
		case '?':	goto he;
		case '-':
		case '/':	++p;
o1:			switch(toupper(*p++)) {
			default	:
he:				p = Help;
				while(c = *p++) {
					if(c & 0x80) {
						while(c-- & 0x7F)
							Pc(' ');
						continue; }
					Pc(c); }
			return;
/*ChtTxt R:\Help.h
Graphically displays the directory structure of a drive or path.

use:	TREE [A-Z:][path][\spec] [options]

opts:	/A		use ASCII instead of extended characters
		/F		displays names of Files in each directory
		/O		show tOtals at end
		/R		don't Recurse into subdirs
		/S		show smallest<>largest file Sizes
		/T		show   oldest<>newest  file Timestamps

If only A-Z: - TREE shows from root, use: A-Z:. for current
	  spec	 - must contain '*?' wildcards

1995-2003 Dave Dunfield  -  https://dunfield.themindfactory.com
									Freely distributable
*/
			case 'A' :		/* Ascii - switch BOX characters */
				Vline = "|  ";
				Vtee  = "+--";
				Corn  = "\\--";
				Hline = "---";
				break;
			case 'F':	c = O_FILES;	goto o2;
			case 'O':	c = O_TOTAL;	goto o2;
			case 'R':	c = O_RECURSE;	goto o2;
			case 'S':	c = O_SIZE;		goto o2;
			case 'T':	c = O_TIME;
o2:				Opt ^= c; }
			if(*p) goto o1;
			continue; }
		if(*Path)
			goto he;
		strcpy(Path, p); }

	strcpy(Home, "::\\");
	*Home = get_drive() + 'A';
	getdir(Home+3);
	Debug(("H'%s\n", Home))

	*Match = '*';
	if(*Path) {
		p = (Path[1] == ':') ? Path+2 : Path;
//		if(*p == '\\') ++p;
		switch(*p) {
		case 0	:	strcpy(p, "\\");
		case'\\':	++p; }
		Sh = i = c = 0;
a1:		switch(p[i++]) {
		case ':':
		case'\\':	Sh = i;
		default	:	goto a1;
		case '?':
		case '*':	c = 7;
		case 0	:	; }
		if(c) {
			strcpy(Match, p+Sh);
			strupr(Match);
			if(Sh) --Sh;
			p[Sh] = 0; }
		Debug1(("P'%s'%s'\n", Path, Match))
		if(Path[1] == ':') {
			set_drive(c = toupper(*Path) - 'A');
			if(get_drive() != c)
				goto e1; }
		if(*Path && cd(Path)) {
e1:			Error("Cannnot access: %s", Path); } }

	strcpy(Path, "::\\");
	*Path = get_drive() + 'A';
	getdir(Path+3);
	GoHome();

	/* Display volume label of disk */
	printf("Directory PATH listing");
	strcpy(Help, "::\\*.*");
	*Help = *Path;
	if(!find_first(Help, VOLUME, p = Help, &i, &i, &i, &i, &i))  {
		printf(" for volume ");
		while(c = *p++)
			if(c != '.')
				Pc(c); }

	/* Display path and append backslash if not given */
	printf("\n%s\n", Path);
	switch(Path[strlen(Path)-1]) {
		default:
			strcat(Path, "\\");
		case ':' :
		case '\\' : }

	/* Perform recursive function */
	tree_path();

	if((Opt & O_TOTAL) && Fcount) {
		printf("=%u", Fcount);
		if(Opt & O_SIZE) {
			Pc(' ');
			ShowLN(Tsh, Tsl, "%s ");
			ShowLN(LSh, LSl, RJ);
			Plb();
			ShowLN(BSh, BSl, "%s"); }
		if(Opt & O_TIME) {
			Pc(' ');
			ShowDT(LDa, LTi);
			Plb();
			ShowDT(BDa, Bti); }
		Pc('\n'); }
}
