#include <stdio.h>
#include <window.h>

#define	HEIGHT	24
#define	WIDTH	80

#define	VNORM	0x17	// Normal
#define	VHIL1	0x21	// Lookup
#define	VHIL2	0x24	// Unprintable
#define	VHIL3	0x31	// Selected
#define	VATTN	0x71	// Special notes

unsigned
	Seg0,			// ExtSegment0 - Low offsets
	Seg1,			// ExtSegment1 - High offsets
	Stop,			// Top of ""s
	Select = 255,	// Select mode not active
	Column,			// Current column on screen
	Cpos,			// Position in column
	Cend,			// Colum position of end of screen
	Tab = 4,		// Tab width
	Hcol,			// Colum for Hilite
	Hlen,			// Hilite length
	Hpos,			// Position for hilite
	Line[2],		// Line at top of screen
	Fline[2],		// Last find line
	Hline[2],		// Line for hilite
	Slow[2],		// Select range low
	Shigh[2],		// Select range high
	MaxLine[2];		// Maximum Line
FILE
	*fp;
struct WINDOW
	*Swin,			// Status window
	*Mwin;			// Main window
unsigned char
	*Ptr,
	*Stext,			// Status line text
	*FNtext,		// Points to file name
	Hdisp = 255,	// Help display is not active
	Wider,			// Screen still has wider data
	Sopt,			// Search options
	Tchar,			// Temp char variable
	Buffer[256],	// General buffer
	Temp[128],		// Temp""
	Ftext[60];		// Search text
unsigned
	L1[2]		=	{ 1,			0 },
	Lheight[2]	=	{ HEIGHT-1,		0 };

#include "R:\\help.h"

// Search options
#define	S_CASE	0x01	// Case insensitive
#define	S_SOL	0x02	// At start of line
#define	S_EOL	0x04	// At end of line

//Print error message and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
	exit(-1);
}

// Skip to non-blank
int skip(void)
{
	while(isspace(*Ptr))
		++Ptr;
	return *Ptr;
}
void Send(void) {	w_cleow(Swin); }
register Sprintf(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	w_puts(buf, Swin);
}

// Display help text
void help(unsigned char *p, int of)
{
	unsigned char c;
	while(c = *p++) {
		if(c & 0x80) {			while(c-- & 0x7F) {
				if(of)
					wputc(' ');
				else
					putc(' ', stdout); }
			continue; }
		if(of)
			wputc(c);
		else
			putc(c, stdout); }
}

void GoLine(unsigned char *ln)
{
	unsigned so, h, l;
//ltoa(ln, Temp, 10); printf("[%s]%04x%04x ", Temp, *(unsigned*)(ln+2), *(unsigned*)ln);
	longcpy(Line, ln);
//	longadd(Line, L1);
	so = *(unsigned*)(ln+1);
//printf(" %5u ", so);
	if(!so) {
//printf("----- ");
		h = l = 0; }
	else {
		so = (so - 1) *2;
		if(so >= Stop)
			error("?seg too high %u", so);
//printf("%5u ", so);
		l = peekw(Seg0, so);
		h = peekw(Seg1, so); }
//printf("%04x%04x(%u)", h, l, *ln);
	if(fseek(fp, h, l, 0))
		error("?fseek");
#if 255
	so = *ln;
	while(so) {
		if(!fgets(Buffer, sizeof(Buffer)-1, fp))
			error("?eof");
		--so; }
#else
	so = *ln+1;
	do {
		if(!fgets(Buffer, sizeof(Buffer)-1, fp))
			error("?eof"); }
	while(--so);
	ltoa(Line, Temp, 10);
	printf("%s:", Temp);
	fputs(Buffer, stdout);
	putc('\n', stdout);
	for(so=0; so < 5; ++so) {
		fgets(Buffer, sizeof(Buffer)-1, fp);
		printf(" %s\n", Buffer); }
#endif
}

int Oc(unsigned char c)
{
	int r;
	unsigned char vn;
	if(Cpos >= Cend)
		return 15;
	if((c < ' ') || (c > 0x7E)) switch(c) {
		case  0 : return 255;
		default :	// Unprintable
			vn = *Mwin;
			*Mwin = VHIL2;
			if(c < ' ') {
				r = Oc(c+'@');
				goto rr1; }
			if((r = c>>4) > 9)		r += ('A'-'0'-10);
			if(r = Oc(r+'0'))		goto rr1;
			if((r = c & 15) > 9)	r += ('A'-'0'-10);
			r = Oc(r+'0');
	rr1:	*Mwin = vn;
	rr:		return r;
		case'\t':	// Tab
			do {
				if(r = Oc(' '))
					goto rr; }
			while(Cpos % Tab);
			goto rz;
		case ' ': ; }
	if(Cpos++ >= Column)
		wputc(c);
rz:	return 0;
}
void redraw(void)
{
	unsigned i, lh, l[2], ln[2];
	unsigned char va;
	unsigned char d;

	longcpy(l, MaxLine);
	if(longsub(l, Lheight))
		longset(l, 0);
	if(longcmp(l, Line) & 0xFF00)
		longcpy(Line, l);
	d = 0; GoLine(Line);
	if(Stext) {
		w_clwin(Swin);
		w_puts(Stext, Swin);
		Stext = 0; }
	else {
		longcpy(l, Line);
		longadd(l, L1);
		ltoa(l, Temp, 10);
		Sprintf("\r%-7s%3u%3u", Temp, Column+1, Tab);
		if(!Select) {
			ltoa(Slow, Temp, 10);
			ltoa(Shigh, Temp+20, 10);
//			Sprintf("[%-7s-%7s]", Temp, Temp+20); }
			Sprintf(" [%s-%s]", Temp, Temp+20); }
		w_puts(" : ", Swin);
		w_puts(FNtext, Swin);
		Send(); }
	longcpy(ln, Line);
	for(Wider = i = 0; i < HEIGHT; ++i) {
		wgotoxy(Cpos = Hpos = 0, i);
		va = VNORM;
		if(!Select) {
			if(!(longcmp(ln, Slow) & 0x8000)) {	// Line >= Sline-Slow
				if(!(longcmp(Shigh, ln) & 0x8000))	// Line <= Sline+Shigh
					va = VHIL3; } }
		*Mwin = va;
		if(d) {
eof:		if(!(d & 0xF0)) {
				d = 255;
				*Mwin = VATTN;
				wputs("[EOF]");
				*Mwin = va; }
			wcleol();
			continue; }
		if(!fgets(Ptr = Buffer, sizeof(Buffer)-1, fp))
			goto eof;
		if(!++*ln)
			++ln[1];
		lh = longcmp(ln, Hline) ? 0 : -1;
		Cend = Column+WIDTH;
a1:		if(lh) {
			if(lh & 0x8000) {
				if(Hpos++ >= Hcol) {
					*Mwin = VHIL1;
					lh = Hlen; } }
			else if(!--lh)
				*Mwin = va; }
		switch(Oc(*Ptr++)) {
		case 0 : goto a1;				// Normal character
		case 15: Wider = 255; break;	// Beyond screen
		default: wcleol();	} }			// 0(End of text)
	*Mwin = VNORM;
}
// Prompt for and get string
int getstring(unsigned char *prompt, unsigned char *dest, unsigned len)
{
	unsigned i;
	unsigned char ha, buf[80];
	strcpy(buf, dest);
	ha = 0;
a1:	W_OPEN = Swin;
	wclwin();
	wputs(prompt);
	switch(i = wgets(Swin->WINcurx, 0, buf, len)) {
	case _K1:
		W_OPEN = Mwin;
		wclwin();
		help(GShelp, 255);
		ha = 255;
		goto a1; }
	if(ha) redraw();
	if(i == '\n')
		strcpy(dest, buf);
	W_OPEN = Mwin; wcursor_off();
	return i;
}
int BegCS(str1, str2) asm
{
		MOV		DI,6[BP]		// str1
		MOV		SI,4[BP]		// str2
bs1:	MOV		AH,[SI]
		MOV		AL,[DI]
		AND		AH,AH
		JZ		bs2
		INC		SI
		INC		DI
		CMP		AH,AL
		JZ		bs1
		XOR		AX,AX
		POP		BP
		RET
bs2:	MOV		DGRP:_Tchar,AL
		MOV		AL,255
}
int BegCI(str1, str2) asm
{
		MOV		DI,6[BP]		// str1
		MOV		SI,4[BP]		// str2
bi1:	MOV		AH,[SI]
		MOV		AL,[DI]
		AND		AH,AH
		JZ		bs2
		INC		SI
		INC		DI
		CMP		AL,'a'
		JB		bi2
		CMP		AL,'z'
		JA		bi2
		AND		AL,0DFh
bi2:	CMP		AH,AL
		JZ		bi1
		XOR		AX,AX
		POP		BP
		RET
}
// Perform a search
void search(void)
{
	int *cfp;
	unsigned l[2], l1[2];
	unsigned char x, sol;

	Sprintf("\rLooking:%s", Ftext); Send();
	if(!*Ftext)
		return;
	cfp = (Sopt & S_CASE) ? &BegCI : &BegCS;
	longcpy(l, Line);
	GoLine(Fline);
	while(fgets(Ptr = Buffer, sizeof(Buffer)-1, fp)) {
		if(!++*Fline)
			++Fline[1];
		sol = Sopt & S_SOL;
		while(*Ptr && --sol) {
			if((*cfp)(Ptr, Ftext)) {
				if((Sopt & S_EOL) && Tchar)	goto sn;
				longcpy(Line, l);	// Assume on same screen
				longcpy(Hline, Fline);
				Hcol = Ptr - Buffer;
				Hlen = strlen(Ftext);
				ltoa(Fline, Temp+100, 10);
				sprintf(Temp, "Found at: %s", Temp+100);
				Stext = Temp;
				longcpy(l, Fline);
				longsub(l, L1);
				if(longcmp(l, Line) & 0xF000)
					goto a1;
				longcpy(l1, Line);
				longadd(l1, Lheight);
				if(longcmp(l1, l) & 0xF000) {
a1:					longcpy(Line, l); }
				return; }
sn:			++Ptr; }
		if(!--x) {
			if(wtstc() == 0x1B) {
				Stext = "Aborted!";
				goto x1; } } }
	Stext = "Not found!";
x1:	longcpy(Line, l);
	*Hline = Hline[1] = 0xFFFF;
}
void Wselect(void)
{
	unsigned l[2];
	FILE *fpo;

	if(Select) {
		Stext = "No lines selected";
		return; }
	*Temp = 0;
	if(getstring("File?", Temp, 64) != '\n')
		return;
	w_clwin(Swin); w_puts("Writing: ", Swin); w_puts(Temp, Swin);
	if(!(fpo = fopen(Temp, "w"))) {
		sprintf(Stext = Buffer, "Can't access: %s", Temp);
		return; }
	longcpy(l, Line);
	GoLine(Slow);
	while(longcmp(Line, Shigh) <= 0) {
		if(!fgets(Buffer, sizeof(Buffer)-1, fp))
			break;
		if(!++*Line)
			++Line[1];
		fputs(Buffer, fpo);
		putc('\n', fpo); }
	fclose(fpo);
	longcpy(Line, l);
}
/*ChtTxt R:\\Help
View Large Text files:

use: VLT filename [starting line]

VLT can view VERY large text files (8 million lines).

Large files can take a little while to index, however once you are at the
interactive screen, movement around the file should be very fast.

Use '?' interactive key for help.

?COPY.TXT 2020 Dave Dunfield.
*/
main(int argc, char *argv[])
{
	unsigned i, j, l[2];

	for(i=1; i < argc; ++i) {
		switch(*(Ptr = argv[i])) {
		case '-':
		case '/':
			if(Tab = atoi(Ptr+1) & 63) continue;
		case '?': goto he;
		default : ; }
		if(!Stext) {
			Stext = Ptr;
			continue; }
		if(!longtst(Line)) {
			atol(Ptr, Line, 10);
			longsub(Line, L1);
			continue; }
		he:	help(Help, 0);
			return; }
	if(!(Ptr = FNtext = Stext)) goto he;
	i = strlen(Ptr); j = 0;
a0:	if((i - j) > 50) switch(Ptr[j++]) {
		case ':':
		case'\\': FNtext = Ptr+j;
		default : goto a0;
		case 0  : ; }

	Seg1 = (Seg0 = alloc_seg(8192)) + 4096;
//	Ptr = "R:\\BIG";
//	Ptr = "R:\\A.C";
//	Ptr = "R:\\A";
	fp = fopen(Stext, "rvq");
	printf("Indexing: %s", Stext);
	while(fgets(Buffer, sizeof(Buffer)-1, fp)) {
		if(!++*MaxLine) {
			if(++MaxLine[1] > 255) { tml:
				error("?too many lines"); } }
		if(!(*MaxLine & 255)) {
			if(ftell(fp, &i, &j))
				error("?ftell");
			pokew(Seg0, Stop, j);
			pokew(Seg1, Stop, i);
			if(!(Stop += 2))
				goto tml; } }
	ltoa(MaxLine, Buffer, 10);
	printf(" L=%s Seg=%u\n", Buffer, Stop);

	Swin = wopen(0, 0, WIDTH,		1, WSAVE|WCOPEN|0x70);
	Mwin = wopen(0, 1, WIDTH,  HEIGHT, WSAVE|WCOPEN|VNORM);
	wcursor_off();
a1:	if(Line[1] == 0xFFFF)	longset(Line, 0);
	if(Column & 0xFC00)		Column = 0;
	redraw();	Hdisp = 255;
/*ChtTxt Ihelp
VLT Interactive commands:

	  		- move around file
	PgUp/PgDn	- Move one screen
	  Home		- Move to colume 0
	  ^^		- Move column side to size in 25 line increments
   ^PgUp/^PgDn	- Move to 1st/last line
	   F1		- Go to line number (+/- means adjust current)
		 Press F1 during string entry for more help
	   F2		- Search for text from beginning of file
	   F3		- Search for text from top of screen
	   F4		- Continue last search
	   F5		- Select lines (Start to End)
		 if no lines selected, Start and End are set to top of screen
		 if TOS == Start, all lines are deselected
		 if TOS <  Start, Start is set to TOS
		 if TOS >  End, End is set to TOS
		 if TOS>Start & TOS<End, End=End+1 ; (good selecting last screen)
	   F6		- Go to Start of selected lines
	   F7		- Go to  End  of selected lines
	   F9		- Write selected lines to file
	   Tab		- Cycle 1/2/4/8/16 tab stops
	   ESC		- Exit
*/
a2:	if(Stext) goto a1;
	switch(wgetc()) {
	default:
		if(!Hdisp) goto a1;
		goto a2;
	case _KUA:	j = 1;	sj:	longset(l, j);	longsub(Line, l);	goto a1;
	case _KDA:	j = 1;	aj: longset(l, j);	longadd(Line, l);	goto a1;
	case _KRA:	j = 1;	rj:	if(Wider) Column += j;				goto a1;
	case _KLA:	j = 1;	lj:	Column -= j;						goto a1;
	case _KPU:	j = HEIGHT-1;			goto sj;
	case _KPD:	j = HEIGHT-1;			goto aj;
	case _KHO:	Column = 0;				goto a1;
	case _CRA:	j = 25;	goto rj;
	case _CLA:	j = 25;	goto lj;
	case _CPU:	longset(Line, 0);		goto a1;
	case _CPD:	*Line=Line[1]=0xFFFE;	goto a1;
	case _K1:		// Goto line
		*Buffer = 0;
		if(getstring("Line?", Ptr=Buffer, 64) == '\n') {
			switch(j=skip()) {
			case '+' :
			case '-' : ++Ptr; skip(); }
			atol(Ptr, l, 10);
			if(longtst(l)) {
				switch(j) {
				case '+': longadd(Line, l);	goto a1;
				case '-': longsub(Line, l);	goto a1;
				default	: longcpy(Line, l); }
				longsub(Line, L1); } }
		goto a1;
	case _K2 :		// Search
		longset(Fline, 0);
		goto f1;
	case _K3:		// Search from top of screem
		longcpy(Fline, Line);
	f1:	*(Ptr = Temp) = '[';
		if(Sopt & S_SOL)	*++Ptr = '<';
		if(Sopt & S_EOL)	*++Ptr = '>';
		strcpy(Ptr+1, (Sopt & S_CASE) ? "CI" : "CS");
		strcpy(Ptr+3, "]Search?");
/*ChtTxt GShelp
VLT String Entry:

	  		- Position cursor
   Bkspace		- Backup cursor & delete
	 Del		- Delete character under cursor
	 Ins		- Toggle INSERT/OVERWRITE
	Home		- Position cursor at start of string
	 End		- Position cursor at end of string
	PgUp		- Clear entire field
	PgDn		- Clear from cursor to end of field
	Enter		- Accept string
	 F2			- [Search] Toggle Case sensitividy
	 F3			- [Search] Toggle "must be at start of line"
	 F4			- [Search] Toggle "must be at  end  of line"
	 ESC		- Cancel entry
*/
		switch(getstring(Temp, Ftext, sizeof(Ftext)-1)) {
		case _K2 : Sopt ^= S_CASE;	goto f1;
		case _K3 : i = S_SOL;		goto f2;
		case _K4 : i = S_EOL;		f2:
			j = Sopt & i;
			Sopt &= ~(S_SOL|S_EOL);
			if(!j) Sopt |= i;
		default:	goto f1;
		case 0x1B:	goto a1;
		case '\n' : if(Sopt & S_CASE)	strupr(Ftext); }
	case _K4:		// Search again
		search();
		goto a1;
	case _K5:		// Select
		if(Select) {
			Select = 0;
			longcpy(Slow, Line);
			goto a3; }
		if(!(i = longcmp(Line, Slow))) {
			Select = 255;
			goto a1; }
///		if(longcmp(Line, Slow) < 0) {
		if(i & 0x8000) {
			longcpy(Slow, Line);
			goto a1; }
		if(longcmp(Line, Shigh) > 0) {
a3:			longcpy(Shigh, Line);
			goto a1; }
		if(longcmp(Shigh, MaxLine) < 0)
			longadd(Shigh, L1);
		goto a1;
	case _K6 :	longcpy(Line, Slow);	goto a1;
	case _K7 :	longcpy(Line, Shigh);	goto a1;
	case _K9 :	Wselect();				goto a1;
	case '?' :
		wclwin();
		help(Ihelp, 255);
		Hdisp = 0;
		goto a2;
	case '\t': if((Tab <<= 1) > 16) Tab = 1;	goto a1;
	case 0x1B:
		if(!Hdisp) goto a1; }
	wclose();
	wclose();
	fclose(fp);
}
