/*
 * DosBox side of Windows Command Interface
 * - lets you run windows commands from within DosBox
 * - Handy to copy/move without losing windows long filenames or timestamps
 *
 * Makes use of temporary files (defined below):
 *	CFILE	= Created by DosBox with command(s) to be performed under windows.
 *			  Commands can begin with '+' or '-'
 *				+ = Redirect output of commands to file
 *				- = Basically ignored but copied to EFILE
 *	SFILE	= Status/Flag file - created by DosBox when CFILE is ready.
 *			  Deleted on windows side when they have been performed.
 *	EFILE	= Created by windows with the error (result) codes from each
 *			  Command execution. Preceeded by '+', '-' or ' '.
 *				+ = Output redirect file exists
 *				- = No meaning other that '-' preceeded command.
 *			  ' ' = No special flags on this file.
 *	RFILE	= Output redirect file(s) - created by WINDOWS
 *			  This is a prefix, actual filenames are postpended with a number
 *			  which represents the commands position in CFILE (0=1st command)
 */
// Note: R: ramdrive is shared/exists in both Windows and DosBox
#define	SFILE	"$WCMD$.FLG"
#define	CFILE	"$WCMD$.CMD"
#define	EFILE	"$WCMD$.ERR"
#define	RFILE	"$WCMD$."	// Gets a numeric extension

// If stdio has NOT already been included, assume you are compiling as a
// functonal demo program.
// If stdio HAS been included, include only the source necessary to implement
// The interface
#ifndef FILE
	#define	DEMO_MODE
	#include <stdio.h>

	unsigned
		Wait;
	FILE
		*fp,
		*efp;
	unsigned char
		*Ptr,
		*Fptr,
		Test,
		File[128],
		Buffer[256],
		Temp[128],
		Temp1[128];
/*ChtTxt R:\Help.h
use:	WCMD [command] [options]

opts:	/T		- Test mode, show commands without passing to windows
		M=mc	- specify time to Wait			[1000/5000]
		/=text	- Pass text as part of command	(useful for /T M= etc).

If [command] not given WCMD enters an interactive session, prompting for
commands, and displaying stdout results. Use 'quit', 'exit' or ^Z to stop.

Special sequences in commands:
	@Wfile	- resolves to full Windows path to file
	@Dfile	- resolves to full Dosbox  path to file
	@@		- insert a single '@' in command

Dave Dunfield   -   https://dunfield.themindfactory.com
       Download and see my product CATALOG.
*/
#include "R:\\Help.h"

#define	TMPFILE	"$MNT$.TMP"

unsigned
	Dpos,					// DosBox directory/file position
unsigned char
	Ddir[128],				// Resolved DosBox directory/file
	Wdir[128];				// Resolved windows directory/file

// Report error and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	fputs(buf, stdout);
	exit(-1);
}

// Add a string to directory name
void Dadd(unsigned char *p)
{
	while(*p)
		Ddir[Dpos++] = *p++;
}
// Insure dir string ends with '\\'
void Ds(void)
{
	if(Ddir[Dpos-1] != '\\')
		Ddir[Dpos++] = '\\';
}

//0000000000111111111122222222223333333333
//0123456789012345678901234567890123456789
//Drive C is mounted as local directory C:\DosBox\C\

// Resolve a filename to a full path
void resolve(unsigned char *s)
{
	unsigned i;
	FILE *fp;
	unsigned char c, d, e, *p, Temp[128];

	strcpy(Fptr, TMPFILE);
//				  01234567
	strcpy(Temp, "mount >");
	strcpy(Temp+7, File);
	system(Temp);
	Dpos = 0;
	d = e = get_drive();
	if(s[1] == ':') {
		d = toupper(*s);
		if((d < 'A') || (d > 'Z'))
			error("?Drive?");
		set_drive(d -= 'A');
		if(get_drive() != d)
			error("?driveNF");
		s += 2; }
	Ddir[Dpos++] = d + 'A';
	Ddir[Dpos++] = ':';

	fp = fopen(File, "rvq");
	while(fgets(p = Temp, sizeof(Temp)-1, fp)) {
		if(!strbeg(Temp, "Drive "))		continue;
		if(!strbeg(Temp+22, "local "))	continue;
		if((Temp[6]-'A') == d) {
			strcpy(Wdir, Temp+38);
			break; }
	} fclose(fp);
	delete(File);

	Ds();
	if(*s != '\\') {
		if(getdir(Temp)) error("?getdir");
		Dadd(Temp);
		Ds(); }
a1:	i = 0;
a2:	switch(c = *s++) {
	default:
		Temp[i++] = c;
		goto a2;
	case '\\' :
		if(!i) goto a2;
	case 0 :
		Temp[i] = 0;
		if(!strcmp(Temp, ".")) 	goto a1;		// Ignore
		if(!strcmp(Temp, "..")) {
a3:			if(!--Dpos) error("?Dpos1");
			if(Ddir[Dpos-1] != '\\') goto a3;
			goto a1; } }
	Dadd(Temp);
	if(c) {
		Ds();
		goto a1; }
	Ddir[Dpos] = 0;
	p = Wdir; while(*p) ++p;
	if(*(p-1) == '\\') --p;
	strcpy(p, Ddir+2);
	if(d != e) set_drive(e);
}

	// Skip blanks in the input stream
	int skip(void)
	{
		while(isspace(*Ptr))
			++Ptr;
		return *Ptr;
	}

	int cmpu(unsigned char *p, unsigned char f)
	{
		unsigned i;
		unsigned char c;
		i = 0;
		while(c = toupper(*p++)) {
			if(toupper(Ptr[i++]) != c)
				return 0; }
		if(f) return 255;
		switch(Ptr[i]) {	// Insure valid command end
		case ' ' :
		case '\t':
		case 0 : return 255; }
		return 0;
	}


cpycmd(void)
{
	unsigned char c, d, *p, *p1;
	p = Buffer;
a1:	while(*Ptr) {
		if(cmpu("@@", 255)) { Ptr += 2; *p++ = '@'; continue; }
		if(cmpu("@D", 255)) { d = 0; goto rn; }
		if(cmpu("@W", 255)) { d = 255;
	rn:		Ptr += 2;
			p1 = Temp1;
			while(c = *Ptr) {
				if(isspace(c))
					break;
				*p1++ = *Ptr++; }
			*p1 = 0;
			if(!*Temp1) error("?fname");
			resolve(Temp1);
			p1 = d ? Wdir : Ddir;
			do {
				*p++ = c = *p1++; }
			while(c);
			goto a1; }
		*p++ = *Ptr++; }
	*p = 0;
}
#endif

// Execute a WINDOWS cmd
//	ct = command text
//	ms = how long to wait (ms) for results
void wcmd(unsigned char *ct, unsigned ms)
{
	unsigned t;
	FILE fp;
	unsigned char d, m;
	static FILE *cfp;

	if(!cfp) {
		strcpy(Fptr, CFILE);
		cfp = fopen(File, "wvq"); }
	if((m = *ct) == '-')
		++ct;
	if(*ct) {
		fputs(ct, cfp);
		putc('\n', cfp); }
	if(m == '-')
		return;
	fclose(cfp); cfp = 0;

	strcpy(Fptr, SFILE);
	d = get_drive();
	set_drive((*File&0x1F)-1);

	fp = fopen(File, "wvqb");
	putc(0x5A, fp);
	fclose(fp);
ag:	delay(t = 1000);
	system("RESCAN >NUL:");
	strcpy(Fptr, SFILE);
	if(fp = fopen(File, "rb")) {
		fclose(fp);
		if(t > ms) {
			set_drive(d);
			abort("Timeout!"); }
		ms -= t;
		goto ag; }
	set_drive(d);
}

#ifdef DEMO_MODE
	main(int argc, char *argv[])
	{
		unsigned i, j;
		unsigned char *p, c, o;

		p = Temp;
		for(i=1; i < argc; ++i) {
			Ptr = argv[i];
			j = toupper(*Ptr++) << 8;
			switch(toupper(*Ptr++) | j) {
			case'?'<<8:
			case '-?' :
			case '/?' :
				Ptr = Help;
				while(c = *Ptr++) {
					if(c & 0x80) {
						while(c-- & 0x7F)
							putc(' ', stdout);
						continue; }
				putc(c, stdout); }
				exit(-1);
			case '-T' :
			case '/T' : Test = 255;			continue;
			case 'W=' : Wait = atoi(Ptr);	continue;
			default: Ptr -= 2;
			case '/=' :
			case '-=' : ; }
			if(p > Temp) *p++ = ' ';
			while(c = *Ptr++)
				*p++ = c; }
		*p = 0;

		if(!getenv("TEMP", File))
			strcpy(File, "R:\\");
		i = 0; while(File[i]) ++i;
		if(i) switch(File[i-1]) {
			default:	File[i++] = '\\';
			case ':':
			case'\\':	; }
		File[i] = 0; Fptr = File+i;

		if(p > Temp) {	// Single command (from command line)
			Ptr = Temp;
			cpycmd();
			if(Test) {
				printf(">%s<\n", Buffer);
				return; }
			if(!Wait) Wait = 1000;
			wcmd(Buffer, Wait);
			return; }

		if(!Wait) Wait = 5000;
		for(;;) {			// Interactive command session
			printf("WINcmd> ");
			if(!fgets(Ptr = Temp+1, sizeof(Temp)-2, stdin))
				break;
			if(!skip())			continue;
			if(cmpu("QUIT", 0))	break;
			if(cmpu("EXIT", 0))	break;
			Temp[0] = '+';
			Ptr = Temp;
			cpycmd();
			if(Test) {
				printf(">%s<\n", Buffer);
				continue; }
			wcmd(Buffer, Wait);
			i = 0;
			strcpy(Fptr, EFILE);
			efp = fopen(File, "rvq");
			while(fgets(Ptr = Temp, sizeof(Temp)-1, efp)) {
				switch(o = *Ptr) {
				case '+' :
					strcpy(Fptr, RFILE);
					j = 0; while(Fptr[j]) ++j;
					sprintf(Fptr+j, "%u", i);
					fp = fopen(File, "rvq");
					while(fgets(Buffer, sizeof(Buffer)-1, fp)) {
						fputs(Buffer, stdout);
						putc('\n', stdout); }
					fclose(fp);
					delete(File);
				case '-' :
				case ' ' : ++Ptr; }
				if((*Ptr != '0') || atoi(Ptr))
					printf("Command ReturnCode=%s\n", Ptr);
				++i; }
			strcpy(Fptr, EFILE);
			delete(File); }
	}
#endif
