// XDIR - better DIR for DOSBOX
#include <stdio.h>
#include <file.h>
#define	Debug(a)	//print a;
#define	Debug1(a)	printf a;
#define	ALL		0x40	// Extra attribute bit
#define	STACK	100		//pSize of directory stack

//#define DEBUG			// General debug messages
//#define SDEBUG	0	// Sort debug
//#define DUMPM			// Dump memory segments

unsigned
	Options,		// Command options
	Column,			// Column of output
	Dseg,			// Directory storage segment
	Dtop,			// Top of directory segment
	Dpos,			// POsition in directory segment
	Fseg,			// Filename stoage seqment
	Ftop,			// Top of filename segment
	Fpos,			// Filename storage position
	Iseg,			// Index segment
	Itop,			// Highest index count
	De,				// Dir end position
	Sh, Sl,			// Find size
	At,				// Find attribute
	Ti, Da,			// Find time
	Wc,				// File wildcard found
	Pd,				// Parent directory
	Lpd,			// Last ""
	Sp,				// Stack pointer
	Tcount,			// Total file count
	Tfiles,			// Total number of files
	GTfiles,		// Grand Total number of files
	Tsize[2],		// Total size
	GTsize[2],		// Grant Total size
	STKdata[STACK];	// Stack
unsigned char
	*Ptr,			// General pointer
	*Ptr1,			// ""
	*Memb,			// Memory base
	Attrib = 0x7F,	// Accepted attributes
	Cdrive,			// Initial drive
#define	D_TOTAL	0x01
#define	D_SDIR	0x02
#define	D_ONCE	0x04
	Dm,				// Display mode
	Sort,			// Type of sort
	Wild[16],		// Wildcard
	Dir[256],		// Director buffer
	Temp[16],		// Temp storage
	Name[16];		// File name

#include "R:\\Help.h"

// Dseg:	Word: Parent offset
//			Word: TimeH, TimeL
//			Byte: Lenght of name (-1 = DIRUP)
//			Bytes (name)
// Fseg:	Word: Parent offset
//			Word: SizeH, SizeL
//			Word: TimeH, timeL
//			Byte: Length
//			Bytes Name
#define	DOHEAD	7
#define	FOHEAD	11

// Display newline
void nl(void)
{
	putc('\n', stdout);
}

// Report error and terminate
register error(unsigned args)
{
	unsigned char buf[128];
	_format_(nargs()*2+&args, buf);
	putc('?', stdout);
	fputs(buf, stdout);
	nl();
	if(Cdrive != 0xFF) set_drive(Cdrive);
	exit(-1);
}

void Abort(void)
{
	unsigned char c;
	Ptr = Help;
	while(c = *Ptr++) {
		if(c & 0x80) {
			while(c-- & 0x7F)
				putc(' ', stdout);
			continue; }
		putc(c, stdout); }
	exit(0);
}

// Insure caracter is printable
unsigned char *pc(int c)
{
	sprintf(Temp, (((c>=' ')&&(c<0x7F)) ?"%c" : "<%02x>") , c);
	return Temp;
}

#define	O_24HOUR	0x0001		// 24 hour time
#define	O_ATTR		0x0002		// choose Attributes
#define	O_BARE		0x0004		// Bare display
#define	O_SMALL		0x0008		// Compact format display
#define	O_SEC		0x0010		// Seconds
#define	O_FONLY		0x0020		// Files only
#define	O_LOWER		0x0040		// Lower case
#define	O_MEMU		0x0080		// Memory use
#define	O_SUBDIR	0x0100		// recurse into Subdirectories
#define	O_TRAIL		0x0200		// directories Trail files
#define	O_NSUM		0x0400
#define	O_WIDE		0x0800		// Wide format
#define	O_NDIR		0x1000
/*ChtTxt R:\Help.h

use:	XDIR [filespec] [options]

opts:	/2				24 hour time
		/A[+-]adehrs	File must have Attributes			('e' =accept Every)
		/B				Bare format
		/C				Compact format						(default with /O)
		/E				show sEconds
		/F				Files only (no dirs) in list		(default with /SCB)
		/L				use Lower case
		/M				show Memory use
		/S				list Subdirs
		/T				directories Trail filenames
		/U				no sUmmary
		/W				Wide format
		/O[-!]o			list in Order			  			('-' = reverse)
		 	o:	'D'ate, 'E'xtension, 'N'ame, 'S'ize			(/C unless '!')

Wildcards work like they do in UNIX, ie: '.' has so special meaning:
	use '*' for ALL files, '*.*' means name must contain '.'

?COPY.TXT 2020 Dave Dunfield.
*/
//					 124812480
#define	ATtext		"RHSVDAE"
#define	OPtext		"2ABCEFLMSTUW"

unsigned opbits(unsigned char *opt, unsigned op, unsigned char an)
{
	unsigned b;
	unsigned char *p, c;
a1:	switch(c = toupper(*Ptr++)) {
	case '+' : an = 0x80;	goto a1;
	case '-' : an = 0x40;	goto a1;
	case '/' :
	case 0 : goto e1; }
	p = opt;
	b = 0x01;
	while(*p != c) {
		if(!*p++) goto e1;
		b <<= 1; }
	if((an |= 1) & 0x40)	op &= ~b;	// Remove
	else if(an & 0x80)		op |= b;	// Add
	else { op = b; an |= 0x80; }		// Replace
	goto a1;
e1:	if(!(an & 1))
		Abort();
	--Ptr;
	return op;
}

int cmdopt(void)
{
//	unsigned b;
	unsigned char c; //, *p;

	switch(*Ptr) {
	case '?'	: if(!Ptr[1]) break;
	default		: return 0;
	case '/'	:
	case '-'	: ++Ptr; }
	do {
		switch(c = toupper(*Ptr++)) {
		case '/' :
		case '-' : continue;
		case '?' :
hlp: 		Abort();
		case 'A' :
			Attrib = opbits(ATtext, Attrib, 0);
			continue;
		case 'O' :
			if(Sort) error("Multiple /O");
			Options |= O_SMALL;
a1:			switch(c = toupper(*Ptr++)) {
			default		: goto hlp;
			case '-'	: Sort ^= 0x80;			goto a1;
			case '!'	: Options &= ~O_SMALL;	goto a1;
			case 'N'	:	// Name
			case 'E'	:	// Extension
			case 'D'	:	// Date
			case 'S'	:	// Size
				Sort |= c;
				continue; }
		} --Ptr;
		Options = opbits(OPtext, Options, 0x80); }
	while(*Ptr);
	return 255;
}

void setcase(unsigned char *s)
{
	if(Options & O_LOWER) {
		while(*s = tolower(*s))
			++s; }
}

unsigned char PRlc;
// Show string without duplicating '\\'
void pr(unsigned char *s)
{
	unsigned char c;
	while(c = *s++) {
		if((c == '\\') && (PRlc == '\\'))
			continue;
		putc(PRlc=c, stdout); }
}

// Add a string to directory
#define	DA_ES	0x01	// End at slash
#define DA_AS	0x02	// Add a slash first
#define	DA_DS	0x04	// Drop trailing \
#define	DA_WC	0x08	// Detectn wildcard
unsigned char *DAadd(unsigned char *p, unsigned char o)
{
	unsigned char c, e, ec;
	Debug(("DAadd(%03x): '%s' = ", e, p))
	ec	= (o & DA_ES) ? '\\' : 0;
	e	= De ? Dir[De-1] : 0;
	if(o & DA_AS) {		// Add preceeding \
		if(e != '\\')
			Dir[De++] = e = '\\'; }
	if(e == '\\') {		// Trailng skash
		if((o & DA_DS) || (*p == '\\'))
			--De; }
	while(c = *p) {
		++p;
		Dir[De++] = c;
		if(o & DA_WC) switch(c) {
			case '*'	:
			case '?'	: ++Wc;;
			default		: continue;
			case '\\'	: ; }
		if(c == ec) break; }
	Dir[De] = 0;
	Debug(("'%s'\n", Dir))
	return p;
}

// Drop a directory from the buffer
void DAdrop(void)
{
	Debug(("DaDrop:'%s'%u", Dir, De))
	if(De) --De;
a1:	if(De) switch(Dir[--De]) {
	default: goto a1;
	case ':' :
	case '\\': ++De;
	case 0 : ; }
	Dir[De] = 0;
	Debug((" %u'%s'\n", De, Dir))
}

// Check for special dirname
int isspec(unsigned char *p)
{
	unsigned char *pt;
	Debug(("spec?'%s' '%s'", Ptr, p))
	pt = Ptr;
	while(*p) {
		if(*pt != *p++)
			return 0;
		++pt; }
	switch(*pt) {
	case '\\' : ++pt;
	case 0 : Ptr = pt; return 255; }
	return 0;
}

int DoFind(void)
{
	Debug(("Find'%s'%u\n", Dir, De))
	return find_first(Dir, 0x37, Name, &Sh, &Sl, &At, &Ti, &Da);
}

// Resolve directories in filename
void resolve(void)
{
	unsigned char c, d;
	De = 0;
	Cdrive = d = get_drive();
	c = 0xFF;
	if(Ptr[1] == ':') {
		set_drive(c=toupper(Ptr[0]) - 'A');
		if((d = get_drive()) != c) error("drive");
		Ptr += 2; }
	Dir[De++] = d + 'A';
	Dir[De++] = ':';
	if(*Ptr != '\\') {	// Not new
		getdir(Temp);
		DAadd(Temp, DA_AS);
		if(*Temp) Dir[De++] = '\\'; }
	else
		DAadd("\\", 0);
	d = 0;
	do {
		if(isspec("..")) {
			Debug(("..Y\n"))
			DAdrop();
			continue; }
		if(isspec(".")) {
			Debug((".Y\n"))
			continue; }
		Debug(("NO\n"))
		d = De;
		if(Wc) error("Wildcard(s) in path");
		Ptr = DAadd(Ptr, DA_AS|DA_ES|DA_WC);
//if(kbget() == 0x1B) error("ESC");
	} while(*Ptr);
	if(!Wc) {
		if((!DoFind()) && (At & DIRECTORY))
			goto kd; }
	if(d) {
		strcpy(Wild, Dir+d);
		strupr(Wild);
		Dir[De = d] = 0; }
kd:	Debug(("C'%s'%u\n", Dir, De))
	if(De > 3) DAadd("", DA_DS);	// Drop trailing \ if not root
	set_drive(Cdrive); Cdrive = 0xFF;
	if(!*Wild) strcpy(Wild, "*");
	Debug(("Resolve'%s'%u '%s'\n", Dir, De, Wild))
}

#ifdef DUMPM
// Dump segment to file
void dumpseg(unsigned char *fn, unsigned seg)
{
	unsigned i;
	FILE *fp;
	fp = fopen(fn, "wvqb");
	i = 0;
	do {
		putc(peek(seg, i), fp); }
	while(++i);
	fclose(fp);
}
#endif

// Add string to directory
void Dadd(unsigned char *s)
{
	unsigned e;
	if(!De) Wc = 0;
	Debug(("Add:'%s'De=%u", s, De))
	if(!*s) return;
	if(e = De) switch(Dir[e-1]) {
		default: Dir[e++] = '\\';
		case '\\' :
		case ':' : ; }
a1:	switch(Dir[e] = *s++) {
	case '*' :
	case '?' : ++Wc; goto ie;
	case '\\':
		if(Wc) error("Wild1");
		De = e+1;
	default: ie:
		++e;
		goto a1;
	case 0 : ; }
	if(!Wc)
		De = e;
	Debug((" '%s'De=%u Wc=%u\n", Dir, De, Wc))
}

// Drop last string from directory
void Ddrop(void)
{
	Debug(("[Drop]"))
a1:	if(De) switch(Dir[De-1]) {
		default		: --De; goto a1;
		case '\\'	: --De;
		case ':'	: ; }
	Dir[De] = 0;
}

// Put and item on the directory stack
void Stack(unsigned v)
{
	if(Sp >= STACK) error("Dstack overflow");
	STKdata[Sp++] = v;
}
/*
 * Match a filename against a pattern using unix rules
 * - '?' matches any single character
 * - '*' matches any substring
 * - '.' is treated like any other character
 */
int Fmatch(unsigned char *name, unsigned char *pattern)
{
	unsigned char c;

	Debug(("Match '%s'", name))
	Debug((" '%s'\n", pattern))

//	for(;;) switch(c = toupper(*pattern++)) {
	for(;;) switch(c = *pattern++) {
	case 0 : return *name == 0;
	case '?' :
		if(!*name++)
			return 0;
		break;
	case '*' :
		if(!*pattern)
			return 1;
		while(*name) {
			if(Fmatch(name, pattern))
				return 1;
			++name; }
		return 0;
	default:
//		if(toupper(*name++) != c)
		if(*name++ != c)
			return 0; }
}

void Fentry(unsigned l)
{
	if((Ftop+l+FOHEAD) < Ftop) error("Fseg overflow");
	if(Itop >= 32767) error("Iseg overflow");
	setcase(Name);
	pokew(Iseg, Itop+Itop, Ftop); ++Itop;
	pokew(Fseg, Ftop, STKdata[Sp-1]);	// Parent offset
	pokew(Fseg, Ftop+2, Sh);			// SizeH
	pokew(Fseg, Ftop+4, Sl);			// SizeL
	pokew(Fseg, Ftop+6, Ti);			// Time
	pokew(Fseg, Ftop+8, Da);			// Date
	poke(Fseg, Ftop+10, l|0x80);		// Length
	Ftop += FOHEAD;
}

void DoDir(void)
{
	unsigned s, e, de;
	static unsigned l, nf;
		
	Debug(("DoDir:'%s'e=%u w=%u '%s'\n", Dir, De, Wc, Wild))
	Ptr = Dir;
//	while(*Ptr) {
//		if(*Ptr++ == '$') {
//			if(strbeg(Ptr, "RECYCLE"))
//				return; } }
	s = Dtop;
	Dadd("*.*");	//	Dadd(Wild);
	Debug(("Find:'%s'\n", Dir))
	if(DoFind()) {
//		error("Not found: %s", Dir);
		printf("? %s\n", Dir);
		return; }
	Dir[De] = nf = 0;
	do {
		l = strlen(Ptr=Name);
		if((At |= ALL) & DIRECTORY) {	// Directory entry
			setcase(Name);
			Debug(("SubDir: '%s'\n", Name))
			if((Dtop+l+DOHEAD) < Dtop) error("Dseg overflow");
			pokew(Dseg, Dtop, STKdata[Sp-1]);		// Parent offset
			pokew(Dseg, Dtop+2, Ti);				// Time
			pokew(Dseg, Dtop+4, Da);				// Date
			poke(Dseg, Dtop+6, l|0x80);				// Length
			Dtop += DOHEAD;
			while(l) {
				poke(Dseg, Dtop++, *Ptr++);
				--l; }
			continue; }
		// Filename
		Debug(("File: '%s'\n", Ptr))
		if(Fmatch(Name, Wild)) {
			if(At & Attrib) {
				++nf;
				setcase(Name);
				Fentry(l);
				while(l) {
					poke(Fseg, Ftop++, *Ptr++);
					--l; } } }
	} while !find_next(Name, &Sh, &Sl, &At, &Ti, &Da);
	if(!nf)		// Fake a name
		Fentry(0);
	e = Dtop;
	Debug(("%04x < %04x\n", s, e))
	Wc = 0;
	while(s < e) {
		Stack(s);
		l = peek(Dseg, s+(DOHEAD-1)) & 0x1F;
		s += DOHEAD;	// Skip len & parent
		Ptr = Name;
		while(l) {
			*Ptr++ = peek(Dseg, s++);
			--l; }
		*Ptr = 0;
		if(*Name != '.') {
			if(Options & O_SUBDIR) {
				de = De;
				Dadd(Name);
				Debug(("SubDir>'%s'%u\n", Dir, Sp))
				Dadd("*.*");
				DoDir();
				Dir[De = de] = 0; } }
		--Sp; }
	Debug(("DoEnd:'%s'%u %u\n", Dir, De, Wc))
}

//  Read next file from [Fpos] into: Name, Pd, Sh, Sl, Ti, Da
void GetFile()
{
	unsigned l;
	unsigned char *p;
	Pd = peekw(Fseg, Fpos);
	Sh = peekw(Fseg, Fpos+2);
	Sl = peekw(Fseg, Fpos+4);
	Ti = peekw(Fseg, Fpos+6);
	Da = peekw(Fseg, Fpos+8);
	l = peek(Fseg, Fpos+10) & 0x1F;
	Fpos += FOHEAD;
	p = Name;
	while(l) {
		*p++ = peek(Fseg, Fpos++);
		--l; }
	*p = 0;
}

// Show a directory
#define	SD_DONLY	0x01
#define	SD_LEADS	0x80
int showdir(unsigned ofset, unsigned char sl)
{
	unsigned pa, l, m, s;
	unsigned char *p;

	if(!(sl & SD_DONLY)) {
		if(!(Attrib & DIRECTORY)) {
			return 0; } }
	*(p = Dir+250) = s = 0;
	while(ofset != -1) {
		pa = peekw(Dseg, ofset);
		s = l = peek(Dseg, ofset+(DOHEAD-1)) & 0x1F;
		ofset += DOHEAD;
		if(sl & SD_LEADS) {
			*--p = '\\';
			++s; }
		sl |= SD_LEADS;
		p -= l; m = 0;
		while(l) {
			p[m++] = peek(Dseg, ofset++);
			--l; }
		if(m && (sl & SD_LEADS) && (p[m-1] != '\\'))
			p[m++] = '\\';
//?		p[m] = 0;
		ofset = pa; }
	Debug(("[sd'%s']", p))
	pr(p);
	return 255;
}

#define	LSIZE	4		/* 32 bit numbers */
extern char Longreg[];	/* Contains remainder after long division */

/*
 * Convert a LONG number into a printable string
 */
char *Ltoa(unsigned char *n1, unsigned char *string)
{
	unsigned sp, p;
	unsigned char c, stack[(LSIZE*25)/10+4];
	char temp1[LSIZE], temp2[LSIZE];

	longcpy(temp2, n1);
	longset(temp1, 10);

	/* Stack up digits in reverse order */
	sp = p = 0;
	do {
		if(p++ >= 3) {
			stack[sp++] = ',';
			p = 1; }
		longdiv(temp2, temp1);
		stack[sp++] = ((c = *Longreg) > 9) ? c + '7' : c + '0'; }
	while(longtst(temp2));

	/* Unstack digits into output buffer */
	do
		*string++ = stack[--sp];
	while(sp);
	*string = 0;
	return string;
}

// Display time & date
void showtd(unsigned ti, unsigned da)
{
	unsigned j, k;
	unsigned char *p, s[8];
	if(Options & O_BARE)
		return;
	p = "%04u-%02u-%02u";
	*s = 0;
	j = (da >> 9) + 1980;
	if(Options & O_SMALL) {
		p = "%02u-%02u-%02u";
		j %= 100; }
	printf(p, j, (da>>5)&0x0F, da&0x1F);

	j = (k = (ti >> 11) & 0x1F) % 12;
	if(Options & O_SEC)
		sprintf(s, ":%02u", (ti&31)*2);
	if(Options & O_24HOUR) {
		if(!(Options & O_SMALL)) putc(' ', stdout);
		printf("%3u:%02u%s", ti>>11, (ti>>5)&0x3F, s); }
	else if(Options & O_SMALL)
		printf("%3u:%02u%s%c", (j)?j:12, (ti>>5)&0x3F, s, (k>11)?'p':'a');
	else
		printf("%4u:%02u%s %cm ", (j)?j:12, (ti>>5)&0x3F, s, (k>11)?'P':'A');
}

// Print in column width
void prc(unsigned char *s)
{
	unsigned char *f;
	f = (++Column > 4) ? "%s" : "%-15s";
	printf(f, s);
	if(f[1] != '-') {
		nl();
		Column = 0; }
}

// Show subdirectories
void showsub(unsigned index)
{
	unsigned o, l, pa, ti, da;
	unsigned char *p, name[32];

	o = 0;
	if(!(Attrib & DIRECTORY))	return;
	if(Options & O_FONLY)		return;
	if(index >= (unsigned)-2)	return;
	while(o < Dtop) {
		pa = peekw(Dseg, o);
		ti = peekw(Dseg, o+2);
		da = peekw(Dseg, o+4);
		l = peek(Dseg, o+(DOHEAD-1)) & 0x1F;
		o += DOHEAD;
//printf("@%04x-%04x-%04x %04x: %04x %04x %04x %u",
//	o1, o, o+l, Dtop, pa, ti, da, l);
		if(pa == index) {
			p = name;
			while(l) {
				*p++ = peek(Dseg, o++);
				--l; }
			*p = 0;
			if(Fmatch(name, Wild)) {
				if(Options & O_WIDE) {
					sprintf(Temp, "[%s]", name);
					prc(Temp);
					continue; }
				if(Options & O_BARE) {
					showdir(pa, 0);
					printf("%s\n", name);
					continue; }
				showtd(ti, da);
				if(Options & O_SMALL)
					printf("%-14s%s\n", "   <DIR>", name); 
				else
					printf("%-19s%s\n", "   <DIR>", name); }
			continue; }
		o += l; }
}

// Block display
void bdisp(void)
{
	unsigned char nf;

	if(Options & O_WIDE) {
		if(Column) nl();
		Column = nf = 0;
		goto a1; }
	if(!(Options & (O_SMALL|O_BARE))) {
		nf = 255;
a1:		if((Dm & D_TOTAL) && !(Options & O_NSUM)) {
			Ltoa(Tsize, Temp);
			printf("%-8s%6u %s%14s bytes.\n", "", Tfiles, "Files(s)", Temp);
			++Tcount;
			longset(Tsize, Tfiles=0); }
		if(Dm & D_SDIR) {
			if(nf) nl();
			printf(" Directory of ");
			if(showdir(Pd, SD_DONLY)) pr("\\");
			pr(Wild);
			nl();
			if(nf) nl(); } }
}

// Display a file
void showfile(unsigned index)
{
	unsigned i, s[2];

	PRlc = 0;
	Fpos = peekw(Iseg, index+index);
	GetFile();
	if(Pd != Lpd) {
		if(Options & O_TRAIL)
			showsub(Lpd);
		if(*Name || (Dm & D_ONCE))
			bdisp();
		Dm = D_TOTAL|D_SDIR;
		if(!(Options & O_TRAIL))
			showsub(Pd);
		Lpd = Pd; }
	i = Da;
	if(!*Name) return;
	s[1] = Sh;
	s[0] = Sl;
	longadd(Tsize, s);
	longadd(GTsize, s);
	if(Options & O_WIDE) {
		prc(Name);
		return; }
	else {
		showtd(Ti, Da);
		if(!(Options & O_BARE)) {
			Ltoa(s, Temp);
			if(Options & O_SMALL)
				printf("%13s ", Temp);
			else
				printf("%18s ", Temp); }
		if(Options & (O_SMALL|O_BARE)) {
			if(!(Options & O_NDIR))
				showdir(Pd, SD_LEADS); }
		pr(Name); nl(); }
	++Tfiles;
	++GTfiles;
}

// Sort files
void sort(void)
{
	unsigned f1, f2, s2, l, fp, fp1, fp2, sp2;
	unsigned pd, sh, sl, ti, da;
#if SDEBUG
	unsigned SH, SL, TI, DA;
	unsigned char NAME[16];
#endif
	unsigned char *p, *E, *e, name[16];

#if SDEBUG
	printf("Sorting: %c%c\n", (Sort&0x80) ? '-' : '+', Sort & 0x7F);
#endif
	for(f1 = 0; f1 < Itop; ++f1) {
		fp1 = Fpos = peekw(Iseg, f1+f1);
		GetFile();
#if SDEBUG
		SH = Sh; SL = Sl; TI = Ti; DA = Da; strcpy(NAME, Name);
#endif
#if SDEBUG > 1
		printf("test(%u) %04x%04x %04x%04x\n", f1, SH,SL,DA,TI);
#endif
		s2 = -1;
		E = 0;
		for(f2 = f1 + 1; f2 < Itop; ++f2) {
			fp = fp2 = peekw(Iseg, f2+f2);
			pd = peekw(Fseg, fp);
			sh = peekw(Fseg, fp+2);
			sl = peekw(Fseg, fp+4);
			ti = peekw(Fseg, fp+6);
			da = peekw(Fseg, fp+8);
			l = peek(Fseg, fp+10) & 0x1F;
			fp += FOHEAD;
			p = name;
			while(l) {
				*p++ = peek(Fseg, fp++);
				--l; }
			*p = 0;
#if SDEBUG > 1
			printf("TEST(%u) %04x%04x %04x%04x\n", f2, sh,sl,da,ti);
#endif
			switch(Sort & 0x7F) {
			case 'D' :
				if(da < Da) goto swap1;
				if(da > Da) goto swap2;
				if(ti < Ti) goto swap1;
				if(ti > Ti) goto swap2;
				continue;
		swap1:	if(Sort & 0x80) continue;
				goto swap3;
		swap2:	if(!(Sort & 0x80)) continue;
		swap3:	Pd = pd;
				Sh = sh; Sl = sl;
				Ti = ti; Da = da;
				strcpy(Name, name); E = 0;
				s2 = f2;
				sp2 = fp2;
				continue;
			case 'S' :
				if(sh < Sh) goto swap1;
				if(sh > Sh) goto swap2;
				if(sl < Sl) goto swap1;
				if(sl > Sl) goto swap2;
				continue;
			case 'N' :
				l = strcmp(name, Name);
a1:				if(l & 0x8000) goto swap1;
				if(l) goto swap2;
				continue;
			case 'E' :
				if(!E) {
					E = Name;
a2:					switch(*E) {
					default: ++E; goto a2;
					case '.' : ++E;
					case 0 : ; } }
			e = name;
a3:			switch(*e) {
			default: ++e; goto a3;
			case '.' : ++e;
			case 0 : ; }
			l = strcmp(e, E);
			goto a1;
			default: error("NIsort: %s", pc(Sort & 0x7F)); } }
		if(s2 != -1) {	// Swap to occur
#if SDEBUG
			printf("swap(%u) %04x%04x %04x%04x", f1, SH, SL, DA, TI);
			printf(" with(%u) %04x%04x %04x%04x\n", s2, Sh, Sl, Da, Ti);
#endif
			pokew(Iseg, f1+f1, sp2);
			pokew(Iseg, s2+s2, fp1); } }
}

main(int argc, char *argv[])
{
	unsigned i, j;
	// Process command line
	for(i=1; i < argc; ++i) {
		Ptr = argv[i];
		if(!cmdopt()) {
			if(Ptr1) Abort();
			Ptr1 = Ptr; } }
	if(Options & (O_SMALL|O_BARE)) {
		if(Options & O_SUBDIR)
			Options ^= O_FONLY;
		if(Options & O_WIDE)
			Options ^= (O_WIDE|O_NDIR); }
	Debug(("[%x]", Options))
	if(!(Ptr = Ptr1)) Ptr = "*";
	if(Options & O_LOWER) strlwr(Ptr1);
	resolve();
	Debug(("Dir : '%s'\n", Dir))
	Debug(("Wild: '%s'\n", Wild))
	if(Options & O_MEMU) {
		free(i = malloc(1));
		Ptr = Memb = i + 20;
		Ptr1 = &i - 20;
		while(Ptr < Ptr1)
			*Ptr++ = 0xA5; }
//printf("D'%s'%u W:'%s'\n", Dir, De, Wild);

	Iseg = (Dseg = (Fseg = alloc_seg(4096*3)) + 4096) + 4096;
	Debug(("I:%04x D:%04x F:%04x\n", Iseg, Dseg, Fseg))
	i = 0;
	do {
		pokew(Iseg, i, 0);
		pokew(Dseg, i, 0);
		pokew(Fseg, i, 0); }
	while(i -= 2);

	Debug(("DIR:[%s] Wc:[%s]\n", Dir, Wild))

	Stack(0);
	pokew(Dseg, 0, -1);
	poke(Dseg, (DOHEAD-1), De);
	Dtop += DOHEAD;
	Debug(("[%u'%s]", De, Wild))
	for(i=0; i < De; ++i)
		poke(Dseg, Dtop++, Dir[i]);

	DoDir();
#ifdef DUMPM
	dumpseg("R:\\DSEG", Dseg);
	dumpseg("R:\\FSEG", Fseg);
#endif

	Lpd = -2;	// Insure new
	Dm = D_ONCE|D_SDIR;		// Initial display mode
	Debug(("Dout'%s'\n", Dir))
	if(Sort) sort();
	for(i=0; i < Itop; ++i)
		showfile();
/*	if(!Itop)
		showsub(Pd);
	else */ if(Options & O_TRAIL)
		showsub(Lpd);
//	Lpd = -2;	// Insure new
	Dm = D_TOTAL; bdisp();
	if((Tcount != 1) && !(Options & (O_BARE|O_NSUM))) {
		Ltoa(GTsize, Temp);
		printf("%-8s%6u %s%14s bytes.\n", "Total:", GTfiles, "Files(s)", Temp); }
	if(Options & O_MEMU) {
		i = j = 0;
		Ptr1 = &i - 20;
		while(Memb < Ptr1) {
			if(*Memb++ == 0xA5)
				++i;
			else if(i) {
				if(i > j) j = i;
				i = 0; } }
			printf("\nMem:%-6uFseg:%-6uDseg:%-6uIseg:%u\n", -j, Ftop, Dtop, Itop+Itop); }
	Debug(("{%x}", Options))
}
