/*
 * A TSR file *browser
 *
 * ?COPY.TXT 1993-2005 Dave Dunfield
 * **See COPY.TXT**.
 *
 * Permission granted for personal (non-commercial) use only.
 *
 * Compile command: cc tfb -fop
 */
#include <stdio.h>
#include <window.h>
#include "help.h"

#define	LINE_SIZE	512		/* Maximum width of input line */
#define	NUM_TAGS	10		/* Maximum number of tag locations */
#define	NUM_FILES	10		/* Maximum number of pick files */

int tab_size = 4, line, lcount, offset, tag, file, fnext = 0,
	file_info[NUM_FILES][NUM_TAGS+4], Msel, Mval[NUM_FILES];

unsigned sizeh, sizel, maxline, lines[2048][2], tags[NUM_TAGS];

static char filename[NUM_FILES][51], search_string[NUM_FILES][51],
	*Mptr[NUM_FILES+1], *argptr = 0;

extern struct WINDOW *twin, *bwin;
extern char bwin_contents;

FILE *fp = 0;

extern unsigned char
	Vbrw_txt,						/* Main text screen */
	Vedt_eof,						/* End of file */
	Vbrw_pop;						/* Pop-up items */

/* Form for setting tab size */
char *form2[] = {
	30<<8|3,
	"\x00\x00\x85Tab size:",
	0 };

/* Form for selecting line number */
char *form3[] = {
	30<<8|3,
	"\x00\x00\x85Line number:",
	0 };

/* Form for string searches */
char *form4[] = {
	64<<8|3,
	"\x00\x00\x32Search for:",
	0 };

/*
 * Main file browser program
 */
browse(char interactive)
{
	int i, x;
	char buffer[LINE_SIZE+1];

	W_OPEN = bwin;
	*twin = Vbrw_txt;
	wcursor_off();

	/* If file already active... reopen */
	if(fnext) {
		if(!(fp = fopen(filename[file], "rb")))
			fnext = 0; }

	/* If no file open... prompt for one. */
	if(!fnext) {
		if(!interactive) {
			wclwin();
			return; }
		*buffer = 0;
		do {
			if(argptr) {
				strcpy(buffer, argptr);
				argptr = 0; }
			else if(!get_file(buffer, "*.*"))
				*buffer = 0;
			if(!*buffer)
				return 0; }
		while(!open_file(buffer));
		strcpy(filename[file = fnext++], buffer); }

/* Display screen from file */
	init_browse_window();
	bwin_contents = -1;
display:
	if(line > lcount)
		line = lcount;
	if(line < 0) line = 0;
	if(offset < 0) offset = 0;
	gotoline(line);
	for(i=0; i < W_OPEN->WINheight; ++i) {
		wgotoxy(0, i);
		if(fgets(buffer, sizeof(buffer)-1, fp))
			show_line(buffer);
		if((line + i) == lcount) {
			*W_OPEN = Vedt_eof;
			wputs("*END OF FILE*");
			*W_OPEN = Vbrw_txt;
			wcleow();
			break; } }
	if(!interactive) {
		fclose(fp);
		return; }
	update_status();

/* Get and process command character */
command:
	switch(x = dgetc()) {
		case _KUA :			/* Backup one line */
			--line;
			goto display;
		case _KDA :			/* Advance one line */
			++line;
			goto display;
		case _KPU :			/* Backup one page */
			line -= W_OPEN->WINheight - 1;
			goto display;
		case _KPD :			/* Advance one page */
			line += W_OPEN->WINheight -1;
			goto display;
		case _CPU :			/* Go to start of file */
			line = 0;
			goto display;
		case _CPD :			/* Go to end of file */
			line = 32767;
			goto display;
		case _KRA :			/* Advance one column */
			++offset;
			goto display;
		case _KLA :			/* Backup one column */
			--offset;
			goto display;
		case _KEN :			/* Advance 20 columns */
			offset += 20;
			goto display;
		case _KHO :			/* Backup 20 columns */
			offset -= 20;
			goto display;
		case _CHO :			/* Reset to 1st column */
			offset = 0;
			goto display;
		case _K1 :			/* Display Fkey help */
			help(H_BROWSE);
			goto command;
		case _K2 :			/* Goto line number */
			x = line+1;
			if(!wform(20, 10, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, form3, &x))
				line = x - 1;
			goto display;
		case _K3 :			/* Initial Search */
			if(!wform(7, 10, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, form4, search_string[file])
				&& search(search_string[file], line))
				goto display;
			goto command;
		case _K4 :			/* Repeat Search */
			if(search(search_string[file], line+1))
				goto display;
			goto command;
		case _K5 :			/* Move to tag */
			if((!tag_menu(15, 8)) && tags[tag])
				line = tags[tag] - 1;
			goto display;
		case _K6 :			/* Set tag */
			if(!tag_menu(55, 8))
				tags[tag] = line + 1;
			goto command;
		case _K7 :			/* Set TAB size */
			x = tab_size;
			if(!wform(20, 10, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, form2, &x))
				tab_size = x ? x : 1;
			goto display;
		case _K9 :			/* Browse another file */
			*buffer = 0;
			if(get_file(buffer, "*.*")) {
				save_info();
				if(open_file(buffer)) {
					strcpy(filename[file = fnext++ % NUM_FILES], buffer);
					goto display; } }
			goto command;
		case _K10 :			/* Pick a previously opened file */
			for(i=Msel=x=0; i < NUM_FILES; ++i) {
				if(*filename[i]) {
					if(i == file)
						Msel = x;
					Mptr[x] = filename[i];
					Mval[x++] = i; } }
			Mptr[x] = 0;
			if(!wmenu(15, 8, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, Mptr, &Msel)) {
				save_info();
				if(open_file(filename[Msel])) {
					file = Msel;
					restore_info();
					goto display; } }
			goto command;
		case 0x1B:			/* Exit */
			save_info();
			fclose(fp);
			return -1; }

/* Command key not recognized... */
	wputc(7);
	goto command;
}

/*
 * Open and index a file
 */
open_file(name)
	char *name;
{
	int c;

	/* Attempt to open the file - report if failure */
	if(!(c = openf(name, "rb"))) {
/*		w_clwin(twin);
		w_printf(twin,"Unable to access: '%s'", name); */
		return 0; }

	w_clwin(twin);
	w_printf(twin,"Indexing '%s'...", name);

	/* Close previously open file (if any) */
	if(fp)
		fclose(fp);
	fp = c;

	/* Reset viewer file control variables */
	sizeh = sizel = maxline = lcount = line = offset = tag = 0;
	for(c=0; c < NUM_TAGS; ++c)
		tags[c] = 0;

	/* Build table of line numbers .vs. file offsets */
	while((c = getc(fp)) != EOF) {
		if(!++sizel)
			++sizeh;
		if(c == '\n') {
		/*	if(!++sizel)
				++sizeh; */
			if(!(++lcount & 0x1F)) {
				lines[maxline][0] = sizel;
				lines[maxline++][1] = sizeh; } } }

	return -1;
}

/*
 * Display status in the message window
 */
update_status()
{
	w_gotoxy(0, 0, twin);
	w_printf(twin,"BROWSE: %-42s Line: %u of %u, Col: %u", filename[file], line+1, lcount, offset+1);
	w_cleow(twin);
}

/*
 * Position file to line 'n'
 */
gotoline(line)
	unsigned line;
{
	int c, i;

	rewind(fp);

	/* If more than 32 lines... seek to it */
	if(i = line >> 5) {
		--i;
		fseek(fp, lines[i][1], lines[i][0], 0); }

	/* Read till we get to exact line */
	i = line & 0x1F;
	while(i) {
		if((c = getc(fp)) == EOF)
			return -1;
		if(c == '\n')
			--i; }

	return 0;
}

/*
 * Display a line with tabs expanded
 */
show_line(text)
	char *text;
{
	int p, o;
	unsigned char c;

	o = offset + W_OPEN->WINwidth;
	p = 0;
	while((c = *text++) && (p < o)) {
		if(c == '\t') {				/* tab */
			do
				if(p >= offset)
					wputc(' ');
			while(++p % tab_size); }
		else if(c != '\r') {						/* not a tab */
			if(++p > offset) {
				if(c < ' ') {		/* Control character */
					*W_OPEN = (Vbrw_txt >> 4) | (Vbrw_txt << 4);
					wputc(c + 0x40);
					*W_OPEN = Vbrw_txt;
					continue; }
				wputc((c <= '~') ? c : 0xFE); } } }
	if(p < o)
		wcleol();
}

/*
 * Search for string in file
 */
search(string, l)
	char *string;
	int l;
{
	char buffer[LINE_SIZE+1];

	w_clwin(twin);
	w_printf(twin, "Searching from line %u for '%s'... ", l+1, string);
	gotoline(l);
	while(fgets(buffer, sizeof(buffer)-1, fp)) {
		if(inline(buffer, string)) {
			line = l;
			return -1; }
		++l; }
	w_printf(twin, "Not found!", string);
	return 0;
}

/*
 * Test for string occuring within a line.
 * We could easily do this in 'C', however its a good chance to show
 * off inline assembly language, and get a slight speed improvement.
 */
inline(line, string) asm
{
		MOV		SI,6[BP]		; Get line
inl1:	MOV		DI,4[BP]		; Get string
inl2:	MOV		AL,[DI]			; Get char from string
		MOV		AH,[SI]			; Get char from line
		AND		AL,AL			; End of string?
		JZ		inl3			; Yes, we have match
		INC		SI				; Advance line
		INC		DI				; Advance string
		CMP		AL,AH			; *line == *string?
		JZ		inl2			; Yes, keep looking
		AND		AH,AH			; End of string?
		JNZ		inl1			; No, keep trying
; End of line... string was not found
		XOR		AX,AX			; 0 = Not found
		JMP SHORT inl4			; And exit
; Found string
inl3:	MOV		AX,-1			; 1 = Success
inl4:
}

/*
 * Save viewer information for current file.
 */
save_info()
{
	int i, *ptr;
	ptr = file_info[file];
	*ptr = line;
	*++ptr = offset;
	*++ptr = tab_size;
	*++ptr = tag;
	for(i=0; i < NUM_TAGS; ++i)
		*++ptr = tags[i];
}

/*
 * Reload viewer information for current file.
 */
restore_info()
{
	int i, *ptr;
	ptr = file_info[file];
	line = *ptr;
	offset = *++ptr;
	tab_size = *++ptr;
	tag = *++ptr;
	for(i=0; i < NUM_TAGS; ++i)
		tags[i] = *++ptr;
}

/*
 * Build and perform a menu of tag line numbers.
 */
tag_menu(x, y)
	int x, y;
{
	int i;
	char *tagnames[NUM_TAGS+1], text[NUM_TAGS][6];
	for(i=0; i < NUM_TAGS; ++i) {
		if(tags[i])
			sprintf(tagnames[i] = text[i], "%u", tags[i]);
		else
			tagnames[i] = "-----"; }
	tagnames[NUM_TAGS] = 0;
	return wmenu(x, y, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, tagnames, &tag);
}
