#include <stdio.h>
#include <window.h>
#include <comm.h>
#include "help.h"

char title_bar[] =
/*----*----1----*----2----*----3----*----4----*----5----*----6----*----7----*/
" C)ompile  T)arget   O)ption   F)ile     K)alc     A)scii    B)rowse   L)og";
#define	EDIT_START	1			/* Start of edit buffer */
#define	MCOMPILE	1,1			/* X,Y for compile menues */
#define	MTARGET		11,1		/* X,Y for target menu */
#define	MOPTION		21,1		/* X,Y for options menus */
#define	MFILE		31,1		/* X,Y for file menus */
#define	MCALC		41,1		/* X,Y for Calculator */
#define	MASCII		51,1		/* X,Y for ASCII */
#define	CWLINE		0			/* Starting line for ?COPY.TXT */
#define	CWROW		7			/* Starting row for ?COPY.TXT */
#define	TSIZE		23			/* Size of text window */
#define	NCOLORS		8			/* Number of colors */
#define	EDITF		27			/* Number of edit functions */
#define	KEYS		30			/* Number of special keys */

/* Step option types */
#define	OPT_SWITCH	1			/* ON/OFF switch */
#define	OPT_PICK	2			/* Pick list */
#define	OPT_VALUE	3			/* Value entry */
#define	OPT_CHAIN	4			/* Chain to new option menu */
#define	OPT_EXEC	5			/* Execute a function */

/* Parse function flags */
#define	PARSE_SPACE	0x01		/* Parse on spaces */
#define	PARSE_BAR	0x02		/* Parse on bars */
#define	PARSE_UCASE	0x04		/* Store in upper case */
#define	PARSE_EDIT	0x08		/* Parse edit flags */


unsigned char
	Vedt_txt = NORMAL,			/* Normal text */
	Vbrw_txt = REVERSE, 		/* Main text screen */
	Vedt_msg = 0x01,			/* Informational messages */
	Vedt_err = 0x09,			/* Error messages */
	Vbrw_pop = REVERSE,			/* Pop-up items */
	Vedt_eof = REVERSE,			/* EOF marker */
	Vhlp_txt = 0x07,			/* Help text */
	Vhlp_lnk = 0x0F;			/* Help link */

/* Structure of a COMPILATION STEP identifier */
struct STEP {
	char *STEP_name;			/* Name of step */
	char *STEP_type;			/* Filetype for step output */
	char *STEP_command; };		/* Command strings */

/* Structure of an option handler */
struct OPTION {
	char OPT_type;
	char *OPT_text;
	char *OPT_value; };

/* Storage for configured compilation steps */
struct STEP *step[10];
char step_enable[10];
int steps;
struct OPTION *step_options;
char *simulator, *debugger, *loader, *setup;
char uservar[4][26];

/* Text pool used for configuration storage & strings */
char text_pool[3000], *text_ptr, *key_ptr = 0;

/* Text tool used for application output storage */
char APPoutput[4000];
unsigned APPindex, APPy = 0;

/* Parse buffer & associated pointer */
char parse_buffer[100], *parse_ptr;

/* Filename input buffer */
char filename[65], home[65], tmprefix[50], defile[65], ifile[65], ofile[65];

/* Preconfigured IDE options */
extern resize();
struct OPTION general_options[11] = {
	char OPT_EXEC,	int	"Resize windows", &resize,
	char OPT_VALUE,	int	"Tab width        ", 4,
	char OPT_VALUE,	int	"Filename         \xC3", &filename,
	char OPT_VALUE, int "Temp. file prefix\xB4", &tmprefix,
	char OPT_SWITCH,int "Compile from temp", 0,
	char OPT_SWITCH,int "Keep temp. files ", 0,
	char OPT_SWITCH,int "Pause after steps", 0,
	char OPT_PICK,	int	"Target port      \x84COM1\x80COM2\x80COM3\x80COM4", 0,
	char OPT_VALUE, int "Target speed     \x80", 9600,
	char OPT_VALUE,	int	"Upload delay     \x80", 0,
	char OPT_SWITCH,int	"Upload linefeeds ", 1
	};
char END_marker = 0;
#define	TAB_SIZE		1
#define	COMPILE_TEMP	4
#define	KEEP_TEMP		5
#define	PAUSE_STEP		6
#define	TTY_PORT		7
#define	TTY_SPEED		8
#define	TTY_DELAY		9
#define	TTY_LINEFEED	10

struct WINDOW *twin, *mwin, *bwin;
char bwin_contents = 15;		/* Indicate not written */

/* Variables for the target() functions */
unsigned
	mode=(PAR_NO|STOP_1|DATA_8);/* Communication modes */
char
	reset_cursor,				/* Reset cursor in tty screen */
	dnlfile[65] = "*.*";		/* Filename for downloading */
FILE *upl_fp = 0, *dnl_fp = 0;

/*
 * Function keys
 */
char keys[KEYS][4] = {		/* Key names */
	"ESC",	"UA\0",	"DA\0",	"LA\0",	"RA\0",	"PU\0",	"PD\0",	"HOM",
	"END",	"KP+",	"KP-",	"INS",	"DEL",	"BS\0",	"F1\0",	"F2\0",
	"F3\0",	"F4\0",	"F5\0",	"F6\0",	"F7\0",	"F8\0",	"F9\0",	"F10",
	"^PU",	"^PD",	"^HO",	"^EN",	"^LA",	"^RA" };

/* Variables for the calc() function */
int
	acc,						/* Calculator accumulator 0 */
	acc1;						/* Calculator accumulator 1 */
char
	op;							/* Calculator pending operation */

extern unsigned
	tab_width,				/* Editor tab size */
	tab_size,				/* Browser tab size */
	edit_seg,				/* Edit buffer */
	edit_end;				/* End of edit buffer */

extern char
	edit_keys[],			/* Editor keys */
	*edit_key_cmds[25],		/* Editor command keys */
	CHANGED,				/* Edit file has been changed */
	*errmsg;				/* Error message to display */

/*
 * Skip to next non-blank
 */
skip_blanks()
{
	while(isspace(*parse_ptr))
		++parse_ptr;
	return *parse_ptr;
}

/*
 * Parse string with specified delimiter into parse_buffer
 */
parse(char flags)
{
	char c, *ptr;

	skip_blanks();
	ptr = parse_buffer;

	for(;;) {
		if(!(c = *parse_ptr))
			break;
		++parse_ptr;
		if((flags & PARSE_SPACE) && isspace(c))
			break;
		if((flags & PARSE_BAR) && (c == '|'))
			break;
		*ptr++ = (flags & PARSE_UCASE) ? toupper(c) : c; }

	*ptr = 0;
	return ptr - parse_buffer;
}

/*
 * Parse a string into the text buffer
 */
char *parse_text(int o)
{
	int c, i;
	char *ptr, *ptr1, *ptr2;

	parse(o);
	ptr = parse_buffer;
	ptr1 = text_ptr;
	do {
		c = *ptr++;
		if(o & PARSE_EDIT) switch(c) {
			case '^' :	i = *ptr & 0x1F;	goto dospec;
			case '!' :	i = (*ptr & 0x1F) + _CRA;
			dospec:	if(isalpha(*ptr)) {
				++ptr;
				c = i;
				continue; }
			case '~' :
				i = KEYS;
				while(i--)
					if(strbeg(ptr, ptr2 = keys[i])) {
						c = i ? i + 0x7F : 0x1B;
						ptr += strlen(ptr2);
						break; } } }
	while(*text_ptr++ = c);
	return ptr1;
}

/*
 * Set title bar to specified color & text
 */
register title(args)
	unsigned args;
{
	unsigned *ptr;
	char buffer[81];

	*twin = *(ptr = (nargs()-1) * 2 + &args);
	_format_(ptr, buffer);
	*(int*)(twin+6) = 0;
	w_puts(buffer, twin);
	w_cleol(twin);
}

main(int argc, char *argv[])
{
	int i;
	char mflag;
	static int fselect = 0, tselect = 0, cselect = 0;
	static char *file_menu[] = { "Load", "Configuration", "DOS Shell", "Quit", 0 };
	static char *target_menu[] = { "Connect", "Simulate", "Debug", "Load", 0 };
	static char *stepmenu[] = { "Options", "Steps","Compile", 0 };


	if(!(edit_seg = alloc_seg(4096)))
		abort("Unable to allocate edit buffer");

	strcpy(ifile, "*");
	if(!getenv("MCDIR", home))
		abort("Environment variable MCDIR is not set!");

	for(i=1; i < argc; ++i) {
		parse_ptr = argv[i];
		switch((toupper(*parse_ptr++) << 8) | toupper(*parse_ptr++)) {
			case 'C=' :
				strcpy(ifile, parse_ptr);
				break;
			default:
				strcpy(filename, argv[i]); } }

	if(read_config(ifile, "$r")) {
		fputs(errmsg || "No config selected", stdout);
		return; }

	twin = wopen(0, 0, 80, 1, WCOPEN|WCCLOSE|(unsigned)Vedt_msg);
	bwin = wopen(0, TSIZE+1, 80, 24-TSIZE, (WCOPEN|WCCLOSE|WSCROLL)|(unsigned)Vbrw_txt);
	wputs("DDSIDE: ?COPY.TXT 1994-2005 Dave Dunfield. **See COPY.TXT**.          F1=Help");
	mwin = wopen(0, 1, 80, TSIZE, (WCOPEN|WCCLOSE|WSCROLL)|(unsigned)Vedt_txt);

	load_edit_file(filename);
	if(*filename == '*')
		strcpy(filename, "NONAME");
top:
	for(;;) {
		edit(-1);
		mflag = 0;
remenu:
		if(mflag)
			goto top;
		wcursor_off();
		title(Vbrw_pop, title_bar);
		switch(i = toupper(dgetc())) {
			case _K1 :		/* Help */
				help(H_IDE);
			case _K8 :		/* Function menu */
				goto remenu;
			case 'C' :		/* Compile menu */
			case _ALT+'C' :
				for(;;) {
					if(wmenu(MCOMPILE, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, stepmenu, &cselect))
						goto remenu;
					mflag = -1;
					switch(cselect) {
						case 0 :
							select_options(MCOMPILE, step_options);
							continue;
						case 1 :
							select_steps();
							continue; }
					break; }
				init_browse_window();
				compile();
				break;
			case 'T' :		/* Target system */
			case _ALT+'T' :
				if(wmenu(MTARGET, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, target_menu, &tselect))
					goto remenu;
				switch(tselect) {
					case 0 :
#ifndef	DEMO
						target();
#else
						errmsg ="Connect not available in DEMO";
#endif
						break;
					case 1 :
						if(simulator) {
							sprintf(parse_buffer, "%s %s", simulator, ofile);
							doshell(parse_buffer);
							break; }
						errmsg = "No simulator defined";
						break;
					case 2 :
						if(debugger) {
							sprintf(parse_buffer, "%s %s", debugger, ofile);
							doshell(parse_buffer);
							break; }
						errmsg = "No debugger defined";
						break;
					case 3 :
						if(loader) {
							sprintf(parse_buffer, "%s %s", loader, ofile);
							doshell(parse_buffer);
							break; }
						errmsg = "No loader defined"; }
				break;
			case 'O' :		/* Options menu */
			case _ALT+'O' :
				mflag = select_options(MOPTION, general_options);
				if(!(tab_size = tab_width = general_options[TAB_SIZE].OPT_value))
					tab_size = tab_width = 1;
				goto remenu;
			case 'F' :		/* File menu */
			case _ALT+'F' :
				goto exmenu;
			case 'K' :		/* Calculator */
			case _ALT+'K' :
				mflag = calc();
				goto remenu;
			case 'A' :		/* Ascii char set */
			case _ALT+'A' :
				mflag = cset();
				goto remenu;
			case 'B' :		/* Browser */
			case _ALT+'B' :
				mflag = browse(-1);
				goto remenu;
			case 'L' :		/* Output log */
			case _ALT+'L' :
				browse_output(-1); } }
exmenu:

	if(wmenu(MFILE, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, file_menu, &fselect))
		goto remenu;
	switch(fselect) {
		case 0 :		/* Open */
			strcpy(ifile, defile);
			if(get_file(ifile, defile) && !check_save())
				load_edit_file(ifile);
			goto top;
		case 1 :		/* Config */
			strcpy(ifile, "*");
			if(!read_config(ifile, "r"))
				(bwin_contents) ? browse(0) : browse_output(0);
			goto top;
		case 2 :		/* Shell */
			doshell(0);
		default:
			goto top;
		case 3 :		/* Quit */
			if(check_save())
				goto top; }

	/* Clear the screen to normal & home cursor before closing */
	*twin = *bwin = *mwin = NORMAL;
	*(int*)(twin+12) = 0;
	W_OPEN = mwin;
	wclose();
	wclose();
	wclose();
}

/*
 * Check to see of the current file needs saveing
 */
check_save()
{
	if(CHANGED) {
		title(Vedt_err, "\007%s has unsaved changes... Save now (Y/N)?", filename);
		for(;;)  switch(toupper(dgetc())) {
			case 'Y' :
				return write_file(filename, EDIT_START, edit_end) ?
					-1 : CHANGED = 0;
			case 'N' :
				return 0;
			case 0x1B:
				return -1;
			case _K1 :
				help(0); } }
	return 0;
}

/*
 * Resize the text windows
 */
resize()
{
	int l;
	title(Vbrw_pop, "Resize: Up/Down = Increase/Decrease, Home/End = Max/Min, ESC = exit");
	l = mwin->WINheight;
	for(;;) {
		switch(dgetc()) {
			case _KUA :
				if(l > 2)
					--l;
				break;
			case _KHO :
				l = 2;
				break;
			case _KEN :
				l = 23;
				break;
			case _KDA :
				if(l < 23)
					++l;
				break;
			case 0x1B :
				return;
			case _K1 :
				help(0); }
		init_browse_window();
		mwin->WINheight = l;
		bwin->WINheight = 24 - l;
		bwin->WINorgy   = l + 1;
		edit(0);
		(bwin_contents) ? browse(0) : browse_output(0); }
}

/*
 * Select the compile steps to be executed
 */
select_steps()
{
	int i, j, k, selects[11];
	char buffer[1024], *list[11], *bptr, *ptr;

	k = 0;
	for(;;) {
		bptr = buffer;
		for(i = j = 0; i < steps; ++i) {
			if(*(ptr = step[i]->STEP_name) != '!') {
				sprintf(list[j] = bptr, "%c %s",
					step_enable[i] ? 0xFB : ' ', ptr);
				selects[j++] = i;
				bptr += strlen(bptr) + 1; } }
		list[j] = 0;
		if(!j)
			return;
		if(wmenu(MCOMPILE, (WSAVE|WCOPEN|WBOX2)|(unsigned)Vbrw_pop, list, &k))
			return;
		i = selects[k];
		step_enable[i] = !step_enable[i]; }
}

/*
 * Present a menu & select options for the compile steps
 */
select_options(int x, int y, struct OPTION *options)
{
	int i, l, lcount, index;
	char buffer[1024], buffer1[60], *list[15], *bptr, *ptr, *ptr1, *tptr,
		mflag;
	struct OPTION *optr;

	if(!step_options)
		return 0;
new_options:
	index = mflag = 0;
loop:
/*	title(Vbrw_pop, "Select options... ESC to exit"); ??? */
	lcount = 0;
	optr = options;
	bptr = buffer;
	while(i = optr->OPT_type) {
		ptr = optr->OPT_text;
		ptr1 = buffer1;
		while((l = *ptr) && (l > 0))
			*ptr1++ = *ptr++;
		*ptr1 = 0;
		switch(i) {
			case OPT_SWITCH :
				sprintf(bptr, "%s: %s", buffer1, optr->OPT_value ? "YES" : "NO ");
				break;
			case OPT_PICK :
				++ptr;
				tptr = ++ptr1;
				for(i = optr->OPT_value; i; --i)
					while(*ptr && (*ptr++ > 0));
				while(*ptr && (*ptr > 0) && (*ptr != '$'))
					*ptr1++ = *ptr++;
				*ptr1 = 0;
				sprintf(bptr, "%s: %s", buffer1, tptr);
				break;
			case OPT_VALUE :
				switch(l & 0x7F) {
					case 0 :	tptr = "%s: %u";	break;
					case 1 :	tptr = "%s: %d";	break;
					default:	tptr = "%s: %s";	}
				sprintf(bptr, tptr, buffer1, optr->OPT_value);
				break;
			default:
				strcpy(bptr, buffer1); }
		list[lcount++] = bptr;
		bptr += (strlen(bptr)+1);
		optr += sizeof(struct OPTION); }
	list[lcount] = 0;

	if(wmenu(x, y, (WSAVE|WCOPEN|WBOX2)|(unsigned)Vbrw_pop, list, &index))
		return mflag;

	mflag = -1;
	optr = options;
	for(i=0; i < index; ++i)
		optr += sizeof(struct OPTION);
	ptr = optr->OPT_text;
	ptr1 = buffer1+3;
	while((l = *ptr++) && (l > 0))
		*ptr1++ = l;
	*ptr1++ = ':';
	*ptr1 = 0;
	switch(optr->OPT_type) {
		case OPT_SWITCH :
			optr->OPT_value = !optr->OPT_value;
			break;
		case OPT_PICK :
			if(++optr->OPT_value >= (l & 0x7F))
				optr->OPT_value = 0;
			break;
		case OPT_VALUE :
			list[0] = (50<<8)|5;
			list[1] = buffer1;
			list[2] = 0;
			buffer1[0] = buffer1[1] = 0x01;
			switch(l &= 0x7F) {
				case 0 :
					buffer1[2] = 0x85;	tptr = &optr->OPT_value;	break;
				case 1 :
					sprintf(buffer,"%d", optr->OPT_value);
					buffer1[2] = 0x05;	tptr = buffer;				break;
				default :
					buffer1[2] = l-1;		tptr = optr->OPT_value;		}
			wform(x, y, (WSAVE|WCOPEN|WBOX2)|(unsigned)Vbrw_pop, list, tptr);
			if(l == 1)
				optr->OPT_value = atoi(buffer);
			break;
		case OPT_CHAIN :
			options = optr->OPT_value;
			goto new_options;
		case OPT_EXEC :
			(*optr->OPT_value)(); }
	goto loop;
}

/*
 * Read an options menu into the memory pool
 */
read_options(FILE *fp)
{
	int i, j, v, ocount;
	char buffer[100], *ptr;
	struct OPTION options[11];
	static char *names[] =
		{ "END", "SWITCH", "PICK", "UNSIGNED", "SIGNED", "TEXT" };

	ocount = 0;
	while(fgets(parse_ptr = buffer, sizeof(buffer)-1, fp)) {
		if(*buffer == '*')
			continue;
		parse(PARSE_SPACE|PARSE_UCASE);
		for(i=0; i < (sizeof(names)/2); ++i)
			if(!strcmp(names[i], parse_buffer))
				goto found;
		sprintf(errmsg = ifile, "\007Unknown option type: %s", parse_buffer);
		return 0;
	found:
		/* Get value operand */
		parse(PARSE_SPACE);
		v = atoi(parse_buffer);
		options[ocount].OPT_type = OPT_VALUE; /* Assume this */
		options[ocount].OPT_text = text_ptr;
		/* Fill in text buffer */
		j = parse(PARSE_BAR);
		strcpy(text_ptr, parse_buffer);
		ptr = (text_ptr += j);
		switch(i) {
			case 0 : goto end;
			case 1 :		/* Switch value */
				options[ocount].OPT_type = OPT_SWITCH;
				*text_ptr++ = 0x80;
				j = parse(PARSE_BAR);
				strcpy(text_ptr, parse_buffer);
				text_ptr += j;
				if(j = parse(0)) {
					*text_ptr++ = 0x80;
					strcpy(text_ptr, parse_buffer);
					text_ptr += j; }
				break;
			case 2 :			/* Pick list */
				options[ocount].OPT_type = OPT_PICK;
				i = 0;
				while(j = parse(PARSE_BAR)) {
					++i;
					*text_ptr++ = 0x80;
					strcpy(text_ptr, parse_buffer);
					text_ptr += j; }
				*ptr = 0x80 + i;
				break;
			case 3 :			/* Unsigned */
				*text_ptr++ = 0x80;
				break;
			case 4 :			/* Signed */
				*text_ptr++ = 0x81;
				break;
			case 5 :			/* Text */
				++text_ptr;
				if(parse(0) >= ++v)
					abort("Not enough room");
				strcpy(i = text_ptr, parse_buffer);
				*ptr = 0x80 + v;
				text_ptr += v;
				v = i; }
		options[ocount].OPT_value = v;
		*text_ptr++ = 0;
		++ocount; }
end:
	options[ocount].OPT_type = 0;
	memcpy(ptr = text_ptr, options, i = (ocount * sizeof(struct OPTION))+1);
	text_ptr += i;
	return ptr;
}

/*
 * Read the configuration file
 */
read_config(char *file, char *options)
{
	int i, j, k, edit_cmd;
	char buffer[201], *ptr;
	FILE *fp;
	struct STEP *sptr;
	static char *names[] = {		/* Config command names */
		"REM", "FILE", "TEMP", "STEP", "OPTION", "KEY", "COLOR",
		"TAB", "TARGET", "SIMULATE", "DEBUG", "LOAD", "SETUP" }
	static char edit_funs[EDITF][4] = {	/* Editor functions */
		"BLI", "FLI", "BCH", "FCH", "BPG", "FPG", "SOL", "EOL",
		"CMD", "REP", "INS", "DEL", "BSD", "ELD", "POS", "TOP",
		"TAG", "DLI", "DLE", "IDL", "FUN", "SOF", "EOF", "BWR",
		"FWR", "HLP", "XXX" };
	static char colors[16][3] = {
		"BK", "BL", "GR", "CY", "RD", "MG", "BR", "WH",
		"GY", "LB", "LG", "LC", "LR", "LM", "YL", "BW" };

	/* Open IDE configuration file */
	sprintf(buffer, "%s.IDE", file);
	if(!(fp = openf(buffer, options))) {
		errmsg = 0;
		sprintf(buffer,"%s\\%s.IDE", home, file);
		if(!(fp = openf(buffer, options))) {
			return -1; } }

	/* Get temporary directory */
	if(!getenv("MCTMP", tmprefix)) {
		if(getenv("TEMP", tmprefix)) {
			if(tmprefix[(i = strlen(tmprefix))-1] != '\\') {
				tmprefix[i] = '\\';
				tmprefix[i+1] = 0; } } }

	text_ptr = text_pool;
	memset(edit_key_cmds,
		simulator = debugger = loader = setup = steps = step_options = edit_cmd = 0,
		sizeof(edit_key_cmds));
	while(fgets(parse_ptr = buffer, sizeof(buffer)-1, fp)) {
		parse(PARSE_SPACE|PARSE_UCASE);
		for(i=0; i < (sizeof(names)/2); ++i)
			if(!strcmp(names[i], parse_buffer))
				goto found;
		sprintf(errmsg = ifile, "\007Unknown config item: %s", parse_buffer);
		return -1;
	found: 	switch(i) {
		case 1 :		/* file */
			parse(0);
			strcpy(defile, parse_buffer);
			if(!*filename)
				strcpy(filename, parse_buffer);
			break;
		case 2 :		/* temp */
			parse(PARSE_SPACE);
			general_options[COMPILE_TEMP].OPT_value = atoi(parse_buffer);
			parse(PARSE_SPACE);
			general_options[KEEP_TEMP].OPT_value = atoi(parse_buffer);
			if(parse(0))
				strcpy(tmprefix, parse_buffer);
			break;
		case 3 :		/* step */
			step_enable[steps] = (skip_blanks() == '-') ? ++parse_ptr, 0 : -1;
			step[steps++] = sptr = text_ptr;
			text_ptr += sizeof(struct STEP);
			sptr->STEP_name = parse_text(PARSE_BAR);
			sptr->STEP_type = parse_text(PARSE_BAR);
			sptr->STEP_command = parse_text(0);
			break;
		case 4 :		/* options */
			if(!(step_options = read_options(fp)))
				return -1;
			break;
		case 5 :		/* keys */
			while(parse(PARSE_BAR|PARSE_UCASE|PARSE_SPACE)) {
				for(i=j=0; i < KEYS; ++i)
					if(!strcmp(parse_buffer, keys[i])) {
						i += 26;
						goto foundkey; }
				if(isalpha(i = parse_buffer[1])) switch(*parse_buffer) {
					case '^' : i -= 'A';				goto foundkey;
					case '!' : i -= 'A' - (26+30);		goto foundkey; }
				sprintf(errmsg = ifile, "\007Invalid key: %s", parse_buffer);
				return -1;
			foundkey:
				if(skip_blanks() == '$') {
					++parse_ptr;
					edit_key_cmds[edit_cmd] = parse_text(PARSE_EDIT|PARSE_SPACE);
					j = edit_cmd++ + EDITF;
					goto foundfun; }
				parse(PARSE_SPACE|PARSE_UCASE);
				for(j=0; j < EDITF; ++j)
					if(!strcmp(parse_buffer, edit_funs[j]))
						goto foundfun;
				sprintf(errmsg = ifile, "\007Invalid edit function: %s", parse_buffer);
				return -1;
			foundfun:
				edit_keys[i] = j | 0x80; }
			break;
		case 6 :		/* colors */
			i = 0;
			ptr = &Vedt_txt;
			while((i < NCOLORS) && parse(PARSE_UCASE|PARSE_BAR)) {
				for(j=0; j < (sizeof(colors)/3); ++j)
					if(!strcmp(parse_buffer, colors[j]))
						goto foundcolor1;
				goto badcolor;
			foundcolor1:
				parse(PARSE_UCASE|PARSE_SPACE);
				for(k=0; k < (sizeof(colors)/3); ++k)
					if(!strcmp(parse_buffer, colors[k]))
						goto foundcolor2;
			badcolor:
				sprintf(errmsg = ifile, "\007Invalid color: %s", parse_buffer);
				return -1;
			foundcolor2:
				*ptr++ = (k<<4) | j; }
			break;
		case 7 :		/* tabsize */
			parse(0);
			if(i = atoi(parse_buffer))
				tab_width = tab_size = general_options[TAB_SIZE].OPT_value = i;
			break;
		case 8 :		/* TARGET */
			parse(PARSE_SPACE);
			general_options[TTY_PORT].OPT_value = atoi(parse_buffer)-1;
			parse(PARSE_SPACE);
			general_options[TTY_SPEED].OPT_value = atoi(parse_buffer);
			parse(PARSE_SPACE);
			general_options[TTY_DELAY].OPT_value = atoi(parse_buffer);
			parse(0);
			general_options[TTY_LINEFEED].OPT_value = atoi(parse_buffer);
			break;
		case 9 :		/* SIMULATE */
			simulator = parse_text(0);
			break;
		case 10	:		/* DEBUG */
			debugger = parse_text(0);
			break;
		case 11	:		/* LOAD */
			loader = parse_text(0);
			break;
		case 12 :
			setup = parse_text(0);
			}
	}
	fclose(fp);
}

/*
 * Perform all steps necessary to compile
 */
compile()
{
	int i, j, k, last;
	char *ptr, tiflag;

	memset(uservar, tiflag = 0, sizeof(uservar));
	strcpy(ifile, filename);
	if(general_options[COMPILE_TEMP].OPT_value) {
		tiflag = -1;
		sprintf(ifile, "%s0.TMP", tmprefix);
		write_file(ifile, EDIT_START, edit_end); }
	else if(CHANGED) {
		write_file(ifile, EDIT_START, edit_end);
		CHANGED = 0; }
	if(setup)
		perform_step(0, setup);
	for(i=last=0; i < steps; ++i)
		if(step_enable[i])
			last = i;
	for(i=j=0; i < steps; ++i) if(step_enable[i]) {
		++j;
		if(i != last)
			sprintf(ofile,"%s%u.%s", tmprefix, j, step[i]->STEP_type);
		else {
			strcpy(ptr = ofile, filename);
			while(*ptr && (*ptr != '.'))
				++ptr;
			*ptr++ = '.';
			strcpy(ptr, step[i]->STEP_type); }
		if(*(ptr = step[i]->STEP_name) == '!')
			++ptr;
		if(k = perform_step(ptr, step[i]->STEP_command)) {
			sprintf(errmsg = parse_buffer, "\007Step '%s' terminated with exit code %d",
				ptr, k & 255);
			break; }
		if(tiflag && !general_options[KEEP_TEMP].OPT_value)
			delete(ifile);
		strcpy(ifile, ofile);
		tiflag = -1; }
	browse_output(0);
}

/*
 * Perform a step
 */
perform_step(char *name, char *ptr)
{
	int i;
	char buffer[200], buffer1[200], *ptr1, *ptr2, *bptr, c, sflag;
	struct OPTION *optr;

/* Scan and insert option strings */
	bptr = buffer;
	while(c = *ptr++) {
		if(c != '$') {
			*bptr++ = c;
			continue; }
		optr = step_options;
		if(!isdigit(*ptr)) {
			*bptr++ = c;
			continue; }
		for(c = (*ptr++ - '0') & 0x7f; c; --c)
			optr += sizeof(struct OPTION);
		ptr1 = optr->OPT_text;
		while((c = *ptr1) && (*ptr1++ > 0));
		switch(optr->OPT_type) {
			case OPT_SWITCH :
				if(!optr->OPT_value)
					while(*ptr1 && (*ptr1++ > 0));
				goto copy_txt;
			case OPT_PICK :
				for(i = optr->OPT_value; i; --i)
					while(*ptr1 && (*ptr1++ > 0));
			copy_txt:
				while(*ptr1 && (*ptr1 > 0))
					*bptr++ = *ptr1++;
				break;
			case OPT_VALUE :
				switch(c & 0x7F) {
					case 0 : ptr2 = "%u";	break;
					case 1 : ptr2 = "%d";	break;
					default: ptr2 = "%s";	}
				sprintf(bptr, ptr2, optr->OPT_value);
				bptr += strlen(bptr); } }
	*bptr = sflag = 0;

/* Scan and insert input/output filenames, etc */
	bptr = buffer1;
	ptr = buffer;
	while(c = *ptr++) {
		if(c == '$') switch(c = *ptr++) {	/* Special character */
			case 'V' :		/* Select I/O from video screen */
				sflag = -1;
				continue;
			case 'Y' :		/* Enable step */
			case 'N' :		/* Disable step */
				if(isdigit(*ptr))
					step_enable[*ptr++ - '0'] = (c == 'Y');
				continue;
			case '\'' :		/* Special string operation */
				ptr1 = ptr;
				while(*ptr) {
					if(*ptr == '\'') {
						*ptr++ = 0;
						break; }
					++ptr; }
				if(isdigit(c = *ptr++)) {			/* If step enabled */
					if(step_enable[c - '0'])
						goto copyall; }
				else switch(c) {
					case 'E' :		/* Environment variable */
						getenv(ptr1, bptr);
						bptr += strlen(bptr);
						break;
					case 'A' :	ptr2 = uservar[0];	goto copyvar;
					case 'B' :	ptr2 = uservar[1];	goto copyvar;
					case 'C' :	ptr2 = uservar[2];	goto copyvar;
					case 'D' :	ptr2 = uservar[3];
					copyvar:
						strcpy(ptr2, ptr1); }
				continue;
			case 'A' :	ptr1 = uservar[0];		goto copyall;
			case 'B' :	ptr1 = uservar[1];		goto copyall;
			case 'C' :	ptr1 = uservar[2];		goto copyall;
			case 'D' :	ptr1 = uservar[3];		goto copyall;
			case 'T' :	ptr1 = tmprefix;		goto copyall;
			case 'H' :	ptr1 = home;			goto copyall;
			case 'I' :	ptr1 = ifile;			goto copyall;
			case 'O' :	ptr1 = ofile;			goto copyall;
			case 'F' :	ptr1 = filename;
			copyall:
				while(*ptr1)
					*bptr++ = *ptr1++;
				continue;
			case 'i' :	ptr1 = ifile;		goto copydot;
			case 'o' :	ptr1 = ofile;		goto copydot;
			case 'f' :	ptr1 = filename;
			copydot:
				while(*ptr1 && (*ptr1 != '.'))
					*bptr++ = *ptr1++;
				continue; }
		*bptr++ = c; }
	*bptr = i = 0;

	if(name) {
		strcpy(buffer, ptr = buffer1);
		buffer[80] = 0;
		title(Vedt_err, general_options[PAUSE_STEP].OPT_value ? buffer : name);
		while(*ptr && !isspace(*ptr))
			++ptr;
		*ptr++ = 0;

		APPindex = APPy = 0;
		if(sflag) {				/* Get output from screen */
			wopen(0, 0, 80, 25, WSAVE|WCOPEN|NORMAL);
			wupdatexy();
			i = exec(buffer1, ptr);
			grab_screen(0, 24);
			wclose(); }
		else {					/* Get output from INT10 */
			grab_int10();
			i = exec(buffer1, ptr);
			release_int10(); }
		APPoutput[APPindex] = 0;
		if(general_options[PAUSE_STEP].OPT_value) {
			if(dgetc() == 0x1B)
				i |= 0xFF00; } }
	return i;
}

/*
 * Grab the output from the screen
 */
grab_screen(unsigned start, unsigned end)
{
	unsigned line, i, j;

	APPindex = APPy = 0;
	while(start < end) {
		line = start++ * 160;
		i = 160;
		do {
			i -= 2;
			if(peek(W_BASE, line+i) != ' ') {
				for(j = 0; j <= i; j += 2)
					APPoutput[APPindex++] = peek(W_BASE, line+j);
				APPoutput[APPindex++] = 0;
				break; } }
		while(i); }
		APPoutput[APPindex] = 0;
}

/*
 * Grab the int 10 vector & get ready for the fun
 */
grab_int10()
{
	w_clwin(bwin);
	asm {
		MOV		AX,3510h		; Get interrupt 10
		INT		21h				; Call DOS
		MOV		CS:int10o,BX	; Save offset
		MOV		CS:int10s,ES	; Save segment
		MOV		AX,2510h		; Set interrupt 10
		MOV		DX,OFFSET int10	; Get offset
		INT		21h				; Set the segment
		MOV		AX,SP			; Get SP
		SUB		AX,1024			; Adjust for boundary
		MOV		CS:Freesp,AX	; Set boundary
	}
}

/*
 * Release the int10 vector
 */
release_int10()
{
	asm	{
		PUSH	DS				; Save DS
		MOV		AX,2510h		; Set interrupt 10
		MOV		DX,CS:int10o	; Get offset
		MOV		DS,CS:int10s	; Get segment
		INT		21h				; Call DOS
		POP		DS				; Restore DS
	}
}

/*
 * Interrupt 10 handler
 */
asm {
Freesp	DW		0				; Free SP for call
Savesp	DW		0				; Place to save SP
Savess	DW		0				; Plave to save SS
int10:	CMP		AH,0Eh			; Write character in TTY
		JZ		int11			; Yes, handle it
		DB		0EAh			; Intersegment jummp
int10o	DW		0				; Offset
int10s	DW		0				; Segment
int11:	CLI						; Inhibit interrupts
		MOV		CS:Savesp,SP	; Save SP
		MOV		CS:Savess,SS	; Save SS
		MOV		SP,CS			; Get CS
		MOV		SS,SP			; Set SS
		MOV		SP,CS:Freesp	; Set nice high SP
		STI
		PUSH	ES				; Save ES
		PUSH	DS				; Save DS
		PUSH	DI				; Save DI
		PUSH	SI				; Save SI
		PUSH	DX				; Save DX
		PUSH	CX				; Save CX
		PUSH	BX				; Save BX
		PUSH	AX				; Save AX
		MOV		AX,CS			; Get CS
		MOV		DS,AX			; Set DS
		CALL	_int10			; Call handler
		POP		AX				; Restore AX
		POP		BX				; Restore BX
		POP		CX				; Restore CX
		POP		DX				; Restore DX
		POP		SI				; Restore SI
		POP		DI				; Restore DI
		POP		DS				; Restore DS
		POP		ES				; Restore ES
		CLI						; Inhibit interrupts
		MOV		SS,CS:Savess	; Restore SS
		MOV		SP,CS:Savesp	; Restore SP
		IRET
}

/*
 * Interrupt 10 handler in 'C'
 */
int10(int ax)
{
	unsigned char c;
	w_putc(c = ax & 255, bwin);
	if(c < ' ') switch(c) {
		default:	return;
		case '\n' :	c = 0;	}

	if(APPindex < (sizeof(APPoutput)-1))
		APPoutput[APPindex++] = c;
}

/*
 * Browse the application output
 */
browse_output(char interactive)
{
	unsigned h, i, j, index[50], icount, height;
	unsigned x, p;

	init_browse_window();
	W_OPEN = bwin;
	wcursor_off();
	height = W_OPEN->WINheight;
	/* Index the output */
	while(APPindex && !APPoutput[APPindex-1])	/* Trim ending lines */
		--APPindex;
	bwin_contents = i = 0;
	while((i < APPindex) && !APPoutput[i])		/* Trim Leading lines */
		++i;
	index[icount=0] = i;
	while(i < APPindex) {
		if(!APPoutput[i++]) {
			index[++icount] = i;
			if(icount >= 49)
				break; } }
	++icount;

clearx:
	x = 0;
update:
	if(interactive)
		title(Vedt_err, "OUTPUT LOG: Line %u of %u", APPy+1, icount);
	for(i=0; i < height; ++i) {
		wgotoxy(h = 0, i);
		if((j = APPy + i) >= icount) {
			*W_OPEN = Vedt_eof;
			wputs("*END OF OUTPUT*");
			*W_OPEN = Vbrw_txt;
			wcleow();
			break; }
		p = index[j];
		for(j=0; j < x; ++j) {
			if(APPoutput[p])
				++p; }
		j = 0;
		while(APPoutput[p]) {
			wputc(APPoutput[p++]);
			if(++j >= 80)
				goto noclear; }
		wcleol();
	noclear: }

	if(!interactive)
		return;
	switch(i = dgetc()) {
		case _KUA :
			if(APPy)
				--APPy;
			goto clearx;
		case _KDA :
			if(APPy < icount)
				++APPy;
			goto clearx;
		case _KPD :
			if((APPy+height) < icount) {
				APPy += height;
				goto clearx; }
		case _CPD :
			APPy = icount;
			goto clearx;
		case _KPU :
			if(APPy > height) {
				APPy -= height;
				goto clearx; }
		case _CPU :
			APPy = 0;
			goto clearx;
		case _KRA :
			++x;
			break;
		case _KLA :
			if(x)
				--x;
			break;
		case _KHO :
			x = 0;
			break;
		case 0x1B:
			return;
		case _K1 :
			help(H_LOG); }
	goto update;
}

/*
 * Execute a sub-shell
 */
doshell(command)
	char *command;
{
	int e;
	char comspec[65], tail[80];

	if(!getenv("COMSPEC", comspec)) {
		errmsg = "\007Cannot locate COMSPEC";
		return; }
	*tail = 0;
	if(command)
		concat(tail, "/C ", command);
	wopen(0, 0, 80, 25, WSAVE|WCOPEN|NORMAL);
	wcursor_line();
	wupdatexy();
	e = exec(comspec, tail);
	wclose();
}

/*
 * Get a filename with a prompt
 */
get_file(char *filename, char *defile)
{
	char fname[65];
	static char *form[] = { 64<<8|3, "\x00\x00\x32Filename:", 0 };
	strcpy(fname, defile);
	if(!wform(7, 10, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop, form, fname)) {
		strcpy(filename, fname);
		return -1; }
	return 0;
}

/*
 * Open a file with options
 */
openf(char *filename, char *options)
{
	int n, p, c, i;
	char *names[100], namebuf[1000], *nptr, *ptr, *ptr1;
	FILE *fp;

	for(ptr = filename; i = *ptr; ++ptr)
		if((i == '*') || (i == '?'))
			break;
	if(i) {
		if(find_first(filename, n = 0, nptr = namebuf, &i, &i, &i, &i, &i)) {
			sprintf(errmsg = parse_buffer, "\007No files matching: '%s'", filename);
			return 0; }
		do {
			for(i=0; i < n; ++i)
				if(strcmp(names[i], nptr) == 1)
					break;
			for(c = ++n; c > i; --c)
				names[c] = names[c-1];
			names[i] = nptr;
			while(*nptr++); }
		while((n < (sizeof(names)/2)) && !find_next(nptr, &i, &i, &i, &i, &i));

		for(i=n; i < (sizeof(names)/2); ++i)
			names[i] = "";

		c = p = 0;
		if((n == 1) && (*options == '$'))
			goto open_file;

		wopen(13, 5, 53, 12, (WSAVE|WCOPEN|WBOX3)|(unsigned)Vbrw_pop);
		wintitle(filename);
		wcursor_off();
		for(;;) {
			for(i=0; i < 40; ++i) {
				wgotoxy((i%4)*13, i/4);
				*W_OPEN = (i == c) ? ((*W_OPEN >> 4)|(*W_OPEN << 4)) : Vbrw_pop;
				wputf(names[i+p], 12); }
			switch(dgetc()) {
				case 0x1B :
					wclose();
					return 0;
				case '\n' :
					wclose();
					goto open_file;
				case _K1 :
					help(0);
					break;
				case _KRA : i = c + 1; goto position;
				case _KLA : i = c - 1; goto position;
				case _KUA : i = c - 4; goto position;
				case _KDA : i = c + 4;
				position:
					if(i < 0) {
						c = 0;
						if((p - 4) >= 0) {
							c = i + 4;
							p -= 4; }
						break; }
					if(i >= 40) {
						if((p + 40) < n) {
							i -= 4;
							p += 4; } }
					c = ((p + i) < n) ? i : (n - p) - 1; } }
open_file:
		ptr = ptr1 = filename;
		while(i = *ptr++) {
			if((i == '\\') || (i == ':'))
				ptr1 = ptr; }
		strcpy(ptr1, names[p+c]); }
	
	if(!options)		/* Solve wildcards only ... don't open */
		return -1;
	if(!(fp = fopen(filename, options)))
		sprintf(errmsg = parse_buffer, "\007Unable to access: '%s'", filename);
	return fp;
}

#ifndef	DEMO
/*
 * Display the target_tty status
 */
static update_status()
{
	W_OPEN = mwin;
	wcursor_line();
	reset_cursor = -1;
	title(errmsg ? Vedt_err : Vedt_eof, "TTY:%s%s %s",
		upl_fp ? " UPL:" : "",
		dnl_fp ? " CAP:" : "",
		errmsg ? errmsg : ofile);
	errmsg = 0;
}

/*
 * Close upload file
 */
close_upload()
{
	if(upl_fp) {
		fclose(upl_fp);
		upl_fp = 0; }
}

/*
 * Close download file
 */
close_download()
{
	if(dnl_fp) {
		fclose(dnl_fp);
		dnl_fp = 0; }
}

/*
 * Communicate with target system
 */
target()
{
	int c;

	mwin[1] = (WCOPEN|WCCLOSE|WSCROLL|WWRAP|WLF)>>8;
	w_clwin(mwin);
	if(Copen(general_options[TTY_PORT].OPT_value+1,
		scale(57600, 2, general_options[TTY_SPEED].OPT_value),
		mode, SET_RTS|SET_DTR|OUTPUT_2)) {
		errmsg = "Can't open COMM port"; }

	update_status();
	for(;;) {
		if((c = Ctestc()) != -1) {
			if(dnl_fp && ((c >= ' ') || (c == '\t') || (c == '\n')))
				putc(c, dnl_fp);
			if(c == '\t') {
				do
					wputc(' ');
				while(W_OPEN->WINcurx % tab_width); }
			else
				wputc(c);
			reset_cursor = -1; }
		else if(reset_cursor) {
			wupdatexy();
			reset_cursor = 0; }
		if(c = getchar()) {
			if(c == 0x1B)
				goto exit;
			if(c < 0) switch(c) {
				case _K1 :
					help(H_TARGET);
					continue;
				case _K2 :		/* exit */
					c = 0x1B;
					break;
				case _K3 :		/* upload */
					if(upl_fp)
						close_upload();
					else if(get_file(ofile, ofile))
						upl_fp = openf(ofile, "r");
					update_status();
					continue;
				case _K4 :		/* Capture */
					if(dnl_fp)
						close_download();
					else if(get_file(dnlfile, dnlfile))
						dnl_fp = openf(dnlfile, "w");
					update_status();
					continue;
				case _K5 :		/* Browse */
					browse(-1);
					goto fixwin;
				case _K6 :		/* Output log */
					browse_output(-1);
					goto fixwin;
				case _K7 :		/* Copy screen to output log */
					grab_screen(1, W_OPEN->WINheight+1);
					browse_output(0);
				fixwin:
					update_status();
					if(W_OPEN->WINcury >= (c = W_OPEN->WINheight))
						wgotoxy(0, c-1);
				default: continue;
				case _KDL :	c = 127; break;
				case _KBS : c = 8; }
			Cputc((c == '\n') ? '\r' : c); } };

/* Clean up before exiting back to editor */
exit:
	close_upload();
	Cclose();
	mwin[1] = (WCOPEN|WCCLOSE|WSCROLL)>>8;
}

/*
 * Get a character from the keyboard
 */
getchar()
{
	int i;
	static int j;
	static unsigned key_delay = 0;

	if(key_delay) {
		--key_delay;
		return 0; }

	if((j == '\n') && general_options[TTY_LINEFEED].OPT_value) {
		Cputc(0x0A);
		j = 0; }

	if(i = wtstc())
		return i;

	if(upl_fp) {
		if((j = getc(upl_fp)) == EOF) {
			close_upload();
			update_status();
			return 0; }
		if((j >= ' ') || (j == '\t') || (j == '\n')) {
			key_delay = general_options[TTY_DELAY].OPT_value;
			return j; } }
	return 0;
}

/*
 * Scale to a fractional value
 */
scale(value, multiply, divide) asm
{
		MOV		AX,8[BP]		; Get value
		MUL		WORD PTR 6[BP]	; Multiply to 32 bit product
		MOV		BX,4[BP]		; Get divisor
		DIV		BX				; Divide back to 16 bit result
		SHR		BX,1			; /2 for test
		INC		DX				; .5 rounds up
		SUB		BX,DX			; Set 'C' if remainder > half
		ADC		AX,0			; Increment result to scale
}
#endif

/*
 * Display a title on a window
 */
wintitle(ptr)
	char *ptr;
{
	char buffer[6];
	memcpy(buffer, W_OPEN, 6);
	W_OPEN[1] &= (~WBOX3 >> 8);
	--W_OPEN[3];
	wgotoxy(0,0);
	wprintf(" %s ", ptr);
	memcpy(W_OPEN, buffer, 6);
}

/*
 * Main calculator program
 */
calc()
{
	char c, flag;

	static int memory = 0;
	static char mode = 0, buffer[7];

	op = acc ? '=' : ' ';		/* Use '=' reset mode if value left over */
	flag = 0;

	wopen(MCALC, 9, 4, (WSAVE|WBOX1|WCOPEN|WSCROLL)|(unsigned)Vbrw_pop);
	wcursor_off();
	for(;;) {
		wprintf(mode ? "\r%c $%04x" : "\r%c%6d", op, acc);
		switch(c = toupper(dgetc())) {
			case '+' :		/* Record all operators */
			case '-' :
			case '*' :
			case '/' :
			case '%' :
			case '&' :
			case '|' :
			case '^' :
			case '<' :
			case '>' :
				doeval();
				wprintf(mode ? "\r  $%04x\n" : "\r %6d\n", acc1);
				acc = 0;
				op = c;
				break;
			case '=' :		/* Display partial result */
				doeval();
				wclwin();
				acc = acc1;
				op = '=';
				break;
			case '\'' :		/* Single ASCII character */
				acc = dgetc();
				break;
			case '"' :		/* Double ASCII character */
				acc = (dgetc() << 8) | dgetc();
				break;
			case _KBS :		/* Delete last entered digit */
				acc /= mode ? 16 : 10;
				break;
			case ' ' :		/* Toggle hex/decmal mode */
				mode = !mode;
				break;
			case '\n' :		/* Exit and enter value */
				doeval();
				sprintf(key_ptr = buffer, mode ? "%x" : "%d", acc = acc1);
				wclose();
				return -1;
			case '\x1B' :	/* Exit and don't enter value */
				doeval();
				acc = acc1;
				wclose();
				return flag;
			case 'K' :		/* Clear the calculator display */
				acc = acc1 = 0;
				op = ' ';
				break;
			case 'S' :		/* Save to memory */
				memory = acc;
				break;
			case 'R' :		/* Restore from memory */
				acc = memory;
				break;
			case _K1 :		/* Help request */
				help(H_CALC);
				break;
			default:
				if(op == '=') {		/* Previous result to clear */
					acc = acc1 = 0;
					op = ' '; }
				if(mode) {				/* Hex input */
					if(isdigit(c))
						acc = (acc * 16) + (c - '0');
					else if((c >= 'A') && (c <= 'F'))
						acc = (acc * 16) + (c - ('A'-10)); }
				else if(isdigit(c))		/* Decimal input */
					acc = (acc * 10) + (c - '0'); }
		flag = -1; }
}

/*
 * Evaluate the last recorded operation
 */
doeval()
{
	switch(op) {
		case '+' : acc1 += acc; break;
		case '-' : acc1 -= acc; break;
		case '*' : acc1 *= acc; break;
		case '/' : if(!acc) goto dbz; acc1 /= acc; break;
		case '%' : if(!acc) goto dbz; acc1 %= acc; break;
		case '&' : acc1 &= acc; break;
		case '|' : acc1 |= acc; break;
		case '^' : acc1 ^= acc; break;
		case '<' : acc1 <<=acc; break;
		case '>' : acc1 >>=acc; break;
		default  : acc1 = acc; break;
		dbz: wprintf("\n? / 0\nError"); dgetc(); }
}

/*
 * Display the IBM PC Character set
 */
cset()
{
	int i, flag;
	static unsigned char start = ' ';

	flag = 0;
	wopen(MASCII, 8, 18, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vbrw_pop);
	wcursor_off();

redraw:
	wgotoxy(0, 0);
	for(i=0; i < 16; ++i) {
		wgotoxy(1, i);
		wprintf("%02x=", (i + start) & 0xFF);
		wputc((i + start) | 0x0100); }
	switch(i = dgetc()) {
		case _KUA : --start;		goto redraw1;
		case _KDA :	++start;		goto redraw1;
		case _KPU :	start -= 16;	goto redraw1;
		case _KPD :	start += 16;	goto redraw1;
		case _KHO :	start = 0;		goto redraw1;
		case _K1  : help(H_ASCII);	goto redraw;
		default:
			if(i >= 0)
				start = i;
		redraw1:
			flag = -1;
			goto redraw;
		case 0x1B : }
	wclose();
	return flag;
}

/*
 * Insure the browser window is re-sized if necessary
 */
init_browse_window()
{
	if(bwin_contents == 15) {
		mwin->WINheight = 20;
		bwin->WINheight = 24 - 20;
		bwin->WINorgy   = 20 + 1;
		bwin_contents = -1; }
}

/*
 * Get a key with macro input
 */
int dgetc()
{
#ifdef	DEMO
#define	SWIDTH	80
	unsigned i, c, s;
	char *ptr;
	static char *text[] = {
	"DDSIDE: Unregistered evaluation copy...",
    "Please contact Dunfield Development Services for ordering information",
	"http://www.dunfield.com   FAX:613-256-5821   "
	};

	if(key_ptr) {
		if(*key_ptr)
			return *key_ptr++;
		key_ptr = 0; }

	wupdatexy();
	for(i=0; i < 300; ++i) {
		if(c = wtstc())
			return c;
		delay(50); }

	wopen((80-SWIDTH)/2, 0, SWIDTH, 1, WSAVE|WCOPEN|REVERSE);
	wcursor_off();
	s = -1;
	for(;;) {
		ptr = text[++s % (sizeof(text)/2)];
		i = SWIDTH;
		do {
			if(c = wtstc())
				goto exit;
			wgotoxy(--i, 0);
			wputf(ptr, SWIDTH-i);
			delay(100); }
		while(i);
		do {
			if(c = wtstc())
				goto exit;
			wgotoxy(0, 0);
			wputf(++ptr, SWIDTH);
			delay(100); }
		while(*ptr); }
exit:
	wclose();
	return c;
#else
	if(key_ptr) {
		if(*key_ptr)
			return *key_ptr++;
		key_ptr = 0; }

	return wgetc();
#endif
}
