#include <stdio.h>
#include <window.h>

/* General parameters */
#define	LINK_S		('N'-0x40)		/* Start of a link */
#define	LINK_E		('O'-0x40)		/* End of a link */
#define	USER_CODE	('Q'-0x40)		/* User supplied */
#define	TAB_SIZE	4				/* Spacing of TABs */

/* Video attributes */
#define	TEXT_N		REVERSE			/* Normal text */
#define	TEXT_H		0x71			/* Hypertext link */
#define	TEXT_S		0x17			/* Selected link */

char help[] = { "\n\
~ 1.0 - DDS help file viewer - Dave Dunfield - "#__DATE__"\n\n\
Use: ~ <help-file-name>\n\
\nAvailable help files are:\n" };

/*
 * Help commnd - Implements "hypertext" screens
 */
main(int argc, char *argv[])
{
	int c, lx, ly, ox, oy;
	unsigned i, j, section, size, ncount;
	unsigned char buffer[65], *ptr, *p;
	unsigned char xs[50], ys[50], names[50][25], link[50];
	FILE *fp;

	ptr = i = argv[0];
	p = 0;
	while(*ptr) switch(*ptr++) {
		case '.' : p = ptr-1;	continue;
		case ':' :
		case '\\': i = ptr; }

	if(argc < 2) {
		if(p)
			*p = 0;
		concat(buffer, argv[0], ".HLP");
		if(fp = fopen(buffer, "rb"))
			goto go;
		ptr = help;
		for(;;) switch(c = *ptr++) {
			case 0 :
				if(find_first("*.HLP", 0, xs, &j, &j, &j, &j, &j))
					printf("None! - Make sure you are positioned to the product directory.\n");
				else do {
					p = xs;
					while(*p) {
						if(*p == '.')
							*p = 0;
						++p; }
					printf("   %s\n", xs); }
				while(!find_next(xs, &j, &j, &j, &j, &j));
				return;
			case '~' : fputs(i, stdout); continue;
			default: putc(c, stdout); } }

	p = buffer; ptr = argv[1]; i = 0;
	for(;;) switch(*p++ = *ptr++) {
		case 0 : goto en;
		case ':' :
		case '\\': i = 0;	continue;
		case '.' : i = 255; }
en:	if(!i)
		strcpy(p-1, ".HLP");

	fp = fopen(buffer, "rvqb");
go:
	section = 0;

	/* Locate the section in question */
lookup:
	size = getc(fp);
	size |= getc(fp) << 8;
	if(section--) {
		fseek(fp, 0, size, 1);
		goto lookup; }

	/* Draw the screen */
	wopen(5, 4, 70, 17, WSAVE|WCOPEN|WBOX1|TEXT_N);
	wcursor_off();
	i = ncount = ptr = 0;
	while(buffer[i++] = getc(fp));
	wintitle(buffer);
	wgotoxy(0, 0);
	while(i++ < size) switch(c = getc(fp)) {
		case LINK_S :	/* Start link */
			ptr = names[ncount];
			xs[ncount] = W_OPEN->WINcurx;
			ys[ncount] = W_OPEN->WINcury;
			*W_OPEN = TEXT_H;
			break;
		case LINK_E :	/* End link */
			link[ncount++] = getc(fp);
			*ptr = ptr = 0;
			*W_OPEN = TEXT_N;
		extra:
			++i;
			break;
		case USER_CODE:	/* User supplied */
			wprintf("<%03u>", getc(fp));
			goto extra;
		case '\t' :		/* Horizontal TAB */
			do
				wputc(' ');
			while(W_OPEN->WINcurx % TAB_SIZE);
			break;
		case 0 :
			c = '\n';
		default:
			wputc(c);
			if(ptr)
				*ptr++ = c; }

	/* Allow user to select field & link to new screen */
	i = section = 0;
	for(;;) {
		wgotoxy(xs[section], ys[section]);
		*W_OPEN = TEXT_H;
		wputs(names[section]);
		wgotoxy(xs[i], ys[i]);
		*W_OPEN = TEXT_S;
		wputs(names[section = i]);
		*W_OPEN = TEXT_N;
		switch(c = wgetc()) {		/* User keystroke */
			case _KLA :				/* Left arrow - previous field */
				i = (i ? i : ncount) - 1;
				break;
			case _KRA :				/* Right arrow - next field */
				i = (i + 1) % ncount;
				break;
			case _KUA : ox = oy = -1000; goto dofind;
			case _KDA : ox = oy = 1000;
			dofind:
				size = i;
				for(j = 0; j < ncount; ++j) {
					lx = (int)xs[j] - (int)xs[i];
					ly = (int)ys[j] - (int)ys[i];
					if(c == _KUA) {
						if((ly >= 0) || (ly < oy)) continue; }
					else {
						if((ly <= 0) || (ly > oy))	continue; }
					if(abs(lx) > abs(ox)) continue;
					size = j;
					ox = lx;
					oy = ly; }
				i = size;
				break;
			case '\n' :				/* Enter - chain to menu */
				rewind(fp);
				section = link[i];
				wclose();
				goto lookup;
			case 0x1B:				/* Escape exit */
				wclose();
				fclose(fp);
				return; } }
}

/*
 * Display a title on a window
 */
wintitle(ptr)
	char *ptr;
{	char buffer[6];
	memcpy(buffer, W_OPEN, 6);
	W_OPEN[1] &= (~WBOX3 >> 8);
	--W_OPEN[3];
	wgotoxy(0,0);
	wprintf(" %s ", ptr);
	memcpy(W_OPEN, buffer, 6);
}
