#include <stdio.h>
#include <window.h>

/* General parameters */
#define	LINK_S		('N'-0x40)		/* Start of a link */
#define	LINK_E		('O'-0x40)		/* End of a link */
#define	USER_CODE	('Q'-0x40)		/* User code */

#define	TAB_SIZE	4				/* Spacing of TABs */
#define	LINKS		25				/* Maximum # links per screen */

extern char home[], *errmsg;
extern unsigned char Vhlp_txt, Vhlp_lnk;

/*
 * Help commnd - Implements "hypertext" screens
 */
help(unsigned section)
{
	int c, lx, ly, ox, oy;
	unsigned i, j, size, ncount;
	unsigned char buffer[65], *ptr;
	unsigned char xs[LINKS], ys[LINKS], names[LINKS][25], link[LINKS];
	FILE *fp;

	concat(buffer, home, "\\DDSIDE.HLP");
	if(!(fp = fopen(buffer, "rb"))) {
		errmsg = "Cannot open help file";
		return; }

	/* Locate the section in question */
lookup:
	size = getc(fp);
	size |= getc(fp) << 8;
	if(section--) {
		fseek(fp, 0, size, 1);
		goto lookup; }

	/* Draw the screen */
	wopen(5, 4, 70, 17, (WSAVE|WCOPEN|WBOX1)|(unsigned)Vhlp_txt);
	wcursor_off();
	i = ncount = ptr = 0;
	while(buffer[i++] = getc(fp));
	wintitle(buffer);
	wgotoxy(0, 0);
	while(i++ < size) switch(c = getc(fp)) {
		case LINK_S :	/* Start link */
			ptr = names[ncount];
			xs[ncount] = W_OPEN->WINcurx;
			ys[ncount] = W_OPEN->WINcury;
			*W_OPEN = Vhlp_lnk;
			break;
		case LINK_E :	/* End link */
			link[ncount++] = getc(fp);
			*ptr = ptr = 0;
			*W_OPEN = Vhlp_txt;
#ifndef USER_CODE
			++i;
			break;
#else
		extra:
			++i;
			break;
		case USER_CODE:	/* User control code */
			user_help(getc(fp));
			goto extra;
#endif
		case '\t' :		/* Horizontal TAB */
			do
				wputc(' ');
			while(W_OPEN->WINcurx % TAB_SIZE);
			break;
		case 0 :
			c = '\n';
		default:
			wputc(c);
			if(ptr)
				*ptr++ = c; }

	/* Allow user to select field & link to new screen */
	i = section = 0;
	for(;;) {
		wgotoxy(xs[section], ys[section]);
		*W_OPEN = Vhlp_lnk;
		wputs(names[section]);
		wgotoxy(xs[i], ys[i]);
		*W_OPEN = (Vhlp_lnk << 4) | (Vhlp_lnk >> 4);
		wputs(names[section = i]);
		*W_OPEN = Vhlp_txt;
		switch(c = dgetc()) {		/* User keystroke */
			case _KLA :				/* Left arrow - previous field */
				i = (i ? i : ncount) - 1;
				break;
			case _KRA :				/* Right arrow - next field */
				i = (i + 1) % ncount;
				break;
			case _KUA : ox = oy = -1000; goto dofind;
			case _KDA : ox = oy = 1000;
			dofind:
				size = i;
				for(j = 0; j < ncount; ++j) {
					lx = (int)xs[j] - (int)xs[i];
					ly = (int)ys[j] - (int)ys[i];
					if(c == _KUA) {
						if((ly >= 0) || (ly < oy)) continue; }
					else {
						if((ly <= 0) || (ly > oy))	continue; }
					if(abs(lx) > abs(ox)) continue;
					size = j;
					ox = lx;
					oy = ly; }
				i = size;
				break;
			case '\n' :				/* Enter - chain to menu */
				rewind(fp);
				section = link[i];
				wclose();
				goto lookup;
			case 0x1B:				/* Escape exit */
				wclose();
				fclose(fp);
				return; } }
}

extern unsigned char edit_keys[30+26+26], keys[30][4];

/*
 * User supplied output function
 */
user_help(int code)
{
	int i, j;
	code += 0x80;
	for(i = j = 0; i < sizeof(edit_keys); ++i)
		if(edit_keys[i] == code) {
			if(i < 26)
				wprintf("^%c  ", i+'A');
			else if(i > (26+30))
				wprintf("!%c  ", i + ('A'-(26+30)) );
			else
				wprintf("%-4s", keys[i-26]);
			if(++j > 2)
				return; }
	while(++j < 4)
		wputs("    ");
}
